/******************************************************************************/
/* DD for SAMSON Positioner 373x-3 EXPERT+ HART capable                       */
/******************************************************************************/
/* SAMSON AG Mess- und Regeltechnik                                           */
/* Weismuellerstrasse 3                                                       */
/* 60314 Frankfurt                                                            */
/* Germany                                                                    */
/* Tel.: (++49) 69 4009 0     Fax: (++49) 69 4009 1507                        */
/* Internet: http://www.samson.de                                             */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2007). All Rights Reserved                       */
/* Device:        SAMSON Positioner 373x-3 HART capable EXPERT+  from FW 1.40 */
/******************************************************************************/
/* Autor: Thomas Kraemer / E42                                                */
/* Datei: SAHA_373X_3_rev4.ddl                                                */
/******************************************************************************/
/* Datum:     Autor:  Aenderungen:                                            */
/* ------     ------  ------------                                            */
/* 03.03.2003 Kmr/E42 Erste Version.                                          */
/*                    HART 6 Befehle 20,22,31,71,72,76 sind durch die Befehle */
/*                    143-146 und Erweiterung der Befehle 128-131 ersetzt     */
/*                    worden, da noch nicht von Handheld/AMS unterstuetzt.    */
/* 27.03.2003 Kmr/E42 x_begrenzung_oben/unten und w_ma_bereich_anfang/ende:   */
/*                     Parametername fuer Handheld korrigiert.                */
/*                    Fehler 76 (Keine Notlaufeigenschaft) implementiert:     */
/*                     Parameter xmtr_specific_status_3 erweitert             */
/*                    Fehler 77 (Programmladefehler) implementiert:           */
/*                     Parameter xmtr_specific_status_3 erweitert             */
/*                    final_assembly_number: Label geaendert.                 */
/*                    Alle nicht benoetigten Bits mit dummy-Texten vorbelegt, */
/*                     damit bei Erweiterungen keine undef. Meldungen (cmd48):*/
/*                     xmtr_specific_status_3:  Bit 0x10 ... 0x80             */
/*                     xmtr_specific_status_4:  Bit 0x02 ... 0x80             */
/*                     xmtr_specific_status_5:  Bit 0x04 ... 0x80             */
/*                     xmtr_specific_status_6:  Bit 0x04                      */
/*                     xmtr_specific_status_7:  Bit 0x08; 0x20 ... 0x80       */
/*                     xmtr_specific_status_8:  Bit 0x08; 0x20 ... 0x80       */
/*                    Texte geaendert:                                        */
/*                     alt: 'Ausgang Split-Range'; neu: 'Fhrungsgre %'     */
/* 28.03.2003 Kmr/E42 #define AMS_APPLICATION eingefuehrt                     */
/*                     (Unterschied: cmd 128 und 130 sind bei AMS wegen       */
/*                      Kommunikationsproblemen gekuerzt auf jeweils 2 Werte  */
/*                      zum Lesen !)                                          */
/* 28.04.2003 Kmr/E42 Parameter 'zertifizierung': Index geaendert/hinzugef.,  */
/*                     Hilfetext korrigiert, in Verzeichnis angezeigt.        */
/*                    Cmd 128 und 130 sind jetzt auf 4 x denselben Wert       */
/*                     Lesen eingestellt. Jetzt keine Warning beim Tokenizen. */
/*                     (mit #define AMS_APPLICATION)                          */
/*                    Parameter Alarmmodus: Texte der combobox geaendert.     */
/*                    Abhaengigkeit vom Magnetventil entfernt:                */
/*                     Parameter xmtr_specific_status_0                       */
/*                    Parameter 175 eingefuehrt. Wird mit cmd 130 eingelesen. */
/*                    Parameter 337 (status_init): combobox-Text geaendert    */
/*                    Parameter 7 (Initialisierungsart) hat anderen HART-     */
/*                     Befehl und kein NP mehr in der combobox.               */
/*                    Gewuenschter Nennbereich (Parameter 6) wird jetzt       */
/*                     immer ins Geraet geschrieben.                          */
/*                    Blockierstellung Maximalwerte geaendert                 */
/*                    x_bereich_anfang Maximalwerte geaendert                 */
/*                    x_bereich_ende Minimal-/Maximalwerte geaendert          */
/*                    Bereich von w_ma_bereich_anfang/ende begrenzt           */
/*                    w_hand: MAX_VALUE ist jetzt variabel.                   */
/*                    Parameter 18 und 20: Hilfe geaendert und abhaengig.     */
/* 13.05.2003 Kmr/E42 Kp und Tv: sind jetzt nur lesbar; Hilfetexte geaendert. */
/*                    Textaenderung: 'Target mode' statt 'Required mode'      */
/*                                  'Actual mode' statt 'Current mode'        */
/*                    Hilfetexte der einzelnen Statusbits fuer AMS eingefuegt.*/
/*                    Einige weitere Parameterbez./Texte fuer AMS geaendert.  */
/*                    Methoden write_target_mode und write_w_manual erstellt. */
/*                    Dateiname geaendert von Sn3730.ddl in SAM373X.ddl.      */
/* 27.05.2003 Kmr/E42 Text fuer 'Req. nom. range' fuer Handheld/AMS gekrzt.  */
/* 18.06.2003 Kmr/E42 Texte bzgl. Kaltstart/cold start korrigiert.            */
/*                    Methodentexte fuer 'Abort zero point adjustment' und    */
/*                    'Position transmitter test' geaendert.                  */
/*                    Methode 'write_target_mode' geaendert: Akt. Betriebsart */
/*                    wird jetzt angezeigt.                                   */
/*                    Parameter stellungsmelder und ind_grenzkontakt sind     */
/*                    jetzt nur noch lesbar.                                  */
/* 02.07.2003 Kmr/E42 Stiftposition: Indices bei Abhaengigkeiten geaendert.   */
/*                                                                            */
/* 11.01.2006 Kmr/E42 - Erstellung der DD fuer 373X-3 EXPERT+ ab FW 1.40      */
/*                    - Aenderungen fuer Lauffaehigkeit unter HCF DD-IDE.     */
/*                    - Parameter fuer EXPERT+ hinzugefuegt (include-Datei    */
/*                    SAM373X_EP.ddl; entspr. Befehle in SAM373X_EP_CMD.ddl). */
/*                    - Deutsche Texte auskommentiert wegen Tokenizer         */
/*                    Beschraenkung.                                          */
/*                    - Parameter 'zertifizierung' geaendert.                 */
/*                    - Info: nicht alle Texte ins Deutsche uebersetzt !      */
/*                    - Umschaltung zwischen EXPERT und EXPERT+ implementiert */
/*                                                                            */
/* 28.04.2006 Kmr/E82 Auftrennung in reine PDM-DD. Dateien umbenannt.         */
/*                    - Update-Methoden fuer Testergebnisse geschrieben.      */
/*                    - #define AMS_APPLICATION geloescht, da DD nur fuer PDM */
/*                    - Messwerte Datenlogger, Sprungantwort und stat. KL     */
/*                      werden per Methode (Button) eingelesen da mit         */
/*                      blichen commands zu langsam.                         */
/* 06.06.2006 Kmr/E82 - Device Revision 5: Unterstuetzung fuer PST Regler.    */
/*                    - Neuen Parameter 'Verhalten bei Pistenausfall'         */
/*                    eingefhrt (nur fuer EXPERT +/++, nicht PST)            */
/* 18.04.2007 Kmr/E82 - Text PST statt ESD gendert.                          */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* ACHTUNG:                                                                   */
/******************************************************************************/
/*                                                                            */
/* Nur definieren wenn deutsche und englische Hilfe verwendet werden soll:    */
/*  (Nur Standard Parameter ohne EXPERT+ Parameter !                          */
/*   Sonst wird nur die englische Hilfe verwendet)                            */
#define HELP_DE_EN
/******************************************************************************/
/*                                                                            */
/* Nur definieren wenn Hilfetexte der EXPERT+ Parameter erwuenscht sind:      */
/*  (nur in deutsch und englisch)                                             */
#define HELP_EP_DE_EN
/******************************************************************************/
/*                                                                            */
/* Nur definieren wenn deutsche und englische Labeltexte und combobox Texte   */
/*  der Parameter erwuenscht sind, sonst nur englisch:                        */
#define LABEL_DE_EN
/******************************************************************************/

MANUFACTURER	     66,   /* SAMSON AG, Frankfurt, Germany  */
DEVICE_TYPE		    239,   /* Positioner 373X-3 HART capable */
DEVICE_REVISION     5,   /* Device Revision 5 (EXPERT/EXPERT+/PST FW from 1.42) */
DD_REVISION         1    /* Device Description Revision 1  */

/* ------------------------------------------------------------------------ */
/* Defines                                                                  */
/* ------------------------------------------------------------------------ */
#define DEV_STATUS_SIZE    33   /* cmd 48 hat 31+2 Bytes */
#define DEVICE_BUSY         8

#define UNLOCKING_DEVICE    0
#define LOCKING_DEVICE      1

#define NOT_IMPLEMENTED     0
#define IMPLEMENTED         1

#define DIAG_LEVEL_EXPERT            0
#define DIAG_LEVEL_EXPERT_PLUS       1
#define DIAG_LEVEL_EXPERT_PLUS_PLUS  2
#define DIAG_LEVEL_PST               3

/* Parameter Aktuelle Betriebsart */
#define AKT_BA_INBETRIEBNAHME      0
#define AKT_BA_INIT                1
#define AKT_BA_AUTO_REGELUNG       2
#define AKT_BA_AUTO_STEUERUNG      3
#define AKT_BA_HAND_IP             4
#define AKT_BA_HAND_W              5
#define AKT_BA_HAND_W_STEUERUNG    6
#define AKT_BA_SICHERHEIT          7
#define AKT_BA_TEST_MODUS          8
#define AKT_BA_ENTW_MODUS          9
#define AKT_BA_HART_REGELUNG      10
#define AKT_BA_HART_STEUERUNG     11

/* Sonstiges */
#define PRIMARY		   0
#define SECONDARY	   1
#define TERTIARY	   2
#define FOURTH		   3

#define INIT_ART_MAX   0
#define INIT_ART_NOM   1
#define INIT_ART_MAN   2
#define INIT_ART_SUB   3

/* ------------------------------------------------------------------------ */
/* 'int wrProt' muss in der verwendeten Methode definiert sein ! */
#define CHECK_WRITE_PROTECTION                                \
        iassign(static_enums_code1, 93);                      \
        send_command(130); /* HART-Schreibschutz auslesen */  \
        wrProt = ivar_value (hart_schreibschutz);             \
        if (wrProt == 1)                                      \
        {   /* HART-Schreibschutz ist aktiv */                \
            ACKNOWLEDGE("Device is write protected"           \
                        "|de|Gert ist schreibgeschtzt");    \
            process_abort();  /* Methode beenden */           \
        }


/* ------------------------------------------------------------------------ */
/* 'int akt_BA' muss in der verwendeten Methode definiert sein ! */
#define CHECK_ACT_MODE                                        \
        iassign(static_enums_code1, 86);                      \
        send_command(130); /* akt. Betriebsart auslesen */    \
        akt_BA = ivar_value (akt_betriebsart);                \
        if (akt_BA == 7) /* wenn Sicherheitsstellung */       \
        {   /* Sicherheitsstellung ist aktiv */               \
            ACKNOWLEDGE("Fail-safe position is active"        \
                        "|de|Sicherheitsstellung ist aktiv"); \
            process_abort();  /* Methode beenden */           \
        }

/* ------------------------------------------------------------------------ */
/* nur sichtbar wenn Diagnose-Level EXPERT+ aber kein PST enthaelt */

/* Umschaltung zwischen EXPERT und EXPERT+ Parameter */
#define VALIDITY_ONLY_EXPERT_PLUS_NO_PST                 \
  VALIDITY                                               \
    IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) || \
        ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ))   \
    { TRUE; }                                            \
    ELSE                                                 \
    { FALSE; }

/* ------------------------------------------------------------------------ */
/* nur sichtbar wenn Diagnose-Level EXPERT+ oder PST enthaelt */

/* Umschaltung zwischen EXPERT und EXPERT+ Parameter */
#define VALIDITY_ONLY_EXPERT_PLUS                        \
  VALIDITY                                               \
    IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) || \
        ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) || \
        ( diag_level == DIAG_LEVEL_PST              ))   \
    { TRUE; }                                            \
    ELSE                                                 \
    { FALSE; }

/* ------------------------------------------------------------------------ */
/* nur sichtbar wenn Diagnose-Level PST enthaelt */

/* Umschaltung auf PST Parameter */
#define VALIDITY_ONLY_PST                                \
  VALIDITY                                               \
    IF ( diag_level == DIAG_LEVEL_PST )                  \
    { TRUE; }                                            \
    ELSE                                                 \
    { FALSE; }


/*****************************************************************************/
/* fr Methode method_PDM_StandardDiagnosis: */
#define PDM_DIAG_FAULT                0x0001
#define PDM_DIAG_MAINT_REQUIRED       0x0002
#define PDM_DIAG_MAINT_RECOMMENDED    0x0004
#define PDM_DIAG_PROCESS_ERROR				0x0010
#define PDM_DIAG_CONFIG_ERROR				  0x0020
#define PDM_DIAG_SIMULATION					  0x0040
#define PDM_DIAG_GOOD						      0x0008
/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS   0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS                0xFFF7  /* Lsche GOOD */
/*****************************************************************************/


/* fr Methode methodOpenDeviceManual_3730_PST: PST EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3730_PST "e83881en.pdf"     \
                                        "|de|e83881de.pdf"

/* fr Methode methodOpenDeviceManual_3730: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3730 "e83843en.pdf"        \
                                    "|de|e83843de.pdf"    \
                                    "|fr|e83843fr.pdf"    \
                                    "|it|e83843it.pdf"    \
                                    "|nl|e83843nl.pdf"    \
                                    "|ru|e83843ru.pdf"    \
                                    "|zh|e83843zh.pdf"

/* fr Methode methodOpenDeviceManual_3731: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3731 "e83873en.pdf"        \
                                    "|de|e83873de.pdf"    \
                                    "|it|e83873it.pdf"    \
                                    "|ru|e83873ru.pdf"

/* fr Methode methodOpenValveDiagnostics: Ventildiagnose Doku im pdf-Format */
#define VALVE_DIAGNOSTICS_FILENAME "e83880en.pdf"         \
                                   "|de|e83880de.pdf"


/* ------------------------------------------------------------------------ */
/* Includes                                                                 */
/* ------------------------------------------------------------------------ */
#include "macros.h"
#include "methods.h"

/* EXPERT+ Parameter */
#include "SAHA_373X_3_rev5_EP.ddl"
/* HART Befehle EXPERT+ Parameter */
#include "SAHA_373X_3_rev5_EP_CMD.ddl"

#include "Diagnosis.inc"


/* ------------------------------------------------------------------------ */
/* Parameter-Definitionen                                                   */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Importierte Parameter                                                    */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Common Tables                                                            */
/* ------------------------------------------------------------------------ */
IMPORT STANDARD _TABLES, DEVICE_REVISION 11, DD_REVISION 1
{
	EVERYTHING;
}

/* ------------------------------------------------------------------------ */
/* Universals (Parameter and commands)                                      */
/* ------------------------------------------------------------------------ */
IMPORT STANDARD _UNIVERSAL, DEVICE_REVISION 5, DD_REVISION 1
{
    EVERYTHING;

  /* Redefinitionen ------------------------------------------------------- */
  REDEFINITIONS
  {
    /* kmr: wegen Fehlermeldung umdefiniert: */
    /* the transaction will need to be redefine to show the correct */
    /* number of variables returned in this command */
    COMMAND read_dynamic_variables_and_pv_current
    {
        REDEFINE TRANSACTION
        {
            REQUEST
            {}

            REPLY
            {
                response_code, device_status,
                PV.ANALOG_VALUE, PV.DIGITAL_UNITS, PV.DIGITAL_VALUE
            }
        }
    }

    /* Wegen Warnmeldung vom Tokenizer umdefiniert */
	VARIABLE response_code
	{
      /* alt: CLASS USER_INTERFACE & DIAGNOSTIC; */
      REDEFINE CLASS DEVICE & DIAGNOSTIC;
	}

    /* Wegen Bezeichnung fuer Kaltstart umdefiniert */
	VARIABLE device_status
	{
      REDEFINE LABEL	[device_status] ;
      REDEFINE HELP     [field_device_status_help];
      REDEFINE HANDLING READ;

      REDEFINE TYPE BIT_ENUMERATED
      {
    	{ 0x01, [PV_out_of_limits],	                       DV1 (AUTO & BAD)          },
    	{ 0x02, [Non_PV_out_of_limits],                    DV2 (AUTO & BAD)          },
    	{ 0x04, [PV_analog_output_saturated],              AO1 (AUTO & BAD)          },
    	{ 0x08, [PV_analog_output_fixed],                  AO1 (MANUAL & GOOD)       },
    	{ 0x10, [more_status_available],                   MORE                      },
    	{ 0x20, "Restart executed" "|de|Neustart ausgef.", MISC                      },
    	{ 0x40, [configuration_changed],                   MISC & IGNORE_IN_HANDHELD },
    	{ 0x80, [device_malfunction],	                   MORE                      }
      }
	}

/* ------------------------------------------------------------------------ */
/* Parameter: ---                          Doku-Nummer: ---     EB-Code: -- */
/*   (aehnlich: Parameter: geraetetyp      Doku-Nummer: 148     EB-Code: -- */
/* ------------------------------------------------------------------------ */
    VARIABLE device_type
    {
      #ifdef LABEL_DE_EN
      REDEFINE LABEL "Positioner type no." "|de|Typ-Nr. Regler";
      #else
      REDEFINE LABEL "Positioner type no.";
      #endif

      REDEFINE TYPE ENUMERATED
      {
        { 0xf9,  "3780"   },
        { 0xef,  "373X-3" }
      }
      #ifdef HELP_DE_EN
      REDEFINE HELP "Type number of the positioner."
                    "|de|Typnummer des Stellungsreglers.";
      #else
      REDEFINE HELP "Type number of the positioner.";
      #endif
    }

/* ------------------------------------------------------------------------ */
/* Parameter: TAG                          Doku-Nummer: 102/312 EB-Code: -- */
/* ------------------------------------------------------------------------ */
	VARIABLE tag
	{
      REDEFINE LABEL "TAG";

      #ifdef HELP_DE_EN
      REDEFINE HELP  "Tag identification number of the operation unit."
                     "|de|Messstellen - Kennzeichen der Betriebseinheit.";
      #else
      REDEFINE HELP  "Tag identification number of the operation unit.";
      #endif
	}

/* ------------------------------------------------------------------------ */
/* Parameter: Serien-Nr.                   Doku-Nummer: 106     EB-Code: -- */
/* ------------------------------------------------------------------------ */
	VARIABLE device_id
	{
      #ifdef LABEL_DE_EN
      REDEFINE LABEL "Serial number positioner" "|de|Serien-Nummer Regler";
      #else
      REDEFINE LABEL "Serial number positioner";
      #endif

      #ifdef HELP_DE_EN
      REDEFINE HELP "Serial number of the positioner."
                    "|de|Serien-Nummer des Stellungsreglers.";
      #else
      REDEFINE HELP "Serial number of the positioner.";
      #endif
	}

/* ------------------------------------------------------------------------ */
/* Parameter: Beschreibung                 Doku-Nummer: 313   EB-Code: --   */
/* ------------------------------------------------------------------------ */
	VARIABLE descriptor
	{
      #ifdef LABEL_DE_EN
      REDEFINE LABEL "Description" "|de|Beschreibung";
      #else
      REDEFINE LABEL "Description";
      #endif

      #ifdef HELP_DE_EN
      REDEFINE HELP  "Free available space for entering text."
                     "|de|Frei verfgbares Textfeld.";
      #else
      REDEFINE HELP  "Free available space for entering text.";
      #endif
	}

/* ------------------------------------------------------------------------ */
/* Parameter: Nachricht                    Doku-Nummer: 314   EB-Code: --   */
/* ------------------------------------------------------------------------ */
	VARIABLE message
	{
      #ifdef LABEL_DE_EN
      REDEFINE LABEL "Message" "|de|Nachricht";
      #else
      REDEFINE LABEL "Message";
      #endif

      #ifdef HELP_DE_EN
      REDEFINE HELP  "Free available space for entering text."
                     "|de|Frei verfgbares Textfeld.";
      #else
      REDEFINE HELP  "Free available space for entering text.";
      #endif
	}

/* ------------------------------------------------------------------------ */
/* Parameter: Final assembly number        Doku-Nummer: 322   EB-Code: --   */
/* ------------------------------------------------------------------------ */
    VARIABLE final_assembly_number
    {
      #ifdef LABEL_DE_EN
      REDEFINE LABEL "Final assembly number" "|de|Werknummer";
      #else
      REDEFINE LABEL "Final assembly number";
      #endif
    }

/* ------------------------------------------------------------------------ */
/* Parameter: Busadresse                   Doku-Nummer: 300   EB-Code: 46   */
/* ------------------------------------------------------------------------ */
    VARIABLE polling_address
    {
      #ifdef LABEL_DE_EN
      REDEFINE LABEL "Bus address" "|de|Busadresse";
      #else
      REDEFINE LABEL "Bus address";
      #endif

      REDEFINE TYPE UNSIGNED_INTEGER (1)
      {
          DISPLAY_FORMAT "2d";
          EDIT_FORMAT    "2d";

          MIN_VALUE  0;
          MAX_VALUE 15;   /* HART 5 */
/*          MAX_VALUE 63;*/   /* HART 6 */
      }

/* kmr: fuer HART 6:
      REDEFINE HELP "Address used to identify a field device. "
                    "Changeable by the user under menu "
                    "entry 'Device-Addressing ...': "
                    "0 for point-to-point, 1 to 63 for multidrop "
                    "communication."
                    "|de|Adresse zur eindeutigen Identifizierung "
                    "des Feldgertes, vom Anwender nderbar unter dem "
                    "Menpunkt 'Gert-Adressierung ...': "
                    "0 fr Punkt-zu-Punkt, 1 bis 63 fr Multidrop.";
*/

/* kmr: fuer HART 5: */
      #ifdef HELP_DE_EN
      REDEFINE HELP "Address used to identify a field device. "
                    "Changeable by the user under menu "
                    "entry 'Device-Addressing ...': "
                    "0 for point-to-point, 1 to 15 for multidrop "
                    "communication."
                    "|de|Adresse zur eindeutigen Identifizierung "
                    "des Feldgertes, vom Anwender nderbar unter dem "
                    "Menpunkt 'Gert-Adressierung ...': "
                    "0 fr Punkt-zu-Punkt, 1 bis 15 fr Multidrop.";
      #else
      REDEFINE HELP "Address used to identify a field device. "
                    "Changeable by the user under menu "
                    "entry 'Device-Addressing ...': "
                    "0 for point-to-point, 1 to 15 for multidrop "
                    "communication.";
      #endif
    }
/* ------------------------------------------------------------------------ */

  }
}

/* ------------------------------------------------------------------------ */
/* Command 143      Lesen des Long-TAG */
/* ------------------------------------------------------------------------ */
COMMAND read_long_tag
{
  NUMBER 143;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
	  long_tag
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS, [no_command_specific_errors];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 144       Schreiben des Long-TAG (fuer HART 5) */
/* ------------------------------------------------------------------------ */
COMMAND write_long_tag
{
  NUMBER 144;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  long_tag
    }

    REPLY
	{
	  response_code, device_status,
	  long_tag
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS,    [no_command_specific_errors];
    5, MISC_ERROR, [too_few_data_bytes_recieved];
    7, MODE_ERROR, [in_write_protect_mode];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 145   Aktionen im Stellungsregler starten (HART 5) */
/* ------------------------------------------------------------------------ */
COMMAND write_start_actions
{
  NUMBER 145;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      start_action
    }

    REPLY
	{
	  response_code, device_status,
      start_action
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 1,	MISC_ERROR,         [cal_failed]; /* NP- oder Init.-fehler */
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	 6, MISC_ERROR,         [xmtr_specific_command_error];
     7, MODE_ERROR,         [in_write_protect_mode];
	16, MODE_ERROR,         [access_restricted];
  }
}

VARIABLE start_action
{
  LABEL "Start action";
  CLASS DEVICE;
  HANDLING WRITE;
  TYPE ENUMERATED
  {
      {   2, "" },
      {   3, "" },
      {   4, "" },
      { 100, "" },
      { 101, "" },
      { 102, "" },
      { 103, "" },
      { 104, "" },
      { 105, "" },
      { 119, "" },
      { 120, "" },
      { 121, "" },
      { 122, "" },
      { 123, "" },
      { 124, "" },
      { 125, "" },
      { 126, "" },
      { 127, "" },
      { 128, "" },
      { 129, "" },
      { 130, "" },
      { 131, "" },
      { 132, "" },
      { 133, "" },
      { 134, "" },
      { 135, "" },
      { 136, "" },
      { 137, "" },
      { 138, "" },
      { 139, "" },
      { 140, "" },
      { 141, "" },
      { 142, "" },
      { 143, "" },
      { 144, "" }
/*
      {   2, "x" "|de|Start_Init" },
      {   3, "x" "|de|Nullpkt_Init" },
      {   4, "x" "|de|Squawk" },
      { 100, "x" "|de|Stoerm_Test" },
      { 101, "x" "|de|GW1_Test" },
      { 102, "x" "|de|GW2_Test" },
      { 103, "x" "|de|Kennl_transfer_start" },
      { 104, "x" "|de|Kennl_transfer_ende" },
      { 105, "x" "|de|Kaltstart" },
      { 119, "x" "|de|Reset_Wegint" },
      { 120, "x" "|de|Reset_XFehler" },
      { 121, "x" "|de|Reset_DXFehler" },
      { 122, "x" "|de|Reset_AnbauFehler" },
      { 123, "x" "|de|Reset_InitZeitFehler" },
      { 124, "x" "|de|Reset_MGVFehler" },
      { 125, "x" "|de|Reset_Laufz_Fehler" },
      { 126, "x" "|de|Reset_StiftPos_Fehler" },
      { 127, "x" "|de|Reset_Regelkr_Fehler" },
      { 128, "x" "|de|Reset_Nullpkt_Fehler" },
      { 129, "x" "|de|Reset_Autokorrektur_Fehler" },
      { 130, "x" "|de|Reset_Fataler_Fehler" },
      { 131, "x" "|de|Reset_XSignal_Fehler" },
      { 132, "x" "|de|Reset_WzuKlein_Fehler" },
      { 133, "x" "|de|Reset_IP_Fehler" },
      { 134, "x" "|de|Reset_Hardware_Fehler" },
      { 135, "x" "|de|Reset_Datensp_Fehler" },
      { 136, "x" "|de|Reset_Kontrr_Fehler" },
      { 137, "x" "|de|Reset_Regelparam_Fehler" },
      { 138, "x" "|de|Reset_Poti_Param" },
      { 139, "x" "|de|Reset_Abgleich_Fehler" },
      { 140, "x" "|de|Reset_Allg_Param_Fehler" },
      { 141, "x" "|de|Reset_Startup_Param_Fehler" },
      { 142, "x" "|de|Reset_kein_produk_Fehler" },
      { 143, "x" "|de|Reset_HART_Param_Fehler" },
      { 144, "x" "|de|Reset_Kaltstart_Flag" } */
  }
}

/* ------------------------------------------------------------------------ */
/* Command 146   Aktionen im Stellungsregler abbrechen (HART 5) */
/* ------------------------------------------------------------------------ */
COMMAND abort_actions
{
  NUMBER 146;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      abort_action
    }

    REPLY
	{
	  response_code, device_status,
      abort_action
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
     7, MODE_ERROR,         [in_write_protect_mode];
	16, MODE_ERROR,         [access_restricted];
  }
}

VARIABLE abort_action
{
  #ifdef LABEL_DE_EN
  LABEL "Abort action" "|de|Aktion abbrechen";
  #else
  LABEL "Abort action";
  #endif

  CLASS DEVICE;
  HANDLING WRITE;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      {   2, "Abort initialization" "|de|Abbruch Initialisierung"   },
      {   3, "Abort ZP adjustment"  "|de|Abbruch Nullpunktabgleich" }
  #else
      {   2, "Abort initialization" },
      {   3, "Abort ZP adjustment"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Aborts the running calibration sequence."
       "|de|Abbrechen der laufenden Kalibrierungs-Sequenz.";
  #else
  HELP "Aborts the running calibration sequence.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Command 137 Read Trend-Values
     Sammel-Command um viele Werte zu erhalten (z.B. fuer Trend-Fenster) */
/* ------------------------------------------------------------------------ */
COMMAND read_trend_values
{
  NUMBER 137;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
	  w_prozent,         /* Byte 0-3 Fuehrungsgre in % */
	  regelgroesse,      /* Byte 4-7 Regelgre in %    */
	  dummy_enum,        /* Byte  8  'Regelkreis gestrt'- Fehler */
	  dummy_enum,        /* Byte  9  Nullpunktfehler */
	  status_init_piste  /* Byte 10  Status der Initialisierung und der Piste */
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS, [no_command_specific_errors];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 141 Read Info_Firmware
     Lesen der Firmware-Versionsnummer. */
/* ------------------------------------------------------------------------ */
COMMAND read_info_firmware
{
  NUMBER 141;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
	  firmware_version
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS, [no_command_specific_errors];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 147   Antriebswirkflaeche lesen (HART 5)                         */
/* ------------------------------------------------------------------------ */
COMMAND read_antriebswirkflaeche
{
  NUMBER 147;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}

    REPLY
	{
	  response_code, device_status,
      antriebswirkflaeche
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 148   Antriebswirkflaeche schreiben (HART 5)                     */
/* ------------------------------------------------------------------------ */
COMMAND write_antriebswirkflaeche
{
  NUMBER 148;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      antriebswirkflaeche
	}

    REPLY
	{
	  response_code, device_status,
      antriebswirkflaeche
	}
  }

  RESPONSE_CODES
  {
	 0, SUCCESS,            [no_command_specific_errors];
     3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
     7, MODE_ERROR,         [in_write_protect_mode];
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter mit EB-Code                                                    */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Gewuenschte Betriebsart     Doku-Nummer: 1/350  EB-Code: 0    */
/* ------------------------------------------------------------------------ */
VARIABLE gew_betriebsart
{
  #ifdef LABEL_DE_EN
  LABEL "Target mode" "|de|Gewnschte Betriebsart";
  #else
  LABEL "Target mode";
  #endif

  CLASS DEVICE;
  HANDLING WRITE;

  TYPE ENUMERATED
  {

  /* Wenn PST Regler */
  IF ( diag_level == DIAG_LEVEL_PST )
  {
  #ifdef LABEL_DE_EN
      {  0, "Automatic"           "|de|Automatik"           },
      { 32, "Manual"              "|de|Hand"                },
      { 16, "Fail-safe position"  "|de|Sicherheitsstellung" },
      { 66, "PST"                 "|de|PST"                 }
  #else
      {  0, "Automatic"           },
      { 32, "Manual"              },
      { 16, "Fail-safe position"  },
      { 66, "PST" }
  #endif
  }
  ELSE
  {
  #ifdef LABEL_DE_EN
      {  0, "Automatic"          "|de|Automatik"           },
      { 32, "Manual"             "|de|Hand"                },
      { 16, "Fail-safe position" "|de|Sicherheitsstellung" }
  #else
      {  0, "Automatic"          },
      { 32, "Manual"             },
      { 16, "Fail-safe position" }
  #endif
  }

  }

  #ifdef HELP_DE_EN
  HELP "Selection of the required operating mode."
	   "|de|Auswahl der gewnschten Betriebsart. "
       "Umschaltung von Automatik auf Hand erfolgt druckstossfrei.";
  #else
  HELP "Selection of the required operating mode.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Handsollwert w               Doku-Nummer: 2     EB-Code: 1    */
/* ------------------------------------------------------------------------ */
VARIABLE w_hand
{
  #ifdef LABEL_DE_EN
  LABEL "Manual reference variable w" "|de|Hand Fhrungsgre w";
  #else
  LABEL "Manual reference variable w" ;
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE    0.0;
      MAX_VALUE  140.0;

/* wegen Methode write_w_manual nicht erlaubt: */
#ifdef wegen_methode_nicht
      MAX_VALUE
        SELECT (geraet_ini)
        {
          CASE 0:  100.0; /* nicht initialisiert */
          CASE 1:  140.0; /* initialisiert */
          DEFAULT: 100.0;
        }
#endif

  }

  CONSTANT_UNIT "%";

  /* nur sichtbar wenn die aktuelle Betriebsart = HAND (es gibt 3 Arten) */
  VALIDITY
    IF ((akt_betriebsart == 4)  ||
        (akt_betriebsart == 5)  ||
        (akt_betriebsart == 6))
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Adjust the manual setpoint in the manual mode."
       "|de|Einstellung des Hand-Sollwertes in der Betriebsart Hand.";
  #else
  HELP "Adjust the manual setpoint in the manual mode.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Leserichtung                 Doku-Nummer: 3     EB-Code: 2    */
/* ------------------------------------------------------------------------ */
VARIABLE leserichtung
{
  #ifdef LABEL_DE_EN
  LABEL "Reading direction" "|de|Leserichtung";
  #else
  LABEL "Reading direction" ;
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      { 0, "Pneumatic connection right" "|de|Pneumatik-Anschluss rechts" },
      { 1, "Pneumatic connection left"  "|de|Pneumatik-Anschluss links"  }
  #else
      { 0, "Pneumatic connection right" },
      { 1, "Pneumatic connection left"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "The reading direction of the LC display at the device is turned by 180."
       "|de|Die Leserichtung der LC-Anzeige am Gert wird um 180 gedreht.";
  #else
  HELP "The reading direction of the LC display at the device is turned by 180.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stiftposition                Doku-Nummer: 5/352  EB-Code: 4   */
/* ------------------------------------------------------------------------ */
VARIABLE stiftposition
{
  #ifdef LABEL_DE_EN
  LABEL "Pin position" "|de|Stiftposition";
  #else
  LABEL "Pin position" ;
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      { 0, "Off"    "|de|Aus"    },
  #else
      { 0, "Off"                 },
  #endif
      { 1, "17 mm"  "|de|17 mm"  },
      { 2, "25 mm"  "|de|25 mm"  },
      { 3, "35 mm"  "|de|35 mm"  },
      { 4, "50 mm"  "|de|50 mm"  },
      { 5, "70 mm"  "|de|70 mm"  },
      { 6, "100 mm" "|de|100 mm" },
      { 8, "200 mm" "|de|200 mm" },
      { 9, "90 "   "|de|90 "   }
  }

  #ifdef HELP_DE_EN
  HELP "The adjusted pin position is displayed, or the pin position can be "
       "selected. It must match the actual position in the lever."
       "|de|Der Abtaststift muss je nach Ventilhub/-winkel in die richtige "
       "Stiftposition eingesetzt werden. Fr die Initialisierung unter "
       "NOM oder SUB muss diese Stiftposition eingegeben werden.";
  #else
  HELP "The adjusted pin position is displayed, or the pin position can be "
       "selected. It must match the actual position in the lever.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Gew./Erm. Nennbereich        Doku-Nummer: 6/54  EB-Code: 5    */
/* ------------------------------------------------------------------------ */
VARIABLE nennbereich
{
  LABEL
    IF (geraet_ini == 1) /* wenn Regler initialisiert: andere Label */
    {
    #ifdef LABEL_DE_EN
      "Determined nominal range" "|de|Ermittelter Nennbereich";
    #else
      "Determined nominal range" ;
    #endif
    }
    ELSE /* wenn Regler nicht initialisiert: andere Label */
    {
    #ifdef LABEL_DE_EN
      "Required nominal range" "|de|Gewnschter Nennbereich";
    #else
      "Required nominal range" ;
    #endif
    }

  CLASS DEVICE;
  HANDLING  READ&WRITE; /* bei HART immer schreibbar */
  TYPE FLOAT
  {
    DISPLAY_FORMAT "5.1f";
    EDIT_FORMAT    "5.1f";

    /* Min.- und Max.-Grenze von der Stiftposition abhaengig */
    MIN_VALUE
      SELECT (stiftposition)
      {
        CASE 0:   20.0;
        CASE 1:    3.6;
        CASE 2:    5.0;
        CASE 3:    7.0;
        CASE 4:   10.0;
        CASE 5:   14.0;
        CASE 6:   20.0;
        CASE 8:   40.0;
        CASE 9:   24.0;
        DEFAULT:  20.0;
      }

    MAX_VALUE
      SELECT (stiftposition)
      {
        CASE 0:  100.0;
        CASE 1:   17.7;
        CASE 2:   25.0;
        CASE 3:   35.4;
        CASE 4:   50.0;
        CASE 5:   70.7;
        CASE 6:  100.0;
        CASE 8:  200.0;
        CASE 9:  110.0;
        DEFAULT: 100.0;
      }
  }

  /* wenn Stiftposition = 9 (90) dann Einheit = , sonst mm */
  CONSTANT_UNIT
    IF (stiftposition == 9)
    { ""; }
    ELSE
    { "mm"; }

  /* wenn Stiftposition = 0 (AUS) dann nicht sichtbar */
  VALIDITY
    IF (stiftposition == 0)
    { FALSE; }
    ELSE
    { TRUE; }

  /* Hilfetexte fuer den ermittelten UND den gewnschten Nennbereich ! */
  #ifdef HELP_DE_EN
  HELP "The nominal travel/angle must be entered prior to initialization "
       "(initialization mode NOM or SUB). "
       "The achieved travel/angle is displayed after successful initialization."
       "|de|Fr die Initialisierung unter NOM oder SUB muss der "
       "Nennhub/-winkel des Ventiles eingegeben werden. "
       "Nach erfolgreicher Initialisierung wird hier der Hub/Winkel angezeigt, "
       "der bei der Initialisierung erreicht worden ist.";
  #else
  HELP "The nominal travel/angle must be entered prior to initialization "
       "(initialization mode NOM or SUB). "
       "The achieved travel/angle is displayed after successful initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Initialisierungsart          Doku-Nummer: 7     EB-Code: 6    */
/* ------------------------------------------------------------------------ */
VARIABLE initialisierungsart
{
  #ifdef LABEL_DE_EN
  LABEL "Initialization mode" "|de|Initialisierungsart";
  #else
  LABEL "Initialization mode" ;
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  INIT_ART_MAX;
  #ifdef LABEL_DE_EN
      { INIT_ART_MAX, "Maximum range"     "|de|Maximalbereich"  },
      { INIT_ART_NOM, "Nominal range"     "|de|Nennbereich"     },
      { INIT_ART_MAN, "Manual adjustment" "|de|Handeinstellung" },
      { INIT_ART_SUB, "Substitute"        "|de|Ersetzung"       }
  #else
      { INIT_ART_MAX, "Maximum range"     },
      { INIT_ART_NOM, "Nominal range"     },
      { INIT_ART_MAN, "Manual adjustment" },
      { INIT_ART_SUB, "Substitute"        }
  #endif
  }

   #ifdef HELP_DE_EN
   HELP "Selection of the initialization mode. "
       "Determines the function of the INIT key at the device, too."
       "|de|Auswahl der Initialisierungsart. "
       "Bestimmt auch die Funktion der INIT-Taste am Gert.";
   #else
   HELP "Selection of the initialization mode. "
       "Determines the function of the INIT key at the device, too.";
   #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Bewegungsrichtung            Doku-Nummer: 8/347  EB-Code: 7   */
/* ------------------------------------------------------------------------ */
VARIABLE bewegungsrichtung
{
  #ifdef LABEL_DE_EN
  LABEL "Moving direction" "|de|Bewegungsrichtung";
  #else
  LABEL "Moving direction";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 1, "Increasing/increasing >>" "|de|Steigend/steigend >>" },
      { 0, "Increasing/decreasing <>" "|de|Steigend/fallend <>"  }
  #else
      { 1, "Increasing/increasing >>" },
      { 0, "Increasing/decreasing <>" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Operating direction of the reference variable w towards "
       "the travel/angle x."
       "|de|Bewegungsrichtung der Fhrungsgre w zum Hub/Drehwinkel x.";
  #else
  HELP "Operating direction of the reference variable w towards "
       "the travel/angle x.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehw.-bereich Anfang   Doku-Nummer: 9     EB-Code: 8    */
/* ------------------------------------------------------------------------ */
VARIABLE x_bereich_anfang
{
  #ifdef LABEL_DE_EN
  LABEL "Travel/angle range start" "|de|Hub-/Drehwinkelbereich Anfang";
  #else
  LABEL "Travel/angle range start" ;
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  0.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      /* Max.-Grenze von der Stiftposition abhaengig */
      MAX_VALUE
        SELECT (stiftposition)
        {
          CASE 0:   80.0;
          CASE 1:   14.2;
          CASE 2:   20.0;
          CASE 3:   28.3;
          CASE 4:   40.0;
          CASE 5:   56.6;
          CASE 6:   80.0;
          CASE 8:  160.0;
          CASE 9:   88.0;
          DEFAULT:  80.0;
        }
  }
  /* Einheit von Stiftposition abhaengig */
  CONSTANT_UNIT
      SELECT (stiftposition)
      {
        CASE 0:    "%";
        CASE 1:   "mm";
        CASE 2:   "mm";
        CASE 3:   "mm";
        CASE 4:   "mm";
        CASE 5:   "mm";
        CASE 6:   "mm";
        CASE 8:   "mm";
        CASE 9:    "";
        DEFAULT:   "%";
      }

  #ifdef HELP_DE_EN
  HELP "Lower range value for the travel/angle in the nominal or working range."
       "|de|Anfangswert fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
  #else
  HELP "Lower range value for the travel/angle in the nominal or working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbereich Ende  Doku-Nummer: 10    EB-Code: 9    */
/* ------------------------------------------------------------------------ */
VARIABLE x_bereich_ende
{
  #ifdef LABEL_DE_EN
  LABEL "Travel/angle range end" "|de|Hub-/Drehwinkelbereich Ende";
  #else
  LABEL "Travel/angle range end";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  100.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      /* Min.- und Max.-Grenzen von der Stiftposition abhaengig */
      MIN_VALUE
        SELECT (stiftposition)
        {
          CASE 0:   20.0;
          CASE 1:    0.7;
          CASE 2:    1.0;
          CASE 3:    1.4;
          CASE 4:    2.0;
          CASE 5:    2.8;
          CASE 6:    4.0;
          CASE 8:    8.0;
          CASE 9:    4.8;
          DEFAULT:  20.0;
        }

      MAX_VALUE
        SELECT (stiftposition)
        {
          CASE 0:  100.0;
          CASE 1:   17.7;
          CASE 2:   25.0;
          CASE 3:   35.4;
          CASE 4:   50.0;
          CASE 5:   70.7;
          CASE 6:  100.0;
          CASE 8:  200.0;
          CASE 9:  110.0;
          DEFAULT: 100.0;
        }
  }
  /* Einheit von Stiftposition abhaengig */
  CONSTANT_UNIT
      SELECT (stiftposition)
      {
        CASE 0:    "%";
        CASE 1:   "mm";
        CASE 2:   "mm";
        CASE 3:   "mm";
        CASE 4:   "mm";
        CASE 5:   "mm";
        CASE 6:   "mm";
        CASE 8:   "mm";
        CASE 9:    "";
        DEFAULT:   "%";
      }

  #ifdef HELP_DE_EN
  HELP "Upper range value for the travel/angle in the nominal or working range."
       "|de|Endwert fr den Hub-/Drehwinkel im Nenn- bzw. Arbeitsbereich.";
  #else
  HELP "Upper range value for the travel/angle in the nominal or working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Hub-/Drehwinkelbegrenzung unten                   */
/*                                         Doku-Nummer: 11    EB-Code: 10   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_x_begrenzung_unten
{
  #ifdef LABEL_DE_EN
  LABEL "Enable travel/angle lower limit"
        "|de|Aktivierung Hub-/Drehwinkelbegrenzung unten";
  #else
  LABEL "Enable travel/angle lower limit";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  #else
      { 0, "Off" },
      { 1, "On"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Enables the limitation of the travel/angle downwards to the entered value."
       "|de|Aktivierung der Begrenzung des Hubes/Drehwinkels nach unten.";
  #else
  HELP "Enables the limitation of the travel/angle downwards to the entered value.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbegrenzung unten Doku-Nummer: 12   EB-Code: 10 */
/* ------------------------------------------------------------------------ */
VARIABLE x_begrenzung_unten
{
  #ifdef LABEL_DE_EN
  LABEL "Travel/angle lower limit" "|de|Hub-/Drehwinkelbegrenzung unten";
  #else
  LABEL "Travel/angle lower limit";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  0.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.0;
      MAX_VALUE 49.9;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "Limitation of the travel/angle downwards to the entered value."
       "|de|Begrenzung des Hubes/Drehwinkels nach unten auf den "
       "eingegebenen Wert, die Kennlinie wird nicht angepasst.";
  #else
  HELP "Limitation of the travel/angle downwards to the entered value.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Hub-/Drehwinkelbegrenzung oben
                                           Doku-Nummer: 13    EB-Code: 11   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_x_begrenzung_oben
{
  #ifdef LABEL_DE_EN
  LABEL "Enable travel/angle upper limit"
        "|de|Aktivierung Hub-/Drehwinkelbegrenzung oben";
  #else
  LABEL "Enable travel/angle upper limit";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  #else
      { 0, "Off" },
      { 1, "On"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Enables the limitation of the travel/angle upwards to the entered value."
       "|de|Aktivierung der Begrenzung des Hubes/Drehwinkels nach oben.";
  #else
  HELP "Enables the limitation of the travel/angle upwards to the entered value.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Hub-/Drehwinkelbegrenzung oben   Doku-Nummer: 14  EB-Code: 11 */
/* ------------------------------------------------------------------------ */
VARIABLE x_begrenzung_oben
{
  #ifdef LABEL_DE_EN
  LABEL "Travel/angle upper limit" "|de|Hub-/Drehwinkelbegrenzung oben";
  #else
  LABEL "Travel/angle upper limit" ;
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  100.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE  50.0;
      MAX_VALUE 120.9;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "Limitation of the travel/angle upwards to the entered value."
       "|de|Begrenzung des Hubes/Drehwinkels nach oben auf den "
       "eingegebenen Wert, die Kennlinie wird nicht angepasst.";
  #else
  HELP "Limitation of the travel/angle upwards to the entered value.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Endlage bei w <  Doku-Nummer: 17    EB-Code: 14   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_endlage_w_kleiner
{
  #ifdef LABEL_DE_EN
  LABEL "Enable setpoint cutoff decrease"
        "|de|Aktivierung Endlage bei w kleiner";
  #else
  LABEL "Enable setpoint cutoff decrease";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  #else
      { 0, "Off" },
      { 1, "On"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Enables the setpoint cutoff decrease function."
       "|de|Aktivierung der Endlagenfunktion bei w kleiner.";
  #else
  HELP "Enables the setpoint cutoff decrease function.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Endlage bei w <              Doku-Nummer: 18    EB-Code: 14   */
/* ------------------------------------------------------------------------ */
VARIABLE endlage_w_kleiner
{
  #ifdef LABEL_DE_EN
  LABEL "Setpoint cutoff decrease" "|de|Endlage bei w kleiner";
  #else
  LABEL "Setpoint cutoff decrease";
  #endif
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  1.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.0;
      MAX_VALUE 49.9;
  }
  CONSTANT_UNIT "%";

  HELP
    SELECT (bewegungsrichtung)
    {
      CASE 1: /* steigend/steigend */
  #ifdef HELP_DE_EN
        "If w falls below the entered value, the valve is fully closed."
        "|de|Unterschreitet w diesen Wert, wird der Antrieb voll geschlossen.";
  #else
        "If w falls below the entered value, the valve is fully closed.";
  #endif
      CASE 0: /* steigend/fallend  */
  #ifdef HELP_DE_EN
        "If w exceeds the value of (100-entered value), the valve is fully closed."
        "|de|berschreitet w den Wert von (100-Wert), wird der Antrieb voll geschlossen.";
  #else
        "If w exceeds the value of (100-entered value), the valve is fully closed.";
  #endif
    }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Endlage bei w >  Doku-Nummer: 19    EB-Code: 15   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_endlage_w_groesser
{
  #ifdef LABEL_DE_EN
  LABEL "Enable setpoint cutoff increase"
        "|de|Aktivierung Endlage bei w grer";
  #else
  LABEL "Enable setpoint cutoff increase";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  #else
      { 0, "Off" },
      { 1, "On"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Enables the setpoint cutoff increase function."
       "|de|Aktivierung der Endlagenfunktion bei w grer.";
  #else
  HELP "Enables the setpoint cutoff increase function.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Endlage bei w >              Doku-Nummer: 20    EB-Code: 15   */
/* ------------------------------------------------------------------------ */
VARIABLE endlage_w_groesser
{
  #ifdef LABEL_DE_EN
  LABEL "Setpoint cutoff increase" "|de|Endlage bei w grer";
  #else
  LABEL "Setpoint cutoff increase";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  100.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE  50.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  HELP
    SELECT (bewegungsrichtung)
    {
      CASE 1: /* steigend/steigend */
  #ifdef HELP_DE_EN
        "If w exceeds the entered value, the valve is fully opened."
        "|de|berschreitet w diesen Wert, wird der Antrieb voll geffnet.";
  #else
        "If w exceeds the entered value, the valve is fully opened.";
  #endif
      CASE 0: /* steigend/fallend  */
  #ifdef HELP_DE_EN
        "If w falls below the value of (100-entered value), the valve is fully opened."
        "|de|Unterschreitet w den Wert von (100-Wert), wird der Antrieb voll geffnet.";
  #else
        "If w falls below the value of (100-entered value), the valve is fully opened.";
  #endif
    }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Druckgrenze                  Doku-Nummer: 21    EB-Code: 16   */
/* ------------------------------------------------------------------------ */
VARIABLE druckgrenze
{
  #ifdef LABEL_DE_EN
  LABEL "Pressure limit" "|de|Druckgrenze";
  #else
  LABEL "Pressure limit";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  3;
  #ifdef LABEL_DE_EN
      { 3, "Off"     "|de|Aus"     },
  #else
      { 3, "Off" },
  #endif
      { 2, "3.7 bar" "|de|3.7 bar" },
      { 1, "2.4 bar" "|de|2.4 bar" },
      { 0, "1.4 bar" "|de|1.4 bar" }
  }

  #ifdef HELP_DE_EN
  HELP "The pressure limit determined during initialization is "
       "displayed and can be modified."
       "|de|Die whrend der Initialisierung ermittelte Druckbegrenzung "
       "wird angezeigt und kann gendert werden.";
  #else
  HELP "The pressure limit determined during initialization is "
       "displayed and can be modified.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Prop.-faktor KP (Stufe)      Doku-Nummer: 22    EB-Code: 17   */
/* ------------------------------------------------------------------------ */
VARIABLE kp_stufe
{
  #ifdef LABEL_DE_EN
  LABEL "Proportional action coeff. KP (step)"
        "|de|Proportionalittsfaktor KP (Stufe)";
  #else
  LABEL "Proportional action coeff. KP (step)";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE UNSIGNED_INTEGER (1)
  {
    DISPLAY_FORMAT  "2d";
    EDIT_FORMAT     "2d";

    MIN_VALUE  0;
    MAX_VALUE 17;
  }

  #ifdef HELP_DE_EN
  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for impermissible high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization."
       "|de|Bei der Initialisierung des Stellungsreglers werden die Werte fr "
       "KP und TV optimal eingestellt. Sollte der Regler aufgrund zustzlicher "
       "Strungen zu unzulssig hohen Nachschwingungen neigen, knnen "
       "KP und TV vor Ort angepasst werden.";
  #else
  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for impermissible high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Vorhaltezeit TV (Stufe)      Doku-Nummer: 23    EB-Code: 18   */
/* ------------------------------------------------------------------------ */
VARIABLE tv_stufe
{
  #ifdef LABEL_DE_EN
  LABEL "Derivative action time TV (step)" "|de|Vorhaltezeit TV (Stufe)";
  #else
  LABEL "Derivative action time TV (step)";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
  #else
      { 0, "Off" },
  #endif
      { 1, "1"   "|de|1"   },
      { 2, "2"   "|de|2"   },
      { 3, "3"   "|de|3"   },
      { 4, "4"   "|de|4"   }
  }

  #ifdef HELP_DE_EN
  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for impermissible high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization."
       "|de|Bei der Initialisierung des Stellungsreglers werden die Werte fr "
       "KP und TV optimal eingestellt. Sollte der Regler aufgrund zustzlicher "
       "Strungen zu unzulssig hohen Nachschwingungen neigen, knnen "
       "KP und TV vor Ort angepasst werden.";
  #else
  HELP "During the initialization of the positioner, KP and TV values are optimized. "
       "Should the positioner show a tendency for impermissible high post-pulse "
       "oscillation due to additional interference, KP and TV can be "
       "adapted on-site after the initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Toleranzband                 Doku-Nummer: 24    EB-Code: 19   */
/* ------------------------------------------------------------------------ */
VARIABLE toleranzband
{
  #ifdef LABEL_DE_EN
  LABEL "Tolerance band" "|de|Toleranzband";
  #else
  LABEL "Tolerance band";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   5.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  0.1;
      MAX_VALUE 10.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "Used for error monitoring. Determination of the tolerance band in "
       "relation to the working range."
       "|de|Toleranzband bezogen auf den Arbeitsbereich. "
       "Zugehrige Nachlaufzeit ist Rcksetzkriterium. "
       "Wird whrend der Initialisierung eine Laufzeit festgestellt, "
       "deren 6 faches > 30s ist, wird die sechsfache Laufzeit als "
       "Nachlaufzeit bernommen.";
  #else
  HELP "Used for error monitoring. Determination of the tolerance band in "
       "relation to the working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinienauswahl            Doku-Nummer: 25/351  EB-Code: 20 */
/* ------------------------------------------------------------------------ */
VARIABLE kennlinienauswahl
{
  #ifdef LABEL_DE_EN
  LABEL "Characteristic" "|de|Kennlinienauswahl";
  #else
  LABEL "Characteristic";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      {  0, "Linear"                                "|de|Linear"                             },
      {  1, "Equal percentage"                      "|de|Gleichprozentig"                    },
      {  2, "Equal percentage reverse"              "|de|Gleichprozentig invers"             },
      { 10, "SAMSON butterfly linear"               "|de|SAMSON Stellklappe linear"          },
      { 11, "SAMSON butterfly equal percentage"     "|de|SAMSON Stellklappe gleichprozentig" },
      { 12, "VETEC rotary linear"                   "|de|VETEC Drehkegel linear"             },
      { 13, "VETEC rotary equal percentage"         "|de|VETEC Drehkegel gleichprozentig"    },
      { 14, "Segmented ball valve linear"           "|de|Kugelsegment linear"                },
      { 15, "Segmented ball valve equal percentage" "|de|Kugelsegment gleichprozentig"       },
      {  3, "User defined"                          "|de|Benutzerdefiniert"                  }
  #else
      {  0, "Linear"                           },
      {  1, "Equal percentage"                 },
      {  2, "Equal percentage reverse"         },
      { 10, "SAMSON butterfly linear"          },
      { 11, "SAMSON butterfly equal perc."     },
      { 12, "VETEC rotary linear"              },
      { 13, "VETEC rotary equal percentage"    },
      { 14, "Segmented ball valve linear"      },
      { 15, "Segmented ball valve equal perc." },
      {  3, "User defined"                     }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Selection of the used characteristic."
       "|de|Auswahl der verwendeten Kennlinie.";
  #else
  HELP "Selection of the used characteristic.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Gewuenschte Laufzeit auf     Doku-Nummer: 26    EB-Code: 21   */
/* ------------------------------------------------------------------------ */
VARIABLE gew_laufzeit_auf
{
  #ifdef LABEL_DE_EN
  LABEL "Required transit time open" "|de|Gewnschte Laufzeit auf";
  #else
  LABEL "Required transit time open";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   0.0;
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";

      MIN_VALUE   0.0;
      MAX_VALUE 240.0;
  }
  CONSTANT_UNIT "s";

  #ifdef HELP_DE_EN
  HELP "The time required to pass through the working range when the valve opens."
       "|de|Zeit um den Arbeitsbereich beim ffnen des Stellventiles zu durchfahren.";
  #else
  HELP "The time required to pass through the working range when the valve opens.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Gewuenschte Laufzeit zu      Doku-Nummer: 27    EB-Code: 22   */
/* ------------------------------------------------------------------------ */
VARIABLE gew_laufzeit_zu
{
  #ifdef LABEL_DE_EN
  LABEL "Required transit time close" "|de|Gewnschte Laufzeit zu";
  #else
  LABEL "Required transit time close";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   0.0;
      DISPLAY_FORMAT "3.0f";
      EDIT_FORMAT    "3.0f";

      MIN_VALUE   0.0;
      MAX_VALUE 240.0;
  }
  CONSTANT_UNIT "s";

  #ifdef HELP_DE_EN
  HELP "The time required to pass through the working range when "
       "the valve closes."
       "|de|Zeit um den Arbeitsbereich beim Schlieen des Stellventiles "
       "zu durchfahren.";
  #else
  HELP "The time required to pass through the working range when "
       "the valve closes.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Absolutes Wegintegral        Doku-Nummer: 28    EB-Code: 23   */
/* ------------------------------------------------------------------------ */
VARIABLE wegintegral
{
  #ifdef LABEL_DE_EN
  LABEL "Total valve travel" "|de|Wegintegral";
  #else
  LABEL "Total valve travel";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "9.0f";
  }

  #ifdef HELP_DE_EN
  HELP "Totalized double valve travel."
       "|de|Aufsummierter Ventildoppelhub.";
  #else
  HELP "Totalized double valve travel.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Grenzwert Wegintegral        Doku-Nummer: 29    EB-Code: 24   */
/* ------------------------------------------------------------------------ */
VARIABLE gw_wegintegral
{
  #ifdef LABEL_DE_EN
  LABEL "Limit value total valve travel" "|de|Grenzwert Wegintegral";
  #else
  LABEL "Limit value total valve travel";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  1000000;
      DISPLAY_FORMAT "9.0f";
      EDIT_FORMAT    "9.0f";

      MIN_VALUE      1000.0;
      MAX_VALUE 990000000.0;
  }

  #ifdef HELP_DE_EN
  HELP "Limit value of total valve travel. If the limit value is exceeded, "
       "the fault symbol and the wrench symbol on the display appear."
       "|de|Grenzwert Wegintegral, nach dessen berschreiten erscheint die "
       "Strmeldung und das Maulschlsselsymbol auf der LC-Anzeige am Gert.";
  #else
  HELP "Limit value of total valve travel. If the limit value is exceeded, "
       "the fault symbol and the wrench symbol on the display appear.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Alarmmodus                   Doku-Nummer: 30    EB-Code: 25   */
/* ------------------------------------------------------------------------ */
VARIABLE alarmmodus
{
  #ifdef LABEL_DE_EN
  LABEL "Alarm mode" "|049Alarmmodus";
  #else
  LABEL "Alarm mode";
  #endif

  CLASS DEVICE;
  /* nur schreibbar wenn Binaerausgang beim 3731-3 eingebaut (ungleich 103 = nicht vorhanden) */
  HANDLING
    /*-------------*/
    /* wenn 3731-3 */
    /*-------------*/
    IF (geraetetyp == 31)
    {
      IF (BA_vorhanden == 103)
      { READ&WRITE; }
      ELSE
      { READ; }
    }
    ELSE
      { READ&WRITE; }


  /* combobox-Inhalt vom Geraetetyp und eingebautem ind. Grenzkontakt abhaengig */
  TYPE ENUMERATED
  {
    /*-------------*/
    /* wenn 3730-3 */
    /*-------------*/
    IF (geraetetyp == 30)
    {
        IF (ind_grenzkontakt == IMPLEMENTED)
        {
            // Antwort 1 ist hier gleich 0 und 3 wie 2 wg. Kompatibilitaet zum 31er
            {   0, "A2 <= 1.2mA" },
            {   1, "A2 <= 1.2mA" },
            {   2, "A2 >= 2.1mA" },
            {   3, "A2 >= 2.1mA" },
            {   4, "Not used" "|049Nicht verwendet" },
            { 250, "Not used" "|049Nicht verwendet" }
        }
        ELSE
        {
            {   0, "A1 >= 2.1mA/A2 <= 1.2mA" },
            {   1, "A1 <= 1.2mA/A2 <= 1.2mA" },
            {   2, "A1 >= 2.1mA/A2 >= 2.1mA" },
            {   3, "A1 <= 1.2mA/A2 >= 2.1mA" },
            {   4, "Not used" "|049Nicht verwendet" },
            { 250, "Not used" "|049Nicht verwendet" }
        }
    }

    /*-------------*/
    /* wenn 3731-3 */
    /*-------------*/
    IF (geraetetyp == 31)
    {
        #ifdef HELP_DE_EN
        {   0, "A1 norm. open contact"   "|049A1 Schliesser"     },
        {   1, "A1 norm. closed contact" "|049A1 ffner"         },
        {   2, "A2 norm. open contact"   "|049A2 Schliesser"     },
        {   3, "A2 norm. closed contact" "|049A2 ffner"         },
        {   4, "Fault alarm output"      "|049Strmeldeausgang"  },
        { 250, "Not used"                "|049Nicht verwendet"   }
        #else
        {   0, "A1 norm. open contact"   },
        {   1, "A1 norm. closed contact" },
        {   2, "A2 norm. open contact"   },
        {   3, "A2 norm. closed contact" },
        {   4, "Fault alarm output"      },
        { 250, "Not used"                }
        #endif
    }

  }

  HELP
    IF (ind_grenzkontakt == IMPLEMENTED)
    {
         #ifdef HELP_DE_EN
         "Switching mode of software limit switch A2."
         "|049Schaltmodus des Software - Grenzkontaktes A2 im angesprochenen "
         "Zustand und bei Grundgert ohne elektrische Hilfsenergie.";
         #else
         "Switching mode of software limit switch A2.";
         #endif
    }
    ELSE
    {
         #ifdef HELP_DE_EN
         "Switching mode of software limit switches A1 and A2."
         "|049Schaltmodus der Software - Grenzkontakte A1 und A2 im angesprochenen "
         "Zustand und bei Grundgert ohne elektrische Hilfsenergie.";
         #else
         "Switching mode of software limit switches A1 and A2.";
         #endif
    }
}


/* ------------------------------------------------------------------------ */
VARIABLE BA_vorhanden
{
  LABEL "";
  HANDLING READ;
  TYPE UNSIGNED_INTEGER;
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Grenzwert A1     Doku-Nummer: 31    EB-Code: 26   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_gw_a1
{
  #ifdef LABEL_DE_EN
  LABEL "Enable limit value A1" "|de|Aktivierung Grenzwert A1";
  #else
  LABEL "Enable limit value A1";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  #else
      { 0, "Off" },
      { 1, "On"  }
  #endif
  }

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Enables the software limit switch A1."
       "|de|Aktivierung des Software - Grenzwertes A1.";
  #else
  HELP "Enables the software limit switch A1.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Grenzwert A1                 Doku-Nummer: 32    EB-Code: 26   */
/* ------------------------------------------------------------------------ */
VARIABLE grenzwert_a1
{
  #ifdef LABEL_DE_EN
  LABEL "Limit value A1" "|de|Grenzwert A1";
  #else
  LABEL "Limit value A1";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   2.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Software limit value for A1 in relation to the working range."
       "|de|Software - Grenzwert A1, bezogen auf den Arbeitsbereich.";
  #else
  HELP "Software limit value for A1 in relation to the working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktivierung Grenzwert A2     Doku-Nummer: 33    EB-Code: 27   */
/* ------------------------------------------------------------------------ */
VARIABLE aktiv_gw_a2
{
  #ifdef LABEL_DE_EN
  LABEL "Enable limit value A2" "|de|Aktivierung Grenzwert A2";
  #else
  LABEL "Enable limit value A2";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "Off" "|de|Aus" },
      { 1, "On"  "|de|Ein" }
  #else
      { 0, "Off" },
      { 1, "On"  }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Enables the software limit switch A2."
       "|de|Aktivierung des Software - Grenzwertes A2.";
  #else
  HELP "Enables the software limit switch A2.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Grenzwert A2                 Doku-Nummer: 34    EB-Code: 27   */
/* ------------------------------------------------------------------------ */
VARIABLE grenzwert_a2
{
  #ifdef LABEL_DE_EN
  LABEL "Limit value A2" "|de|Grenzwert A2";
  #else
  LABEL "Limit value A2";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      DEFAULT_VALUE  98.0;
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "Software limit value for A2 in relation to the working range."
       "|de|Software - Grenzwert A2, bezogen auf den Arbeitsbereich.";
  #else
  HELP "Software limit value for A2 in relation to the working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Wirkrichtung Stellungsmelder Doku-Nummer: 36    EB-Code: 29   */
/* ------------------------------------------------------------------------ */
VARIABLE wirkr_stellmelder
{
  #ifdef LABEL_DE_EN
  LABEL "Operation direction position transmitter"
        "|de|Wirkrichtung Stellungsmelder";
  #else
  LABEL "Operation direction position transmitter";
  #endif

  CLASS DEVICE;
  /* nur schreibbar wenn Stellungsmelder eingebaut */
  HANDLING
    IF (stellungsmelder == 1)
    { READ&WRITE; }
    ELSE
    { READ; }
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      { 0, "Increasing/increasing >>" "|de|Steigend/steigend >>" },
      { 1, "Increasing/decreasing <>" "|de|Steigend/fallend <>"  }
  #else
      { 0, "Increasing/increasing >>" },
      { 1, "Increasing/decreasing <>" }
  #endif
  }

  /* nur sichtbar wenn Stellungsmelder eingebaut */
  VALIDITY
    IF (stellungsmelder == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Operating direction of the position transmitter. "
       "Indicates how the travel/angle position is assigned to the "
       "output signal i, based on the closed position."
       "|de|Wirkrichtung des Stellungsmelders. Gibt ausgehend von der "
       "Schliestellung die Zuordnung der Hub-/Winkelstellung zum "
       "Ausgangssignal i an.";
  #else
  HELP "Operating direction of the position transmitter. "
       "Indicates how the travel/angle position is assigned to the "
       "output signal i, based on the closed position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoermeldung mit Stellungsmelder  Doku-Nummer: 37 EB-Code: 30 */
/* ------------------------------------------------------------------------ */
VARIABLE stoerm_mit_stellmelder
{
  #ifdef LABEL_DE_EN
  LABEL "Fault alarm position transmitter"
        "|de|Strmeldung mit Stellungsmelder";
  #else
  LABEL "Fault alarm position transmitter";
  #endif

  CLASS DEVICE;
  /* nur schreibbar wenn Stellungsmelder eingebaut */
  HANDLING
    IF (stellungsmelder == 1)
    { READ&WRITE; }
    ELSE
    { READ; }
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
      { 0, "No"                 "|de|Nein"               },
      { 1, "High (ix > 20.5mA)" "|de|High (ix > 20.5mA)" },
      { 2, "Low  (ix <  3.8mA)" "|de|Low  (ix <  3.8mA)" }
  #else
      { 0, "No"                 },
      { 1, "High (ix > 20.5mA)" },
      { 2, "Low  (ix <  3.8mA)" }
  #endif
  }

  /* nur sichtbar wenn Stellungsmelder eingebaut */
  VALIDITY
    IF (stellungsmelder == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Used to select whether faults causing the fault alarm contact to "
       "switch should also be signaled by the position transmitter output "
       "and how they should be signaled."
       "|de|Auswahl, ob und wie Strungen, die zum Schalten des "
       "Strmeldekontaktes fhren, auch durch den Stellungsmelderausgang "
       "signalisiert werden sollen.";
  #else
  HELP "Used to select whether faults causing the fault alarm contact to "
       "switch should also be signaled by the position transmitter output "
       "and how they should be signaled.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stellungsmelder Test         Doku-Nummer: 38    EB-Code: 31   */
/* ------------------------------------------------------------------------ */
VARIABLE test_stellmelder
{
  #ifdef LABEL_DE_EN
  LABEL "Position transmitter test" "|de|Stellungsmelder Test";
  #else
  LABEL "Position transmitter test";
  #endif

  CLASS DEVICE;
  HANDLING WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn Stellungsmelder eingebaut */
  VALIDITY
    IF (stellungsmelder == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Testing the position transmitter. Values can be entered in relation "
       "to the working range."
       "|de|Test des Stellungsmelders. Werte knnen, bezogen auf den "
       "Arbeitsbereich, eingegeben werden.";
  #else
  HELP "Testing the position transmitter. Values can be entered in relation "
       "to the working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoermeldung Sonderfunktionen  Doku-Nummer: 39.1  EB-Code: 32 */
/*            (ab FW 1.40 neue Bedeutung von Code 32 !)                     */
/* ------------------------------------------------------------------------ */
VARIABLE stoerm_sonderfunktion
{
  #ifdef LABEL_DE_EN
  LABEL "Fault alarm at condensed state 'Function check'"
        "|de|Strmeldung bei Sammelstatus 'Funktionskontrolle'";
  #else
  LABEL "Fault alarm at condensed state 'Function check'";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "No"  "|de|Nein" },
      { 1, "Yes" "|de|Ja"   }
  #else
      { 0, "No"  },
      { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Determines whether a fault alarm appears when the condensed state "
       "'Function check' occurs."
       "|de|Festlegung ob beim Auftreten eines Sammelstatus 'Funktionskontrolle' "
       "eine Strmeldung ausgegeben werden soll.";
  #else
  HELP "Determines whether a fault alarm appears when the condensed state "
       "'Function check' occurs.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoermeldung Wegintegral     Doku-Nummer: 40.1  EB-Code: 33   */
/*            (ab FW 1.40 neue Bedeutung von Code 33 !)                     */
/* ------------------------------------------------------------------------ */
VARIABLE stoerm_wegintegral
{
  #ifdef LABEL_DE_EN
  LABEL "Fault alarm at cond. state 'Maint. required'"
        "|de|Strmeldung bei Sammelstatus 'Wartungsbedarf'";
  #else
  LABEL "Fault alarm at cond. state 'Maint. required'";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "No"  "|de|Nein" },
      { 1, "Yes" "|de|Ja"   }
  #else
      { 0, "No"  },
      { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Determines whether a fault alarm appears when the condensed state "
       "'Maintenance required' and 'Maintenance alarm' occurs, or only at "
       "'Maintenance alarm'."
       "|de|Festlegung ob beim Auftreten eines Sammelstatus 'Wartungsbedarf' "
       "und 'Ausfall' eine Strmeldung ausgegeben werden soll, oder nur bei 'Ausfall'.";
  #else
  HELP "Determines whether a fault alarm appears when the condensed state "
       "'Maintenance required' and 'Maintenance alarm' occurs, or only at "
       "'Maintenance alarm'.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Schliessrichtung             Doku-Nummer: 41    EB-Code: 34   */
/* ------------------------------------------------------------------------ */
VARIABLE schliessrichtung
{
  #ifdef LABEL_DE_EN
  LABEL "Closing direction" "|de|Schliessrichtung";
  #else
  LABEL "Closing direction";
  #endif

  CLASS DEVICE;
  HANDLING
    /* wenn Regler NICHT initialisiert UND Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */
    IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))
    { READ&WRITE; }
    ELSE
    { READ; }

  TYPE ENUMERATED
  {
      DEFAULT_VALUE  1;
  #ifdef LABEL_DE_EN
      { 0, "Clockwise"        "|de|Im Uhrzeigersinn"    },
      { 1, "Counterclockwise" "|de|Gegen Uhrzeigersinn" }
  #else
      { 0, "Clockwise"        },
      { 1, "Counterclockwise" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Turning direction in which the valve is moved to the closed position "
       "(view onto the rotary switch motion when the positioner cover is open). "
       "Can only be entered in initialization mode SUB."
       "|de|Drehrichtung durch die die Zu-Stellung des Stellventiles erreicht wird "
       "(Blick auf Knebelknopfbewegung bei geffnetem Deckel des Stellungsreglers). "
       "Eingabe nur bei Initialisierungsart SUB mglich.";
  #else
  HELP "Turning direction in which the valve is moved to the closed position "
       "(view onto the rotary switch motion when the positioner cover is open). "
       "Can only be entered in initialization mode SUB.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Blockierstellung             Doku-Nummer: 42    EB-Code: 35   */
/* ------------------------------------------------------------------------ */
VARIABLE blockierstellung
{
  #ifdef LABEL_DE_EN
  LABEL "Blocking position" "|de|Blockierstellung";
  #else
  LABEL "Blocking position";
  #endif

  CLASS DEVICE;
  HANDLING
    /* wenn Regler NICHT initialisiert UND Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */
    IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))
    { READ&WRITE; }
    ELSE
    { READ; }

  TYPE FLOAT
  {
      DEFAULT_VALUE  0.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      /* Max.-Grenze von der Stiftposition abhaengig */
      MAX_VALUE
        SELECT (stiftposition)
        {
          CASE 0:  100.0;
          CASE 1:   17.7;
          CASE 2:   25.0;
          CASE 3:   35.4;
          CASE 4:   50.0;
          CASE 5:   70.7;
          CASE 6:  100.0;
          CASE 8:  200.0;
          CASE 9:  110.0;
          DEFAULT: 100.0;
        }
  }
  /* Einheit von Stiftposition abhaengig */
  CONSTANT_UNIT
      SELECT (stiftposition)
      {
        CASE 0:    "%";
        CASE 1:   "mm";
        CASE 2:   "mm";
        CASE 3:   "mm";
        CASE 4:   "mm";
        CASE 5:   "mm";
        CASE 6:   "mm";
        CASE 8:   "mm";
        CASE 9:    "";
        DEFAULT:   "%";
      }

  #ifdef HELP_DE_EN
  HELP "Distance up to the closed position. Can only be entered in "
       "initialization mode SUB."
       "|de|Abstand bis zur Zu-Stellung. Nur bei Init.-modus SUB.";
  #else
  HELP "Distance up to the closed position. Can only be entered in "
       "initialization mode SUB.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kaltstart                    Doku-Nummer: 43/201 EB-Code: 36  */
/* ------------------------------------------------------------------------ */
VARIABLE kaltstart
{
  #ifdef LABEL_DE_EN
  LABEL "Start with default values" "|de|Start mit Defaultwerten";
  #else
  LABEL "Start with default values";
  #endif

  CLASS DEVICE;
  HANDLING WRITE;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      { 0, "No"  "|de|Nein" },
      { 1, "Yes" "|de|Ja"   }
  #else
      { 0, "No"  },
      { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Resets all parameters to default (factory setting). "
       "Note: After reset the device must be re-initialized."
       "|de|Setzt alle Parameter auf Standardwerte (Werkseinstellung) zurck. "
       "Hinweis: Nach dem Setzen muss das Gert neu initialisiert werden.";
  #else
  HELP "Resets all parameters to default (factory setting). "
       "Note: After reset the device must be re-initialized.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stellungsmelder              Doku-Nummer: 44    EB-Code: 37   */
/* ------------------------------------------------------------------------ */
VARIABLE stellungsmelder
{
  #ifdef LABEL_DE_EN
  LABEL "Position transmitter" "|de|Stellungsmelder";
  #else
  LABEL "Position transmitter";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      { NOT_IMPLEMENTED, "Not implemented" "|de|Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|de|Eingebaut"       }
  #else
      { NOT_IMPLEMENTED, "Not implemented" },
      { IMPLEMENTED,     "Implemented"     }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Indicates whether the option position transmitter is installed "
       "(no automatic identification)."
       "|de|Anzeige ob die Option Stellungsmelder eingebaut ist. "
       "Wird nicht automatisch erkannt.";
  #else
  HELP "Indicates whether the option position transmitter is installed "
       "(no automatic identification).";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Induktiver Grenzkontakt      Doku-Nummer: 45    EB-Code: 38   */
/* ------------------------------------------------------------------------ */
VARIABLE ind_grenzkontakt
{
  #ifdef LABEL_DE_EN
  LABEL "Inductive limit switch" "|de|Induktiver Grenzkontakt";
  #else
  LABEL "Inductive limit switch";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      { NOT_IMPLEMENTED, "Not implemented" "|de|Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|de|Eingebaut"       }
  #else
      { NOT_IMPLEMENTED, "Not implemented" },
      { IMPLEMENTED,     "Implemented"     }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Indicates whether the option inductive limit switch is installed "
       "(no automatic identification)."
       "|de|Anzeige ob die Option induktiver Grenzkontakt eingebaut ist. "
       "Wird nicht automatisch erkannt.";
  #else
  HELP "Indicates whether the option inductive limit switch is installed "
       "(no automatic identification).";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Regeldifferenz e             Doku-Nummer: 46    EB-Code: 39   */
/* ------------------------------------------------------------------------ */
VARIABLE regeldifferenz
{
  #ifdef LABEL_DE_EN
  LABEL "Setpoint deviation e" "|de|Regeldifferenz e";
  #else
  LABEL "Setpoint deviation e";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn Geraet initialisiert */
  VALIDITY
    IF (geraet_ini == 1)
    { TRUE; }
    ELSE
    { FALSE; }


  #ifdef HELP_DE_EN
  HELP "Deviation from the reference position."
       "|de|Abweichung von der Sollposition.";
  #else
  HELP "Deviation from the reference position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Minimale Laufzeit auf        Doku-Nummer: 47    EB-Code: 40   */
/* ------------------------------------------------------------------------ */
VARIABLE min_laufzeit_auf
{
  #ifdef LABEL_DE_EN
  LABEL "Minimum transit time open" "|de|Minimale Laufzeit auf";
  #else
  LABEL "Minimum transit time open";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "s";

  #ifdef HELP_DE_EN
  HELP "The minimum opening time is determined during initialization."
       "|de|Minimale ffnungszeit, wird whrend der Initialisierung ermittelt.";
  #else
  HELP "The minimum opening time is determined during initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Minimale Laufzeit zu         Doku-Nummer: 48    EB-Code: 41   */
/* ------------------------------------------------------------------------ */
VARIABLE min_laufzeit_zu
{
  #ifdef LABEL_DE_EN
  LABEL "Minimum transit time close" "|de|Minimale Laufzeit zu";
  #else
  LABEL "Minimum transit time close";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "3.1f";
  }
  CONSTANT_UNIT "s";

  #ifdef HELP_DE_EN
  HELP "The minimum closing time is determined during initialization."
       "|de|Minimale Schliezeit, wird whrend der Initialisierung ermittelt.";
  #else
  HELP "The minimum closing time is determined during initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fuehrungsgroesse w [%]       Doku-Nummer: 49    EB-Code: 42   */
/* ------------------------------------------------------------------------ */
VARIABLE w_prozent
{
  #ifdef LABEL_DE_EN
  LABEL "Reference var. w" "|de|Fhrungsgre w";
  #else
  LABEL "Reference var. w";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "Indicates the supplied automatic reference variable "
       "corresponding 4 to 20 mA."
       "|de|Anzeige der anliegenden Automatik - Fhrungsgre "
       "entsprechend 4 bis 20 mA.";
  #else
  HELP "Indicates the supplied automatic reference variable "
       "corresponding 4 to 20 mA.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Antriebsdruck y              Doku-Nummer: 51    EB-Code: 44   */
/* ------------------------------------------------------------------------ */
VARIABLE antriebsdruck
{
  #ifdef LABEL_DE_EN
  LABEL "Drive signal y" "|de|Stellgre y";
  #else
  LABEL "Drive signal y";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

  /* nur sichtbar wenn Geraet initialisiert */
  VALIDITY
    IF (geraet_ini == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Shows the actuator pressure after initialization."
       "|de|Gibt nach der Initialisierung den Antriebsdruck an.";
  #else
  HELP "Shows the actuator pressure after initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Magnetventil                 Doku-Nummer: 52    EB-Code: 45   */
/* ------------------------------------------------------------------------ */
VARIABLE magnetventil
{
  #ifdef LABEL_DE_EN
  LABEL "Solenoid valve" "|de|Magnetventil";
  #else
  LABEL "Solenoid valve";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      { NOT_IMPLEMENTED, "Not implemented" "|de|Nicht eingebaut" },
      { IMPLEMENTED,     "Implemented"     "|de|Eingebaut"       }
  #else
      { NOT_IMPLEMENTED, "Not implemented" },
      { IMPLEMENTED,     "Implemented"     }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Indicates whether a solenoid valve is installed."
       "|de|Anzeige ob die Option Magnetventil eingebaut ist.";
  #else
  HELP "Indicates whether a solenoid valve is installed.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter ohne EB-Code                                                   */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Regelgroesse x               Doku-Nummer: 100   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE regelgroesse
{
  #ifdef LABEL_DE_EN
  LABEL "Controlled var. x" "|de|Regelgre x";
  #else
  LABEL "Controlled var. x";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  /* Einheit von Geraet initialisiert abhaengig */
  CONSTANT_UNIT
    IF (geraet_ini == 1)
    { "%"; }
    ELSE
    { ""; }

  #ifdef HELP_DE_EN
  HELP "Current position." "|de|Aktuelle Position.";
  #else
  HELP "Current position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 1               Doku-Nummer: 103/315   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_1
{
  #ifdef LABEL_DE_EN
  LABEL "Text field 1" "|de|Textfeld 1";
  #else
  LABEL "Text field 1";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Free available space for entering text."
       "|de|Frei verfgbares Textfeld.";
  #else
  HELP "Free available space for entering text.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 2               Doku-Nummer: 104/316   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_2
{
  #ifdef LABEL_DE_EN
  LABEL "Text field 2" "|de|Textfeld 2";
  #else
  LABEL "Text field 2";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Free available space for entering text."
       "|de|Frei verfgbares Textfeld.";
  #else
  HELP "Free available space for entering text.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 3               Doku-Nummer: 105/317   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_3
{
  #ifdef LABEL_DE_EN
  LABEL "Text field 3" "|de|Textfeld 3";
  #else
  LABEL "Text field 3";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Free available space for entering text."
       "|de|Frei verfgbares Textfeld.";
  #else
  HELP "Free available space for entering text.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Erzeugnis-Nummer Regler      Doku-Nummer: 107   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE erzeugnis_num_regler
{
  #ifdef LABEL_DE_EN
  LABEL "Product number positioner" "|de|Erzeugnis-Nummer Regler";
  #else
  LABEL "Product number positioner";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Manufacturer's product number of the positioner."
       "|de|Hersteller - Erzeugnis - Nummer des Stellungsreglers.";
  #else
  HELP "Manufacturer's product number of the positioner.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[0]                         Doku-Nummer: 111   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x0
{
  LABEL "x[0]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "Coordinates for user - defined control valve characteristic. x[n] = "
       "reference variable in % of the respective range. y[n] = travel / opening "
       "angle in % of the respective range."
       "|de|Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
       "Fhrungsgre und Hub / Drehwinkel. x[n] = Fhrungsgre in % "
       "des Fhrungsgrenbereichs. y[n] = Hub- / Drehwinkel in % des "
       "Hub / Drehwinkelbereichs.";
  #else
  HELP "Coordinates for user - defined control valve characteristic. x[n] = "
       "reference variable in % of the respective range. y[n] = travel / opening "
       "angle in % of the respective range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[1]                         Doku-Nummer: 112   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x1
{
  LABEL "x[1]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[2]                         Doku-Nummer: 113   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x2
{
  LABEL "x[2]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[3]                         Doku-Nummer: 114   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x3
{
  LABEL "x[3]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[4]                         Doku-Nummer: 115   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x4
{
  LABEL "x[4]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[5]                         Doku-Nummer: 116   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x5
{
  LABEL "x[5]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[6]                         Doku-Nummer: 117   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x6
{
  LABEL "x[6]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[7]                         Doku-Nummer: 118   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x7
{
  LABEL "x[7]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[8]                         Doku-Nummer: 119   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x8
{
  LABEL "x[8]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[9]                         Doku-Nummer: 120   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x9
{
  LABEL "x[9]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: x[10]                        Doku-Nummer: 121   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x10
{
  LABEL "x[10]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[0]                         Doku-Nummer: 122   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y0
{
  LABEL "y[0]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[1]                         Doku-Nummer: 123   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y1
{
  LABEL "y[1]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[2]                         Doku-Nummer: 124   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y2
{
  LABEL "y[2]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[3]                         Doku-Nummer: 125   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y3
{
  LABEL "y[3]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[4]                         Doku-Nummer: 126   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y4
{
  LABEL "y[4]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[5]                         Doku-Nummer: 127   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y5
{
  LABEL "y[5]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[6]                         Doku-Nummer: 128   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y6
{
  LABEL "y[6]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[7]                         Doku-Nummer: 129   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y7
{
  LABEL "y[7]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[8]                         Doku-Nummer: 130   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y8
{
  LABEL "y[8]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[9]                         Doku-Nummer: 131   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y9
{
  LABEL "y[9]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: y[10]                        Doku-Nummer: 132   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE y10
{
  LABEL "y[10]";
  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 100.0;
  }
  CONSTANT_UNIT "%";

  #ifdef HELP_DE_EN
  HELP "see help x[0]" "|de|siehe Hilfe x[0]";
  #else
  HELP "see help x[0]";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nachlaufzeit                 Doku-Nummer: 133   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE nachlaufzeit
{
  #ifdef LABEL_DE_EN
  LABEL "Delay time" "|de|Nachlaufzeit";
  #else
  LABEL "Delay time";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  30.0;
      DISPLAY_FORMAT "4.0f";
      EDIT_FORMAT    "4.0f";

      MIN_VALUE    0.0;
      MAX_VALUE 9999.0;
  }
  CONSTANT_UNIT "s";

  #ifdef HELP_DE_EN
  HELP "Reset criterion for monitoring the active control loop. "
       "When delay time is exceeded and the setpoint deviation is not "
       "within the limits of the tolerance band, a control loop error "
       "is reported."
       "|de|Rcksetzkriterium fr laufende Regelkreis - berwachung. "
       "Wenn die Nachlaufzeit berschritten ist und die Regelabweichung "
       "nicht innerhalb des Toleranzbandes liegt, wird Regelkreisstrung "
       "gemeldet.";
  #else
  HELP "Reset criterion for monitoring the active control loop. "
       "When delay time is exceeded and the setpoint deviation is not "
       "within the limits of the tolerance band, a control loop error "
       "is reported.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Sicherheitsstellung          Doku-Nummer: 134   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE sicherheitsstellung
{
  #ifdef LABEL_DE_EN
  LABEL "Fail-safe position" "|de|Sicherheitsstellung";
  #else
  LABEL "Fail-safe position";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Air to close" "|de|ffnend"     },
    { 1, "Air to open"  "|de|Schlieend"  },
    { 2, "Undefined"    "|de|Undefiniert" }
  #else
    { 0, "Air to close" },
    { 1, "Air to open"  },
    { 2, "Undefined"    }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Fail-safe position of the actuator in the event of air/power "
       "failure or start-up. Determined during initialization."
       "|de|Sicherheitsstellung des Antriebes bei Luft - /Hilfsenergieausfall "
       "oder Gerteanlauf. Wird whrend der Initialisierung ermittelt.";
  #else
  HELP "Fail-safe position of the actuator in the event of air/power "
       "failure or start-up. Determined during initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zwangsentlueftung/Magnetventil aktiv      Doku-Nummer: 138    */
/* ------------------------------------------------------------------------ */
VARIABLE zwangsentlueftung
{
  #ifdef LABEL_DE_EN
  LABEL "Status solenoid valve" "|de|Status Magnetventil";
  #else
  LABEL "Status solenoid valve";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Not active" "|de|Nicht aktiv" },
    { 1, "Active"     "|de|Aktiv"       },
    { 2, "Not implemented" "|de|Nicht implementiert" }
  #else
    { 0, "Not active" },
    { 1, "Active"     },
    { 2, "Not implemented" }
  #endif
  }

  /* nur sichtbar wenn Magnetventil eingebaut */
  VALIDITY
    IF (magnetventil == 1)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Status of option solenoid valve." "|de|Status der Option Magnetventil.";
  #else
  HELP "Status of option solenoid valve.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: X unterschreitet A1          Doku-Nummer: 140   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x_unterschreitet_a1
{
  #ifdef LABEL_DE_EN
  LABEL "X falls below A1" "|de|X unterschreitet A1";
  #else
  LABEL "X falls below A1";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  #else
    { 0, "No"  },
    { 1, "Yes" }
  #endif
  }

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Indicates whether the controlled variable x falls below the "
       "limit value A1."
       "|de|Anzeige ob die Regelgre x den Grenzwert fr A1 unterschreitet.";
  #else
  HELP "Indicates whether the controlled variable x falls below the "
       "limit value A1.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Status Grenzkontakt A1       Doku-Nummer: 141   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE status_a1
{
  #ifdef LABEL_DE_EN
  LABEL "Status limit switch A1" "|de|Status Grenzkontakt A1";
  #else
  LABEL "Status limit switch A1";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Non conducting/low" "|de|Sperrend/low" },
    { 1, "Conducting/high"    "|de|Leitend/high" }
  #else
    { 0, "Non conducting/low" },
    { 1, "Conducting/high"    }
  #endif
  }

  /* nur sichtbar wenn ind. Grenzkontakt nicht eingebaut */
  VALIDITY
    IF (ind_grenzkontakt == NOT_IMPLEMENTED)
    { TRUE; }
    ELSE
    { FALSE; }

  #ifdef HELP_DE_EN
  HELP "Status of output for limit switch A1."
       "|de|Status des Schaltausgangs fr Grenzkontakt A1.";
  #else
  HELP "Status of output for limit switch A1.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: X ueberschreitet A2          Doku-Nummer: 142   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE x_ueberschreitet_a2
{
  #ifdef LABEL_DE_EN
  LABEL "X exceeds A2" "|de|X berschreitet A2";
  #else
  LABEL "X exceeds A2";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  #else
    { 0, "No"  },
    { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Indicates whether the controlled variable x exceeds the limit value A2."
       "|de|Anzeige ob die Regelgre x den Grenzwert fr A2 berschreitet.";
  #else
  HELP "Indicates whether the controlled variable x exceeds the limit value A2.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Status Grenzkontakt A2       Doku-Nummer: 143   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE status_a2
{
  #ifdef LABEL_DE_EN
  LABEL "Status limit switch A2" "|de|Status Grenzkontakt A2";
  #else
  LABEL "Status limit switch A2";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Non conducting/low" "|de|Sperrend/low" },
    { 1, "Conducting/high"    "|de|Leitend/high" }
  #else
    { 0, "Non conducting/low" },
    { 1, "Conducting/high"    }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Status of output for limit switch A2."
       "|de|Status des Schaltausgangs fr Grenzkontakt A2.";
  #else
  HELP "Status of output for limit switch A2.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stoerung vorh. (Stoermeldeausgang) Doku-Nummer: 144 EB-Code:- */
/* ------------------------------------------------------------------------ */
VARIABLE stoerung_vorhanden
{
  #ifdef LABEL_DE_EN
  LABEL "Error occurred" "|de|Strung vorhanden";
  #else
  LABEL "Error occurred";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  #else
    { 0, "No"  },
    { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Status of the fault alarm output."
       "|de|Status des Strmeldeausgangs.";
  #else
  HELP "Status of the fault alarm output.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraet initialisiert         Doku-Nummer: 145   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE geraet_ini
{
  #ifdef LABEL_DE_EN
  LABEL "Device initialized" "|de|Gert initialisiert";
  #else
  LABEL "Device initialized";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  #else
    { 0, "No"  },
    { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Status of the device initialization."
       "|de|Status der Gerte - Initialisierung.";
  #else
  HELP "Status of the device initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 4               Doku-Nummer: 146/318   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_4
{
  #ifdef LABEL_DE_EN
  LABEL "Text field 4" "|de|Textfeld 4";
  #else
  LABEL "Text field 4";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Free available space for entering text."
       "|de|Frei verfgbares Textfeld.";
  #else
  HELP "Free available space for entering text.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Textfeld 5               Doku-Nummer: 147/319   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE textfeld_5
{
  #ifdef LABEL_DE_EN
  LABEL "Text field 5" "|de|Textfeld 5";
  #else
  LABEL "Text field 5";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Free available space for entering text."
       "|de|Frei verfgbares Textfeld.";
  #else
  HELP "Free available space for entering text.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraetetyp                   Doku-Nummer: 148   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE geraetetyp
{
  #ifdef LABEL_DE_EN
  LABEL "Device type" "|de|Gertetyp";
  #else
  LABEL "Device type";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    {  30, "3730-3",
           "SAMSON Positioner 3730-3 HART" "|de|SAMSON Stellungsregler 3730-3 HART" },
    {  31, "3731-3",
           "SAMSON Positioner 3731-3 HART" "|de|SAMSON Stellungsregler 3731-3 HART" },
    { 255, "Unknown" "|de|Unbekannt" }
  #else
    {  30, "3730-3"  },
    {  31, "3731-3"  },
    { 255, "Unknown" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Shows the exact device type."
       "|de|Anzeige des genauen Gertetyps.";
  #else
  HELP "Shows the exact device type.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Diagnose-Parameter                                                       */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Typenkennung Antrieb         Doku-Nummer: 151   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ident_antrieb
{
  #ifdef LABEL_DE_EN
  LABEL "Type identification actuator" "|de|Typenkennung Antrieb";
  #else
  LABEL "Type identification actuator";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Manufacturer's identification number of the actuator."
       "|de|Hersteller - Identnummer des zum Stellungsregler zugehrigen Antriebs.";
  #else
  HELP "Manufacturer's identification number of the actuator.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Booster                      Doku-Nummer: 152   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE booster
{
  #ifdef LABEL_DE_EN
  LABEL "Booster" "|de|Booster";
  #else
  LABEL "Booster";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Not present" "|de|Nicht vorhanden" },
    { 1, "Present"     "|de|Vorhanden"       }
  #else
    { 0, "Not present" },
    { 1, "Present"     }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Pneumatic volume booster."
       "|de|Pneumatischer Volumenverstrker.";
  #else
  HELP "Pneumatic volume booster.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Antriebswirkflaeche          Doku-Nummer: 153   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE antriebswirkflaeche
{
  #ifdef LABEL_DE_EN
  LABEL "Actuator size" "|de|Antriebswirkflche";
  #else
  LABEL "Actuator size";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;

  TYPE UNSIGNED_INTEGER (2)
  {
    DEFAULT_VALUE  240;
    DISPLAY_FORMAT  "4d";
    EDIT_FORMAT     "4d";

    MIN_VALUE   60;
    MAX_VALUE 5600;
  }
  CONSTANT_UNIT "cm";

  #ifdef HELP_DE_EN
  HELP "Effective diaphragm or piston area of the actuator."
       "|de|Wirksame Membran- oder Kolbenflche des Antriebs.";
  #else
  HELP "Effective diaphragm or piston area of the actuator.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stelldruckbereich Anfang     Doku-Nummer: 154   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE stelldruckbereich_anfang
{
  #ifdef LABEL_DE_EN
  LABEL "Signal pressure lower value" "|de|Stelldruckbereich Anfang";
  #else
  LABEL "Signal pressure lower value";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  0.2;
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  #ifdef HELP_DE_EN
  HELP "Start value of the actuator's spring range."
       "|de|Anfangswert des Federbereiches des Antriebes.";
  #else
  HELP "Start value of the actuator's spring range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stelldruckbereich Ende       Doku-Nummer: 155   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE stelldruckbereich_ende
{
  #ifdef LABEL_DE_EN
  LABEL "Signal pressure upper value" "|de|Stelldruckbereich Ende";
  #else
  LABEL "Signal pressure upper value";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   1.0;
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  #ifdef HELP_DE_EN
  HELP "End value of the actuator's spring range."
       "|de|Endwert des Federbereiches des Antriebes.";
  #else
  HELP "End value of the actuator's spring range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Versorgungsdruck             Doku-Nummer: 156   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE versorgungsdruck
{
  #ifdef LABEL_DE_EN
  LABEL "Supply pressure" "|de|Versorgungsdruck";
  #else
  LABEL "Supply pressure";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE   6.0;
      DISPLAY_FORMAT "3.1f";
      EDIT_FORMAT    "3.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 6.0;
  }
  CONSTANT_UNIT "bar";

  #ifdef HELP_DE_EN
  HELP "Pressure of the pneumatic supply system."
       "|de|Druck des Zuluftnetzes.";
  #else
  HELP "Pressure of the pneumatic supply system.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Typenkennung Ventil          Doku-Nummer: 157   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ident_ventil
{
  #ifdef LABEL_DE_EN
  LABEL "Type identification valve" "|de|Typenkennung Ventil";
  #else
  LABEL "Type identification valve";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Manufacturer identification of the valve delivered with the actuator."
       "|de|Hersteller - Identnummer des zum Stellungsregler zugehrigen Ventils.";
  #else
  HELP "Manufacturer identification of the valve delivered with the actuator.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fliessrichtung               Doku-Nummer: 158   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE fliessrichtung
{
  #ifdef LABEL_DE_EN
  LABEL "Flow direction" "|de|Flierichtung";
  #else
  LABEL "Flow direction";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Valve opening (FTO)" "|de|Ventil ffnend (FTO)"     },
    { 1, "Valve closing (FTC)" "|de|Ventil schliessend (FTC)" }
  #else
    { 0, "Valve opening (FTO)" },
    { 1, "Valve closing (FTC)" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Flow direction of the medium against the valve trim."
       "|de|Anstrmrichtung Medium zu Drosselelement des Ventils.";
  #else
  HELP "Flow direction of the medium against the valve trim.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Stangenabdichtung            Doku-Nummer: 159   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE stangenabdichtung
{
  #ifdef LABEL_DE_EN
  LABEL "Stuffing box" "|de|Stangenabdichtung";
  #else
  LABEL "Stuffing box";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Self adjusting" "|de|Selbstnachstellend" },
    { 1, "Retorque"       "|de|Nachziehbar"        },
    { 2, "Bag sealing"    "|de|Balgabdichtung"     }
  #else
    { 0, "Self adjusting" },
    { 1, "Retorque"       },
    { 2, "Bag sealing"    }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Sealing of the valve stem."
       "|de|Abdichtung der Kegelstange nach aussen.";
  #else
  HELP "Sealing of the valve stem.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Dichtkante (Leckageklasse)   Doku-Nummer: 160   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE dichtkante
{
  #ifdef LABEL_DE_EN
  LABEL "Sealing edge (leakage class)" "|de|Dichtkante (Leckageklasse)";
  #else
  LABEL "Sealing edge (leakage class)";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Metal-sealed" "|de|Metallisch dichtend"  },
    { 1, "Sharpened"     "|de|Eingeschliffen"      },
    { 2, "Soft-sealed"   "|de|Weichdichtend"       },
    { 3, "Nickel-sealed" "|de|Nickeldichtung"      }
  #else
    { 0, "Metal-sealed"  },
    { 1, "Sharpened"     },
    { 2, "Soft-sealed"   },
    { 3, "Nickel-sealed" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Type of sealing between seat and plug."
       "|de|Art der Abdichtung zwischen Sitz und Kegel.";
  #else
  HELP "Type of sealing between seat and plug.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Druckentlastung              Doku-Nummer: 161   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE druckentlastung
{
  #ifdef LABEL_DE_EN
  LABEL "Press. balancing" "|de|Druckentlastung";
  #else
  LABEL "Press. balancing";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "None"            "|de|Ohne"          },
    { 1, "With (PTFE)"     "|de|Mit (PTFE)"    },
    { 2, "With (graphite)" "|de|Mit (Graphit)" }
  #else
    { 0, "None"            },
    { 1, "With (PTFE)"     },
    { 2, "With (graphite)" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Plug with mostly compensated stroking forces."
       "|de|Kegel mit weitgehender Kompensation der Stellkrfte.";
  #else
  HELP "Plug with mostly compensated stroking forces.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinie Kegel              Doku-Nummer: 162   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kennlinie_kegel
{
  #ifdef LABEL_DE_EN
  LABEL "Flow characteristic" "|de|Kennlinie Kegel";
  #else
  LABEL "Flow characteristic";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  2;
  #ifdef LABEL_DE_EN
    { 0, "Linear 30:1"           "|de|Linear 30:1"          },
    { 1, "Equal percentage 30:1" "|de|Gleichprozentig 30:1" },
    { 2, "Linear 50:1"           "|de|Linear 50:1"          },
    { 3, "Equal percentage 50:1" "|de|Gleichprozentig 50:1" },
    { 4, "Other"                 "|de|Sonstige"             }
  #else
    { 0, "Linear 30:1"           },
    { 1, "Equal percentage 30:1" },
    { 2, "Linear 50:1"           },
    { 3, "Equal percentage 50:1" },
    { 4, "Other"                 }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Valve characteristic flow versus valve travel."
       "|de|Ventilkennlinie Durchfluss zu Ventilhub.";
  #else
  HELP "Valve characteristic flow versus valve travel.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nennweiten-Norm              Doku-Nummer: 163   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE nennweiten_norm
{
  #ifdef LABEL_DE_EN
  LABEL "Nominal diameter" "|de|Nennweiten-Norm";
  #else
  LABEL "Nominal diameter";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
    { 0, "DIN"  },
    { 1, "ANSI" }
  }

  #ifdef HELP_DE_EN
  HELP "Valve dimensions according to DIN or ANSI standard."
       "|de|Ventilabmessumgen nach DIN- oder ANSI-Norm.";
  #else
  HELP "Valve dimensions according to DIN  or ANSI standard.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Nennweite DN                 Doku-Nummer: 164   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE nennweite_dn
{
  #ifdef LABEL_DE_EN
  LABEL "Nominal diameter DN" "|de|Nennweite DN";
  #else
  LABEL "Nominal diameter DN";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  50.0;
      DISPLAY_FORMAT "4.0f";
      EDIT_FORMAT    "4.0f";

      MIN_VALUE    8.0;
      MAX_VALUE 2100.0;
  }

  #ifdef HELP_DE_EN
  HELP "Diameter in mm (DIN) or inches (ANSI)."
       "|de|Nennweite in mm (DIN) oder inch (ANSI).";
  #else
  HELP "Diameter in mm (DIN) or inches (ANSI).";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kvs Einheit                  Doku-Nummer: 165   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kvs_einheit
{
  #ifdef LABEL_DE_EN
  LABEL "Kvs unit" "|de|Kvs Einheit";
  #else
  LABEL "Kvs unit";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
    { 0, "Kv" },
    { 1, "Cv" }
  }

  #ifdef HELP_DE_EN
  HELP "Flow coefficient based metric (kvs) or us-american (cv)."
       "|de|Durchfluss - Koeffizient aus Einheiten metrisch (kvs) "
       "oder us-amerikanisch (cv).";
  #else
  HELP "Flow coefficient based metric (kvs) or us-american (cv).";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kvs Wert                     Doku-Nummer: 166   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kvs_wert
{
  #ifdef LABEL_DE_EN
  LABEL "Kvs value" "|de|Kvs Wert";
  #else
  LABEL "Kvs value";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  1.0;
      DISPLAY_FORMAT "10.4f";
      EDIT_FORMAT    "10.4f";

      MIN_VALUE     0.0001;
      MAX_VALUE 20000.0;
  }
  /* Einheit von kvs_einheit abhaengig */
  CONSTANT_UNIT
    IF (kvs_einheit == 0)
    { "Kv"; }
    ELSE
    { "Cv"; }

  #ifdef HELP_DE_EN
  HELP "Flow coefficient of the valve."
       "|de|Durchfluss - Koeffizient des Ventils.";
  #else
  HELP "Flow coefficient of the valve.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Sitzdurchmesser Ventil       Doku-Nummer: 167   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE sitzdurchmesser_ventil
{
  #ifdef LABEL_DE_EN
  LABEL "Seat diameter valve" "|de|Sitzdurchmesser Ventil";
  #else
  LABEL "Seat diameter valve";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  6.0;
      DISPLAY_FORMAT "5.1f";
      EDIT_FORMAT    "5.1f";

      MIN_VALUE   2.0;
      MAX_VALUE 500.0;
  }
  CONSTANT_UNIT "mm";

  #ifdef HELP_DE_EN
  HELP "Diameter of the valve seat."
       "|de|Durchmesser der Sitzbohrung des Ventils.";
  #else
  HELP "Diameter of the valve seat.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Anzahl Nullpunktabgleiche    Doku-Nummer: 175   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE anzahl_np
{
  #ifdef LABEL_DE_EN
  LABEL "No. of zero point adjustments" "|de|Anzahl Nullpunktabgleiche";
  #else
  LABEL "No. of zero point adjustments";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE UNSIGNED_INTEGER (1)
  {
      DISPLAY_FORMAT "3d";
  }

  #ifdef HELP_DE_EN
  HELP "Number of zero point adjustments since the latest initialization."
       "|de|Anzahl der durchgefhrten Nullpunktabgleiche seit der "
       "letzten Initialisierung.";
  #else
  HELP "Number of zero point adjustments since the latest initialization.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fhrungsgre %              Doku-Nummer: 302   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ausgang_split_range
{
  #ifdef LABEL_DE_EN
  LABEL "Control value" "|de|Fhrungsgre %";
  #else
  LABEL "Control value";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

/*  HELP "Control value" "|de|Fhrungsgre %";*/
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ventilsollwert               Doku-Nummer: 304   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ventilsollwert
{
  #ifdef LABEL_DE_EN
  LABEL "Valve setpoint" "|de|Ventilsollwert";
  #else
  LABEL "Valve setpoint";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

/*  HELP "Valve setpoint" "|de|Ventilsollwert";*/
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zielposition                 Doku-Nummer: 306   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zielposition
{
  #ifdef LABEL_DE_EN
  LABEL "Target position" "|de|Zielposition";
  #else
  LABEL "Target position";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

/*  HELP "Target position" "|de|Zielposition";*/
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ventilposition               Doku-Nummer: 308   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ventilposition
{
  #ifdef LABEL_DE_EN
  LABEL "Valve position" "|de|Ventilposition";
  #else
  LABEL "Valve position";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
  CONSTANT_UNIT "%";

/*  HELP "Valve position" "|de|Ventilposition";*/
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kennlinientyp                Doku-Nummer: 320   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE kennlinientyp
{
  #ifdef LABEL_DE_EN
  LABEL "Characteristic type" "|de|Kennlinientyp";
  #else
  LABEL "Characteristic type";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE PACKED_ASCII (32);

  #ifdef HELP_DE_EN
  HELP "Free text to describe the user defined characteristic."
       "|de|Freier Text zur Beschreibung der benutzerdefinierten Kennlinie.";
  #else
  HELP "Free text to describe the user defined characteristic.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Long TAG                     Doku-Nummer: 323   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE long_tag
{
  #ifdef LABEL_DE_EN
  LABEL "Long TAG" "|de|Lang TAG";
  #else
  LABEL "Long TAG";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ASCII (32);

  #ifdef HELP_DE_EN
  HELP  "Tag identification number of the operation unit."
        "|de|Messstellen - Kennzeichen der Betriebseinheit.";
  #else
  HELP  "Tag identification number of the operation unit.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ueberwachungszeit            Doku-Nummer: 324   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE ueberwachungszeit
{
  #ifdef LABEL_DE_EN
  LABEL "Shed time" "|de|berwachungszeit";
  #else
  LABEL "Shed time";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "9.0f";
      EDIT_FORMAT    "9.0f";

      MIN_VALUE         0.0;
      MAX_VALUE 100000000.0;
  }
  CONSTANT_UNIT "s";

  #ifdef HELP_DE_EN
  HELP "Shed time" "|de|berwachungszeit";
  #else
  HELP "Shed time";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraetesperre                Doku-Nummer: 332   EB-Code: 3    */
/* ------------------------------------------------------------------------ */
VARIABLE geraetesperre
{
  #ifdef LABEL_DE_EN
  LABEL "Lock device" "|de|Gertesperre";
  #else
  LABEL "Lock device";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  LOCKING_DEVICE;
  #ifdef LABEL_DE_EN
    { UNLOCKING_DEVICE, "Unlocked" "|de|Freigegeben" },
    { LOCKING_DEVICE,   "Locked"   "|de|Gesperrt"    }
  #else
    { UNLOCKING_DEVICE, "Unlocked" },
    { LOCKING_DEVICE,   "Locked"   }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "State local operation." "|de|Status Vor-Ort-Bedienung.";
  #else
  HELP "State local operation." ;
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zertifizierung               Doku-Nummer: 333   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zertifizierung
{
  #ifdef LABEL_DE_EN
  LABEL "Certification" "|de|Zertifizierung";
  #else
  LABEL "Certification";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    {   0, "Not present" "|de|Nicht vorhanden" },
    {   1, "Present" "|de|Vorhanden"   },
    {   2, "Present" "|de|Vorhanden"   },
    {   3, "Present" "|de|Vorhanden"   },
    {   4, "Present" "|de|Vorhanden"   },
    {   5, "Present" "|de|Vorhanden"   },
    {   6, "Present" "|de|Vorhanden"   },
    {   7, "Present" "|de|Vorhanden"   },
    {   8, "Present" "|de|Vorhanden"   },
    {   9, "Present" "|de|Vorhanden"   },
    {  10, "Present" "|de|Vorhanden"   },
    {  11, "Present" "|de|Vorhanden"   },
    {  12, "Present" "|de|Vorhanden"   },
    {  13, "Present" "|de|Vorhanden"   },
    {  14, "Present" "|de|Vorhanden"   },
    {  15, "Present" "|de|Vorhanden"   },
    {  16, "Present" "|de|Vorhanden"   },
    {  17, "Present" "|de|Vorhanden"   },
    {  18, "Present" "|de|Vorhanden"   },
    {  19, "Present" "|de|Vorhanden"   },
    {  20, "Present" "|de|Vorhanden"   },
    {  21, "Present" "|de|Vorhanden"   },
    {  22, "Present" "|de|Vorhanden"   },
    {  23, "Present" "|de|Vorhanden"   },
    {  24, "Present" "|de|Vorhanden"   },
    {  25, "Present" "|de|Vorhanden"   },
    {  26, "Present" "|de|Vorhanden"   },
    {  27, "Present" "|de|Vorhanden"   },
    {  28, "Present" "|de|Vorhanden"   },
    {  29, "Present" "|de|Vorhanden"   },
    {  30, "Present" "|de|Vorhanden"   },
    {  31, "Present" "|de|Vorhanden"   },
    {  32, "Present" "|de|Vorhanden"   },
    {  33, "Present" "|de|Vorhanden"   },
    {  34, "Present" "|de|Vorhanden"   },
    {  35, "Present" "|de|Vorhanden"   },
    {  36, "Present" "|de|Vorhanden"   },
    {  37, "Present" "|de|Vorhanden"   },
    {  38, "Present" "|de|Vorhanden"   },
    {  39, "Present" "|de|Vorhanden"   },
    {  40, "Present" "|de|Vorhanden"   },
    {  41, "Present" "|de|Vorhanden"   },
    {  42, "Present" "|de|Vorhanden"   },
    {  43, "Present" "|de|Vorhanden"   },
    {  44, "Present" "|de|Vorhanden"   },
    {  45, "Present" "|de|Vorhanden"   },
    {  46, "Present" "|de|Vorhanden"   },
    {  47, "Present" "|de|Vorhanden"   },
    {  48, "Present" "|de|Vorhanden"   },
    {  49, "Present" "|de|Vorhanden"   },
    {  50, "Present" "|de|Vorhanden"   },
    {  51, "Present" "|de|Vorhanden"   },
    {  52, "Present" "|de|Vorhanden"   },
    {  53, "Present" "|de|Vorhanden"   },
    {  54, "Present" "|de|Vorhanden"   },
    {  55, "Present" "|de|Vorhanden"   },
    {  56, "Present" "|de|Vorhanden"   },
    {  57, "Present" "|de|Vorhanden"   },
    {  58, "Present" "|de|Vorhanden"   },
    {  59, "Present" "|de|Vorhanden"   },
    {  60, "Present" "|de|Vorhanden"   },
    {  61, "Present" "|de|Vorhanden"   },
    {  62, "Present" "|de|Vorhanden"   },
    {  63, "Present" "|de|Vorhanden"   },
    {  64, "Present" "|de|Vorhanden"   },
    {  65, "Present" "|de|Vorhanden"   },
    {  66, "Present" "|de|Vorhanden"   },
    {  67, "Present" "|de|Vorhanden"   },
    {  68, "Present" "|de|Vorhanden"   },
    {  69, "Present" "|de|Vorhanden"   },
    {  70, "Present" "|de|Vorhanden"   },
    {  71, "Present" "|de|Vorhanden"   },
    {  72, "Present" "|de|Vorhanden"   },
    {  73, "Present" "|de|Vorhanden"   },
    {  74, "Present" "|de|Vorhanden"   },
    {  75, "Present" "|de|Vorhanden"   },
    {  76, "Present" "|de|Vorhanden"   },
    {  77, "Present" "|de|Vorhanden"   },
    {  78, "Present" "|de|Vorhanden"   },
    {  79, "Present" "|de|Vorhanden"   },
    {  80, "Present" "|de|Vorhanden"   },
    {  81, "Present" "|de|Vorhanden"   },
    {  82, "Present" "|de|Vorhanden"   },
    {  83, "Present" "|de|Vorhanden"   },
    {  84, "Present" "|de|Vorhanden"   },
    {  85, "Present" "|de|Vorhanden"   },
    {  86, "Present" "|de|Vorhanden"   },
    {  87, "Present" "|de|Vorhanden"   },
    {  88, "Present" "|de|Vorhanden"   },
    {  89, "Present" "|de|Vorhanden"   },
    {  90, "Present" "|de|Vorhanden"   },
    {  91, "Present" "|de|Vorhanden"   },
    {  92, "Present" "|de|Vorhanden"   },
    {  93, "Present" "|de|Vorhanden"   },
    {  94, "Present" "|de|Vorhanden"   },
    {  95, "Present" "|de|Vorhanden"   },
    {  96, "Present" "|de|Vorhanden"   },
    {  97, "Present" "|de|Vorhanden"   },
    {  98, "Present" "|de|Vorhanden"   },
    {  99, "Present" "|de|Vorhanden"   },
    { 255, "Not valid" "|de|Ungltig"  }
  #else
    {   0, "Not present" },
    {   1, "Present"     },
    {   2, "Present"     },
    {   3, "Present"     },
    {   4, "Present"     },
    {   5, "Present"     },
    {   6, "Present"     },
    {   7, "Present"     },
    {   8, "Present"     },
    {   9, "Present"     },
    {  10, "Present"     },
    {  11, "Present"     },
    {  12, "Present"     },
    {  13, "Present"     },
    {  14, "Present"     },
    {  15, "Present"     },
    {  16, "Present"     },
    {  17, "Present"     },
    {  18, "Present"     },
    {  19, "Present"     },
    {  20, "Present"     },
    {  21, "Present"     },
    {  22, "Present"     },
    {  23, "Present"     },
    {  24, "Present"     },
    {  25, "Present"     },
    {  26, "Present"     },
    {  27, "Present"     },
    {  28, "Present"     },
    {  29, "Present"     },
    {  30, "Present"     },
    {  31, "Present"     },
    {  32, "Present"     },
    {  33, "Present"     },
    {  34, "Present"     },
    {  35, "Present"     },
    {  36, "Present"     },
    {  37, "Present"     },
    {  38, "Present"     },
    {  39, "Present"     },
    {  40, "Present"     },
    {  41, "Present"     },
    {  42, "Present"     },
    {  43, "Present"     },
    {  44, "Present"     },
    {  45, "Present"     },
    {  46, "Present"     },
    {  47, "Present"     },
    {  48, "Present"     },
    {  49, "Present"     },
    {  50, "Present"     },
    {  51, "Present"     },
    {  52, "Present"     },
    {  53, "Present"     },
    {  54, "Present"     },
    {  55, "Present"     },
    {  56, "Present"     },
    {  57, "Present"     },
    {  58, "Present"     },
    {  59, "Present"     },
    {  60, "Present"     },
    {  61, "Present"     },
    {  62, "Present"     },
    {  63, "Present"     },
    {  64, "Present"     },
    {  65, "Present"     },
    {  66, "Present"     },
    {  67, "Present"     },
    {  68, "Present"     },
    {  69, "Present"     },
    {  70, "Present"     },
    {  71, "Present"     },
    {  72, "Present"     },
    {  73, "Present"     },
    {  74, "Present"     },
    {  75, "Present"     },
    {  76, "Present"     },
    {  77, "Present"     },
    {  78, "Present"     },
    {  79, "Present"     },
    {  80, "Present"     },
    {  81, "Present"     },
    {  82, "Present"     },
    {  83, "Present"     },
    {  84, "Present"     },
    {  85, "Present"     },
    {  86, "Present"     },
    {  87, "Present"     },
    {  88, "Present"     },
    {  89, "Present"     },
    {  90, "Present"     },
    {  91, "Present"     },
    {  92, "Present"     },
    {  93, "Present"     },
    {  94, "Present"     },
    {  95, "Present"     },
    {  96, "Present"     },
    {  97, "Present"     },
    {  98, "Present"     },
    {  99, "Present"     },
    { 255, "Not valid"   }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Determines whether or not the positioner is suitable for hazardous areas."
       "|de|Gibt an, ob der Stellungsregler in explosionsgefhrdeten "
       "Bereichen eingesetzt werden kann.";
  #else
  HELP "Determines whether or not the positioner is suitable for hazardous areas.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Bauart                       Doku-Nummer: 334   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE bauart
{
  #ifdef LABEL_DE_EN
  LABEL "Model" "|de|Bauart";
  #else
  LABEL "Model";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Single acting" "|de|Einfach wirkend" },
    { 1, "Double acting" "|de|Doppelt wirkend" }
  #else
    { 0, "Single acting" },
    { 1, "Double acting" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Actuator with or without spring loading."
       "|de|Antrieb mit oder ohne Federrckstellung.";
  #else
  HELP "Actuator with or without spring loading.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Anbau                        Doku-Nummer: 335   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE anbau
{
  #ifdef LABEL_DE_EN
  LABEL "Attachment" "|de|Anbau";
  #else
  LABEL "Attachment";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "Integrated" "|de|Integriert" },
    { 1, "NAMUR"      "|de|NAMUR"      }
  #else
    { 0, "Integrated" },
    { 1, "NAMUR"      }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Defines positioner attachment to the control valve."
       "|de|Definiert den Anbau des Stellungsreglers an das Stellventil.";
  #else
  HELP "Defines positioner attachment to the control valve.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: HART-Schreibschutz           Doku-Nummer: 336   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE hart_schreibschutz
{
  #ifdef LABEL_DE_EN
  LABEL "HART write protection" "|de|HART-Schreibschutz";
  #else
  LABEL "HART write protection";
  #endif

  CLASS DEVICE;
/* kmr: hier nur lesbar machen */
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Not write protected" "|de|Nicht schreibgeschtzt" },
    { 1, "Write protected"     "|de|Schreibgeschtzt"       }
  #else
    { 0, "Not write protected" },
    { 1, "Write protected"     }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "HART write protection for all HART commands."
       "|de|Schreibschutz fr alle HART-Kommandos.";
  #else
  HELP "HART write protection for all HART commands.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Status Initialisierung       Doku-Nummer: 337   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE status_init
{
  #ifdef LABEL_DE_EN
  LABEL "Status initialization" "|de|Status Initialisierung";
  #else
  LABEL "Status initialization";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    {   0, "Not active"               "|de|Nicht aktiv"                },
    {   1, "Running"                  "|de|Luft"                      },
    {   2, "Test aborted"             "|de|Test abgebrochen"           },
    {  16, "Zero point adjustment"    "|de|Nullpunktabgleich"          },
    {  17, "Maximum point adjustment" "|de|Maximalpunktabgleich"       },
    {  18, "Detection of mech. stops" "|de|Ermittlung mech. Anschlge" },
    {  19, "Controller optimization"  "|de|Regleroptimierung"          },
    {  20, "Fine adjustment"          "|de|Feinabgleich"               },
    {  21, "Step 1 (step response)"   "|de|Sprung 1 (Sprungantwort)"   },
    {  23, "Step 2 (step response)"   "|de|Sprung 2 (Sprungantwort)"   },
    {  30, "Reference drive signal y steady (d1) active"
           "|de|Referenzlauf Stellsignal y Stationr (d1) aktiv"                    },
    {  31, "Reference drive signal y hysteresis (d2) active"
           "|de|Referenzlauf Stellsignal y Hysterese (d2) aktiv"                    },
    {  32, "Static characteristic (d3) active" "|de|Statische Kennlinie (d3) aktiv" },
    {  33, "Step response (d4) active"         "|de|Sprungantwort (d4) aktiv"       },
    {  34, "Hysteresis test (d5) active"       "|de|Hysterese Test (d5) aktiv"      },
    {  41, "Step 1 (step response)"            "|de|Sprung 1 (Sprungantwort)"       },
    {  43, "Step 1 (step response)"            "|de|Sprung 2 (Sprungantwort)"       },
    { 254, "Terminated"                        "|de|Beendet"                        }
  #else
    {   0, "Not active"               },
    {   1, "Running"                  },
    {   2, "Test aborted"             },
    {  16, "Zero point adjustment"    },
    {  17, "Maximum point adjustment" },
    {  18, "Detection of mech. stops" },
    {  19, "Controller optimization"  },
    {  20, "Fine adjustment"          },
    {  21, "Step 1 (step response)"   },
    {  23, "Step 2 (step response)"   },
    {  30, "Reference drive signal y steady (d1) active"     },
    {  31, "Reference drive signal y hysteresis (d2) active" },
    {  32, "Static characteristic (d3) active" },
    {  33, "Step response (d4) active"         },
    {  34, "Hysteresis test (d5) active"       },
    {  41, "Step 1 (step response)"            },
    {  43, "Step 1 (step response)"            },
    { 254, "Terminated"                        }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Status of the running calibration sequence."
       "|de|Status der laufenden Kalibrierung.";
  #else
  HELP "Status of the running calibration sequence.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Fuehrungsgroesse w [mA]      Doku-Nummer: 338   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE w_ma
{
  #ifdef LABEL_DE_EN
  LABEL "Reference var. w" "|de|Fhrungsgre w";
  #else
  LABEL "Reference var. w";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";
  }
  CONSTANT_UNIT "mA";

  #ifdef HELP_DE_EN
  HELP "Current input signal in mA; used as reference variable w "
       "in mode AUTOMATIC."
       "|de|Stromeingang in mA, dient in Betriebsart Automatik als "
       "Fhrungsgre.";
  #else
  HELP "Current input signal in mA; used as reference variable w "
       "in mode AUTOMATIC.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: w-Bereich Anfang [mA]        Doku-Nummer: 339   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE w_ma_bereich_anfang
{
  #ifdef LABEL_DE_EN
  LABEL "Reference var. range start" "|de|Fhrungsgrenbereich Anfang";
  #else
  LABEL "Reference var. range start";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  4.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  4.0;
      MAX_VALUE 16.0; /* 4mA (25%) unter w_ma_bereich_ende */
  }
  CONSTANT_UNIT "mA";

  #ifdef HELP_DE_EN
  HELP "Lower range value of the valid reference variable range."
       "|de|Anfangswert des gltigen Fhrungsgrenbereiches.";
  #else
  HELP "Lower range value of the valid reference variable range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: w-Bereich Ende [mA]          Doku-Nummer: 340   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE w_ma_bereich_ende
{
  #ifdef LABEL_DE_EN
  LABEL "Reference var. range end" "|de|Fhrungsgrenbereich Ende";
  #else
  LABEL "Reference var. range end";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE FLOAT
  {
      DEFAULT_VALUE  20.0;
      DISPLAY_FORMAT "4.1f";
      EDIT_FORMAT    "4.1f";

      MIN_VALUE  8.0;  /* 4mA (25%) ber w_ma_bereich_anfang */
      MAX_VALUE 20.0;
  }
  CONSTANT_UNIT "mA";

  #ifdef HELP_DE_EN
  HELP "Upper range value of the valid reference variable range."
       "|de|Endwert des gltigen Fhrungsgrenbereiches.";
  #else
  HELP "Upper range value of the valid reference variable range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung primaere Variable  Doku-Nummer: 341   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_prim_var
{
  #ifdef LABEL_DE_EN
  LABEL "Assignment primary variable" "|de|Zuordnung primre Variable";
  #else
  LABEL "Assignment primary variable";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Control value"      "|de|Fhrungsgre %"     },
    { 1, "Valve setpoint"     "|de|Ventilsollwert"      },
    { 2, "Target position"    "|de|Zielposition"        },
    { 3, "Valve position"     "|de|Ventilposition"      },
    { 4, "Setpoint deviation e" "|de|Regelabweichung e" },
    { 5, "Total valve travel" "|de|Wegintegral"         }
  #else
    { 0, "Control value"      },
    { 1, "Valve setpoint"     },
    { 2, "Target position"    },
    { 3, "Valve position"     },
    { 4, "Setpoint deviation e" },
    { 5, "Total valve travel" }
  #endif
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung sekundaere Var.    Doku-Nummer: 342   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_sek_var
{
  #ifdef LABEL_DE_EN
  LABEL "Assignment secondary variable" "|de|Zuordnung sekundre Variable";
  #else
  LABEL "Assignment secondary variable";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Control value"      "|de|Fhrungsgre %"     },
    { 1, "Valve setpoint"     "|de|Ventilsollwert"      },
    { 2, "Target position"    "|de|Zielposition"        },
    { 3, "Valve position"     "|de|Ventilposition"      },
    { 4, "Setpoint deviation e" "|de|Regelabweichung e" },
    { 5, "Total valve travel" "|de|Wegintegral"         }
  #else
    { 0, "Control value"      },
    { 1, "Valve setpoint"     },
    { 2, "Target position"    },
    { 3, "Valve position"     },
    { 4, "Setpoint deviation e" },
    { 5, "Total valve travel" }
  #endif
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung tertiaere Var.     Doku-Nummer: 343   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_tert_var
{
  #ifdef LABEL_DE_EN
  LABEL "Assignment tertiary variable" "|de|Zuordnung tertire Variable";
  #else
  LABEL "Assignment tertiary variable";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Control value"      "|de|Fhrungsgre %"     },
    { 1, "Valve setpoint"     "|de|Ventilsollwert"      },
    { 2, "Target position"    "|de|Zielposition"        },
    { 3, "Valve position"     "|de|Ventilposition"      },
    { 4, "Setpoint deviation e" "|de|Regelabweichung e" },
    { 5, "Total valve travel" "|de|Wegintegral"         }
  #else
    { 0, "Control value"      },
    { 1, "Valve setpoint"     },
    { 2, "Target position"    },
    { 3, "Valve position"     },
    { 4, "Setpoint deviation e" },
    { 5, "Total valve travel" }
  #endif
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Zuordnung quartaere Var.     Doku-Nummer: 344   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE zuordnung_quart_var
{
  #ifdef LABEL_DE_EN
  LABEL "Assignment quaternary variable" "|de|Zuordnung quartre Variable";
  #else
  LABEL "Assignment quaternary variable";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "Control value"      "|de|Fhrungsgre %"     },
    { 1, "Valve setpoint"     "|de|Ventilsollwert"      },
    { 2, "Target position"    "|de|Zielposition"        },
    { 3, "Valve position"     "|de|Ventilposition"      },
    { 4, "Setpoint deviation e" "|de|Regelabweichung e" },
    { 5, "Total valve travel" "|de|Wegintegral"         }
  #else
    { 0, "Control value"        },
    { 1, "Valve setpoint"       },
    { 2, "Target position"      },
    { 3, "Valve position"       },
    { 4, "Setpoint deviation e" },
    { 5, "Total valve travel"   }
  #endif
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Firmware Version             Doku-Nummer: 50/345 EB-Code: --  */
/* ------------------------------------------------------------------------ */
VARIABLE firmware_version
{
  #ifdef LABEL_DE_EN
  LABEL "Software revision" "|de|Firmware Version";
  #else
  LABEL "Software revision";
  #endif

  CLASS DEVICE;
  HANDLING READ;
  TYPE ASCII (8);

  #ifdef HELP_DE_EN
  HELP "Indicates the current firmware version of the device."
       "|de|Aktuelle Firmware Version des Gertes.";
  #else
  HELP "Indicates the current firmware version of the device.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Aktuelle Betriebsart         Doku-Nummer: 109/349 EB-Code: -- */
/* ------------------------------------------------------------------------ */
VARIABLE akt_betriebsart
{
  #ifdef LABEL_DE_EN
  LABEL "Actual mode" "|de|Aktuelle Betriebsart";
  #else
  LABEL "Actual mode";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
      {  0, "Start-up"               "|de|Inbetriebnahme"      },
      {  1, "Initialization"         "|de|Initialisierung"     },
      {  2, "Automatic"              "|de|Automatik"           },
      {  3, "Automatic"              "|de|Automatik"           },
      {  4, "Manual"                 "|de|Hand"                },
      {  5, "Manual"                 "|de|Hand"                },
      {  6, "Manual"                 "|de|Hand"                },
      {  7, "Fail-safe position"     "|de|Sicherheitsstellung" },
      {  8, "Test mode"              "|de|Test-Modus"          },
      {  9, "Development mode"       "|de|Entwicklungs-Modus"  },
      { 10, "HART automatic control" "|de|HART-Regelung"       },
      { 11, "HART control"           "|de|HART-Steuerung"      },
/* die 33 ist willkuerlich gewaehlt, da der Regler im PST mode ueber HART
   hier nur Hand (5) sendet und PST per Methode generiert werden muss */
      { 33, "PST"                    "|de|PST"                 }
  #else
      {  0, "Start-up"               },
      {  1, "Initialization"         },
      {  2, "Automatic"              },
      {  3, "Automatic"              },
      {  4, "Manual"                 },
      {  5, "Manual"                 },
      {  6, "Manual"                 },
      {  7, "Fail-safe position"     },
      {  8, "Test mode"              },
      {  9, "Development mode"       },
      { 10, "HART automatic control" },
      { 11, "HART control"           },
      { 33, "PST"                    }
  #endif
  }

  POST_READ_ACTIONS
  {
    CALC_PST_MODE /* ermittle Betriebsart PST */
  }

  #ifdef HELP_DE_EN
  HELP "Shows the actual operating mode of the device."
	   "|de|Anzeige der aktuellen Betriebsart des Gertes.";
  #else
  HELP "Shows the actual operating mode of the device.";
  #endif
}


/* ------------------------------------------------------------------------ */
/* Parameter: Verhalten bei Pistenausfall  Doku-Nummer: ---   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE wegaufnehmerausfall
{
  #ifdef LABEL_DE_EN
  LABEL "Position sensor failure control" "|de|Verhalten Wegaufnehmerausfall";
  #else
  LABEL "Position sensor failure control";
  #endif

  CLASS DEVICE;
  HANDLING READ&WRITE;
  TYPE ENUMERATED
  {
      DEFAULT_VALUE  0; /* bei interner Piste */
  #ifdef LABEL_DE_EN
      {  0, "Emergency mode"     "|de|Notlaufeigenschaft"  },
      {  1, "Fail safe position" "|de|Sicherheitsstellung" }
  #else
      {  0, "Emergency mode"     },
      {  1, "Fail safe position" }
  #endif
  }

  #ifdef HELP_DE_EN
  HELP "Determines the action of the positioner at failure of the position sensor."
       "|de|Bestimmt das Verhalten des Stellungsreglers bei Ausfall des Wegaufnehmers.";
  #else
  HELP "Determines the action of the positioner at failure of the position sensor.";
  #endif

  /* nur bei EXPERT+ aber nicht bei PST ! */
  VALIDITY_ONLY_EXPERT_PLUS_NO_PST
}


/* ------------------------------------------------------------------------ */
/* ARRAYs: static_param, static_enums, user_text                            */
/*         Indices nach Parameter-Nummer der Dokumentation                  */
/* ------------------------------------------------------------------------ */
/* fuer cmd 128 (Lesen) und 129 (Schreiben) */
ARRAY OF VARIABLE static_param /* float/integer */
{
    ELEMENTS
    {                                   /* Para.-Nr. (Doku): */
        1, zero_point_limit         ;   /*        */
        7, antriebsdruck            ;   /*   51   */
        9, w_hand                   ;   /*    2   */
       10, nennbereich              ;   /*    6/54 (gew. und erm. Nennbereich) */
       /* 11, antriebswirkflaeche      ; siehe cmd 147/148 */  /*  153   */
       12, stelldruckbereich_anfang ;   /*  154   */
       13, stelldruckbereich_ende   ;   /*  155   */
       14, versorgungsdruck         ;   /*  156   */
       15, nennweite_dn             ;   /*  164   */
       16, kvs_wert                 ;   /*  166   */
       17, sitzdurchmesser_ventil   ;   /*  167   */
       24, x0                       ;   /*  111   */
       25, x1                       ;   /*  112   */
       26, x2                       ;   /*  113   */
       27, x3                       ;   /*  114   */
       28, x4                       ;   /*  115   */
       29, x5                       ;   /*  116   */
       30, x6                       ;   /*  117   */
       31, x7                       ;   /*  118   */
       32, x8                       ;   /*  119   */
       33, x9                       ;   /*  120   */
       34, x10                      ;   /*  121   */
       35, y0                       ;   /*  122   */
       36, y1                       ;   /*  123   */
       37, y2                       ;   /*  124   */
       38, y3                       ;   /*  125   */
       39, y4                       ;   /*  126   */
       40, y5                       ;   /*  127   */
       41, y6                       ;   /*  128   */
       42, y7                       ;   /*  129   */
       43, y8                       ;   /*  130   */
       44, y9                       ;   /*  131   */
       45, y10                      ;   /*  132   */
       47, wegintegral              ;   /*   28   */
       48, grenzwert_a1             ;   /*   32   */
       49, grenzwert_a2             ;   /*   34   */
       51, test_stellmelder         ;   /*   38   */
       52, min_laufzeit_zu          ;   /*   48   */
       55, min_laufzeit_auf         ;   /*   47   */
       58, toleranzband             ;   /*   24   */
       60, gw_wegintegral           ;   /*   29   */
       70, blockierstellung         ;   /*   42   */
       71, regeldifferenz           ;   /*   46   */
       72, device_id                ;   /*  106   */
       73, nachlaufzeit             ;   /*  133   */
      100, w_ma_bereich_anfang      ;   /*  339   */
      101, w_ma_bereich_ende        ;   /*  340   */
      102, ueberwachungszeit        ;   /*  324   */
      103, endlage_w_kleiner        ;   /*   18   */
      104, endlage_w_groesser       ;   /*   20   */
      105, gew_laufzeit_auf         ;   /*   26   */
      106, gew_laufzeit_zu          ;   /*   27   */
      107, x_bereich_anfang         ;   /*    9   */
      108, x_bereich_ende           ;   /*   10   */
      109, x_begrenzung_unten       ;   /*   12   */
      110, x_begrenzung_oben        ;   /*   14   */
    }
}

/* -------------------------------------------------------------------------- */
/* fuer cmd 130 (Lesen) und 131 (Schreiben) */
ARRAY OF VARIABLE static_enums /* combobox */
{
    ELEMENTS
    {
    IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
        ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ))
    {
       49, wegaufnehmerausfall        ;    /*       */
       52, counter_init_start         ;    /*       */
       56, anzahl_np                  ;    /* 175   */
       57, initialisierungsart        ;    /*   7   */
       58, geraetetyp                 ;    /* 148   */
       59, geraetesperre              ;    /* 332   */
       60, bewegungsrichtung          ;    /*   8   */
       61, gew_betriebsart            ;    /*   1/350 */
       62, kennlinienauswahl          ;    /*  25   */
       63, booster                    ;    /* 152   */
       64, fliessrichtung             ;    /* 158   */
       65, stangenabdichtung          ;    /* 159   */
       66, dichtkante                 ;    /* 160   */
       67, druckentlastung            ;    /* 161   */
       68, kennlinie_kegel            ;    /* 162   */
       69, nennweiten_norm            ;    /* 163   */
       70, kvs_einheit                ;    /* 165   */
       71, stoerung_vorhanden         ;    /* 144   */
       72, stiftposition              ;    /*   5   */
       73, stellungsmelder            ;    /*  44   */
       75, ind_grenzkontakt           ;    /*  45   */
       77, stoerm_sonderfunktion      ;    /*  39   */
       79, stoerm_wegintegral         ;    /*  40   */
       80, wirkr_stellmelder          ;    /*  36   */
       81, status_a1                  ;    /* 141   */
       82, status_a2                  ;    /* 143   */
       83, zertifizierung             ;    /* 333   */
       84, bauart                     ;    /* 334   */
       85, anbau                      ;    /* 335   */
       86, akt_betriebsart            ;    /* 109/349 */
       87, sicherheitsstellung        ;    /* 134   */
       88, x_unterschreitet_a1        ;    /* 140   */
       89, x_ueberschreitet_a2        ;    /* 142   */
       93, hart_schreibschutz         ;    /* 336   */
       94, geraet_ini                 ;    /* 145   */
      101, aktiv_endlage_w_kleiner    ;    /*  17   */
      102, aktiv_endlage_w_groesser   ;    /*  19   */
      103, aktiv_x_begrenzung_unten   ;    /*  11   */
      104, aktiv_x_begrenzung_oben    ;    /*  13   */
      105, kp_stufe                   ;    /*  22   */
      106, tv_stufe                   ;    /*  23   */
      107, aktiv_gw_a1                ;    /*  31   */
      108, aktiv_gw_a2                ;    /*  33   */
      109, leserichtung               ;    /*   3   */
      110, alarmmodus                 ;    /*  30   */
      111, druckgrenze                ;    /*  21   */
      112, schliessrichtung           ;    /*  41   */
      113, stoerm_mit_stellmelder     ;    /*  37   */
      114, magnetventil               ;    /*  52   */
      115, zwangsentlueftung          ;    /* 138 Magnetventil */
      150, BA_vorhanden               ;    /*  fuer alarmmodus Lesen/Schreiben */
      /* kmr: mit 120-143 koennten die Fehlercodes (pro Fehler 1 Byte) eingelesen
         werden. Wird hier aber nicht verwendet, da mit cmd 48 eingelesen. */
    }
    ELSE
    {
       52, counter_init_start         ;    /*       */
       56, anzahl_np                  ;    /* 175   */
       57, initialisierungsart        ;    /*   7   */
       58, geraetetyp                 ;    /* 148   */
       59, geraetesperre              ;    /* 332   */
       60, bewegungsrichtung          ;    /*   8   */
       61, gew_betriebsart            ;    /*   1/350 */
       62, kennlinienauswahl          ;    /*  25   */
       63, booster                    ;    /* 152   */
       64, fliessrichtung             ;    /* 158   */
       65, stangenabdichtung          ;    /* 159   */
       66, dichtkante                 ;    /* 160   */
       67, druckentlastung            ;    /* 161   */
       68, kennlinie_kegel            ;    /* 162   */
       69, nennweiten_norm            ;    /* 163   */
       70, kvs_einheit                ;    /* 165   */
       71, stoerung_vorhanden         ;    /* 144   */
       72, stiftposition              ;    /*   5   */
       73, stellungsmelder            ;    /*  44   */
       75, ind_grenzkontakt           ;    /*  45   */
       77, stoerm_sonderfunktion      ;    /*  39   */
       79, stoerm_wegintegral         ;    /*  40   */
       80, wirkr_stellmelder          ;    /*  36   */
       81, status_a1                  ;    /* 141   */
       82, status_a2                  ;    /* 143   */
       83, zertifizierung             ;    /* 333   */
       84, bauart                     ;    /* 334   */
       85, anbau                      ;    /* 335   */
       86, akt_betriebsart            ;    /* 109/349 */
       87, sicherheitsstellung        ;    /* 134   */
       88, x_unterschreitet_a1        ;    /* 140   */
       89, x_ueberschreitet_a2        ;    /* 142   */
       93, hart_schreibschutz         ;    /* 336   */
       94, geraet_ini                 ;    /* 145   */
      101, aktiv_endlage_w_kleiner    ;    /*  17   */
      102, aktiv_endlage_w_groesser   ;    /*  19   */
      103, aktiv_x_begrenzung_unten   ;    /*  11   */
      104, aktiv_x_begrenzung_oben    ;    /*  13   */
      105, kp_stufe                   ;    /*  22   */
      106, tv_stufe                   ;    /*  23   */
      107, aktiv_gw_a1                ;    /*  31   */
      108, aktiv_gw_a2                ;    /*  33   */
      109, leserichtung               ;    /*   3   */
      110, alarmmodus                 ;    /*  30   */
      111, druckgrenze                ;    /*  21   */
      112, schliessrichtung           ;    /*  41   */
      113, stoerm_mit_stellmelder     ;    /*  37   */
      114, magnetventil               ;    /*  52   */
      115, zwangsentlueftung          ;    /* 138 Magnetventil */
      150, BA_vorhanden               ;    /*  fuer alarmmodus Lesen/Schreiben */
      /* kmr: mit 120-143 koennten die Fehlercodes (pro Fehler 1 Byte) eingelesen
         werden. Wird hier aber nicht verwendet, da mit cmd 48 eingelesen. */
    }
    }
}

/* ------------------------------------------------------------------------ */
ARRAY OF VARIABLE user_text
{
    ELEMENTS
    {                          /* Para#: */
         1, textfeld_1    ;    /* 103    */
         2, textfeld_2    ;    /* 104    */
         3, textfeld_3    ;    /* 105    */
         4, textfeld_4    ;    /* 146    */
         5, textfeld_5    ;    /* 147    */
         6, ident_antrieb ;    /* 151    */
         7, ident_ventil  ;    /* 157    */
    }
}

/* ------------------------------------------------------------------------ */
/* Variablen                                                                */
/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* PV, SV, TV, QV : dynamische Variablen                                    */
/* ------------------------------------------------------------------------ */
ARRAY OF COLLECTION dynamic_variables
{
    ELEMENTS
    { /* PRIMARY ist immer Fhrungsgre % (Ausgang Split Range) zugeordnet */
      PRIMARY    , transmitter_variables[0]                   , [primary]  ;
      SECONDARY  , transmitter_variables[zuordnung_sek_var]   , [secondary];
      TERTIARY   , transmitter_variables[zuordnung_tert_var]  , [tertiary] ;
      FOURTH     , transmitter_variables[zuordnung_quart_var] , [fourth]   ;
    }
}

/* ------------------------------------------------------------------------ */
/* Alle mgliche dynamische Variablen */
ARRAY OF COLLECTION transmitter_variables
{
    ELEMENTS
    {
      0, coll_ausgang_split_range; /* Ausg. Split-Range (Fhrungsgre %) */
      1, coll_ventilsollwert     ; /* Ventilsollwert    */
      2, coll_zielposition       ; /* Zielposition      */
      3, coll_ventilposition     ; /* Ventilposition    */
      4, coll_regeldifferenz     ; /* Regeldifferenz    */
      5, coll_wegintegral        ; /* Wegintegral       */
    }
}

/* ------------------------------------------------------------------------ */
/* Ausgang Split-Range (Fhrungsgre %) */
COLLECTION OF VARIABLE coll_ausgang_split_range
{
  LABEL " ";
  HELP  " ";
  MEMBERS
  {
	  DIGITAL_VALUE, ausgang_split_range;
	  DIGITAL_UNITS, dynamic_units;
	  ANALOG_VALUE , ausgang_split_range;

	  PERCENT_RANGE       , dummy_float;
	  MINIMUM_SPAN        , dummy_float;
	  ALARM_CODE          , dummy_enum;
	  TRANSFER_FUNCTION   , dummy_enum;
	  SENSOR_SERIAL_NUMBER, serial_no;
	  SENSOR_UNITS        , dynamic_units;
	  LOWER_SENSOR_LIMIT  , dummy_float;
	  UPPER_SENSOR_LIMIT  , dummy_float;
	  RANGE_UNITS         , dynamic_units;
	  LOWER_RANGE_VALUE   , lower_range_value;
	  UPPER_RANGE_VALUE   , upper_range_value;
	  DAMPING_VALUE       , dummy_float;
  }
}

/* Ventilsollwert */
COLLECTION OF VARIABLE coll_ventilsollwert
{
  LABEL " ";
  HELP  " ";
  MEMBERS
  {
    DIGITAL_VALUE, ventilsollwert;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , ventilsollwert;
  }
}

/* Zielposition */
COLLECTION OF VARIABLE coll_zielposition
{
  LABEL " ";
  HELP  " ";
  MEMBERS
  {
    DIGITAL_VALUE, zielposition;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , zielposition;
  }
}

/* Ventilposition */
COLLECTION OF VARIABLE coll_ventilposition
{
  LABEL " ";
  HELP  " ";
  MEMBERS
  {
    DIGITAL_VALUE, ventilposition;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , ventilposition;
  }
}

/* Regeldifferenz */
COLLECTION OF VARIABLE coll_regeldifferenz
{
  LABEL " ";
  HELP  " ";
  MEMBERS
  {
    DIGITAL_VALUE, regeldifferenz;
    DIGITAL_UNITS, dynamic_units;
    ANALOG_VALUE , regeldifferenz;
  }
}

/* Wegintegral */
COLLECTION OF VARIABLE coll_wegintegral
{
  LABEL " ";
  HELP  " ";
  MEMBERS
  {
    DIGITAL_VALUE, wegintegral;
    DIGITAL_UNITS, dummy_enum;
    ANALOG_VALUE , wegintegral;
  }
}

/* ------------------------------------------------------------------------ */
/* Primary Variable                                                         */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE sollwert
{
    MEMBERS
    {
	  DIGITAL_VALUE, sollwert_value;
	  DIGITAL_UNITS, dynamic_units;
	  ANALOG_VALUE, sollwert_analog_value;
	  PERCENT_RANGE, dummy_float;
	  MINIMUM_SPAN, dummy_float;
	  ALARM_CODE, dummy_enum;
	  TRANSFER_FUNCTION, dummy_enum;
	  SENSOR_SERIAL_NUMBER, serial_no;
	  SENSOR_UNITS, dynamic_units;
	  LOWER_SENSOR_LIMIT, dummy_float;
	  UPPER_SENSOR_LIMIT, dummy_float;
	  RANGE_UNITS, dynamic_units;
	  LOWER_RANGE_VALUE, lower_range_value;
	  UPPER_RANGE_VALUE, upper_range_value;
	  DAMPING_VALUE, dummy_float;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE sollwert_value
{
  LABEL "w";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 120.0;
  }

  #ifdef HELP_DE_EN
  HELP "Reference variable (setpoint value) in % with consideration"
	   " to reference variable range."
	   "|de|Fhrungsgre in % unter Bercksichtigung von "
	   "Fhrungsgre Anfang und Ende.";
  #else
  HELP "Reference variable (setpoint value) in % with consideration"
	   " to reference variable range.";
  #endif
}

/* ------------------------------------------------------------------------ */
VARIABLE sollwert_analog_value
{
  LABEL "w_analog";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.2f";

      MIN_VALUE  3.00;
      MAX_VALUE 24.00;
  }
  CONSTANT_UNIT "mA";

  #ifdef HELP_DE_EN
  HELP "Current input signal in mA; used as reference variable w"
  	   " in 'Auto' mode."
  	   "|de|Stromeingang in mA, dient in Betriebsart 'Auto' als "
	   "Fhrungsgre.";
  #else
  HELP "Current input signal in mA; used as reference variable w"
  	   " in 'Auto' mode.";
  #endif
}

/* ------------------------------------------------------------------------ */
VARIABLE dynamic_units
{
  LABEL "units";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
      { 57, "%"}
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE serial_no
{
	LABEL [pv_sensor_serial_number];
    CLASS DEVICE;
	TYPE UNSIGNED_INTEGER (3)
	{
		DISPLAY_FORMAT  "7d";
		EDIT_FORMAT     "7d";
	}
}

/* ------------------------------------------------------------------------ */
VARIABLE upper_range_value
{
  LABEL "urv";
  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  HELP "Upper Range Value.";
}

/* ------------------------------------------------------------------------ */
VARIABLE lower_range_value
{
  LABEL "lrv";
  CLASS DEVICE;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  HELP "Lower Range Value.";
}

/* ------------------------------------------------------------------------ */
VARIABLE dummy_float
{
  LABEL "d_float";
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE dummy_enum
{
  LABEL "d_enum";
  TYPE ENUMERATED
  {
      { 0, " "}
  }
}

/* ------------------------------------------------------------------------ */
/* Secondary Variable                                                       */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE istwert
{
    MEMBERS
    {
	  DIGITAL_VALUE, istwert_value;
	  DIGITAL_UNITS, dynamic_units;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE istwert_value
{
  LABEL "x";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "5.1f";

      MIN_VALUE 0.0;
      MAX_VALUE 120.0;
  }

  #ifdef HELP_DE_EN
  HELP "Controlled variable (actual value) in % in reference to range"
       " of travel/opening angle."
       "|de|Regelgre in % bezogen auf Hub - /Drehwinkelbereich.";
  #else
  HELP "Controlled variable (actual value) in % in reference to range"
       " of travel/opening angle.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Tertiary Variable                                                        */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE regeldiff
{
    MEMBERS
    {
	  DIGITAL_VALUE, regeldiff_value;
	  DIGITAL_UNITS, dynamic_units;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE regeldiff_value
{
  LABEL "e (w-x)";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;

  TYPE FLOAT
  {
      DISPLAY_FORMAT "4.1f";

      MIN_VALUE   0.0;
      MAX_VALUE 120.0;
  }

  #ifdef HELP_DE_EN
  HELP "Control deviation; corresponds to error e = w - x."
       "|de|Regeldifferenz in %.";
  #else
  HELP "Control deviation; corresponds to error e = w - x.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Fourth Variable                                                          */
/* ------------------------------------------------------------------------ */
COLLECTION OF VARIABLE wegint
{
    MEMBERS
    {
	  DIGITAL_VALUE, summ_beweg_value;
	  DIGITAL_UNITS, summ_beweg_units;
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE summ_beweg_value
{
  #ifdef LABEL_DE_EN
  LABEL "Current value" "|de|Aktueller Wert";
  #else
  LABEL "Current value";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE FLOAT
  {
      DISPLAY_FORMAT "7.0f";
      MIN_VALUE 0.0;
      MAX_VALUE 16500000.0;
  }

  #ifdef HELP_DE_EN
  HELP "Valve travel summation in cycles of the rated travel."
	   "|de|Summe der Nennlastspiele.";
  #else
  HELP "Valve travel summation in cycles of the rated travel.";
  #endif
}

/* ------------------------------------------------------------------------ */
VARIABLE summ_beweg_units
{
  LABEL "units";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
      {251, " "}
  }
}

/* ------------------------------------------------------------------------ */
/* HART-Commands                                                            */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Common practice commands                                                 */
/* ------------------------------------------------------------------------ */
IMPORT STANDARD _COMMON_PRACTICE, DEVICE_REVISION 7, DD_REVISION 2
{
  VARIABLE response_preambles;
  VARIABLE transmitter_variable_code; /* fuer cmd 54 */

  /* CMD 35: Write Primary Variable Range Values */
  COMMAND write_pv_range_values;

  /* CMD 38: Reset Configuration Changed Flag */
  COMMAND reset_configuration_change_flag;

  /* CMD 48: Read Additional Device Status */
  COMMAND read_additional_transmitter_status;

  /* CMD 50: Read Transmitter Variable Assignments */
  COMMAND read_transmitter_variable_assignments;

  /* CMD 51: Write Transmitter Variable Assignments */
  COMMAND write_transmitter_variable_assignments;

  /* CMD 54: Read Transmitter Variable Information */
  COMMAND read_transmitter_variable_information;

  /* CMD 59: Write Number of Preambles */
  COMMAND write_number_of_response_preambles;

  VARIABLE xmtr_specific_status_0;
  VARIABLE xmtr_specific_status_1;
  VARIABLE xmtr_specific_status_2;
  VARIABLE xmtr_specific_status_3;
  VARIABLE xmtr_specific_status_4;
  VARIABLE xmtr_specific_status_5;
  VARIABLE operating_mode_1;
  VARIABLE operating_mode_2;
  VARIABLE analog_output_saturated1;
  VARIABLE analog_output_saturated2;
  VARIABLE analog_output_saturated3;
  VARIABLE analog_output_fixed1;
  VARIABLE analog_output_fixed2;
  VARIABLE analog_output_fixed3;
  VARIABLE xmtr_specific_status_6;
  VARIABLE xmtr_specific_status_7;
  VARIABLE xmtr_specific_status_8;

  /* ------------- */
  /* Redefinitions */
  /* ------------- */
  REDEFINITIONS
  {
    /* CMD 48: Read Additional Device Status */
    COMMAND read_additional_transmitter_status
    {
	  REDEFINE TRANSACTION
	  {
        REQUEST
        {}
        REPLY
        {
        	response_code, device_status,
            xmtr_specific_status_0,         /* Byte 0 (Fehlercode 0) */
			xmtr_specific_status_1,         /* Byte 1 (Fehlercode 1) */
			xmtr_specific_status_2,         /* Byte 2 (Fehlercode 2) */
			xmtr_specific_status_3,         /* Byte 3 (Fehlercode 3) */
			xmtr_specific_status_4,         /* Byte 4 (Kaltstart ausgefuehrt) */
			xmtr_specific_status_5,         /* Byte 5 (Ersatzabgleich/Geraet init.) */
			operating_mode_1,               /* Byte 6 (Wegintegral ueberschritten) (0/1) */
			operating_mode_2,               /* Byte 7     dummy (=0) */
			analog_output_saturated1,       /* Byte 8-10  dummy (=0) */
			analog_output_saturated2,
			analog_output_saturated3,
			analog_output_fixed1,           /* Byte 11-13 dummy (=0) */
			analog_output_fixed2,
			analog_output_fixed3,
			xmtr_specific_status_6,         /* Byte 14 (device_family_status_0) */
			xmtr_specific_status_7,         /* Byte 15 (device_family_status_1) */
			xmtr_specific_status_8,         /* Byte 16 (device_family_status_2) */

			namur_sammelstatus,             /* Byte 17 (NAMUR Sammelstatus (Ampel) */
			air_supply,                     /* Byte 18 (NAMUR Statusmeldungen erw. Diagnose) */
			actuator_spring,                /* Byte 19 */
			shifting_working_range,         /* Byte 20 */
			friction,                       /* Byte 21 */
			leakage_pneumatic,              /* Byte 22 */
			limit_working_range,            /* Byte 23 */
			dynamic_stress_factor,          /* Byte 24 */
			inner_leakage,                  /* Byte 25 */
			external_leakage,               /* Byte 26 */
			observing_end_position,         /* Byte 27 */
			connection_positioner_valve,    /* Byte 28 */
			working_range,                  /* Byte 29 */
			pst_emergency_shut_down         /* Byte 30 */
        }
	  }

	  REDEFINE RESPONSE_CODES
	  {
	  	 0, SUCCESS,            [no_command_specific_errors];
	  	 2,	DATA_ENTRY_ERROR,	[invalid_selection];
	  	 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	  	 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
	  	 5,	MISC_ERROR, 		[too_few_data_bytes_recieved];
	  	 6, MISC_ERROR,         [xmtr_specific_command_error];
	  	 7,	MODE_ERROR,	        [in_write_protect_mode];
	  	 8, MISC_WARNING,       [update_in_progress];
	  	 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
	  	10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
	  	11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
	  	12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
	  	13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
	  	14,	DATA_ENTRY_WARNING,	[span_too_small];
	  	16, MODE_ERROR,         [access_restricted];
	  }
    }

    /* CMD 50: Read Transmitter Variable Assignments */
    COMMAND read_transmitter_variable_assignments
    {
	  REDEFINE TRANSACTION
	  {
        REQUEST
        {}
        REPLY
        {
        	response_code, device_status,
        	zuordnung_prim_var, zuordnung_sek_var,
        	zuordnung_tert_var, zuordnung_quart_var
        }
	  }
    }

    /* CMD 51: Write Transmitter Variable Assignments */
    COMMAND write_transmitter_variable_assignments
    {
	  REDEFINE TRANSACTION
	  {
        REQUEST
        {
        	zuordnung_prim_var, zuordnung_sek_var,
        	zuordnung_tert_var, zuordnung_quart_var
        }
        REPLY
        {
        	response_code, device_status,
        	zuordnung_prim_var, zuordnung_sek_var,
        	zuordnung_tert_var, zuordnung_quart_var
        }
	  }
    }

    /* CMD 54: Read Transmitter Variable Information */
    COMMAND read_transmitter_variable_information
    {
	  REDEFINE TRANSACTION
	  {
		REQUEST
		{
			transmitter_variable_code (INFO,INDEX)
		}

		REPLY
		{
			response_code, device_status
            transmitter_variable_code,
			transmitter_variables[transmitter_variable_code].SENSOR_SERIAL_NUMBER,
			transmitter_variables[transmitter_variable_code].SENSOR_UNITS,
			transmitter_variables[transmitter_variable_code].UPPER_SENSOR_LIMIT,
			transmitter_variables[transmitter_variable_code].LOWER_SENSOR_LIMIT,
			transmitter_variables[transmitter_variable_code].DAMPING_VALUE,
			transmitter_variables[transmitter_variable_code].MINIMUM_SPAN
		}
	  }
    }

    /* ----------------------------------- */
	/* Parameter fuer cmd 48 redefinieren: */
    /* ----------------------------------- */
/* ------------------------------------------------------------------------ */
/* Parameter: Fehlercodes                 Doku-Nummer: 53    EB-Code: 50-75 */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_0
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Error codes byte 0" "|de|Fehlercodes Byte 0";
  #else
  REDEFINE LABEL "Error codes byte 0";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	  { 0x01, "x > range"
   	        "|de|x > Bereich",                        DATA }, /* Fehler 50 */
	  { 0x02, "Delta x < range"
   	        "|de|Delta x < Bereich",                  DATA }, /* Fehler 51 */
	  { 0x04, "Attachment"
   	        "|de|Anbau",                              DATA }, /* Fehler 52 */
	  { 0x08, "Initialization time exceeded"
   	        "|de|Initialisierungszeit berschritten", DATA }, /* Fehler 53 */
	  { 0x10, "Initialization / solenoid valve"
   	        "|de|Initialisierung / Magnetventil",     DATA }, /* Fehler 54 */
	  { 0x20, "Travel time too short"
   	        "|de|Laufzeit unterschritten",            DATA }, /* Fehler 55 */
	  { 0x40, "Pin position"
   	        "|de|Stiftposition",                      DATA }, /* Fehler 56 */
	  { 0x80, "Control loop"
   	        "|de|Regelkreis",                         DATA }  /* Fehler 57 */
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}

/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_1
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Error codes byte 1" "|de|Fehlercodes Byte 1";
  #else
  REDEFINE LABEL "Error codes byte 1";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	{ 0x01, "Zero point"
 	        "|de|Nullpunkt",      DATA }, /* Fehler 58 */
	{ 0x02, "Autocorrection"
 	        "|de|Autokorrektur",  DATA }, /* Fehler 59 */
	{ 0x04, "Fatal error"
 	        "|de|Fataler Fehler", DATA }, /* Fehler 60 */
	/*{ 0x08, "---"
 	        "|de|---",            DATA },    Fehler 61 */
	{ 0x10, "x-signal"
 	        "|de|x-Signal",       DATA }, /* Fehler 62 */
	{ 0x20, "W too small"
 	        "|de|W zu klein",     DATA }, /* Fehler 63 */
	{ 0x40, "i/p converter"
 	        "|de|i/p-Wandler",    DATA }, /* Fehler 64 */
	{ 0x80, "Hardware"
 	        "|de|Hardware",       DATA }  /* Fehler 65 */
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}

/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_2
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Error codes byte 2" "|de|Fehlercodes Byte 2";
  #else
  REDEFINE LABEL "Error codes byte 2";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	{ 0x01, "Data memory"
 	        "|de|Datenspeicher",           DATA }, /* Fehler 66 */
	{ 0x02, "Test calculation"
 	        "|de|Kontrollrechnung",        DATA }, /* Fehler 67 */
	{ 0x04, "Control parameter"
 	        "|de|Regelparameter",          DATA }, /* Fehler 68 */
	{ 0x08, "Poti parameter"
 	        "|de|Potiparameter",           DATA }, /* Fehler 69 */
	{ 0x10, "Configuration parameter"
 	        "|de|Abgleichparameter",       DATA }, /* Fehler 70 */
	{ 0x20, "General parameter"
 	        "|de|Allgemeine Parameter",    DATA }, /* Fehler 71 */
	/*{ 0x40, "---"
 	        "|de|---",                     DATA },    Fehler 72 */
	{ 0x80, "Internal device error 1"
 	        "|de|Interner Gertefehler 1", DATA }  /* Fehler 73 */
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}

/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_3
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Error codes byte 3" "|de|Fehlercodes Byte 3";
  #else
  REDEFINE LABEL "Error codes byte 3";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	{ 0x01, "HART parameter"
 	        "|de|HART Parameter",           DATA }, /* Fehler 74 */
	{ 0x02, "Info parameter"
 	        "|de|Info Parameter",           DATA }, /* Fehler 75 */
	{ 0x04, "No emergency mode"
 	        "|de|Keine Notlaufeigenschaft", DATA }, /* Fehler 76 */
	{ 0x08, "Program load error"
 	        "|de|Programmladefehler",       DATA }, /* Fehler 77 */
	{ 0x10, "Options parameter"
 	        "|de|Optionsparameter",         DATA }, /* Fehler 78 */

	{ 0x20, "Device status 3/20"
 	        "|de|Gertestatus 3/20",        DATA }, /* dummy */

	{ 0x40, "Diagnosis parameter"
 	        "|de|Diagnoseparameter",        DATA }, /* Fehler 80 */

	{ 0x80, "Device status 3/80"
 	        "|de|Gertestatus 3/80",        DATA }  /* dummy */
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Kaltstart ausgefuehrt        Doku-Nummer: 348   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_4
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Start with default values executed"
                 "|de|Start mit Defaultwerten ausgefhrt";
  #else
  REDEFINE LABEL "Start with default values executed";
  #endif

  REDEFINE CLASS DEVICE;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
    /* mit kontextsensitiver Hilfe */
    { 0x01, "Default values executed" "|de|Defaultwerte ausgefhrt",
            "Indicates whether a start with default values occurred."
            "|de|Zeigt an ob ein Start mit Defaultwerten ausgefhrt wurde."
                                         , DATA },

	{ 0x02, "Device status 4/02"
 	        "|de|Gertestatus 4/02",       DATA }, /* dummy */
	{ 0x04, "Device status 4/04"
 	        "|de|Gertestatus 4/04",       DATA }, /* dummy */
	{ 0x08, "Device status 4/08"
 	        "|de|Gertestatus 4/08",       DATA }, /* dummy */
	{ 0x10, "Device status 4/10"
 	        "|de|Gertestatus 4/10",       DATA }, /* dummy */
	{ 0x20, "Device status 4/20"
 	        "|de|Gertestatus 4/20",       DATA }, /* dummy */
	{ 0x40, "Device status 4/40"
 	        "|de|Gertestatus 4/40",       DATA }, /* dummy */
	{ 0x80, "Device status 4/80"
 	        "|de|Gertestatus 4/80",       DATA }  /* dummy */
  }

  /* Hilfe nur ber kontextsensitive Hilfe */
}

/* ------------------------------------------------------------------------ */
/* Parameter: Ersatzabgleich durchgefuehrt  Doku-Nummer: 135   EB-Code: --  */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_5
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Initialization" "|de|Initialisierung";
  #else
  REDEFINE LABEL "Initialization";
  #endif

  REDEFINE CLASS DEVICE;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
    { 0x01, "Device not initialized" "|de|Gert nicht initialisiert",           DATA },
    { 0x02, "Initialized in substitution mode" "|de|Ersatzabgleich durchgefhrt",
            "Indicates whether the substitution mode was executed."
            "|de|Anzeige ob der Ersatzabgleich (sub mode) durchgefhrt wurde.", DATA },

	{ 0x04, "Device status 5/04"
 	        "|de|Gertestatus 5/04",       DATA }, /* dummy */
	{ 0x08, "Device status 5/08"
 	        "|de|Gertestatus 5/08",       DATA }, /* dummy */
	{ 0x10, "Device status 5/10"
 	        "|de|Gertestatus 5/10",       DATA }, /* dummy */
	{ 0x20, "Device status 5/20"
 	        "|de|Gertestatus 5/20",       DATA }, /* dummy */
	{ 0x40, "Device status 5/40"
 	        "|de|Gertestatus 5/40",       DATA }, /* dummy */
	{ 0x80, "Device status 5/80"
 	        "|de|Gertestatus 5/80",       DATA }  /* dummy */
  }

  /* Hilfe nur ueber kontextsensitive Hilfe */
}

/* ------------------------------------------------------------------------ */
/* Parameter: Wegintegral ueberschritten   Doku-Nummer: 139   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE operating_mode_1
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Total valve travel limit exceeded" "|de|Wegintegral berschritten";
  #else
  REDEFINE LABEL "Total valve travel limit exceeded";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE ENUMERATED
  {
  #ifdef LABEL_DE_EN
    { 0, "No"  "|de|Nein" },
    { 1, "Yes" "|de|Ja"   }
  #else
    { 0, "No"  },
    { 1, "Yes" }
  #endif
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Status total valve travel limit."
                "|de|Status Grenzwert Wegintegral.";
  #else
  REDEFINE HELP "Status total valve travel limit.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: device family status 6       Doku-Nummer: 325   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_6
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Device status 0" "|de|Gertestatus 0";
  #else
  REDEFINE LABEL "Device status 0";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	{ 0x01, "Hardware failure electronics"
	        "|de|Hardwarefehler Elektronik",      DATA },
	{ 0x02, "Defective mechanics / pneumatics"
	        "|de|Fehler in Mechanik / Pneumatik", DATA },
	{ 0x04, "Device status 6/04"
 	        "|de|Gertestatus 6/04",              DATA }, /* dummy */
	{ 0x08, "Checksum error EEPROM"
	        "|de|Checksum error EEPROM",          DATA },
	{ 0x10, "Defective position transmitter"
	        "|de|Fehler in Wegaufnehmer",         DATA },
	{ 0x20, "Power supply failed"
	        "|de|Hilfsenergie zu gering",         DATA },
	{ 0x40, "Local operation active"
	        "|de|Vor-Ort-Bedienung aktiv",        DATA },
	{ 0x80, "Solenoid valve active"
	        "|de|Magnetventil aktiv",             DATA }
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: device family status 7       Doku-Nummer: 326   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_7
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Device status 1" "|de|Gertestatus 1";
  #else
  REDEFINE LABEL "Device status 1";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	{ 0x01, "Device not initialized"
	        "|de|Gert nicht initialisiert",         DATA },
	{ 0x02, "Initialization not successful"
	        "|de|Initialisierung nicht erfolgreich", DATA },
	{ 0x04, "Initialization is running"
	        "|de|Initialisierung luft",             DATA },
	{ 0x08, "Device status 7/08"
 	        "|de|Gertestatus 7/08",                 DATA }, /* dummy */
	{ 0x10, "User defined characteristic not valid"
	        "|de|Benutzerdef. Kennlinie ungltig",   DATA },

	{ 0x20, "Device status 7/20"
 	        "|de|Gertestatus 7/20",                 DATA }, /* dummy */
	{ 0x40, "Device status 7/40"
 	        "|de|Gertestatus 7/40",                 DATA }, /* dummy */
	{ 0x80, "Device status 7/80"
 	        "|de|Gertestatus 7/80",                 DATA }  /* dummy */
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: device family status 8       Doku-Nummer: 327   EB-Code: --   */
/* ------------------------------------------------------------------------ */
VARIABLE xmtr_specific_status_8
{
  #ifdef LABEL_DE_EN
  REDEFINE LABEL "Device status 2" "|de|Gertestatus 2";
  #else
  REDEFINE LABEL "Device status 2";
  #endif

  REDEFINE CLASS DEVICE&DYNAMIC;
  REDEFINE HANDLING READ;
  REDEFINE TYPE BIT_ENUMERATED (1)
  {
	{ 0x01, "Travel time too short"
	        "|de|Laufzeit zu kurz",          DATA },
	{ 0x02, "Control loop fault"
	        "|de|Regelkreis gestrt",        DATA },
	{ 0x04, "Zero point error"
	        "|de|Nullpunktfehler",           DATA },
	{ 0x08, "Device status 8/08"
 	        "|de|Gertestatus 8/08",         DATA }, /* dummy */
	{ 0x10, "Total valve travel exceeded"
	        "|de|Wegintegral berschritten", DATA },

	{ 0x20, "Device status 8/20"
 	        "|de|Gertestatus 8/20",         DATA }, /* dummy */
	{ 0x40, "Device status 8/40"
 	        "|de|Gertestatus 8/40",         DATA }, /* dummy */
	{ 0x80, "Device status 8/80"
 	        "|de|Gertestatus 8/80",         DATA }  /* dummy */
  }

  #ifdef HELP_DE_EN
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit."
                "|de|Zusammenfassung aller Fehlercodes. Bitweise codiert.";
  #else
  REDEFINE HELP "Summary of all error codes. Coded bit-by-bit.";
  #endif
}


/* Ende der Parameter-Redefinitionen fuer cmd 48 */


    /* ------------------------------------------------------------------------ */
    /* Parameter: Anzahl Praeambeln            Doku-Nummer: 331   EB-Code: --   */
    /* ------------------------------------------------------------------------ */
    VARIABLE response_preambles
    {
  #ifdef LABEL_DE_EN
      REDEFINE LABEL "Number of preambels" "|de|Anzahl Prambeln";
  #else
      REDEFINE LABEL "Number of preambels";
  #endif

      REDEFINE TYPE UNSIGNED_INTEGER (1)
      {
          DISPLAY_FORMAT "2d";
          EDIT_FORMAT    "2d";

          MIN_VALUE   5;
	      MAX_VALUE  20;
      }

  #ifdef HELP_DE_EN
      REDEFINE HELP "Number of preambels required from the control "
                    "station requested by the positioner."
                    "|de|Anzahl der bentigten Synchronisations - Bytes.";
  #else
      REDEFINE HELP "Number of preambels required from the control "
                    "station requested by the positioner.";
  #endif
    }
  }
}

/* ------------------------------------------------------------------------ */
/* Manufacturer specific commands                                           */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Command 128
   Command wird verwendet zum Lesen von vier float Variablen aus der Tabelle
   static_param.
   static_param_code1...4 dienen als Index in die Tabelle.                  */
/* ------------------------------------------------------------------------ */
COMMAND read_static_variables
{
  NUMBER 128;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  static_param_code1 (INFO, INDEX),
	  static_param_code2 (INFO, INDEX),
	  static_param_code3 (INFO, INDEX),
	  static_param_code4 (INFO, INDEX)
	}

    REPLY
	{
	  response_code, device_status,
	  static_param_code1,
	  static_param[static_param_code1],
	  static_param_code2,
	  static_param[static_param_code2],
	  static_param_code3,
	  static_param[static_param_code3],
	  static_param_code4,
	  static_param[static_param_code4]
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,	        [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 129
   Command wird verwendet zum Schreiben einer float Variablen aus der Tabelle
   static_param.
   static_param_code1 dient als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND write_static_variables
{
  NUMBER 129;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  static_param_code (INFO, INDEX),
	  static_param[static_param_code]
	}

    REPLY
	{
	  response_code, device_status,
	  static_param_code,
	  static_param[static_param_code]
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,	        [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
		65, MISC_ERROR,         "Characteristic could not been written."
		                        "|de|Kennlinie kann nicht geschrieben werden.";
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE static_param_code
{
  LABEL  "static";
  CLASS USER_INTERFACE;
  TYPE INDEX static_param;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_param_code1
{
  LABEL  "static1";
  CLASS USER_INTERFACE;
  TYPE INDEX static_param;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_param_code2
{
  LABEL  "static2";
  CLASS USER_INTERFACE;
  TYPE INDEX static_param;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_param_code3
{
  LABEL  "static3";
  CLASS USER_INTERFACE;
  TYPE INDEX static_param;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_param_code4
{
  LABEL  "static4";
  CLASS USER_INTERFACE;
  TYPE INDEX static_param;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
/* Command 130
   Command wird verwendet zum Lesen von vier enum. Variablen aus der Tabelle
   static_enums.
   static_enums_code1...4 dienen als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND read_enums
{
  NUMBER 130;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  static_enums_code1 (INFO, INDEX),
	  static_enums_code2 (INFO, INDEX),
	  static_enums_code3 (INFO, INDEX),
	  static_enums_code4 (INFO, INDEX)
	}

    REPLY
	{
	  response_code, device_status,
	  static_enums_code1,
	  static_enums[static_enums_code1],
	  static_enums_code2,
	  static_enums[static_enums_code2],
	  static_enums_code3,
	  static_enums[static_enums_code3],
	  static_enums_code4,
	  static_enums[static_enums_code4]
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 131
   Command wird verwendet zum Schreiben einer enum. Variablen aus der Tabelle
   static_enums.
   static_enums_code1 dient als Index in die Tabelle. */
/* ------------------------------------------------------------------------ */
COMMAND write_enums
{
  NUMBER 131;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  static_enums_code (INFO, INDEX),
	  static_enums[static_enums_code]
	}

    REPLY
	{
	  response_code, device_status,
	  static_enums_code,
	  static_enums[static_enums_code]
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 1,	DATA_ENTRY_ERROR,	"Device does not accept changing SP source."
		                        "|de|Nicht mglich in Regelung zu gehen.";
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE static_enums_code
{
  LABEL  "enum";
  CLASS USER_INTERFACE;
  TYPE INDEX static_enums;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_enums_code1
{
  LABEL  "enum1";
  CLASS USER_INTERFACE;
  TYPE INDEX static_enums;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_enums_code2
{
  LABEL  "enum2";
  CLASS USER_INTERFACE;
  TYPE INDEX static_enums;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_enums_code3
{
  LABEL  "enum3";
  CLASS USER_INTERFACE;
  TYPE INDEX static_enums;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
VARIABLE static_enums_code4
{
  LABEL  "enum4";
  CLASS USER_INTERFACE;
  TYPE INDEX static_enums;
  HANDLING READ&WRITE;
}

/* ------------------------------------------------------------------------ */
/* Command 132   read Benutzer-Kennlienientyp */
/* ------------------------------------------------------------------------ */
COMMAND read_kennlinientyp
{
  NUMBER 132;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}
    REPLY
	{
	  response_code, device_status,
	  kennlinientyp
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 133   write Benutzer-Kennlienientyp */
/* ------------------------------------------------------------------------ */
COMMAND write_kennlinientyp
{
  NUMBER 133;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  kennlinientyp
	}

    REPLY
	{
	  response_code, device_status,
	  kennlinientyp
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 134
   Command wird verwendet zum Abfragen des Status von Aktionen */
/* ------------------------------------------------------------------------ */
COMMAND read_action_status
{
  NUMBER 134;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	}

    REPLY
	{
	  response_code, device_status,
	  status_init
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 135
   Command wird verwendet zum Abfragen der Erzeugnisnummer des Reglers */
/* ------------------------------------------------------------------------ */
COMMAND read_dev_ident_nr
{
  NUMBER 135;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}

    REPLY
	{
	  response_code, device_status,
	  erzeugnis_num_regler
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 136
   Command wird verwendet zum Abfragen der dyn. Variablen des Reglers */
/* ------------------------------------------------------------------------ */
COMMAND read_all_dynamics
{
  NUMBER 136;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{}

    REPLY
	{
	  response_code, device_status,
	  w_ma,                 /* Byte 0-3   */
	  akt_betriebsart,      /* Byte 4     */
   	  w_prozent,            /* Byte 5-8   */
	  w_hand,               /* Byte 9-12  */
      regeldifferenz,       /* Byte 13-16 */
	  regelgroesse,         /* Byte 17-20 */
	  stoerung_vorhanden,   /* Byte 21    */
	  status_a1,            /* Byte 22    */
	  status_a2,            /* Byte 23    */
	  reglerstatus,         /* Byte 24    */
	  wegintegral,          /* Byte 25-28 */
	  status_init_piste     /* Byte 29    */
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE status_init_piste
{
  LABEL "status_init_piste";
  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE BIT_ENUMERATED (1)
  {
      { 0x01, "Device initialized" "|de|Gert initialisiert", DATA },
      { 0x02, "Piste ok"           "|de|Piste ok"           , DATA }
  }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Betriebszustand              Doku-Nummer: 365   EB-Code: -    */
/* ------------------------------------------------------------------------ */
VARIABLE reglerstatus
{
  #ifdef LABEL_DE_EN
  LABEL "Operating status" "|de|Betriebszustand";
  #else
  LABEL "Operating status";
  #endif

  CLASS DEVICE&DYNAMIC;
  HANDLING READ;
  TYPE ENUMERATED
  {
      #ifdef LABEL_DE_EN
      { 0, "See operating mode"        "|de|Siehe Betriebsart"         },
      { 1, "Solenoid valve active"     "|de|Magnetventil aktiv"        },
      { 2, "Lower travel limit active" "|de|Hubbegrenzung unten aktiv" },
      { 3, "Upper travel limit active" "|de|Hubbegrenzung oben aktiv"  },
      { 4, "End position < active"     "|de|Endlage < aktiv"           },
      { 5, "End position > active"     "|de|Endlage > aktiv"           }
      #else
      { 0, "See operating mode"        },
      { 1, "Solenoid valve active"     },
      { 2, "Lower travel limit active" },
      { 3, "Upper travel limit active" },
      { 4, "End position < active"     },
      { 5, "End position > active"     }
      #endif
  }

  #ifdef HELP_DE_EN
  HELP "Shows the current operating status of the internal position "
       "control algorithm."
       "|de|Zeigt den aktuellen Betriebszustand der internen "
       "Stellungsregelung an.";
  #else
  HELP "Shows the current operating status of the internal position "
       "control algorithm.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Command 138
   Command wird verwendet zum Abfragen der Textfelder
   Auswahl des Texts erfolgt ber text_index */
/* ------------------------------------------------------------------------ */
COMMAND read_text_inputs
{
  NUMBER 138;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
	  text_index (INFO, INDEX)
    }

    REPLY
	{
	  response_code, device_status,
	  text_index,
	  user_text[text_index]
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 139
   Command wird verwendet zum Schreiben der Textfelder
   Auswahl des Texts erfolgt ber text_index */
/* ------------------------------------------------------------------------ */
COMMAND write_text_inputs
{
  NUMBER 139;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
	  text_index (INFO, INDEX),
	  user_text[text_index]
    }

    REPLY
	{
	  response_code, device_status,
	  text_index,
	  user_text[text_index]
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		 6, MISC_ERROR,         [xmtr_specific_command_error];
		 7,	MODE_ERROR,		    [in_write_protect_mode];
		 8, MISC_WARNING,       [update_in_progress];
		 9,	DATA_ENTRY_ERROR,	[lower_range_value_too_high];
		10,	DATA_ENTRY_ERROR,	[lower_range_value_too_low];
		11,	DATA_ENTRY_ERROR,	[upper_range_value_too_high];
		12,	DATA_ENTRY_ERROR,	[upper_range_value_too_low];
		13,	DATA_ENTRY_ERROR,	[URV_and_LRV_out_of_limits];
		14,	DATA_ENTRY_WARNING,	[span_too_small];
		16, MODE_ERROR,         [access_restricted];
  }
}

/* ------------------------------------------------------------------------ */
VARIABLE text_index
{
  LABEL  "texts";
  CLASS USER_INTERFACE;
  TYPE INDEX user_text;
  HANDLING READ&WRITE;
}


/* ------------------------------------------------------------------------ */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation              */
/* (Klassifikation der Standard-Fehlermeldungen Code 50-80 u.a.)            */
/* ------------------------------------------------------------------------ */


/* --------------------------------------------------------------------------- */
VARIABLE condensed_mask_code_50
{
  #ifdef LABEL_DE_EN
  LABEL "x > range" "|de|x > Bereich";
  #else
  LABEL   "x > range";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP "Definition of the condensed state when this error occurs."
       "|de|Festlegung des Sammelstatus bei Auftreten dieses Fehlers.";
  #else
  HELP "Definition of the condensed state when this error occurs.";
  #endif
}
condensed_mask_code_51 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Delta x < range" "|de|Delta x < Bereich";}
  #else
   { REDEFINE LABEL "Delta x < range";}
  #endif
condensed_mask_code_52 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Attachment" "|de|Anbau";}
  #else
   { REDEFINE LABEL "Attachment";}
  #endif
condensed_mask_code_53 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Initialization time exceeded" "|de|Initialisierungszeit berschritten";}
  #else
   { REDEFINE LABEL "Initialization time exceeded";}
  #endif
condensed_mask_code_54 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Initialization / solenoid valve" "|de|Initialisierung / Magnetventil";}
  #else
   { REDEFINE LABEL "Initialization / solenoid valve";}
  #endif
condensed_mask_code_55 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Travel time too short" "|de|Laufzeit unterschritten";}
  #else
   { REDEFINE LABEL "Travel time too short";}
  #endif
condensed_mask_code_56 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Pin position" "|de|Stiftposition";}
  #else
   { REDEFINE LABEL "Pin position";}
  #endif
condensed_mask_code_57 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Control loop" "|de|Regelkreis";}
  #else
   { REDEFINE LABEL "Control loop";}
  #endif
condensed_mask_code_58 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Zero point" "|de|Nullpunkt";}
  #else
   { REDEFINE LABEL "Zero point";}
  #endif
condensed_mask_code_59 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Autocorrection" "|de|Autokorrektur";}
  #else
   { REDEFINE LABEL "Autocorrection";}
  #endif
condensed_mask_code_60 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Fatal error" "|de|Fataler Fehler";}
  #else
   { REDEFINE LABEL "Fatal error";}
  #endif
condensed_mask_code_62 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "x-signal" "|de|x-Signal";}
  #else
   { REDEFINE LABEL "x-signal";}
  #endif
condensed_mask_code_63 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "W too small" "|de|W zu klein";}
  #else
   { REDEFINE LABEL "W too small";}
  #endif
condensed_mask_code_64 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "i/p converter" "|de|i/p-Wandler";}
  #else
   { REDEFINE LABEL "i/p converter";}
  #endif
condensed_mask_code_65 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Hardware" "|de|Hardware";}
  #else
   { REDEFINE LABEL "Hardware";}
  #endif
condensed_mask_code_66 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Data memory" "|de|Datenspeicher";}
  #else
   { REDEFINE LABEL "Data memory";}
  #endif
condensed_mask_code_67 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Control calculation" "|de|Kontrollrechnung";}
  #else
   { REDEFINE LABEL "Control calculation";}
  #endif
condensed_mask_code_68 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Control parameter" "|de|Regelparameter";}
  #else
   { REDEFINE LABEL "Control parameter";}
  #endif
condensed_mask_code_69 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Poti parameter" "|de|Potiparameter";}
  #else
   { REDEFINE LABEL "Poti parameter";}
  #endif
condensed_mask_code_70 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Adjustment parameter" "|de|Abgleichparameter";}
  #else
   { REDEFINE LABEL "Adjustment parameter";}
  #endif
condensed_mask_code_71 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "General parameter" "|de|Allgemeine Parameter";}
  #else
   { REDEFINE LABEL "General parameter";}
  #endif
condensed_mask_code_73 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Internal device error 1" "|de|Interner Gertefehler 1";}
  #else
   { REDEFINE LABEL "Internal device error 1";}
  #endif
condensed_mask_code_74 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "HART parameter" "|de|HART Parameter";}
  #else
   { REDEFINE LABEL "HART parameter";}
  #endif
condensed_mask_code_75 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Info parameter" "|de|Info-Parameter";}
  #else
   { REDEFINE LABEL "Info parameter";}
  #endif
condensed_mask_code_76 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "No emergency mode" "|de|Keine Notlaufeigenschaft";}
  #else
   { REDEFINE LABEL "No emergency mode";}
  #endif
condensed_mask_code_77 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Program load error" "|de|Programmladefehler";}
  #else
   { REDEFINE LABEL "Program load error";}
  #endif
condensed_mask_code_78 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Options parameter" "|de|Optionsparameter";}
  #else
   { REDEFINE LABEL "Options parameter";}
  #endif
condensed_mask_code_80 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Diagnosis parameter" "|de|Diagnoseparameter";}
  #else
   { REDEFINE LABEL "Diagnosis parameter";}
  #endif
condensed_mask_valve_travel LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Total valve travel exceeded" "|de|Wegintegral berschritten";}
  #else
   { REDEFINE LABEL "Total valve travel exceeded";}
  #endif
condensed_mask_temp_40 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Temperature below -40C" "|de|Temperatur kleiner -40C";}
  #else
   { REDEFINE LABEL "Temperature below -40C";}
  #endif
condensed_mask_temp_80 LIKE VARIABLE condensed_mask_code_50
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Temperature above +80C" "|de|Temperatur grer +80C";}
  #else
   { REDEFINE LABEL "Temperature above +80C";}
  #endif


/* ------------------------------------------------------------------------ */
/* Command 251      Lesen der Statusklassifikationen Code 50...80           */
/* ------------------------------------------------------------------------ */
COMMAND read_condensed_mask_codes
{
  NUMBER 251;
  OPERATION READ;
  TRANSACTION
  {
    REQUEST
	{
    }

    REPLY
	{
	  response_code, device_status,
      condensed_mask_code_50,
      condensed_mask_code_51,
      condensed_mask_code_52,
      condensed_mask_code_53,
      condensed_mask_code_54,
      condensed_mask_code_55,
      condensed_mask_code_56,
      condensed_mask_code_57,
      condensed_mask_code_58,
      condensed_mask_code_59,
      condensed_mask_code_60,
      dummy_enum,
      condensed_mask_code_62,
      condensed_mask_code_63,
      condensed_mask_code_64,
      condensed_mask_code_65,
      condensed_mask_code_66,
      condensed_mask_code_67,
      condensed_mask_code_68,
      condensed_mask_code_69,
      condensed_mask_code_70,
      condensed_mask_code_71,
      dummy_enum,
      condensed_mask_code_73,
      condensed_mask_code_74,
      condensed_mask_code_75,
      condensed_mask_code_76,
      condensed_mask_code_77,
      condensed_mask_code_78,
      dummy_enum,
      condensed_mask_code_80,
      condensed_mask_valve_travel
	}
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
  }
}

/* ------------------------------------------------------------------------ */
/* Command 250      Schreiben der Statusklassifikationen Code 50...80       */
/* ------------------------------------------------------------------------ */
COMMAND write_condensed_mask_codes
{
  NUMBER 250;
  OPERATION WRITE;
  TRANSACTION
  {
    REQUEST
	{
      condensed_mask_code_50,
      condensed_mask_code_51,
      condensed_mask_code_52,
      condensed_mask_code_53,
      condensed_mask_code_54,
      condensed_mask_code_55,
      condensed_mask_code_56,
      condensed_mask_code_57,
      condensed_mask_code_58,
      condensed_mask_code_59,
      condensed_mask_code_60,
      dummy_enum,
      condensed_mask_code_62,
      condensed_mask_code_63,
      condensed_mask_code_64,
      condensed_mask_code_65,
      condensed_mask_code_66,
      condensed_mask_code_67,
      condensed_mask_code_68,
      condensed_mask_code_69,
      condensed_mask_code_70,
      condensed_mask_code_71,
      dummy_enum,
      condensed_mask_code_73,
      condensed_mask_code_74,
      condensed_mask_code_75,
      condensed_mask_code_76,
      condensed_mask_code_77,
      condensed_mask_code_78,
      dummy_enum,
      condensed_mask_code_80,
      condensed_mask_valve_travel
    }

    REPLY
	{
	  response_code, device_status,
      condensed_mask_code_50,
      condensed_mask_code_51,
      condensed_mask_code_52,
      condensed_mask_code_53,
      condensed_mask_code_54,
      condensed_mask_code_55,
      condensed_mask_code_56,
      condensed_mask_code_57,
      condensed_mask_code_58,
      condensed_mask_code_59,
      condensed_mask_code_60,
      dummy_enum,
      condensed_mask_code_62,
      condensed_mask_code_63,
      condensed_mask_code_64,
      condensed_mask_code_65,
      condensed_mask_code_66,
      condensed_mask_code_67,
      condensed_mask_code_68,
      condensed_mask_code_69,
      condensed_mask_code_70,
      condensed_mask_code_71,
      dummy_enum,
      condensed_mask_code_73,
      condensed_mask_code_74,
      condensed_mask_code_75,
      condensed_mask_code_76,
      condensed_mask_code_77,
      condensed_mask_code_78,
      dummy_enum,
      condensed_mask_code_80,
      condensed_mask_valve_travel
	}
  }

  RESPONSE_CODES
  {
    0, SUCCESS,    [no_command_specific_errors];
    5, MISC_ERROR, [too_few_data_bytes_recieved];
    7, MODE_ERROR, [in_write_protect_mode];
  }
}


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Zuluftdruck */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE AirSupply_6_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Air supply - Perhaps modified"
           "|de|Zuluftdruck - Eventuell verndert";
  #else
  LABEL    "Air supply - Perhaps modified";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the air supply."
           "|de|Klassifikation der Meldung vom Zuluftdruck.";
  #else
  HELP     "Classification of the message from the air supply.";
  #endif
}

AirSupply_1_condensed_mask  LIKE  VARIABLE  AirSupply_6_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Air supply - Perhaps modified (TEST)"
                 "|de|Zuluftdruck - Eventuell verndert (TEST)"; }
  #else
{ REDEFINE LABEL "Air supply - Perhaps modified (TEST)"; }
  #endif
AirSupply_3_condensed_mask  LIKE  VARIABLE  AirSupply_6_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Air supply - Perhaps not enough"
                 "|de|Zuluftdruck - Eventuell nicht ausreichend"; }
  #else
{ REDEFINE LABEL "Air supply - Perhaps not enough"; }
  #endif
AirSupply_2_condensed_mask  LIKE  VARIABLE  AirSupply_6_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Air supply - Perhaps not enough (TEST)"
                 "|de|Zuluftdruck - Eventuell nicht ausreichend (TEST)"; }
  #else
{ REDEFINE LABEL "Air supply - Perhaps not enough (TEST)"; }
  #endif
AirSupply_4_condensed_mask  LIKE  VARIABLE  AirSupply_6_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Air supply - Working at full capacity"
                 "|de|Zuluftdruck - Stark ausgelastet"; }
  #else
{ REDEFINE LABEL "Air supply - Working at full capacity"; }
  #endif
AirSupply_5_condensed_mask  LIKE  VARIABLE  AirSupply_6_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Air supply - Working at full capacity (TEST)"
                 "|de|Zuluftdruck - Stark ausgelastet (TEST)"; }
  #else
{ REDEFINE LABEL "Air supply - Working at full capacity (TEST)"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Trend Stellbereich */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE ShiftingWorkingRange_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Shifting working range - Shifting working range to closing position"
           "|de|Trend Stellbereich - Arbeitsbereichverschiebung Schliessstellung";
  #else
  LABEL    "Shifting working range - Shifting working range to closing position";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the messages from the shifting working range."
           "|de|Klassifikation der Meldung vom Trend Stellbereich.";
  #else
  HELP     "Classification of the messages from the shifting working range.";
  #endif
}

ShiftingWorkingRange_2_condensed_mask  LIKE  VARIABLE  ShiftingWorkingRange_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Shifting working range - Shifting working range to max. opening position"
                 "|de|Trend Stellbereich - Arbeitsbereichverschiebung max. ffnung"; }
  #else
{ REDEFINE LABEL "Shifting working range - Shifting working range to max. opening position"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Leckage Pneumatik */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE LeakagePn_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Leakage pneumatics - Perhaps existing (TEST)"
           "|de|Leckage Pneumatik - Eventuell vorhanden (TEST)";
  #else
  LABEL    "Leakage pneumatics - Perhaps existing (TEST)";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the messages from the pneumatic leakage."
           "|de|Klassifikation der Meldung der pneumatischen Leckage.";
  #else
  HELP     "Classification of the messages from the pneumatic leakage.";
  #endif
}

LeakagePn_3_condensed_mask  LIKE  VARIABLE  LeakagePn_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Leakage pneumatics - Perhaps too large (TEST)"
                 "|de|Leckage Pneumatik - Eventuell zu gross (TEST)"; }
  #else
{ REDEFINE LABEL "Leakage pneumatics - Perhaps too large (TEST)"; }
  #endif
LeakagePn_4_condensed_mask  LIKE  VARIABLE  LeakagePn_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Leakage pneumatics - Perhaps too large"
                 "|de|Leckage Pneumatik - Eventuell zu gross"; }
  #else
{ REDEFINE LABEL "Leakage pneumatics - Perhaps too large"; }
  #endif
LeakagePn_2_condensed_mask  LIKE  VARIABLE  LeakagePn_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Leakage pneumatics - Perhaps existing"
                 "|de|Leckage Pneumatik - Eventuell vorhanden"; }
  #else
{ REDEFINE LABEL "Leakage pneumatics - Perhaps existing"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Beschraenkung Stellbereich */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE LimitWorkingRange_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Limit working range - Down"
           "|de|Beschrnkung Stellbereich - Nach unten";
  #else
  LABEL    "Limit working range - Down";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the limitation working range."
           "|de|Klassifikation der Meldung von der Beschrnkung des Stellbereichs.";
  #else
  HELP     "Classification of the message from the limitation working range.";
  #endif
}

LimitWorkingRange_2_condensed_mask  LIKE  VARIABLE  LimitWorkingRange_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Limit working range - Up"
                 "|de|Beschrnkung Stellbereich - Nach oben"; }
  #else
{ REDEFINE LABEL "Limit working range - Up"; }
  #endif
LimitWorkingRange_3_condensed_mask  LIKE  VARIABLE  LimitWorkingRange_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Limit working range - Modification impossible"
                 "|de|Beschrnkung Stellbereich - Keine nderung mglich (Klemmen)"; }
  #else
{ REDEFINE LABEL "Limit working range - Modification impossible"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Trend Endlage */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE ObservingEndPosition_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "End position trend - Zero point - shift downwards monotonically; average above reference"
           "|de|Trend Endlage - NP-verschiebung monoton unten Mittelwert ob. Ref.-geraden";
  #else
  LABEL    "End position trend - Zero point - shift downwards monotonically; average above reference";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the travel end position."
           "|de|Klassifikation der Meldung vom Endlagetrend.";
  #else
  HELP     "Classification of the message from the travel end position.";
  #endif
}

ObservingEndPosition_2_condensed_mask  LIKE  VARIABLE  ObservingEndPosition_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "End position trend - Zero point - shift upwards monotonically; average above reference"
                 "|de|Trend Endlage - NP-verschiebung monoton oben Mittelwert ob. Ref.-geraden"; }
  #else
{ REDEFINE LABEL "End position trend - Zero point - shift upwards monotonically; average above reference"; }
  #endif
ObservingEndPosition_3_condensed_mask  LIKE  VARIABLE  ObservingEndPosition_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "End position trend - Zero point - alternate; average above reference"
                 "|de|Trend Endlage - NP alterniert - Mittelwert ob. Ref.-geraden"; }
  #else
{ REDEFINE LABEL "End position trend - Zero point - alternate; average above reference"; }
  #endif
ObservingEndPosition_4_condensed_mask  LIKE  VARIABLE  ObservingEndPosition_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "End position trend - Zero point - shift downwards monotonically; average below reference"
                 "|de|Trend Endlage - NP-verschiebung monoton unten Mittelwert unt. Ref.-geraden"; }
  #else
{ REDEFINE LABEL "End position trend - Zero point - shift downwards monotonically; average below reference"; }
  #endif
ObservingEndPosition_5_condensed_mask  LIKE  VARIABLE  ObservingEndPosition_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "End position trend - Zero point - shift upwards monotonically; average below reference"
                 "|de|Trend Endlage - NP-verschiebung monoton oben Mittelwert unt. Ref.-geraden"; }
  #else
{ REDEFINE LABEL "End position trend - Zero point - shift upwards monotonically; average below reference"; }
  #endif
ObservingEndPosition_6_condensed_mask  LIKE  VARIABLE  ObservingEndPosition_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "End position trend - Zero point - alternate; average below reference"
                 "|de|Trend Endlage - NP alterniert - Mittelwert unt. Ref.-geraden"; }
  #else
{ REDEFINE LABEL "End position trend - Zero point - alternate; average below reference"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Mech. Verbindung SR/Ventil */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE ConnectionPosValve_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Mech. conn. positioner/valve - No optimum travel transmision (TEST)"
           "|de|Mech. Verb. Regler/Ventil - Keine opt. Hubbertragung (TEST)";
  #else
  LABEL    "Mech. conn. positioner/valve - No optimum travel transmision (TEST)";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the mechanical connection."
           "|de|Klassifikation der Meldung der mechanischen Verbindung.";
  #else
  HELP     "Classification of the message from the mechanical connection.";
  #endif
}

ConnectionPosValve_2_condensed_mask  LIKE  VARIABLE  ConnectionPosValve_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Mech. conn. positioner/valve - Perhaps loose"
                 "|de|Mech. Verb. Regler/Ventil - Evtl. Lose vorhanden"; }
  #else
{ REDEFINE LABEL "Mech. conn. positioner/valve - Perhaps loose"; }
  #endif
ConnectionPosValve_3_condensed_mask  LIKE  VARIABLE  ConnectionPosValve_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Mech. conn. positioner/valve - Perhaps range limit"
                 "|de|Mech. Verb. Regler/Ventil - Evtl. Einschrnkung Stellbereich"; }
  #else
{ REDEFINE LABEL "Mech. conn. positioner/valve - Perhaps range limit"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Stellbereich */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE WorkingRange_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Working range - Mostly near closing position"
           "|de|Stellbereich - Vorwiegend nahe Schliessstellung";
  #else
  LABEL    "Working range - Mostly near closing position";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the working range."
           "|de|Klassifikation der Meldung vom Stellbereich.";
  #else
  HELP     "Classification of the message from the working range.";
  #endif
}

WorkingRange_2_condensed_mask  LIKE  VARIABLE  WorkingRange_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Working range - Mostly near max. opening"
                 "|de|Stellbereich - Vorwiegend nahe max. ffnung"; }
  #else
{ REDEFINE LABEL "Working range - Mostly near max. opening"; }
  #endif
WorkingRange_3_condensed_mask  LIKE  VARIABLE  WorkingRange_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Working range - Mostly closing position"
                 "|de|Stellbereich - Vorwiegend Schliessstellung"; }
  #else
{ REDEFINE LABEL "Working range - Mostly closing position"; }
  #endif
WorkingRange_4_condensed_mask  LIKE  VARIABLE  WorkingRange_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Working range - Mostly max. opening"
                 "|de|Stellbereich - Vorwiegend max. ffnung"; }
  #else
{ REDEFINE LABEL "Working range - Mostly max. opening"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Reibung */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE Friction_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Friction - Much higher over whole range"
           "|de|Reibung - ber ganzen Stellbereich deutlich hher";
  #else
  LABEL    "Friction - Much higher over whole range";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the friction."
           "|de|Klassifikation der Meldung der Reibung.";
  #else
  HELP     "Classification of the message from the friction.";
  #endif
}

Friction_2_condensed_mask  LIKE  VARIABLE  Friction_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Friction - Much lower over whole range"
                 "|de|Reibung - ber ganzen Stellbereich deutlich niedriger"; }
  #else
{ REDEFINE LABEL "Friction - Much lower over whole range"; }
  #endif
Friction_3_condensed_mask  LIKE  VARIABLE  Friction_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Friction - Much higher over section"
                 "|de|Reibung - ber Teilbereich deutlich hher"; }
  #else
{ REDEFINE LABEL "Friction - Much higher over section"; }
  #endif
Friction_4_condensed_mask  LIKE  VARIABLE  Friction_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Friction - Much lower over section"
                 "|de|Reibung - ber Teilbereich deutlich niedriger"; }
  #else
{ REDEFINE LABEL "Friction - Much lower over section"; }
  #endif
Friction_5_condensed_mask  LIKE  VARIABLE  Friction_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Friction - Much higher/lower over whole range (TEST)"
                 "|de|Reibung - ber ganzen Stellbereich deutlich hher/niedriger (TEST)"; }
  #else
{ REDEFINE LABEL "Friction - Much higher/lower over whole range (TEST)"; }
  #endif
Friction_6_condensed_mask  LIKE  VARIABLE  Friction_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Friction - Much higher/lower over section (TEST)"
                 "|de|Reibung - ber Teilbereich deutlich hher/niedriger (TEST)"; }
  #else
{ REDEFINE LABEL "Friction - Much higher/lower over section (TEST)"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Antriebsfedern */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE ActSpring_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Actuator springs - Perhaps spring stiffness reduced (TEST)"
           "|de|Antriebsfedern - Evtl. Federsteifigkeit reduziert (Federausfall) (TEST)";
  #else
  LABEL    "Actuator springs - Perhaps spring stiffness reduced (TEST)";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the actuator springs."
           "|de|Klassifikation der Meldung der Antriebsfedern.";
  #else
  HELP     "Classification of the message from the actuator springs.";
  #endif
}

ActSpring_2_condensed_mask  LIKE  VARIABLE  ActSpring_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Actuator springs - Perhaps bias reduced (TEST)"
                 "|de|Antriebsfedern - Evtl. Vorspannung reduziert (TEST)"; }
  #else
{ REDEFINE LABEL "Actuator springs - Perhaps bias reduced (TEST)"; }
  #endif
ActSpring_3_condensed_mask  LIKE  VARIABLE  ActSpring_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Actuator springs - Perhaps bias increased (TEST)"
                 "|de|Antriebsfedern - Evtl. Vorspannung erhht (TEST)"; }
  #else
{ REDEFINE LABEL "Actuator springs - Perhaps bias increased (TEST)"; }
  #endif
ActSpring_4_condensed_mask  LIKE  VARIABLE  ActSpring_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Actuator springs - Working at full capacity"
                 "|de|Antriebsfedern - Stark ausgelastet"; }
  #else
{ REDEFINE LABEL "Actuator springs - Working at full capacity"; }
  #endif
ActSpring_5_condensed_mask  LIKE  VARIABLE  ActSpring_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "Actuator springs - Working at full capacity (TEST)"
                 "|de|Antriebsfedern - Stark ausgelastet (TEST)"; }
  #else
{ REDEFINE LABEL "Actuator springs - Working at full capacity (TEST)"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Innere Leckage */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE InnerLeakage_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "Inner leakage - Perhaps larger than origin"
           "|de|Innere Leckage - Eventuell grsser als im Neuzustand";
  #else
  LABEL    "Inner leakage - Perhaps larger than origin";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP "Classification of the message from the internal leakage."
           "|de|Klassifikation der Meldung der inneren Leckage.";
  #else
  HELP "Classification of the message from the internal leakage.";
  #endif
}

InnerLeakage_2_condensed_mask  LIKE VARIABLE InnerLeakage_1_condensed_mask
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Inner leakage - Perhaps larger than origin (TEST)"
                    "|de|Innere Leckage - Eventuell grsser als im Neuzustand (TEST)"; }
  #else
   { REDEFINE LABEL "Inner leakage - Perhaps larger than origin (TEST)";}
  #endif
InnerLeakage_3_condensed_mask  LIKE VARIABLE InnerLeakage_1_condensed_mask
  #ifdef LABEL_DE_EN
   { REDEFINE LABEL "Inner leakage - Perhaps present"
                    "|de|Innere Leckage - Eventuell vorhanden"; }
  #else
   { REDEFINE LABEL "Inner leakage - Perhaps present";}
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   Externe Leckage */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE ExternalLeakage_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "External leakage - Perhaps soon expected"
           "|de|Externe Leckage - Eventuell bald zu erwarten";
  #else
  LABEL    "External leakage - Perhaps soon expected";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the external leakage."
           "|de|Klassifikation der Meldung der externen Leckage.";
  #else
  HELP     "Classification of the message from the external leakage.";
  #endif
}

ExternalLeakage_2_condensed_mask  LIKE  VARIABLE  ExternalLeakage_1_condensed_mask
  #ifdef LABEL_DE_EN
{ REDEFINE LABEL "External leakage - Perhaps existing"
                 "|de|Externe Leckage - Eventuell vorhanden"; }
  #else
{ REDEFINE LABEL "External leakage - Perhaps existing"; }
  #endif


/* ----------------------------------------------------------------------------- */
/* Stellungsregler - Fehlerueberwachung - Statusklassifikation - Erweitert -     */
/*   PST */
/* (Klassifikation der EXPERT+ Fehlermeldungen)                                  */
/* ----------------------------------------------------------------------------- */
VARIABLE PST_1_condensed_mask
{
  #ifdef LABEL_DE_EN
  LABEL    "PST - Status set"
           "|de|PST - Status gesetzt";
  #else
  LABEL    "PST - Status set";
  #endif

  CLASS    DEVICE;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE  0;
  #ifdef LABEL_DE_EN
    { 0, "No message"           "|de|Keine Meldung"       },
    { 1, "Maintenance required" "|de|Wartungsbedarf"      },
    { 2, "Maintenance demanded" "|de|Wartungsanforderung" },
    { 3, "Maintenance alarm"    "|de|Ausfall"             }
  #else
    { 0, "No message"           },
    { 1, "Maintenance required" },
    { 2, "Maintenance demanded" },
    { 3, "Maintenance alarm"    }
  #endif
  }
  #ifdef HELP_DE_EN
  HELP     "Classification of the message from the PST status."
           "|de|Klassifikation der Meldung des PST Status.";
  #else
  HELP     "Classification of the message from the PST status.";
  #endif
}


/* ------------------------------------------------------------------------ */
/* Relations                                                                */
/* (Variable rechts des Doppelpunktes wird neu gelesen wenn links geaendert)*/
/* ------------------------------------------------------------------------ */
/* nach der Initialisierung folgende Werte neu einlesen: */
REFRESH relation_init
{ /*      337 : 6/54, 134, 21, 47, 48, 22, 23 8/347, 41 */
  status_init : nennbereich, sicherheitsstellung, druckgrenze,
                min_laufzeit_auf, min_laufzeit_zu, kp_stufe, tv_stufe,
                bewegungsrichtung, schliessrichtung
}

REFRESH relation_geraet_ini
{ /*     145 : 6, 41, 42, 51, 54 */
  geraet_ini : w_hand, nennbereich, schliessrichtung, blockierstellung,
               regeldifferenz, antriebsdruck, regelgroesse
}

REFRESH relation_akt_betriebsart
{ /*          109 : 2 */
  akt_betriebsart : w_hand
}

REFRESH relation_stellungsmelder
{ /*           44 : 36, 37, 38 */
  stellungsmelder : wirkr_stellmelder, stoerm_mit_stellmelder, test_stellmelder
}

REFRESH relation_ind_grenzkontakt
{ /*            45 : 30, 35, 31, 32, 140, 141 */
  ind_grenzkontakt :
  alarmmodus, /* alarm_test, */ aktiv_gw_a1, grenzwert_a1, x_unterschreitet_a1, status_a1
}

REFRESH relation_magnetventil
{  /*        52 : 64, 138, 325 */
   magnetventil : xmtr_specific_status_0, zwangsentlueftung/*, xmtr_specific_status_6*/
   /* 64 = Fehler 64 (Initialisierung Magnetventil) in fehlercode_0 enthalten */
}

/* Einheitenabhaengigkeiten: */
REFRESH unit_relation_geraet_ini
{ /*     145 : 100 */
  geraet_ini : regelgroesse
}

/* Einheitenabhaengigkeiten: */
REFRESH unit_relation_stiftposition
{ /*          5 : 9, 10, 42, 6, 54 */
  stiftposition : x_bereich_anfang, x_bereich_ende, schliessrichtung, nennbereich
}






/* Ansicht - Messwertanzeige ***************************************************/
MENU OnlineWindow_display
{
	LABEL		[menu_dialog_display];
	ITEMS
	{
		Page_display_measure,
		Page_display_state_1,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {
        /* EXPERT+ Geraet */

		Page_display_state_4,
      }

		Page_display_state_2,
		Page_display_state_3,
		Page_display_statistic,
		Page_display_device
	}
}

/* Ansicht - Messwertanzeige - Messwert ****************************************/
MENU Page_display_measure
{
	LABEL		[menu_dialog_display_measure];
	ITEMS
	{
        Page_group_display_measure
	}
}

MENU Page_group_display_measure
{
	LABEL		"";
	ITEMS
	{
		BarVal_pv_display,
		BarVal_sp_display,
        namur_sammelstatus,
        reglerstatus,
        device_status (READ_ONLY), /* Gertezustand */
        akt_betriebsart,
        current_temperature,
		SEPARATOR,
        VertBar_e_display
	}
}

MENU BarVal_pv_display /* Istwert Bargraph */
{
    LABEL "Controlled variable x" "|de|Regelgre x";
	ITEMS
	{
		regelgroesse  (READ_ONLY),
		xwMin,
		xwMax
/*	geht nicht	dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE*/
	}
}

MENU BarVal_sp_display /* Sollwert Bargraph */
{
    LABEL
        /* bei Betriebsart HAND */
        IF ((akt_betriebsart == AKT_BA_HAND_IP)  ||
            (akt_betriebsart == AKT_BA_HAND_W )  ||
            (akt_betriebsart == AKT_BA_HAND_W_STEUERUNG ))
        {
            "Man. Reference variable w" "|de|Hand Fhrungsgre w";
        }
        ELSE
        {
            "Reference variable w" "|de|Fhrungsgre w";
        }

	ITEMS
	{
        /* bei Betriebsart HAND */
        IF ((akt_betriebsart == AKT_BA_HAND_IP)  ||
            (akt_betriebsart == AKT_BA_HAND_W )  ||
            (akt_betriebsart == AKT_BA_HAND_W_STEUERUNG ))
        {
            w_hand     (READ_ONLY) /* Handsollwert anzeigen */
        }
        ELSE
        {
		    w_prozent  (READ_ONLY) /* Autosollwert anzeigen */
        }

		xwMin,
		xwMax
/*	geht nicht	dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE*/
	}
}

/* Minimalwert Bargraph x,w */
VARIABLE xwMin
{
	LABEL "xw Min";
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0 ;
	}
}

/* Maximalwert Bargraph x,w */
VARIABLE xwMax
{
	LABEL "xw Max";
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100 ;
	}
}

MENU VertBar_e_display /* Regeldifferenz Bargraph */
{
    LABEL "Setpoint deviation e" "|de|Regeldifferenz e";
	ITEMS
	{
		regeldifferenz  (READ_ONLY),
		eMin,
		eMax
	}
}

/* Minimalwert Bargraph e */
VARIABLE eMin
{
	LABEL "e Min";
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE -10 ;
	}
}

/* Maximalwert Bargraph e */
VARIABLE eMax
{
	LABEL "e Max";
	CLASS LOCAL;
	TYPE FLOAT
	{
		DEFAULT_VALUE 10 ;
	}
}

/* Ansicht - Messwertanzeige - Status 1 ***************************************/

MENU Page_display_state_1
{
	LABEL	  "Status messages"
	          "|de|Statusmeldungen";
	ITEMS
	{
	   namur_sammelstatus,
	   elapsed_hours_meter,
	   device_in_closed_loop,
	   device_switched_on_since_init,
	   device_in_closed_loop_since_init,
	   stoerung_vorhanden,
	   geraet_ini,
       xmtr_specific_status_4,
       anzahl_np,
       counter_init_start,
       zero_point_limit (READ_ONLY),
	   zwangsentlueftung,
       SEPARATOR,
       xmtr_specific_status_0,
       xmtr_specific_status_1,
       xmtr_specific_status_2,
       xmtr_specific_status_3,
       error_code_81_ref_test_aborted,
       min_temperature,
       max_temperature,
       his_t_zeit_min_temperatur,
       his_t_zeit_max_temperatur,
       temp_period_time_low,
       temp_period_time_high
	}
}



MENU Page_display_state_2
{
	LABEL	  "Logger 1"
	          "|de|Protokollierung 1";
	ITEMS
	{
      messages_1 ,
      messages_2 ,
      messages_3 ,
      messages_4 ,
      messages_5 ,
      messages_6 ,
      messages_7 ,
      messages_8 ,
      messages_9 ,
      messages_10,
      messages_11,
      messages_12,
      messages_13,
      messages_14,
      messages_15,
      SEPARATOR,
      elapsed_hours_meter_1 ,
      elapsed_hours_meter_2 ,
      elapsed_hours_meter_3 ,
      elapsed_hours_meter_4 ,
      elapsed_hours_meter_5 ,
      elapsed_hours_meter_6 ,
      elapsed_hours_meter_7 ,
      elapsed_hours_meter_8 ,
      elapsed_hours_meter_9 ,
      elapsed_hours_meter_10,
      elapsed_hours_meter_11,
      elapsed_hours_meter_12,
      elapsed_hours_meter_13,
      elapsed_hours_meter_14,
      elapsed_hours_meter_15
	}
}


MENU Page_display_state_3
{
	LABEL	  "Logger 2"
	          "|de|Protokollierung 2";
	ITEMS
	{
      messages_16,
      messages_17,
      messages_18,
      messages_19,
      messages_20,
      messages_21,
      messages_22,
      messages_23,
      messages_24,
      messages_25,
      messages_26,
      messages_27,
      messages_28,
      messages_29,
      messages_30,
      SEPARATOR,
      elapsed_hours_meter_16,
      elapsed_hours_meter_17,
      elapsed_hours_meter_18,
      elapsed_hours_meter_19,
      elapsed_hours_meter_20,
      elapsed_hours_meter_21,
      elapsed_hours_meter_22,
      elapsed_hours_meter_23,
      elapsed_hours_meter_24,
      elapsed_hours_meter_25,
      elapsed_hours_meter_26,
      elapsed_hours_meter_27,
      elapsed_hours_meter_28,
      elapsed_hours_meter_29,
      elapsed_hours_meter_30
	}
}



MENU Page_display_state_4
{
	LABEL	  "Extended"
	          "|de|Erweitert";
	ITEMS
	{
	  Page_group_display_state_4
	}
}

MENU Page_group_display_state_4
{
	LABEL		"";
	ITEMS
	{
      air_supply,
      shifting_working_range,
      leakage_pneumatic,
      limit_working_range,
      observing_end_position,
      connection_positioner_valve,
      working_range,
      friction,
      actuator_spring,
      inner_leakage,
      external_leakage,

      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        pst_emergency_shut_down
      }
	}
}



MENU Page_display_device
{
	LABEL	  "Device"
	          "|de|Gert";
	ITEMS
	{
	   Page_group_display_device
	}
}

MENU Page_group_display_device
{
    LABEL  "";
	ITEMS
	{
	  tag                   (READ_ONLY),
	  long_tag              (READ_ONLY),
	  manufacturer_id,
	  device_type,
	  device_id,
	  erzeugnis_num_regler,
	  firmware_version,
	  final_assembly_number (READ_ONLY),
      transmitter_revision,
      universal_revision
	}
}


/* Ansicht - Messwertanzeige - Statistik **************************************/
MENU Page_display_statistic
{
	LABEL  "Statistics"
	       "|de|Statistik";
	ITEMS
	{
        Page_group_statistic_1,
        Page_group_statistic_2
	}
}

MENU Page_group_statistic_1
{
	LABEL  "";
	ITEMS
	{
	    Val_wegintegral,
	    Val_gw_wegintegral
	}
}

MENU Page_group_statistic_2
{
	LABEL  "";
	ITEMS
	{
        Val_anzahl_init,
        Val_anzahl_np
	}
}

/* Grossanzeige */
MENU Val_wegintegral
{
    LABEL "Total valve travel" "|de|Wegintegral";
	ITEMS
	{
		wegintegral
	}
}

/* Grossanzeige */
MENU Val_gw_wegintegral
{
    LABEL "Limit value total valve travel" "|de|Grenzwert Wegintegral";
	ITEMS
	{
		gw_wegintegral	(READ_ONLY)
	}
}

/* Grossanzeige */
MENU Val_anzahl_np
{
    LABEL "Number of zero point adjustments" "|de|Anzahl Nullpunktabgleiche";
	ITEMS
	{
		anzahl_np
	}
}

/* Grossanzeige */
MENU Val_anzahl_init
{
    LABEL    "Number of initializations" "|de|Anzahl Initialisierungen";
	ITEMS
	{
		counter_init_start
	}
}

/* Ansicht - Gertezustand ***************************************************/
MENU OnlineWindow_diagnosis
{
	LABEL		[menu_dialog_diagnosis];
	ITEMS
	{
		Page_display_state_1,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {
        /* EXPERT+ Geraet */

		Page_display_state_4,
	  }

		Page_display_state_2,
		Page_display_state_3,
		Page_display_device
	}
    HELP "Current device status and diagnosis messages."
         "|de|Aktueller Gertezustand und Diagnosemeldungen.";
}



/* Ansicht - y-t Diagram *****************************************************/
MENU OnlineWindow_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Page_process_yt
	}
}

MENU Page_process_yt
{
	LABEL		[menu_yt_diagram] ;
	ITEMS
	{
		Val_yt,
		Val_yt_2,
		OCX_out_display_yt
	}
}

/* Grossanzeige */
MENU Val_yt
{
	LABEL   "Controlled variable X" "|de|Regelgre X";
	STYLE   "OCX_DYNAMIC_YT";
	ITEMS
	{
		regelgroesse
	}
}

/* Grossanzeige */
MENU Val_yt_2
{
    LABEL  "Reference variable W" "|de|Fhrungsgre W";
	STYLE  "OCX_DYNAMIC_YT";
	ITEMS
	{
		w_prozent
	}
}

MENU OCX_out_display_yt								/* OCX-Control */
{
	LABEL		[menu_yt_diagram] ;
	STYLE		"PDMTVPROXY.PDMTVProxyCtrl.1";		/* Name, unter dem das OCX in Windows registriert ist */
	ITEMS
	{
		OCX_ProfilNum_yt,							/* Profil-Nummer */
		OCX_out_display_1,							/* 1. Kurve */
		OCX_out_display_2,							/* 2. Kurve */
		OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
	}
}

MENU OCX_out_display_1								/* 1. Kurve im OCX-Control yt */
{
	LABEL   "Controlled variable X" "|de|Regelgre X";
	STYLE	"OCX_DYNAMIC_YT";
	ITEMS
	{
		regelgroesse,
		xwMin,
		xwMax
/* geht nicht
		dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE */
	}
}

MENU OCX_out_display_2								/* 1. Kurve im OCX-Control yt */
{
    LABEL   "Reference variable W" "|de|Fhrungsgre W";
	STYLE	"OCX_DYNAMIC_YT";
	ITEMS
	{
		w_prozent,
		xwMin,
		xwMax
/* geht nicht
		dynamic_variables[0].LOWER_RANGE_VALUE,
		dynamic_variables[0].UPPER_RANGE_VALUE */
	}
}


VARIABLE OCX_ProfilNum_yt							/* Profil-Variable fr OCX yt */
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	0;							/* Profil 0 fr normale y-t-Darstellung */
	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_yt	/* Fr Speicherung von Settings, die vom Benutzer zur Laufzeit gendert wurden */
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}


/* Ansicht - x-y Diagram (ben. Kennlinie) ************************************/
VARIABLE xMin
{
	LABEL "x" ;
	CLASS LOCAL ;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0 ;
	}
    CONSTANT_UNIT "%";
}

VARIABLE xMax
{
	LABEL "x" ;
	CLASS LOCAL ;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100 ;
	}
    CONSTANT_UNIT "%";
}

VARIABLE yMin /* Untergrenze y-Bereich */
{
	LABEL		"y";
	CLASS		LOCAL; /* CONTAINED; */
	TYPE		FLOAT
	{
		DEFAULT_VALUE 0 ;
	}
    CONSTANT_UNIT "%";
	HANDLING    READ & WRITE ;
	PRE_EDIT_ACTIONS
	{
		DEFINITION
		{
			yMin = 0 ;
		}
	}
}

VARIABLE yMax /* Obergrenze y-Bereich */
{
	LABEL		"y";
	CLASS		LOCAL; /*CONTAINED;*/
	TYPE		FLOAT
	{
		DEFAULT_VALUE 100 ;
	}
    CONSTANT_UNIT "%";
	HANDLING    READ & WRITE ;
}

MENU xvalues1 /* Liste aller x-Wert-Variablen */
{
	STYLE		"OCX_X_LIST";
    ITEMS
    {
		x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10
    }
}

MENU yvalues1 /* Liste aller y-Wert-Variablen */
{
	STYLE		"OCX_Y_LIST";
    ITEMS
    {
		y0, y1, y2, y3, y4, y5, y6, y7, y8, y9, y10
    }
}

/* OCX Trendviewer ------------------------------------------------ */
VARIABLE OCX_ProfilNum_xy		/* Profil-Variable fr OCX yx */
{
	LABEL		"ProfilID";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		INTEGER(2)
	{
		DEFAULT_VALUE	1003;
	}

	HANDLING READ;
}

VARIABLE OCX_UserSettings_xy
{
	LABEL		"UserSettings";
	STYLE		"OCX_PROPERTY";
	CLASS		LOCAL;
	TYPE		ASCII (1000)
	{
		DEFAULT_VALUE	"";
	}
	HANDLING	READ & WRITE;
}

MENU OfflineWindow_graph_xy_editable
{
	LABEL "User defined characteristics"
	      "|de|Benutzerdefinierte Kennlinie";
	ITEMS
	{
		OCX_out_display_xy,
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        kennl_eingabe  ,  /* Methode */
        SEPARATOR      ,
	    x0  (READ_ONLY),
	    x1  (READ_ONLY),
	    x2  (READ_ONLY),
	    x3  (READ_ONLY),
	    x4  (READ_ONLY),
	    x5  (READ_ONLY),
	    x6  (READ_ONLY),
	    x7  (READ_ONLY),
	    x8  (READ_ONLY),
	    x9  (READ_ONLY),
	    x10 (READ_ONLY),
        SEPARATOR      ,
	    y0  (READ_ONLY),
	    y1  (READ_ONLY),
	    y2  (READ_ONLY),
	    y3  (READ_ONLY),
	    y4  (READ_ONLY),
	    y5  (READ_ONLY),
	    y6  (READ_ONLY),
	    y7  (READ_ONLY),
	    y8  (READ_ONLY),
	    y9  (READ_ONLY),
	    y10 (READ_ONLY)
	}
    HELP   "Arithmetic chart and coordinates for user - defined control valve characteristic."
           "|de|Grafik und Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
           "Fhrungsgre und Hub / Drehwinkel.";
}

MENU OCX_out_display_xy_1
{
	LABEL  "xy";
	STYLE  "OCX_DYNAMIC_XY";
	ITEMS
	{
        xvalues1,               /* x-values      */
        yvalues1,               /* y-values      */
        xMin    (READ_ONLY),    /* start value X */
        xMax    (READ_ONLY),    /* end value X   */
        yMin    (READ_ONLY),    /* start value Y */
        yMax    (READ_ONLY)     /* end value Y   */
	}
}

MENU OCX_out_display_xy			/* OCX-Control */
{
	LABEL  "y=f(x)" ;
/* kmr:
    SIZE-Angabe geht wohl nicht auf allen Rechnern/mit allen PDM-Versionen:
    STYLE  "PDMTVPROXY.PDMTVProxyCtrl.1" & "SIZE 50 23"; */ /* Breite x Hoehe */
	STYLE  "PDMTVPROXY.PDMTVProxyCtrl.1";
	ITEMS
	{
		OCX_ProfilNum_xy,		/* profile number */
		OCX_out_display_xy_1,	/* 1. Curve */
		OCX_UserSettings_xy		/* storing of user settings */
	}
}

/*******************************************************************************/
/* Online Dialogs                                                              */
/*******************************************************************************/

/* Gert - Betrieb ***********************************************************/
MENU OnlineDialog_operation
{
	LABEL		"Operation"
	            "|de|Betrieb";
	ITEMS
	{
		Page_operation_AUTO,
		Page_operation_MANUAL,
		Page_operation_simulation
	}
    HELP  "Manipulation and monitoring of operating parameters."
          "|de|ndern und Anzeigen von Betriebsparametern.";
}

/* Gert - Betrieb - Automatik ***********************************************/
MENU Page_operation_AUTO
{
	LABEL  "Automatic"
	       "|de|Automatik";
	ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_AUTO_1,
        Page_group_AUTO_2,
        Page_group_operation_status
	}
}

MENU Page_group_AUTO_1
{
	LABEL  "";
	ITEMS
	{
		akt_betriebsart,
        write_target_mode /* Schreiben von gew_betriebsart */
	}
}

MENU Page_group_AUTO_2
{
	LABEL  "";
	ITEMS
	{
      Val_w,
      Val_x,
      Val_e
	}
}

MENU Page_group_operation_status
{
	LABEL  "";
	ITEMS
	{
	   namur_sammelstatus,
  	   stoerung_vorhanden,
       reglerstatus,
       status_a1,
       x_unterschreitet_a1,
       status_a2,
       x_ueberschreitet_a2,
       current_temperature
	}
}


/* Grossanzeige */
MENU Val_w
{
    LABEL "Reference variable w" "|de|Fhrungsgre w";
	ITEMS
	{
		w_prozent
	}
}

/* Grossanzeige */
MENU Val_x
{
    LABEL "Controlled variable x" "|de|Regelgre x";
	ITEMS
	{
		regelgroesse
	}
}

/* Grossanzeige */
MENU Val_e
{
    LABEL "Setpoint deviation e" "|de|Regeldifferenz e";
	ITEMS
	{
		regeldifferenz
	}
}

/* Gert - Betrieb - Hand ****************************************************/
MENU Page_operation_MANUAL
{
	LABEL  "Manual"
	       "|de|Hand";
	ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_MANUAL_1,
        Page_group_MANUAL_2,
        Page_group_operation_status
	}
}

MENU Page_group_MANUAL_1
{
	LABEL		"";
	ITEMS
	{
        write_target_mode, /* Schreiben von gew_betriebsart */
		akt_betriebsart
	}
}

MENU Page_group_MANUAL_2
{
	LABEL		"";
	ITEMS
	{
	  w_hand,       /* nur in Hand sichtbar */
      Val_w,
      Val_x,
      Val_e
	}
}

/* Gert - Betrieb - Simulation **********************************************/
MENU Page_operation_simulation
{
	LABEL  "Simulation"
	       "|de|Simulation";
	ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_simulation_1,
        Page_group_simulation_2
	}
}

MENU Page_group_simulation_1
{
	LABEL  "";
	ITEMS
	{
	  met_alarm_test,         /* Methode */
	  met_test_stellmelder    /* Methode */
	}
}

MENU Page_group_simulation_2
{
	LABEL		"";
	ITEMS
	{
	  search_device       /* Methode */
	}
}

/* Gert - Rcksetzen ********************************************************/
MENU OnlineDialog_reset
{
	LABEL  "Reset" "|de|Rcksetzen";
	HELP   [master_reset_help];
	ITEMS
	{
		Page_reset_misc,
		Page_reset_diagnosis,
		Page_reset_factory
	}
}

/* Gert - Rcksetzen - Verschiedenes ****************************************/
MENU Page_reset_misc
{
	LABEL  "Reset miscellaneous"
	       "|de|Rcksetzen Verschiedenes";
	ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_reset_maintenance_1,
        Page_group_reset_maintenance_2,
        Page_group_reset_maintenance_3
	}
}

MENU Page_group_reset_maintenance_1
{
	LABEL  "";
	ITEMS
	{
        wegintegral,
        reset_valve_travel_counter   /* Methode */
	}
}

MENU Page_group_reset_maintenance_2
{
	LABEL  "";
	ITEMS
	{
        xmtr_specific_status_4, /* Kaltstart ausgefhrt */
        reset_cold_start_flag
	}
}

MENU Page_group_reset_maintenance_3
{
	LABEL  "";
	ITEMS
	{
        device_status,             /* Gertezustand */
        reset_fehler,              /* Methode */
        configuration_flag_reset   /* Methode Reset config change flag */
	}
}


/* Gert - Rcksetzen - Diagnose ****************************************/
MENU Page_reset_diagnosis
{
	LABEL  "Reset diagnosis"
	       "|de|Rcksetzen Diagnose";
	ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_reset_diagnosis
	}
}

MENU Page_group_reset_diagnosis
{
	LABEL  "";
	ITEMS
	{
      reset_logger,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {
        /* EXPERT+ Geraet */

      reset_x_long_term_histogram,
      reset_x_short_term_histogram,
      reset_e_long_term_setpoint_deviation,
      reset_e_short_term_setpoint_deviation,
      reset_z_long_term,
      reset_z_short_term,
      reset_y_x_long_term,
      reset_y_x_short_term,
      reset_hysteresis_long_term,
      reset_hysteresis_short_term,
      reset_lower_end_position,
      reset_lower_end_position_ref_values,
      reset_y_x_measured_values,
      reset_hysteresis_measured_values
      }

	}
}


/* Gert - Rcksetzen - Rcksetzen in Auslieferzustand ***********************/
MENU Page_reset_factory
{
	LABEL  "Factory reset"
	       "|de|Rcksetzen in Auslieferzustand";
	ITEMS
    {
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_reset_factory
	}
}

MENU Page_group_reset_factory
{
	LABEL  "";
	ITEMS
	{
        device_status,    /* Gertezustand */
		start_kaltstart   /* Methode */
	}
}

/* Gert - Selbstkalibrierung ************************************************/
MENU OnlineDialog_self_calibration
{
	LABEL	"Self calibration"
	        "|de|Selbstkalibrierung";
	HELP	"Activation of calibration sequences "
	        "(Zero point adjustment, Initialization)"
	        "|de|Aufruf von Kalibrierfunktionen "
	        "(Nullpunktabgleich, Initialisierung)";
	ITEMS
	{
        Page_self_calibration_1,
        Page_substitution,
        Page_operation_BA,
        Page_self_calibration_2
	}
}

MENU Page_operation_BA
{
	LABEL  "Mode"
	       "|de|Betriebsart";
	ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_MANUAL_1,
        Page_group_MANUAL_2,
        Page_group_operation_status
	}
}

MENU Page_self_calibration_1
{
	LABEL	"Self calibration"
	        "|de|Selbstkalibrierung";
	ITEMS
	{
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      leserichtung,
      stiftposition,
      initialisierungsart,
      druckgrenze,
      nennbereich,
      bauart
	}
}

MENU Page_self_calibration_2
{
	LABEL	"Start self calibration"
	        "|de|Start Selbstkalibrierung";
	ITEMS
	{
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      start_nullpunktabgleich,   /* Methode */
      start_initialisierung,     /* Methode */
      abort_init,                /* Methode */
      status_init,
      diag_reference_info,
      min_laufzeit_auf,
      min_laufzeit_zu,
      sicherheitsstellung,
      geraet_ini,
      anzahl_np,
      counter_init_start,
      xmtr_specific_status_0,    /* Initialisierungsfehler */
      xmtr_specific_status_3,    /* Initialisierungsfehler */
      xmtr_specific_status_7,    /* Fehler, die die Init. betreffen */
      error_code_81_ref_test_aborted,
      transmit_button
	}
}

MENU Page_substitution
{
	LABEL	"Substitution"
	        "|de|Ersatzabgleich";
	ITEMS
    {
        Page_group_substitution
	}
}

MENU Page_group_substitution
{
	LABEL  "";
	ITEMS
	{
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
	  xmtr_specific_status_5,
      schliessrichtung,
      blockierstellung,
      aktiv_x_begrenzung_oben
	}
}



/* Gert - Request-/Response Prambeln ***************************************/
MENU OnlineDialog_request_response_preambles
{
	LABEL  [menu_request_response_preambles];
	ITEMS
	{
        Page_request_response_preambles
	}
}

MENU Page_request_response_preambles
{
	LABEL  [menu_request_response_preambles];
	ITEMS
    {
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        Page_group_request_response_preambles
	}
}

MENU Page_group_request_response_preambles
{
	LABEL  "";
	ITEMS
	{
        request_preambles    (READ_ONLY),
		response_preambles
	}
}

/* Gert - Beobachterfunktionen AUTO ************************************************/
/*      OnlineDialog_AUTO_data_logger,
        OnlineDialog_AUTO_travel_hist_x,
        OnlineDialog_AUTO_deviation_hist_e,
        OnlineDialog_AUTO_cycle_counter_hist,
        OnlineDialog_AUTO_drive_signal_diagram,
        OnlineDialog_AUTO_trend_travel_end_pos,   */


MENU OnlineDialog_Diagnosis
{
	LABEL	"Diagnosis" "|de|Diagnose";
	ITEMS
	{
      Page_diagnosis_1
      /* Statusmeldungen */
      Page_display_state_1,

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {
        /* EXPERT+ Geraet */

        Page_display_state_4,
      }
      Page_display_state_2,
      Page_display_state_3

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {
        /* EXPERT+ Geraet */

        /* Beobachterfunktionen AUTO */
        Page_diagnosis_2,
        /* Tests HAND */
        Page_diagnosis_3,

        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
           Page_diagnosis_pst
        }
      }
	}
	HELP	"General diagnosis functions"
            "|de|Allgemeine Diagnosefunktionen";
}

MENU OnlineDialog_AUTO_data_logger
{
	LABEL	"Data logger (AUTO)" "|de|Datenlogger (AUTO)";
	ITEMS
	{
      Page_data_logger_1,
      Page_data_logger_2
	}
	HELP	"Diagnosis - Statistical information in mode Automatic - data logger"
            "|de|Diagnose - Beobachterfunktionen in Betriebsart Automatik - Datenlogger";
}

MENU OnlineDialog_AUTO_travel_hist_x
{
	LABEL	"Travel histogram x (AUTO)" "|de|Histogramm Ventilstellung x (AUTO)";
	ITEMS
	{
      Page_EDDL_x_long,
      Page_EDDL_x_short
	}
	HELP	"Diagnosis - Statistical information in mode Automatic - Travel histogram x"
            "|de|Diagnose - Beobachterfunktionen in Betriebsart Automatik - Histogramm Ventilstellung x";
}

MENU OnlineDialog_AUTO_deviation_hist_e
{
	LABEL	"Setpoint deviation histogram e (AUTO)" "|de|Histogramm Regelabweichung e (AUTO)";
	ITEMS
	{
	  Page_EDDL_e_long,
	  Page_EDDL_e_short
	}
	HELP	"Diagnosis - Statistical information in mode Automatic - Setpoint deviation histogram e"
            "|de|Diagnose - Beobachterfunktionen in Betriebsart Automatik - Histogramm Regelabweichung e";
}

MENU OnlineDialog_AUTO_cycle_counter_hist
{
	LABEL	"Cycle counter histogram (AUTO)" "|de|Histogramm Zyklenzhler (AUTO)";
	ITEMS
	{
      Page_EDDL_z_long,
      Page_EDDL_z_short
	}
	HELP	"Diagnosis - Statistical information in mode Automatic - Cycle counter histogram"
            "|de|Diagnose - Beobachterfunktionen in Betriebsart Automatik - Histogramm Zyklenzhler";
}

MENU OnlineDialog_AUTO_drive_signal_diagram
{
	LABEL	"Drive signal diagram (AUTO)" "|de|Diagramm Stellsignal y (AUTO)";
	ITEMS
	{
/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
      Page_display_EDDL_y_steady_long,
      Page_display_EDDL_y_steady_short,
      Page_EDDL_y_hysteresis
#endif
/* wenn enhanced PDM Version */
#ifdef _V602_
      Page_display_EDDL_y_steady,
      Page_EDDL_y_hysteresis
#endif
	}
	HELP	"Diagnosis - Statistical information in mode Automatic - Drive signal diagram"
            "|de|Diagnose - Beobachterfunktionen in Betriebsart Automatik - Diagramm Stellsignal y";
}

MENU OnlineDialog_AUTO_trend_travel_end_pos
{
	LABEL	"Trend of travel end position (AUTO)" "|de|Endlagentrend (AUTO)";
	ITEMS
	{
/* wenn enhanced PDM Version */
#ifdef _V602_
        Page_EDDL_et,
#endif

        Page_EDDL_et_1,
        Page_EDDL_et_2
	}
	HELP	"Diagnosis - Statistical information in mode Automatic - Trend of travel end position"
            "|de|Diagnose - Beobachterfunktionen in Betriebsart Automatik - Endlagentrend";
}

/* Gert - Testfunktionen HAND ************************************************/
/*      OnlineDialog_MAN_drive_signal_diagram_steady,
        OnlineDialog_MAN_drive_signal_diagram_hys,
        OnlineDialog_MAN_static_char,
        OnlineDialog_MAN_y_step_response   */

MENU OnlineDialog_MAN_drive_signal_diagram_steady
{
	LABEL	"Drive signal diagram steady (MAN)" "|de|Stellsignal y Stationr (HAND)";
	ITEMS
	{
        Page_diag_steady
	}
	HELP	"Diagnosis - Tests in mode Manual - Drive signal diagram steady"
            "|de|Diagnose - Testfunktionen in Betriebsart Hand - Stellsignal y Stationr";
}

MENU OnlineDialog_MAN_drive_signal_diagram_hys
{
	LABEL	"Drive signal diagram hysteresis (MAN)" "|de|Stellsignal y Hysterese (HAND)";
	ITEMS
	{
        Page_diag_hysteresis
	}
	HELP	"Diagnosis - Tests in mode Manual - Drive signal diagram hysteresis"
            "|de|Diagnose - Testfunktionen in Betriebsart Hand - Stellsignal y Hysterese";
}

MENU OnlineDialog_MAN_static_char
{
	LABEL	"Static characteristic (MAN)" "|de|Statische Kennlinie (HAND)";
	ITEMS
	{
        Page_diag_stat_char_1,
        Page_diag_stat_char_2
	}
	HELP	"Diagnosis - Tests in mode Manual - Static characteristic"
            "|de|Diagnose - Testfunktionen in Betriebsart Hand - Statische Kennlinie";
}

MENU OnlineDialog_MAN_y_step_response
{
	LABEL	"Step response (MAN)" "|de|Sprungantwort (HAND)";
	ITEMS
	{
        Page_step_response_1,
        Page_step_response_2
	}
	HELP	"Diagnosis - Tests in mode Manual - Step response"
            "|de|Diagnose - Testfunktionen in Betriebsart Hand - Sprungantwort";
}

MENU Page_diagnosis_pst
{
	LABEL	"PST" "|de|PST";
	ITEMS
	{
      input_pst_enabling_code,
      pst_mode_on_off,
      pst_operating_mode,
      pst_elapsed_hours_meter_next_PST_test,
      pst_elapsed_hours_meter_auto_test_time,
      transmit_button,
      SEPARATOR,
      Page_pst_1,
      Page_pst_2
	}
	HELP	"Diagnosis - PST"
            "|de|Diagnose - PST";
}


/* ------------------------------------------------------------------------ */
/* OFFLINE Menues                                                           */
/* ------------------------------------------------------------------------ */


/*****************************************************************************/
/* Defines fuer SCHREIBEN */

/* ------------------------------------------------------------------------ */
/* Schreiben in ein EXPERT+ Geraet */
/* ------------------------------------------------------------------------ */

#define upload_EXPERT_PLUS                                               \
      leserichtung                 ,                                     \
      stiftposition                ,                                     \
      nennbereich                  ,                                     \
      /* nur Schreiben wenn:                                             \
         Regler NICHT initialisiert UND                                  \
         Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */          \
      IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))    \
      {                                                                  \
        schliessrichtung             , /* Abhaengigkeit */               \
        blockierstellung             , /* Abhaengigkeit */               \
      }                                                                  \
      initialisierungsart          ,                                     \
      bewegungsrichtung            ,                                     \
      x_bereich_anfang             ,                                     \
      x_bereich_ende               ,                                     \
      aktiv_x_begrenzung_unten     ,                                     \
      x_begrenzung_unten           ,                                     \
      aktiv_x_begrenzung_oben      ,                                     \
      x_begrenzung_oben            ,                                     \
      w_ma_bereich_anfang          ,                                     \
      w_ma_bereich_ende            ,                                     \
      aktiv_endlage_w_kleiner      ,                                     \
      endlage_w_kleiner            ,                                     \
      aktiv_endlage_w_groesser     ,                                     \
      endlage_w_groesser           ,                                     \
      druckgrenze                  ,                                     \
      toleranzband                 ,                                     \
      kennlinienauswahl            ,                                     \
      gew_laufzeit_auf             ,                                     \
      gew_laufzeit_zu              ,                                     \
      gw_wegintegral               ,                                     \
      alarmmodus                   ,                                     \
      /* nur Schreiben wenn ind. Grenzkontakt nicht eingebaut */         \
      IF (ind_grenzkontakt == NOT_IMPLEMENTED)                           \
      {                                                                  \
        aktiv_gw_a1                ,                                     \
        grenzwert_a1               ,                                     \
      }                                                                  \
      aktiv_gw_a2                  ,                                     \
      grenzwert_a2                 ,                                     \
      /* nur schreibbar wenn Stellungsmelder eingebaut */                \
      IF (stellungsmelder == 1)                                          \
      {                                                                  \
        wirkr_stellmelder            ,                                   \
        stoerm_mit_stellmelder       ,                                   \
      }                                                                  \
      stoerm_sonderfunktion        ,                                     \
      stoerm_wegintegral           ,                                     \
      tag                          ,                                     \
      textfeld_1                   ,                                     \
      textfeld_2                   ,                                     \
      textfeld_3                   ,                                     \
      textfeld_4                   ,                                     \
      textfeld_5                   ,                                     \
      nachlaufzeit                 ,                                     \
      ident_antrieb                ,                                     \
      booster                      ,                                     \
      antriebswirkflaeche          ,                                     \
      stelldruckbereich_anfang     ,                                     \
      stelldruckbereich_ende       ,                                     \
      versorgungsdruck             ,                                     \
      ident_ventil                 ,                                     \
      fliessrichtung               ,                                     \
      stangenabdichtung            ,                                     \
      dichtkante                   ,                                     \
      druckentlastung              ,                                     \
      kennlinie_kegel              ,                                     \
      nennweiten_norm              ,                                     \
      nennweite_dn                 ,                                     \
      kvs_einheit                  ,                                     \
      kvs_wert                     ,                                     \
      sitzdurchmesser_ventil       ,                                     \
      descriptor                   ,                                     \
      message                      ,                                     \
      kennlinientyp                ,                                     \
      date                         ,                                     \
      final_assembly_number        ,                                     \
      long_tag                     ,                                     \
      ueberwachungszeit            ,                                     \
      bauart                       ,                                     \
      anbau                        ,                                     \
      zero_point_limit,                                                  \
      condensed_mask_code_50,                                            \
      condensed_mask_code_51,                                            \
      condensed_mask_code_52,                                            \
      condensed_mask_code_53,                                            \
      condensed_mask_code_54,                                            \
      condensed_mask_code_55,                                            \
      condensed_mask_code_56,                                            \
      condensed_mask_code_57,                                            \
      condensed_mask_code_58,                                            \
      condensed_mask_code_59,                                            \
      condensed_mask_code_60,                                            \
      condensed_mask_code_62,                                            \
      condensed_mask_code_63,                                            \
      condensed_mask_code_64,                                            \
      condensed_mask_code_65,                                            \
      condensed_mask_code_66,                                            \
      condensed_mask_code_67,                                            \
      condensed_mask_code_68,                                            \
      condensed_mask_code_69,                                            \
      condensed_mask_code_70,                                            \
      condensed_mask_code_71,                                            \
      condensed_mask_code_73,                                            \
      condensed_mask_code_74,                                            \
      condensed_mask_code_75,                                            \
      condensed_mask_code_76,                                            \
      condensed_mask_code_77,                                            \
      condensed_mask_code_78,                                            \
      condensed_mask_code_80,                                            \
      condensed_mask_valve_travel,                                       \
      condensed_mask_temp_40,                                            \
      condensed_mask_temp_80,                                            \
                                                                         \
      /* EXPERT+ Parameter */                                            \
      hys_stell_y,                                                       \
      stepstart,                                                         \
      stepend,                                                           \
      step_sample_rate,                                                  \
      latency_after_step,                                                \
      step_selection,                                                    \
      datalogger_select,                                                 \
      trigger_select,                                                    \
      sample_rate,                                                       \
      start_value,                                                       \
      logging_limit,                                                     \
      pretrigger_time,                                                   \
      AirSupply_6_condensed_mask,                                        \
      AirSupply_1_condensed_mask,                                        \
      AirSupply_3_condensed_mask,                                        \
      AirSupply_2_condensed_mask,                                        \
      AirSupply_4_condensed_mask,                                        \
      AirSupply_5_condensed_mask                                         \
      ShiftingWorkingRange_1_condensed_mask,                             \
      ShiftingWorkingRange_2_condensed_mask,                             \
      LeakagePn_1_condensed_mask,                                        \
      LeakagePn_3_condensed_mask,                                        \
      LeakagePn_4_condensed_mask,                                        \
      LeakagePn_2_condensed_mask,                                        \
      LimitWorkingRange_1_condensed_mask,                                \
      LimitWorkingRange_2_condensed_mask,                                \
      LimitWorkingRange_3_condensed_mask,                                \
      ObservingEndPosition_1_condensed_mask,                             \
      ObservingEndPosition_2_condensed_mask,                             \
      ObservingEndPosition_3_condensed_mask,                             \
      ObservingEndPosition_4_condensed_mask,                             \
      ObservingEndPosition_5_condensed_mask,                             \
      ObservingEndPosition_6_condensed_mask,                             \
      ConnectionPosValve_1_condensed_mask,                               \
      ConnectionPosValve_2_condensed_mask,                               \
      ConnectionPosValve_3_condensed_mask,                               \
      WorkingRange_1_condensed_mask,                                     \
      WorkingRange_2_condensed_mask,                                     \
      WorkingRange_3_condensed_mask,                                     \
      WorkingRange_4_condensed_mask,                                     \
      Friction_1_condensed_mask,                                         \
      Friction_2_condensed_mask,                                         \
      Friction_3_condensed_mask,                                         \
      Friction_4_condensed_mask,                                         \
      Friction_5_condensed_mask,                                         \
      Friction_6_condensed_mask,                                         \
      ActSpring_1_condensed_mask,                                        \
      ActSpring_2_condensed_mask,                                        \
      ActSpring_3_condensed_mask,                                        \
      ActSpring_4_condensed_mask,                                        \
      ActSpring_5_condensed_mask,                                        \
      InnerLeakage_1_condensed_mask,                                     \
      InnerLeakage_2_condensed_mask,                                     \
      InnerLeakage_3_condensed_mask,                                     \
      ExternalLeakage_1_condensed_mask,                                  \
      ExternalLeakage_2_condensed_mask,                                  \
      kl_stepstart,                                                      \
      kl_stepend,                                                        \
      kl_delay_time_after_step,                                          \
      kl_anzahl_bis_umkehr,                                              \
      sample_rate_st_hist,                                               \
      sample_rate_st_hist_e,                                             \
      wegaufnehmerausfall,                                               \
                                                                         \
      /* Schreibbare PST Parameter */                                    \
                                                                         \
      /* Wenn PST Regler */                                              \
      IF ( diag_level == DIAG_LEVEL_PST )                                \
      {                                                                  \
/* PST Betriebsarten werden hier nicht geschrieben                       \
      pst_mode_on_off,                                                   \
      pst_operating_mode,                           */                   \
      pst_activation_ramp_function,                                      \
      pst_activation_tol_band_control,                                   \
      pst_fault_alarm_output,                                            \
      pst_activation_y_control,                                          \
      pst_activation_x_control,                                          \
      pst_max_test_duration,                                             \
      pst_ramp_time_rising,                                              \
      pst_ramp_time_falling,                                             \
      pst_settling_time_before_start,                                    \
      pst_tolerance_band,                                                \
      pst_step_tolerance_limit,                                          \
      pst_y_control_value,                                               \
      pst_x_control_value,                                               \
      PST_1_condensed_mask                                              \
      }



/* ------------------------------------------------------------------------ */
/* Schreiben in ein EXPERT Geraet */
/* ------------------------------------------------------------------------ */
#define upload_EXPERT                                                    \
      leserichtung                 ,                                     \
      stiftposition                ,                                     \
      nennbereich                  ,                                     \
      /* nur Schreiben wenn:                                             \
         Regler NICHT initialisiert UND                                  \
         Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */          \
      IF ((geraet_ini == 0) && (initialisierungsart == INIT_ART_SUB))    \
      {                                                                  \
        schliessrichtung             , /* Abhaengigkeit */               \
        blockierstellung             , /* Abhaengigkeit */               \
      }                                                                  \
      initialisierungsart          ,                                     \
      bewegungsrichtung            ,                                     \
      x_bereich_anfang             ,                                     \
      x_bereich_ende               ,                                     \
      aktiv_x_begrenzung_unten     ,                                     \
      x_begrenzung_unten           ,                                     \
      aktiv_x_begrenzung_oben      ,                                     \
      x_begrenzung_oben            ,                                     \
      w_ma_bereich_anfang          ,                                     \
      w_ma_bereich_ende            ,                                     \
      aktiv_endlage_w_kleiner      ,                                     \
      endlage_w_kleiner            ,                                     \
      aktiv_endlage_w_groesser     ,                                     \
      endlage_w_groesser           ,                                     \
      druckgrenze                  ,                                     \
      toleranzband                 ,                                     \
      kennlinienauswahl            ,                                     \
      gew_laufzeit_auf             ,                                     \
      gew_laufzeit_zu              ,                                     \
      gw_wegintegral               ,                                     \
      alarmmodus                   ,                                     \
      /* nur Schreiben wenn ind. Grenzkontakt nicht eingebaut */         \
      IF (ind_grenzkontakt == NOT_IMPLEMENTED)                           \
      {                                                                  \
        aktiv_gw_a1                ,                                     \
        grenzwert_a1               ,                                     \
      }                                                                  \
      aktiv_gw_a2                  ,                                     \
      grenzwert_a2                 ,                                     \
      /* nur schreibbar wenn Stellungsmelder eingebaut */                \
      IF (stellungsmelder == 1)                                          \
      {                                                                  \
        wirkr_stellmelder            ,                                   \
        stoerm_mit_stellmelder       ,                                   \
      }                                                                  \
      stoerm_sonderfunktion        ,                                     \
      stoerm_wegintegral           ,                                     \
      tag                          ,                                     \
      textfeld_1                   ,                                     \
      textfeld_2                   ,                                     \
      textfeld_3                   ,                                     \
      textfeld_4                   ,                                     \
      textfeld_5                   ,                                     \
      nachlaufzeit                 ,                                     \
      ident_antrieb                ,                                     \
      booster                      ,                                     \
      antriebswirkflaeche          ,                                     \
      stelldruckbereich_anfang     ,                                     \
      stelldruckbereich_ende       ,                                     \
      versorgungsdruck             ,                                     \
      ident_ventil                 ,                                     \
      fliessrichtung               ,                                     \
      stangenabdichtung            ,                                     \
      dichtkante                   ,                                     \
      druckentlastung              ,                                     \
      kennlinie_kegel              ,                                     \
      nennweiten_norm              ,                                     \
      nennweite_dn                 ,                                     \
      kvs_einheit                  ,                                     \
      kvs_wert                     ,                                     \
      sitzdurchmesser_ventil       ,                                     \
      descriptor                   ,                                     \
      message                      ,                                     \
      kennlinientyp                ,                                     \
      date                         ,                                     \
      final_assembly_number        ,                                     \
      long_tag                     ,                                     \
      ueberwachungszeit            ,                                     \
      bauart                       ,                                     \
      anbau                        ,                                     \
      zero_point_limit,                                                  \
      condensed_mask_code_50,                                            \
      condensed_mask_code_51,                                            \
      condensed_mask_code_52,                                            \
      condensed_mask_code_53,                                            \
      condensed_mask_code_54,                                            \
      condensed_mask_code_55,                                            \
      condensed_mask_code_56,                                            \
      condensed_mask_code_57,                                            \
      condensed_mask_code_58,                                            \
      condensed_mask_code_59,                                            \
      condensed_mask_code_60,                                            \
      condensed_mask_code_62,                                            \
      condensed_mask_code_63,                                            \
      condensed_mask_code_64,                                            \
      condensed_mask_code_65,                                            \
      condensed_mask_code_66,                                            \
      condensed_mask_code_67,                                            \
      condensed_mask_code_68,                                            \
      condensed_mask_code_69,                                            \
      condensed_mask_code_70,                                            \
      condensed_mask_code_71,                                            \
      condensed_mask_code_73,                                            \
      condensed_mask_code_74,                                            \
      condensed_mask_code_75,                                            \
      condensed_mask_code_76,                                            \
      condensed_mask_code_77,                                            \
      condensed_mask_code_78,                                            \
      condensed_mask_code_80,                                            \
      condensed_mask_valve_travel,                                       \
      condensed_mask_temp_40,                                            \
      condensed_mask_temp_80



MENU upload_variables /* Parameter die in das Geraet geschrieben werden */
{
    LABEL "Upload variables";
    ITEMS
    {

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {

        /* ------------------------------------------------------------------------ */
        /* Schreiben in ein EXPERT+/PST Geraet */
        /* ------------------------------------------------------------------------ */
        upload_EXPERT_PLUS

      }
      ELSE
      {

        /* ------------------------------------------------------------------------ */
        /* Schreiben in ein EXPERT Geraet */
        /* ------------------------------------------------------------------------ */
        upload_EXPERT

      }
    }

#ifdef _V602_
	PRE_WRITE_ACTIONS
	{
      /* nur bei PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code; /* vor dem Schreiben Freigabecode abfragen */
      }
    }
#endif    
}



/*****************************************************************************/
/* Defines fuer LESEN */

/* ------------------------------------------------------------------------ */
/* Lesen aus ein EXPERT Geraet */
/* ------------------------------------------------------------------------ */
#define download_EXPERT                            \
      diag_level,                                  \
	  tag,                                         \
	  long_tag,                                    \
	  descriptor,                                  \
	  message,                                     \
	  textfeld_1,                                  \
	  textfeld_2,                                  \
	  textfeld_3,                                  \
	  textfeld_4,                                  \
	  textfeld_5,                                  \
	  device_id,                                   \
	  erzeugnis_num_regler,                        \
	  firmware_version,                            \
	  final_assembly_number,                       \
      date,                                        \
      universal_revision,                          \
      transmitter_revision,                        \
      request_preambles,                           \
	  device_type,                                 \
	  geraetetyp,                                  \
	  ident_antrieb,                               \
      /* erst Stiftposition, dann Nennbereich einlesen */ \
      stiftposition,                               \
	  bauart,                                      \
	  anbau,                                       \
	  booster,                                     \
	  antriebswirkflaeche,                         \
	  stelldruckbereich_anfang,                    \
	  stelldruckbereich_ende,                      \
	  versorgungsdruck,                            \
      ident_ventil,                                \
      fliessrichtung,                              \
      stangenabdichtung,                           \
      dichtkante,                                  \
      druckentlastung,                             \
      kennlinie_kegel,                             \
      nennweiten_norm,                             \
      nennweite_dn,                                \
      kvs_wert,                                    \
      kvs_einheit,                                 \
      sitzdurchmesser_ventil,                      \
	  magnetventil,                                \
	  stellungsmelder,                             \
	  wirkr_stellmelder,                           \
	  ind_grenzkontakt,                            \
	  bewegungsrichtung,                           \
	  w_ma_bereich_anfang,                         \
      w_ma_bereich_ende,                           \
      aktiv_endlage_w_kleiner,                     \
      endlage_w_kleiner,                           \
      aktiv_endlage_w_groesser,                    \
      endlage_w_groesser,                          \
      gew_laufzeit_auf,                            \
      gew_laufzeit_zu,                             \
	  x_bereich_anfang,                            \
	  x_bereich_ende,                              \
	  aktiv_x_begrenzung_unten,                    \
	  x_begrenzung_unten,                          \
	  aktiv_x_begrenzung_oben,                     \
	  x_begrenzung_oben,                           \
	  kennlinienauswahl,                           \
	  kennlinientyp,                               \
	  x0,                                          \
	  x1,                                          \
	  x2,                                          \
	  x3,                                          \
	  x4,                                          \
	  x5,                                          \
	  x6,                                          \
	  x7,                                          \
	  x8,                                          \
	  x9,                                          \
	  x10,                                         \
	  y0,                                          \
	  y1,                                          \
	  y2,                                          \
	  y3,                                          \
	  y4,                                          \
	  y5,                                          \
	  y6,                                          \
	  y7,                                          \
	  y8,                                          \
	  y9,                                          \
	  y10,                                         \
	  kp_stufe,                                    \
	  tv_stufe,                                    \
      sicherheitsstellung,                         \
	  toleranzband,                                \
	  nachlaufzeit,                                \
	  wegintegral,                                 \
	  gw_wegintegral,                              \
      alarmmodus,                                  \
      aktiv_gw_a1,                                 \
      grenzwert_a1,                                \
      aktiv_gw_a2,                                 \
      grenzwert_a2,                                \
	  stoerm_sonderfunktion,                       \
	  stoerm_wegintegral,                          \
	  stoerm_mit_stellmelder,                      \
      leserichtung,                                \
      initialisierungsart,                         \
      druckgrenze,                                 \
      nennbereich,                                 \
      min_laufzeit_auf,                                          \
      min_laufzeit_zu,                                           \
      sicherheitsstellung,                                       \
      geraet_ini,                                                \
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */  \
	  schliessrichtung,                                          \
	  blockierstellung,                                          \
	  geraetesperre,                                             \
	  anzahl_np,                                                 \
	  zertifizierung,                                            \
      zero_point_limit,                                          \
      messages_1 ,                                               \
      messages_2 ,                                               \
      messages_3 ,                                               \
      messages_4 ,                                               \
      messages_5 ,                                               \
      messages_6 ,                                               \
      messages_7 ,                                               \
      messages_8 ,                                               \
      messages_9 ,                                               \
      messages_10,                                               \
      messages_11,                                               \
      messages_12,                                               \
      messages_13,                                               \
      messages_14,                                               \
      messages_15,                                               \
      messages_16,                                               \
      messages_17,                                               \
      messages_18,                                               \
      messages_19,                                               \
      messages_20,                                               \
      messages_21,                                               \
      messages_22,                                               \
      messages_23,                                               \
      messages_24,                                               \
      messages_25,                                               \
      messages_26,                                               \
      messages_27,                                               \
      messages_28,                                               \
      messages_29,                                               \
      messages_30,                                               \
      elapsed_hours_meter_1 ,                                    \
      elapsed_hours_meter_2 ,                                    \
      elapsed_hours_meter_3 ,                                    \
      elapsed_hours_meter_4 ,                                    \
      elapsed_hours_meter_5 ,                                    \
      elapsed_hours_meter_6 ,                                    \
      elapsed_hours_meter_7 ,                                    \
      elapsed_hours_meter_8 ,                                    \
      elapsed_hours_meter_9 ,                                    \
      elapsed_hours_meter_10,                                    \
      elapsed_hours_meter_11,                                    \
      elapsed_hours_meter_12,                                    \
      elapsed_hours_meter_13,                                    \
      elapsed_hours_meter_14,                                    \
      elapsed_hours_meter_15,                                    \
      elapsed_hours_meter_16,                                    \
      elapsed_hours_meter_17,                                    \
      elapsed_hours_meter_18,                                    \
      elapsed_hours_meter_19,                                    \
      elapsed_hours_meter_20,                                    \
      elapsed_hours_meter_21,                                    \
      elapsed_hours_meter_22,                                    \
      elapsed_hours_meter_23,                                    \
      elapsed_hours_meter_24,                                    \
      elapsed_hours_meter_25,                                    \
      elapsed_hours_meter_26,                                    \
      elapsed_hours_meter_27,                                    \
      elapsed_hours_meter_28,                                    \
      elapsed_hours_meter_29,                                    \
      elapsed_hours_meter_30,                                    \
      hart_schreibschutz,                                        \
      namur_sammelstatus,                                        \
      stoerung_vorhanden,                                        \
      status_a1,                                                 \
      status_a2,                                                 \
      x_unterschreitet_a1,                                       \
      x_ueberschreitet_a2,                                       \
      reglerstatus,                                              \
      current_temperature,                                       \
      status_init,                                               \
      xmtr_specific_status_0,                                    \
      xmtr_specific_status_1,                                    \
      xmtr_specific_status_2,                                    \
      xmtr_specific_status_3,                                    \
      xmtr_specific_status_4,                                    \
      status_init,                                               \
      diag_reference_info,                                       \
      elapsed_hours_meter,                                       \
      device_in_closed_loop,                                     \
      device_switched_on_since_init,                             \
      device_in_closed_loop_since_init,                          \
      zwangsentlueftung,                                         \
      counter_init_start,                                        \
      min_temperature,                                           \
      max_temperature,                                           \
      his_t_zeit_min_temperatur,                                 \
      his_t_zeit_max_temperatur,                                 \
      condensed_mask_code_50,                                    \
      condensed_mask_code_51,                                    \
      condensed_mask_code_52,                                    \
      condensed_mask_code_53,                                    \
      condensed_mask_code_54,                                    \
      condensed_mask_code_55,                                    \
      condensed_mask_code_56,                                    \
      condensed_mask_code_57,                                    \
      condensed_mask_code_58,                                    \
      condensed_mask_code_59,                                    \
      condensed_mask_code_60,                                    \
      condensed_mask_code_62,                                    \
      condensed_mask_code_63,                                    \
      condensed_mask_code_64,                                    \
      condensed_mask_code_65,                                    \
      condensed_mask_code_66,                                    \
      condensed_mask_code_67,                                    \
      condensed_mask_code_68,                                    \
      condensed_mask_code_69,                                    \
      condensed_mask_code_70,                                    \
      condensed_mask_code_71,                                    \
      condensed_mask_code_73,                                    \
      condensed_mask_code_74,                                    \
      condensed_mask_code_75,                                    \
      condensed_mask_code_76,                                    \
      condensed_mask_code_77,                                    \
      condensed_mask_code_78,                                    \
      condensed_mask_code_80,                                    \
      condensed_mask_valve_travel,                               \
      condensed_mask_temp_40,                                    \
      condensed_mask_temp_80


/* ------------------------------------------------------------------------ */
/* Lesen aus ein EXPERT+ Geraet */
/* ------------------------------------------------------------------------ */
#define download_EXPERT_PLUS                \
      diag_level,                           \
	  tag,                                  \
	  long_tag,                             \
	  descriptor,                           \
	  message,                              \
	  textfeld_1,                           \
	  textfeld_2,                           \
	  textfeld_3,                           \
	  textfeld_4,                           \
	  textfeld_5,                           \
	  device_id,                            \
	  erzeugnis_num_regler,                 \
	  firmware_version,                     \
	  final_assembly_number,                \
      date,                                 \
      universal_revision,                   \
      transmitter_revision,                 \
      request_preambles,                    \
	  device_type,                          \
	  geraetetyp,                           \
	  ident_antrieb,                        \
      /* erst Stiftposition, dann Nennbereich einlesen */ \
      stiftposition,                        \
	  bauart,                               \
	  anbau,                                \
	  booster,                              \
	  antriebswirkflaeche,                  \
	  stelldruckbereich_anfang,             \
	  stelldruckbereich_ende,               \
	  versorgungsdruck,                     \
      ident_ventil,                         \
      fliessrichtung,                       \
      stangenabdichtung,                    \
      dichtkante,                           \
      druckentlastung,                      \
      kennlinie_kegel,                      \
      nennweiten_norm,                      \
      nennweite_dn,                         \
      kvs_wert,                             \
      kvs_einheit,                          \
      sitzdurchmesser_ventil,               \
	  magnetventil,                         \
	  stellungsmelder,                      \
	  wirkr_stellmelder,                    \
	  ind_grenzkontakt,                     \
	  bewegungsrichtung,                    \
	  w_ma_bereich_anfang,                  \
      w_ma_bereich_ende,                    \
      aktiv_endlage_w_kleiner,              \
      endlage_w_kleiner,                    \
      aktiv_endlage_w_groesser,             \
      endlage_w_groesser,                   \
      gew_laufzeit_auf,                     \
      gew_laufzeit_zu,                      \
	  x_bereich_anfang,                     \
	  x_bereich_ende,                       \
	  aktiv_x_begrenzung_unten,             \
	  x_begrenzung_unten,                   \
	  aktiv_x_begrenzung_oben,              \
	  x_begrenzung_oben,                    \
	  kennlinienauswahl,                    \
	  kennlinientyp,                        \
	  x0,                                   \
	  x1,                                   \
	  x2,                                   \
	  x3,                                   \
	  x4,                                   \
	  x5,                                   \
	  x6,                                   \
	  x7,                                   \
	  x8,                                   \
	  x9,                                   \
	  x10,                                  \
	  y0,                                   \
	  y1,                                   \
	  y2,                                   \
	  y3,                                   \
	  y4,                                   \
	  y5,                                   \
	  y6,                                   \
	  y7,                                   \
	  y8,                                   \
	  y9,                                   \
	  y10,                                  \
	  kp_stufe,                             \
	  tv_stufe,                             \
      sicherheitsstellung,                  \
	  toleranzband,                         \
	  nachlaufzeit,                         \
	  wegintegral,                          \
	  gw_wegintegral,                       \
      alarmmodus,                           \
      aktiv_gw_a1,                          \
      grenzwert_a1,                         \
      aktiv_gw_a2,                          \
      grenzwert_a2,                         \
	  stoerm_sonderfunktion,                \
	  stoerm_wegintegral,                   \
	  stoerm_mit_stellmelder,               \
      leserichtung,                         \
      initialisierungsart,                  \
      druckgrenze,                          \
      nennbereich,                          \
      min_laufzeit_auf,                                         \
      min_laufzeit_zu,                                          \
      sicherheitsstellung,                                      \
      geraet_ini,                                               \
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */ \
	  schliessrichtung,                                         \
	  blockierstellung,                                         \
	  geraetesperre,                        \
	  anzahl_np,                            \
	  zertifizierung,                       \
      zero_point_limit,                     \
      messages_1 ,                          \
      messages_2 ,                          \
      messages_3 ,                          \
      messages_4 ,                          \
      messages_5 ,                          \
      messages_6 ,                          \
      messages_7 ,                          \
      messages_8 ,                          \
      messages_9 ,                          \
      messages_10,                          \
      messages_11,                          \
      messages_12,                          \
      messages_13,                          \
      messages_14,                          \
      messages_15,                          \
      messages_16,                          \
      messages_17,                          \
      messages_18,                          \
      messages_19,                          \
      messages_20,                          \
      messages_21,                          \
      messages_22,                          \
      messages_23,                          \
      messages_24,                          \
      messages_25,                          \
      messages_26,                          \
      messages_27,                          \
      messages_28,                          \
      messages_29,                          \
      messages_30,                          \
      elapsed_hours_meter_1 ,               \
      elapsed_hours_meter_2 ,               \
      elapsed_hours_meter_3 ,               \
      elapsed_hours_meter_4 ,               \
      elapsed_hours_meter_5 ,               \
      elapsed_hours_meter_6 ,               \
      elapsed_hours_meter_7 ,               \
      elapsed_hours_meter_8 ,               \
      elapsed_hours_meter_9 ,               \
      elapsed_hours_meter_10,               \
      elapsed_hours_meter_11,               \
      elapsed_hours_meter_12,               \
      elapsed_hours_meter_13,               \
      elapsed_hours_meter_14,               \
      elapsed_hours_meter_15,               \
      elapsed_hours_meter_16,               \
      elapsed_hours_meter_17,               \
      elapsed_hours_meter_18,               \
      elapsed_hours_meter_19,               \
      elapsed_hours_meter_20,               \
      elapsed_hours_meter_21,               \
      elapsed_hours_meter_22,               \
      elapsed_hours_meter_23,               \
      elapsed_hours_meter_24,               \
      elapsed_hours_meter_25,               \
      elapsed_hours_meter_26,               \
      elapsed_hours_meter_27,               \
      elapsed_hours_meter_28,               \
      elapsed_hours_meter_29,               \
      elapsed_hours_meter_30,               \
      hart_schreibschutz,                   \
      namur_sammelstatus,                   \
      stoerung_vorhanden,                   \
      status_a1,                            \
      status_a2,                            \
      x_unterschreitet_a1,                  \
      x_ueberschreitet_a2,                  \
      reglerstatus,                         \
      current_temperature,                  \
      status_init,                          \
      xmtr_specific_status_0,               \
      xmtr_specific_status_1,               \
      xmtr_specific_status_2,               \
      xmtr_specific_status_3,               \
      xmtr_specific_status_4,               \
      status_init,                          \
      diag_reference_info,                  \
      elapsed_hours_meter,                  \
      device_in_closed_loop,                \
      device_switched_on_since_init,        \
      device_in_closed_loop_since_init,     \
      zwangsentlueftung,                    \
      counter_init_start,                   \
      min_temperature,                      \
      max_temperature,                      \
      his_t_zeit_min_temperatur,            \
      his_t_zeit_max_temperatur,            \
      condensed_mask_code_50,               \
      condensed_mask_code_51,               \
      condensed_mask_code_52,               \
      condensed_mask_code_53,               \
      condensed_mask_code_54,               \
      condensed_mask_code_55,               \
      condensed_mask_code_56,               \
      condensed_mask_code_57,               \
      condensed_mask_code_58,               \
      condensed_mask_code_59,               \
      condensed_mask_code_60,               \
      condensed_mask_code_62,               \
      condensed_mask_code_63,               \
      condensed_mask_code_64,               \
      condensed_mask_code_65,               \
      condensed_mask_code_66,               \
      condensed_mask_code_67,               \
      condensed_mask_code_68,               \
      condensed_mask_code_69,               \
      condensed_mask_code_70,               \
      condensed_mask_code_71,               \
      condensed_mask_code_73,               \
      condensed_mask_code_74,               \
      condensed_mask_code_75,               \
      condensed_mask_code_76,               \
      condensed_mask_code_77,               \
      condensed_mask_code_78,               \
      condensed_mask_code_80,               \
      condensed_mask_valve_travel,          \
      condensed_mask_temp_40,               \
      condensed_mask_temp_80,               \
                                            \
      /* EXPERT+ Parameter */               \
      hys_stell_y,                          \
      stepstart,                            \
      stepend,                              \
      step_sample_rate,                     \
      latency_after_step,                   \
      step_selection,                       \
      datalogger_select,                    \
      trigger_select,                       \
      sample_rate,                          \
      start_value,                              \
      logging_limit,                            \
      pretrigger_time,                          \
      max_pretrigger_time,                      \
      AirSupply_6_condensed_mask,               \
      AirSupply_1_condensed_mask,               \
      AirSupply_3_condensed_mask,               \
      AirSupply_2_condensed_mask,               \
      AirSupply_4_condensed_mask,               \
      AirSupply_5_condensed_mask                \
      ShiftingWorkingRange_1_condensed_mask,    \
      ShiftingWorkingRange_2_condensed_mask,    \
      LeakagePn_1_condensed_mask,               \
      LeakagePn_3_condensed_mask,               \
      LeakagePn_4_condensed_mask,               \
      LeakagePn_2_condensed_mask,               \
      LimitWorkingRange_1_condensed_mask,       \
      LimitWorkingRange_2_condensed_mask,       \
      LimitWorkingRange_3_condensed_mask,       \
      ObservingEndPosition_1_condensed_mask,    \
      ObservingEndPosition_2_condensed_mask,    \
      ObservingEndPosition_3_condensed_mask,    \
      ObservingEndPosition_4_condensed_mask,    \
      ObservingEndPosition_5_condensed_mask,    \
      ObservingEndPosition_6_condensed_mask,    \
      ConnectionPosValve_1_condensed_mask,      \
      ConnectionPosValve_2_condensed_mask,      \
      ConnectionPosValve_3_condensed_mask,      \
      WorkingRange_1_condensed_mask,            \
      WorkingRange_2_condensed_mask,            \
      WorkingRange_3_condensed_mask,            \
      WorkingRange_4_condensed_mask,            \
      Friction_1_condensed_mask,                \
      Friction_2_condensed_mask,                \
      Friction_3_condensed_mask,                \
      Friction_4_condensed_mask,                \
      Friction_5_condensed_mask,                \
      Friction_6_condensed_mask,                \
      ActSpring_1_condensed_mask,               \
      ActSpring_2_condensed_mask,               \
      ActSpring_3_condensed_mask,               \
      ActSpring_4_condensed_mask,               \
      ActSpring_5_condensed_mask,               \
      InnerLeakage_1_condensed_mask,            \
      InnerLeakage_2_condensed_mask,            \
      InnerLeakage_3_condensed_mask,            \
      ExternalLeakage_1_condensed_mask,         \
      ExternalLeakage_2_condensed_mask,         \
      kl_stepstart,                             \
      kl_stepend,                               \
      kl_delay_time_after_step,                 \
      kl_anzahl_bis_umkehr,                     \
      sample_rate_st_hist,                      \
      sample_rate_st_hist_e,                    \
      diag_reference_info,                      \
      error_code_81_ref_test_aborted,           \
      temp_period_time_low,                     \
      temp_period_time_high,                    \
      air_supply,                               \
      shifting_working_range,                   \
      leakage_pneumatic,                        \
      limit_working_range,                      \
      observing_end_position,                   \
      connection_positioner_valve,              \
      working_range,                            \
      friction,                                 \
      actuator_spring,                          \
      inner_leakage,                            \
      external_leakage,                         \
      pst_emergency_shut_down                   \
      his_x_mittelwert_int_1,                   \
      his_x_anzahl_messpunkte,                  \
      his_x_mittelwert_kurz,                    \
      mittelwert_e_lang,                        \
      gesamtanzahl,                             \
      deviation_min,                            \
      deviation_max,                            \
      his_e_mittelwert_kurz,                    \
      his_z_mittelwert_int,                     \
      his_z_gesamtanzahl,                       \
      his_z_dynamic_stress_factor,              \
      his_z_mittelwert_kurz,                    \
      test_information,                         \
      ref_value_valve_position,                 \
      lower_end_position_ref_value_bsz,         \
      trend_travel_end_pos_drive_signal_ref,    \
      automatical_test_status,                  \
      hand_y_stat_test_information,             \
      hand_y_hys_test_information,              \
      kl_step_height,                           \
      kl_min_dead_band,                         \
      kl_average_dead_band,                     \
      kl_max_dead_band,                         \
      duration_of_test,                         \
      overshoot_rising,                         \
      dead_time_rising,                         \
      time_63_rising,                           \
      time_98_rising,                           \
      rise_time_rising_step,                    \
      settling_time_rising_step,                \
      overshoot_falling,                        \
      dead_time_falling,                        \
      time_63_falling,                          \
      time_98_falling,                          \
      rise_time_falling_step,                   \
      settling_time_falling_step,               \
/* Histogramm Ventilstellung x Langzeit */      \
      x_interval_value_0,                       \
      x_interval_value_1,                       \
      x_interval_value_2,                        \
      x_interval_value_3,                        \
      x_interval_value_4,                        \
      x_interval_value_5,                        \
      x_interval_value_6,                        \
      x_interval_value_7,                        \
      x_interval_value_8,                        \
      x_interval_value_9,                        \
      x_interval_value_10,                       \
      x_interval_value_11,                       \
      x_interval_value_12,                       \
      x_interval_value_13,                       \
      x_interval_value_14,                       \
      x_interval_value_15,                       \
      x_interval_value_16,                       \
      x_interval_value_17,                       \
      x_interval_value_18,                       \
      x_interval_value_19,                       \
      x_interval_value_20,                       \
      x_interval_value_21,                       \
/* Histogramm Ventilstellung x Kurzzeit */       \
      x_interval_value_kz_0,                     \
      x_interval_value_kz_1,                     \
      x_interval_value_kz_2,                     \
      x_interval_value_kz_3,                     \
      x_interval_value_kz_4,                     \
      x_interval_value_kz_5,                     \
      x_interval_value_kz_6,                     \
      x_interval_value_kz_7,                     \
      x_interval_value_kz_8,                     \
      x_interval_value_kz_9,                     \
      x_interval_value_kz_10,                    \
      x_interval_value_kz_11,                    \
      x_interval_value_kz_12,                    \
      x_interval_value_kz_13,                    \
      x_interval_value_kz_14,                    \
      x_interval_value_kz_15,                    \
      x_interval_value_kz_16,                    \
      x_interval_value_kz_17,                    \
      x_interval_value_kz_18,                    \
      x_interval_value_kz_19,                    \
      x_interval_value_kz_20,                    \
      x_interval_value_kz_21,                    \
/* Histogramm Regelabweichung e Langzeit */      \
      e_interval_value_long_0,                   \
      e_interval_value_long_1,                   \
      e_interval_value_long_2,                   \
      e_interval_value_long_3,                   \
      e_interval_value_long_4,                   \
      e_interval_value_long_5,                   \
      e_interval_value_long_6,                   \
      e_interval_value_long_7,                   \
      e_interval_value_long_8,                   \
      e_interval_value_long_9,                   \
      e_interval_value_long_10,                  \
      e_interval_value_long_11,                  \
/* Histogramm Regelabweichung e Kurzzeit */      \
      e_interval_value_short_0,                  \
      e_interval_value_short_1,                  \
      e_interval_value_short_2,                  \
      e_interval_value_short_3,                  \
      e_interval_value_short_4,                  \
      e_interval_value_short_5,                  \
      e_interval_value_short_6,                  \
      e_interval_value_short_7,                  \
      e_interval_value_short_8,                  \
      e_interval_value_short_9,                  \
      e_interval_value_short_10,                 \
      e_interval_value_short_11,                 \
/* Histogramm Zyklenzhler Langzeit */           \
      his_z_intervallwert_0,                     \
      his_z_intervallwert_1,                     \
      his_z_intervallwert_2,                     \
      his_z_intervallwert_3,                     \
      his_z_intervallwert_4,                     \
      his_z_intervallwert_5,                     \
      his_z_intervallwert_6,                     \
      his_z_intervallwert_7,                     \
      his_z_intervallwert_8,                     \
      his_z_intervallwert_9,                     \
      his_z_intervallwert_10,                    \
      his_z_intervallwert_11,                    \
      his_z_intervallwert_12,                    \
/* Histogramm Zyklenzhler Kurzzeit */           \
      his_z_intervallwert_short_0,               \
      his_z_intervallwert_short_1,               \
      his_z_intervallwert_short_2,               \
      his_z_intervallwert_short_3,               \
      his_z_intervallwert_short_4,               \
      his_z_intervallwert_short_5,               \
      his_z_intervallwert_short_6,               \
      his_z_intervallwert_short_7,               \
      his_z_intervallwert_short_8,               \
      his_z_intervallwert_short_9,               \
      his_z_intervallwert_short_10,              \
      his_z_intervallwert_short_11,              \
      his_z_intervallwert_short_12,              \
/* Diagramm Stellsignal y Stationaer Langzeit */ \
      average_value_stat_long_1,                 \
      average_value_stat_long_2,                 \
      average_value_stat_long_3,                 \
      average_value_stat_long_4,                 \
      average_value_stat_long_5,                 \
      average_value_stat_long_6,                 \
      average_value_stat_long_7,                 \
      average_value_stat_long_8,                 \
      average_value_stat_long_9,                 \
      average_value_stat_long_10,                \
      average_value_stat_long_11,                \
      average_value_stat_long_12,                \
      average_value_stat_long_13,                \
      average_value_stat_long_14,                \
      average_value_stat_long_15,                \
      average_value_stat_long_16,                \
      average_value_stat_long_17,                \
      average_value_stat_long_18,                \
      average_value_stat_long_19,                \
      average_value_stat_long_20,                \
      average_value_stat_long_21,                \
      average_value_stat_long_22,                \
/* Diagramm Stellsignal y Stationaer Kurzzeit */ \
      average_value_stat_short_1,                \
      average_value_stat_short_2,                \
      average_value_stat_short_3,                \
      average_value_stat_short_4,                \
      average_value_stat_short_5,                \
      average_value_stat_short_6,                \
      average_value_stat_short_7,                \
      average_value_stat_short_8,                \
      average_value_stat_short_9,                \
      average_value_stat_short_10,               \
      average_value_stat_short_11,               \
      average_value_stat_short_12,               \
      average_value_stat_short_13,               \
      average_value_stat_short_14,               \
      average_value_stat_short_15,               \
      average_value_stat_short_16,               \
      average_value_stat_short_17,               \
      average_value_stat_short_18,               \
      average_value_stat_short_19,               \
      average_value_stat_short_20,               \
      average_value_stat_short_21,               \
      average_value_stat_short_22,               \
      stat_stellsignal_Value_0,                  \
      stat_stellsignal_Value_1,                  \
      stat_stellsignal_Value_2,                  \
      stat_stellsignal_Value_3,                  \
      stat_stellsignal_Value_4,                  \
      stat_stellsignal_Value_5,                  \
      stat_stellsignal_Value_6,                  \
      stat_stellsignal_Value_7,                  \
      stat_stellsignal_Value_8,                  \
      stat_stellsignal_Value_9,                  \
      stat_ventilstellung_Value_0,               \
      stat_ventilstellung_Value_1,               \
      stat_ventilstellung_Value_2,               \
      stat_ventilstellung_Value_3,               \
      stat_ventilstellung_Value_4,               \
      stat_ventilstellung_Value_5,               \
      stat_ventilstellung_Value_6,               \
      stat_ventilstellung_Value_7,               \
      stat_ventilstellung_Value_8,               \
      stat_ventilstellung_Value_9,               \
/* Diagramm Stellsignal y Hysterese */           \
      average_value_long_1,                      \
      average_value_long_2,                      \
      average_value_long_3,                      \
      average_value_long_4,                      \
      average_value_long_5,                      \
      average_value_long_6,                      \
      average_value_long_7,                      \
      average_value_long_8,                      \
      average_value_long_9,                      \
      average_value_long_10,                     \
      average_value_long_11,                     \
      average_value_long_12,                     \
      average_value_long_13,                     \
      average_value_long_14,                     \
      average_value_long_15,                     \
      average_value_long_16,                     \
      average_value_long_17,                     \
      average_value_long_18,                     \
      average_value_long_19,                     \
      hys_stellsignal_Value_0,                   \
      hys_stellsignal_Value_1,                   \
      hys_stellsignal_Value_2,                   \
      hys_stellsignal_Value_3,                   \
      hys_stellsignal_Value_4,                   \
      hys_stellsignal_Value_5,                   \
      hys_stellsignal_Value_6,                   \
      hys_stellsignal_Value_7,                   \
      hys_stellsignal_Value_8,                   \
      hys_stellsignal_Value_9,                   \
      hys_ventilstellung_Value_0,                \
      hys_ventilstellung_Value_1,                \
      hys_ventilstellung_Value_2,                \
      hys_ventilstellung_Value_3,                \
      hys_ventilstellung_Value_4,                \
      hys_ventilstellung_Value_5,                \
      hys_ventilstellung_Value_6,                \
      hys_ventilstellung_Value_7,                \
      hys_ventilstellung_Value_8,                \
      hys_ventilstellung_Value_9,                \
/* Endlagentrend */                              \
      valve_pos_meas_point_1,                    \
      lower_end_position_bsz_1,                  \
      lower_end_pos_drive_signal_1,              \
      valve_pos_meas_point_2,                    \
      lower_end_position_bsz_2,                  \
      lower_end_pos_drive_signal_2,              \
      valve_pos_meas_point_3,                    \
      lower_end_position_bsz_3,                  \
      lower_end_pos_drive_signal_3,              \
      valve_pos_meas_point_4,                    \
      lower_end_position_bsz_4,                  \
      lower_end_pos_drive_signal_4,              \
      valve_pos_meas_point_5,                    \
      lower_end_position_bsz_5,                  \
      lower_end_pos_drive_signal_5,              \
      valve_pos_meas_point_6,                    \
      lower_end_position_bsz_6,                  \
      lower_end_pos_drive_signal_6,              \
      valve_pos_meas_point_7,                    \
      lower_end_position_bsz_7,                  \
      lower_end_pos_drive_signal_7,              \
      valve_pos_meas_point_8,                    \
      lower_end_position_bsz_8,                  \
      lower_end_pos_drive_signal_8,              \
      valve_pos_meas_point_9,                    \
      lower_end_position_bsz_9,                  \
      lower_end_pos_drive_signal_9,              \
      valve_pos_meas_point_10,                   \
      lower_end_position_bsz_10,                 \
      lower_end_pos_drive_signal_10,             \
      valve_pos_meas_point_11,                   \
      lower_end_position_bsz_11,                 \
      lower_end_pos_drive_signal_11,             \
      valve_pos_meas_point_12,                   \
      lower_end_position_bsz_12,                 \
      lower_end_pos_drive_signal_12,             \
      valve_pos_meas_point_13,                   \
      lower_end_position_bsz_13,                 \
      lower_end_pos_drive_signal_13,             \
      valve_pos_meas_point_14,                   \
      lower_end_position_bsz_14,                 \
      lower_end_pos_drive_signal_14,             \
      valve_pos_meas_point_15,                   \
      lower_end_position_bsz_15,                 \
      lower_end_pos_drive_signal_15,             \
      valve_pos_meas_point_16,                   \
      lower_end_position_bsz_16,                 \
      lower_end_pos_drive_signal_16,             \
      valve_pos_meas_point_17,                   \
      lower_end_position_bsz_17,                 \
      lower_end_pos_drive_signal_17,             \
      valve_pos_meas_point_18,                   \
      lower_end_position_bsz_18,                 \
      lower_end_pos_drive_signal_18,             \
      valve_pos_meas_point_19,                   \
      lower_end_position_bsz_19,                 \
      lower_end_pos_drive_signal_19,             \
      valve_pos_meas_point_20,                   \
      lower_end_position_bsz_20,                 \
      lower_end_pos_drive_signal_20,             \
      valve_pos_meas_point_21,                   \
      lower_end_position_bsz_21,                 \
      lower_end_pos_drive_signal_21,             \
      valve_pos_meas_point_22,                   \
      lower_end_position_bsz_22,                 \
      lower_end_pos_drive_signal_22,             \
      valve_pos_meas_point_23,                   \
      lower_end_position_bsz_23,                 \
      lower_end_pos_drive_signal_23,             \
      valve_pos_meas_point_24,                   \
      lower_end_position_bsz_24,                 \
      lower_end_pos_drive_signal_24,             \
      valve_pos_meas_point_25,                   \
      lower_end_position_bsz_25,                 \
      lower_end_pos_drive_signal_25,             \
      valve_pos_meas_point_26,                   \
      lower_end_position_bsz_26,                 \
      lower_end_pos_drive_signal_26,             \
      valve_pos_meas_point_27,                   \
      lower_end_position_bsz_27,                 \
      lower_end_pos_drive_signal_27,             \
      valve_pos_meas_point_28,                   \
      lower_end_position_bsz_28,                 \
      lower_end_pos_drive_signal_28,             \
      valve_pos_meas_point_29,                   \
      lower_end_position_bsz_29,                 \
      lower_end_pos_drive_signal_29,             \
      valve_pos_meas_point_30,                   \
      lower_end_position_bsz_30,                 \
      lower_end_pos_drive_signal_30,             \
/* Stellsignal y Stationr */                    \
      hand_y_stat_wiederholungswerte_1,          \
      hand_y_stat_wiederholungswerte_2,          \
      hand_y_stat_wiederholungswerte_3,          \
      hand_y_stat_wiederholungswerte_4,          \
      hand_y_stat_wiederholungswerte_5,          \
      hand_y_stat_wiederholungswerte_6,          \
      hand_y_stat_wiederholungswerte_7,          \
      hand_y_stat_wiederholungswerte_8,          \
      hand_y_stat_wiederholungswerte_9,          \
      hand_y_stat_wiederholungswerte_10,         \
      hand_y_stat_wiederholungswerte_11,         \
      hand_y_stat_wiederholungswerte_12,         \
      hand_y_stat_wiederholungswerte_13,         \
      hand_y_stat_wiederholungswerte_14,         \
      hand_y_stat_wiederholungswerte_15,         \
      hand_y_stat_wiederholungswerte_16,         \
      hand_y_stat_wiederholungswerte_17,         \
      hand_y_stat_wiederholungswerte_18,         \
      hand_y_stat_wiederholungswerte_19,         \
      hand_y_stat_wiederholungswerte_20,         \
      hand_y_stat_wiederholungswerte_21,         \
      hand_y_stat_wiederholungswerte_22,         \
      hand_y_stat_wiederholungswerte_23,         \
      hand_y_stat_wiederholungswerte_24,         \
      hand_y_stat_wiederholungswerte_25,         \
                                                 \
      hand_y_stat_referenzwerte_1,               \
      hand_y_stat_referenzwerte_2,               \
      hand_y_stat_referenzwerte_3,               \
      hand_y_stat_referenzwerte_4,               \
      hand_y_stat_referenzwerte_5,               \
      hand_y_stat_referenzwerte_6,               \
      hand_y_stat_referenzwerte_7,               \
      hand_y_stat_referenzwerte_8,               \
      hand_y_stat_referenzwerte_9,               \
      hand_y_stat_referenzwerte_10,              \
      hand_y_stat_referenzwerte_11,              \
      hand_y_stat_referenzwerte_12,              \
      hand_y_stat_referenzwerte_13,              \
      hand_y_stat_referenzwerte_14,              \
      hand_y_stat_referenzwerte_15,              \
      hand_y_stat_referenzwerte_16,              \
      hand_y_stat_referenzwerte_17,              \
      hand_y_stat_referenzwerte_18,              \
      hand_y_stat_referenzwerte_19,              \
      hand_y_stat_referenzwerte_20,              \
      hand_y_stat_referenzwerte_21,              \
      hand_y_stat_referenzwerte_22,              \
      hand_y_stat_referenzwerte_23,              \
      hand_y_stat_referenzwerte_24,              \
      hand_y_stat_referenzwerte_25,              \
                                                 \
            stat_ref_vs_0,                       \
            stat_ref_vs_1,                       \
            stat_ref_vs_2,                       \
            stat_ref_vs_3,                       \
            stat_ref_vs_4,                       \
            stat_ref_vs_5,                       \
            stat_ref_vs_6,                       \
            stat_ref_vs_7,                       \
            stat_ref_vs_8,                       \
            stat_ref_vs_9,                       \
            stat_ref_vs_10,                      \
            stat_ref_vs_11,                      \
            stat_ref_vs_12,                      \
            stat_ref_vs_13,                      \
            stat_ref_vs_14,                      \
            stat_ref_vs_15,                      \
            stat_ref_vs_16,                      \
            stat_ref_vs_17,                      \
            stat_ref_vs_18,                      \
            stat_ref_vs_19,                      \
            stat_ref_vs_20,                      \
            stat_ref_vs_21,                      \
            stat_ref_vs_22,                      \
            stat_ref_vs_23,                      \
            stat_ref_vs_24,                      \
                                                 \
            stat_again_vs_0,                     \
            stat_again_vs_1,                     \
            stat_again_vs_2,                     \
            stat_again_vs_3,                     \
            stat_again_vs_4,                     \
            stat_again_vs_5,                     \
            stat_again_vs_6,                     \
            stat_again_vs_7,                     \
            stat_again_vs_8,                     \
            stat_again_vs_9,                     \
            stat_again_vs_10,                    \
            stat_again_vs_11,                    \
            stat_again_vs_12,                    \
            stat_again_vs_13,                    \
            stat_again_vs_14,                    \
            stat_again_vs_15,                    \
            stat_again_vs_16,                    \
            stat_again_vs_17,                    \
            stat_again_vs_18,                    \
            stat_again_vs_19,                    \
            stat_again_vs_20,                    \
            stat_again_vs_21,                    \
            stat_again_vs_22,                    \
            stat_again_vs_23,                    \
            stat_again_vs_24,                    \
/* Stellsignal y Hysterese */                    \
			hys_ref_vs_0,                        \
			hys_ref_vs_1,                        \
			hys_ref_vs_2,                        \
			hys_ref_vs_3,                        \
			hys_ref_vs_4,                        \
			hys_ref_vs_5,                        \
			hys_ref_vs_6,                        \
			hys_ref_vs_7,                        \
			hys_ref_vs_8,                        \
			hys_ref_vs_9,                        \
			hys_ref_vs_10,                       \
			hys_ref_vs_11,                       \
                                                 \
      hand_y_hys_wiederholungswerte_1,           \
      hand_y_hys_wiederholungswerte_2,           \
      hand_y_hys_wiederholungswerte_3,           \
      hand_y_hys_wiederholungswerte_4,           \
      hand_y_hys_wiederholungswerte_5,           \
      hand_y_hys_wiederholungswerte_6,           \
      hand_y_hys_wiederholungswerte_7,           \
      hand_y_hys_wiederholungswerte_8,           \
      hand_y_hys_wiederholungswerte_9,           \
      hand_y_hys_wiederholungswerte_10,          \
      hand_y_hys_wiederholungswerte_11,          \
      hand_y_hys_wiederholungswerte_12,          \
                                                 \
      hand_y_hys_referenzwerte_1,                \
      hand_y_hys_referenzwerte_2,                \
      hand_y_hys_referenzwerte_3,                \
      hand_y_hys_referenzwerte_4,                \
      hand_y_hys_referenzwerte_5,                \
      hand_y_hys_referenzwerte_6,                \
      hand_y_hys_referenzwerte_7,                \
      hand_y_hys_referenzwerte_8,                \
      hand_y_hys_referenzwerte_9,                \
      hand_y_hys_referenzwerte_10,               \
      hand_y_hys_referenzwerte_11,               \
      hand_y_hys_referenzwerte_12,               \
      wegaufnehmerausfall,                       \
                                                 \
      /* Lesbare PST Parameter */                \
                                                 \
      /* Wenn PST Regler */                      \
      IF ( diag_level == DIAG_LEVEL_PST )        \
      {                                          \
/* PST Betriebsarten brauchen nicht gelesen zu werden \
      pst_mode_on_off,                           \
      pst_operating_mode,          */            \
      pst_activation_ramp_function,              \
      pst_activation_tol_band_control,           \
      pst_fault_alarm_output,                    \
      pst_activation_y_control,                  \
      pst_activation_x_control,                  \
      pst_max_test_duration,                     \
      pst_ramp_time_rising,                      \
      pst_ramp_time_falling,                     \
      pst_number_of_tests,                       \
      pst_status__no_test_0,                     \
      pst_status_pst_test,                       \
      pst_status__x_cancel_0,                    \
      pst_status__y_cancel_0,                    \
      pst_status__tol_band_exceed_0,             \
      pst_status__max_test_time_exceed_0,        \
      pst_status__wrong_op_mode_0,               \
      pst_status__data_memory_full_0,            \
      pst_status__solenoid_valve_0,              \
      pst_status__supply_pressure_friction_0,    \
      pst_status__no_test_1,                     \
      pst_status__x_cancel_1,                    \
      pst_status__y_cancel_1,                    \
      pst_status__tol_band_exceed_1,             \
      pst_status__max_test_time_exceed_1,        \
      pst_status__wrong_op_mode_1,               \
      pst_status__data_memory_full_1,            \
      pst_status__solenoid_valve_1,              \
      pst_status__supply_pressure_friction_1,    \
      pst_status__no_test_2,                     \
      pst_status__x_cancel_2,                    \
      pst_status__y_cancel_2,                    \
      pst_status__tol_band_exceed_2,             \
      pst_status__max_test_time_exceed_2,        \
      pst_status__wrong_op_mode_2,               \
      pst_status__data_memory_full_2,            \
      pst_status__solenoid_valve_2,              \
      pst_status__supply_pressure_friction_2,    \
      pst_settling_time_before_start,            \
      pst_elapsed_hours_meter_0,                 \
      pst_elapsed_hours_meter_auto_test_time,    \
      pst_elapsed_hours_meter_1,                 \
      dead_time_rising_1,                        \
      time_63_rising_1,                          \
      time_98_rising_1,                          \
      rise_time_rising_step_1,                   \
      settling_time_rising_step_1,               \
      dead_time_falling_1,                       \
      time_63_falling_1,                         \
      time_98_falling_1,                         \
      rise_time_falling_step_1,                  \
      settling_time_falling_step_1,              \
      pst_elapsed_hours_meter_2,                 \
      dead_time_rising_2,                        \
      time_63_rising_2,                          \
      time_98_rising_2,                          \
      rise_time_rising_step_2,                   \
      settling_time_rising_step_2,               \
      dead_time_falling_2,                       \
      time_63_falling_2,                         \
      time_98_falling_2,                         \
      rise_time_falling_step_2,                  \
      settling_time_falling_step_2,              \
      pst_elapsed_hours_meter_next_PST_test,     \
      pst_tolerance_band,                        \
      pst_step_tolerance_limit,                  \
      overshoot_rising_1,                        \
      overshoot_falling_1,                       \
      overshoot_rising_2,                        \
      overshoot_falling_2,                       \
      pst_y_control_value,                       \
      pst_x_control_value,                       \
      pst_min_value_y_control,                   \
      PST_1_condensed_mask                      \
      }


/* ------------------------------------------------------------------------- */
/* Lesen aus Feldgert */
/* ------------------------------------------------------------------------ */
MENU download_variables
{
    LABEL [menu_load_to_PC];
    ITEMS
    {

      /* Wenn EXPERT+ dann diese Parameter auch behandeln: */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( diag_level == DIAG_LEVEL_PST              ))
      {

        /* ------------------------------------------------------------------------ */
        /* Lesen aus ein EXPERT+ Geraet */
        /* ------------------------------------------------------------------------ */
        download_EXPERT_PLUS

      }
      ELSE
      {

        /* ------------------------------------------------------------------------ */
        /* Lesen aus ein EXPERT Geraet */
        /* ------------------------------------------------------------------------ */
        download_EXPERT

      }
    }

#ifdef _V602_
    PRE_READ_ACTIONS
    {
      read_diag_level;  /* erst Diagnoselevel auslesen, damit obige Abfrage geht */
    }
#endif    
}


/* ------------------------------------------------------------------------ */
/* Diagnoselevel einlesen bevor komplettes Lesen aus dem Feldgeraet         */
/* ------------------------------------------------------------------------ */
METHOD read_diag_level
{
    LABEL "";
    DEFINITION
    {
		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        send_command_trans( 171,1 );   /* Diagnoselevel einlesen */
    }
}



/*****************************************************************************/
/* MENU Bar (Menleiste)                                                     */
/*****************************************************************************/
MENU Menu_Main_Specialist
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_S_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}

MENU Menu_Main_Maintenance
{
	LABEL		[main_menu];
	ITEMS
	{
		Menu_File,
		Menu_M_Device,
		Menu_View,
		Menu_Options,
		Menu_Help
	}
}

/*****************************************************************************/
/*    Menu: File (Datei)					                                 */
/*****************************************************************************/
MENU Menu_File
{
	LABEL		[menu_File];
	ITEMS
	{
		std_Save,
		SEPARATOR,
		std_Eigenschaften,
		SEPARATOR,
		std_Print,
		std_PrintPreview,
		std_PrintSetup,
		std_PageSetup,
		std_Schriftfelder,
		SEPARATOR,
		std_Exit
	}
}

METHOD std_Save
{
	LABEL		[menu_File_Save];
	DEFINITION
	{
	}
}

METHOD SEPARATOR
{
	LABEL		[menu_Separator];
	DEFINITION
	{
	}
}

METHOD std_Eigenschaften
{
	LABEL		[menu_File_Properties];
	DEFINITION
	{
	}
}

METHOD std_Print
{
	LABEL		[menu_File_Print];
	DEFINITION
	{
	}
}

METHOD std_PrintPreview
{
	LABEL		[menu_File_PrintPreview];
	DEFINITION
	{
	}
}

METHOD std_PrintSetup
{
	LABEL		[menu_File_PrintSetup];
	DEFINITION
	{
	}
}

METHOD std_PageSetup
{
	LABEL		[menu_File_PageSetup];
	DEFINITION
	{
	}
}

METHOD std_Schriftfelder
{
	LABEL		[menu_File_Labels];
	DEFINITION
	{
	}
}

METHOD std_Exit
{
	LABEL		[menu_File_Exit];
	DEFINITION
	{
	}
}

METHOD polling_address_set
{
	LABEL		[transfer];
	HELP		[transfer_help];
	CLASS		INPUT;
	DEFINITION
	{
		ACKNOWLEDGE([message_polling_address]);
	}
}

/*****************************************************************************/
/*    Menu: Device (Gert)											         */
/*****************************************************************************/
MENU Menu_S_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_CommWay,
		SEPARATOR,
		OnlineDialog_Device_NodeAddress,
		SEPARATOR,
		std_LoadinDevice,
		std_LoadinPC,
        SEPARATOR,
		OnlineDialog_operation,
		OnlineDialog_reset,
		SEPARATOR,
		OnlineDialog_self_calibration,
        OfflineWindow_graph_xy_editable,
		OnlineDialog_request_response_preambles,
        SEPARATOR,
	    OnlineDialog_Diagnosis,
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
		SEPARATOR,
        input_pst_enabling_code,
        method_pst_reset
      }
	}
}

MENU OnlineDialog_Device_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	ITEMS
	{
			polling_address,
			polling_address_set
	}
}

MENU Menu_M_Device
{
	LABEL		[menu_Device];
	ITEMS
	{
		std_CommWay,
		SEPARATOR,
		std_LoadinDevice,
		std_LoadinPC
	}
}

METHOD std_CommWay
{
	LABEL		[menu_Device_CommWay];
	DEFINITION
	{
	}
}

METHOD std_NodeAddress
{
	LABEL		[menu_Device_NodeAddress];
	DEFINITION
	{
	}
}

METHOD std_LoadinDevice
{
	LABEL		[menu_Device_LoadinDevice];
	DEFINITION
	{
	}
}

METHOD std_LoadinPC
{
	LABEL		[menu_Device_LoadinPC];
	DEFINITION
	{
	}
}


/*****************************************************************************/
/*    Menu: View (Ansicht)											         */
/*****************************************************************************/
MENU Menu_View
{
	LABEL		[menu_View];
	ITEMS
	{
		OnlineWindow_display,
		OnlineWindow_yt,
		OnlineWindow_diagnosis,
		SEPARATOR,
		std_Funktionsleiste,
		std_Statuszeile,
		SEPARATOR,
		std_Update
	}
}

METHOD std_Funktionsleiste
{
	LABEL		[menu_View_Toolbar];
	DEFINITION
	{
	}
}

METHOD std_Statuszeile
{
	LABEL		[menu_View_Statusbar];
	DEFINITION
	{
	}
}

METHOD std_Update
{
	LABEL		[menu_View_Update];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: Options (Extras)										         */
/*****************************************************************************/
MENU Menu_Options
{
	LABEL		[menu_Options];
	ITEMS
	{
		std_Einstellungen,
		std_Untereintraege
	}
}

METHOD std_Einstellungen
{
	LABEL		[menu_Options_Properties];
	DEFINITION
	{
	}
}

METHOD std_Untereintraege
{
	LABEL		[menu_Options_Subitems];
	DEFINITION
	{
	}
}

/*****************************************************************************/
/*    Menu: Help (Hilfe)											         */
/*****************************************************************************/
MENU Menu_Help
{
	LABEL		[menu_Help];
	ITEMS
	{
		std_Hilfethemen,
		std_HilfeKontext,
		SEPARATOR,
		std_HilfeGeraet,
		SEPARATOR,
		methodOpenDeviceManual_3730,
		methodOpenDeviceManual_3730_PST,
		methodOpenDeviceManual_3731,
		methodOpenValveDiagnostics,
		SEPARATOR,
		std_HilfeEinfuehrung,
		std_HilfeErsteSchritte,
		SEPARATOR,
		std_Hilfebenutzen,
		std_Info
	}
}

METHOD std_Hilfethemen
{
	LABEL		[menu_Help_Topics];
	DEFINITION
	{
	}
}

METHOD std_HilfeKontext
{
	LABEL		[menu_Help_Context];
	DEFINITION
	{
	}
}

METHOD std_HilfeGeraet
{
	LABEL		[menu_Help_Device];
	DEFINITION
	{
	}
}

METHOD std_HilfeEinfuehrung
{
	LABEL		[menu_Help_Introduction];
	DEFINITION
	{
	}
}

METHOD std_HilfeErsteSchritte
{
	LABEL		[menu_Help_First_Steps];
	DEFINITION
	{
	}
}

METHOD std_Hilfebenutzen
{
	LABEL		[menu_Help_Using];
	DEFINITION
	{
	}
}

METHOD std_Info
{
	LABEL		[menu_Help_Info];
	DEFINITION
	{
	}
}

/* ------------------------------------------------------------------------ */
/*  Online Menues                                                           */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Hauptmenue: */
/* ------------------------------------------------------------------------ */
MENU root_menu
{
/* ori:   LABEL [bus_devices];*/

  #ifdef LABEL_DE_EN
    LABEL	"SAMSON Positioner 373X-3"
	        "|de|SAMSON Stellungsregler 373X-3";
  #else
	LABEL	"SAMSON Positioner 373X-3";
  #endif

    ITEMS
    {
      ident,         /* Hauptmenue */
	  positioner,    /* Hauptmenue */
	  diagnosis      /* Hauptmenue */
    }
}

/* ------------------------------------------------------------------------ */
/* Hauptmenue: Identifikation */
/* ------------------------------------------------------------------------ */
MENU ident
{
  #ifdef LABEL_DE_EN
    LABEL "Identification" "|de|Identifikation";
  #else
    LABEL "Identification";
  #endif
    ITEMS
    {
      ident_op_unit,    /* Untermenue */
      ident_positioner  /* Untermenue */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Identifikation - Betriebseinheit */
/* ------------------------------------------------------------------------ */
MENU ident_op_unit
{
  #ifdef LABEL_DE_EN
    LABEL "Operation unit" "|de|Betriebseinheit";
  #else
    LABEL "Operation unit";
  #endif
    ITEMS
    {
	  tag,
	  long_tag,
	  descriptor,
	  message,
	  textfeld_1,
	  textfeld_2,
	  textfeld_3,
	  textfeld_4,
	  textfeld_5,
	  device_id,
	  erzeugnis_num_regler,
	  firmware_version,
      diag_level,
	  final_assembly_number,
      date,
      zertifizierung,
      hart_schreibschutz (READ_ONLY),
      request_preambles,
      universal_revision,
      transmitter_revision
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Identifikation - Stellungsregler */
/* ------------------------------------------------------------------------ */
MENU ident_positioner
{
  #ifdef LABEL_DE_EN
    LABEL "Positioner" "|de|Stellungsregler";
  #else
    LABEL "Positioner";
  #endif

    ITEMS
    {
	  geraetetyp,                 /* '3730-3' oder '3731-3' */
      ident_positioner_actuator,  /* Untermenue */
      ident_positioner_valve,     /* Untermenue */
      ident_positioner_add_comp   /* Untermenue */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Identifikation - Stellungsregler - Antrieb */
/* ------------------------------------------------------------------------ */
MENU ident_positioner_actuator
{
  #ifdef LABEL_DE_EN
    LABEL "Actuator" "|de|Antrieb";
  #else
    LABEL "Actuator";
  #endif

    ITEMS
    {
	  ident_antrieb,
	  bauart,
	  anbau,
	  booster,
	  antriebswirkflaeche,
	  stelldruckbereich_anfang,
	  stelldruckbereich_ende,
	  versorgungsdruck
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Identifikation - Stellungsregler - Ventil */
/* ------------------------------------------------------------------------ */
MENU ident_positioner_valve
{
  #ifdef LABEL_DE_EN
    LABEL "Valve" "|de|Ventil";
  #else
    LABEL "Valve";
  #endif

    ITEMS
    {
      ident_ventil,
      fliessrichtung,
      stangenabdichtung,
      dichtkante,
      druckentlastung,
      kennlinie_kegel,
      nennweiten_norm,
      nennweite_dn,
      kvs_wert,
      kvs_einheit,
      sitzdurchmesser_ventil
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Identifikation - Stellungsregler - Zusatzkomponente */
/* ------------------------------------------------------------------------ */
MENU ident_positioner_add_comp
{
  #ifdef LABEL_DE_EN
    LABEL "Additional component" "|de|Zusatzkomponente";
  #else
    LABEL "Additional component";
  #endif
    ITEMS
    {
	  magnetventil,
	  stellungsmelder,
	  wirkr_stellmelder,
	  ind_grenzkontakt
    }
}

/* ------------------------------------------------------------------------ */
/* Hauptmenue: Stellungsregler */
/* ------------------------------------------------------------------------ */
MENU positioner
{
  #ifdef LABEL_DE_EN
    LABEL "Positioner" "|de|Stellungsregler";
  #else
    LABEL "Positioner";
  #endif

    ITEMS
    {
      positioner_ref_var       , /* Untermenue */
      positioner_working_range , /* Untermenue */
      positioner_characteristic, /* Untermenue */
      positioner_performance   , /* Untermenue */
      positioner_fail_safe     , /* Untermenue */
      positioner_error_control , /* Untermenue */
      positioner_start_up        /* Untermenue */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fuehrungsgroesse */
/* ------------------------------------------------------------------------ */
MENU positioner_ref_var
{
  #ifdef LABEL_DE_EN
    LABEL "Reference variable" "|de|Fhrungsgre";
  #else
    LABEL "Reference variable";
  #endif

    ITEMS
    {
	  bewegungsrichtung,
	  w_ma_bereich_anfang,
      w_ma_bereich_ende,
      aktiv_endlage_w_kleiner,
      endlage_w_kleiner,
      aktiv_endlage_w_groesser,
      endlage_w_groesser,
      gew_laufzeit_auf,
      gew_laufzeit_zu
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Arbeitsbereich */
/* ------------------------------------------------------------------------ */
MENU positioner_working_range
{
  #ifdef LABEL_DE_EN
    LABEL "Working range" "|de|Arbeitsbereich";
  #else
    LABEL "Working range";
  #endif

    ITEMS
    {
	  x_bereich_anfang,
	  x_bereich_ende,
	  aktiv_x_begrenzung_unten,
	  x_begrenzung_unten,
	  aktiv_x_begrenzung_oben,
	  x_begrenzung_oben
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Kennlinie */
/* ------------------------------------------------------------------------ */
MENU positioner_characteristic
{
  #ifdef LABEL_DE_EN
    LABEL "Characteristic" "|de|Kennlinie";
  #else
    LABEL "Characteristic";
  #endif

    ITEMS
    {
	  kennlinienauswahl,
	  kennlinientyp,
      kennl_eingabe,          /* Methode fr Sttzwerte schreiben */
	  x0  (DISPLAY_VALUE, READ_ONLY), /* x0 ... y10 nur angezeigt */
	  x1  (DISPLAY_VALUE, READ_ONLY),
	  x2  (DISPLAY_VALUE, READ_ONLY),
	  x3  (DISPLAY_VALUE, READ_ONLY),
	  x4  (DISPLAY_VALUE, READ_ONLY),
	  x5  (DISPLAY_VALUE, READ_ONLY),
	  x6  (DISPLAY_VALUE, READ_ONLY),
	  x7  (DISPLAY_VALUE, READ_ONLY),
	  x8  (DISPLAY_VALUE, READ_ONLY),
	  x9  (DISPLAY_VALUE, READ_ONLY),
	  x10 (DISPLAY_VALUE, READ_ONLY),
	  y0  (DISPLAY_VALUE, READ_ONLY),
	  y1  (DISPLAY_VALUE, READ_ONLY),
	  y2  (DISPLAY_VALUE, READ_ONLY),
	  y3  (DISPLAY_VALUE, READ_ONLY),
	  y4  (DISPLAY_VALUE, READ_ONLY),
	  y5  (DISPLAY_VALUE, READ_ONLY),
	  y6  (DISPLAY_VALUE, READ_ONLY),
	  y7  (DISPLAY_VALUE, READ_ONLY),
	  y8  (DISPLAY_VALUE, READ_ONLY),
	  y9  (DISPLAY_VALUE, READ_ONLY),
	  y10 (DISPLAY_VALUE, READ_ONLY)
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Kennwerte */
/* ------------------------------------------------------------------------ */
MENU positioner_performance
{
  #ifdef LABEL_DE_EN
    LABEL "Performance characteristics" "|de|Kennwerte";
  #else
    LABEL "Performance characteristics";
  #endif

    ITEMS
    {
	  kp_stufe,
	  tv_stufe
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Ausfallverhalten */
/* ------------------------------------------------------------------------ */
MENU positioner_fail_safe
{
  #ifdef LABEL_DE_EN
    LABEL "Fail-safe action" "|de|Ausfallverhalten";
  #else
    LABEL "Fail-safe action";
  #endif

    ITEMS
    {
      sicherheitsstellung,
      wegaufnehmerausfall
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung */
/* ------------------------------------------------------------------------ */
MENU positioner_error_control
{
  #ifdef LABEL_DE_EN
    LABEL "Error control" "|de|Fehlerberwachung";
  #else
    LABEL "Error control";
  #endif

    ITEMS
    {
	  toleranzband,
	  nachlaufzeit,
	  wegintegral,
	  gw_wegintegral,
      alarmmodus,
      aktiv_gw_a1,
      grenzwert_a1,
      aktiv_gw_a2,
      grenzwert_a2,
	  stoerm_sonderfunktion,
	  stoerm_wegintegral,
	  stoerm_mit_stellmelder, /* wenn Stellmelder vorhanden */
      zero_point_limit,
      classification_report
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/* ------------------------------------------------------------------------ */
MENU classification_report
{
  #ifdef LABEL_DE_EN
    LABEL "Classification report" "|de|Statusklassifikation";
  #else
    LABEL "Classification report";
  #endif

    ITEMS
    {
      condensed_mask_code_50,
      condensed_mask_code_51,
      condensed_mask_code_52,
      condensed_mask_code_53,
      condensed_mask_code_54,
      condensed_mask_code_55,
      condensed_mask_code_56,
      condensed_mask_code_57,
      condensed_mask_code_58,
      condensed_mask_code_59,
      condensed_mask_code_60,
      condensed_mask_code_62,
      condensed_mask_code_63,
      condensed_mask_code_64,
      condensed_mask_code_65,
      condensed_mask_code_66,
      condensed_mask_code_67,
      condensed_mask_code_68,
      condensed_mask_code_69,
      condensed_mask_code_70,
      condensed_mask_code_71,
      condensed_mask_code_73,
      condensed_mask_code_74,
      condensed_mask_code_75,
      condensed_mask_code_76,
      condensed_mask_code_77,
      condensed_mask_code_78,
      condensed_mask_code_80,
      condensed_mask_valve_travel,
      condensed_mask_temp_40,
      condensed_mask_temp_80,
      class_extended /* Verzeichnis */
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation
               - Erweitert */
/* ------------------------------------------------------------------------ */
MENU class_extended
{
  #ifdef LABEL_DE_EN
    LABEL "Extended" "|de|Erweitert";
  #else
    LABEL "Extended";
  #endif

    ITEMS
    {
      class_air_supply,
      class_shifting_working_range,
      class_leakage_pneumatic,
      class_limit_working_range,
      class_observing_end_position,
      class_connection_positioner_valve,
      class_working_range,
      class_friction,
      class_actuator_spring,
      class_inner_leakage,
      class_external_leakage,

      /* nur bei PST */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        class_pst
      }
    }
    VALIDITY_ONLY_EXPERT_PLUS
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Zuluftdruck */
/* ------------------------------------------------------------------------ */
MENU class_air_supply
{
  #ifdef LABEL_DE_EN
    LABEL "Air supply" "|de|Zuluftdruck";
  #else
    LABEL "Air supply";
  #endif

    ITEMS
    {
      AirSupply_6_condensed_mask,
      AirSupply_1_condensed_mask,
      AirSupply_3_condensed_mask,
      AirSupply_2_condensed_mask,
      AirSupply_4_condensed_mask,
      AirSupply_5_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Trend Stellbereich */
/* ------------------------------------------------------------------------ */
MENU class_shifting_working_range
{
  #ifdef LABEL_DE_EN
    LABEL "Shifting working range" "|de|Trend Stellbereich";
  #else
    LABEL "Shifting working range";
  #endif

    ITEMS
    {
      ShiftingWorkingRange_1_condensed_mask,
      ShiftingWorkingRange_2_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Leckage Pneumatik */
/* ------------------------------------------------------------------------ */
MENU class_leakage_pneumatic
{
  #ifdef LABEL_DE_EN
    LABEL "Leakage pneumatics" "|de|Leckage Pneumatik";
  #else
    LABEL "Leakage pneumatics";
  #endif

    ITEMS
    {
      LeakagePn_1_condensed_mask,
      LeakagePn_3_condensed_mask,
      LeakagePn_4_condensed_mask,
      LeakagePn_2_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Beschraenkung Stellbereich */
/* ------------------------------------------------------------------------ */
MENU class_limit_working_range
{
  #ifdef LABEL_DE_EN
    LABEL "Limit working range" "|de|Beschrnkung Stellbereich";
  #else
    LABEL "Limit working range";
  #endif

    ITEMS
    {
      LimitWorkingRange_1_condensed_mask,
      LimitWorkingRange_2_condensed_mask,
      LimitWorkingRange_3_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Trend Endlage */
/* ------------------------------------------------------------------------ */
MENU class_observing_end_position
{
  #ifdef LABEL_DE_EN
    LABEL "End position trend" "|de|Trend Endlage";
  #else
    LABEL "End position trend";
  #endif

    ITEMS
    {
      ObservingEndPosition_1_condensed_mask,
      ObservingEndPosition_2_condensed_mask,
      ObservingEndPosition_3_condensed_mask,
      ObservingEndPosition_4_condensed_mask,
      ObservingEndPosition_5_condensed_mask,
      ObservingEndPosition_6_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Mech. Verbindung SR / Ventil */
/* ------------------------------------------------------------------------ */
MENU class_connection_positioner_valve
{
  #ifdef LABEL_DE_EN
    LABEL "Connection positioner/valve" "|de|Mech. Verbindung SR/Ventil";
  #else
    LABEL "Connection positioner/valve";
  #endif

    ITEMS
    {
      ConnectionPosValve_1_condensed_mask,
      ConnectionPosValve_2_condensed_mask,
      ConnectionPosValve_3_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Stellbereich */
/* ------------------------------------------------------------------------ */
MENU class_working_range
{
  #ifdef LABEL_DE_EN
    LABEL "Working range" "|de|Stellbereich";
  #else
    LABEL "Working range";
  #endif

    ITEMS
    {
      WorkingRange_1_condensed_mask,
      WorkingRange_2_condensed_mask,
      WorkingRange_3_condensed_mask,
      WorkingRange_4_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Reibung */
/* ------------------------------------------------------------------------ */
MENU class_friction
{
  #ifdef LABEL_DE_EN
    LABEL "Friction" "|de|Reibung";
  #else
    LABEL "Friction";
  #endif

    ITEMS
    {
      Friction_1_condensed_mask,
      Friction_2_condensed_mask,
      Friction_3_condensed_mask,
      Friction_4_condensed_mask,
      Friction_5_condensed_mask,
      Friction_6_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Antriebsfedern */
/* ------------------------------------------------------------------------ */
MENU class_actuator_spring
{
  #ifdef LABEL_DE_EN
    LABEL "Actuator springs" "|de|Antriebsfedern";
  #else
    LABEL "Actuator springs";
  #endif

    ITEMS
    {
      ActSpring_1_condensed_mask,
      ActSpring_2_condensed_mask,
      ActSpring_3_condensed_mask,
      ActSpring_4_condensed_mask,
      ActSpring_5_condensed_mask
    }
}
/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Innere Leckage */
/* ------------------------------------------------------------------------ */
MENU class_inner_leakage
{
  #ifdef LABEL_DE_EN
    LABEL "Inner leakage" "|de|Innere Leckage";
  #else
    LABEL "Inner leakage";
  #endif

    ITEMS
    {
      InnerLeakage_1_condensed_mask,
      InnerLeakage_2_condensed_mask,
      InnerLeakage_3_condensed_mask
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - Externe Leckage */
/* ------------------------------------------------------------------------ */
MENU class_external_leakage
{
  #ifdef LABEL_DE_EN
    LABEL "External leakage" "|de|Externe Leckage";
  #else
    LABEL "External leakage";
  #endif

    ITEMS
    {
      ExternalLeakage_1_condensed_mask,
      ExternalLeakage_2_condensed_mask
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Fehlerueberwachung - Statusklassifikation  */
/*             - PST */
/* ------------------------------------------------------------------------ */
MENU class_pst
{
  #ifdef LABEL_DE_EN
    LABEL "PST" "|de|PST";
  #else
    LABEL "PST";
  #endif

    ITEMS
    {
      PST_1_condensed_mask
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Inbetriebnahme */
/* ------------------------------------------------------------------------ */
MENU positioner_start_up
{
  #ifdef LABEL_DE_EN
    LABEL "Start-up" "|de|Inbetriebnahme";
  #else
    LABEL "Start-up";
  #endif

    ITEMS
    {
      leserichtung,
      stiftposition,
      initialisierungsart,
      druckgrenze,
      nennbereich,
      bauart,
      min_laufzeit_auf,
      min_laufzeit_zu,
      sicherheitsstellung,
      geraet_ini,
      positioner_start_up_substitution /* Untermenue */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Stellungsregler - Inbetriebnahme - Ersatzabgleich */
/* ------------------------------------------------------------------------ */
MENU positioner_start_up_substitution
{
  #ifdef LABEL_DE_EN
    LABEL "Substitution" "|de|Ersatzabgleich";
  #else
    LABEL "Substitution";
  #endif

    ITEMS
    {
	  xmtr_specific_status_5, /* Ersatzabgleich durchgefhrt */
	  schliessrichtung,
	  blockierstellung,
	  aktiv_x_begrenzung_oben
    }
}



/* ------------------------------------------------------------------------ */
/* Hauptmenue: Diagnose */
/* ------------------------------------------------------------------------ */
MENU diagnosis
{
  #ifdef LABEL_DE_EN
    LABEL "Diagnosis" "|de|Diagnose";
  #else
    LABEL "Diagnosis";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
      start_abort_reference_test,*/
      diag_level,

      status_messages,           /* Untermenue */
      statistical_info_auto,     /* Untermenue */
      tests_man,                 /* Untermenue */
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        tests_pst                /* Untermenue bei PST */
      }
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statusmeldungen */
/* ------------------------------------------------------------------------ */
MENU status_messages
{
  #ifdef LABEL_DE_EN
    LABEL "Status messages" "|de|Statusmeldungen";
  #else
    LABEL "Status messages";
  #endif

    ITEMS
    {
      namur_sammelstatus,
      elapsed_hours_meter,         /* 4 Betriebsstundenzaehler */
      device_in_closed_loop,
      device_switched_on_since_init,
      device_in_closed_loop_since_init,

      stoerung_vorhanden,
      zwangsentlueftung,
      geraet_ini,                 /* Geraet initialisiert */
      xmtr_specific_status_4,     /* Kaltstart ausgefhrt */
      anzahl_np,                  /* Anzahl Nullpunktabgleiche */
      counter_init_start,         /* Anzahl Initialisierungen */
      zero_point_limit (READ_ONLY), /* hier nur lesbar */

      xmtr_specific_status_0,     /* Fehlercodes Byte 0 */
      xmtr_specific_status_1,     /* Fehlercodes Byte 1 */
      xmtr_specific_status_2,     /* Fehlercodes Byte 2 */
      xmtr_specific_status_3,     /* Fehlercodes Byte 3 */
      /*xmtr_specific_status_6,*/     /* device family status 0 */
      /*xmtr_specific_status_7,*/     /* device family status 1 */
      /*xmtr_specific_status_8,*/     /* device family status 2 */
      error_code_81_ref_test_aborted,

      min_temperature,
      max_temperature,
      his_t_zeit_min_temperatur,
      his_t_zeit_max_temperatur,
      temp_period_time_low,
      temp_period_time_high,

      logger,    /* Menu */
      extended   /* Menu */
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statusmeldungen - Protokollierung */
/* ------------------------------------------------------------------------ */
MENU logger
{
  #ifdef LABEL_DE_EN
    LABEL "Logger" "|de|Protokollierung";
  #else
    LABEL "Logger";
  #endif

    ITEMS
    {
      messages_1,
      elapsed_hours_meter_1,
      messages_2,
      elapsed_hours_meter_2,
      messages_3,
      elapsed_hours_meter_3,
      messages_4,
      elapsed_hours_meter_4,
      messages_5,
      elapsed_hours_meter_5,
      messages_6,
      elapsed_hours_meter_6,
      messages_7,
      elapsed_hours_meter_7,
      messages_8,
      elapsed_hours_meter_8,
      messages_9,
      elapsed_hours_meter_9,
      messages_10,
      elapsed_hours_meter_10,
      messages_11,
      elapsed_hours_meter_11,
      messages_12,
      elapsed_hours_meter_12,
      messages_13,
      elapsed_hours_meter_13,
      messages_14,
      elapsed_hours_meter_14,
      messages_15,
      elapsed_hours_meter_15,
      messages_16,
      elapsed_hours_meter_16,
      messages_17,
      elapsed_hours_meter_17,
      messages_18,
      elapsed_hours_meter_18,
      messages_19,
      elapsed_hours_meter_19,
      messages_20,
      elapsed_hours_meter_20,
      messages_21,
      elapsed_hours_meter_21,
      messages_22,
      elapsed_hours_meter_22,
      messages_23,
      elapsed_hours_meter_23,
      messages_24,
      elapsed_hours_meter_24,
      messages_25,
      elapsed_hours_meter_25,
      messages_26,
      elapsed_hours_meter_26,
      messages_27,
      elapsed_hours_meter_27,
      messages_28,
      elapsed_hours_meter_28,
      messages_29,
      elapsed_hours_meter_29,
      messages_30,
      elapsed_hours_meter_30
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statusmeldungen - Erweitert */
/* ------------------------------------------------------------------------ */
MENU extended
{
  #ifdef LABEL_DE_EN
    LABEL "Extended" "|de|Erweitert";
  #else
    LABEL "Extended";
  #endif

    ITEMS
    {
      air_supply,
      shifting_working_range,
      leakage_pneumatic,
      limit_working_range,
      observing_end_position,
      connection_positioner_valve,
      working_range,
      friction,
      actuator_spring,
      inner_leakage,
      external_leakage,
/*      dynamic_stress_factor,*/

      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        pst_emergency_shut_down
      }
    }
    VALIDITY_ONLY_EXPERT_PLUS
}



/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Beobachterfunktionen AUTO */
/* ------------------------------------------------------------------------ */
MENU statistical_info_auto
{
  #ifdef LABEL_DE_EN
    LABEL "Statistical information AUTO" "|de|Beobachterfunktionen AUTO";
  #else
    LABEL "Statistical information AUTO";
  #endif

    ITEMS
    {
      data_logger,                  /* Menu */
      travel_histogram,             /* Menu */
      setpoint_deviation_histogram, /* Menu */
      cycle_counter_histogram,      /* Menu */
      drive_signal_diagram,         /* Menu */
      trend_of_travel_end_position  /* Menu */
    }
    VALIDITY_ONLY_EXPERT_PLUS
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO - Datenlogger */
/* ------------------------------------------------------------------------ */
MENU data_logger
{
  #ifdef LABEL_DE_EN
    LABEL "Data logger" "|de|Datenlogger";
  #else
    LABEL "Data logger";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
	  start_abort_data_logger,*/
      datalogger_select,
      trigger_select,
      sample_rate,
      start_value,
      logging_limit,
      pretrigger_time,
      max_pretrigger_time,
      magnetventil
/* unnoetig      datalogger_progress*/
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Histogramm Ventilstellung x */
/* ------------------------------------------------------------------------ */
MENU travel_histogram
{
  #ifdef LABEL_DE_EN
    LABEL "Travel histogram" "|de|Histogramm Ventilstellung x";
  #else
    LABEL "Travel histogram";
  #endif

    ITEMS
    {
      his_x_mittelwert_int_1,
      his_x_anzahl_messpunkte,

      x_interval_value_0,
      x_interval_value_1,
      x_interval_value_2,
      x_interval_value_3,
      x_interval_value_4,
      x_interval_value_5,
      x_interval_value_6,
      x_interval_value_7,
      x_interval_value_8,
      x_interval_value_9,
      x_interval_value_10,
      x_interval_value_11,
      x_interval_value_12,
      x_interval_value_13,
      x_interval_value_14,
      x_interval_value_15,
      x_interval_value_16,
      x_interval_value_17,
      x_interval_value_18,
      x_interval_value_19,
      x_interval_value_20,
      x_interval_value_21,

      travel_histogram_short /* Menu */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Histogramm Ventilstellung x - Kurzzeitbetrachtung */
/* ------------------------------------------------------------------------ */
MENU travel_histogram_short
{
  #ifdef LABEL_DE_EN
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";
  #else
    LABEL "Short-term";
  #endif

    ITEMS
    {
      his_x_mittelwert_kurz,
      sample_rate_st_hist,

      x_interval_value_kz_0,
      x_interval_value_kz_1,
      x_interval_value_kz_2,
      x_interval_value_kz_3,
      x_interval_value_kz_4,
      x_interval_value_kz_5,
      x_interval_value_kz_6,
      x_interval_value_kz_7,
      x_interval_value_kz_8,
      x_interval_value_kz_9,
      x_interval_value_kz_10,
      x_interval_value_kz_11,
      x_interval_value_kz_12,
      x_interval_value_kz_13,
      x_interval_value_kz_14,
      x_interval_value_kz_15,
      x_interval_value_kz_16,
      x_interval_value_kz_17,
      x_interval_value_kz_18,
      x_interval_value_kz_19,
      x_interval_value_kz_20,
      x_interval_value_kz_21
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Histogramm Regelabweichung e */
/* ------------------------------------------------------------------------ */
MENU setpoint_deviation_histogram
{
  #ifdef LABEL_DE_EN
    LABEL "Setpoint deviation histogram" "|de|Histogramm Regelabweichung e";
  #else
    LABEL "Setpoint deviation histogram";
  #endif

    ITEMS
    {
      mittelwert_e_lang,
      gesamtanzahl,
      deviation_min,
      deviation_max,

      e_interval_value_long_0,
      e_interval_value_long_1,
      e_interval_value_long_2,
      e_interval_value_long_3,
      e_interval_value_long_4,
      e_interval_value_long_5,
      e_interval_value_long_6,
      e_interval_value_long_7,
      e_interval_value_long_8,
      e_interval_value_long_9,
      e_interval_value_long_10,
      e_interval_value_long_11,

      setpoint_deviation_histogram_short /* Menu */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Histogramm Regelabweichung e - Kurzzeitbetrachtung */
/* ------------------------------------------------------------------------ */
MENU setpoint_deviation_histogram_short
{
  #ifdef LABEL_DE_EN
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";
  #else
    LABEL "Short-term";
  #endif

    ITEMS
    {
      his_e_mittelwert_kurz,
      sample_rate_st_hist_e,

      e_interval_value_short_0,
      e_interval_value_short_1,
      e_interval_value_short_2,
      e_interval_value_short_3,
      e_interval_value_short_4,
      e_interval_value_short_5,
      e_interval_value_short_6,
      e_interval_value_short_7,
      e_interval_value_short_8,
      e_interval_value_short_9,
      e_interval_value_short_10,
      e_interval_value_short_11
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Histogramm Zyklenzaehler */
/* ------------------------------------------------------------------------ */
MENU cycle_counter_histogram
{
  #ifdef LABEL_DE_EN
    LABEL "Cycle counter histogram" "|de|Histogramm Zyklenzhler";
  #else
    LABEL "Cycle counter histogram";
  #endif

    ITEMS
    {
      his_z_mittelwert_int,
      his_z_gesamtanzahl,
      his_z_dynamic_stress_factor,

      his_z_intervallwert_0,
      his_z_intervallwert_1,
      his_z_intervallwert_2,
      his_z_intervallwert_3,
      his_z_intervallwert_4,
      his_z_intervallwert_5,
      his_z_intervallwert_6,
      his_z_intervallwert_7,
      his_z_intervallwert_8,
      his_z_intervallwert_9,
      his_z_intervallwert_10,
      his_z_intervallwert_11,
      his_z_intervallwert_12,

      cycle_counter_histogram_short /* Menu */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Histogramm Zyklenzaehler - Kurzzeitbetrachtung */
/* ------------------------------------------------------------------------ */
MENU cycle_counter_histogram_short
{
  #ifdef LABEL_DE_EN
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";
  #else
    LABEL "Short-term";
  #endif

    ITEMS
    {
      his_z_mittelwert_kurz,

      his_z_intervallwert_short_0,
      his_z_intervallwert_short_1,
      his_z_intervallwert_short_2,
      his_z_intervallwert_short_3,
      his_z_intervallwert_short_4,
      his_z_intervallwert_short_5,
      his_z_intervallwert_short_6,
      his_z_intervallwert_short_7,
      his_z_intervallwert_short_8,
      his_z_intervallwert_short_9,
      his_z_intervallwert_short_10,
      his_z_intervallwert_short_11,
      his_z_intervallwert_short_12
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Diagramm Stellsignal y */
/* ------------------------------------------------------------------------ */
MENU drive_signal_diagram
{
  #ifdef LABEL_DE_EN
    LABEL "Drive signal diagram" "|de|Diagramm Stellsignal y";
  #else
    LABEL "Drive signal diagram";
  #endif

    ITEMS
    {
      auto_drive_signal_diagram_steady,
      drive_signal_diagram_hyst
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Diagramm Stellsignal y Stationaer */
/* ------------------------------------------------------------------------ */

MENU auto_drive_signal_diagram_steady
{
  #ifdef LABEL_DE_EN
    LABEL "Steady" "|de|Stationr";
  #else
    LABEL "Steady";
  #endif

    ITEMS
    {
      auto_drive_signal_diagram_steady_long,
      auto_drive_signal_diagram_steady_short
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Diagramm Stellsignal y Stationaer - Langzeit */
/* ------------------------------------------------------------------------ */
MENU auto_drive_signal_diagram_steady_long
{
  #ifdef LABEL_DE_EN
    LABEL "Long-term" "|de|Langzeitbetrachtung";
  #else
    LABEL "Long-term";
  #endif

    ITEMS
    {
      average_value_stat_long_1,
      average_value_stat_long_2,
      average_value_stat_long_3,
      average_value_stat_long_4,
      average_value_stat_long_5,
      average_value_stat_long_6,
      average_value_stat_long_7,
      average_value_stat_long_8,
      average_value_stat_long_9,
      average_value_stat_long_10,
      average_value_stat_long_11,
      average_value_stat_long_12,
      average_value_stat_long_13,
      average_value_stat_long_14,
      average_value_stat_long_15,
      average_value_stat_long_16,
      average_value_stat_long_17,
      average_value_stat_long_18,
      average_value_stat_long_19,
      average_value_stat_long_20,
      average_value_stat_long_21,
      average_value_stat_long_22
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Diagramm Stellsignal y Stationaer - Kurzzeit */
/* ------------------------------------------------------------------------ */
MENU auto_drive_signal_diagram_steady_short
{
  #ifdef LABEL_DE_EN
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";
  #else
    LABEL "Short-term";
  #endif

    ITEMS
    {
      average_value_stat_short_1,
      average_value_stat_short_2,
      average_value_stat_short_3,
      average_value_stat_short_4,
      average_value_stat_short_5,
      average_value_stat_short_6,
      average_value_stat_short_7,
      average_value_stat_short_8,
      average_value_stat_short_9,
      average_value_stat_short_10,
      average_value_stat_short_11,
      average_value_stat_short_12,
      average_value_stat_short_13,
      average_value_stat_short_14,
      average_value_stat_short_15,
      average_value_stat_short_16,
      average_value_stat_short_17,
      average_value_stat_short_18,
      average_value_stat_short_19,
      average_value_stat_short_20,
      average_value_stat_short_21,
      average_value_stat_short_22,

      Tab_s_stat_stellsignal,
      Tab_s_stat_ventilstellung
    }
}

/* Stellsignal Y - Stationaer Kurzzeit Stellsignal ****************************************************/
MENU Tab_s_stat_stellsignal
{
    LABEL     "Drive signal" "|de|Stellsignal" ;

    ITEMS
    {
      stat_stellsignal_Value_0,
      stat_stellsignal_Value_1,
      stat_stellsignal_Value_2,
      stat_stellsignal_Value_3,
      stat_stellsignal_Value_4,
      stat_stellsignal_Value_5,
      stat_stellsignal_Value_6,
      stat_stellsignal_Value_7,
      stat_stellsignal_Value_8,
      stat_stellsignal_Value_9
    }
}

/* Stellsignal Y - Stationaer Kurzzeit Ventilstellung ****************************************************/
MENU Tab_s_stat_ventilstellung
{
    LABEL     "Valve position" "|de|Ventilstellung" ;

    ITEMS
    {
      stat_ventilstellung_Value_0,
      stat_ventilstellung_Value_1,
      stat_ventilstellung_Value_2,
      stat_ventilstellung_Value_3,
      stat_ventilstellung_Value_4,
      stat_ventilstellung_Value_5,
      stat_ventilstellung_Value_6,
      stat_ventilstellung_Value_7,
      stat_ventilstellung_Value_8,
      stat_ventilstellung_Value_9
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Diagramm Stellsignal y Hysterese */
/* ------------------------------------------------------------------------ */
MENU drive_signal_diagram_hyst
{
  #ifdef LABEL_DE_EN
    LABEL "Hysteresis" "|de|Hysterese";
  #else
    LABEL "Hysteresis";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
      start_abort_hysteresis_online_test,*/
      hys_stell_y,
      test_information,

      Tab_s_hys_longterm,
      Tab_s_hys_shortterm
    }
}

/* Stellsignal Y - Hysterese Langzeit ************************************************************/
MENU Tab_s_hys_longterm
{
    LABEL "Long-term" "|de|Langzeitbetrachtung";

    ITEMS
    {
      average_value_long_1,
      average_value_long_2,
      average_value_long_3,
      average_value_long_4,
      average_value_long_5,
      average_value_long_6,
      average_value_long_7,
      average_value_long_8,
      average_value_long_9,
      average_value_long_10,
      average_value_long_11,
      average_value_long_12,
      average_value_long_13,
      average_value_long_14,
      average_value_long_15,
      average_value_long_16,
      average_value_long_17,
      average_value_long_18,
      average_value_long_19
    }
}

/* Stellsignal Y - Hysterese Kurzzeit ************************************************************/
MENU Tab_s_hys_shortterm
{
    LABEL "Short-term" "|de|Kurzzeitbetrachtung";

    ITEMS
    {
          Tab_s_hys_stellsignal,
          Tab_s_hys_ventilstellung
    }
}

/* Stellsignal Y - Hysterese Kurzzeit Stellsignal ****************************************************/
MENU Tab_s_hys_stellsignal
{
    LABEL     "Difference drive signal" "|de|Differenz Stellsignal" ;

    ITEMS
    {
      hys_stellsignal_Value_0,
      hys_stellsignal_Value_1,
      hys_stellsignal_Value_2,
      hys_stellsignal_Value_3,
      hys_stellsignal_Value_4,
      hys_stellsignal_Value_5,
      hys_stellsignal_Value_6,
      hys_stellsignal_Value_7,
      hys_stellsignal_Value_8,
      hys_stellsignal_Value_9
    }
}

/* Stellsignal Y - Hysterese Kurzzeit Ventilstellung ****************************************************/
MENU Tab_s_hys_ventilstellung
{
    LABEL     "Valve position" "|de|Ventilstellung" ;

    ITEMS
    {
      hys_ventilstellung_Value_0,
      hys_ventilstellung_Value_1,
      hys_ventilstellung_Value_2,
      hys_ventilstellung_Value_3,
      hys_ventilstellung_Value_4,
      hys_ventilstellung_Value_5,
      hys_ventilstellung_Value_6,
      hys_ventilstellung_Value_7,
      hys_ventilstellung_Value_8,
      hys_ventilstellung_Value_9
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Statistische Informationen AUTO -
               Endlagentrend */
/* ------------------------------------------------------------------------ */
MENU trend_of_travel_end_position
{
  #ifdef LABEL_DE_EN
    LABEL "Trend of travel end position" "|de|Endlagentrend";
  #else
    LABEL "Trend of travel end position";
  #endif

    ITEMS
    {
      ref_value_valve_position,
      lower_end_position_ref_value_bsz,
      trend_travel_end_pos_drive_signal_ref,


      valve_pos_meas_point_1,
      lower_end_position_bsz_1,
      lower_end_pos_drive_signal_1,

      valve_pos_meas_point_2,
      lower_end_position_bsz_2,
      lower_end_pos_drive_signal_2,

      valve_pos_meas_point_3,
      lower_end_position_bsz_3,
      lower_end_pos_drive_signal_3,

      valve_pos_meas_point_4,
      lower_end_position_bsz_4,
      lower_end_pos_drive_signal_4,

      valve_pos_meas_point_5,
      lower_end_position_bsz_5,
      lower_end_pos_drive_signal_5,

      valve_pos_meas_point_6,
      lower_end_position_bsz_6,
      lower_end_pos_drive_signal_6,

      valve_pos_meas_point_7,
      lower_end_position_bsz_7,
      lower_end_pos_drive_signal_7,

      valve_pos_meas_point_8,
      lower_end_position_bsz_8,
      lower_end_pos_drive_signal_8,

      valve_pos_meas_point_9,
      lower_end_position_bsz_9,
      lower_end_pos_drive_signal_9,

      valve_pos_meas_point_10,
      lower_end_position_bsz_10,
      lower_end_pos_drive_signal_10,

      valve_pos_meas_point_11,
      lower_end_position_bsz_11,
      lower_end_pos_drive_signal_11,

      valve_pos_meas_point_12,
      lower_end_position_bsz_12,
      lower_end_pos_drive_signal_12,

      valve_pos_meas_point_13,
      lower_end_position_bsz_13,
      lower_end_pos_drive_signal_13,

      valve_pos_meas_point_14,
      lower_end_position_bsz_14,
      lower_end_pos_drive_signal_14,

      valve_pos_meas_point_15,
      lower_end_position_bsz_15,
      lower_end_pos_drive_signal_15,

      valve_pos_meas_point_16,
      lower_end_position_bsz_16,
      lower_end_pos_drive_signal_16,

      valve_pos_meas_point_17,
      lower_end_position_bsz_17,
      lower_end_pos_drive_signal_17,

      valve_pos_meas_point_18,
      lower_end_position_bsz_18,
      lower_end_pos_drive_signal_18,

      valve_pos_meas_point_19,
      lower_end_position_bsz_19,
      lower_end_pos_drive_signal_19,

      valve_pos_meas_point_20,
      lower_end_position_bsz_20,
      lower_end_pos_drive_signal_20,

      valve_pos_meas_point_21,
      lower_end_position_bsz_21,
      lower_end_pos_drive_signal_21,

      valve_pos_meas_point_22,
      lower_end_position_bsz_22,
      lower_end_pos_drive_signal_22,

      valve_pos_meas_point_23,
      lower_end_position_bsz_23,
      lower_end_pos_drive_signal_23,

      valve_pos_meas_point_24,
      lower_end_position_bsz_24,
      lower_end_pos_drive_signal_24,

      valve_pos_meas_point_25,
      lower_end_position_bsz_25,
      lower_end_pos_drive_signal_25,

      valve_pos_meas_point_26,
      lower_end_position_bsz_26,
      lower_end_pos_drive_signal_26,

      valve_pos_meas_point_27,
      lower_end_position_bsz_27,
      lower_end_pos_drive_signal_27,

      valve_pos_meas_point_28,
      lower_end_position_bsz_28,
      lower_end_pos_drive_signal_28,

      valve_pos_meas_point_29,
      lower_end_position_bsz_29,
      lower_end_pos_drive_signal_29,

      valve_pos_meas_point_30,
      lower_end_position_bsz_30,
      lower_end_pos_drive_signal_30
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Testfunktionen HAND */
/* ------------------------------------------------------------------------ */
MENU tests_man
{
  #ifdef LABEL_DE_EN
    LABEL "Tests MAN" "|de|Testfunktionen HAND";
  #else
    LABEL "Tests MAN";
  #endif

    ITEMS
    {

/* nicht anzeigen und schreiben
      start_abort_tests_in_turn,*/       /* Alle Tests starten */
      automatical_test_status,

      drive_signal_diagram_steady,     /* Verzeichnisse */
      drive_signal_diagram_hysteresis,
      static_characteristic,

      /* Wenn EXPERT+/++ Regler */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS )    )
      {
        step_response            /* Untermenue Sprungantwort bei EXPERT+/++ */
      }
    }
    VALIDITY_ONLY_EXPERT_PLUS
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Testfunktionen HAND - Sprungantwort */
/* ------------------------------------------------------------------------ */
MENU step_response
{
  #ifdef LABEL_DE_EN
    LABEL "Step response" "|de|Sprungantwort";
  #else
    LABEL "Step response";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
      start_abort_step_response_test,*/
      stepstart,
      stepend,
      latency_after_step,
      step_sample_rate,
      duration_of_test,
      step_selection,

      overshoot_rising,
      dead_time_rising,
      time_63_rising,
      time_98_rising,
      rise_time_rising_step,
      settling_time_rising_step,

      overshoot_falling,
      dead_time_falling,
      time_63_falling,
      time_98_falling,
      rise_time_falling_step,
      settling_time_falling_step
    }
}



/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Testfunktionen HAND - Stellsignal y Stationaer */
/* ------------------------------------------------------------------------ */
MENU drive_signal_diagram_steady
{
  #ifdef LABEL_DE_EN
    LABEL "Drive signal diagram steady" "|de|Stellsignal y Stationr";
  #else
    LABEL "Drive signal diagram steady";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
      start_abort_drive_signal_diagram_steady,*/ /* Stellsignal y Stationaer */
      hand_y_stat_test_information,

      Tab_s_drive_signal_stat_ref_vs,
      Tab_s_drive_signal_stat_ref_ss,
      Tab_s_drive_signal_stat_again_vs,
      Tab_s_drive_signal_stat_again_ss
    }
}


/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_ref_vs
{
    LABEL     "Reference value valve position" "|de|Referenzwert Ventilstellung" ;

    ITEMS
    {
            stat_ref_vs_0,
            stat_ref_vs_1,
            stat_ref_vs_2,
            stat_ref_vs_3,
            stat_ref_vs_4,
            stat_ref_vs_5,
            stat_ref_vs_6,
            stat_ref_vs_7,
            stat_ref_vs_8,
            stat_ref_vs_9,
            stat_ref_vs_10,
            stat_ref_vs_11,
            stat_ref_vs_12,
            stat_ref_vs_13,
            stat_ref_vs_14,
            stat_ref_vs_15,
            stat_ref_vs_16,
            stat_ref_vs_17,
            stat_ref_vs_18,
            stat_ref_vs_19,
            stat_ref_vs_20,
            stat_ref_vs_21,
            stat_ref_vs_22,
            stat_ref_vs_23,
            stat_ref_vs_24
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_ref_ss
{
    LABEL     "Reference value drive signal" "|de|Referenzwert Stellsignal" ;

    ITEMS
    {
      hand_y_stat_referenzwerte_1,
      hand_y_stat_referenzwerte_2,
      hand_y_stat_referenzwerte_3,
      hand_y_stat_referenzwerte_4,
      hand_y_stat_referenzwerte_5,
      hand_y_stat_referenzwerte_6,
      hand_y_stat_referenzwerte_7,
      hand_y_stat_referenzwerte_8,
      hand_y_stat_referenzwerte_9,
      hand_y_stat_referenzwerte_10,
      hand_y_stat_referenzwerte_11,
      hand_y_stat_referenzwerte_12,
      hand_y_stat_referenzwerte_13,
      hand_y_stat_referenzwerte_14,
      hand_y_stat_referenzwerte_15,
      hand_y_stat_referenzwerte_16,
      hand_y_stat_referenzwerte_17,
      hand_y_stat_referenzwerte_18,
      hand_y_stat_referenzwerte_19,
      hand_y_stat_referenzwerte_20,
      hand_y_stat_referenzwerte_21,
      hand_y_stat_referenzwerte_22,
      hand_y_stat_referenzwerte_23,
      hand_y_stat_referenzwerte_24,
      hand_y_stat_referenzwerte_25
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_again_vs
{
    LABEL    "Repetition value valve position"  "|de|Wiederholungswert Ventilstellung" ;

    ITEMS
    {
            stat_again_vs_0,
            stat_again_vs_1,
            stat_again_vs_2,
            stat_again_vs_3,
            stat_again_vs_4,
            stat_again_vs_5,
            stat_again_vs_6,
            stat_again_vs_7,
            stat_again_vs_8,
            stat_again_vs_9,
            stat_again_vs_10,
            stat_again_vs_11,
            stat_again_vs_12,
            stat_again_vs_13,
            stat_again_vs_14,
            stat_again_vs_15,
            stat_again_vs_16,
            stat_again_vs_17,
            stat_again_vs_18,
            stat_again_vs_19,
            stat_again_vs_20,
            stat_again_vs_21,
            stat_again_vs_22,
            stat_again_vs_23,
            stat_again_vs_24
    }
}


/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_stat_again_ss
{
    LABEL    "Repetition value drive signal" "|de|Wiederholungswert Stellsignal" ;

    ITEMS
    {
      hand_y_stat_wiederholungswerte_1,
      hand_y_stat_wiederholungswerte_2,
      hand_y_stat_wiederholungswerte_3,
      hand_y_stat_wiederholungswerte_4,
      hand_y_stat_wiederholungswerte_5,
      hand_y_stat_wiederholungswerte_6,
      hand_y_stat_wiederholungswerte_7,
      hand_y_stat_wiederholungswerte_8,
      hand_y_stat_wiederholungswerte_9,
      hand_y_stat_wiederholungswerte_10,
      hand_y_stat_wiederholungswerte_11,
      hand_y_stat_wiederholungswerte_12,
      hand_y_stat_wiederholungswerte_13,
      hand_y_stat_wiederholungswerte_14,
      hand_y_stat_wiederholungswerte_15,
      hand_y_stat_wiederholungswerte_16,
      hand_y_stat_wiederholungswerte_17,
      hand_y_stat_wiederholungswerte_18,
      hand_y_stat_wiederholungswerte_19,
      hand_y_stat_wiederholungswerte_20,
      hand_y_stat_wiederholungswerte_21,
      hand_y_stat_wiederholungswerte_22,
      hand_y_stat_wiederholungswerte_23,
      hand_y_stat_wiederholungswerte_24,
      hand_y_stat_wiederholungswerte_25
    }
}




/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Testfunktionen HAND - Stellsignal y Hysterese */
/* ------------------------------------------------------------------------ */
MENU drive_signal_diagram_hysteresis
{
  #ifdef LABEL_DE_EN
    LABEL "Drive signal diagram hysteresis" "|de|Stellsignal y Hysterese";
  #else
    LABEL "Drive signal diagram hysteresis";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
      start_abort_drive_signal_diagram_hysteresis,*/ /* Stellsignal y Hysterese */
      hand_y_hys_test_information,

      Tab_s_drive_signal_hys_ref_vs,
      Tab_s_drive_signal_hys_ref_hys,
      Tab_s_drive_signal_hys_again_hys
    }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_hys_ref_vs
{
    LABEL     "Reference value valve position" "|de|Referenzwert Ventilstellung" ;

    ITEMS
    {
			hys_ref_vs_0,
			hys_ref_vs_1,
			hys_ref_vs_2,
			hys_ref_vs_3,
			hys_ref_vs_4,
			hys_ref_vs_5,
			hys_ref_vs_6,
			hys_ref_vs_7,
			hys_ref_vs_8,
			hys_ref_vs_9,
			hys_ref_vs_10,
			hys_ref_vs_11
	  }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_hys_ref_hys
{
    LABEL    "Reference measurement hysteresis" "|de|Referenzmessung Hysterese" ;

    ITEMS
    {
      hand_y_hys_referenzwerte_1,
      hand_y_hys_referenzwerte_2,
      hand_y_hys_referenzwerte_3,
      hand_y_hys_referenzwerte_4,
      hand_y_hys_referenzwerte_5,
      hand_y_hys_referenzwerte_6,
      hand_y_hys_referenzwerte_7,
      hand_y_hys_referenzwerte_8,
      hand_y_hys_referenzwerte_9,
      hand_y_hys_referenzwerte_10,
      hand_y_hys_referenzwerte_11,
      hand_y_hys_referenzwerte_12
   }
}

/* Stellsignal Y stationaer ************************************************************/
MENU Tab_s_drive_signal_hys_again_hys
{
    LABEL     "Repetition value hysteresis" "|de|Wiederholungswert Hysterese" ;

    ITEMS
    {
      hand_y_hys_wiederholungswerte_1,
      hand_y_hys_wiederholungswerte_2,
      hand_y_hys_wiederholungswerte_3,
      hand_y_hys_wiederholungswerte_4,
      hand_y_hys_wiederholungswerte_5,
      hand_y_hys_wiederholungswerte_6,
      hand_y_hys_wiederholungswerte_7,
      hand_y_hys_wiederholungswerte_8,
      hand_y_hys_wiederholungswerte_9,
      hand_y_hys_wiederholungswerte_10,
      hand_y_hys_wiederholungswerte_11,
      hand_y_hys_wiederholungswerte_12
   }
}



/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - Testfunktionen HAND - Statische Kennlinie */
/* ------------------------------------------------------------------------ */
MENU static_characteristic
{
  #ifdef LABEL_DE_EN
    LABEL "Static characteristic" "|de|Statische Kennlinie";
  #else
    LABEL "Static characteristic";
  #endif

    ITEMS
    {
/* nicht anzeigen und schreiben
      start_abort_static_characteristic,*/ /* Steuerung Statische Kennlinie */
      kl_stepstart,
      kl_stepend,
      kl_step_height,
      kl_delay_time_after_step,
      kl_anzahl_bis_umkehr,
      kl_min_dead_band,
      kl_average_dead_band,
      kl_max_dead_band
    }
}


/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - PST */
/* ------------------------------------------------------------------------ */
MENU tests_pst
{
  #ifdef LABEL_DE_EN
    LABEL "PST" "|de|PST";
  #else
    LABEL "PST";
  #endif

    ITEMS
    {
/* PST Betriebsarten nur im online Fenster anzeigen
      pst_mode_on_off,
      pst_operating_mode,*/
      pst_elapsed_hours_meter_next_PST_test,
      pst_elapsed_hours_meter_auto_test_time,

      /* Einstellungen */
      stepstart,
      stepend,
      pst_step_tolerance_limit,
      pst_activation_ramp_function,
      pst_ramp_time_rising,
      pst_ramp_time_falling,
      pst_settling_time_before_start,
      latency_after_step,
      step_sample_rate,
      pst_rec_scan_rate (READ_ONLY),
      duration_of_test,
      pst_max_test_duration,
      pst_fault_alarm_output,

      /* Abbruchbedingungen */
      pst_activation_x_control,
      pst_x_control_value,
      pst_activation_y_control,
      pst_y_control_value,
      pst_activation_tol_band_control,
      pst_tolerance_band,

      /* Anzeige */
      pst_min_value_y_control,
/*      pst_status_pst_test,*/
      pst_number_of_tests,

      pst_analysis_meas_data  /* Verzeichnis */
/* noch nicht
      pst_meas_data, */       /* Verzeichnis */
    }
    VALIDITY_ONLY_EXPERT_PLUS
}



/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - PST - Messdatenauswertung */
/* ------------------------------------------------------------------------ */
MENU pst_analysis_meas_data
{
  #ifdef LABEL_DE_EN
    LABEL "Analysis of measured data" "|de|Messdatenauswertung";
  #else
    LABEL "Analysis of measured data";
  #endif

    ITEMS
    {
      /* Gespeicherte Auswertungen */

      pst_analysis_meas_data_0,
      pst_analysis_meas_data_1,
      pst_analysis_meas_data_2
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - PST - Messdatenauswertung - Aktueller Test */
/* ------------------------------------------------------------------------ */
MENU pst_analysis_meas_data_0
{
  #ifdef LABEL_DE_EN
    LABEL "Current test" "|de|Aktueller Test";
  #else
    LABEL "Current test";
  #endif

    ITEMS
    {
      /* Gespeicherte Auswertungen */

      /* Aktueller Test */
      pst_elapsed_hours_meter_0,
      overshoot_rising,
      dead_time_rising,
      time_63_rising,
      time_98_rising,
      rise_time_rising_step,
      settling_time_rising_step,

      overshoot_falling,
      dead_time_falling,
      time_63_falling,
      time_98_falling,
      rise_time_falling_step,
      settling_time_falling_step,

      /* Test Status (aktueller Test) */
      pst_status__no_test_0,
      pst_status__x_cancel_0,
      pst_status__y_cancel_0,
      pst_status__tol_band_exceed_0,
      pst_status__max_test_time_exceed_0,
      pst_status__wrong_op_mode_0,
      pst_status__data_memory_full_0,
      pst_status__solenoid_valve_0,
      pst_status__supply_pressure_friction_0
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - PST - Messdatenauswertung - Letzter Test */
/* ------------------------------------------------------------------------ */
MENU pst_analysis_meas_data_1
{
  #ifdef LABEL_DE_EN
    LABEL "Last test" "|de|Letzter Test";
  #else
    LABEL "Last test";
  #endif

    ITEMS
    {
      /* Gespeicherte Auswertungen */

      /* 1. gespeicherte Auswertung (letzter Test) */
      pst_elapsed_hours_meter_1,
      overshoot_rising_1,
      dead_time_rising_1,
      time_63_rising_1,
      time_98_rising_1,
      rise_time_rising_step_1,
      settling_time_rising_step_1,

      overshoot_falling_1,
      dead_time_falling_1,
      time_63_falling_1,
      time_98_falling_1,
      rise_time_falling_step_1,
      settling_time_falling_step_1,

      /* Test Status (letzter Test) */
/*      pst_status__no_test_1,
      pst_status__x_cancel_1,
      pst_status__y_cancel_1,
      pst_status__tol_band_exceed_1,
      pst_status__max_test_time_exceed_1,
      pst_status__wrong_op_mode_1,
      pst_status__data_memory_full_1,
      pst_status__solenoid_valve_1,
      pst_status__supply_pressure_friction_1    */
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - PST - Messdatenauswertung - Vorletzter Test */
/* ------------------------------------------------------------------------ */
MENU pst_analysis_meas_data_2
{
  #ifdef LABEL_DE_EN
    LABEL "Last test but one" "|de|Vorletzter Test";
  #else
    LABEL "Last test but one";
  #endif

    ITEMS
    {
      /* Gespeicherte Auswertungen */

      /* 2. gespeicherte Auswertung (vorletzter Test) */
      pst_elapsed_hours_meter_2,
      overshoot_rising_2,
      dead_time_rising_2,
      time_63_rising_2,
      time_98_rising_2,
      rise_time_rising_step_2,
      settling_time_rising_step_2,

      overshoot_falling_2,
      dead_time_falling_2,
      time_63_falling_2,
      time_98_falling_2,
      rise_time_falling_step_2,
      settling_time_falling_step_2,

      /* Test Status (vorletzter Test) */
/*      pst_status__no_test_2,
      pst_status__x_cancel_2,
      pst_status__y_cancel_2,
      pst_status__tol_band_exceed_2,
      pst_status__max_test_time_exceed_2,
      pst_status__wrong_op_mode_2,
      pst_status__data_memory_full_2,
      pst_status__solenoid_valve_2,
      pst_status__supply_pressure_friction_2*/
    }
}

/* ------------------------------------------------------------------------ */
/* Untermenue: Diagnose - PST - Messwerte */
/* ------------------------------------------------------------------------ */
/* noch nicht
MENU pst_meas_data
{
  #ifdef LABEL_DE_EN
    LABEL "Measured data" "|de|Messwerte";
  #else
    LABEL "Measured data";
  #endif

    ITEMS
    {
    }
}
*/


/* ------------------------------------------------------------------------ */
/* Methods: */
/* ------------------------------------------------------------------------ */


/* ------------------------------------------------------------------------ */
/* PST: Aktuelle Betriebsart PST ermitteln */
/* ------------------------------------------------------------------------ */
METHOD CALC_PST_MODE
{
    LABEL "";
    DEFINITION
    {
        unsigned int  i_read_BA, i_read_pst_mode, diagnose_level;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        /* nur wenn PST Regler macht diese Methode Sinn */
        send_command_trans(171,1); /* Diagnose Level auslesen */
        diagnose_level = ivar_value (diag_level);

        if ( diagnose_level == DIAG_LEVEL_PST )
        {

          i_read_BA = ivar_value (akt_betriebsart);         /* gelesene Betriebsart zuweisen */
          send_command_trans(171,309);                      /* PST Modus einlesen */
          i_read_pst_mode = ivar_value (pst_mode_on_off);   /* PST Modus zuweisen */

          /* wenn akt. Betriebsart = Hand und PST Modus = EIN dann ist PST aktiv */
          if( (i_read_BA == 5) && (i_read_pst_mode == 1) )
          {
            iassign(akt_betriebsart, 33); /* Betriebsart = PST setzen  */
          }

        }
    }
}


/* ------------------------------------------------------------------------ */
/* PST: Eingabe PST-Freigabecode */
/* ------------------------------------------------------------------------ */
METHOD input_pst_enabling_code
{
  #ifdef LABEL_DE_EN
    LABEL "PST enabling code" "|de|PST Freigabecode";
  #else
    LABEL "PST enabling code";
  #endif

    DEFINITION
    {
        unsigned int  temp_pst_enabling_code;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

	    temp_pst_enabling_code = 0; /* Vorgabewert Freigabecode fuer Anwender auf 0 setzen */
        /* Wert vom Anwender holen: */
        GET_LOCAL_VAR_VALUE("Please enter the PST enabling code:"
                            "|de|Bitte PST Freigabecode eingeben:", temp_pst_enabling_code);

	    iassign(pst_enabling_code, temp_pst_enabling_code); /* Anwenderwert uebernehmen  */
        send_command(255); /* Freigabecode schreiben */

        ACKNOWLEDGE("PST enabling code has been written."
                    "|de|PST Freigabecode wurde geschrieben.");
    }

    #ifdef HELP_DE_EN
      HELP "Write protection for PST mode."
           "|de|PST Schreibschutz.";
    #else
      HELP "Write protection for PST mode.";
    #endif
}


/* ------------------------------------------------------------------------ */
/* PST: Ruecksetzen */
/* ------------------------------------------------------------------------ */
METHOD method_pst_reset
{
  #ifdef LABEL_DE_EN
  LABEL    "PST Reset" "|de|PST Rcksetzen";
  #else
  LABEL    "PST Reset";
  #endif

    DEFINITION
    {
		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        ACKNOWLEDGE("Reset all PST parameter ?"
                    "|de|Alle PST-Parameter zurcksetzen ?");

        send_command(182); /* PST ruecksetzen */

        ACKNOWLEDGE("All PST parameter have been reset."
                    "|de|Alle PST-Parameter wurden zurckgesetzt.");
    }

#ifdef HELP_EP_DE_EN
  HELP     "All PST parameters will be reset to default values and all measured "
           "data will be deleted."
           "|de|Smtliche PST-Parameter werden auf Defaultwerte gesetzt und "
           "alle Messdaten werden gelscht.";
#endif
}


/*----------------------------------------------------------------------------*/
/* Standard button fuer Uebertragen */
METHOD transmit_button
{
	LABEL [transfer];
	CLASS INPUT;
	DEFINITION{}
}

METHOD configuration_flag_reset
{
	CLASS		INPUT;
	LABEL		[configuration_flag_reset];
	HELP		[configuration_flag_reset_help];
	DEFINITION
	{
		int		choice;
		char	disp_string1[60];
		char	disp_string2[60];
		int		slen1;
		int		slen2;
        int     wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

		slen1=60;
		slen2=60;
		get_dictionary_string(configuration_flag_reset_execute, disp_string1, slen1);
		get_dictionary_string(yes_no, disp_string2, slen2);
		choice= SELECT_FROM_LIST(disp_string1, disp_string2);
		if ( choice == 0 )
		{
    		DELAY(2, "Reset" "|de|Wird rckgesetzt");
			send_command(38);
		}
	}
}
/*****************************************************************************/



/*METHOD method_PDM_StandardDiagnosis*/
METHOD method_PDM_DeviceDiagnosis
{
    LABEL       "Diagnosis" "|de|Diagnose";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {
        int i_stat_0, i_stat_1, i_stat_2, i_stat_3, i_stat_7, i_stat_8;
        int akt_BA, dev_status;
        int i_no_good; /* Merker zum Lschen anderer Stati */
        int sammelstatus;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        send_command(48);     /* Status einlesen */
        /* Status zuweisen */
        i_stat_0 = int_value(xmtr_specific_status_0);
        i_stat_1 = int_value(xmtr_specific_status_1);
        i_stat_2 = int_value(xmtr_specific_status_2);
        i_stat_3 = int_value(xmtr_specific_status_3);
        i_stat_7 = int_value(xmtr_specific_status_7);
        i_stat_8 = int_value(xmtr_specific_status_8);
        sammelstatus = ivar_value (namur_sammelstatus);  /* NAMUR Sammelstatus kopieren */
        dev_status = ivar_value (device_status);         /* Gertezustand kopieren */

        /* Parameter vorbelegen: */
		PDM_Diag_Status_Diagnosis = 0;     /* NAMUR-Icon */
		PDM_Diag_Rule_Message     = "";    /* Diagnose Meldung */
    		i_no_good = 0;                     /* unten setzen wenn in Methode PDM_Diag_Status_Diagnosis
                                              neu gesetzt wird */

        /* Variablen fuer Lesebefehl 130 vorbelegen */
	    iassign(static_enums_code1,  86);    /* akt. Betriebsart */
	    iassign(static_enums_code2,  94);    /* irgendwas */
	    iassign(static_enums_code3,  52);    /* irgendwas */
	    iassign(static_enums_code4,  56);    /* irgendwas */
        send_command(130); /* akt. Betriebsart auslesen */
        akt_BA = ivar_value (akt_betriebsart);

        /*----------------------------------------------*/
        /* Auswertung der eingelesenen Statusparameter: */
        /*----------------------------------------------*/
        /* wenn Hand aktiv: */
        if ((akt_BA == AKT_BA_HAND_IP)  ||
            (akt_BA == AKT_BA_HAND_W )  ||
            (akt_BA == AKT_BA_HAND_W_STEUERUNG ))
        {
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MODE_LOCAL_OVERRIDE;
			PDM_Diag_Rule_Message += "Manual mode active;"
			                         "|de|Betriebsart Hand aktiv;";
            i_no_good += 1; /* good lschen */
        }

        /*---------------------------------------------*/
        /* device_status (Gertezustand)               */
        /*---------------------------------------------*/
		if( dev_status & 0x40 )
		{
			PDM_Diag_Rule_Message += [configuration_changed] + ";";
		}

		if( dev_status & 0x80 )
		{
			PDM_Diag_Rule_Message += [device_malfunction] + ";";
		}

		if( dev_status & 0x10 )
		{
			PDM_Diag_Rule_Message += [more_status_available] + ";";
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_0 (Fehlercodes Byte 0) */
        /*---------------------------------------------*/
		if( i_stat_0 & 0x01 )
		{   /* Code 50 */
			PDM_Diag_Rule_Message += "x > range;" "|de|x > Bereich;";
		}

		if( i_stat_0 & 0x02 )
		{   /* Code 51 */
			PDM_Diag_Rule_Message += "Delta x < range;" "|de|Delta x < Bereich;";
		}

		if( i_stat_0 & 0x04 )
		{   /* Code 52 */
			PDM_Diag_Rule_Message += "Attachment;" "|de|Anbau;";
		}

		if( i_stat_0 & 0x08 )
		{   /* Code 53 */
			PDM_Diag_Rule_Message += "Initialization time exceeded;"
			                         "|de|Initialisierungszeit berschritten;";
		}

		if( i_stat_0 & 0x10 )
		{   /* Code 54 */
			PDM_Diag_Rule_Message += "Initialization / solenoid valve;"
			                         "|de|Initialisierung / Magnetventil;";
		}

		if( i_stat_0 & 0x20 )
		{   /* Code 55 */
			PDM_Diag_Rule_Message += "Travel time too short;"
			                         "|de|Laufzeit unterschritten;";
		}

		if( i_stat_0 & 0x40 )
		{   /* Code 56 */
			PDM_Diag_Rule_Message += "Pin position;" "|de|Stiftposition;";
		}

		if( i_stat_0 & 0x80 )
		{   /* Code 57 */
			PDM_Diag_Rule_Message += "Control loop;" "|de|Regelkreis;";
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_1 (Fehlercodes Byte 1) */
        /*---------------------------------------------*/
		if( i_stat_1 & 0x01 )
		{   /* Code 58 */
			PDM_Diag_Rule_Message += "Zero point;" "|de|Nullpunkt;";
		}

		if( i_stat_1 & 0x02 )
		{   /* Code 59 */
			PDM_Diag_Rule_Message += "Autocorrection;" "|de|Autokorrektur;";
		}

		if( i_stat_1 & 0x04 )
		{   /* Code 60 */
			PDM_Diag_Rule_Message += "Fatal error;" "|de|Fataler Fehler;";
		}

		if( i_stat_1 & 0x10 )
		{   /* Code 62 */
			PDM_Diag_Rule_Message += "x-signal;" "|de|x-Signal;";
		}

		if( i_stat_1 & 0x20 )
		{   /* Code 63 */
			PDM_Diag_Rule_Message += "W too small;" "|de|W zu klein;";
		}

		if( i_stat_1 & 0x40 )
		{   /* Code 64 */
			PDM_Diag_Rule_Message += "i/p-converter;" "|de|i/p-Wandler;";
		}

		if( i_stat_1 & 0x80 )
		{   /* Code 65 */
			PDM_Diag_Rule_Message += "Hardware;" "|de|Hardware;";
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_2 (Fehlercodes Byte 2) */
        /*---------------------------------------------*/
		if( i_stat_2 & 0x01 )
		{   /* Code 66 */
			PDM_Diag_Rule_Message += "Data memory;" "|de|Datenspeicher;";
		}

		if( i_stat_2 & 0x02 )
		{   /* Code 67 */
			PDM_Diag_Rule_Message += "Test calculation;" "|de|Kontrollrechnung;";
		}

		if( i_stat_2 & 0x04 )
		{   /* Code 68 */
			PDM_Diag_Rule_Message += "Control parameter;" "|de|Regelparameter;";
		}

		if( i_stat_2 & 0x08 )
		{   /* Code 69 */
			PDM_Diag_Rule_Message += "Poti parameter;" "|de|Potiparameter;";
		}

		if( i_stat_2 & 0x10 )
		{   /* Code 70 */
			PDM_Diag_Rule_Message += "Configuration parameter;"
			                         "|de|Abgleichparameter;";
		}

		if( i_stat_2 & 0x20 )
		{   /* Code 71 */
			PDM_Diag_Rule_Message += "General parameter;" "|de|Allgemeine Parameter;";
		}

		if( i_stat_2 & 0x80 )
		{   /* Code 73 */
			PDM_Diag_Rule_Message += "Internal device error 1;"
			                         "|de|Interner Gertefehler 1;";
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_3 (Fehlercodes Byte 3) */
        /*---------------------------------------------*/
		if( i_stat_3 & 0x01 )
		{   /* Code 74 */
			PDM_Diag_Rule_Message += "HART parameter;" "|de|HART Parameter;";
		}

		if( i_stat_3 & 0x02 )
		{   /* Code 75 */
			PDM_Diag_Rule_Message += "Info parameter;" "|de|Info Parameter;";
		}

		if( i_stat_3 & 0x04 )
		{   /* Code 76 */
			PDM_Diag_Rule_Message += "No emergency mode;"
			                         "|de|Keine Notlaufeigenschaft;";
		}

		if( i_stat_3 & 0x08 )
		{   /* Code 77 */
			PDM_Diag_Rule_Message += "Program load error;"
			                         "|de|Programmladefehler;";
		}

		if( i_stat_3 & 0x10 )
		{   /* Code 78 */
			PDM_Diag_Rule_Message += "Options parameter;"
			                         "|de|Optionsparameter;";
		}

		if( i_stat_3 & 0x40 )
		{   /* Code 80 */
			PDM_Diag_Rule_Message += "Diagnosis parameter;"
			                         "|de|Diagnoseparameter;";
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_7 (Gertestatus 1) */
        /*---------------------------------------------*/
		if( i_stat_7 & 0x01 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_HIGH;
            i_no_good += 1; /* good lschen */
			PDM_Diag_Rule_Message += "Device not initialized;"
			                         "|de|Gert nicht initialisiert;";
		}

		if( i_stat_7 & 0x02 )
		{
			PDM_Diag_Rule_Message += "Initialization not successful;"
			                         "|de|Initialisierung nicht erfolgreich;";
		}

		if( i_stat_7 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Initialization is running;"
			                         "|de|Initialisierung luft;";
		}

		if( i_stat_7 & 0x10 )
		{
			PDM_Diag_Rule_Message += "User defined characteristics not valid;"
			                         "|de|Benutzerdef. Kennlinie ungltig;";
		}

        /*---------------------------------------------*/
        /* xmtr_specific_status_8 (Gertestatus 2)     */
        /*---------------------------------------------*/
		if( i_stat_8 & 0x04 )
		{
			PDM_Diag_Rule_Message += "Zero point error;" "|de|Nullpunktfehler;";
		}

		if( i_stat_8 & 0x10 )
		{
			PDM_Diag_Rule_Message += "Total valve travel exceeded;"
			                         "|de|Wegintegral berschritten;";
		}

        /********************************/
        /* NAMUR Sammelstatus auswerten */
        /********************************/
        /*   { 0,   "No message"           "|de|Keine Meldung"       },
             { 1,   "Maintenance required" "|de|Wartungsbedarf"      },
             { 2,   "Maintenance demanded" "|de|Wartungsanforderung" },
             { 3,   "Maintenance alarm"    "|de|Ausfall"             },
             { 7,   "Function check"       "|de|Funktionskontrolle"  }  */

		if( sammelstatus == 0 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_GOOD;
		}
		else if( sammelstatus == 1 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_LOW;
            i_no_good += 1; /* good lschen */
		}
		else if( sammelstatus == 2 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_MEDIUM;
            i_no_good += 1; /* good lschen */
		}
		else if( sammelstatus == 3 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MAINT_HIGH;
            i_no_good += 1; /* good lschen */
		}
		else if( sammelstatus == 7 )
		{
			PDM_Diag_Status_Diagnosis |= PDM_DIAG_MODE_TEST;
            i_no_good += 1; /* good lschen */
		}


        /* wenn Icon nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD; /* Alles OK */
			PDM_Diag_Rule_Message = "Status OK"
			                        "|de|Zustand OK"
			                        "|fr|Etat OK"
			                        "|it|Stato OK"
			                        "|sp|Estado OK";
		}


        /* wenn Status PDM_DIAG_GOOD gelscht werden soll: */
		if( i_no_good != 0 )
		{    /* nur PDM_DIAG_GOOD lschen */
			PDM_Diag_Status_Diagnosis &= PDM_DIAG_GOOD_INVERS;
		}

    }
}
/*****************************************************************************/


/* ------------------------------------------------------------------------ */
/* Kurze Version der Methoden fuer Nullpunktabgleich und Initialisierung:   */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Parameter: Nullpunktabgleich            Doku-Nummer: 211   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD start_nullpunktabgleich
{
  #ifdef LABEL_DE_EN
    LABEL "Zero point adjustment" "|de|Nullpunktabgleich";
  #else
    LABEL "Zero point adjustment";
  #endif

    DEFINITION
    {
		char status[STATUS_SIZE];
		char dev_status[DEV_STATUS_SIZE];
		int  cnt;
        long ids[2];
        int  wrProt; /* Speicher fuer Schreibschutztest */
        int  error;
        int  akt_BA; /* aktuelle Betriebsart */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */
        CHECK_ACT_MODE /* Wenn akt. Betriebsart = Sicherheitsstellung: nicht auslsen ! */

        ACKNOWLEDGE("WARNING: Never start zero point adjustment during a running process !\n"
                    "During zero point adjustment the control valve departs from its current "
                    "position at full travel !\n\n"
                    "Status of zero point adjustment: \nsee parameter 'Status initialization' "
                    "and 'Error codes'.\n\n"
                    "Start zero point adjustment ?"
                    "|de|WARNUNG: Der Nullpunktabgleich darf nicht whrend eines laufenden "
                    "Prozesses erfolgen !\n"
                    "Bei Nullpunktabgleich fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status des Nullpunktabgleichs: \nsiehe Parameter 'Status Initialisierung' "
                    "und 'Fehlercodes'.\n\n"
                    "Nullpunktabgleich starten ?");

	    iassign(start_action, 3); /* NP-Abgleich auslsen */
        send_command(145);
    }

  #ifdef HELP_DE_EN
    HELP "Start the zero point adjustment."
         "|de|Start des Nullpunktabgleichs.";
  #else
    HELP "Start the zero point adjustment.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Initialisierung              Doku-Nummer: 212   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD start_initialisierung
{
  #ifdef LABEL_DE_EN
    LABEL "Initialization" "|de|Initialisierung";
  #else
    LABEL "Initialization";
  #endif

    DEFINITION
    {
      char  status[STATUS_SIZE];
      char  dev_status[DEV_STATUS_SIZE];
      int   cnt;
      long  ids[2];
      int   wrProt; /* Speicher fuer Schreibschutztest */
      int   error;
      int   akt_BA; /* aktuelle Betriebsart */

      XMTR_IGNORE_ALL_COMM_STATUS();
      XMTR_IGNORE_ALL_DEVICE_STATUS();
      XMTR_IGNORE_ALL_RESPONSE_CODES();
      XMTR_IGNORE_COMM_ERROR();

      IGNORE_ALL_COMM_STATUS();
      IGNORE_ALL_DEVICE_STATUS();
      IGNORE_ALL_RESPONSE_CODES();
      IGNORE_COMM_ERROR();

      XMTR_RETRY_ON_NO_DEVICE();
      RETRY_ON_NO_DEVICE();

      CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */
      CHECK_ACT_MODE /* Wenn akt. Betriebsart = Sicherheitsstellung: nicht auslsen ! */

      ACKNOWLEDGE("WARNING: Never start initialization during a running process !\n"
                  "During initialization the control valve departs from its current "
                  "position at full travel !\n"
                  "Hint: previously the parameter initialization mode "
                  "must have the required value.\n\n"
                  "Status of initialization: \nsee parameter 'Status initialization' "
                  "and 'Error codes'.\n\n"
                  "Start initialization ?"
                  "|de|WARNUNG: Die Initialisierung darf nicht whrend eines laufenden"
                  " Prozesses erfolgen !\n"
                  "Bei Initialisierung fhrt das Stellgert den gesamten Bereich durch !\n"
                  "Hinweis: Initialisierungsart vorher "
                  "auf gewnschten Wert einstellen.\n\n"
                  "Status der Initialisierung: \nsiehe Parameter 'Status Initialisierung' "
                  "und 'Fehlercodes'.\n\n"
                  "Initialisierung starten ?");

      iassign(start_action, 2); /* Initialisierung auslsen */
      send_command(145);
    }

  #ifdef HELP_DE_EN
    HELP "Start the initialization sequence. Previously the parameter "
         "initialization mode must have the required value."
         "|de|Start der Initialisierung. Der Parameter "
         "Initialisierungsart muss vorher auf die gewnschte "
         "Initialisierungs - Sequenz eingestellt sein.";
  #else
    HELP "Start the initialization sequence. Previously the parameter "
         "initialization mode must have the required value.";
  #endif
}


/* ------------------------------------------------------------------------ */
/* Kaltstart ausloesen                                                      */
/* ------------------------------------------------------------------------ */
METHOD start_kaltstart
{
  #ifdef LABEL_DE_EN
    LABEL "Default values" "|de|Defaultwerte";
  #else
    LABEL "Default values";
  #endif

    DEFINITION
    {
        int  wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        ACKNOWLEDGE("Warning: never start with default values during a running process ! "
                    "The valve departs from its current position at full travel !"
                    "|de|Warnung: Start mit Defaultwerten darf nicht whrend eines "
                    "laufenden Prozesses erfolgen ! "
                    "Ventil fhrt durch gesamten Bereich !");

        ACKNOWLEDGE("Note: A new initialization will be necessary."
                    "|de|Hinweis: Eine erneute Initialisierung wird erforderlich.");

        CHECK_WRITE_PROTECTION  /* auf Schreibschutz testen */
        iassign( start_action, 105 ); /* Parameter Kaltstart auf Start setzen */
        send_command(145);            /* Kaltstart auslsen */

        DELAY(20,"Device is resetting..." "|de|Gert wird zurckgesetzt...");

        ACKNOWLEDGE("Note: new communication startup necessary to get "
                    "current device data."
                    "|de|Hinweis: Erneuter Verbindungsaufbau notwendig "
                    "um Gertedaten neu zu lesen.");
    }

  #ifdef HELP_DE_EN
    HELP "Resets all parameters to default (factory setting). "
         "Note: After reset the device must be re-initialized."
         "|de|Setzt alle Parameter auf Standardwerte (Werkseinstellung) zurck. "
         "Hinweis: Nach dem Setzen muss das Gert neu initialisiert werden.";
  #else
    HELP "Resets all parameters to default (factory setting). "
         "Note: After reset the device must be re-initialized.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Ruecksetzen der Fehlerbits                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_fehler
{
  #ifdef LABEL_DE_EN
    LABEL "Reset error" "|de|Rcksetzen Fehler";
  #else
    LABEL "Reset error";
  #endif

    DEFINITION
    {
        int result;
        int wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        result = SELECT_FROM_LIST("Reset error:" "|de|Rcksetzen Fehler:",
          "x > range;"             /* 0  Fehler 50   */
          "Delta x < range;"       /* 1  Fehler 51   */
          "Attachment;"            /* 2  Fehler 52   */
          "Init. time >;"          /* 3  Fehler 53   */
          "Init./sol. valve;"      /* 4  Fehler 54   */
          "Travel time <;"         /* 5  Fehler 55   */
          "Pin position;"          /* 6  Fehler 56   */
          "Zero point;"            /* 7  Fehler 58   */
          "Autocorrection;"        /* 8  Fehler 59   */
          "Hardware;"              /* 9  Fehler 65   */
          "Test calculation;"      /* 10 Fehler 67   */
          "Control parameter;"     /* 11 Fehler 68   */
          "Poti parameter;"        /* 12 Fehler 69   */
          "General parameter;"     /* 13 Fehler 71   */
          "HART parameter;"        /* 14 Fehler 74   */
          "Info parameter"         /* 15 Fehler 75   */
          /*"Config. changed" */   /* 16 config changed flag (Para 358) */

          "|de|x > Bereich;"       /* 0  Fehler 50   */
          "Delta x < Bereich;"     /* 1  Fehler 51   */
          "Anbau;"                 /* 2  Fehler 52   */
          "Init.-zeit >;"          /* 3  Fehler 53   */
          "Init./Magnetventil;"    /* 4  Fehler 54   */
          "Laufzeit <;"            /* 5  Fehler 55   */
          "Stiftposition;"         /* 6  Fehler 56   */
          "Nullpunkt;"             /* 7  Fehler 58   */
          "Autokorrektur;"         /* 8  Fehler 59   */
          "Hardware;"              /* 9  Fehler 65   */
          "Kontrollrechnung;"      /* 10 Fehler 67   */
          "Regelparameter;"        /* 11 Fehler 68   */
          "Potiparameter;"         /* 12 Fehler 69   */
          "Allg. Parameter;"       /* 13 Fehler 71   */
          "HART Parameter;"        /* 14 Fehler 74   */
          "Info Parameter"  );     /* 15 Fehler 75   */
          /*"Konfig. gendert"*/   /* 16 config changed flag (Para 358) */

        /* ------------------------------------------------------------------------ */
        /* Parameter: Rcks. Fehlercodes  Doku-Nr.: 213-236,240,330  EB-Code: ab 50 */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset this error message ?"
                    "|de|Diese Fehlermeldung zurcksetzen ?");
        if (result == 0)
        { /* Fehler 50  (X > Bereich-Fehler zuruecksetzen) */
          iassign(start_action, 120);
          send_command(145);
        }
        if (result == 1)
        { /* Fehler 51  (dX > Bereich zuruecksetzen) */
          iassign(start_action, 121);
          send_command(145);
        }
        if (result == 2)
        { /* Fehler 52  (Anbau-Fehler zuruecksetzen) */
          iassign(start_action, 122);
          send_command(145);
        }
        if (result == 3)
        { /* Fehler 53  (Init-Zeit > - Fehler zuruecksetzen) */
          iassign(start_action, 123);
          send_command(145);
        }
        if (result == 4)
        { /* Fehler 54  (Init-MGV-Fehler zuruecksetzen) */
          iassign(start_action, 124);
          send_command(145);
        }
        if (result == 5)
        { /* Fehler 55  (Laufzeit < - Fehler zuruecksetzen) */
          iassign(start_action, 125);
          send_command(145);
        }
        if (result == 6)
        { /* Fehler 56  (Stiftposition-Fehler zuruecksetzen) */
          iassign(start_action, 126);
          send_command(145);
        }
        if (result == 7)
        { /* Fehler 58  (Nullpunkt-Fehler zuruecksetzen) */
          iassign(start_action, 128);
          send_command(145);
        }
        if (result == 8)
        { /* Fehler 59  (Autokorrektur-Fehler zuruecksetzen) */
          iassign(start_action, 129);
          send_command(145);
        }
        if (result == 9)
        { /* Fehler 65  (Hardware-Fehler zuruecksetzen) */
          iassign(start_action, 134);
          send_command(145);
        }
        if (result == 10)
        { /* Fehler 67  (Kontrollrechnung-Fehler zuruecksetzen) */
          iassign(start_action, 136);
          send_command(145);
        }
        if (result == 11)
        { /* Fehler 68  (Regelparameter-Fehler zuruecksetzen) */
          iassign(start_action, 137);
          send_command(145);
        }
        if (result == 12)
        { /* Fehler 69  (Poti-Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 138);
          send_command(145);
        }
        if (result == 13)
        { /* Fehler 71  (Allgemeine-Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 140);
          send_command(145);
        }
        if (result == 14)
        { /*  Fehler 74  (HART-Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 143);
          send_command(145);
        }
        if (result == 15)
        { /*  Fehler 75  (Info Parameter-Fehler zuruecksetzen) */
          iassign(start_action, 141);
          send_command(145);
        }

        /* ------------------------------------------------------------------------ */
        /* Parameter: Ruecksetzen 'Konfiguration geaendert'      Doku-Nummer: 358   */
        /* ------------------------------------------------------------------------ */
        /*if (result == 16)
        {
          ACKNOWLEDGE("Reset this message ?"
                      "|de|Diese Meldung zurcksetzen ?");
          send_command(38);
        }*/

        DELAY(3,"resetting..." "|de|wird zurckgesetzt...");
    }

  #ifdef HELP_DE_EN
    HELP "Resets different flags back to zero."
         "|de|Setzt verschiedene Flags auf 0 zurck.";
  #else
    HELP "Resets different flags back to zero.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Ruecksetzen Kaltstart-Flag                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_cold_start_flag
{
  #ifdef LABEL_DE_EN
    LABEL "Reset 'default values flag'" "|de|Rcksetzen 'Defaultwerte Flag'";
  #else
    LABEL "Reset 'default values flag'";
  #endif

    DEFINITION
    {
        int wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        /* ------------------------------------------------------------------------ */
        /* Parameter: Ruecksetzen Kaltstart Flag   Doku-Nummer: 353   EB-Code: --   */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset default values flag ?"
                    "|de|Defaultwerte Flag zurcksetzen ?");
        iassign(start_action, 144); /* Kaltstart Flag zurcksetzen */
        send_command(145);

        DELAY(3,"resetting..." "|de|wird zurckgesetzt...");
    }

  #ifdef HELP_DE_EN
    HELP "Resets default values flag back to zero."
         "|de|Setzt Defaultwerte Flag auf 0 zurck.";
  #else
    HELP "Resets default values flag back to zero.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Ruecksetzen Zaehler Wegintegral                                          */
/* ------------------------------------------------------------------------ */
METHOD reset_valve_travel_counter
{
  #ifdef LABEL_DE_EN
    LABEL "Reset 'total valve travel'" "|de|Rcksetzen 'Abs. Wegintegral'";
  #else
    LABEL "Reset 'total valve travel'";
  #endif

    DEFINITION
    {
        int result;
        int wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        /* ------------------------------------------------------------------------ */
        /* Parameter: Ruecksetzen Wegintegral      Doku-Nummer: 209   EB-Code: --   */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset total valve travel counter to zero ?"
                    "|de|Zhler fr absolutes Wegintegral auf 0 setzen ?");
        iassign(start_action, 119); /* Wegintegral zurcksetzen */
        send_command(145);

        DELAY(3,"resetting..." "|de|wird zurckgesetzt...");
    }

  #ifdef HELP_DE_EN
    HELP "Resets total valve travel counter back to zero."
         "|de|Setzt Zhler fr absolutes Wegintegral auf 0 zurck.";
  #else
    HELP "Resets total valve travel counter back to zero.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Abbruch Nullpunktabgleich    Doku-Nummer: 354   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD abort_zp_adjust
{
  #ifdef LABEL_DE_EN
    LABEL "Abort zero point adjustment" "|de|Abbruch Nullpunktabgleich";
  #else
    LABEL "Abort zero point adjustment";
  #endif

    DEFINITION
    {
       int  wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

       ACKNOWLEDGE("Abort running zero point adjustment ?"
                   "|de|Laufenden Nullpunktabgleich abbrechen ?");

       CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

       iassign(abort_action, 3); /* 'Nullpunktabgleich abbrechen' senden */
       send_command(146);
       DELAY(3,"Zero point adjustment is aborted."
               "|de|Nullpunktabgleich wird abgebrochen.");
    }

  #ifdef HELP_DE_EN
    HELP "Abort the running zero point adjustment. "
         "The valve is moved to the fail-safe position."
         "|de|Abbruch des laufenden Nullpunktabgleichs. "
         "Stellventil wird in die Sicherheitsstellung gefahren.";
  #else
    HELP "Abort the running zero point adjustment. "
         "The valve is moved to the fail-safe position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Abbruch Nullpunktabgleich    Doku-Nummer: 354   EB-Code: --   */
/*            (ohne Benutzer-Abfrage; fr add_abort_method)                 */
/* ------------------------------------------------------------------------ */
METHOD abort_zp_adjust_2
{
  #ifdef LABEL_DE_EN
    LABEL "Abort zero point adjustment" "|de|Abbruch Nullpunktabgleich";
  #else
    LABEL "Abort zero point adjustment";
  #endif

    DEFINITION
    {
       int  wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

       CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

       iassign(abort_action, 3); /* 'Nullpunktabgleich abbrechen' senden */
       send_command(146);
       DELAY(3,"Zero point adjustment is aborted."
               "|de|Nullpunktabgleich wird abgebrochen.");
    }

  #ifdef HELP_DE_EN
    HELP "Abort the running zero point adjustment. "
         "The valve is moved to the fail-safe position."
         "|de|Abbruch des laufenden Nullpunktabgleichs. "
         "Stellventil wird in die Sicherheitsstellung gefahren.";
  #else
    HELP "Abort the running zero point adjustment. "
         "The valve is moved to the fail-safe position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Abbruch Initialisierung      Doku-Nummer: 355   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD abort_init
{
  #ifdef LABEL_DE_EN
    LABEL "Abort initialization" "|de|Abbruch Initialisierung";
  #else
    LABEL "Abort initialization";
  #endif

    DEFINITION
    {
        int  wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        ACKNOWLEDGE("Abort the running initialization ?"
                    "|de|Laufende Initialisierung abbrechen ?");

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        iassign(abort_action, 2); /* 'Initialisierung abbrechen' senden */
        send_command(146);
        DELAY(3,"Initialization is aborted."
                "|de|Initialisierung wird abgebrochen.");
    }

  #ifdef HELP_DE_EN
    HELP "Abort the running initialization. "
         "The valve is moved to the fail-safe position."
         "|de|Abbruch der laufenden Initialisierung. "
         "Stellventil wird in die Sicherheitsstellung gefahren.";
  #else
    HELP "Abort the running initialization. "
         "The valve is moved to the fail-safe position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Abbruch Initialisierung      Doku-Nummer: 355   EB-Code: --   */
/*            (ohne Benutzer-Abfrage; fr add_abort_method)                 */
/* ------------------------------------------------------------------------ */
METHOD abort_init_2
{
  #ifdef LABEL_DE_EN
    LABEL "Abort initialization" "|de|Abbruch Initialisierung";
  #else
    LABEL "Abort initialization";
  #endif

    DEFINITION
    {
        int  wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        iassign(abort_action, 2); /* 'Initialisierung abbrechen' senden */
        send_command(146);
        DELAY(3,"Initialization is aborted."
                "|de|Initialisierung wird abgebrochen.");
    }

  #ifdef HELP_DE_EN
    HELP "Abort the running initialization. "
         "The valve is moved to the fail-safe position."
         "|de|Abbruch der laufenden Initialisierung. "
         "Stellventil wird in die Sicherheitsstellung gefahren.";
  #else
    HELP "Abort the running initialization. "
         "The valve is moved to the fail-safe position.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraet suchen                Doku-Nummer: 362   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD search_device
{
  #ifdef LABEL_DE_EN
    LABEL "Search device" "|de|Gert suchen";
  #else
    LABEL "Search device";
  #endif

    DEFINITION
    {
       int  wrProt; /* Speicher fuer Schreibschutztest */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

       CHECK_WRITE_PROTECTION    /* auf Schreibschutz testen */

       iassign(start_action, 4); /* 'Gert suchen' senden */
       send_command(145);
    }

  #ifdef HELP_DE_EN
    HELP "Displays 'Here I am' at the connected device."
         "|de|Anzeige von 'Here I am' am angeschlossenem Gert.";
  #else
    HELP "Displays 'Here I am' at the connected device."
         "|de|Anzeige von 'Here I am' am angeschlossenem Gert.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Parameter: Alarm Test                Doku-Nummer: 35/238   EB-Code: 28   */
/* ------------------------------------------------------------------------ */
METHOD met_alarm_test
{
  #ifdef LABEL_DE_EN
    LABEL "Alarm test" "|de|Alarm Test";
  #else
    LABEL "Alarm test";
  #endif

    DEFINITION
    {
        int  alarm_test_tmp;
        int  wrProt;
        int  ind_gk;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        iassign(static_enums_code1, 75);  /* auf ind_grenzkontakt stellen */
        send_command(130);                /* ind_grenzkontakt einlesen */
        ind_gk = int_value(ind_grenzkontakt);

        /* wenn ind. Grenzkontakt eingebaut: Test A1 weglassen */
        if (ind_gk == IMPLEMENTED)
        {
          alarm_test_tmp = SELECT_FROM_LIST("Test ..." "|de|Teste ...",
          "A2;"     "A3 (Fault alarm output)"
          "|de|A2;" "A3 (Strmeldeausgang)"  );
          alarm_test_tmp = alarm_test_tmp + 1; /* +1 weil Antwort 0 - 1 - 2 sein soll */
        }
        else
        {
          alarm_test_tmp = SELECT_FROM_LIST("Test ..." "|de|Teste ...",
          "A1;"     "A2;" "A3 (Fault alarm output)"
          "|de|A1;" "A2;" "A3 (Strmeldeausgang)"  );
          /* keine Korrektur notwendig, weil Antwort 0 - 1 - 2 ist */
        }

        if (alarm_test_tmp == 0) /* Test A1 */
        {
          ACKNOWLEDGE("Limit switch A1 will switch 5 times."
                      "|de|Grenzkontakt A1 wird 5 mal geschaltet.");
          iassign(start_action, 101); /* Test A1 senden */
          send_command(145);
        }
        if (alarm_test_tmp == 1) /* Test A2 */
        {
          ACKNOWLEDGE("Limit switch A2 will switch 5 times."
                      "|de|Grenzkontakt A2 wird 5 mal geschaltet.");
          iassign(start_action, 102); /* Test A2 senden */
          send_command(145);
        }
        if (alarm_test_tmp == 2) /* Test Strmeldung A3 */
        {
          ACKNOWLEDGE("Error switch A3 will switch 5 times."
                      "|de|Strmeldekontakt A3 wird 5 mal geschaltet.");
          iassign(start_action, 100); /* Test Strmeldung A3 senden */
          send_command(145);
        }
    }

  #ifdef HELP_DE_EN
    HELP "Testing the software limit switches A1 / A2 and the fault "
         "alarm output A3."
         "|de|Test der Software - Grenzkontakte A1 und A2 sowie des "
         "Strmeldekontaktes A3.";
  #else
    HELP "Testing the software limit switches A1 / A2 and the fault "
         "alarm output A3.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Methode: kennl_eingabe                                                   */
/*          zur Eingabe der Sttzwerte der benutzerdefinierten Kennlinie    */
/* ------------------------------------------------------------------------ */
METHOD kennl_eingabe
{
  #ifdef LABEL_DE_EN
    LABEL "User-defined characteristic" "|de|Benutzerdefinierte Kennlinie";
  #else
    LABEL "User-defined characteristic";
  #endif

    DEFINITION
    {
	  char status[STATUS_SIZE];
	  char dev_status[DEV_STATUS_SIZE];
	  int  param_nr;
      int  wrProt;

	  XMTR_IGNORE_ALL_COMM_STATUS();
	  XMTR_IGNORE_ALL_DEVICE_STATUS();
	  XMTR_IGNORE_ALL_RESPONSE_CODES();
	  XMTR_IGNORE_COMM_ERROR();

	  IGNORE_ALL_COMM_STATUS();
	  IGNORE_ALL_DEVICE_STATUS();
	  IGNORE_ALL_RESPONSE_CODES();
	  IGNORE_COMM_ERROR();

      XMTR_RETRY_ON_NO_DEVICE();
      RETRY_ON_NO_DEVICE();


      CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

	  GET_DEV_VAR_VALUE("x[0]", x0);
	  GET_DEV_VAR_VALUE("y[0]", y0);

	  GET_DEV_VAR_VALUE("x[1]", x1);
	  GET_DEV_VAR_VALUE("y[1]", y1);

	  GET_DEV_VAR_VALUE("x[2]", x2);
	  GET_DEV_VAR_VALUE("y[2]", y2);

	  GET_DEV_VAR_VALUE("x[3]", x3);
	  GET_DEV_VAR_VALUE("y[3]", y3);

	  GET_DEV_VAR_VALUE("x[4]", x4);
	  GET_DEV_VAR_VALUE("y[4]", y4);

	  GET_DEV_VAR_VALUE("x[5]", x5);
	  GET_DEV_VAR_VALUE("y[5]", y5);

	  GET_DEV_VAR_VALUE("x[6]", x6);
	  GET_DEV_VAR_VALUE("y[6]", y6);

	  GET_DEV_VAR_VALUE("x[7]", x7);
	  GET_DEV_VAR_VALUE("y[7]", y7);

	  GET_DEV_VAR_VALUE("x[8]", x8);
	  GET_DEV_VAR_VALUE("y[8]", y8);

	  GET_DEV_VAR_VALUE("x[9]", x9);
	  GET_DEV_VAR_VALUE("y[9]", y9);

	  GET_DEV_VAR_VALUE("x[10]", x10);
	  GET_DEV_VAR_VALUE("y[10]", y10);

	  /* Start Kennlinienbertragung */
	  DELAY(2,"Transmission of values. Please wait..."
              "|de|Werte werden bertragen. Bitte warten...");

      iassign(start_action, 103); /* Start KL-bertragung */
	  send_command(145);

      /* Werte bertragen */
	  for( param_nr=24; param_nr<46; param_nr++ )
	  {
	    iassign(static_param_code, param_nr);
	    send_command(129); /* float-Wert schreiben */
	  }

      iassign(start_action, 104); /* Ende KL-bertragung */
	  send_command(145);

      DELAY(3,"Transmission of values completed."
              "|de|Kennlinienwerte wurden bertragen.");

      get_more_status(status, dev_status);  /* CMD 48 */

      /* dev_status[15] = device_family_status_1 */
      if (dev_status[15] & 0x10) /* Kennlinie fehlerhaft */
      {
	  	ACKNOWLEDGE("User defined characteristic is not valid."
	  		        "|de|Benutzerdef. Kennlinie ist ungltig." );
      }
    }

  #ifdef HELP_DE_EN
    HELP "Coordinates for user-defined control valve characteristic. x[n] = "
         "reference variable in % of the respective range. y[n] = travel / opening "
         "angle in % of the respective range."
         "|de|Sttzwerte fr benutzerdefinierte Zuordnung zwischen "
         "Fhrungsgre und Hub / Drehwinkel. x[n] = Fhrungsgre in % "
         "des Fhrungsgren - Bereichs. y[n] = Hub- / Drehwinkel in % des "
         "Hub / Drehwinkelbereichs.";
  #else
    HELP "Coordinates for user-defined control valve characteristic. x[n] = "
         "reference variable in % of the respective range. y[n] = travel / opening "
         "angle in % of the respective range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Test Stellungsmelder                                                     */
/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* Parameter: Stellungsmelder Test         Doku-Nummer: 38    EB-Code: 31   */
/* ------------------------------------------------------------------------ */
METHOD met_test_stellmelder
{
  #ifdef LABEL_DE_EN
  LABEL "Position transmitter test" "|de|Stellungsmelder Test";
  #else
  LABEL "Position transmitter test";
  #endif

  DEFINITION
  {
      int  wrProt;  /* Speicher fuer Schreibschutztest */
      int  sm;      /* Stellungsmelder vorhanden ? */

	  XMTR_IGNORE_ALL_COMM_STATUS();
	  XMTR_IGNORE_ALL_DEVICE_STATUS();
	  XMTR_IGNORE_ALL_RESPONSE_CODES();
	  XMTR_IGNORE_COMM_ERROR();

	  IGNORE_ALL_COMM_STATUS();
	  IGNORE_ALL_DEVICE_STATUS();
	  IGNORE_ALL_RESPONSE_CODES();
	  IGNORE_COMM_ERROR();

      XMTR_RETRY_ON_NO_DEVICE();
      RETRY_ON_NO_DEVICE();

      CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

      /* Schauen ob Stellungsmelder installiert ist: */
	  iassign(static_enums_code1, 73);
      send_command(130); /* Stellungsmelder auslesen */
      sm = ivar_value (stellungsmelder);
      if (sm == 0)
      {   /* Stellungsmelder nicht vorhanden */
          ACKNOWLEDGE("Position transmitter is not implemented."
                      "|de|Stellungsmelder ist nicht vorhanden.");
          process_abort();  /* Methode beenden */
      }

      /* Wert vom Anwender holen: */
      GET_DEV_VAR_VALUE("Enter a test value:"
                        "|de|Vorgabe eines Testwertes:", test_stellmelder);

      ACKNOWLEDGE("Execute position transmitter test ?"
                  "|de|Test Stellungsmelder ausfhren ?");
	  iassign(static_param_code, 51);	/* Wert schreiben */
	  send_command(129);

      DELAY(3,"Test is running" "|de|Test luft");
  }

  #ifdef HELP_DE_EN
  HELP "Testing the position transmitter. Values can be entered in relation "
       "to the working range."
       "|de|Test des Stellungsmelders. Werte knnen, bezogen auf den "
       "Arbeitsbereich, eingegeben werden.";
  #else
  HELP "Testing the position transmitter. Values can be entered in relation "
       "to the working range.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Gewnschte Betriebsart schreiben                                         */
/* ------------------------------------------------------------------------ */
METHOD write_target_mode
{
  #ifdef LABEL_DE_EN
    LABEL "Target mode" "|de|Gewnschte Betriebsart";
  #else
    LABEL "Target mode";
  #endif

    DEFINITION
    {
        long ids[2]; /* fr akt. Betriebsart */
        int  wrProt; /* Speicher fuer Schreibschutztest */
        int  target_mode_tmp; /* gew. Betriebsart */
        int  diagnose_level;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION  /* auf Schreibschutz testen */

        /* Aktuelle Betriebsart einlesen: */
	    iassign(static_enums_code1, 86);
        send_command(130); /* akt. Betriebsart auslesen */
        ids[0] = VARID(akt_betriebsart);

        /* Abfrage mit Anzeige der akt. Betriebsart im Text: */

        /* Wenn PST Regler */
        send_command_trans(171,1); /* Diagnose Level auslesen */
        diagnose_level = ivar_value (diag_level);
        if ( diagnose_level == DIAG_LEVEL_PST )
        {
              target_mode_tmp = select_from_list(
              "Actual mode: %{0}. Please select target mode:"
              "|de|Akt. Betriebsart: %{0}. Gewnschte Betriebsart whlen:", ids,
              "Automatic;"
              "Manual;"
              "Fail-safe position;"
              "PST"
              "|de|Automatik;"
              "Hand;"
              "Sicherheitsstellung;"
              "PST" );
        }
        else
        {
              target_mode_tmp = select_from_list(
              "Actual mode: %{0}. Please select target mode:"
              "|de|Akt. Betriebsart: %{0}. Gewnschte Betriebsart whlen:", ids,
              "Automatic;"
              "Manual;"
              "Fail-safe position"
              "|de|Automatik;"
              "Hand;"
              "Sicherheitsstellung" );
        }


        if (target_mode_tmp == 0)
        {
            /* Betriebsart Automatik schreiben */
            iassign(gew_betriebsart, 0);
            iassign(static_enums_code, 61);
            send_command(131);
            DELAY(2,"Writing target mode ..." "|de|Schreibe Betriebsart ...");
        }
        else if (target_mode_tmp == 1)
        {
            /* Betriebsart Hand schreiben */
            iassign(gew_betriebsart, 32);
            iassign(static_enums_code, 61);
            send_command(131);
            DELAY(2,"Writing target mode ..." "|de|Schreibe Betriebsart ...");
        }
        else if (target_mode_tmp == 2)
        {
            /* Betriebsart Sicherheitsstellung schreiben */
            iassign(gew_betriebsart, 16);
            iassign(static_enums_code, 61);
            send_command(131);
            DELAY(2, "Writing target mode ..." "|de|Schreibe Betriebsart ...");
        }
        else if (target_mode_tmp == 3)
        {
            /* Betriebsart PST schreiben:
               1. Betriebsart HAND schreiben
               2. PST Modus auf EIN stellen */
            iassign(gew_betriebsart, 32);     /* 1. */
            iassign(static_enums_code, 61);   /* 1. */
            send_command(131);                /* 1. */
            iassign(pst_mode_on_off, 1);      /* 2. */
            send_command_trans(170,309);      /* 2. */
            DELAY(2, "Writing target mode ..." "|de|Schreibe Betriebsart ...");
        }
    }

  #ifdef HELP_DE_EN
    HELP "Writing the Target Mode." "|de|Schreiben der gewnschten Betriebsart.";
  #else
    HELP "Writing the Target Mode.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Handsollwert schreiben                                                   */
/* ------------------------------------------------------------------------ */
METHOD write_w_manual
{
  #ifdef LABEL_DE_EN
    LABEL "Manual reference variable w" "|de|Hand Fhrungsgre w";
  #else
    LABEL "Manual reference variable w";
  #endif

    DEFINITION
    {
        int    wrProt;     /* Speicher fuer Schreibschutztest */
        int    akt_BA;     /* aktuelle Betriebsart */
        float  w_hand_tmp; /* w Hand Wert */

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        CHECK_WRITE_PROTECTION  /* auf Schreibschutz testen */

        /* nur in Hand w_hand schreiben */
	    iassign(static_enums_code1, 86);
        send_command(130); /* akt. Betriebsart auslesen */
        akt_BA = ivar_value (akt_betriebsart);

        if ((akt_BA == 4) || (akt_BA == 5) || (akt_BA == 6))
        { /* Hand ist aktiv */
          /* Wert vom Anwender holen: */
          GET_DEV_VAR_VALUE("Please enter a value for manual reference variable w:"
                            "|de|Bitte Wert fr Hand Fhrungsgre w eingeben:", w_hand);
          iassign(static_param_code, 9);	/* Handsollwert schreiben */
          send_command(129);
          DELAY(2, "Writing manual reference variable w ..."
                   "|de|Schreibe Hand Fhrungsgre w ...");
        }
        else
        {
          ACKNOWLEDGE("Parameter is only writable in actual mode 'Manual' !"
                      "|de|Der Parameter ist nur in der Betriebsart 'Hand' schreibbar !");
        }
    }

  #ifdef HELP_DE_EN
    HELP "Writing of manual reference variable w in actual mode 'Manual'."
         "|de|Schreiben der Hand Fhrungsgre w in Betriebsart 'Hand'.";
  #else
    HELP "Writing of manual reference variable w in actual mode 'Manual'.";
  #endif
}

/* ------------------------------------------------------------------------ */
/* Zeit im ms statt s, daher beim Lesen *100 (fuer long (4 byte))           */
/* ------------------------------------------------------------------------ */
METHOD convert_mal_100_long
{
    LABEL "Convert";
    DEFINITION
    {
        long temp1;

		temp1 = lgetval() * 100;
		lsetval(temp1);
    }
}

/*****************************************************************************/

/* fr Aufruf von Manual 3730-3: */
METHOD methodOpenDeviceManual_3730
{
    LABEL "SAMSON 3730-3 Mounting and operating instructions"
          "|de|SAMSON 3730-3 Einbau- und Bedienungsanleitung";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3730);
	}
    HELP "Mounting and operating instructions of the positioner 3730-3 (EB 8384-3)."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3730-3 (EB 8384-3).";
}
/*****************************************************************************/

/* fr Aufruf von Manual 3730-3 PST: */
METHOD methodOpenDeviceManual_3730_PST
{
    LABEL "SAMSON 3730-3 PST Mounting and operating instructions"
          "|de|SAMSON 3730-3 PST Einbau- und Bedienungsanleitung";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3730_PST);
	}
    HELP "Mounting and operating instructions of the positioner 3730-3 "
         "with PST (Partial Stroke Test) (EB 8388-1)."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3730-3 "
         "mit PST (Partial Stroke Test) (EB 8388-1).";
}
/*****************************************************************************/

/* fr Aufruf von Manual 3731-3: */
METHOD methodOpenDeviceManual_3731
{
    LABEL "SAMSON 3731-3 Mounting and operating instructions"
          "|de|SAMSON 3731-3 Einbau- und Bedienungsanleitung";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3731);
	}
    HELP "Mounting and operating instructions of the positioner 3731-3 (EB 8387-3)."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3731-3 (EB 8387-3).";
}

/*****************************************************************************/
/* fr Aufruf von Ventildiagnose EXPERT+: */
METHOD methodOpenValveDiagnostics
{
    LABEL "SAMSON EXPERT+ Valve Diagnostics" "|049SAMSON EXPERT+ Ventildiagnose";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(VALVE_DIAGNOSTICS_FILENAME);
	}
    HELP "EXPERT+ Valve Diagnostics of the positioner series 373X-3 (EB 8388)."
         "|de|EXPERT+ Ventildiagnose der Stellungsregler Serie 373X-3 (EB 8388).";
}
/*****************************************************************************/


/*****************************************************************************/
/* fr Warnmeldung vor Ausfhrung eines Tests: */
METHOD WARNING_BEFORE_TEST
{
    LABEL "Warning" "|de|Warnung";
	ACCESS OFFLINE;
	DEFINITION
	{
       ACKNOWLEDGE("Warning: During test start the control valve departs from its "
                   "current position at full travel !"
                   "|de|Warnung: Bei diesem Test kann das Stellventil den "
                   "gesamten Hubbereich durchfahren !");
	}
}
/*****************************************************************************/

/* ------------------------------------------------------------------------ */
/* Einlesen Sprungantwort Daten mit schnellen Sammelkommandos               */
/* ------------------------------------------------------------------------ */
METHOD read_step_response_data
{
	LABEL   "Load 'step response' graph data" "|de|Lade 'Sprungantwort' Grafik - Daten";

    DEFINITION
    {
        float          f_read_local;
        unsigned long  ul_read_local;
        unsigned int   ui_read_local;

        DELAY(2,"reading data... (Progress: 0 percent)" "|de|Daten werden gelesen... (Fortschritt: 0 Prozent)");

	    /* Senden der 5 Indices: */
	    iassign(cmd_index_1, 1000);    /* Index 1 */
	    iassign(cmd_index_2, 1100);    /* Index 2 */
	    iassign(cmd_index_3,  400);    /* Index 3 */
	    iassign(cmd_index_4,  300);    /* Index 4 */
	    iassign(cmd_index_5,  300);    /* Index 5 */
		send_command_trans(152,3);

        /* Einlesen der 5 x 100 Werte: */
		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_0 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_0 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_0  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_0  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_0 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_1 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_1 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_1  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_1  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_1 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_2 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_2 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_2  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_2  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_2 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_3 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_3 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_3  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_3  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_3 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_4 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_4 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_4  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_4  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_4 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_5 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_5 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_5  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_5  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_5 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_6 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_6 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_6  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_6  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_6 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_7 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_7 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_7  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_7  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_7 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_8 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_8 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_8  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_8  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_8 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_9 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_9 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_9  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_9  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_9 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_10 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_10 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_10  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_10  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_10 , ui_read_local);

        DELAY(1,"reading data... (Progress: 10 percent)" "|de|Daten werden gelesen... (Fortschritt: 10 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_11, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_11, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_11 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_11 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_11, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_12, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_12, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_12 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_12 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_12, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_13, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_13, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_13 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_13 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_13, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_14, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_14, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_14 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_14 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_14, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_15, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_15, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_15 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_15 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_15, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_16, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_16, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_16 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_16 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_16, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_17, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_17, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_17 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_17 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_17, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_18, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_18, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_18 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_18 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_18, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_19, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_19, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_19 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_19 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_19, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_20, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_20, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_20 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_20 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_20, ui_read_local);

        DELAY(1,"reading data... (Progress: 20 percent)" "|de|Daten werden gelesen... (Fortschritt: 20 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_21, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_21, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_21 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_21 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_21, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_22, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_22, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_22 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_22 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_22, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_23, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_23, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_23 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_23 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_23, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_24, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_24, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_24 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_24 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_24, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_25, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_25, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_25 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_25 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_25, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_26, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_26, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_26 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_26 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_26, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_27, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_27, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_27 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_27 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_27, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_28, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_28, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_28 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_28 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_28, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_29, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_29, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_29 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_29 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_29, ui_read_local);

        DELAY(1,"reading data... (Progress: 30 percent)" "|de|Daten werden gelesen... (Fortschritt: 30 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_30 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_30 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_30  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_30  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_30 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_31, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_31, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_31 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_31 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_31, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_32, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_32, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_32 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_32 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_32, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_33, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_33, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_33 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_33 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_33, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_34, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_34, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_34 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_34 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_34, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_35, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_35, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_35 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_35 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_35, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_36, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_36, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_36 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_36 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_36, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_37, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_37, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_37 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_37 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_37, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_38, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_38, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_38 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_38 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_38, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_39, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_39, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_39 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_39 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_39, ui_read_local);

        DELAY(1,"reading data... (Progress: 40 percent)" "|de|Daten werden gelesen... (Fortschritt: 40 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_40 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_40 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_40  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_40  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_40 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_41, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_41, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_41 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_41 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_41, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_42, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_42, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_42 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_42 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_42, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_43, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_43, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_43 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_43 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_43, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_44, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_44, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_44 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_44 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_44, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_45, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_45, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_45 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_45 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_45, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_46, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_46, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_46 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_46 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_46, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_47, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_47, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_47 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_47 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_47, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_48, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_48, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_48 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_48 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_48, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_49, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_49, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_49 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_49 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_49, ui_read_local);

        DELAY(1,"reading data... (Progress: 50 percent)" "|de|Daten werden gelesen... (Fortschritt: 50 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_50 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_50 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_50  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_50  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_50 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_51, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_51, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_51 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_51 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_51, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_52, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_52, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_52 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_52 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_52, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_53, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_53, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_53 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_53 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_53, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_54, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_54, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_54 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_54 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_54, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_55, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_55, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_55 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_55 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_55, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_56, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_56, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_56 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_56 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_56, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_57, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_57, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_57 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_57 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_57, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_58, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_58, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_58 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_58 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_58, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_59, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_59, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_59 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_59 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_59, ui_read_local);

        DELAY(1,"reading data... (Progress: 60 percent)" "|de|Daten werden gelesen... (Fortschritt: 60 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_60 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_60 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_60  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_60  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_60 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_61, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_61, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_61 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_61 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_61, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_62, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_62, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_62 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_62 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_62, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_63, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_63, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_63 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_63 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_63, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_64, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_64, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_64 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_64 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_64, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_65, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_65, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_65 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_65 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_65, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_66, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_66, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_66 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_66 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_66, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_67, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_67, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_67 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_67 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_67, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_68, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_68, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_68 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_68 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_68, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_69, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_69, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_69 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_69 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_69, ui_read_local);

        DELAY(1,"reading data... (Progress: 70 percent)" "|de|Daten werden gelesen... (Fortschritt: 70 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_70 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_70 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_70  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_70  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_70 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_71, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_71, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_71 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_71 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_71, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_72, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_72, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_72 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_72 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_72, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_73, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_73, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_73 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_73 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_73, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_74, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_74, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_74 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_74 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_74, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_75, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_75, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_75 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_75 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_75, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_76, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_76, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_76 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_76 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_76, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_77, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_77, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_77 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_77 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_77, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_78, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_78, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_78 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_78 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_78, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_79, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_79, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_79 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_79 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_79, ui_read_local);

        DELAY(1,"reading data... (Progress: 80 percent)" "|de|Daten werden gelesen... (Fortschritt: 80 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_80 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_80 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_80  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_80  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_80 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_81, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_81, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_81 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_81 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_81, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_82, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_82, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_82 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_82 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_82, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_83, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_83, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_83 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_83 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_83, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_84, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_84, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_84 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_84 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_84, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_85, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_85, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_85 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_85 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_85, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_86, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_86, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_86 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_86 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_86, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_87, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_87, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_87 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_87 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_87, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_88, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_88, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_88 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_88 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_88, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_89, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_89, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_89 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_89 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_89, ui_read_local);

        DELAY(1,"reading data... (Progress: 90 percent)" "|de|Daten werden gelesen... (Fortschritt: 90 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_90 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_90 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_90  , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_90  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_90 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_91, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_91, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_91 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_91 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_91, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_92, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_92, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_92 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_92 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_92, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_93, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_93, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_93 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_93 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_93, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_94, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_94, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_94 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_94 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_94, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_95, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_95, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_95 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_95 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_95, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_96, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_96, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_96 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_96 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_96, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_97, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_97, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_97 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_97 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_97, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_98, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_98, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_98 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_98 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_98, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(sprung_vs_99, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(sprung_sw_99, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(sprung_e_99 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(sprung_t_99 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(sprung_ss_99, ui_read_local);

        /* damit Daten ausserhalb der Methode gueltig */
        save_values();

        DELAY(2,"Data were read." "|de|Daten wurden eingelesen.");
    }

    HELP     "Load data for this graph."
             "|de|Laden der Daten fr diesen Graph.";
}

/* ------------------------------------------------------------------------ */
/* Berechnung des Parameters pst_rec_scan_rate                              */
/* ------------------------------------------------------------------------ */
METHOD calculate_pst_rec_scan_rate
{
    LABEL "";
    DEFINITION
    {
        unsigned long temp; /* long, da sonst nicht ausreichend */
        int diagnose_level;

		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

		temp = igetval();  /* in 1/10s */
		temp = temp * 100; /* damit keine Kommastellen notwendig */

		temp = (temp * 103) / 10000;
		/* 1.0 addieren, da nachher alle 'Nachkommastellen' verworfen statt gerundet werden ! */
		temp = temp + 100;

		temp = temp / 100; /* wieder in richtiger Einheit (1/10s) */

		/* Grenzen: 0,2...30s */
		if( temp < 2 )
		  temp = 2;
		else if( temp > 300 )
		  temp = 300;

        /* Wenn PST Regler (Abhaengigkeit, da POST_READ_ACTIONS von duration_of_test
                            nicht anhaengig gemacht werden kann) */
        send_command_trans(171,1); /* Diagnose Level auslesen */
        diagnose_level = ivar_value (diag_level);
        if ( diagnose_level == DIAG_LEVEL_PST )
        {
          iassign(pst_rec_scan_rate, temp);
        }
    }
}

/* ------------------------------------------------------------------------ */
VARIABLE cmd_index_1
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ&WRITE;
}
VARIABLE cmd_index_2
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ&WRITE;
}
VARIABLE cmd_index_3
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ&WRITE;
}
VARIABLE cmd_index_4
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ&WRITE;
}
VARIABLE cmd_index_5
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ&WRITE;
}
VARIABLE cmd_index_6
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ&WRITE;
}

VARIABLE f_read_1
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     FLOAT;
  HANDLING READ;
}
VARIABLE f_read_2
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     FLOAT;
  HANDLING READ;
}
VARIABLE f_read_3
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     FLOAT;
  HANDLING READ;
}
VARIABLE f_read_4
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     FLOAT;
  HANDLING READ;
}
VARIABLE f_read_5
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     FLOAT;
  HANDLING READ;
}
VARIABLE f_read_6
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     FLOAT;
  HANDLING READ;
}
VARIABLE l_read_1
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (4);
  HANDLING READ;
}
VARIABLE i_read_1
{
  LABEL    "index";
  CLASS    USER_INTERFACE;
  TYPE     UNSIGNED_INTEGER (2);
  HANDLING READ;
}




/****************************************/
/* Diagnose */
/****************************************/

MENU Page_diagnosis_1
{
    LABEL "Diagnosis" "|de|Diagnose";
/*    STYLE WINDOW;*/
    ITEMS
	{
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      start_abort_reference_test,
      diag_reference_info,
      diag_level,
      akt_betriebsart
    }
}

MENU Page_diagnosis_2
{
    LABEL "Statistical information AUTO" "|de|Beobachterfunktionen AUTO";
/*    STYLE WINDOW;*/
    ITEMS
	{
      OnlineDialog_AUTO_data_logger,
      OnlineDialog_AUTO_travel_hist_x,
      OnlineDialog_AUTO_deviation_hist_e,
      OnlineDialog_AUTO_cycle_counter_hist,
      OnlineDialog_AUTO_drive_signal_diagram,
      OnlineDialog_AUTO_trend_travel_end_pos
    }
}

MENU Page_diagnosis_3
{
    LABEL "Tests MAN" "|de|Testfunktionen HAND";
/*    STYLE WINDOW;*/
    ITEMS
	{
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      start_abort_tests_in_turn,       /* Alle Tests starten */
      automatical_test_status,
      transmit_button,
      SEPARATOR,
      OnlineDialog_MAN_drive_signal_diagram_steady,
      OnlineDialog_MAN_drive_signal_diagram_hys,
      OnlineDialog_MAN_static_char,

      /* nicht bei PST Regler */
      IF (( diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS )    )
      {
         OnlineDialog_MAN_y_step_response
      }
    }
}


/****************************************/
/* Diagnose - Beobachterfunktionen AUTO */
/****************************************/

/*----------------- Datalogger -----------------*/

MENU Page_data_logger_1
{
    LABEL "Data logger" "|de|Datenlogger";
/*    STYLE WINDOW;*/
    ITEMS
	{
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      datalogger_select,
      trigger_select,
      sample_rate,
      start_value,
      logging_limit,
      pretrigger_time,
      magnetventil,
      max_pretrigger_time,
      transmit_button
  }
}

MENU Page_data_logger_2
{
    LABEL "Data logger measurement" "|de|Datenlogger Messung";
    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
          graph14,
          /* Manuelles Einlesen der Daten: */
          method_LOAD_datalogger,
#endif
          /* Wenn PST Regler */
          IF ( diag_level == DIAG_LEVEL_PST )
          {
            input_pst_enabling_code,
          }
          start_abort_data_logger,
          datalogger_progress,
		  transmit_button
    }
}


METHOD method_LOAD_datalogger
{
	LABEL   "Load 'data logger' graph data" "|de|Lade 'Datenlogger' Grafik - Daten";
    DEFINITION
    {
        float          f_read_local;
        unsigned long  ul_read_local;
        unsigned int   ui_read_local;

        DELAY(2,"reading data... (Progress: 0 percent)" "|de|Daten werden gelesen... (Fortschritt: 0 Prozent)");

        /*
        datalogger_t_0..99 (unsigned long 200...299)
        datalogger_vs_0..99 (float 900...999)
        datalogger_sw_0..99 (float 700...799)
        datalogger_e_0..99 (float 800...899)
        datalogger_ss_0..99 (unsigned int 400...499) */

	    /* Senden der 5 Indices: */
	    iassign(cmd_index_1, 900);    /* Index 1 */
	    iassign(cmd_index_2, 800);    /* Index 2 */
	    iassign(cmd_index_3, 700);    /* Index 3 */
	    iassign(cmd_index_4, 200);    /* Index 4 */
	    iassign(cmd_index_5, 400);    /* Index 5 */
		send_command_trans(152,3);

        /* Einlesen der 5 X 100 Werte: */
		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_0 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_0  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_0 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_0  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_0 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_1 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_1  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_1 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_1  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_1 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_2 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_2  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_2 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_2  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_2 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_3 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_3  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_3 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_3  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_3 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_4 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_4  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_4 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_4  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_4 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_5 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_5  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_5 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_5  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_5 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_6 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_6  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_6 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_6  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_6 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_7 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_7  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_7 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_7  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_7 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_8 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_8  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_8 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_8  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_8 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_9 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_9  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_9 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_9  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_9 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_10 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_10  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_10 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_10  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_10 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_11 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_11  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_11 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_11  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_11 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_12 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_12  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_12 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_12 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_12 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_13 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_13  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_13 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_13  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_13 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_14 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_14  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_14 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_14  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_14 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_15 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_15  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_15 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_15  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_15 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_16 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_16  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_16 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_16  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_16 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_17 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_17  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_17 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_17  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_17 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_18 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_18  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_18 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_18  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_18 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_19 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_19  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_19 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_19  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_19 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_20, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_20 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_20, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_20 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_20, ui_read_local);

        DELAY(1,"reading data... (Progress: 20 percent)" "|de|Daten werden gelesen... (Fortschritt: 20 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_21 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_21  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_21 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_21  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_21 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_22, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_22 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_22, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_22 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_22, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_23, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_23 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_23, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_23 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_23, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_24, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_24 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_24, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_24 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_24, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_25, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_25 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_25, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_25 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_25, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_26, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_26 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_26, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_26 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_26, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_27, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_27 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_27, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_27 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_27, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_28, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_28 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_28, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_28 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_28, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_29, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_29 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_29, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_29 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_29, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_30, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_30 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_30, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_30 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_30, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_31 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_31  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_31 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_31  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_31 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_32, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_32 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_32, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_32 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_32, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_33, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_33 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_33, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_33 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_33, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_34, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_34 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_34, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_34 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_34, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_35, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_35 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_35, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_35 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_35, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_36, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_36 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_36, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_36 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_36, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_37, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_37 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_37, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_37 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_37, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_38, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_38 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_38, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_38 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_38, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_39, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_39 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_39, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_39 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_39, ui_read_local);

        DELAY(1,"reading data... (Progress: 40 percent)" "|de|Daten werden gelesen... (Fortschritt: 40 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_40, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_40 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_40, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_40 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_40, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_41 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_41  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_41 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_41  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_41 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_42, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_42 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_42, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_42 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_42, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_43, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_43 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_43, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_43 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_43, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_44, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_44 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_44, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_44 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_44, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_45, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_45 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_45, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_45 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_45, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_46, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_46 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_46, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_46 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_46, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_47, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_47 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_47, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_47 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_47, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_48, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_48 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_48, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_48 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_48, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_49, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_49 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_49, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_49 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_49, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_50, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_50 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_50, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_50 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_50, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_51 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_51  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_51 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_51  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_51 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_52, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_52 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_52, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_52 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_52, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_53, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_53 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_53, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_53 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_53, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_54, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_54 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_54, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_54 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_54, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_55, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_55 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_55, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_55 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_55, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_56, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_56 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_56, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_56 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_56, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_57, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_57 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_57, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_57 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_57, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_58, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_58 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_58, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_58 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_58, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_59, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_59 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_59, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_59 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_59, ui_read_local);

        DELAY(1,"reading data... (Progress: 60 percent)" "|de|Daten werden gelesen... (Fortschritt: 60 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_60, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_60 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_60, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_60 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_60, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_61 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_61  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_61 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_61  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_61 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_62, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_62 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_62, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_62 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_62, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_63, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_63 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_63, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_63 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_63, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_64, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_64 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_64, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_64 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_64, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_65, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_65 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_65, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_65 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_65, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_66, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_66 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_66, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_66 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_66, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_67, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_67 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_67, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_67 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_67, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_68, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_68 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_68, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_68 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_68, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_69, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_69 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_69, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_69 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_69, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_70, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_70 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_70, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_70 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_70, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_71 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_71  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_71 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_71  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_71 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_72, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_72 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_72, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_72 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_72, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_73, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_73 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_73, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_73 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_73, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_74, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_74 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_74, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_74 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_74, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_75, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_75 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_75, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_75 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_75, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_76, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_76 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_76, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_76 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_76, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_77, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_77 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_77, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_77 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_77, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_78, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_78 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_78, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_78 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_78, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_79, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_79 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_79, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_79 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_79, ui_read_local);

        DELAY(1,"reading data... (Progress: 80 percent)" "|de|Daten werden gelesen... (Fortschritt: 80 Prozent)");

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_80, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_80 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_80, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_80 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_80, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_81 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_81  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_81 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_81  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_81 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_82, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_82 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_82, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_82 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_82, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_83, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_83 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_83, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_83 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_83, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_84, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_84 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_84, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_84 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_84, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_85, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_85 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_85, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_85 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_85, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_86, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_86 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_86, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_86 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_86, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_87, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_87 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_87, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_87 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_87, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_88, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_88 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_88, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_88 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_88, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_89, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_89 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_89, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_89 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_89, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_90, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_90 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_90, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_90 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_90, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_91 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_91  , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_91 , f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_91  , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_91 , ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_92, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_92 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_92, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_92 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_92, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_93, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_93 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_93, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_93 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_93, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_94, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_94 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_94, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_94 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_94, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_95, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_95 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_95, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_95 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_95, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_96, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_96 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_96, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_96 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_96, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_97, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_97 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_97, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_97 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_97, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_98, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_98 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_98, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_98 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_98, ui_read_local);

		send_command_trans(156,3);
        f_read_local = fvar_value(f_read_1);
        fassign(datalogger_vs_99, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(datalogger_e_99 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(datalogger_sw_99, f_read_local);
        ul_read_local = lvar_value(l_read_1);
        lassign(datalogger_t_99 , ul_read_local);
        ui_read_local = ivar_value(i_read_1);
        iassign(datalogger_ss_99, ui_read_local);

        /* damit Daten ausserhalb der Methode gueltig */
        save_values();

        DELAY(2,"Data were read." "|de|Daten wurden eingelesen.");
    }

    HELP     "Load data for this graph."
             "|de|Laden der Daten fr diesen Graph.";
}


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph14
{
    LABEL "Data logger" "|de|Datenlogger";
	HEIGHT X_LARGE;
	WIDTH  X_LARGE;
	X_AXIS xaxis18;
	MEMBERS
	{
		WAVEFORM24, waveform24;
		WAVEFORM25, waveform25;
		WAVEFORM26, waveform26;
		WAVEFORM27, waveform27;
	}
}

AXIS xaxis18
{
	LABEL "Time t" "|de|Zeit t";
	MIN_VALUE   0;
	MAX_VALUE 360000;
	CONSTANT_UNIT "1/10 s";
}


WAVEFORM waveform24
{
	Y_AXIS yaxis19;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			datalogger_t_0,
            datalogger_t_1,
            datalogger_t_2,
            datalogger_t_3,
            datalogger_t_4,
            datalogger_t_5,
            datalogger_t_6,
            datalogger_t_7,
            datalogger_t_8,
            datalogger_t_9,
            datalogger_t_10,
            datalogger_t_11,
            datalogger_t_12,
            datalogger_t_13,
            datalogger_t_14,
            datalogger_t_15,
            datalogger_t_16,
            datalogger_t_17,
            datalogger_t_18,
            datalogger_t_19,
            datalogger_t_20,
            datalogger_t_21,
            datalogger_t_22,
            datalogger_t_23,
            datalogger_t_24,
            datalogger_t_25,
            datalogger_t_26,
            datalogger_t_27,
            datalogger_t_28,
            datalogger_t_29,
            datalogger_t_30,
            datalogger_t_31,
            datalogger_t_32,
            datalogger_t_33,
            datalogger_t_34,
            datalogger_t_35,
            datalogger_t_36,
            datalogger_t_37,
            datalogger_t_38,
            datalogger_t_39,
            datalogger_t_40,
            datalogger_t_41,
            datalogger_t_42,
            datalogger_t_43,
            datalogger_t_44,
            datalogger_t_45,
            datalogger_t_46,
            datalogger_t_47,
            datalogger_t_48,
            datalogger_t_49,
            datalogger_t_50,
            datalogger_t_51,
            datalogger_t_52,
            datalogger_t_53,
            datalogger_t_54,
            datalogger_t_55,
            datalogger_t_56,
            datalogger_t_57,
            datalogger_t_58,
            datalogger_t_59,
            datalogger_t_60,
            datalogger_t_61,
            datalogger_t_62,
            datalogger_t_63,
            datalogger_t_64,
            datalogger_t_65,
            datalogger_t_66,
            datalogger_t_67,
            datalogger_t_68,
            datalogger_t_69,
            datalogger_t_70,
            datalogger_t_71,
            datalogger_t_72,
            datalogger_t_73,
            datalogger_t_74,
            datalogger_t_75,
            datalogger_t_76,
            datalogger_t_77,
            datalogger_t_78,
            datalogger_t_79,
            datalogger_t_80,
            datalogger_t_81,
            datalogger_t_82,
            datalogger_t_83,
            datalogger_t_84,
            datalogger_t_85,
            datalogger_t_86,
            datalogger_t_87,
            datalogger_t_88,
            datalogger_t_89,
            datalogger_t_90,
            datalogger_t_91,
            datalogger_t_92,
            datalogger_t_93,
            datalogger_t_94,
            datalogger_t_95,
            datalogger_t_96,
            datalogger_t_97,
            datalogger_t_98,
            datalogger_t_99
		}
		Y_VALUES
		{
	        datalogger_vs_0,
		    datalogger_vs_1,
		    datalogger_vs_2,
		    datalogger_vs_3,
		    datalogger_vs_4,
		    datalogger_vs_5,
		    datalogger_vs_6,
		    datalogger_vs_7,
		    datalogger_vs_8,
		    datalogger_vs_9,
		    datalogger_vs_10,
		    datalogger_vs_11,
		    datalogger_vs_12,
		    datalogger_vs_13,
		    datalogger_vs_14,
		    datalogger_vs_15,
		    datalogger_vs_16,
		    datalogger_vs_17,
		    datalogger_vs_18,
		    datalogger_vs_19,
		    datalogger_vs_20,
		    datalogger_vs_21,
		    datalogger_vs_22,
		    datalogger_vs_23,
		    datalogger_vs_24,
		    datalogger_vs_25,
		    datalogger_vs_26,
		    datalogger_vs_27,
		    datalogger_vs_28,
		    datalogger_vs_29,
		    datalogger_vs_30,
		    datalogger_vs_31,
		    datalogger_vs_32,
		    datalogger_vs_33,
		    datalogger_vs_34,
		    datalogger_vs_35,
		    datalogger_vs_36,
		    datalogger_vs_37,
		    datalogger_vs_38,
		    datalogger_vs_39,
		    datalogger_vs_40,
		    datalogger_vs_41,
		    datalogger_vs_42,
		    datalogger_vs_43,
		    datalogger_vs_44,
		    datalogger_vs_45,
		    datalogger_vs_46,
		    datalogger_vs_47,
		    datalogger_vs_48,
		    datalogger_vs_49,
		    datalogger_vs_50,
		    datalogger_vs_51,
		    datalogger_vs_52,
		    datalogger_vs_53,
		    datalogger_vs_54,
		    datalogger_vs_55,
		    datalogger_vs_56,
		    datalogger_vs_57,
		    datalogger_vs_58,
		    datalogger_vs_59,
		    datalogger_vs_60,
		    datalogger_vs_61,
		    datalogger_vs_62,
		    datalogger_vs_63,
		    datalogger_vs_64,
		    datalogger_vs_65,
		    datalogger_vs_66,
		    datalogger_vs_67,
		    datalogger_vs_68,
		    datalogger_vs_69,
		    datalogger_vs_70,
		    datalogger_vs_71,
		    datalogger_vs_72,
		    datalogger_vs_73,
		    datalogger_vs_74,
		    datalogger_vs_75,
		    datalogger_vs_76,
		    datalogger_vs_77,
		    datalogger_vs_78,
		    datalogger_vs_79,
		    datalogger_vs_80,
		    datalogger_vs_81,
		    datalogger_vs_82,
		    datalogger_vs_83,
		    datalogger_vs_84,
		    datalogger_vs_85,
		    datalogger_vs_86,
		    datalogger_vs_87,
		    datalogger_vs_88,
		    datalogger_vs_89,
		    datalogger_vs_90,
		    datalogger_vs_91,
		    datalogger_vs_92,
		    datalogger_vs_93,
		    datalogger_vs_94,
		    datalogger_vs_95,
		    datalogger_vs_96,
		    datalogger_vs_97,
		    datalogger_vs_98,
		    datalogger_vs_99
	  }
  }
}


WAVEFORM waveform25
{
	Y_AXIS yaxis20;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			datalogger_t_0,
            datalogger_t_1,
            datalogger_t_2,
            datalogger_t_3,
            datalogger_t_4,
            datalogger_t_5,
            datalogger_t_6,
            datalogger_t_7,
            datalogger_t_8,
            datalogger_t_9,
            datalogger_t_10,
            datalogger_t_11,
            datalogger_t_12,
            datalogger_t_13,
            datalogger_t_14,
            datalogger_t_15,
            datalogger_t_16,
            datalogger_t_17,
            datalogger_t_18,
            datalogger_t_19,
            datalogger_t_20,
            datalogger_t_21,
            datalogger_t_22,
            datalogger_t_23,
            datalogger_t_24,
            datalogger_t_25,
            datalogger_t_26,
            datalogger_t_27,
            datalogger_t_28,
            datalogger_t_29,
            datalogger_t_30,
            datalogger_t_31,
            datalogger_t_32,
            datalogger_t_33,
            datalogger_t_34,
            datalogger_t_35,
            datalogger_t_36,
            datalogger_t_37,
            datalogger_t_38,
            datalogger_t_39,
            datalogger_t_40,
            datalogger_t_41,
            datalogger_t_42,
            datalogger_t_43,
            datalogger_t_44,
            datalogger_t_45,
            datalogger_t_46,
            datalogger_t_47,
            datalogger_t_48,
            datalogger_t_49,
            datalogger_t_50,
            datalogger_t_51,
            datalogger_t_52,
            datalogger_t_53,
            datalogger_t_54,
            datalogger_t_55,
            datalogger_t_56,
            datalogger_t_57,
            datalogger_t_58,
            datalogger_t_59,
            datalogger_t_60,
            datalogger_t_61,
            datalogger_t_62,
            datalogger_t_63,
            datalogger_t_64,
            datalogger_t_65,
            datalogger_t_66,
            datalogger_t_67,
            datalogger_t_68,
            datalogger_t_69,
            datalogger_t_70,
            datalogger_t_71,
            datalogger_t_72,
            datalogger_t_73,
            datalogger_t_74,
            datalogger_t_75,
            datalogger_t_76,
            datalogger_t_77,
            datalogger_t_78,
            datalogger_t_79,
            datalogger_t_80,
            datalogger_t_81,
            datalogger_t_82,
            datalogger_t_83,
            datalogger_t_84,
            datalogger_t_85,
            datalogger_t_86,
            datalogger_t_87,
            datalogger_t_88,
            datalogger_t_89,
            datalogger_t_90,
            datalogger_t_91,
            datalogger_t_92,
            datalogger_t_93,
            datalogger_t_94,
            datalogger_t_95,
            datalogger_t_96,
            datalogger_t_97,
            datalogger_t_98,
            datalogger_t_99
		}
		Y_VALUES
		{
	        datalogger_sw_0,
		    datalogger_sw_1,
		    datalogger_sw_2,
		    datalogger_sw_3,
		    datalogger_sw_4,
		    datalogger_sw_5,
		    datalogger_sw_6,
		    datalogger_sw_7,
		    datalogger_sw_8,
		    datalogger_sw_9,
		    datalogger_sw_10,
		    datalogger_sw_11,
		    datalogger_sw_12,
		    datalogger_sw_13,
		    datalogger_sw_14,
		    datalogger_sw_15,
		    datalogger_sw_16,
		    datalogger_sw_17,
		    datalogger_sw_18,
		    datalogger_sw_19,
		    datalogger_sw_20,
		    datalogger_sw_21,
		    datalogger_sw_22,
		    datalogger_sw_23,
		    datalogger_sw_24,
		    datalogger_sw_25,
		    datalogger_sw_26,
		    datalogger_sw_27,
		    datalogger_sw_28,
		    datalogger_sw_29,
		    datalogger_sw_30,
		    datalogger_sw_31,
		    datalogger_sw_32,
		    datalogger_sw_33,
		    datalogger_sw_34,
		    datalogger_sw_35,
		    datalogger_sw_36,
		    datalogger_sw_37,
		    datalogger_sw_38,
		    datalogger_sw_39,
		    datalogger_sw_40,
		    datalogger_sw_41,
		    datalogger_sw_42,
		    datalogger_sw_43,
		    datalogger_sw_44,
		    datalogger_sw_45,
		    datalogger_sw_46,
		    datalogger_sw_47,
		    datalogger_sw_48,
		    datalogger_sw_49,
		    datalogger_sw_50,
		    datalogger_sw_51,
		    datalogger_sw_52,
		    datalogger_sw_53,
		    datalogger_sw_54,
		    datalogger_sw_55,
		    datalogger_sw_56,
		    datalogger_sw_57,
		    datalogger_sw_58,
		    datalogger_sw_59,
		    datalogger_sw_60,
		    datalogger_sw_61,
		    datalogger_sw_62,
		    datalogger_sw_63,
		    datalogger_sw_64,
		    datalogger_sw_65,
		    datalogger_sw_66,
		    datalogger_sw_67,
		    datalogger_sw_68,
		    datalogger_sw_69,
		    datalogger_sw_70,
		    datalogger_sw_71,
		    datalogger_sw_72,
		    datalogger_sw_73,
		    datalogger_sw_74,
		    datalogger_sw_75,
		    datalogger_sw_76,
		    datalogger_sw_77,
		    datalogger_sw_78,
		    datalogger_sw_79,
		    datalogger_sw_80,
		    datalogger_sw_81,
		    datalogger_sw_82,
		    datalogger_sw_83,
		    datalogger_sw_84,
		    datalogger_sw_85,
		    datalogger_sw_86,
		    datalogger_sw_87,
		    datalogger_sw_88,
		    datalogger_sw_89,
		    datalogger_sw_90,
		    datalogger_sw_91,
		    datalogger_sw_92,
		    datalogger_sw_93,
		    datalogger_sw_94,
		    datalogger_sw_95,
		    datalogger_sw_96,
		    datalogger_sw_97,
		    datalogger_sw_98,
		    datalogger_sw_99
	  }
  }
}

WAVEFORM waveform26
{
	Y_AXIS yaxis21;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			datalogger_t_0,
            datalogger_t_1,
            datalogger_t_2,
            datalogger_t_3,
            datalogger_t_4,
            datalogger_t_5,
            datalogger_t_6,
            datalogger_t_7,
            datalogger_t_8,
            datalogger_t_9,
            datalogger_t_10,
            datalogger_t_11,
            datalogger_t_12,
            datalogger_t_13,
            datalogger_t_14,
            datalogger_t_15,
            datalogger_t_16,
            datalogger_t_17,
            datalogger_t_18,
            datalogger_t_19,
            datalogger_t_20,
            datalogger_t_21,
            datalogger_t_22,
            datalogger_t_23,
            datalogger_t_24,
            datalogger_t_25,
            datalogger_t_26,
            datalogger_t_27,
            datalogger_t_28,
            datalogger_t_29,
            datalogger_t_30,
            datalogger_t_31,
            datalogger_t_32,
            datalogger_t_33,
            datalogger_t_34,
            datalogger_t_35,
            datalogger_t_36,
            datalogger_t_37,
            datalogger_t_38,
            datalogger_t_39,
            datalogger_t_40,
            datalogger_t_41,
            datalogger_t_42,
            datalogger_t_43,
            datalogger_t_44,
            datalogger_t_45,
            datalogger_t_46,
            datalogger_t_47,
            datalogger_t_48,
            datalogger_t_49,
            datalogger_t_50,
            datalogger_t_51,
            datalogger_t_52,
            datalogger_t_53,
            datalogger_t_54,
            datalogger_t_55,
            datalogger_t_56,
            datalogger_t_57,
            datalogger_t_58,
            datalogger_t_59,
            datalogger_t_60,
            datalogger_t_61,
            datalogger_t_62,
            datalogger_t_63,
            datalogger_t_64,
            datalogger_t_65,
            datalogger_t_66,
            datalogger_t_67,
            datalogger_t_68,
            datalogger_t_69,
            datalogger_t_70,
            datalogger_t_71,
            datalogger_t_72,
            datalogger_t_73,
            datalogger_t_74,
            datalogger_t_75,
            datalogger_t_76,
            datalogger_t_77,
            datalogger_t_78,
            datalogger_t_79,
            datalogger_t_80,
            datalogger_t_81,
            datalogger_t_82,
            datalogger_t_83,
            datalogger_t_84,
            datalogger_t_85,
            datalogger_t_86,
            datalogger_t_87,
            datalogger_t_88,
            datalogger_t_89,
            datalogger_t_90,
            datalogger_t_91,
            datalogger_t_92,
            datalogger_t_93,
            datalogger_t_94,
            datalogger_t_95,
            datalogger_t_96,
            datalogger_t_97,
            datalogger_t_98,
            datalogger_t_99
		}
		Y_VALUES
		{
	        datalogger_e_0,
		    datalogger_e_1,
		    datalogger_e_2,
		    datalogger_e_3,
		    datalogger_e_4,
		    datalogger_e_5,
		    datalogger_e_6,
		    datalogger_e_7,
		    datalogger_e_8,
		    datalogger_e_9,
		    datalogger_e_10,
		    datalogger_e_11,
		    datalogger_e_12,
		    datalogger_e_13,
		    datalogger_e_14,
		    datalogger_e_15,
		    datalogger_e_16,
		    datalogger_e_17,
		    datalogger_e_18,
		    datalogger_e_19,
		    datalogger_e_20,
		    datalogger_e_21,
		    datalogger_e_22,
		    datalogger_e_23,
		    datalogger_e_24,
		    datalogger_e_25,
		    datalogger_e_26,
		    datalogger_e_27,
		    datalogger_e_28,
		    datalogger_e_29,
		    datalogger_e_30,
		    datalogger_e_31,
		    datalogger_e_32,
		    datalogger_e_33,
		    datalogger_e_34,
		    datalogger_e_35,
		    datalogger_e_36,
		    datalogger_e_37,
		    datalogger_e_38,
		    datalogger_e_39,
		    datalogger_e_40,
		    datalogger_e_41,
		    datalogger_e_42,
		    datalogger_e_43,
		    datalogger_e_44,
		    datalogger_e_45,
		    datalogger_e_46,
		    datalogger_e_47,
		    datalogger_e_48,
		    datalogger_e_49,
		    datalogger_e_50,
		    datalogger_e_51,
		    datalogger_e_52,
		    datalogger_e_53,
		    datalogger_e_54,
		    datalogger_e_55,
		    datalogger_e_56,
		    datalogger_e_57,
		    datalogger_e_58,
		    datalogger_e_59,
		    datalogger_e_60,
		    datalogger_e_61,
		    datalogger_e_62,
		    datalogger_e_63,
		    datalogger_e_64,
		    datalogger_e_65,
		    datalogger_e_66,
		    datalogger_e_67,
		    datalogger_e_68,
		    datalogger_e_69,
		    datalogger_e_70,
		    datalogger_e_71,
		    datalogger_e_72,
		    datalogger_e_73,
		    datalogger_e_74,
		    datalogger_e_75,
		    datalogger_e_76,
		    datalogger_e_77,
		    datalogger_e_78,
		    datalogger_e_79,
		    datalogger_e_80,
		    datalogger_e_81,
		    datalogger_e_82,
		    datalogger_e_83,
		    datalogger_e_84,
		    datalogger_e_85,
		    datalogger_e_86,
		    datalogger_e_87,
		    datalogger_e_88,
		    datalogger_e_89,
		    datalogger_e_90,
		    datalogger_e_91,
		    datalogger_e_92,
		    datalogger_e_93,
		    datalogger_e_94,
		    datalogger_e_95,
		    datalogger_e_96,
		    datalogger_e_97,
		    datalogger_e_98,
		    datalogger_e_99
	  }
  }
}

WAVEFORM waveform27
{
	Y_AXIS yaxis22;
    EMPHASIS TRUE;
    LINE_COLOR 0x00b3df ;   /* Farbe Gelbbraun */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			datalogger_t_0,
            datalogger_t_1,
            datalogger_t_2,
            datalogger_t_3,
            datalogger_t_4,
            datalogger_t_5,
            datalogger_t_6,
            datalogger_t_7,
            datalogger_t_8,
            datalogger_t_9,
            datalogger_t_10,
            datalogger_t_11,
            datalogger_t_12,
            datalogger_t_13,
            datalogger_t_14,
            datalogger_t_15,
            datalogger_t_16,
            datalogger_t_17,
            datalogger_t_18,
            datalogger_t_19,
            datalogger_t_20,
            datalogger_t_21,
            datalogger_t_22,
            datalogger_t_23,
            datalogger_t_24,
            datalogger_t_25,
            datalogger_t_26,
            datalogger_t_27,
            datalogger_t_28,
            datalogger_t_29,
            datalogger_t_30,
            datalogger_t_31,
            datalogger_t_32,
            datalogger_t_33,
            datalogger_t_34,
            datalogger_t_35,
            datalogger_t_36,
            datalogger_t_37,
            datalogger_t_38,
            datalogger_t_39,
            datalogger_t_40,
            datalogger_t_41,
            datalogger_t_42,
            datalogger_t_43,
            datalogger_t_44,
            datalogger_t_45,
            datalogger_t_46,
            datalogger_t_47,
            datalogger_t_48,
            datalogger_t_49,
            datalogger_t_50,
            datalogger_t_51,
            datalogger_t_52,
            datalogger_t_53,
            datalogger_t_54,
            datalogger_t_55,
            datalogger_t_56,
            datalogger_t_57,
            datalogger_t_58,
            datalogger_t_59,
            datalogger_t_60,
            datalogger_t_61,
            datalogger_t_62,
            datalogger_t_63,
            datalogger_t_64,
            datalogger_t_65,
            datalogger_t_66,
            datalogger_t_67,
            datalogger_t_68,
            datalogger_t_69,
            datalogger_t_70,
            datalogger_t_71,
            datalogger_t_72,
            datalogger_t_73,
            datalogger_t_74,
            datalogger_t_75,
            datalogger_t_76,
            datalogger_t_77,
            datalogger_t_78,
            datalogger_t_79,
            datalogger_t_80,
            datalogger_t_81,
            datalogger_t_82,
            datalogger_t_83,
            datalogger_t_84,
            datalogger_t_85,
            datalogger_t_86,
            datalogger_t_87,
            datalogger_t_88,
            datalogger_t_89,
            datalogger_t_90,
            datalogger_t_91,
            datalogger_t_92,
            datalogger_t_93,
            datalogger_t_94,
            datalogger_t_95,
            datalogger_t_96,
            datalogger_t_97,
            datalogger_t_98,
            datalogger_t_99
		}
		Y_VALUES
		{
	        datalogger_ss_0,
		    datalogger_ss_1,
		    datalogger_ss_2,
		    datalogger_ss_3,
		    datalogger_ss_4,
		    datalogger_ss_5,
		    datalogger_ss_6,
		    datalogger_ss_7,
		    datalogger_ss_8,
		    datalogger_ss_9,
		    datalogger_ss_10,
		    datalogger_ss_11,
		    datalogger_ss_12,
		    datalogger_ss_13,
		    datalogger_ss_14,
		    datalogger_ss_15,
		    datalogger_ss_16,
		    datalogger_ss_17,
		    datalogger_ss_18,
		    datalogger_ss_19,
		    datalogger_ss_20,
		    datalogger_ss_21,
		    datalogger_ss_22,
		    datalogger_ss_23,
		    datalogger_ss_24,
		    datalogger_ss_25,
		    datalogger_ss_26,
		    datalogger_ss_27,
		    datalogger_ss_28,
		    datalogger_ss_29,
		    datalogger_ss_30,
		    datalogger_ss_31,
		    datalogger_ss_32,
		    datalogger_ss_33,
		    datalogger_ss_34,
		    datalogger_ss_35,
		    datalogger_ss_36,
		    datalogger_ss_37,
		    datalogger_ss_38,
		    datalogger_ss_39,
		    datalogger_ss_40,
		    datalogger_ss_41,
		    datalogger_ss_42,
		    datalogger_ss_43,
		    datalogger_ss_44,
		    datalogger_ss_45,
		    datalogger_ss_46,
		    datalogger_ss_47,
		    datalogger_ss_48,
		    datalogger_ss_49,
		    datalogger_ss_50,
		    datalogger_ss_51,
		    datalogger_ss_52,
		    datalogger_ss_53,
		    datalogger_ss_54,
		    datalogger_ss_55,
		    datalogger_ss_56,
		    datalogger_ss_57,
		    datalogger_ss_58,
		    datalogger_ss_59,
		    datalogger_ss_60,
		    datalogger_ss_61,
		    datalogger_ss_62,
		    datalogger_ss_63,
		    datalogger_ss_64,
		    datalogger_ss_65,
		    datalogger_ss_66,
		    datalogger_ss_67,
		    datalogger_ss_68,
		    datalogger_ss_69,
		    datalogger_ss_70,
		    datalogger_ss_71,
		    datalogger_ss_72,
		    datalogger_ss_73,
		    datalogger_ss_74,
		    datalogger_ss_75,
		    datalogger_ss_76,
		    datalogger_ss_77,
		    datalogger_ss_78,
		    datalogger_ss_79,
		    datalogger_ss_80,
		    datalogger_ss_81,
		    datalogger_ss_82,
		    datalogger_ss_83,
		    datalogger_ss_84,
		    datalogger_ss_85,
		    datalogger_ss_86,
		    datalogger_ss_87,
		    datalogger_ss_88,
		    datalogger_ss_89,
		    datalogger_ss_90,
		    datalogger_ss_91,
		    datalogger_ss_92,
		    datalogger_ss_93,
		    datalogger_ss_94,
		    datalogger_ss_95,
		    datalogger_ss_96,
		    datalogger_ss_97,
		    datalogger_ss_98,
		    datalogger_ss_99
	  }
  }
}

#endif

/*----------------- Travel histogram X -----------------*/

/*----------------- Travel histogram X (long term) -----------------*/

MENU Page_EDDL_x_long
{
	LABEL "Travel histogram x (long term)" "|de|Histogramm Ventilstellung x (Langzeit)";
/*     STYLE WINDOW;*/
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph2,
#endif

      his_x_mittelwert_int_1,
      his_x_anzahl_messpunkte

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      x_interval_value_0,
      x_interval_value_1,
      x_interval_value_2,
      x_interval_value_3,
      x_interval_value_4,
      x_interval_value_5,
      x_interval_value_6,
      x_interval_value_7,
      x_interval_value_8,
      x_interval_value_9,
      x_interval_value_10,
      x_interval_value_11,
      x_interval_value_12,
      x_interval_value_13,
      x_interval_value_14,
      x_interval_value_15,
      x_interval_value_16,
      x_interval_value_17,
      x_interval_value_18,
      x_interval_value_19,
      x_interval_value_20,
      x_interval_value_21
#endif

   }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph2
{
	LABEL "Travel histogram x (long term)" "|de|Histogramm Ventilstellung x (Langzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis1;
	MEMBERS
	{
		WAVEFORM1, waveform2;
	}
}

WAVEFORM waveform2
{
	Y_AXIS yaxis1;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 46;
		X_VALUES
		{
			aXHistogram[0],
			aXHistogram[0],	aXHistogram[1],
			aXHistogram[1],	aXHistogram[2],
			aXHistogram[2], aXHistogram[3],
			aXHistogram[3],	aXHistogram[4],
			aXHistogram[4],	aXHistogram[5],
			aXHistogram[5],	aXHistogram[6],
			aXHistogram[6],	aXHistogram[7],
			aXHistogram[7],	aXHistogram[8],
			aXHistogram[8],	aXHistogram[9],
			aXHistogram[9],	aXHistogram[10],
			aXHistogram[10], aXHistogram[11],
			aXHistogram[11], aXHistogram[12],
			aXHistogram[12], aXHistogram[13],
			aXHistogram[13], aXHistogram[14],
			aXHistogram[14], aXHistogram[15],
			aXHistogram[15], aXHistogram[16],
			aXHistogram[16], aXHistogram[17],
			aXHistogram[17], aXHistogram[18],
			aXHistogram[18], aXHistogram[19],
			aXHistogram[19], aXHistogram[20],
			aXHistogram[20], aXHistogram[21],
			aXHistogram[21], aXHistogram[22],
			aXHistogram[22]
		}
		Y_VALUES
		{
			y000,
		    x_interval_value_0,  x_interval_value_0,
			x_interval_value_1,  x_interval_value_1,
			x_interval_value_2,  x_interval_value_2,
			x_interval_value_3,  x_interval_value_3,
			x_interval_value_4,  x_interval_value_4,
			x_interval_value_5,  x_interval_value_5,
			x_interval_value_6,  x_interval_value_6,
			x_interval_value_7,  x_interval_value_7,
			x_interval_value_8,  x_interval_value_8,
			x_interval_value_9,  x_interval_value_9,
			x_interval_value_10, x_interval_value_10,
			x_interval_value_11, x_interval_value_11,
			x_interval_value_12, x_interval_value_12,
			x_interval_value_13, x_interval_value_13,
			x_interval_value_14, x_interval_value_14,
			x_interval_value_15, x_interval_value_15,
			x_interval_value_16, x_interval_value_16,
			x_interval_value_17, x_interval_value_17,
			x_interval_value_18, x_interval_value_18,
			x_interval_value_19, x_interval_value_19,
			x_interval_value_20, x_interval_value_20,
			x_interval_value_21, x_interval_value_21,
		  y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform1
		}
}

#endif

/*----------------- Travel histogram X (short term) -----------------*/

MENU Page_EDDL_x_short
{
	LABEL "Travel histogram x (short term)" "|de|Histogramm Ventilstellung x (Kurzzeit)";
/*     STYLE WINDOW;*/
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph1,
#endif

      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      his_x_mittelwert_kurz,
      sample_rate_st_hist,
      transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      x_interval_value_kz_0,
      x_interval_value_kz_1,
      x_interval_value_kz_2,
      x_interval_value_kz_3,
      x_interval_value_kz_4,
      x_interval_value_kz_5,
      x_interval_value_kz_6,
      x_interval_value_kz_7,
      x_interval_value_kz_8,
      x_interval_value_kz_9,
      x_interval_value_kz_10,
      x_interval_value_kz_11,
      x_interval_value_kz_12,
      x_interval_value_kz_13,
      x_interval_value_kz_14,
      x_interval_value_kz_15,
      x_interval_value_kz_16,
      x_interval_value_kz_17,
      x_interval_value_kz_18,
      x_interval_value_kz_19,
      x_interval_value_kz_20,
      x_interval_value_kz_21
#endif

  }
}

/*--------------------------------------------------*/


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph1
{
	LABEL   "Travel histogram x (short term)" "|de|Histogramm Ventilstellung x (Kurzzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS  xaxis1;
	MEMBERS
	{
		WAVEFORM1, waveform1;
	}
}

AXIS xaxis1
{
	LABEL "x";
	MIN_VALUE -5;
	MAX_VALUE 105;
	CONSTANT_UNIT "%";
}

AXIS yaxis1
{
	LABEL "Frequency" "|de|Hufigkeit";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform1
{
	Y_AXIS yaxis1;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 46;
		X_VALUES
		{
			aXHistogram[0],
			aXHistogram[0],	aXHistogram[1],
			aXHistogram[1],	aXHistogram[2],
			aXHistogram[2], aXHistogram[3],
			aXHistogram[3],	aXHistogram[4],
			aXHistogram[4],	aXHistogram[5],
			aXHistogram[5],	aXHistogram[6],
			aXHistogram[6],	aXHistogram[7],
			aXHistogram[7],	aXHistogram[8],
			aXHistogram[8],	aXHistogram[9],
			aXHistogram[9],	aXHistogram[10],
			aXHistogram[10], aXHistogram[11],
			aXHistogram[11], aXHistogram[12],
			aXHistogram[12], aXHistogram[13],
			aXHistogram[13], aXHistogram[14],
			aXHistogram[14], aXHistogram[15],
			aXHistogram[15], aXHistogram[16],
			aXHistogram[16], aXHistogram[17],
			aXHistogram[17], aXHistogram[18],
			aXHistogram[18], aXHistogram[19],
			aXHistogram[19], aXHistogram[20],
			aXHistogram[20], aXHistogram[21],
			aXHistogram[21], aXHistogram[22],
			aXHistogram[22]
		}
		Y_VALUES
		{
			y000,
		    x_interval_value_kz_0,  x_interval_value_kz_0,
			x_interval_value_kz_1,  x_interval_value_kz_1,
			x_interval_value_kz_2,  x_interval_value_kz_2,
			x_interval_value_kz_3,  x_interval_value_kz_3,
			x_interval_value_kz_4,  x_interval_value_kz_4,
			x_interval_value_kz_5,  x_interval_value_kz_5,
			x_interval_value_kz_6,  x_interval_value_kz_6,
			x_interval_value_kz_7,  x_interval_value_kz_7,
			x_interval_value_kz_8,  x_interval_value_kz_8,
			x_interval_value_kz_9,  x_interval_value_kz_9,
			x_interval_value_kz_10, x_interval_value_kz_10,
			x_interval_value_kz_11, x_interval_value_kz_11,
			x_interval_value_kz_12, x_interval_value_kz_12,
			x_interval_value_kz_13, x_interval_value_kz_13,
			x_interval_value_kz_14, x_interval_value_kz_14,
			x_interval_value_kz_15, x_interval_value_kz_15,
			x_interval_value_kz_16, x_interval_value_kz_16,
			x_interval_value_kz_17, x_interval_value_kz_17,
			x_interval_value_kz_18, x_interval_value_kz_18,
			x_interval_value_kz_19, x_interval_value_kz_19,
			x_interval_value_kz_20, x_interval_value_kz_20,
			x_interval_value_kz_21, x_interval_value_kz_21,
		    y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform1/*, methodRefresh*/
		}
}

VARIABLE y000
{
	LABEL "0";
	TYPE FLOAT
	{
	   DEFAULT_VALUE 0;
	}
	CLASS LOCAL;
	HANDLING READ;
}

VARIABLE hist_x0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_x1   LIKE VARIABLE   hist_x0  {}
hist_x2   LIKE VARIABLE   hist_x0  {}
hist_x3   LIKE VARIABLE   hist_x0  {}
hist_x4   LIKE VARIABLE   hist_x0  {}
hist_x5   LIKE VARIABLE   hist_x0  {}
hist_x6   LIKE VARIABLE   hist_x0  {}
hist_x7   LIKE VARIABLE   hist_x0  {}
hist_x8   LIKE VARIABLE   hist_x0  {}
hist_x9   LIKE VARIABLE   hist_x0  {}
hist_x10   LIKE VARIABLE   hist_x0 {}
hist_x11   LIKE VARIABLE   hist_x0 {}
hist_x12   LIKE VARIABLE   hist_x0 {}
hist_x13   LIKE VARIABLE   hist_x0 {}
hist_x14   LIKE VARIABLE   hist_x0 {}
hist_x15   LIKE VARIABLE   hist_x0 {}
hist_x16   LIKE VARIABLE   hist_x0 {}
hist_x17   LIKE VARIABLE   hist_x0 {}
hist_x18   LIKE VARIABLE   hist_x0 {}
hist_x19   LIKE VARIABLE   hist_x0 {}
hist_x20   LIKE VARIABLE   hist_x0 {}
hist_x21   LIKE VARIABLE   hist_x0 {}
hist_x22   LIKE VARIABLE   hist_x0 {}

ARRAY OF VARIABLE aXHistogram
{
	LABEL "x[]";
	ELEMENTS
	{
		 0, hist_x0;
		 1, hist_x1;
		 2, hist_x2;
		 3, hist_x3;
		 4, hist_x4;
		 5, hist_x5;
		 6, hist_x6;
		 7, hist_x7;
		 8, hist_x8;
		 9, hist_x9;
		10, hist_x10;
		11, hist_x11;
		12, hist_x12;
		13, hist_x13;
		14, hist_x14;
		15, hist_x15;
		16, hist_x16;
		17, hist_x17;
		18, hist_x18;
		19, hist_x19;
		20, hist_x20;
		21, hist_x21;
		22, hist_x22;
	}
}

METHOD methodInitWaveform1
{
	LABEL "methodInitWaveform1";
	DEFINITION
	{
		assign_float(aXHistogram[0], -5 );
		assign_float(aXHistogram[1], 0 );
		assign_float(aXHistogram[2], 5 );
		assign_float(aXHistogram[3], 10 );
		assign_float(aXHistogram[4], 15 );
		assign_float(aXHistogram[5], 20 );
		assign_float(aXHistogram[6], 25 );
		assign_float(aXHistogram[7], 30 );
		assign_float(aXHistogram[8], 35 );
		assign_float(aXHistogram[9], 40 );
		assign_float(aXHistogram[10], 45 );
		assign_float(aXHistogram[11], 50 );
		assign_float(aXHistogram[12], 55 );
		assign_float(aXHistogram[13], 60 );
		assign_float(aXHistogram[14], 65 );
		assign_float(aXHistogram[15], 70 );
		assign_float(aXHistogram[16], 75 );
		assign_float(aXHistogram[17], 80 );
		assign_float(aXHistogram[18], 85 );
		assign_float(aXHistogram[19], 90 );
		assign_float(aXHistogram[20], 95 );
		assign_float(aXHistogram[21], 100 );
		assign_float(aXHistogram[22], 105 );

		save_values ();
	}
}


/*
METHOD methodInit
{
	LABEL "methodInit";
	DEFINITION
	{
		ACKNOWLEDGE ("Init Action");
	}
}

METHOD methodExit
{
	LABEL "methodExit";
	DEFINITION
	{
		ACKNOWLEDGE ("Exit Action");
	}
}*/

#endif

/*-------------------------------------------------------------------*/



/*----------------- Travel histogram E -----------------*/

/*----------------- Travel histogram E (long term) -----------------*/

MENU Page_EDDL_e_long
{
	LABEL "Travel histogram e (long term)" "|de|Histogramm Regelabweichung e (Langzeit)";
/*     STYLE WINDOW;*/
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
 	  graph4,
#endif
	  mittelwert_e_lang,
	  gesamtanzahl,
      deviation_min,
	  deviation_max

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      e_interval_value_long_0,
      e_interval_value_long_1,
      e_interval_value_long_2,
      e_interval_value_long_3,
      e_interval_value_long_4,
      e_interval_value_long_5,
      e_interval_value_long_6,
      e_interval_value_long_7,
      e_interval_value_long_8,
      e_interval_value_long_9,
      e_interval_value_long_10,
      e_interval_value_long_11
#endif
   }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph4
{
	LABEL "Travel histogram e" "|de|Histogramm Regelabweichung e";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis3;
	MEMBERS
	{
		WAVEFORM4, waveform4;
	}
}

WAVEFORM waveform4
{
	Y_AXIS yaxis3;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 26;
		X_VALUES
		{
			aEHistogram[0],
			aEHistogram[0],	aEHistogram[1],
			aEHistogram[1],	aEHistogram[2],
			aEHistogram[2], aEHistogram[3],
			aEHistogram[3],	aEHistogram[4],
			aEHistogram[4],	aEHistogram[5],
			aEHistogram[5],	aEHistogram[6],
			aEHistogram[6],	aEHistogram[7],
			aEHistogram[7],	aEHistogram[8],
			aEHistogram[8],	aEHistogram[9],
			aEHistogram[9],	aEHistogram[10],
			aEHistogram[10], aEHistogram[11],
			aEHistogram[11], aEHistogram[12],
			aEHistogram[12]
		}
		Y_VALUES
		{
			y000,
		    e_interval_value_long_0,  e_interval_value_long_0,
			e_interval_value_long_1,  e_interval_value_long_1,
			e_interval_value_long_2,  e_interval_value_long_2,
			e_interval_value_long_3,  e_interval_value_long_3,
			e_interval_value_long_4,  e_interval_value_long_4,
			e_interval_value_long_5,  e_interval_value_long_5,
			e_interval_value_long_6,  e_interval_value_long_6,
			e_interval_value_long_7,  e_interval_value_long_7,
			e_interval_value_long_8,  e_interval_value_long_8,
			e_interval_value_long_9,  e_interval_value_long_9,
			e_interval_value_long_10, e_interval_value_long_10,
			e_interval_value_long_11, e_interval_value_long_11,
			y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform3/*, methodRefresh*/
		}
}

#endif

/*----------------- Travel histogram E (short term) -----------------*/

MENU Page_EDDL_e_short
{
	LABEL "Travel histogram e (short term)" "|de|Histogramm Regelabweichung e (Kurzzeit)";
/*     STYLE WINDOW;*/
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph3,
#endif
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
	  his_e_mittelwert_kurz,
	  sample_rate_st_hist_e,
      transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      e_interval_value_short_0,
      e_interval_value_short_1,
      e_interval_value_short_2,
      e_interval_value_short_3,
      e_interval_value_short_4,
      e_interval_value_short_5,
      e_interval_value_short_6,
      e_interval_value_short_7,
      e_interval_value_short_8,
      e_interval_value_short_9,
      e_interval_value_short_10,
      e_interval_value_short_11
#endif
  }
}

/*--------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph3
{
	LABEL "Travel histogram e" "|de|Histogramm Regelabweichung e";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis3;
	MEMBERS
	{
		WAVEFORM3, waveform3;
	}
}

AXIS xaxis3
{
	LABEL "e";
    SCALING LOGARITHMIC;  /*  Funktioniert irgendwie noch nicht, nehme an da fehlt noch das entsprechende LOGARITMIC Define */
	MIN_VALUE -5.5;
	MAX_VALUE 5.5;
	CONSTANT_UNIT "%";
}

AXIS yaxis3
{
	LABEL "Frequency" "|de|Hufigkeit";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform3
{
	Y_AXIS yaxis3;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 26;
		X_VALUES
		{
			aEHistogram[0],
			aEHistogram[0],	aEHistogram[1],
			aEHistogram[1],	aEHistogram[2],
			aEHistogram[2], aEHistogram[3],
			aEHistogram[3],	aEHistogram[4],
			aEHistogram[4],	aEHistogram[5],
			aEHistogram[5],	aEHistogram[6],
			aEHistogram[6],	aEHistogram[7],
			aEHistogram[7],	aEHistogram[8],
			aEHistogram[8],	aEHistogram[9],
			aEHistogram[9],	aEHistogram[10],
			aEHistogram[10], aEHistogram[11],
			aEHistogram[11], aEHistogram[12],
			aEHistogram[12]
		}
		Y_VALUES
		{
			y000,
		    e_interval_value_short_0,  e_interval_value_short_0,
			e_interval_value_short_1,  e_interval_value_short_1,
			e_interval_value_short_2,  e_interval_value_short_2,
			e_interval_value_short_3,  e_interval_value_short_3,
			e_interval_value_short_4,  e_interval_value_short_4,
			e_interval_value_short_5,  e_interval_value_short_5,
			e_interval_value_short_6,  e_interval_value_short_6,
			e_interval_value_short_7,  e_interval_value_short_7,
			e_interval_value_short_8,  e_interval_value_short_8,
			e_interval_value_short_9,  e_interval_value_short_9,
			e_interval_value_short_10, e_interval_value_short_10,
			e_interval_value_short_11, e_interval_value_short_11,
			y000
		}
	}
        INIT_ACTIONS
		{
			methodInitWaveform3/*, methodRefresh*/
		}
}

VARIABLE hist_e0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_e1   LIKE VARIABLE   hist_e0 {}
hist_e2   LIKE VARIABLE   hist_e0 {}
hist_e3   LIKE VARIABLE   hist_e0 {}
hist_e4   LIKE VARIABLE   hist_e0 {}
hist_e5   LIKE VARIABLE   hist_e0 {}
hist_e6   LIKE VARIABLE   hist_e0 {}
hist_e7   LIKE VARIABLE   hist_e0 {}
hist_e8   LIKE VARIABLE   hist_e0 {}
hist_e9   LIKE VARIABLE   hist_e0 {}
hist_e10   LIKE VARIABLE   hist_e0 {}
hist_e11   LIKE VARIABLE   hist_e0 {}
hist_e12   LIKE VARIABLE   hist_e0 {}

ARRAY OF VARIABLE aEHistogram
{
	LABEL "x[]";
	ELEMENTS
	{
		 0, hist_e0;
		 1, hist_e1;
		 2, hist_e2;
		 3, hist_e3;
		 4, hist_e4;
		 5, hist_e5;
		 6, hist_e6;
		 7, hist_e7;
		 8, hist_e8;
		 9, hist_e9;
		10, hist_e10;
		11, hist_e11;
		12, hist_e12;
	}
}

METHOD methodInitWaveform3
{
	LABEL "methodInitWaveform3";
	DEFINITION
	{
		assign_float(aEHistogram[0], -5.5 );
		assign_float(aEHistogram[1], -5.0 );
		assign_float(aEHistogram[2], -1.0 );
		assign_float(aEHistogram[3], -0.5 );
		assign_float(aEHistogram[4], -0.2 );
		assign_float(aEHistogram[5], -0.1 );
		assign_float(aEHistogram[6], 0 );
		assign_float(aEHistogram[7], 0.1 );
		assign_float(aEHistogram[8], 0.2 );
		assign_float(aEHistogram[9], 0.5 );
		assign_float(aEHistogram[10], 1.0 );
		assign_float(aEHistogram[11], 5.0 );
		assign_float(aEHistogram[12], 5.5 );

		save_values ();
	}
}


#endif

/*--------------------------------------------------------------------*/

/*----------------- Travel histogram Z -----------------*/

/*----------------- Travel histogram Z (long term) -----------------*/

MENU Page_EDDL_z_long
{
	LABEL "Cycle counter histogram (long term)" "|de|Histogramm Zyklenzhler (Langzeit)";
/*    STYLE WINDOW;*/
	ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      graph5,
#endif
      his_z_mittelwert_int,
      his_z_gesamtanzahl,
      his_z_dynamic_stress_factor

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      his_z_intervallwert_0,
      his_z_intervallwert_1,
      his_z_intervallwert_2,
      his_z_intervallwert_3,
      his_z_intervallwert_4,
      his_z_intervallwert_5,
      his_z_intervallwert_6,
      his_z_intervallwert_7,
      his_z_intervallwert_8,
      his_z_intervallwert_9,
      his_z_intervallwert_10,
      his_z_intervallwert_11,
      his_z_intervallwert_12
#endif
    }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph5
{
	LABEL "Cycle counter histogram (long term)" "|de|Histogramm Zyklenzhler (Langzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis6;
	MEMBERS
	{
		WAVEFORM5, waveform5;
	}
}

WAVEFORM waveform5
{
	Y_AXIS yaxis6;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 28;
		X_VALUES
		{
			aZHistogram[0],
			aZHistogram[0],	aZHistogram[1],
			aZHistogram[1],	aZHistogram[2],
			aZHistogram[2], aZHistogram[3],
			aZHistogram[3],	aZHistogram[4],
			aZHistogram[4],	aZHistogram[5],
			aZHistogram[5],	aZHistogram[6],
			aZHistogram[6],	aZHistogram[7],
			aZHistogram[7],	aZHistogram[8],
			aZHistogram[8],	aZHistogram[9],
			aZHistogram[9],	aZHistogram[10],
			aZHistogram[10], aZHistogram[11],
			aZHistogram[11], aZHistogram[12],
			aZHistogram[12], aZHistogram[13],
			aZHistogram[13]
		}
		Y_VALUES
		{
			y000,
	        his_z_intervallwert_0,  his_z_intervallwert_0,
			his_z_intervallwert_1,  his_z_intervallwert_1,
			his_z_intervallwert_2,  his_z_intervallwert_2,
			his_z_intervallwert_3,  his_z_intervallwert_3,
			his_z_intervallwert_4,  his_z_intervallwert_4,
			his_z_intervallwert_5,  his_z_intervallwert_5,
			his_z_intervallwert_6,  his_z_intervallwert_6,
			his_z_intervallwert_7,  his_z_intervallwert_7,
			his_z_intervallwert_8,  his_z_intervallwert_8,
			his_z_intervallwert_9,  his_z_intervallwert_9,
			his_z_intervallwert_10, his_z_intervallwert_10,
			his_z_intervallwert_11, his_z_intervallwert_11,
			his_z_intervallwert_12, his_z_intervallwert_12,
		    y000
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform6
		}
}

#endif

/*----------------- Travel histogram Z (short term) -----------------*/

MENU Page_EDDL_z_short
{
	LABEL "Cycle counter histogram (short term)" "|de|Histogramm Zyklenzhler (Kurzzeit)";
/*    STYLE WINDOW;*/
	ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      graph6,
#endif
      his_z_mittelwert_kurz

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      his_z_intervallwert_short_0,
      his_z_intervallwert_short_1,
      his_z_intervallwert_short_2,
      his_z_intervallwert_short_3,
      his_z_intervallwert_short_4,
      his_z_intervallwert_short_5,
      his_z_intervallwert_short_6,
      his_z_intervallwert_short_7,
      his_z_intervallwert_short_8,
      his_z_intervallwert_short_9,
      his_z_intervallwert_short_10,
      his_z_intervallwert_short_11,
      his_z_intervallwert_short_12
#endif
   }
}

/* Cycle counter histogram (short term) */

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph6
{
	LABEL "Cycle counter histogram (short term)" "|de|Histogramm Zyklenzhler (Kurzzeit)";
	HEIGHT	X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis6;
	MEMBERS
	{
		WAVEFORM6, waveform6;
	}
}

AXIS xaxis6
{
	LABEL "Cycle" "|de|Zyklus";
	MIN_VALUE   0;
	MAX_VALUE 110;
	CONSTANT_UNIT "%";
}

AXIS yaxis6
{
	LABEL "Frequency" "|de|Hufigkeit";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform6
{
	Y_AXIS yaxis6;
    EMPHASIS TRUE;
	TYPE XY
	{
		NUMBER_OF_POINTS 28;
		X_VALUES
		{
			aZHistogram[0],
			aZHistogram[0],	aZHistogram[1],
			aZHistogram[1],	aZHistogram[2],
			aZHistogram[2], aZHistogram[3],
			aZHistogram[3],	aZHistogram[4],
			aZHistogram[4],	aZHistogram[5],
			aZHistogram[5],	aZHistogram[6],
			aZHistogram[6],	aZHistogram[7],
			aZHistogram[7],	aZHistogram[8],
			aZHistogram[8],	aZHistogram[9],
			aZHistogram[9],	aZHistogram[10],
			aZHistogram[10], aZHistogram[11],
			aZHistogram[11], aZHistogram[12],
			aZHistogram[12], aZHistogram[13],
			aZHistogram[13]
		}
		Y_VALUES
		{
			y000,
	        his_z_intervallwert_short_0,  his_z_intervallwert_short_0,
			his_z_intervallwert_short_1,  his_z_intervallwert_short_1,
			his_z_intervallwert_short_2,  his_z_intervallwert_short_2,
			his_z_intervallwert_short_3,  his_z_intervallwert_short_3,
			his_z_intervallwert_short_4,  his_z_intervallwert_short_4,
			his_z_intervallwert_short_5,  his_z_intervallwert_short_5,
			his_z_intervallwert_short_6,  his_z_intervallwert_short_6,
			his_z_intervallwert_short_7,  his_z_intervallwert_short_7,
			his_z_intervallwert_short_8,  his_z_intervallwert_short_8,
			his_z_intervallwert_short_9,  his_z_intervallwert_short_9,
			his_z_intervallwert_short_10, his_z_intervallwert_short_10,
			his_z_intervallwert_short_11, his_z_intervallwert_short_11,
			his_z_intervallwert_short_12, his_z_intervallwert_short_12,
		    y000
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform6
		}
}

/*
METHOD methodRefresh_z
{
	LABEL "Reload data";
	DEFINITION
	{
        PUT_MESSAGE (" Reloading Histogram Data ");
		send_command_trans(157,25);
	}
}*/

/*ARRAY aZHistogram
{
	LABEL "z";
	TYPE x000;
	NUMBER_OF_ELEMENTS 14;
}*/

VARIABLE hist_z_0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_z_1   LIKE VARIABLE   hist_z_0 {}
hist_z_2   LIKE VARIABLE   hist_z_0 {}
hist_z_3   LIKE VARIABLE   hist_z_0 {}
hist_z_4   LIKE VARIABLE   hist_z_0 {}
hist_z_5   LIKE VARIABLE   hist_z_0 {}
hist_z_6   LIKE VARIABLE   hist_z_0 {}
hist_z_7   LIKE VARIABLE   hist_z_0 {}
hist_z_8   LIKE VARIABLE   hist_z_0 {}
hist_z_9   LIKE VARIABLE   hist_z_0 {}
hist_z_10   LIKE VARIABLE   hist_z_0 {}
hist_z_11   LIKE VARIABLE   hist_z_0 {}
hist_z_12   LIKE VARIABLE   hist_z_0 {}
hist_z_13   LIKE VARIABLE   hist_z_0 {}

ARRAY OF VARIABLE aZHistogram
{
	LABEL "z[]";
	ELEMENTS
	{
		 0, hist_z_0;
		 1, hist_z_1;
		 2, hist_z_2;
		 3, hist_z_3;
		 4, hist_z_4;
		 5, hist_z_5;
		 6, hist_z_6;
		 7, hist_z_7;
		 8, hist_z_8;
		 9, hist_z_9;
		10, hist_z_10;
		11, hist_z_11;
		12, hist_z_12;
		13, hist_z_13;
	}
}

METHOD methodInitWaveform6
{
	LABEL "methodInitWaveform6";
	DEFINITION
	{
		assign_float(aZHistogram[0], 0 );
		assign_float(aZHistogram[1], 2 );
		assign_float(aZHistogram[2], 5 );
		assign_float(aZHistogram[3], 10 );
		assign_float(aZHistogram[4], 20 );
		assign_float(aZHistogram[5], 30 );
		assign_float(aZHistogram[6], 40 );
		assign_float(aZHistogram[7], 50 );
		assign_float(aZHistogram[8], 60 );
		assign_float(aZHistogram[9], 70 );
		assign_float(aZHistogram[10], 80 );
		assign_float(aZHistogram[11], 90 );
		assign_float(aZHistogram[12], 100 );
		assign_float(aZHistogram[13], 110 );

    save_values ();
  }
}

#endif

/*--------------------------------------------------------------------*/

/*----------------- Drive Signal diagram Y  -----------------*/

/*----------------- Drive Diagram Y (Steady) -----------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

MENU Page_display_EDDL_y_steady
{
	LABEL "Drive signal diagram y steady" "|de|Diagramm Stellsignal y Stationaer";
/*    STYLE WINDOW;*/
	ITEMS
	{
      graph7
    }
}

#endif

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_

MENU Page_display_EDDL_y_steady_long
{
	LABEL "Drive signal diagram y steady (long term)" "|de|Diagramm Stellsignal y Stationaer (Langzeit)";
/*    STYLE WINDOW;*/
	ITEMS
	{
       /* Diagramm Stellsignal y Stationaer Langzeit */
      average_value_stat_long_1,
      average_value_stat_long_2,
      average_value_stat_long_3,
      average_value_stat_long_4,
      average_value_stat_long_5,
      average_value_stat_long_6,
      average_value_stat_long_7,
      average_value_stat_long_8,
      average_value_stat_long_9,
      average_value_stat_long_10,
      average_value_stat_long_11,
      SEPARATOR,
      average_value_stat_long_12,
      average_value_stat_long_13,
      average_value_stat_long_14,
      average_value_stat_long_15,
      average_value_stat_long_16,
      average_value_stat_long_17,
      average_value_stat_long_18,
      average_value_stat_long_19,
      average_value_stat_long_20,
      average_value_stat_long_21,
      average_value_stat_long_22
  }
}

MENU Page_display_EDDL_y_steady_short
{
	LABEL "Drive signal diagram y steady (short term)" "|de|Diagramm Stellsignal y Stationaer (Kurzzeit)";
/*    STYLE WINDOW;*/
	ITEMS
	{
       /* Diagramm Stellsignal y Stationaer Kurzzeit */
      average_value_stat_short_1,
      average_value_stat_short_2,
      average_value_stat_short_3,
      average_value_stat_short_4,
      average_value_stat_short_5,
      average_value_stat_short_6,
      average_value_stat_short_7,
      average_value_stat_short_8,
      average_value_stat_short_9,
      average_value_stat_short_10,
      average_value_stat_short_11,
      SEPARATOR,
      average_value_stat_short_12,
      average_value_stat_short_13,
      average_value_stat_short_14,
      average_value_stat_short_15,
      average_value_stat_short_16,
      average_value_stat_short_17,
      average_value_stat_short_18,
      average_value_stat_short_19,
      average_value_stat_short_20,
      average_value_stat_short_21,
      average_value_stat_short_22
  }
}

#endif


/*----------------- Drive Signal diagram Y (steady) -----------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph7
{
	LABEL "Steady" "|de|Stationr";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis7;
	MEMBERS
	{
		WAVEFORM7, waveform7;
		WAVEFORM8, waveform8;
		/*  Referenzkurve */
	    WAVEFORM15, waveform15;
	}
}

AXIS xaxis7
{
	LABEL "x";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis7
{
	LABEL "Steady - short y" "|de|Stationr - Kz. y";
	MIN_VALUE   0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

AXIS yaxis8
{
	LABEL "Steady - long y" "|de|Stationr - Lz. y";
	MIN_VALUE   0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform7
{
	Y_AXIS yaxis7;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 22;
		X_VALUES
		{
			aYsteadylong[0],
			aYsteadylong[1],
			aYsteadylong[2],
			aYsteadylong[3],
			aYsteadylong[4],
			aYsteadylong[5],
			aYsteadylong[6],
			aYsteadylong[7],
			aYsteadylong[8],
			aYsteadylong[9],
			aYsteadylong[10],
			aYsteadylong[11],
			aYsteadylong[12],
			aYsteadylong[13],
			aYsteadylong[14],
			aYsteadylong[15],
			aYsteadylong[16],
			aYsteadylong[17],
			aYsteadylong[18],
			aYsteadylong[19],
			aYsteadylong[20],
			aYsteadylong[21]

		}
		Y_VALUES
		{
            average_value_stat_short_1,
            average_value_stat_short_2,
            average_value_stat_short_3,
            average_value_stat_short_4,
            average_value_stat_short_5,
            average_value_stat_short_6,
            average_value_stat_short_7,
            average_value_stat_short_8,
            average_value_stat_short_9,
            average_value_stat_short_10,
            average_value_stat_short_11,
            average_value_stat_short_12,
            average_value_stat_short_13,
            average_value_stat_short_14,
            average_value_stat_short_15,
            average_value_stat_short_16,
            average_value_stat_short_17,
            average_value_stat_short_18,
            average_value_stat_short_19,
            average_value_stat_short_20,
            average_value_stat_short_21,
	        average_value_stat_short_22
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform7
		}
}

WAVEFORM waveform8
{
	Y_AXIS yaxis8;
    EMPHASIS TRUE;
	LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 22;
		X_VALUES
		{
			aYsteadylong[0],
			aYsteadylong[1],
			aYsteadylong[2],
			aYsteadylong[3],
			aYsteadylong[4],
			aYsteadylong[5],
			aYsteadylong[6],
			aYsteadylong[7],
			aYsteadylong[8],
			aYsteadylong[9],
			aYsteadylong[10],
			aYsteadylong[11],
			aYsteadylong[12],
			aYsteadylong[13],
			aYsteadylong[14],
			aYsteadylong[15],
			aYsteadylong[16],
			aYsteadylong[17],
			aYsteadylong[18],
			aYsteadylong[19],
			aYsteadylong[20],
			aYsteadylong[21]
		}
		Y_VALUES
		{
            average_value_stat_long_1,
            average_value_stat_long_2,
            average_value_stat_long_3,
            average_value_stat_long_4,
            average_value_stat_long_5,
            average_value_stat_long_6,
            average_value_stat_long_7,
            average_value_stat_long_8,
            average_value_stat_long_9,
            average_value_stat_long_10,
            average_value_stat_long_11,
            average_value_stat_long_12,
            average_value_stat_long_13,
            average_value_stat_long_14,
            average_value_stat_long_15,
            average_value_stat_long_16,
            average_value_stat_long_17,
            average_value_stat_long_18,
            average_value_stat_long_19,
            average_value_stat_long_20,
            average_value_stat_long_21,
	        average_value_stat_long_22
		}
      }
      INIT_ACTIONS
		{
			methodInitWaveform7
		}
}


ARRAY OF VARIABLE aYsteadylong
{
	LABEL "y_steady[]";
	ELEMENTS
	{
		 0, hist_ysteady_long_0;
		 1, hist_ysteady_long_1;
		 2, hist_ysteady_long_2;
		 3, hist_ysteady_long_3;
		 4, hist_ysteady_long_4;
		 5, hist_ysteady_long_5;
		 6, hist_ysteady_long_6;
		 7, hist_ysteady_long_7;
		 8, hist_ysteady_long_8;
		 9, hist_ysteady_long_9;
		 10, hist_ysteady_long_10;
		 11, hist_ysteady_long_11;
		 12, hist_ysteady_long_12;
		 13, hist_ysteady_long_13;
		 14, hist_ysteady_long_14;
		 15, hist_ysteady_long_15;
		 16, hist_ysteady_long_16;
		 17, hist_ysteady_long_17;
		 18, hist_ysteady_long_18;
		 19, hist_ysteady_long_19;
		 20, hist_ysteady_long_20;
		 21, hist_ysteady_long_21;
	}
}

VARIABLE hist_ysteady_long_0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_ysteady_long_1   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_2   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_3   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_4   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_5   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_6   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_7   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_8   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_9   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_10   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_11   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_12   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_13   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_14   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_15   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_16   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_17   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_18   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_19   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_20   LIKE VARIABLE   hist_ysteady_long_0 {}
hist_ysteady_long_21   LIKE VARIABLE   hist_ysteady_long_0 {}

METHOD methodInitWaveform7
{
	LABEL "methodInitWaveform7";
	DEFINITION
	{
		assign_float(aYsteadylong[0], 0 );
		assign_float(aYsteadylong[1], 2.5 );
		assign_float(aYsteadylong[2], 7.5 );
		assign_float(aYsteadylong[3], 12.5 );
		assign_float(aYsteadylong[4], 17.5 );
		assign_float(aYsteadylong[5], 22.5 );
		assign_float(aYsteadylong[6], 27.5 );
		assign_float(aYsteadylong[7], 32.5 );
		assign_float(aYsteadylong[8], 37.5 );
		assign_float(aYsteadylong[9], 42.5 );
		assign_float(aYsteadylong[10], 47.5 );
		assign_float(aYsteadylong[11], 52.5 );
		assign_float(aYsteadylong[12], 57.5 );
		assign_float(aYsteadylong[13], 62.5 );
		assign_float(aYsteadylong[14], 67.5 );
		assign_float(aYsteadylong[15], 72.5 );
		assign_float(aYsteadylong[16], 77.5 );
		assign_float(aYsteadylong[17], 82.5 );
		assign_float(aYsteadylong[18], 87.5 );
		assign_float(aYsteadylong[19], 92.5 );
		assign_float(aYsteadylong[20], 97.5 );
		assign_float(aYsteadylong[21], 100 );

		save_values ();
  }
}

#endif

/*----------------- Drive Signal diagram Y (hysteresis) -----------------*/

MENU Page_EDDL_y_hysteresis
{
	LABEL "Drive signal diagram y hysteresis" "|de|Diagramm Stellsignal y Hysterese";
/*    STYLE WINDOW;*/
	ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      graph8,
#endif
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
      start_abort_hysteresis_online_test,
      hys_stell_y,
      transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_

/* Diagramm Stellsignal y Hysterese */
     ,SEPARATOR,
      average_value_long_1,
      average_value_long_2,
      average_value_long_3,
      average_value_long_4,
      average_value_long_5,
      average_value_long_6,
      average_value_long_7,
      average_value_long_8,
      average_value_long_9,
      average_value_long_10,
      average_value_long_11,
      average_value_long_12,
      average_value_long_13,
      average_value_long_14,
      average_value_long_15,
      average_value_long_16,
      average_value_long_17,
      average_value_long_18,
      average_value_long_19
#endif
  }
}

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph8
{
	LABEL "Hysteresis" "|de|Hysterese";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis7;
	MEMBERS
	{
		WAVEFORM10, waveform10;
		/*  Referenzkurve */
		WAVEFORM17, waveform17;
	}
}

AXIS yaxis10
{
	LABEL "Measurement delta y" "|de|Messwerte delta y";
	MIN_VALUE   0;
	MAX_VALUE 500;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform10
{
	Y_AXIS yaxis10;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 19;
		X_VALUES
		{
			aYhysteresis[0],
			aYhysteresis[1],
			aYhysteresis[2],
			aYhysteresis[3],
			aYhysteresis[4],
			aYhysteresis[5],
			aYhysteresis[6],
			aYhysteresis[7],
			aYhysteresis[8],
			aYhysteresis[9],
			aYhysteresis[10],
			aYhysteresis[11],
			aYhysteresis[12],
			aYhysteresis[13],
			aYhysteresis[14],
			aYhysteresis[15],
			aYhysteresis[16],
			aYhysteresis[17],
			aYhysteresis[18]
		}
		Y_VALUES
		{
          average_value_long_1,
          average_value_long_2,
          average_value_long_3,
          average_value_long_4,
          average_value_long_5,
          average_value_long_6,
          average_value_long_7,
          average_value_long_8,
          average_value_long_9,
          average_value_long_10,
          average_value_long_11,
          average_value_long_12,
          average_value_long_13,
          average_value_long_14,
          average_value_long_15,
          average_value_long_16,
          average_value_long_17,
          average_value_long_18,
          average_value_long_19
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform8
		}
}


ARRAY OF VARIABLE aYhysteresis
{
	LABEL "y_steady[]";
	ELEMENTS
	{
		 0, hist_yhysteresis_0;
		 1, hist_yhysteresis_1;
		 2, hist_yhysteresis_2;
		 3, hist_yhysteresis_3;
		 4, hist_yhysteresis_4;
		 5, hist_yhysteresis_5;
		 6, hist_yhysteresis_6;
		 7, hist_yhysteresis_7;
		 8, hist_yhysteresis_8;
		 9, hist_yhysteresis_9;
		 10, hist_yhysteresis_10;
		 11, hist_yhysteresis_11;
		 12, hist_yhysteresis_12;
		 13, hist_yhysteresis_13;
		 14, hist_yhysteresis_14;
		 15, hist_yhysteresis_15;
		 16, hist_yhysteresis_16;
		 17, hist_yhysteresis_17;
		 18, hist_yhysteresis_18;
	}
}

VARIABLE hist_yhysteresis_0
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}

hist_yhysteresis_1   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_2   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_3   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_4   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_5   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_6   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_7   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_8   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_9   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_10   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_11   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_12   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_13   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_14   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_15   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_16   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_17   LIKE VARIABLE   hist_yhysteresis_0 {}
hist_yhysteresis_18   LIKE VARIABLE   hist_yhysteresis_0 {}

METHOD methodInitWaveform8
{
	LABEL "methodInitWaveform8";
	DEFINITION
	{
		assign_float(aYhysteresis[0], 3 );
		assign_float(aYhysteresis[1], 10.5 );
		assign_float(aYhysteresis[2], 15.5 );
		assign_float(aYhysteresis[3], 20.5 );
		assign_float(aYhysteresis[4], 25.5 );
		assign_float(aYhysteresis[5], 30.5 );
		assign_float(aYhysteresis[6], 35.5 );
		assign_float(aYhysteresis[7], 40.5 );
		assign_float(aYhysteresis[8], 45.5 );
		assign_float(aYhysteresis[9], 50.5 );
		assign_float(aYhysteresis[10], 55.5 );
		assign_float(aYhysteresis[11], 60.5 );
		assign_float(aYhysteresis[12], 65.5 );
		assign_float(aYhysteresis[13], 70.5 );
		assign_float(aYhysteresis[14], 75.5 );
		assign_float(aYhysteresis[15], 80.5 );
		assign_float(aYhysteresis[16], 85.5 );
		assign_float(aYhysteresis[17], 90.5 );
		assign_float(aYhysteresis[18], 98 );

    save_values ();
  }
}

#endif

/*--------------------------------------------------------------------*/
/*----------------- Trend of travel end position ET ------------------*/
/*--------------------------------------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

MENU Page_EDDL_et
{
	LABEL "Trend of travel end position" "|de|Endlagentrend";
/*    STYLE WINDOW;*/
	ITEMS
	{
      graph9,

      ref_value_valve_position,
      lower_end_position_ref_value_bsz,
      trend_travel_end_pos_drive_signal_ref
  }
}

#endif


MENU Page_EDDL_et_1
{
	LABEL "Trend of travel end position 1-15" "|de|Endlagentrend 1-15";
/*    STYLE WINDOW;*/
	ITEMS
	{
      valve_pos_meas_point_1,
      valve_pos_meas_point_2,
      valve_pos_meas_point_3,
      valve_pos_meas_point_4,
      valve_pos_meas_point_5,
      valve_pos_meas_point_6,
      valve_pos_meas_point_7,
      valve_pos_meas_point_8,
      valve_pos_meas_point_9,
      valve_pos_meas_point_10,
      valve_pos_meas_point_11,
      valve_pos_meas_point_12,
      valve_pos_meas_point_13,
      valve_pos_meas_point_14,
      valve_pos_meas_point_15,
      SEPARATOR,
      lower_end_position_bsz_1,
      lower_end_position_bsz_2,
      lower_end_position_bsz_3,
      lower_end_position_bsz_4,
      lower_end_position_bsz_5,
      lower_end_position_bsz_6,
      lower_end_position_bsz_7,
      lower_end_position_bsz_8,
      lower_end_position_bsz_9,
      lower_end_position_bsz_10,
      lower_end_position_bsz_11,
      lower_end_position_bsz_12,
      lower_end_position_bsz_13,
      lower_end_position_bsz_14,
      lower_end_position_bsz_15,
      SEPARATOR,
      lower_end_pos_drive_signal_1,
      lower_end_pos_drive_signal_2,
      lower_end_pos_drive_signal_3,
      lower_end_pos_drive_signal_4,
      lower_end_pos_drive_signal_5,
      lower_end_pos_drive_signal_6,
      lower_end_pos_drive_signal_7,
      lower_end_pos_drive_signal_8,
      lower_end_pos_drive_signal_9,
      lower_end_pos_drive_signal_10,
      lower_end_pos_drive_signal_11,
      lower_end_pos_drive_signal_12,
      lower_end_pos_drive_signal_13,
      lower_end_pos_drive_signal_14,
      lower_end_pos_drive_signal_15
    }
}

MENU Page_EDDL_et_2
{
	LABEL "Trend of travel end position 16-30" "|de|Endlagentrend 16-30";
/*    STYLE WINDOW;*/
	ITEMS
	{
      valve_pos_meas_point_16,
      valve_pos_meas_point_17,
      valve_pos_meas_point_18,
      valve_pos_meas_point_19,
      valve_pos_meas_point_20,
      valve_pos_meas_point_21,
      valve_pos_meas_point_22,
      valve_pos_meas_point_23,
      valve_pos_meas_point_24,
      valve_pos_meas_point_25,
      valve_pos_meas_point_26,
      valve_pos_meas_point_27,
      valve_pos_meas_point_28,
      valve_pos_meas_point_29,
      valve_pos_meas_point_30,
      SEPARATOR,
      lower_end_position_bsz_16,
      lower_end_position_bsz_17,
      lower_end_position_bsz_18,
      lower_end_position_bsz_19,
      lower_end_position_bsz_20,
      lower_end_position_bsz_21,
      lower_end_position_bsz_22,
      lower_end_position_bsz_23,
      lower_end_position_bsz_24,
      lower_end_position_bsz_25,
      lower_end_position_bsz_26,
      lower_end_position_bsz_27,
      lower_end_position_bsz_28,
      lower_end_position_bsz_29,
      lower_end_position_bsz_30,
      SEPARATOR,
      lower_end_pos_drive_signal_16,
      lower_end_pos_drive_signal_17,
      lower_end_pos_drive_signal_18,
      lower_end_pos_drive_signal_19,
      lower_end_pos_drive_signal_20,
      lower_end_pos_drive_signal_21,
      lower_end_pos_drive_signal_22,
      lower_end_pos_drive_signal_23,
      lower_end_pos_drive_signal_24,
      lower_end_pos_drive_signal_25,
      lower_end_pos_drive_signal_26,
      lower_end_pos_drive_signal_27,
      lower_end_pos_drive_signal_28,
      lower_end_pos_drive_signal_29,
      lower_end_pos_drive_signal_30
    }
}



/*----------------- Endlagentrend ------------------------------------*/

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph9
{
	LABEL "Trend of travel end position" "|de|Endlagentrend";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis9;
	MEMBERS
	{
		WAVEFORM9, waveform9;
	}
}

AXIS xaxis9
{
	LABEL "Number of measure points" "|de|Anzahl Messpunkte";
	MIN_VALUE   0;
	MAX_VALUE 30;
	CONSTANT_UNIT "n";
}

AXIS yaxis9
{
	LABEL "x";
	MIN_VALUE  -10;
	MAX_VALUE 10;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform9
{
	Y_AXIS yaxis9;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 30;
		X_VALUES
		{
			aET[1],aET[2],aET[3],aET[4],
			aET[5],aET[6],aET[7],aET[8],aET[9],
			aET[10],aET[11],aET[12],aET[13],aET[14],
			aET[15],aET[16],aET[17],aET[18],aET[19],
			aET[20],aET[21],aET[22],aET[23],aET[24],
			aET[25],aET[26],aET[27],aET[28],aET[29],aET[30]
		}
		Y_VALUES
		{
            valve_pos_meas_point_1,
            valve_pos_meas_point_2,
            valve_pos_meas_point_3,
            valve_pos_meas_point_4,
            valve_pos_meas_point_5,
            valve_pos_meas_point_6,
            valve_pos_meas_point_7,
            valve_pos_meas_point_8,
            valve_pos_meas_point_9,
            valve_pos_meas_point_10,
            valve_pos_meas_point_11,
            valve_pos_meas_point_12,
            valve_pos_meas_point_13,
            valve_pos_meas_point_14,
            valve_pos_meas_point_15,
            valve_pos_meas_point_16,
            valve_pos_meas_point_17,
            valve_pos_meas_point_18,
            valve_pos_meas_point_19,
            valve_pos_meas_point_20,
            valve_pos_meas_point_21,
            valve_pos_meas_point_22,
            valve_pos_meas_point_23,
            valve_pos_meas_point_24,
            valve_pos_meas_point_25,
            valve_pos_meas_point_26,
            valve_pos_meas_point_27,
            valve_pos_meas_point_28,
            valve_pos_meas_point_29,
	        valve_pos_meas_point_30
		}
      }
        INIT_ACTIONS
		{
			methodInitWaveform9
		}
}

ARRAY OF VARIABLE aET
{
	LABEL "endlagentrend[]";
	ELEMENTS
	{
		 1, aET_1;
		 2, aET_2;
		 3, aET_3;
		 4, aET_4;
		 5, aET_5;
		 6, aET_6;
		 7, aET_7;
		 8, aET_8;
		 9, aET_9;
		 10, aET_10;
		 11, aET_11;
		 12, aET_12;
		 13, aET_13;
		 14, aET_14;
		 15, aET_15;
		 16, aET_16;
		 17, aET_17;
		 18, aET_18;
		 19, aET_19;
		 20, aET_20;
		 21, aET_21;
		 22, aET_22;
		 23, aET_23;
		 24, aET_24;
		 25, aET_25;
		 26, aET_26;
		 27, aET_27;
		 28, aET_28;
		 29, aET_29;
		 30, aET_30;

	}
}

VARIABLE aET_1
{
	LABEL "x";
	TYPE FLOAT;
	CLASS LOCAL;
	HANDLING READ;
}
aET_2   LIKE VARIABLE   aET_1 {}
aET_3   LIKE VARIABLE   aET_1 {}
aET_4   LIKE VARIABLE   aET_1 {}
aET_5   LIKE VARIABLE   aET_1 {}
aET_6   LIKE VARIABLE   aET_1 {}
aET_7   LIKE VARIABLE   aET_1 {}
aET_8   LIKE VARIABLE   aET_1 {}
aET_9   LIKE VARIABLE   aET_1 {}
aET_10   LIKE VARIABLE   aET_1 {}
aET_11   LIKE VARIABLE   aET_1 {}
aET_12   LIKE VARIABLE   aET_1 {}
aET_13   LIKE VARIABLE   aET_1 {}
aET_14   LIKE VARIABLE   aET_1 {}
aET_15   LIKE VARIABLE   aET_1 {}
aET_16   LIKE VARIABLE   aET_1 {}
aET_17   LIKE VARIABLE   aET_1 {}
aET_18   LIKE VARIABLE   aET_1 {}
aET_19   LIKE VARIABLE   aET_1 {}
aET_20   LIKE VARIABLE   aET_1 {}
aET_21   LIKE VARIABLE   aET_1 {}
aET_22   LIKE VARIABLE   aET_1 {}
aET_23   LIKE VARIABLE   aET_1 {}
aET_24   LIKE VARIABLE   aET_1 {}
aET_25   LIKE VARIABLE   aET_1 {}
aET_26   LIKE VARIABLE   aET_1 {}
aET_27   LIKE VARIABLE   aET_1 {}
aET_28   LIKE VARIABLE   aET_1 {}
aET_29   LIKE VARIABLE   aET_1 {}
aET_30   LIKE VARIABLE   aET_1 {}

METHOD methodInitWaveform9
{
	LABEL "methodInitWaveform9";
	DEFINITION
	{
		int i;
        float j;
		for( i = 1 ; i < 31 ; i++ )
		{
            j = i;
			assign_float(aET[i], j );
		}
        save_values ();
    }
}

#endif

/**********************************/
/* Diagnose - Testfunktionen HAND */
/**********************************/

/*----------------- Diagramm Stellsignal Stationaer MAN ------------------------------------*/

MENU Page_diag_steady
{
	LABEL "Drive signal diagram steady" "|de|Diagramm Stellsignal y Stationr";
/*     STYLE WINDOW;*/
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph10,
#endif

      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
	  start_abort_drive_signal_diagram_steady,
	  hand_y_stat_test_information,
	  hand_y_stat_step_progress,
      transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,hand_y_stat_wiederholungswerte_1,
      hand_y_stat_wiederholungswerte_2,
      hand_y_stat_wiederholungswerte_3,
      hand_y_stat_wiederholungswerte_4,
      hand_y_stat_wiederholungswerte_5,
      hand_y_stat_wiederholungswerte_6,
      hand_y_stat_wiederholungswerte_7,
      hand_y_stat_wiederholungswerte_8,
      hand_y_stat_wiederholungswerte_9,
      hand_y_stat_wiederholungswerte_10,
      hand_y_stat_wiederholungswerte_11,
      hand_y_stat_wiederholungswerte_12,
      hand_y_stat_wiederholungswerte_13,
      hand_y_stat_wiederholungswerte_14,
      hand_y_stat_wiederholungswerte_15,
      hand_y_stat_wiederholungswerte_16,
      hand_y_stat_wiederholungswerte_17,
      SEPARATOR,
      hand_y_stat_wiederholungswerte_18,
      hand_y_stat_wiederholungswerte_19,
      hand_y_stat_wiederholungswerte_20,
      hand_y_stat_wiederholungswerte_21,
      hand_y_stat_wiederholungswerte_22,
      hand_y_stat_wiederholungswerte_23,
      hand_y_stat_wiederholungswerte_24,
      hand_y_stat_wiederholungswerte_25,

      hand_y_stat_referenzwerte_1,
      hand_y_stat_referenzwerte_2,
      hand_y_stat_referenzwerte_3,
      hand_y_stat_referenzwerte_4,
      hand_y_stat_referenzwerte_5,
      hand_y_stat_referenzwerte_6,
      hand_y_stat_referenzwerte_7,
      hand_y_stat_referenzwerte_8,
      hand_y_stat_referenzwerte_9,
      hand_y_stat_referenzwerte_10,
      hand_y_stat_referenzwerte_11,
      hand_y_stat_referenzwerte_12,
      SEPARATOR,
      hand_y_stat_referenzwerte_13,
      hand_y_stat_referenzwerte_14,
      hand_y_stat_referenzwerte_15,
      hand_y_stat_referenzwerte_16,
      hand_y_stat_referenzwerte_17,
      hand_y_stat_referenzwerte_18,
      hand_y_stat_referenzwerte_19,
      hand_y_stat_referenzwerte_20,
      hand_y_stat_referenzwerte_21,
      hand_y_stat_referenzwerte_22,
      hand_y_stat_referenzwerte_23,
      hand_y_stat_referenzwerte_24,
      hand_y_stat_referenzwerte_25
#endif
  }
}


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_


GRAPH graph10
{
	LABEL "Drive signal diagram steady" "|de|Diagramm Stellsignal y Stationr";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis15;
	MEMBERS
	{
		WAVEFORM15, waveform15;
		WAVEFORM16, waveform16;
	}
}

AXIS xaxis15
{
	LABEL "Valve position x" "|de|Ventilposition x";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis15
{
	LABEL "Drive Signal y Reference" "|de|Stellsignal y Referenz";
	MIN_VALUE  0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

AXIS yaxis16
{
	LABEL "Drive Signal y Repetition" "|de|Stellsignal y Wiederholung";
	MIN_VALUE  0;
	MAX_VALUE 8000;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform15
{
	Y_AXIS yaxis15;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 25;
		X_VALUES
		{
            stat_ref_vs_0,
            stat_ref_vs_1,
            stat_ref_vs_2,
            stat_ref_vs_3,
            stat_ref_vs_4,
            stat_ref_vs_5,
            stat_ref_vs_6,
            stat_ref_vs_7,
            stat_ref_vs_8,
            stat_ref_vs_9,
            stat_ref_vs_10,
            stat_ref_vs_11,
            stat_ref_vs_12,
            stat_ref_vs_13,
            stat_ref_vs_14,
            stat_ref_vs_15,
            stat_ref_vs_16,
            stat_ref_vs_17,
            stat_ref_vs_18,
            stat_ref_vs_19,
            stat_ref_vs_20,
            stat_ref_vs_21,
            stat_ref_vs_22,
            stat_ref_vs_23,
            stat_ref_vs_24
		}
		Y_VALUES
		{
	        hand_y_stat_referenzwerte_1,
	        hand_y_stat_referenzwerte_2,
	        hand_y_stat_referenzwerte_3,
	        hand_y_stat_referenzwerte_4,
	        hand_y_stat_referenzwerte_5,
	        hand_y_stat_referenzwerte_6,
	        hand_y_stat_referenzwerte_7,
	        hand_y_stat_referenzwerte_8,
	        hand_y_stat_referenzwerte_9,
	        hand_y_stat_referenzwerte_10,
	        hand_y_stat_referenzwerte_11,
	        hand_y_stat_referenzwerte_12,
	        hand_y_stat_referenzwerte_13,
	        hand_y_stat_referenzwerte_14,
	        hand_y_stat_referenzwerte_15,
	        hand_y_stat_referenzwerte_16,
	        hand_y_stat_referenzwerte_17,
	        hand_y_stat_referenzwerte_18,
	        hand_y_stat_referenzwerte_19,
	        hand_y_stat_referenzwerte_20,
	        hand_y_stat_referenzwerte_21,
	        hand_y_stat_referenzwerte_22,
	        hand_y_stat_referenzwerte_23,
	        hand_y_stat_referenzwerte_24,
	        hand_y_stat_referenzwerte_25
	  }
  }
}

WAVEFORM waveform16
{
	Y_AXIS yaxis16;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 25;
		X_VALUES
		{
            stat_again_vs_0,
            stat_again_vs_1,
            stat_again_vs_2,
            stat_again_vs_3,
            stat_again_vs_4,
            stat_again_vs_5,
            stat_again_vs_6,
            stat_again_vs_7,
            stat_again_vs_8,
            stat_again_vs_9,
            stat_again_vs_10,
            stat_again_vs_11,
            stat_again_vs_12,
            stat_again_vs_13,
            stat_again_vs_14,
            stat_again_vs_15,
            stat_again_vs_16,
            stat_again_vs_17,
            stat_again_vs_18,
            stat_again_vs_19,
            stat_again_vs_20,
            stat_again_vs_21,
            stat_again_vs_22,
            stat_again_vs_23,
            stat_again_vs_24
		}
		Y_VALUES
		{
	        hand_y_stat_wiederholungswerte_1,
	        hand_y_stat_wiederholungswerte_2,
	        hand_y_stat_wiederholungswerte_3,
	        hand_y_stat_wiederholungswerte_4,
	        hand_y_stat_wiederholungswerte_5,
	        hand_y_stat_wiederholungswerte_6,
	        hand_y_stat_wiederholungswerte_7,
	        hand_y_stat_wiederholungswerte_8,
	        hand_y_stat_wiederholungswerte_9,
	        hand_y_stat_wiederholungswerte_10,
	        hand_y_stat_wiederholungswerte_11,
	        hand_y_stat_wiederholungswerte_12,
	        hand_y_stat_wiederholungswerte_13,
	        hand_y_stat_wiederholungswerte_14,
	        hand_y_stat_wiederholungswerte_15,
	        hand_y_stat_wiederholungswerte_16,
	        hand_y_stat_wiederholungswerte_17,
	        hand_y_stat_wiederholungswerte_18,
	        hand_y_stat_wiederholungswerte_19,
	        hand_y_stat_wiederholungswerte_20,
	        hand_y_stat_wiederholungswerte_21,
	        hand_y_stat_wiederholungswerte_22,
	        hand_y_stat_wiederholungswerte_23,
	        hand_y_stat_wiederholungswerte_24,
	        hand_y_stat_wiederholungswerte_25
	  }
  }
}

#endif

/*----------------- Diagramm Stellsignal Hysterese MAN ------------------------------------*/

MENU Page_diag_hysteresis
{
	LABEL "Drive signal diagram hysteresis" "|de|Diagramm Stellsignal y Hysterese";
/*     STYLE WINDOW;*/
   ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph11,
#endif

      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
	  start_abort_drive_signal_diagram_hysteresis,
	  hand_y_hys_test_information,
	  hand_y_hys_step_progress,
      transmit_button

/* nur wenn keine enhanced-Unterstuetzung ! (PDM < 6.0 SP2) */
#ifndef _V602_
     ,SEPARATOR,
      hand_y_hys_wiederholungswerte_1,
      hand_y_hys_wiederholungswerte_2,
      hand_y_hys_wiederholungswerte_3,
      hand_y_hys_wiederholungswerte_4,
      hand_y_hys_wiederholungswerte_5,
      hand_y_hys_wiederholungswerte_6,
      hand_y_hys_wiederholungswerte_7,
      hand_y_hys_wiederholungswerte_8,
      hand_y_hys_wiederholungswerte_9,
      hand_y_hys_wiederholungswerte_10,
      hand_y_hys_wiederholungswerte_11,
      hand_y_hys_wiederholungswerte_12,
      SEPARATOR,
      hand_y_hys_referenzwerte_1,
      hand_y_hys_referenzwerte_2,
      hand_y_hys_referenzwerte_3,
      hand_y_hys_referenzwerte_4,
      hand_y_hys_referenzwerte_5,
      hand_y_hys_referenzwerte_6,
      hand_y_hys_referenzwerte_7,
      hand_y_hys_referenzwerte_8,
      hand_y_hys_referenzwerte_9,
      hand_y_hys_referenzwerte_10,
      hand_y_hys_referenzwerte_11,
      hand_y_hys_referenzwerte_12
#endif
  }
}


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_


GRAPH graph11
{
	LABEL "Drive signal diagram hysteresis" "|de|Diagramm Stellsignal y Hysterese";
	HEIGHT X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS xaxis15;
	MEMBERS
	{
		WAVEFORM17, waveform17;
		WAVEFORM18, waveform18;
	}
}

AXIS yaxis17
{
	LABEL "Drive Signal y Reference" "|de|Stellsignal y Referenz";
	MIN_VALUE  0;
	MAX_VALUE 500;
	CONSTANT_UNIT "1/s";
}

AXIS yaxis18
{
	LABEL "Drive Signal y Repetition" "|de|Stellsignal y Wiederholung";
	MIN_VALUE  0;
	MAX_VALUE 500;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform17
{
	Y_AXIS yaxis17;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 12;
		X_VALUES
		{
			hys_ref_vs_0,
			hys_ref_vs_1,
			hys_ref_vs_2,
			hys_ref_vs_3,
			hys_ref_vs_4,
			hys_ref_vs_5,
			hys_ref_vs_6,
			hys_ref_vs_7,
			hys_ref_vs_8,
			hys_ref_vs_9,
			hys_ref_vs_10,
			hys_ref_vs_11
		}
		Y_VALUES
		{
	        hand_y_hys_referenzwerte_1,
	        hand_y_hys_referenzwerte_2,
	        hand_y_hys_referenzwerte_3,
	        hand_y_hys_referenzwerte_4,
	        hand_y_hys_referenzwerte_5,
	        hand_y_hys_referenzwerte_6,
	        hand_y_hys_referenzwerte_7,
	        hand_y_hys_referenzwerte_8,
	        hand_y_hys_referenzwerte_9,
	        hand_y_hys_referenzwerte_10,
	        hand_y_hys_referenzwerte_11,
	        hand_y_hys_referenzwerte_12
	  }
  }
}

WAVEFORM waveform18
{
	Y_AXIS yaxis18;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 12;
		X_VALUES
		{
			hys_ref_vs_0,
			hys_ref_vs_1,
			hys_ref_vs_2,
			hys_ref_vs_3,
			hys_ref_vs_4,
			hys_ref_vs_5,
			hys_ref_vs_6,
			hys_ref_vs_7,
			hys_ref_vs_8,
			hys_ref_vs_9,
			hys_ref_vs_10,
			hys_ref_vs_11
		}
		Y_VALUES
		{
	        hand_y_hys_wiederholungswerte_1,
	        hand_y_hys_wiederholungswerte_2,
	        hand_y_hys_wiederholungswerte_3,
	        hand_y_hys_wiederholungswerte_4,
	        hand_y_hys_wiederholungswerte_5,
	        hand_y_hys_wiederholungswerte_6,
	        hand_y_hys_wiederholungswerte_7,
	        hand_y_hys_wiederholungswerte_8,
	        hand_y_hys_wiederholungswerte_9,
	        hand_y_hys_wiederholungswerte_10,
	        hand_y_hys_wiederholungswerte_11,
	        hand_y_hys_wiederholungswerte_12
	  }
  }
}

#endif

/*----------------- Diagramm Statische Kennlinie MAN ------------------------------------*/

MENU Page_diag_stat_char_1
{
	LABEL "Static characteristic" "|de|Statische Kennlinie";
/*     STYLE WINDOW;*/
    ITEMS
	{
        /* Wenn PST Regler */
        IF ( diag_level == DIAG_LEVEL_PST )
        {
          input_pst_enabling_code,
        }
        kl_stepstart,
        kl_stepend,
        kl_delay_time_after_step,
        kl_anzahl_bis_umkehr,
        transmit_button,
		SEPARATOR,
		kl_step_height,
		kl_min_dead_band,
		kl_average_dead_band,
		kl_max_dead_band
  }
}

MENU Page_diag_stat_char_2
{
	LABEL "Static characteristic measurement" "|de|Statische Kennlinie Messung";
/*     STYLE WINDOW;*/
    ITEMS
	{
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
	  graph12,
      /* Manuelles Einlesen der Daten: */
	  method_LOAD_static_characteristic,
#endif
      /* Wenn PST Regler */
      IF ( diag_level == DIAG_LEVEL_PST )
      {
        input_pst_enabling_code,
      }
	  start_abort_static_characteristic,
	  kl_step_progress,
      transmit_button
  }
}

VARIABLE LOAD_static_characteristic
{
  LABEL    " ";
  CLASS    LOCAL;
  HANDLING READ & WRITE;
  TYPE     ENUMERATED (1)
  {
    DEFAULT_VALUE	 0;
  }
}

METHOD method_LOAD_static_characteristic
{
	LABEL   "Load 'static characteristic' graph data" "|de|Lade 'Statische Kennlinie' Grafik - Daten";
    DEFINITION
    {
        float f_read_local;

        XMTR_IGNORE_ALL_COMM_STATUS();
        XMTR_IGNORE_ALL_DEVICE_STATUS();
        XMTR_IGNORE_ALL_RESPONSE_CODES();
        XMTR_IGNORE_COMM_ERROR();

        IGNORE_ALL_COMM_STATUS();
        IGNORE_ALL_DEVICE_STATUS();
        IGNORE_ALL_RESPONSE_CODES();
        IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        DELAY(2,"reading data... (Progress: 0 percent )" "|de|Daten werden gelesen... (Fortschritt: 0 Prozent )");

        iassign(cmd_index_1, 500);
	    iassign(cmd_index_2, 600);
	    iassign(cmd_index_3, 533);
	    iassign(cmd_index_4, 633);
	    iassign(cmd_index_5, 566);
	    iassign(cmd_index_6, 666);
		send_command_trans(152,6);

        /* Einlesen der 3 x 2 X 33 Werte: */
		send_command_trans(156,1);

        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_0 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_0 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_33 , f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_33 , f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_66 , f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_66 , f_read_local);

        send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_1 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_1 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_34 , f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_34 , f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_67 , f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_67 , f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_2 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_2 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_35 , f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_35 , f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_68 , f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_68 , f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_3 , f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_3 , f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_36, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_36, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_69, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_69, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_4, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_4, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_37, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_37, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_70, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_70, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_5, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_5, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_38, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_38, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_71, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_71, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_6, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_6, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_39, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_39, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_72, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_72, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_7, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_7, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_40, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_40, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_73, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_73, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_8, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_8, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_41, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_41, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_74, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_74, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_9, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_9, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_42, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_42, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_75, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_75, f_read_local);

        DELAY(2,"reading data... (Progress: 33 percent )" "|de|Daten werden gelesen... (Fortschritt: 33 Prozent )");

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_10, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_10, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_43, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_43, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_76, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_76, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_11, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_11, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_44, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_44, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_77, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_77, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_12, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_12, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_45, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_45, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_78, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_78, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_13, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_13, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_46, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_46, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_79, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_79, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_14, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_14, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_47, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_47, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_80, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_80, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_15, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_15, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_48, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_48, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_81, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_81, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_16, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_16, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_49, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_49, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_82, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_82, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_17, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_17, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_50, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_50, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_83, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_83, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_18, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_18, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_51, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_51, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_84, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_84, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_19, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_19, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_52, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_52, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_85, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_85, f_read_local);

        DELAY(2,"reading data... (Progress: 66 percent )" "|de|Daten werden gelesen... (Fortschritt: 66 Prozent )");

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_20, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_20, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_53, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_53, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_86, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_86, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_21, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_21, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_54, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_54, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_87, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_87, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_22, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_22, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_55, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_55, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_88, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_88, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_23, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_23, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_56, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_56, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_89, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_89, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_24, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_24, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_57, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_57, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_90, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_90, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_25, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_25, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_58, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_58, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_91, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_91, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_26, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_26, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_59, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_59, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_92, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_92, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_27, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_27, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_60, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_60, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_93, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_93, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_28, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_28, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_61, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_61, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_94, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_94, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_29, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_29, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_62, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_62, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_95, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_95, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_30, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_30, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_63, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_63, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_96, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_96, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_31, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_31, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_64, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_64, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_97, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_97, f_read_local);

		send_command_trans(156,1);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_32, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_32, f_read_local);
        f_read_local = fvar_value(f_read_3);
        fassign(stat_kl_vs_65, f_read_local);
        f_read_local = fvar_value(f_read_4);
        fassign(stat_kl_sw_65, f_read_local);
        f_read_local = fvar_value(f_read_5);
        fassign(stat_kl_vs_98, f_read_local);
        f_read_local = fvar_value(f_read_6);
        fassign(stat_kl_sw_98, f_read_local);

		send_command_trans(157,84);
        f_read_local = fvar_value(f_read_1);
        fassign(stat_kl_vs_99, f_read_local);
        f_read_local = fvar_value(f_read_2);
        fassign(stat_kl_sw_99, f_read_local);

        /* damit Daten ausserhalb der Methode gueltig */
        save_values();

        DELAY(2,"Data were read." "|de|Daten wurden eingelesen.");
    }

    HELP     "Load data for this graph."
             "|de|Laden der Daten fr diesen Graph.";
}


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph12
{
	LABEL "Static characteristic" "|de|Statische Kennlinie";
	HEIGHT X_LARGE;
	WIDTH  X_LARGE;
	X_AXIS xaxis16;
	MEMBERS
	{
		WAVEFORM19, waveform19;
	}
}

AXIS xaxis16
{
	LABEL "Reference variable w" "|de|Fhrungsgre w";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis19
{
	LABEL "Valve position x" "|de|Ventilposition x";
	MIN_VALUE  0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

WAVEFORM waveform19
{
	Y_AXIS yaxis19;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			stat_kl_sw_0,
            stat_kl_sw_1,
            stat_kl_sw_2,
            stat_kl_sw_3,
            stat_kl_sw_4,
            stat_kl_sw_5,
            stat_kl_sw_6,
            stat_kl_sw_7,
            stat_kl_sw_8,
            stat_kl_sw_9,
            stat_kl_sw_10,
            stat_kl_sw_11,
            stat_kl_sw_12,
            stat_kl_sw_13,
            stat_kl_sw_14,
            stat_kl_sw_15,
            stat_kl_sw_16,
            stat_kl_sw_17,
            stat_kl_sw_18,
            stat_kl_sw_19,
            stat_kl_sw_20,
            stat_kl_sw_21,
            stat_kl_sw_22,
            stat_kl_sw_23,
            stat_kl_sw_24,
            stat_kl_sw_25,
            stat_kl_sw_26,
            stat_kl_sw_27,
            stat_kl_sw_28,
            stat_kl_sw_29,
            stat_kl_sw_30,
            stat_kl_sw_31,
            stat_kl_sw_32,
            stat_kl_sw_33,
            stat_kl_sw_34,
            stat_kl_sw_35,
            stat_kl_sw_36,
            stat_kl_sw_37,
            stat_kl_sw_38,
            stat_kl_sw_39,
            stat_kl_sw_40,
            stat_kl_sw_41,
            stat_kl_sw_42,
            stat_kl_sw_43,
            stat_kl_sw_44,
            stat_kl_sw_45,
            stat_kl_sw_46,
            stat_kl_sw_47,
            stat_kl_sw_48,
            stat_kl_sw_49,
            stat_kl_sw_50,
            stat_kl_sw_51,
            stat_kl_sw_52,
            stat_kl_sw_53,
            stat_kl_sw_54,
            stat_kl_sw_55,
            stat_kl_sw_56,
            stat_kl_sw_57,
            stat_kl_sw_58,
            stat_kl_sw_59,
            stat_kl_sw_60,
            stat_kl_sw_61,
            stat_kl_sw_62,
            stat_kl_sw_63,
            stat_kl_sw_64,
            stat_kl_sw_65,
            stat_kl_sw_66,
            stat_kl_sw_67,
            stat_kl_sw_68,
            stat_kl_sw_69,
            stat_kl_sw_70,
            stat_kl_sw_71,
            stat_kl_sw_72,
            stat_kl_sw_73,
            stat_kl_sw_74,
            stat_kl_sw_75,
            stat_kl_sw_76,
            stat_kl_sw_77,
            stat_kl_sw_78,
            stat_kl_sw_79,
            stat_kl_sw_80,
            stat_kl_sw_81,
            stat_kl_sw_82,
            stat_kl_sw_83,
            stat_kl_sw_84,
            stat_kl_sw_85,
            stat_kl_sw_86,
            stat_kl_sw_87,
            stat_kl_sw_88,
            stat_kl_sw_89,
            stat_kl_sw_90,
            stat_kl_sw_91,
            stat_kl_sw_92,
            stat_kl_sw_93,
            stat_kl_sw_94,
            stat_kl_sw_95,
            stat_kl_sw_96,
            stat_kl_sw_97,
            stat_kl_sw_98,
            stat_kl_sw_99
		}
		Y_VALUES
		{
	        stat_kl_vs_0,
            stat_kl_vs_1,
            stat_kl_vs_2,
            stat_kl_vs_3,
            stat_kl_vs_4,
            stat_kl_vs_5,
            stat_kl_vs_6,
            stat_kl_vs_7,
            stat_kl_vs_8,
            stat_kl_vs_9,
            stat_kl_vs_10,
            stat_kl_vs_11,
            stat_kl_vs_12,
            stat_kl_vs_13,
            stat_kl_vs_14,
            stat_kl_vs_15,
            stat_kl_vs_16,
            stat_kl_vs_17,
            stat_kl_vs_18,
            stat_kl_vs_19,
            stat_kl_vs_20,
            stat_kl_vs_21,
            stat_kl_vs_22,
            stat_kl_vs_23,
            stat_kl_vs_24,
            stat_kl_vs_25,
            stat_kl_vs_26,
            stat_kl_vs_27,
            stat_kl_vs_28,
            stat_kl_vs_29,
            stat_kl_vs_30,
            stat_kl_vs_31,
            stat_kl_vs_32,
            stat_kl_vs_33,
            stat_kl_vs_34,
            stat_kl_vs_35,
            stat_kl_vs_36,
            stat_kl_vs_37,
            stat_kl_vs_38,
            stat_kl_vs_39,
            stat_kl_vs_40,
            stat_kl_vs_41,
            stat_kl_vs_42,
            stat_kl_vs_43,
            stat_kl_vs_44,
            stat_kl_vs_45,
            stat_kl_vs_46,
            stat_kl_vs_47,
            stat_kl_vs_48,
            stat_kl_vs_49,
            stat_kl_vs_50,
            stat_kl_vs_51,
            stat_kl_vs_52,
            stat_kl_vs_53,
            stat_kl_vs_54,
            stat_kl_vs_55,
            stat_kl_vs_56,
            stat_kl_vs_57,
            stat_kl_vs_58,
            stat_kl_vs_59,
            stat_kl_vs_60,
            stat_kl_vs_61,
            stat_kl_vs_62,
            stat_kl_vs_63,
            stat_kl_vs_64,
            stat_kl_vs_65,
            stat_kl_vs_66,
            stat_kl_vs_67,
            stat_kl_vs_68,
            stat_kl_vs_69,
            stat_kl_vs_70,
            stat_kl_vs_71,
            stat_kl_vs_72,
            stat_kl_vs_73,
            stat_kl_vs_74,
            stat_kl_vs_75,
            stat_kl_vs_76,
            stat_kl_vs_77,
            stat_kl_vs_78,
            stat_kl_vs_79,
            stat_kl_vs_80,
            stat_kl_vs_81,
            stat_kl_vs_82,
            stat_kl_vs_83,
            stat_kl_vs_84,
            stat_kl_vs_85,
            stat_kl_vs_86,
            stat_kl_vs_87,
            stat_kl_vs_88,
            stat_kl_vs_89,
            stat_kl_vs_90,
            stat_kl_vs_91,
            stat_kl_vs_92,
            stat_kl_vs_93,
            stat_kl_vs_94,
            stat_kl_vs_95,
            stat_kl_vs_96,
            stat_kl_vs_97,
            stat_kl_vs_98,
            stat_kl_vs_99
	  }
  }
}

#endif

/*----------------- Diagramm Sprungantwort MAN ------------------------------------*/

MENU Page_step_response_1
{
    LABEL     "Step response" "|de|Sprungantwort";
    ITEMS
    {
        stepstart,
        stepend,
        step_sample_rate,
        latency_after_step,
        step_selection,
	    duration_of_test,
	    transmit_button,
	    SEPARATOR,
  	    overshoot_rising,
		dead_time_rising,
		time_63_rising,
		time_98_rising,
	    rise_time_rising_step,
	    settling_time_rising_step,
	    SEPARATOR,
		overshoot_falling,
		dead_time_falling,
		time_63_falling,
		time_98_falling,
		rise_time_falling_step,
	    settling_time_falling_step
    }
}

/* Sprungantwort ************************************************************/
MENU Page_step_response_2
{
    LABEL     "Step response measurement" "|de|Sprungantwort Messung";
    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
        graph13,
        /* Manuelles Einlesen der Daten per Methode: */
        read_step_response_data,
#endif
        start_abort_step_response_test,
        step_progress,
        transmit_button
    }
}


/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_

GRAPH graph13
{
    LABEL   "Step response" "|de|Sprungantwort";
	HEIGHT  X_LARGE;
	WIDTH	X_LARGE;
	X_AXIS  xaxis17;
	MEMBERS
	{
		WAVEFORM20, waveform20;
		WAVEFORM21, waveform21;
		WAVEFORM22, waveform22;
		WAVEFORM23, waveform23;
	}
}

AXIS xaxis17
{
	LABEL "Time t" "|de|Zeit t";
	MIN_VALUE   0;
	MAX_VALUE 100;
	CONSTANT_UNIT "1/10 s";
}

AXIS yaxis20
{
	LABEL "Reference variable w" "|de|Fhrungsgre w";
	MIN_VALUE  0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis21
{
	LABEL "Setpoint deviation e" "|de|Regelabweichung e";
	MIN_VALUE  0;
	MAX_VALUE 100;
	CONSTANT_UNIT "%";
}

AXIS yaxis22
{
	LABEL "Drive signal y" "|de|Stellsignal y";
	MIN_VALUE  0;
	MAX_VALUE 10000;
	CONSTANT_UNIT "1/s";
}

WAVEFORM waveform20
{
	Y_AXIS yaxis19;
    EMPHASIS TRUE;
    LINE_COLOR 0xFF0000 ;   /* Farbe Blau */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			sprung_t_0,
            sprung_t_1,
            sprung_t_2,
            sprung_t_3,
            sprung_t_4,
            sprung_t_5,
            sprung_t_6,
            sprung_t_7,
            sprung_t_8,
            sprung_t_9,
            sprung_t_10,
            sprung_t_11,
            sprung_t_12,
            sprung_t_13,
            sprung_t_14,
            sprung_t_15,
            sprung_t_16,
            sprung_t_17,
            sprung_t_18,
            sprung_t_19,
            sprung_t_20,
            sprung_t_21,
            sprung_t_22,
            sprung_t_23,
            sprung_t_24,
            sprung_t_25,
            sprung_t_26,
            sprung_t_27,
            sprung_t_28,
            sprung_t_29,
            sprung_t_30,
            sprung_t_31,
            sprung_t_32,
            sprung_t_33,
            sprung_t_34,
            sprung_t_35,
            sprung_t_36,
            sprung_t_37,
            sprung_t_38,
            sprung_t_39,
            sprung_t_40,
            sprung_t_41,
            sprung_t_42,
            sprung_t_43,
            sprung_t_44,
            sprung_t_45,
            sprung_t_46,
            sprung_t_47,
            sprung_t_48,
            sprung_t_49,
            sprung_t_50,
            sprung_t_51,
            sprung_t_52,
            sprung_t_53,
            sprung_t_54,
            sprung_t_55,
            sprung_t_56,
            sprung_t_57,
            sprung_t_58,
            sprung_t_59,
            sprung_t_60,
            sprung_t_61,
            sprung_t_62,
            sprung_t_63,
            sprung_t_64,
            sprung_t_65,
            sprung_t_66,
            sprung_t_67,
            sprung_t_68,
            sprung_t_69,
            sprung_t_70,
            sprung_t_71,
            sprung_t_72,
            sprung_t_73,
            sprung_t_74,
            sprung_t_75,
            sprung_t_76,
            sprung_t_77,
            sprung_t_78,
            sprung_t_79,
            sprung_t_80,
            sprung_t_81,
            sprung_t_82,
            sprung_t_83,
            sprung_t_84,
            sprung_t_85,
            sprung_t_86,
            sprung_t_87,
            sprung_t_88,
            sprung_t_89,
            sprung_t_90,
            sprung_t_91,
            sprung_t_92,
            sprung_t_93,
            sprung_t_94,
            sprung_t_95,
            sprung_t_96,
            sprung_t_97,
            sprung_t_98,
            sprung_t_99
		}
		Y_VALUES
		{
	        sprung_vs_0,
            sprung_vs_1,
            sprung_vs_2,
            sprung_vs_3,
            sprung_vs_4,
            sprung_vs_5,
            sprung_vs_6,
            sprung_vs_7,
            sprung_vs_8,
            sprung_vs_9,
            sprung_vs_10,
            sprung_vs_11,
            sprung_vs_12,
            sprung_vs_13,
            sprung_vs_14,
            sprung_vs_15,
            sprung_vs_16,
            sprung_vs_17,
            sprung_vs_18,
            sprung_vs_19,
            sprung_vs_20,
            sprung_vs_21,
            sprung_vs_22,
            sprung_vs_23,
            sprung_vs_24,
            sprung_vs_25,
            sprung_vs_26,
            sprung_vs_27,
            sprung_vs_28,
            sprung_vs_29,
            sprung_vs_30,
            sprung_vs_31,
            sprung_vs_32,
            sprung_vs_33,
            sprung_vs_34,
            sprung_vs_35,
            sprung_vs_36,
            sprung_vs_37,
            sprung_vs_38,
            sprung_vs_39,
            sprung_vs_40,
            sprung_vs_41,
            sprung_vs_42,
            sprung_vs_43,
            sprung_vs_44,
            sprung_vs_45,
            sprung_vs_46,
            sprung_vs_47,
            sprung_vs_48,
            sprung_vs_49,
            sprung_vs_50,
            sprung_vs_51,
            sprung_vs_52,
            sprung_vs_53,
            sprung_vs_54,
            sprung_vs_55,
            sprung_vs_56,
            sprung_vs_57,
            sprung_vs_58,
            sprung_vs_59,
            sprung_vs_60,
            sprung_vs_61,
            sprung_vs_62,
            sprung_vs_63,
            sprung_vs_64,
            sprung_vs_65,
            sprung_vs_66,
            sprung_vs_67,
            sprung_vs_68,
            sprung_vs_69,
            sprung_vs_70,
            sprung_vs_71,
            sprung_vs_72,
            sprung_vs_73,
            sprung_vs_74,
            sprung_vs_75,
            sprung_vs_76,
            sprung_vs_77,
            sprung_vs_78,
            sprung_vs_79,
            sprung_vs_80,
            sprung_vs_81,
            sprung_vs_82,
            sprung_vs_83,
            sprung_vs_84,
            sprung_vs_85,
            sprung_vs_86,
            sprung_vs_87,
            sprung_vs_88,
            sprung_vs_89,
            sprung_vs_90,
            sprung_vs_91,
            sprung_vs_92,
            sprung_vs_93,
            sprung_vs_94,
            sprung_vs_95,
            sprung_vs_96,
            sprung_vs_97,
            sprung_vs_98,
            sprung_vs_99
	  }
  }
}

WAVEFORM waveform21
{
	Y_AXIS yaxis20;
    EMPHASIS TRUE;
    LINE_COLOR 0x0000FF ;   /* Farbe Rot */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			sprung_t_0,
            sprung_t_1,
            sprung_t_2,
            sprung_t_3,
            sprung_t_4,
            sprung_t_5,
            sprung_t_6,
            sprung_t_7,
            sprung_t_8,
            sprung_t_9,
            sprung_t_10,
            sprung_t_11,
            sprung_t_12,
            sprung_t_13,
            sprung_t_14,
            sprung_t_15,
            sprung_t_16,
            sprung_t_17,
            sprung_t_18,
            sprung_t_19,
            sprung_t_20,
            sprung_t_21,
            sprung_t_22,
            sprung_t_23,
            sprung_t_24,
            sprung_t_25,
            sprung_t_26,
            sprung_t_27,
            sprung_t_28,
            sprung_t_29,
            sprung_t_30,
            sprung_t_31,
            sprung_t_32,
            sprung_t_33,
            sprung_t_34,
            sprung_t_35,
            sprung_t_36,
            sprung_t_37,
            sprung_t_38,
            sprung_t_39,
            sprung_t_40,
            sprung_t_41,
            sprung_t_42,
            sprung_t_43,
            sprung_t_44,
            sprung_t_45,
            sprung_t_46,
            sprung_t_47,
            sprung_t_48,
            sprung_t_49,
            sprung_t_50,
            sprung_t_51,
            sprung_t_52,
            sprung_t_53,
            sprung_t_54,
            sprung_t_55,
            sprung_t_56,
            sprung_t_57,
            sprung_t_58,
            sprung_t_59,
            sprung_t_60,
            sprung_t_61,
            sprung_t_62,
            sprung_t_63,
            sprung_t_64,
            sprung_t_65,
            sprung_t_66,
            sprung_t_67,
            sprung_t_68,
            sprung_t_69,
            sprung_t_70,
            sprung_t_71,
            sprung_t_72,
            sprung_t_73,
            sprung_t_74,
            sprung_t_75,
            sprung_t_76,
            sprung_t_77,
            sprung_t_78,
            sprung_t_79,
            sprung_t_80,
            sprung_t_81,
            sprung_t_82,
            sprung_t_83,
            sprung_t_84,
            sprung_t_85,
            sprung_t_86,
            sprung_t_87,
            sprung_t_88,
            sprung_t_89,
            sprung_t_90,
            sprung_t_91,
            sprung_t_92,
            sprung_t_93,
            sprung_t_94,
            sprung_t_95,
            sprung_t_96,
            sprung_t_97,
            sprung_t_98,
            sprung_t_99
		}
		Y_VALUES
		{
	        sprung_sw_0,
            sprung_sw_1,
            sprung_sw_2,
            sprung_sw_3,
            sprung_sw_4,
            sprung_sw_5,
            sprung_sw_6,
            sprung_sw_7,
            sprung_sw_8,
            sprung_sw_9,
            sprung_sw_10,
            sprung_sw_11,
            sprung_sw_12,
            sprung_sw_13,
            sprung_sw_14,
            sprung_sw_15,
            sprung_sw_16,
            sprung_sw_17,
            sprung_sw_18,
            sprung_sw_19,
            sprung_sw_20,
            sprung_sw_21,
            sprung_sw_22,
            sprung_sw_23,
            sprung_sw_24,
            sprung_sw_25,
            sprung_sw_26,
            sprung_sw_27,
            sprung_sw_28,
            sprung_sw_29,
            sprung_sw_30,
            sprung_sw_31,
            sprung_sw_32,
            sprung_sw_33,
            sprung_sw_34,
            sprung_sw_35,
            sprung_sw_36,
            sprung_sw_37,
            sprung_sw_38,
            sprung_sw_39,
            sprung_sw_40,
            sprung_sw_41,
            sprung_sw_42,
            sprung_sw_43,
            sprung_sw_44,
            sprung_sw_45,
            sprung_sw_46,
            sprung_sw_47,
            sprung_sw_48,
            sprung_sw_49,
            sprung_sw_50,
            sprung_sw_51,
            sprung_sw_52,
            sprung_sw_53,
            sprung_sw_54,
            sprung_sw_55,
            sprung_sw_56,
            sprung_sw_57,
            sprung_sw_58,
            sprung_sw_59,
            sprung_sw_60,
            sprung_sw_61,
            sprung_sw_62,
            sprung_sw_63,
            sprung_sw_64,
            sprung_sw_65,
            sprung_sw_66,
            sprung_sw_67,
            sprung_sw_68,
            sprung_sw_69,
            sprung_sw_70,
            sprung_sw_71,
            sprung_sw_72,
            sprung_sw_73,
            sprung_sw_74,
            sprung_sw_75,
            sprung_sw_76,
            sprung_sw_77,
            sprung_sw_78,
            sprung_sw_79,
            sprung_sw_80,
            sprung_sw_81,
            sprung_sw_82,
            sprung_sw_83,
            sprung_sw_84,
            sprung_sw_85,
            sprung_sw_86,
            sprung_sw_87,
            sprung_sw_88,
            sprung_sw_89,
            sprung_sw_90,
            sprung_sw_91,
            sprung_sw_92,
            sprung_sw_93,
            sprung_sw_94,
            sprung_sw_95,
            sprung_sw_96,
            sprung_sw_97,
            sprung_sw_98,
            sprung_sw_99
	  }
  }
}

WAVEFORM waveform22
{
	Y_AXIS yaxis21;
    EMPHASIS TRUE;
    LINE_COLOR 0x00BE00 ;   /* Farbe Gruen */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			sprung_t_0,
            sprung_t_1,
            sprung_t_2,
            sprung_t_3,
            sprung_t_4,
            sprung_t_5,
            sprung_t_6,
            sprung_t_7,
            sprung_t_8,
            sprung_t_9,
            sprung_t_10,
            sprung_t_11,
            sprung_t_12,
            sprung_t_13,
            sprung_t_14,
            sprung_t_15,
            sprung_t_16,
            sprung_t_17,
            sprung_t_18,
            sprung_t_19,
            sprung_t_20,
            sprung_t_21,
            sprung_t_22,
            sprung_t_23,
            sprung_t_24,
            sprung_t_25,
            sprung_t_26,
            sprung_t_27,
            sprung_t_28,
            sprung_t_29,
            sprung_t_30,
            sprung_t_31,
            sprung_t_32,
            sprung_t_33,
            sprung_t_34,
            sprung_t_35,
            sprung_t_36,
            sprung_t_37,
            sprung_t_38,
            sprung_t_39,
            sprung_t_40,
            sprung_t_41,
            sprung_t_42,
            sprung_t_43,
            sprung_t_44,
            sprung_t_45,
            sprung_t_46,
            sprung_t_47,
            sprung_t_48,
            sprung_t_49,
            sprung_t_50,
            sprung_t_51,
            sprung_t_52,
            sprung_t_53,
            sprung_t_54,
            sprung_t_55,
            sprung_t_56,
            sprung_t_57,
            sprung_t_58,
            sprung_t_59,
            sprung_t_60,
            sprung_t_61,
            sprung_t_62,
            sprung_t_63,
            sprung_t_64,
            sprung_t_65,
            sprung_t_66,
            sprung_t_67,
            sprung_t_68,
            sprung_t_69,
            sprung_t_70,
            sprung_t_71,
            sprung_t_72,
            sprung_t_73,
            sprung_t_74,
            sprung_t_75,
            sprung_t_76,
            sprung_t_77,
            sprung_t_78,
            sprung_t_79,
            sprung_t_80,
            sprung_t_81,
            sprung_t_82,
            sprung_t_83,
            sprung_t_84,
            sprung_t_85,
            sprung_t_86,
            sprung_t_87,
            sprung_t_88,
            sprung_t_89,
            sprung_t_90,
            sprung_t_91,
            sprung_t_92,
            sprung_t_93,
            sprung_t_94,
            sprung_t_95,
            sprung_t_96,
            sprung_t_97,
            sprung_t_98,
            sprung_t_99
		}
		Y_VALUES
		{
	        sprung_e_0,
            sprung_e_1,
            sprung_e_2,
            sprung_e_3,
            sprung_e_4,
            sprung_e_5,
            sprung_e_6,
            sprung_e_7,
            sprung_e_8,
            sprung_e_9,
            sprung_e_10,
            sprung_e_11,
            sprung_e_12,
            sprung_e_13,
            sprung_e_14,
            sprung_e_15,
            sprung_e_16,
            sprung_e_17,
            sprung_e_18,
            sprung_e_19,
            sprung_e_20,
            sprung_e_21,
            sprung_e_22,
            sprung_e_23,
            sprung_e_24,
            sprung_e_25,
            sprung_e_26,
            sprung_e_27,
            sprung_e_28,
            sprung_e_29,
            sprung_e_30,
            sprung_e_31,
            sprung_e_32,
            sprung_e_33,
            sprung_e_34,
            sprung_e_35,
            sprung_e_36,
            sprung_e_37,
            sprung_e_38,
            sprung_e_39,
            sprung_e_40,
            sprung_e_41,
            sprung_e_42,
            sprung_e_43,
            sprung_e_44,
            sprung_e_45,
            sprung_e_46,
            sprung_e_47,
            sprung_e_48,
            sprung_e_49,
            sprung_e_50,
            sprung_e_51,
            sprung_e_52,
            sprung_e_53,
            sprung_e_54,
            sprung_e_55,
            sprung_e_56,
            sprung_e_57,
            sprung_e_58,
            sprung_e_59,
            sprung_e_60,
            sprung_e_61,
            sprung_e_62,
            sprung_e_63,
            sprung_e_64,
            sprung_e_65,
            sprung_e_66,
            sprung_e_67,
            sprung_e_68,
            sprung_e_69,
            sprung_e_70,
            sprung_e_71,
            sprung_e_72,
            sprung_e_73,
            sprung_e_74,
            sprung_e_75,
            sprung_e_76,
            sprung_e_77,
            sprung_e_78,
            sprung_e_79,
            sprung_e_80,
            sprung_e_81,
            sprung_e_82,
            sprung_e_83,
            sprung_e_84,
            sprung_e_85,
            sprung_e_86,
            sprung_e_87,
            sprung_e_88,
            sprung_e_89,
            sprung_e_90,
            sprung_e_91,
            sprung_e_92,
            sprung_e_93,
            sprung_e_94,
            sprung_e_95,
            sprung_e_96,
            sprung_e_97,
            sprung_e_98,
            sprung_e_99
	  }
  }
}

WAVEFORM waveform23
{
	Y_AXIS yaxis22;
    EMPHASIS TRUE;
    LINE_COLOR 0x00b3df ;   /* Farbe Gelbbraun */
	TYPE XY
	{
		NUMBER_OF_POINTS 100;
		X_VALUES
		{
			sprung_t_0,
            sprung_t_1,
            sprung_t_2,
            sprung_t_3,
            sprung_t_4,
            sprung_t_5,
            sprung_t_6,
            sprung_t_7,
            sprung_t_8,
            sprung_t_9,
            sprung_t_10,
            sprung_t_11,
            sprung_t_12,
            sprung_t_13,
            sprung_t_14,
            sprung_t_15,
            sprung_t_16,
            sprung_t_17,
            sprung_t_18,
            sprung_t_19,
            sprung_t_20,
            sprung_t_21,
            sprung_t_22,
            sprung_t_23,
            sprung_t_24,
            sprung_t_25,
            sprung_t_26,
            sprung_t_27,
            sprung_t_28,
            sprung_t_29,
            sprung_t_30,
            sprung_t_31,
            sprung_t_32,
            sprung_t_33,
            sprung_t_34,
            sprung_t_35,
            sprung_t_36,
            sprung_t_37,
            sprung_t_38,
            sprung_t_39,
            sprung_t_40,
            sprung_t_41,
            sprung_t_42,
            sprung_t_43,
            sprung_t_44,
            sprung_t_45,
            sprung_t_46,
            sprung_t_47,
            sprung_t_48,
            sprung_t_49,
            sprung_t_50,
            sprung_t_51,
            sprung_t_52,
            sprung_t_53,
            sprung_t_54,
            sprung_t_55,
            sprung_t_56,
            sprung_t_57,
            sprung_t_58,
            sprung_t_59,
            sprung_t_60,
            sprung_t_61,
            sprung_t_62,
            sprung_t_63,
            sprung_t_64,
            sprung_t_65,
            sprung_t_66,
            sprung_t_67,
            sprung_t_68,
            sprung_t_69,
            sprung_t_70,
            sprung_t_71,
            sprung_t_72,
            sprung_t_73,
            sprung_t_74,
            sprung_t_75,
            sprung_t_76,
            sprung_t_77,
            sprung_t_78,
            sprung_t_79,
            sprung_t_80,
            sprung_t_81,
            sprung_t_82,
            sprung_t_83,
            sprung_t_84,
            sprung_t_85,
            sprung_t_86,
            sprung_t_87,
            sprung_t_88,
            sprung_t_89,
            sprung_t_90,
            sprung_t_91,
            sprung_t_92,
            sprung_t_93,
            sprung_t_94,
            sprung_t_95,
            sprung_t_96,
            sprung_t_97,
            sprung_t_98,
            sprung_t_99
		}
		Y_VALUES
		{
	        sprung_ss_0,
            sprung_ss_1,
            sprung_ss_2,
            sprung_ss_3,
            sprung_ss_4,
            sprung_ss_5,
            sprung_ss_6,
            sprung_ss_7,
            sprung_ss_8,
            sprung_ss_9,
            sprung_ss_10,
            sprung_ss_11,
            sprung_ss_12,
            sprung_ss_13,
            sprung_ss_14,
            sprung_ss_15,
            sprung_ss_16,
            sprung_ss_17,
            sprung_ss_18,
            sprung_ss_19,
            sprung_ss_20,
            sprung_ss_21,
            sprung_ss_22,
            sprung_ss_23,
            sprung_ss_24,
            sprung_ss_25,
            sprung_ss_26,
            sprung_ss_27,
            sprung_ss_28,
            sprung_ss_29,
            sprung_ss_30,
            sprung_ss_31,
            sprung_ss_32,
            sprung_ss_33,
            sprung_ss_34,
            sprung_ss_35,
            sprung_ss_36,
            sprung_ss_37,
            sprung_ss_38,
            sprung_ss_39,
            sprung_ss_40,
            sprung_ss_41,
            sprung_ss_42,
            sprung_ss_43,
            sprung_ss_44,
            sprung_ss_45,
            sprung_ss_46,
            sprung_ss_47,
            sprung_ss_48,
            sprung_ss_49,
            sprung_ss_50,
            sprung_ss_51,
            sprung_ss_52,
            sprung_ss_53,
            sprung_ss_54,
            sprung_ss_55,
            sprung_ss_56,
            sprung_ss_57,
            sprung_ss_58,
            sprung_ss_59,
            sprung_ss_60,
            sprung_ss_61,
            sprung_ss_62,
            sprung_ss_63,
            sprung_ss_64,
            sprung_ss_65,
            sprung_ss_66,
            sprung_ss_67,
            sprung_ss_68,
            sprung_ss_69,
            sprung_ss_70,
            sprung_ss_71,
            sprung_ss_72,
            sprung_ss_73,
            sprung_ss_74,
            sprung_ss_75,
            sprung_ss_76,
            sprung_ss_77,
            sprung_ss_78,
            sprung_ss_79,
            sprung_ss_80,
            sprung_ss_81,
            sprung_ss_82,
            sprung_ss_83,
            sprung_ss_84,
            sprung_ss_85,
            sprung_ss_86,
            sprung_ss_87,
            sprung_ss_88,
            sprung_ss_89,
            sprung_ss_90,
            sprung_ss_91,
            sprung_ss_92,
            sprung_ss_93,
            sprung_ss_94,
            sprung_ss_95,
            sprung_ss_96,
            sprung_ss_97,
            sprung_ss_98,
            sprung_ss_99
	  }
  }
}

#endif


/*----------------- Diagramm PST --------------------------------------------------*/

MENU Page_pst_1
{
    LABEL     "Control" "|de|Einstellungen";
    ITEMS
    {
      /* Einstellungen */
      input_pst_enabling_code,
      method_pst_reset,
      stepstart,
      stepend,
      pst_step_tolerance_limit,
      pst_activation_ramp_function,
      pst_ramp_time_rising,
      pst_ramp_time_falling,
      pst_settling_time_before_start,
      latency_after_step,
      step_sample_rate,
      pst_rec_scan_rate (READ_ONLY),
      duration_of_test,
      pst_max_test_duration,
      pst_fault_alarm_output,
      SEPARATOR,

      /* Abbruchbedingungen */
      pst_activation_x_control,
      pst_x_control_value,
      pst_activation_y_control,
      pst_y_control_value,
      pst_activation_tol_band_control,
      pst_tolerance_band,

      /* Anzeige */
      pst_min_value_y_control,
      pst_test_status_0,
      pst_number_of_tests
    }
}

/* Sprungantwort PST ********************************************************/
MENU Page_pst_2
{
    LABEL     "Step response measurement and analysis" "|de|Sprungantwort Messung und Auswertung";
    ITEMS
    {
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
        graph13,
        /* Manuelles Einlesen der Daten per Methode: */
        read_step_response_data,
#endif
        input_pst_enabling_code,
        start_abort_step_response_test,
        step_progress,
        pst_min_value_y_control,
        pst_number_of_tests,
        transmit_button,

        Page_pst_3, /* Messdatenauswertung */
        Page_pst_4,
        Page_pst_5
    }
}


MENU Page_pst_3
{
    LABEL     "Analysis current test" "|de|Auswertung aktueller Test";
    ITEMS
    {
      /* Gespeicherte Auswertungen */

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      /* Aktueller Test */
      "Analysis current test:" "|de|Auswertung aktueller Test:",
#endif      
      overshoot_rising,
      dead_time_rising,
      time_63_rising,
      time_98_rising,
      rise_time_rising_step,
      settling_time_rising_step,
      pst_test_status_0,       /* Test Status (aktueller Test) */
      SEPARATOR,
      pst_elapsed_hours_meter_0,
      overshoot_falling,
      dead_time_falling,
      time_63_falling,
      time_98_falling,
      rise_time_falling_step,
      settling_time_falling_step

      /* Test Status (aktueller Test) */
/*      pst_status__no_test_0,
      pst_status__x_cancel_0,
      pst_status__y_cancel_0,
      pst_status__tol_band_exceed_0,
      pst_status__max_test_time_exceed_0,
      pst_status__wrong_op_mode_0,
      pst_status__data_memory_full_0,
      pst_status__solenoid_valve_0,
      pst_status__supply_pressure_friction_0*/
    }
}

MENU Page_pst_4
{
    LABEL     "Analysis last test" "|de|Auswertung letzter Test";
    ITEMS
    {
      /* Gespeicherte Auswertungen */

/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      /* 1. gespeicherte Auswertung (letzter Test) */
      "Analysis last test:" "|de|Auswertung letzter Test:",
#endif      
      overshoot_rising_1,
      dead_time_rising_1,
      time_63_rising_1,
      time_98_rising_1,
      rise_time_rising_step_1,
      settling_time_rising_step_1,
      pst_test_status_1,       /* Test Status (letzter Test) */
      SEPARATOR,
      pst_elapsed_hours_meter_1,
      overshoot_falling_1,
      dead_time_falling_1,
      time_63_falling_1,
      time_98_falling_1,
      rise_time_falling_step_1,
      settling_time_falling_step_1

      /* Test Status (letzter Test) */
/*      pst_status__no_test_1,
      pst_status__x_cancel_1,
      pst_status__y_cancel_1,
      pst_status__tol_band_exceed_1,
      pst_status__max_test_time_exceed_1,
      pst_status__wrong_op_mode_1,
      pst_status__data_memory_full_1,
      pst_status__solenoid_valve_1,
      pst_status__supply_pressure_friction_1*/
    }
}

MENU Page_pst_5
{
    LABEL     "Analysis last test but one" "|de|Auswertung vorletzter Test";
    ITEMS
    {
      /* Gespeicherte Auswertungen */
      /* 2. gespeicherte Auswertung (vorletzter Test) */
/* nur ab PDM 6.0 SP2 mit enhancements Untersttzung: */
#ifdef _V602_
      "Analysis last test but one:" "|de|Auswertung vorletzter Test:",
      #endif
      overshoot_rising_2,
      dead_time_rising_2,
      time_63_rising_2,
      time_98_rising_2,
      rise_time_rising_step_2,
      settling_time_rising_step_2,
      pst_test_status_2,       /* Test Status (vorletzter Test) */
      SEPARATOR,
      pst_elapsed_hours_meter_2,
      overshoot_falling_2,
      dead_time_falling_2,
      time_63_falling_2,
      time_98_falling_2,
      rise_time_falling_step_2,
      settling_time_falling_step_2

      /* Test Status (vorletzter Test) */
/*      pst_status__no_test_2,
      pst_status__x_cancel_2,
      pst_status__y_cancel_2,
      pst_status__tol_band_exceed_2,
      pst_status__max_test_time_exceed_2,
      pst_status__wrong_op_mode_2,
      pst_status__data_memory_full_2,
      pst_status__solenoid_valve_2,
      pst_status__supply_pressure_friction_2*/
    }
}


/* ----------- the end ---------------------------------------------------- */

