/******************************************************************************/
/* DD for HART commands of EXPERT+ Parameter SAMSON Positioner 373x-3         */
/******************************************************************************/
/* SAMSON AG Mess- und Regeltechnik                                           */
/* Weismuellerstrasse 3                                                       */
/* 60314 Frankfurt                                                            */
/* Germany                                                                    */
/* Tel.: (++49) 69 4009 0     Fax: (++49) 69 4009 1507                        */
/* Internet: http://www.samson.de                                             */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2004). All Rights Reserved                       */
/* Device:        SAMSON Positioner 373x-3 HART capable EXPERT+  from FW 1.40 */
/******************************************************************************/
/* Datum:     Autor:   Aenderungen:                                           */
/* ------     ------   ------------                                           */
/* 17.01.2006 kmr/E42  Commands fuer EXPERT+ Parameter definiert              */
/* 28.04.2006 kmr/E82  Commands fuer EXPERT+ enhanced Grafiken definiert      */
/* 06.00.2006 Kmr/E82  Device Revision 5: PST Befehle ergaenzt                */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

/* ------------------------------------------------------------------------ */
/* Befehlsdefinitionen EXPERT+ Parameter                                    */
/* ------------------------------------------------------------------------ */

/*
Inhalt:
 Command 152     Diagnose: Schreiben der Indices fuer Lesen der Messdaten fuer
                 Datenlogger, Sprungantwort und stat. KL
 Command 156     Diagnose: Lesen der Messdaten nach Schreiben der Indices mit cmd 152
 Command 157     Diagnose: Read Diagnose1 (Sammelbefehl)
 Command 170     Diagnose: Unsigned Char Werte schreiben
 Command 171     Diagnose: Unsigned Char Werte lesen
 Command 150     Diagnose: Float Werte schreiben
 Command 151     Diagnose: Float Werte lesen
 Command 160     Diagnose: Unsigned Integer Werte schreiben
 Command 161     Diagnose: Unsigned Integer Werte lesen
 Command 180     Diagnose: Unsigned Long Werte schreiben
 Command 181     Diagnose: Unsigned Long Werte lesen
 Command 255     PST Freigabecode schreiben
 Command 182     PST Ruecksetzen
*/


/* ------------------------------------------------------------------------ */
/* Command 152     Diagnose Index-Startwerte schreiben                      */
/* ------------------------------------------------------------------------ */
COMMAND write_diagnosis_indices
{
  NUMBER 152;
  OPERATION WRITE;

  /* Indices fuer Datenlogger, Sprungantwort */
  TRANSACTION 3
  {
    REQUEST { 3, cmd_index_1, cmd_index_2, cmd_index_3, cmd_index_4, cmd_index_5 }
    REPLY   { response_code, device_status, cmd_index_1, cmd_index_2, cmd_index_3, cmd_index_4, cmd_index_5 }
  }

  /* Indices fuer Statische Kennlinie */
  TRANSACTION 6
  {
    REQUEST { 6, cmd_index_1, cmd_index_2, cmd_index_3, cmd_index_4, cmd_index_5, cmd_index_6 }
    REPLY   { response_code, device_status, cmd_index_1, cmd_index_2, cmd_index_3, cmd_index_4, cmd_index_5, cmd_index_6 }
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
         7, MODE_ERROR,         [in_write_protect_mode];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 156     Read Diagnose mit Startadresse                           */
/* ------------------------------------------------------------------------ */
COMMAND read_diagnosis_start_address
{
  NUMBER 156;
  OPERATION READ;

  /* Statische Kennlinie */
  TRANSACTION 1
  {
    REQUEST { 1 }
    REPLY   { response_code, device_status, dummy_enum, f_read_1, f_read_2, f_read_3, f_read_4, f_read_5, f_read_6 }
  }

  /* Datenlogger, Sprungantwort */
  TRANSACTION 3
  {
    REQUEST { 3 }
    REPLY   { response_code, device_status, dummy_enum, f_read_1, f_read_2, f_read_3, l_read_1, i_read_1 }
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		16, MODE_ERROR,         [access_restricted];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 157   Read Diagnose1                                             */
/* ------------------------------------------------------------------------ */
COMMAND read_diagnose1
{
  NUMBER 157;
  OPERATION READ;


/* ------------------------------------------------------------------------ */
/*
VARIABLE messages_1 ... 30 (unsigned integer 0..29)
*/
/* ------------------------------------------------------------------------ */
/*
VARIABLE elapsed_hours_meter_1 ... 30 (unsigned long 4..33)
*/
  TRANSACTION 2
  {
    REQUEST	{ 2 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      elapsed_hours_meter_1 ,
      messages_1 ,
      elapsed_hours_meter_2 ,
      messages_2 ,
      elapsed_hours_meter_3 ,
      messages_3 ,
      elapsed_hours_meter_4 ,
      messages_4 ,
      elapsed_hours_meter_5 ,
      messages_5
	}
  }

  TRANSACTION 3
  {
    REQUEST	{ 3 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      elapsed_hours_meter_6 ,
      messages_6 ,
      elapsed_hours_meter_7 ,
      messages_7 ,
      elapsed_hours_meter_8 ,
      messages_8 ,
      elapsed_hours_meter_9 ,
      messages_9 ,
      elapsed_hours_meter_10,
      messages_10,
      dummy_enum
	}
  }
  TRANSACTION 4
  {
    REQUEST	{ 4 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      elapsed_hours_meter_11,
      messages_11,
      elapsed_hours_meter_12,
      messages_12,
      elapsed_hours_meter_13,
      messages_13,
      elapsed_hours_meter_14,
      messages_14,
      elapsed_hours_meter_15,
      messages_15
	}
  }
  TRANSACTION 5
  {
    REQUEST	{ 5 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      elapsed_hours_meter_16,
      messages_16,
      elapsed_hours_meter_17,
      messages_17,
      elapsed_hours_meter_18,
      messages_18,
      elapsed_hours_meter_19,
      messages_19,
      elapsed_hours_meter_20,
      messages_20,
      dummy_enum
	}
  }
  TRANSACTION 6
  {
    REQUEST	{ 6 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      elapsed_hours_meter_21,
      messages_21,
      elapsed_hours_meter_22,
      messages_22,
      elapsed_hours_meter_23,
      messages_23,
      elapsed_hours_meter_24,
      messages_24,
      elapsed_hours_meter_25,
      messages_25
	}
  }
  TRANSACTION 7
  {
    REQUEST	{ 7 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      elapsed_hours_meter_26,
      messages_26,
      elapsed_hours_meter_27,
      messages_27,
      elapsed_hours_meter_28,
      messages_28,
      elapsed_hours_meter_29,
      messages_29,
      elapsed_hours_meter_30,
      messages_30,
      dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* unsigned char 73..94
VARIABLE x_interval_value_xx
*/
  TRANSACTION 11
  {
    REQUEST	{ 11 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      x_interval_value_0,
      x_interval_value_1,
      x_interval_value_2,
      x_interval_value_3,
      x_interval_value_4,
      x_interval_value_5,
      x_interval_value_6,
      x_interval_value_7,
      x_interval_value_8,
      x_interval_value_9,
      x_interval_value_10,
      x_interval_value_11,
      x_interval_value_12,
      x_interval_value_13,
      x_interval_value_14,
      x_interval_value_15,
      x_interval_value_16,
      x_interval_value_17,
      x_interval_value_18,
      x_interval_value_19,
      x_interval_value_20,
      x_interval_value_21,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* unsigned char 95..116
VARIABLE x_interval_value_kz_xx
*/
  TRANSACTION 12
  {
    REQUEST	{ 12 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      x_interval_value_kz_0,
      x_interval_value_kz_1,
      x_interval_value_kz_2,
      x_interval_value_kz_3,
      x_interval_value_kz_4,
      x_interval_value_kz_5,
      x_interval_value_kz_6,
      x_interval_value_kz_7,
      x_interval_value_kz_8,
      x_interval_value_kz_9,
      x_interval_value_kz_10,
      x_interval_value_kz_11,
      x_interval_value_kz_12,
      x_interval_value_kz_13,
      x_interval_value_kz_14,
      x_interval_value_kz_15,
      x_interval_value_kz_16,
      x_interval_value_kz_17,
      x_interval_value_kz_18,
      x_interval_value_kz_19,
      x_interval_value_kz_20,
      x_interval_value_kz_21,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/*
VARIABLE e_interval_value_long_0 ... 21 (unsigned char 121..132)
*/
  TRANSACTION 19
  {
    REQUEST	{ 19 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      e_interval_value_long_0,
      e_interval_value_long_1,
      e_interval_value_long_2,
      e_interval_value_long_3,
      e_interval_value_long_4,
      e_interval_value_long_5,
      e_interval_value_long_6,
      e_interval_value_long_7,
      e_interval_value_long_8,
      e_interval_value_long_9,
      e_interval_value_long_10,
      e_interval_value_long_11,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }

/* ------------------------------------------------------------------------ */
/* unsigned char 133..144
VARIABLE e_interval_value_short_xx
*/
  TRANSACTION 20
  {
    REQUEST	{ 20 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      e_interval_value_short_0,
      e_interval_value_short_1,
      e_interval_value_short_2,
      e_interval_value_short_3,
      e_interval_value_short_4,
      e_interval_value_short_5,
      e_interval_value_short_6,
      e_interval_value_short_7,
      e_interval_value_short_8,
      e_interval_value_short_9,
      e_interval_value_short_10,
      e_interval_value_short_11,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* unsigned char 162..174
VARIABLE his_z_intervallwert_xx
*/
  TRANSACTION 24
  {
    REQUEST	{ 24 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      his_z_intervallwert_0,
      his_z_intervallwert_1,
      his_z_intervallwert_2,
      his_z_intervallwert_3,
      his_z_intervallwert_4,
      his_z_intervallwert_5,
      his_z_intervallwert_6,
      his_z_intervallwert_7,
      his_z_intervallwert_8,
      his_z_intervallwert_9,
      his_z_intervallwert_10,
      his_z_intervallwert_11,
      his_z_intervallwert_12,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }

/* ------------------------------------------------------------------------ */
/* unsigned char 175..187
VARIABLE his_z_intervallwert_short_xx
*/
  TRANSACTION 25
  {
    REQUEST	{ 25 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      his_z_intervallwert_short_0,
      his_z_intervallwert_short_1,
      his_z_intervallwert_short_2,
      his_z_intervallwert_short_3,
      his_z_intervallwert_short_4,
      his_z_intervallwert_short_5,
      his_z_intervallwert_short_6,
      his_z_intervallwert_short_7,
      his_z_intervallwert_short_8,
      his_z_intervallwert_short_9,
      his_z_intervallwert_short_10,
      his_z_intervallwert_short_11,
      his_z_intervallwert_short_12,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* float 46..67
VARIABLE average_value_stat_long_xx
*/
/* ------------------------------------------------------------------------ */
/* float 68...89
VARIABLE average_value_stat_short_xx
*/
  TRANSACTION 40
  {
    REQUEST	{ 40 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_long_1,
      average_value_stat_long_2,
      average_value_stat_long_3,
      average_value_stat_long_4,
      average_value_stat_long_5,
      average_value_stat_long_6,
      average_value_stat_long_7,
      dummy_enum
	}
  }
  TRANSACTION 41
  {
    REQUEST	{ 41 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_long_8,
      average_value_stat_long_9,
      average_value_stat_long_10,
      average_value_stat_long_11,
      average_value_stat_long_12,
      average_value_stat_long_13,
      average_value_stat_long_14
	}
  }
  TRANSACTION 42
  {
    REQUEST	{ 42 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_long_15,
      average_value_stat_long_16,
      average_value_stat_long_17,
      average_value_stat_long_18,
      average_value_stat_long_19,
      average_value_stat_long_20,
      average_value_stat_long_21
	}
  }
  TRANSACTION 43
  {
    REQUEST	{ 43 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_long_22,
      average_value_stat_short_1,
      average_value_stat_short_2,
      average_value_stat_short_3,
      average_value_stat_short_4,
      average_value_stat_short_5,
      average_value_stat_short_6
	}
  }
  TRANSACTION 44
  {
    REQUEST	{ 44 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_short_7,
      average_value_stat_short_8,
      average_value_stat_short_9,
      average_value_stat_short_10,
      average_value_stat_short_11,
      average_value_stat_short_12,
      average_value_stat_short_13
	}
  }
  TRANSACTION 45
  {
    REQUEST	{ 45 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_short_14,
      average_value_stat_short_15,
      average_value_stat_short_16,
      average_value_stat_short_17,
      average_value_stat_short_18,
      average_value_stat_short_19,
      average_value_stat_short_20
	}
  }
  TRANSACTION 46
  {
    REQUEST	{ 46 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_stat_short_21,
      average_value_stat_short_22,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* (unsigned integer 30..39) stat_stellsignal_Value_0..9 */
/* (float 90..99)            stat_ventilstellung_Value_0..9 */

  TRANSACTION 47
  {
    REQUEST	{ 47 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_ventilstellung_Value_0,
      stat_stellsignal_Value_0,
      stat_ventilstellung_Value_1,
      stat_stellsignal_Value_1,
      stat_ventilstellung_Value_2,
      stat_stellsignal_Value_2,
      stat_ventilstellung_Value_3,
      stat_stellsignal_Value_3,
      stat_ventilstellung_Value_4,
      stat_stellsignal_Value_4,
      dummy_enum
	}
  }
  TRANSACTION 48
  {
    REQUEST	{ 48 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_ventilstellung_Value_5,
      stat_stellsignal_Value_5,
      stat_ventilstellung_Value_6,
      stat_stellsignal_Value_6,
      stat_ventilstellung_Value_7,
      stat_stellsignal_Value_7,
      stat_ventilstellung_Value_8,
      stat_stellsignal_Value_8,
      stat_ventilstellung_Value_9,
      stat_stellsignal_Value_9
	}
  }


/* ------------------------------------------------------------------------ */
/* float 100..118
VARIABLE average_value_long_xx
*/
  TRANSACTION 54
  {
    REQUEST	{ 54 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_long_1,
      average_value_long_2,
      average_value_long_3,
      average_value_long_4,
      average_value_long_5,
      average_value_long_6,
      average_value_long_7
	}
  }
  TRANSACTION 55
  {
    REQUEST	{ 55 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_long_8,
      average_value_long_9,
      average_value_long_10,
      average_value_long_11,
      average_value_long_12,
      average_value_long_13,
      average_value_long_14
	}
  }
  TRANSACTION 56
  {
    REQUEST	{ 56 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      average_value_long_15,
      average_value_long_16,
      average_value_long_17,
      average_value_long_18,
      average_value_long_19,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* (unsigned integer 40..49) hys_stellsignal_Value_0..9 */
/* (float 144..153)          hys_ventilstellung_Value_0..9 */

  TRANSACTION 61
  {
    REQUEST	{ 61 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      hys_ventilstellung_Value_0,
      hys_stellsignal_Value_0,
      hys_ventilstellung_Value_1,
      hys_stellsignal_Value_1,
      hys_ventilstellung_Value_2,
      hys_stellsignal_Value_2,
      hys_ventilstellung_Value_3,
      hys_stellsignal_Value_3,
      hys_ventilstellung_Value_4,
      hys_stellsignal_Value_4,
      dummy_enum
	}
  }
  TRANSACTION 62
  {
    REQUEST	{ 62 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      hys_ventilstellung_Value_5,
      hys_stellsignal_Value_5,
      hys_ventilstellung_Value_6,
      hys_stellsignal_Value_6,
      hys_ventilstellung_Value_7,
      hys_stellsignal_Value_7,
      hys_ventilstellung_Value_8,
      hys_stellsignal_Value_8,
      hys_ventilstellung_Value_9,
      hys_stellsignal_Value_9
	}
  }

/* ------------------------------------------------------------------------ */
/* (float 599) stat_kl_vs_99 */
/* (float 699) stat_kl_sw_99 */
  TRANSACTION 84
  {
    REQUEST	{ 84 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      dummy_float,
      dummy_float,
      dummy_float,
      dummy_enum,
      dummy_enum,
      dummy_enum,
      dummy_float,
      f_read_1,      /* (stat_kl_vs_99) */
      dummy_float,
      f_read_2       /* (stat_kl_sw_99) */
	}
  }



/* ------------------------------------------------------------------------ */
/* float 217-241
VARIABLE stat_ref_vs_xx
*/
/* Referenzwerte Ventilstellung (x-Achse) */
  TRANSACTION 90
  {
    REQUEST	{ 90 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_ref_vs_0,
      stat_ref_vs_1,
      stat_ref_vs_2,
      stat_ref_vs_3,
      stat_ref_vs_4,
      stat_ref_vs_5,
      stat_ref_vs_6,
      dummy_enum,
      dummy_enum
	}
  }
  TRANSACTION 91
  {
    REQUEST	{ 91 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_ref_vs_7,
      stat_ref_vs_8,
      stat_ref_vs_9,
      stat_ref_vs_10,
      stat_ref_vs_11,
      stat_ref_vs_12,
      stat_ref_vs_13,
      dummy_enum
	}
  }
  TRANSACTION 92
  {
    REQUEST	{ 92 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_ref_vs_14,
      stat_ref_vs_15,
      stat_ref_vs_16,
      stat_ref_vs_17,
      stat_ref_vs_18,
      stat_ref_vs_19,
      stat_ref_vs_20,
      dummy_enum
	}
  }
  TRANSACTION 93
  {
    REQUEST	{ 93 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_ref_vs_21,
      stat_ref_vs_22,
      stat_ref_vs_23,
      stat_ref_vs_24,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum, dummy_enum, dummy_enum, dummy_enum,
      dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* float 242-266
VARIABLE stat_again_vs_xx
*/
/* Wiederholungswerte Ventilstellung (x-Achse) */
  TRANSACTION 94
  {
    REQUEST	{ 94 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_again_vs_0,
      stat_again_vs_1,
      stat_again_vs_2,
      stat_again_vs_3,
      stat_again_vs_4,
      stat_again_vs_5,
      stat_again_vs_6,
      dummy_enum
	}
  }
  TRANSACTION 95
  {
    REQUEST	{ 95 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_again_vs_7,
      stat_again_vs_8,
      stat_again_vs_9,
      stat_again_vs_10,
      stat_again_vs_11,
      stat_again_vs_12,
      stat_again_vs_13,
      dummy_enum
	}
  }
  TRANSACTION 96
  {
    REQUEST	{ 96 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_again_vs_14,
      stat_again_vs_15,
      stat_again_vs_16,
      stat_again_vs_17,
      stat_again_vs_18,
      stat_again_vs_19,
      stat_again_vs_20,
      dummy_enum
	}
  }
  TRANSACTION 97
  {
    REQUEST	{ 97 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
      stat_again_vs_21,
      stat_again_vs_22,
      stat_again_vs_23,
      stat_again_vs_24,
      dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* unsigned int 112-136
   VARIABLE hand_y_stat_referenzwerte_xx
*/
  TRANSACTION 98
  {
    REQUEST	{ 98 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
	  hand_y_stat_referenzwerte_1,
	  hand_y_stat_referenzwerte_2,
	  hand_y_stat_referenzwerte_3,
	  hand_y_stat_referenzwerte_4,
	  hand_y_stat_referenzwerte_5,
	  hand_y_stat_referenzwerte_6,
	  hand_y_stat_referenzwerte_7,
	  hand_y_stat_referenzwerte_8,
	  hand_y_stat_referenzwerte_9,
	  hand_y_stat_referenzwerte_10,
	  hand_y_stat_referenzwerte_11,
      dummy_enum,
	  hand_y_stat_referenzwerte_12,
	  hand_y_stat_referenzwerte_13,
	  hand_y_stat_referenzwerte_14,
	  hand_y_stat_referenzwerte_15
	}
  }
  TRANSACTION 99
  {
    REQUEST	{ 99 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
	  hand_y_stat_referenzwerte_16,
	  hand_y_stat_referenzwerte_17,
	  hand_y_stat_referenzwerte_18,
	  hand_y_stat_referenzwerte_19,
	  hand_y_stat_referenzwerte_20,
	  hand_y_stat_referenzwerte_21,
	  hand_y_stat_referenzwerte_22,
	  hand_y_stat_referenzwerte_23,
	  hand_y_stat_referenzwerte_24,
	  hand_y_stat_referenzwerte_25,
	  hand_y_stat_wiederholungswerte_1,
      dummy_enum,
	  hand_y_stat_wiederholungswerte_2,
	  hand_y_stat_wiederholungswerte_3,
	  hand_y_stat_wiederholungswerte_4,
	  hand_y_stat_wiederholungswerte_5
	}
  }

/* ------------------------------------------------------------------------ */
/* unsigned int 137-161
VARIABLE hand_y_stat_wiederholungswerte_xx
*/
  TRANSACTION 100
  {
    REQUEST	{ 100 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
	  hand_y_stat_wiederholungswerte_6,
	  hand_y_stat_wiederholungswerte_7,
	  hand_y_stat_wiederholungswerte_8,
	  hand_y_stat_wiederholungswerte_9,
	  hand_y_stat_wiederholungswerte_10,
	  hand_y_stat_wiederholungswerte_11,
	  hand_y_stat_wiederholungswerte_12,
	  hand_y_stat_wiederholungswerte_13,
	  hand_y_stat_wiederholungswerte_14,
	  hand_y_stat_wiederholungswerte_15,
	  hand_y_stat_wiederholungswerte_16,
      dummy_enum,
	  hand_y_stat_wiederholungswerte_17,
	  hand_y_stat_wiederholungswerte_18,
	  hand_y_stat_wiederholungswerte_19,
	  hand_y_stat_wiederholungswerte_20
	}
  }
  TRANSACTION 101
  {
    REQUEST	{ 101 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
	  hand_y_stat_wiederholungswerte_21,
	  hand_y_stat_wiederholungswerte_22,
	  hand_y_stat_wiederholungswerte_23,
	  hand_y_stat_wiederholungswerte_24,
	  hand_y_stat_wiederholungswerte_25,
      dummy_enum,
      dummy_enum,
      dummy_enum,
      dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* unsigned int 162-173
VARIABLE hand_y_hys_referenzwerte_xx
*/
  TRANSACTION 103
  {
    REQUEST	{ 103 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
	  hand_y_hys_referenzwerte_1,
	  hand_y_hys_referenzwerte_2,
	  hand_y_hys_referenzwerte_3,
	  hand_y_hys_referenzwerte_4,
	  hand_y_hys_referenzwerte_5,
	  hand_y_hys_referenzwerte_6,
	  hand_y_hys_referenzwerte_7,
	  hand_y_hys_referenzwerte_8,
	  hand_y_hys_referenzwerte_9,
	  hand_y_hys_referenzwerte_10,
	  hand_y_hys_referenzwerte_11,
      dummy_enum,
	  hand_y_hys_referenzwerte_12,
      dummy_enum
	}
  }


/* ------------------------------------------------------------------------ */
/* unsigned int 174-185
VARIABLE hand_y_hys_wiederholungswerte_xx
*/
  TRANSACTION 104
  {
    REQUEST	{ 104 }
    REPLY
	{
	  response_code, device_status,
      dummy_enum,
	  hand_y_hys_wiederholungswerte_1,
	  hand_y_hys_wiederholungswerte_2,
	  hand_y_hys_wiederholungswerte_3,
	  hand_y_hys_wiederholungswerte_4,
	  hand_y_hys_wiederholungswerte_5,
	  hand_y_hys_wiederholungswerte_6,
	  hand_y_hys_wiederholungswerte_7,
	  hand_y_hys_wiederholungswerte_8,
	  hand_y_hys_wiederholungswerte_9,
	  hand_y_hys_wiederholungswerte_10,
	  hand_y_hys_wiederholungswerte_11,
      dummy_enum,
	  hand_y_hys_wiederholungswerte_12
	}
  }


  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
		16, MODE_ERROR,         [access_restricted];
  }
}
/* ------------------------------------------------------------------------ */



/* ------------------------------------------------------------------------ */
/* Command 170     Diagnose Unsigned Char Werte schreiben                   */
/* ------------------------------------------------------------------------ */
COMMAND write_diagnosis_uchar
{
  NUMBER 170;
  OPERATION WRITE;

   TRANSACTION 3
   {
     REQUEST { 0, 0x03, reset_logger }
     REPLY   { response_code, device_status, reset_logger }
   }

   TRANSACTION 38
   {
     REQUEST { 0, 0x26, datalogger_select }
     REPLY   { response_code, device_status, datalogger_select }
   }

   TRANSACTION 39
   {
     REQUEST { 0, 0x27, start_abort_data_logger }
     REPLY   { response_code, device_status, start_abort_data_logger }
   }

   TRANSACTION 42
   {
     REQUEST { 0, 0x2A, logging_limit }
     REPLY   { response_code, device_status, logging_limit }
   }

   TRANSACTION 47
   {
     REQUEST { 0, 0x2F, trigger_select }
     REPLY   { response_code, device_status, trigger_select }
   }

   TRANSACTION 49
   {
     REQUEST { 0, 0x31, reset_x_long_term_histogram }
     REPLY   { response_code, device_status, reset_x_long_term_histogram }
   }

   TRANSACTION 50
   {
     REQUEST { 0, 0x32, reset_x_short_term_histogram }
     REPLY   { response_code, device_status, reset_x_short_term_histogram }
   }

   TRANSACTION 119
   {
     REQUEST { 0, 0x77, reset_e_long_term_setpoint_deviation }
     REPLY   { response_code, device_status, reset_e_long_term_setpoint_deviation }
   }

   TRANSACTION 120
   {
     REQUEST { 0, 0x78, reset_e_short_term_setpoint_deviation }
     REPLY   { response_code, device_status, reset_e_short_term_setpoint_deviation }
   }

   TRANSACTION 146
   {
     REQUEST { 0, 0x92, reset_z_short_term }
     REPLY   { response_code, device_status, reset_z_short_term }
   }

   TRANSACTION 148
   {
     REQUEST { 0, 0x94, reset_z_long_term }
     REPLY   { response_code, device_status, reset_z_long_term }
   }

   TRANSACTION 188
   {
     REQUEST { 0, 0xBC, start_abort_hysteresis_online_test }
     REPLY   { response_code, device_status, start_abort_hysteresis_online_test }
   }

   TRANSACTION 190
   {
     REQUEST { 0, 0xBE, reset_y_x_long_term }
     REPLY   { response_code, device_status, reset_y_x_long_term }
   }

   TRANSACTION 191
   {
     REQUEST { 0, 0xBF, reset_y_x_short_term }
     REPLY   { response_code, device_status, reset_y_x_short_term }
   }

   TRANSACTION 218
   {
     REQUEST { 0, 0xDA, reset_hysteresis_long_term }
     REPLY   { response_code, device_status, reset_hysteresis_long_term }
   }

   TRANSACTION 221
   {
     REQUEST { 0, 0xDD, reset_hysteresis_short_term }
     REPLY   { response_code, device_status, reset_hysteresis_short_term }
   }

   TRANSACTION 245
   {
     REQUEST { 0, 0xF5, reset_lower_end_position }
     REPLY   { response_code, device_status, reset_lower_end_position }
   }

   TRANSACTION 247
   {
     REQUEST { 0, 0xF7, reset_lower_end_position_ref_values }
     REPLY   { response_code, device_status, reset_lower_end_position_ref_values }
   }

   TRANSACTION 252
   {
     REQUEST { 0, 0xFC, reset_y_x_measured_values }
     REPLY   { response_code, device_status, reset_y_x_measured_values }
   }

   TRANSACTION 255
   {
     REQUEST { 0, 0xFF, start_abort_drive_signal_diagram_steady }
     REPLY   { response_code, device_status, start_abort_drive_signal_diagram_steady }
   }

   TRANSACTION 271
   {
     REQUEST { 0x01, 0x0F, reset_hysteresis_measured_values }
     REPLY   { response_code, device_status, reset_hysteresis_measured_values }
   }

   TRANSACTION 273
   {
     REQUEST { 0x01, 0x11, start_abort_drive_signal_diagram_hysteresis }
     REPLY   { response_code, device_status, start_abort_drive_signal_diagram_hysteresis }
   }

   TRANSACTION 275
   {
     REQUEST { 0x01, 0x13, start_abort_static_characteristic }
     REPLY   { response_code, device_status, start_abort_static_characteristic }
   }

  TRANSACTION 276
  {
    REQUEST { 0x01, 0x14, kl_delay_time_after_step }
    REPLY   { response_code, device_status, kl_delay_time_after_step }
  }

  TRANSACTION 277
  {
    REQUEST { 0x01, 0x15, kl_anzahl_bis_umkehr }
    REPLY   { response_code, device_status, kl_anzahl_bis_umkehr }
  }

   TRANSACTION 281
   {
     REQUEST { 0x01, 0x19, start_abort_step_response_test }
     REPLY   { response_code, device_status, start_abort_step_response_test }
   }

   TRANSACTION 287
   {
     REQUEST { 0x01, 0x1F, start_abort_tests_in_turn }
     REPLY   { response_code, device_status, start_abort_tests_in_turn }
   }

   TRANSACTION 291
   {
     REQUEST { 0x01, 0x23, step_selection }
     REPLY   { response_code, device_status, step_selection }
   }

   TRANSACTION 301
   {
     REQUEST { 0x01, 0x2D, start_abort_reference_test }
     REPLY   { response_code, device_status, start_abort_reference_test }
   }

/* Anfang PST */
   TRANSACTION 309
   {
     REQUEST { 0x01, 0x35, pst_mode_on_off }
     REPLY   { response_code, device_status, pst_mode_on_off }
   }

   TRANSACTION 310
   {
     REQUEST { 0x01, 0x36, pst_operating_mode }
     REPLY   { response_code, device_status, pst_operating_mode }
   }

   TRANSACTION 313
   {
     REQUEST { 0x01, 0x39, pst_activation_ramp_function }
     REPLY   { response_code, device_status, pst_activation_ramp_function }
   }

   TRANSACTION 314
   {
     REQUEST { 0x01, 0x3A, pst_activation_tol_band_control }
     REPLY   { response_code, device_status, pst_activation_tol_band_control }
   }

   TRANSACTION 319
   {
     REQUEST { 0x01, 0x3F, pst_fault_alarm_output }
     REPLY   { response_code, device_status, pst_fault_alarm_output }
   }

   TRANSACTION 322
   {
     REQUEST { 0x01, 0x42, pst_activation_y_control }
     REPLY   { response_code, device_status, pst_activation_y_control }
   }

   TRANSACTION 323
   {
     REQUEST { 0x01, 0x43, pst_activation_x_control }
     REPLY   { response_code, device_status, pst_activation_x_control }
   }
/* Ende PST */



   TRANSACTION 334 /* Statusklassifikation 'Temperatur kleiner -40 Grad C */
   {
     REQUEST { 0x01, 0x4E, condensed_mask_temp_40 }
     REPLY   { response_code, device_status, condensed_mask_temp_40 }
   }

   TRANSACTION 336 /* Statusklassifikation 'Temperatur groesser +80 Grad C */
   {
     REQUEST { 0x01, 0x50, condensed_mask_temp_80 }
     REPLY   { response_code, device_status, condensed_mask_temp_80 }
   }

   /* Statusklassifikationen EXPERT+ schreiben unsigned character 410-477 */

   TRANSACTION 410  /* Stellbereich 410-415 */
   {
     REQUEST { 0x01, 0x9A, WorkingRange_1_condensed_mask }
     REPLY   { response_code, device_status, WorkingRange_1_condensed_mask }
   }
   TRANSACTION 411
   {
     REQUEST { 0x01, 0x9B, WorkingRange_2_condensed_mask }
     REPLY   { response_code, device_status, WorkingRange_2_condensed_mask }
   }
   TRANSACTION 412
   {
     REQUEST { 0x01, 0x9C, WorkingRange_3_condensed_mask }
     REPLY   { response_code, device_status, WorkingRange_3_condensed_mask }
   }
   TRANSACTION 413
   {
     REQUEST { 0x01, 0x9D, WorkingRange_4_condensed_mask }
     REPLY   { response_code, device_status, WorkingRange_4_condensed_mask }
   }

   TRANSACTION 416   /* Trend Stellbereich 416-419 */
   {
     REQUEST { 0x01, 0xA0, ShiftingWorkingRange_1_condensed_mask }
     REPLY   { response_code, device_status, ShiftingWorkingRange_1_condensed_mask }
   }
   TRANSACTION 417
   {
     REQUEST { 0x01, 0xA1, ShiftingWorkingRange_2_condensed_mask }
     REPLY   { response_code, device_status, ShiftingWorkingRange_2_condensed_mask }
   }

   TRANSACTION 420   /* Beschraenkung Stellbereich 420-424 */
   {
     REQUEST { 0x01, 0xA4, LimitWorkingRange_1_condensed_mask }
     REPLY   { response_code, device_status, LimitWorkingRange_1_condensed_mask }
   }
   TRANSACTION 421
   {
     REQUEST { 0x01, 0xA5, LimitWorkingRange_2_condensed_mask }
     REPLY   { response_code, device_status, LimitWorkingRange_2_condensed_mask }
   }
   TRANSACTION 422
   {
     REQUEST { 0x01, 0xA6, LimitWorkingRange_3_condensed_mask }
     REPLY   { response_code, device_status, LimitWorkingRange_3_condensed_mask }
   }

   TRANSACTION 425   /* Trend Endlage 425-432 */
   {
     REQUEST { 0x01, 0xA9, ObservingEndPosition_1_condensed_mask }
     REPLY   { response_code, device_status, ObservingEndPosition_1_condensed_mask }
   }
   TRANSACTION 426
   {
     REQUEST { 0x01, 0xAA, ObservingEndPosition_2_condensed_mask }
     REPLY   { response_code, device_status, ObservingEndPosition_2_condensed_mask }
   }
   TRANSACTION 427
   {
     REQUEST { 0x01, 0xAB, ObservingEndPosition_3_condensed_mask }
     REPLY   { response_code, device_status, ObservingEndPosition_3_condensed_mask }
   }
   TRANSACTION 428
   {
     REQUEST { 0x01, 0xAC, ObservingEndPosition_4_condensed_mask }
     REPLY   { response_code, device_status, ObservingEndPosition_4_condensed_mask }
   }
   TRANSACTION 429
   {
     REQUEST { 0x01, 0xAD, ObservingEndPosition_5_condensed_mask }
     REPLY   { response_code, device_status, ObservingEndPosition_5_condensed_mask }
   }
   TRANSACTION 430
   {
     REQUEST { 0x01, 0xAE, ObservingEndPosition_6_condensed_mask }
     REPLY   { response_code, device_status, ObservingEndPosition_6_condensed_mask }
   }

   TRANSACTION 436   /* Verbindung Stellungsregler - Ventil 436-440 */
   {
     REQUEST { 0x01, 0xB4, ConnectionPosValve_1_condensed_mask }
     REPLY   { response_code, device_status, ConnectionPosValve_1_condensed_mask }
   }
   TRANSACTION 437
   {
     REQUEST { 0x01, 0xB5, ConnectionPosValve_2_condensed_mask }
     REPLY   { response_code, device_status, ConnectionPosValve_2_condensed_mask }
   }
   TRANSACTION 438
   {
     REQUEST { 0x01, 0xB6, ConnectionPosValve_3_condensed_mask }
     REPLY   { response_code, device_status, ConnectionPosValve_3_condensed_mask }
   }

   TRANSACTION 441   /* Antriebsfedern 441-447 */
   {
     REQUEST { 0x01, 0xB9, ActSpring_1_condensed_mask }
     REPLY   { response_code, device_status, ActSpring_1_condensed_mask }
   }
   TRANSACTION 442
   {
     REQUEST { 0x01, 0xBA, ActSpring_2_condensed_mask }
     REPLY   { response_code, device_status, ActSpring_2_condensed_mask }
   }
   TRANSACTION 443
   {
     REQUEST { 0x01, 0xBB, ActSpring_3_condensed_mask }
     REPLY   { response_code, device_status, ActSpring_3_condensed_mask }
   }
   TRANSACTION 444
   {
     REQUEST { 0x01, 0xBC, ActSpring_4_condensed_mask }
     REPLY   { response_code, device_status, ActSpring_4_condensed_mask }
   }
   TRANSACTION 445
   {
     REQUEST { 0x01, 0xBD, ActSpring_5_condensed_mask }
     REPLY   { response_code, device_status, ActSpring_5_condensed_mask }
   }

   TRANSACTION 448   /* Zuluftdruck 448-455 */
   {
     REQUEST { 0x01, 0xC0, AirSupply_1_condensed_mask }
     REPLY   { response_code, device_status, AirSupply_1_condensed_mask }
   }
   TRANSACTION 449
   {
     REQUEST { 0x01, 0xC1, AirSupply_2_condensed_mask }
     REPLY   { response_code, device_status, AirSupply_2_condensed_mask }
   }
   TRANSACTION 450
   {
     REQUEST { 0x01, 0xC2, AirSupply_3_condensed_mask }
     REPLY   { response_code, device_status, AirSupply_3_condensed_mask }
   }
   TRANSACTION 451
   {
     REQUEST { 0x01, 0xC3, AirSupply_4_condensed_mask }
     REPLY   { response_code, device_status, AirSupply_4_condensed_mask }
   }
   TRANSACTION 452
   {
     REQUEST { 0x01, 0xC4, AirSupply_5_condensed_mask }
     REPLY   { response_code, device_status, AirSupply_5_condensed_mask }
   }
   TRANSACTION 453
   {
     REQUEST { 0x01, 0xC5, AirSupply_6_condensed_mask }
     REPLY   { response_code, device_status, AirSupply_6_condensed_mask }
   }

   TRANSACTION 456   /* Leckage Pneumatik 456-460 */
   {
     REQUEST { 0x01, 0xC8, LeakagePn_1_condensed_mask }
     REPLY   { response_code, device_status, LeakagePn_1_condensed_mask }
   }
   TRANSACTION 457
   {
     REQUEST { 0x01, 0xC9, LeakagePn_3_condensed_mask }
     REPLY   { response_code, device_status, LeakagePn_3_condensed_mask }
   }
   TRANSACTION 458
   {
     REQUEST { 0x01, 0xCA, LeakagePn_4_condensed_mask }
     REPLY   { response_code, device_status, LeakagePn_4_condensed_mask }
   }
   TRANSACTION 459
   {
     REQUEST { 0x01, 0xCB, LeakagePn_2_condensed_mask }
     REPLY   { response_code, device_status, LeakagePn_2_condensed_mask }
   }

   TRANSACTION 461   /* Reibung 461-466 */
   {
     REQUEST { 0x01, 0xCD, Friction_1_condensed_mask }
     REPLY   { response_code, device_status, Friction_1_condensed_mask }
   }
   TRANSACTION 462
   {
     REQUEST { 0x01, 0xCE, Friction_2_condensed_mask }
     REPLY   { response_code, device_status, Friction_2_condensed_mask }
   }
   TRANSACTION 463
   {
     REQUEST { 0x01, 0xCF, Friction_3_condensed_mask }
     REPLY   { response_code, device_status, Friction_3_condensed_mask }
   }
   TRANSACTION 464
   {
     REQUEST { 0x01, 0xD0, Friction_4_condensed_mask }
     REPLY   { response_code, device_status, Friction_4_condensed_mask }
   }
   TRANSACTION 465
   {
     REQUEST { 0x01, 0xD1, Friction_5_condensed_mask }
     REPLY   { response_code, device_status, Friction_5_condensed_mask }
   }
   TRANSACTION 466
   {
     REQUEST { 0x01, 0xD2, Friction_6_condensed_mask }
     REPLY   { response_code, device_status, Friction_6_condensed_mask }
   }

   TRANSACTION 467   /* Innere Leckage 467-470 */
   {
     REQUEST { 0x01, 0xD3, InnerLeakage_1_condensed_mask }
     REPLY   { response_code, device_status, InnerLeakage_1_condensed_mask }
   }
   TRANSACTION 468
   {
     REQUEST { 0x01, 0xD4, InnerLeakage_2_condensed_mask }
     REPLY   { response_code, device_status, InnerLeakage_2_condensed_mask }
   }
   TRANSACTION 469
   {
     REQUEST { 0x01, 0xD5, InnerLeakage_3_condensed_mask }
     REPLY   { response_code, device_status, InnerLeakage_3_condensed_mask }
   }

   TRANSACTION 471   /* Externe Leckage 471-474 */
   {
     REQUEST { 0x01, 0xD7, ExternalLeakage_1_condensed_mask }
     REPLY   { response_code, device_status, ExternalLeakage_1_condensed_mask }
   }
   TRANSACTION 472
   {
     REQUEST { 0x01, 0xD8, ExternalLeakage_2_condensed_mask }
     REPLY   { response_code, device_status, ExternalLeakage_2_condensed_mask }
   }

   TRANSACTION 475 /* PST 475 */
   {
     REQUEST { 0x01, 0xDB, PST_1_condensed_mask }
     REPLY   { response_code, device_status, PST_1_condensed_mask }
   }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
         7, MODE_ERROR,         [in_write_protect_mode];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 171     Diagnose Unsigned Char Werte lesen                       */
/* ------------------------------------------------------------------------ */
COMMAND read_diagnosis_uchar
{
  NUMBER 171;
  OPERATION READ;

   TRANSACTION 1
   {
     REQUEST { 0, 0x01 }
     REPLY   { response_code, device_status, diag_level }
   }

   TRANSACTION 11
   {
     REQUEST { 0, 0x0B }
     REPLY   { response_code, device_status, his_z_dynamic_stress_factor }
   }

   TRANSACTION 38
   {
     REQUEST { 0, 0x26 }
     REPLY   { response_code, device_status, datalogger_select }
   }

   TRANSACTION 39
   {
     REQUEST { 0, 0x27 }
     REPLY   { response_code, device_status, start_abort_data_logger }
   }

   TRANSACTION 42
   {
     REQUEST { 0, 0x2A }
     REPLY   { response_code, device_status, logging_limit }
   }

   TRANSACTION 44
   {
     REQUEST { 0, 0x2C }
     REPLY   { response_code, device_status, datalogger_progress }
   }

   TRANSACTION 47
   {
     REQUEST { 0, 0x2F }
     REPLY   { response_code, device_status, trigger_select }
   }

/* mit cmd 157 realisiert

   TRANSACTION 73
   {
     REQUEST { 0, 0x49 }
     REPLY   { response_code, device_status, x_interval_value_0 }
   }
   TRANSACTION 74
   {
     REQUEST { 0, 0x4A }
     REPLY   { response_code, device_status, x_interval_value_1 }
   }
   TRANSACTION 75
   {
     REQUEST { 0, 0x4B }
     REPLY   { response_code, device_status, x_interval_value_2 }
   }
   TRANSACTION 76
   {
     REQUEST { 0, 0x4C }
     REPLY   { response_code, device_status, x_interval_value_3 }
   }
   TRANSACTION 77
   {
     REQUEST { 0, 0x4D }
     REPLY   { response_code, device_status, x_interval_value_4 }
   }
   TRANSACTION 78
   {
     REQUEST { 0, 0x4E }
     REPLY   { response_code, device_status, x_interval_value_5 }
   }
   TRANSACTION 79
   {
     REQUEST { 0, 0x4F }
     REPLY   { response_code, device_status, x_interval_value_6 }
   }
   TRANSACTION 80
   {
     REQUEST { 0, 0x50 }
     REPLY   { response_code, device_status, x_interval_value_7 }
   }
   TRANSACTION 81
   {
     REQUEST { 0, 0x51 }
     REPLY   { response_code, device_status, x_interval_value_8 }
   }
   TRANSACTION 82
   {
     REQUEST { 0, 0x52 }
     REPLY   { response_code, device_status, x_interval_value_9 }
   }
   TRANSACTION 83
   {
     REQUEST { 0, 0x53 }
     REPLY   { response_code, device_status, x_interval_value_10 }
   }
   TRANSACTION 84
   {
     REQUEST { 0, 0x54 }
     REPLY   { response_code, device_status, x_interval_value_11 }
   }
   TRANSACTION 85
   {
     REQUEST { 0, 0x55 }
     REPLY   { response_code, device_status, x_interval_value_12 }
   }
   TRANSACTION 86
   {
     REQUEST { 0, 0x56 }
     REPLY   { response_code, device_status, x_interval_value_13 }
   }
   TRANSACTION 87
   {
     REQUEST { 0, 0x57 }
     REPLY   { response_code, device_status, x_interval_value_14 }
   }
   TRANSACTION 88
   {
     REQUEST { 0, 0x58 }
     REPLY   { response_code, device_status, x_interval_value_15 }
   }
   TRANSACTION 89
   {
     REQUEST { 0, 0x59 }
     REPLY   { response_code, device_status, x_interval_value_16 }
   }
   TRANSACTION 90
   {
     REQUEST { 0, 0x5A }
     REPLY   { response_code, device_status, x_interval_value_17 }
   }
   TRANSACTION 91
   {
     REQUEST { 0, 0x5B }
     REPLY   { response_code, device_status, x_interval_value_18 }
   }
   TRANSACTION 92
   {
     REQUEST { 0, 0x5C }
     REPLY   { response_code, device_status, x_interval_value_19 }
   }
   TRANSACTION 93
   {
     REQUEST { 0, 0x5D }
     REPLY   { response_code, device_status, x_interval_value_20 }
   }
   TRANSACTION 94
   {
     REQUEST { 0, 0x5E }
     REPLY   { response_code, device_status, x_interval_value_21 }
   }

   TRANSACTION 95
   {
     REQUEST { 0, 0x5F }
     REPLY   { response_code, device_status, x_interval_value_kz_0 }
   }
   TRANSACTION 96
   {
     REQUEST { 0, 0x60 }
     REPLY   { response_code, device_status, x_interval_value_kz_1 }
   }
   TRANSACTION 97
   {
     REQUEST { 0, 0x61 }
     REPLY   { response_code, device_status, x_interval_value_kz_2 }
   }
   TRANSACTION 98
   {
     REQUEST { 0, 0x62 }
     REPLY   { response_code, device_status, x_interval_value_kz_3 }
   }
   TRANSACTION 99
   {
     REQUEST { 0, 0x63 }
     REPLY   { response_code, device_status, x_interval_value_kz_4 }
   }
   TRANSACTION 100
   {
     REQUEST { 0, 0x64 }
     REPLY   { response_code, device_status, x_interval_value_kz_5 }
   }
   TRANSACTION 101
   {
     REQUEST { 0, 0x65 }
     REPLY   { response_code, device_status, x_interval_value_kz_6 }
   }
   TRANSACTION 102
   {
     REQUEST { 0, 0x66 }
     REPLY   { response_code, device_status, x_interval_value_kz_7 }
   }
   TRANSACTION 103
   {
     REQUEST { 0, 0x67 }
     REPLY   { response_code, device_status, x_interval_value_kz_8 }
   }
   TRANSACTION 104
   {
     REQUEST { 0, 0x68 }
     REPLY   { response_code, device_status, x_interval_value_kz_9 }
   }
   TRANSACTION 105
   {
     REQUEST { 0, 0x69 }
     REPLY   { response_code, device_status, x_interval_value_kz_10 }
   }
   TRANSACTION 106
   {
     REQUEST { 0, 0x6A }
     REPLY   { response_code, device_status, x_interval_value_kz_11 }
   }
   TRANSACTION 107
   {
     REQUEST { 0, 0x6B }
     REPLY   { response_code, device_status, x_interval_value_kz_12 }
   }
   TRANSACTION 108
   {
     REQUEST { 0, 0x6C }
     REPLY   { response_code, device_status, x_interval_value_kz_13 }
   }
   TRANSACTION 109
   {
     REQUEST { 0, 0x6D }
     REPLY   { response_code, device_status, x_interval_value_kz_14 }
   }
   TRANSACTION 110
   {
     REQUEST { 0, 0x6E }
     REPLY   { response_code, device_status, x_interval_value_kz_15 }
   }
   TRANSACTION 111
   {
     REQUEST { 0, 0x6F }
     REPLY   { response_code, device_status, x_interval_value_kz_16 }
   }
   TRANSACTION 112
   {
     REQUEST { 0, 0x70 }
     REPLY   { response_code, device_status, x_interval_value_kz_17 }
   }
   TRANSACTION 113
   {
     REQUEST { 0, 0x71 }
     REPLY   { response_code, device_status, x_interval_value_kz_18 }
   }
   TRANSACTION 114
   {
     REQUEST { 0, 0x72 }
     REPLY   { response_code, device_status, x_interval_value_kz_19 }
   }
   TRANSACTION 115
   {
     REQUEST { 0, 0x73 }
     REPLY   { response_code, device_status, x_interval_value_kz_20 }
   }
   TRANSACTION 116
   {
     REQUEST { 0, 0x74 }
     REPLY   { response_code, device_status, x_interval_value_kz_21 }
   }
*/

   TRANSACTION 117
   {
     REQUEST { 0, 0x75 }
     REPLY   { response_code, device_status, diag_reference_info }
   }

   TRANSACTION 118
   {
     REQUEST { 0, 0x76 }
     REPLY   { response_code, device_status, hand_y_stat_test_information }
   }

/* mit cmd 157 erledigt

   TRANSACTION 121
   {
     REQUEST { 0, 0x79 }
     REPLY   { response_code, device_status, e_interval_value_long_0 }
   }

   TRANSACTION 122
   {
     REQUEST { 0, 0x7A }
     REPLY   { response_code, device_status, e_interval_value_long_1 }
   }

   TRANSACTION 123
   {
     REQUEST { 0, 0x7B }
     REPLY   { response_code, device_status, e_interval_value_long_2 }
   }

   TRANSACTION 124
   {
     REQUEST { 0, 0x7C }
     REPLY   { response_code, device_status, e_interval_value_long_3 }
   }

   TRANSACTION 125
   {
     REQUEST { 0, 0x7D }
     REPLY   { response_code, device_status, e_interval_value_long_4 }
   }

   TRANSACTION 126
   {
     REQUEST { 0, 0x7E }
     REPLY   { response_code, device_status, e_interval_value_long_5 }
   }

   TRANSACTION 127
   {
     REQUEST { 0, 0x7F }
     REPLY   { response_code, device_status, e_interval_value_long_6 }
   }

   TRANSACTION 128
   {
     REQUEST { 0, 0x80 }
     REPLY   { response_code, device_status, e_interval_value_long_7 }
   }

   TRANSACTION 129
   {
     REQUEST { 0, 0x81 }
     REPLY   { response_code, device_status, e_interval_value_long_8 }
   }

   TRANSACTION 130
   {
     REQUEST { 0, 0x82 }
     REPLY   { response_code, device_status, e_interval_value_long_9 }
   }

   TRANSACTION 131
   {
     REQUEST { 0, 0x83 }
     REPLY   { response_code, device_status, e_interval_value_long_10 }
   }

   TRANSACTION 132
   {
     REQUEST { 0, 0x84 }
     REPLY   { response_code, device_status, e_interval_value_long_11 }
   }

   TRANSACTION 133
   {
     REQUEST { 0, 0x85 }
     REPLY   { response_code, device_status, e_interval_value_short_0 }
   }
   TRANSACTION 134
   {
     REQUEST { 0, 0x86 }
     REPLY   { response_code, device_status, e_interval_value_short_1 }
   }
   TRANSACTION 135
   {
     REQUEST { 0, 0x87 }
     REPLY   { response_code, device_status, e_interval_value_short_2 }
   }
   TRANSACTION 136
   {
     REQUEST { 0, 0x88 }
     REPLY   { response_code, device_status, e_interval_value_short_3 }
   }
   TRANSACTION 137
   {
     REQUEST { 0, 0x89 }
     REPLY   { response_code, device_status, e_interval_value_short_4 }
   }
   TRANSACTION 138
   {
     REQUEST { 0, 0x8A }
     REPLY   { response_code, device_status, e_interval_value_short_5 }
   }
   TRANSACTION 139
   {
     REQUEST { 0, 0x8B }
     REPLY   { response_code, device_status, e_interval_value_short_6 }
   }
   TRANSACTION 140
   {
     REQUEST { 0, 0x8C }
     REPLY   { response_code, device_status, e_interval_value_short_7 }
   }
   TRANSACTION 141
   {
     REQUEST { 0, 0x8D }
     REPLY   { response_code, device_status, e_interval_value_short_8 }
   }
   TRANSACTION 142
   {
     REQUEST { 0, 0x8E }
     REPLY   { response_code, device_status, e_interval_value_short_9 }
   }
   TRANSACTION 143
   {
     REQUEST { 0, 0x8F }
     REPLY   { response_code, device_status, e_interval_value_short_10 }
   }
   TRANSACTION 144
   {
     REQUEST { 0, 0x90 }
     REPLY   { response_code, device_status, e_interval_value_short_11 }
   }

   TRANSACTION 162
   {
     REQUEST { 0, 0xA2 }
     REPLY   { response_code, device_status, his_z_intervallwert_0 }
   }
   TRANSACTION 163
   {
     REQUEST { 0, 0xA3 }
     REPLY   { response_code, device_status, his_z_intervallwert_1 }
   }
   TRANSACTION 164
   {
     REQUEST { 0, 0xA4 }
     REPLY   { response_code, device_status, his_z_intervallwert_2 }
   }
   TRANSACTION 165
   {
     REQUEST { 0, 0xA5 }
     REPLY   { response_code, device_status, his_z_intervallwert_3 }
   }
   TRANSACTION 166
   {
     REQUEST { 0, 0xA6 }
     REPLY   { response_code, device_status, his_z_intervallwert_4 }
   }
   TRANSACTION 167
   {
     REQUEST { 0, 0xA7 }
     REPLY   { response_code, device_status, his_z_intervallwert_5 }
   }
   TRANSACTION 168
   {
     REQUEST { 0, 0xA8 }
     REPLY   { response_code, device_status, his_z_intervallwert_6 }
   }
   TRANSACTION 169
   {
     REQUEST { 0, 0xA9 }
     REPLY   { response_code, device_status, his_z_intervallwert_7 }
   }
   TRANSACTION 170
   {
     REQUEST { 0, 0xAA }
     REPLY   { response_code, device_status, his_z_intervallwert_8 }
   }
   TRANSACTION 171
   {
     REQUEST { 0, 0xAB }
     REPLY   { response_code, device_status, his_z_intervallwert_9 }
   }
   TRANSACTION 172
   {
     REQUEST { 0, 0xAC }
     REPLY   { response_code, device_status, his_z_intervallwert_10 }
   }
   TRANSACTION 173
   {
     REQUEST { 0, 0xAD }
     REPLY   { response_code, device_status, his_z_intervallwert_11 }
   }
   TRANSACTION 174
   {
     REQUEST { 0, 0xAE }
     REPLY   { response_code, device_status, his_z_intervallwert_12 }
   }

   TRANSACTION 175
   {
     REQUEST { 0, 0xAF }
     REPLY   { response_code, device_status, his_z_intervallwert_short_0 }
   }
   TRANSACTION 176
   {
     REQUEST { 0, 0xB0 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_1 }
   }
   TRANSACTION 177
   {
     REQUEST { 0, 0xB1 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_2 }
   }
   TRANSACTION 178
   {
     REQUEST { 0, 0xB2 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_3 }
   }
   TRANSACTION 179
   {
     REQUEST { 0, 0xB3 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_4 }
   }
   TRANSACTION 180
   {
     REQUEST { 0, 0xB4 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_5 }
   }
   TRANSACTION 181
   {
     REQUEST { 0, 0xB5 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_6 }
   }
   TRANSACTION 182
   {
     REQUEST { 0, 0xB6 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_7 }
   }
   TRANSACTION 183
   {
     REQUEST { 0, 0xB7 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_8 }
   }
   TRANSACTION 184
   {
     REQUEST { 0, 0xB8 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_9 }
   }
   TRANSACTION 185
   {
     REQUEST { 0, 0xB9 }
     REPLY   { response_code, device_status, his_z_intervallwert_short_10 }
   }
   TRANSACTION 186
   {
     REQUEST { 0, 0xBA }
     REPLY   { response_code, device_status, his_z_intervallwert_short_11 }
   }
   TRANSACTION 187
   {
     REQUEST { 0, 0xBB }
     REPLY   { response_code, device_status, his_z_intervallwert_short_12 }
   }
*/

   TRANSACTION 188
   {
     REQUEST { 0, 0xBC }
     REPLY   { response_code, device_status, start_abort_hysteresis_online_test }
   }

   TRANSACTION 254
   {
     REQUEST { 0, 0xFE }
     REPLY   { response_code, device_status, hand_y_stat_step_progress }
   }

   TRANSACTION 255
   {
     REQUEST { 0, 0xFF }
     REPLY   { response_code, device_status, start_abort_drive_signal_diagram_steady }
   }

   TRANSACTION 258
   {
     REQUEST { 0x01, 0x02 }
     REPLY   { response_code, device_status, hys_ref_vs_0 }
   }
   TRANSACTION 259
   {
     REQUEST { 0x01, 0x03 }
     REPLY   { response_code, device_status, hys_ref_vs_1 }
   }
   TRANSACTION 260
   {
     REQUEST { 0x01, 0x04 }
     REPLY   { response_code, device_status, hys_ref_vs_2 }
   }
   TRANSACTION 261
   {
     REQUEST { 0x01, 0x05 }
     REPLY   { response_code, device_status, hys_ref_vs_3 }
   }
   TRANSACTION 262
   {
     REQUEST { 0x01, 0x06 }
     REPLY   { response_code, device_status, hys_ref_vs_4 }
   }
   TRANSACTION 263
   {
     REQUEST { 0x01, 0x07 }
     REPLY   { response_code, device_status, hys_ref_vs_5 }
   }
   TRANSACTION 264
   {
     REQUEST { 0x01, 0x08 }
     REPLY   { response_code, device_status, hys_ref_vs_6 }
   }
   TRANSACTION 265
   {
     REQUEST { 0x01, 0x09 }
     REPLY   { response_code, device_status, hys_ref_vs_7 }
   }
   TRANSACTION 266
   {
     REQUEST { 0x01, 0x0A }
     REPLY   { response_code, device_status, hys_ref_vs_8 }
   }
   TRANSACTION 267
   {
     REQUEST { 0x01, 0x0B }
     REPLY   { response_code, device_status, hys_ref_vs_9 }
   }
   TRANSACTION 268
   {
     REQUEST { 0x01, 0x0C }
     REPLY   { response_code, device_status, hys_ref_vs_10 }
   }
   TRANSACTION 269
   {
     REQUEST { 0x01, 0x0D }
     REPLY   { response_code, device_status, hys_ref_vs_11 }
   }

   TRANSACTION 273
   {
     REQUEST { 0x01, 0x11 }
     REPLY   { response_code, device_status, start_abort_drive_signal_diagram_hysteresis }
   }

   TRANSACTION 274
   {
     REQUEST { 0x01, 0x12 }
     REPLY   { response_code, device_status, hand_y_hys_step_progress }
   }

   TRANSACTION 275
   {
     REQUEST { 0x01, 0x13 }
     REPLY   { response_code, device_status, start_abort_static_characteristic }
   }

  TRANSACTION 276
  {
    REQUEST { 0x01, 0x14 }
    REPLY   { response_code, device_status, kl_delay_time_after_step }
  }

  TRANSACTION 277
  {
    REQUEST { 0x01, 0x15 }
    REPLY   { response_code, device_status, kl_anzahl_bis_umkehr }
  }

   TRANSACTION 280
   {
     REQUEST { 0x01, 0x18 }
     REPLY   { response_code, device_status, kl_step_progress }
   }

   TRANSACTION 281
   {
     REQUEST { 0x01, 0x19 }
     REPLY   { response_code, device_status, start_abort_step_response_test }
   }

   TRANSACTION 282
   {
     REQUEST { 0x01, 0x1A }
     REPLY   { response_code, device_status, step_progress }
   }

   TRANSACTION 287
   {
     REQUEST { 0x01, 0x1F }
     REPLY   { response_code, device_status, start_abort_tests_in_turn }
   }

   TRANSACTION 288
   {
     REQUEST { 0x01, 0x20 }
     REPLY   { response_code, device_status, his_x_mittelwert_int_1 }
   }

   TRANSACTION 289
   {
     REQUEST { 0x01, 0x21 }
     REPLY   { response_code, device_status, his_x_mittelwert_kurz }
   }

   TRANSACTION 290
   {
     REQUEST { 0x01, 0x22 }
     REPLY   { response_code, device_status, mittelwert_e_lang }
   }

   TRANSACTION 291
   {
     REQUEST { 0x01, 0x23 }
     REPLY   { response_code, device_status, step_selection }
   }

   TRANSACTION 296
   {
     REQUEST { 0x01, 0x28 }
     REPLY   { response_code, device_status, his_e_mittelwert_kurz }
   }

   TRANSACTION 297
   {
     REQUEST { 0x01, 0x29 }
     REPLY   { response_code, device_status, his_z_mittelwert_int }
   }

   TRANSACTION 298
   {
     REQUEST { 0x01, 0x2A }
     REPLY   { response_code, device_status, his_z_mittelwert_kurz }
   }

   TRANSACTION 300
   {
     REQUEST { 0x01, 0x2C }
     REPLY   { response_code, device_status, temperature_error }
   }

   TRANSACTION 301
   {
     REQUEST { 0x01, 0x2D }
     REPLY   { response_code, device_status, start_abort_reference_test }
   }

   TRANSACTION 306
   {
     REQUEST { 0x01, 0x32 }
     REPLY   { response_code, device_status, error_code_81_ref_test_aborted }
   }


/* Anfang PST */
   TRANSACTION 309
   {
     REQUEST { 0x01, 0x35 }
     REPLY   { response_code, device_status, pst_mode_on_off }
   }

   TRANSACTION 310
   {
     REQUEST { 0x01, 0x36 }
     REPLY   { response_code, device_status, pst_operating_mode }
   }

   TRANSACTION 313
   {
     REQUEST { 0x01, 0x39 }
     REPLY   { response_code, device_status, pst_activation_ramp_function }
   }

   TRANSACTION 314
   {
     REQUEST { 0x01, 0x3A }
     REPLY   { response_code, device_status, pst_activation_tol_band_control }
   }

   TRANSACTION 319
   {
     REQUEST { 0x01, 0x3F }
     REPLY   { response_code, device_status, pst_fault_alarm_output }
   }

   TRANSACTION 322
   {
     REQUEST { 0x01, 0x42 }
     REPLY   { response_code, device_status, pst_activation_y_control }
   }

   TRANSACTION 323
   {
     REQUEST { 0x01, 0x43 }
     REPLY   { response_code, device_status, pst_activation_x_control }
   }
/* Ende PST */


   TRANSACTION 334
   {
     REQUEST { 0x01, 0x4E }
     REPLY   { response_code, device_status, condensed_mask_temp_40 }
   }

   TRANSACTION 336
   {
     REQUEST { 0x01, 0x50 }
     REPLY   { response_code, device_status, condensed_mask_temp_80 }
   }

   TRANSACTION 408
   {
     REQUEST { 0x01, 0x98 }
     REPLY   { response_code, device_status, test_information }
   }

   TRANSACTION 409
   {
     REQUEST { 0x01, 0x99 }
     REPLY   { response_code, device_status, hand_y_hys_test_information }
   }

/* Stellbereich 410-415 */
   TRANSACTION 410
   {
     REQUEST { 0x01, 0x9A }
     REPLY   { response_code, device_status, WorkingRange_1_condensed_mask }
   }
   TRANSACTION 411
   {
     REQUEST { 0x01, 0x9B }
     REPLY   { response_code, device_status, WorkingRange_2_condensed_mask }
   }
   TRANSACTION 412
   {
     REQUEST { 0x01, 0x9C }
     REPLY   { response_code, device_status, WorkingRange_3_condensed_mask }
   }
   TRANSACTION 413
   {
     REQUEST { 0x01, 0x9D }
     REPLY   { response_code, device_status, WorkingRange_4_condensed_mask }
   }

/* Trend Stellbereich 416-419 */
   TRANSACTION 416
   {
     REQUEST { 0x01, 0xA0 }
     REPLY   { response_code, device_status, ShiftingWorkingRange_1_condensed_mask }
   }
   TRANSACTION 417
   {
     REQUEST { 0x01, 0xA1 }
     REPLY   { response_code, device_status, ShiftingWorkingRange_2_condensed_mask }
   }

/* Beschraenkung Stellbereich 420-424 */
   TRANSACTION 420
   {
     REQUEST { 0x01, 0xA4 }
     REPLY   { response_code, device_status, LimitWorkingRange_1_condensed_mask }
   }
   TRANSACTION 421
   {
     REQUEST { 0x01, 0xA5 }
     REPLY   { response_code, device_status, LimitWorkingRange_2_condensed_mask }
   }
   TRANSACTION 422
   {
     REQUEST { 0x01, 0xA6 }
     REPLY   { response_code, device_status, LimitWorkingRange_3_condensed_mask }
   }

/* Trend Endlage 425-432 */
   TRANSACTION 425
   {
     REQUEST { 0x01, 0xA9 }
     REPLY   { response_code, device_status, ObservingEndPosition_1_condensed_mask }
   }
   TRANSACTION 426
   {
     REQUEST { 0x01, 0xAA }
     REPLY   { response_code, device_status, ObservingEndPosition_2_condensed_mask }
   }
   TRANSACTION 427
   {
     REQUEST { 0x01, 0xAB }
     REPLY   { response_code, device_status, ObservingEndPosition_3_condensed_mask }
   }
   TRANSACTION 428
   {
     REQUEST { 0x01, 0xAC }
     REPLY   { response_code, device_status, ObservingEndPosition_4_condensed_mask }
   }
   TRANSACTION 429
   {
     REQUEST { 0x01, 0xAD }
     REPLY   { response_code, device_status, ObservingEndPosition_5_condensed_mask }
   }
   TRANSACTION 430
   {
     REQUEST { 0x01, 0xAE }
     REPLY   { response_code, device_status, ObservingEndPosition_6_condensed_mask }
   }

/* Verbindung Regler - Ventil 436-440 */
   TRANSACTION 436
   {
     REQUEST { 0x01, 0xB4 }
     REPLY   { response_code, device_status, ConnectionPosValve_1_condensed_mask }
   }
   TRANSACTION 437
   {
     REQUEST { 0x01, 0xB5 }
     REPLY   { response_code, device_status, ConnectionPosValve_2_condensed_mask }
   }
   TRANSACTION 438
   {
     REQUEST { 0x01, 0xB6 }
     REPLY   { response_code, device_status, ConnectionPosValve_3_condensed_mask }
   }

/* Antriebsfedern 441-447 */
   TRANSACTION 441
   {
     REQUEST { 0x01, 0xB9 }
     REPLY   { response_code, device_status, ActSpring_1_condensed_mask }
   }
   TRANSACTION 442
   {
     REQUEST { 0x01, 0xBA }
     REPLY   { response_code, device_status, ActSpring_2_condensed_mask }
   }
   TRANSACTION 443
   {
     REQUEST { 0x01, 0xBB }
     REPLY   { response_code, device_status, ActSpring_3_condensed_mask }
   }
   TRANSACTION 444
   {
     REQUEST { 0x01, 0xBC }
     REPLY   { response_code, device_status, ActSpring_4_condensed_mask }
   }
   TRANSACTION 445
   {
     REQUEST { 0x01, 0xBD }
     REPLY   { response_code, device_status, ActSpring_5_condensed_mask }
   }

/* Zuluftdruck 448-455 */
   TRANSACTION 448
   {
     REQUEST { 0x01, 0xC0 }
     REPLY   { response_code, device_status, AirSupply_1_condensed_mask }
   }
   TRANSACTION 449
   {
     REQUEST { 0x01, 0xC1 }
     REPLY   { response_code, device_status, AirSupply_2_condensed_mask }
   }
   TRANSACTION 450
   {
     REQUEST { 0x01, 0xC2 }
     REPLY   { response_code, device_status, AirSupply_3_condensed_mask }
   }
   TRANSACTION 451
   {
     REQUEST { 0x01, 0xC3 }
     REPLY   { response_code, device_status, AirSupply_4_condensed_mask }
   }
   TRANSACTION 452
   {
     REQUEST { 0x01, 0xC4 }
     REPLY   { response_code, device_status, AirSupply_5_condensed_mask }
   }
   TRANSACTION 453
   {
     REQUEST { 0x01, 0xC5 }
     REPLY   { response_code, device_status, AirSupply_6_condensed_mask }
   }

/* Leckage Pneumatik 456-460 */
   TRANSACTION 456
   {
     REQUEST { 0x01, 0xC8 }
     REPLY   { response_code, device_status, LeakagePn_1_condensed_mask }
   }
   TRANSACTION 457
   {
     REQUEST { 0x01, 0xC9 }
     REPLY   { response_code, device_status, LeakagePn_3_condensed_mask }
   }
   TRANSACTION 458
   {
     REQUEST { 0x01, 0xCA }
     REPLY   { response_code, device_status, LeakagePn_4_condensed_mask }
   }
   TRANSACTION 459
   {
     REQUEST { 0x01, 0xCB }
     REPLY   { response_code, device_status, LeakagePn_2_condensed_mask }
   }

/* Reibung 461-466 */
   TRANSACTION 461
   {
     REQUEST { 0x01, 0xCD }
     REPLY   { response_code, device_status, Friction_1_condensed_mask }
   }
   TRANSACTION 462
   {
     REQUEST { 0x01, 0xCE }
     REPLY   { response_code, device_status, Friction_2_condensed_mask }
   }
   TRANSACTION 463
   {
     REQUEST { 0x01, 0xCF }
     REPLY   { response_code, device_status, Friction_3_condensed_mask }
   }
   TRANSACTION 464
   {
     REQUEST { 0x01, 0xD0 }
     REPLY   { response_code, device_status, Friction_4_condensed_mask }
   }
   TRANSACTION 465
   {
     REQUEST { 0x01, 0xD1 }
     REPLY   { response_code, device_status, Friction_5_condensed_mask }
   }
   TRANSACTION 466
   {
     REQUEST { 0x01, 0xD2 }
     REPLY   { response_code, device_status, Friction_6_condensed_mask }
   }

/* Innere Leckage 467-470 */
   TRANSACTION 467
   {
     REQUEST { 0x01, 0xD3 }
     REPLY   { response_code, device_status, InnerLeakage_1_condensed_mask }
   }
   TRANSACTION 468
   {
     REQUEST { 0x01, 0xD4 }
     REPLY   { response_code, device_status, InnerLeakage_2_condensed_mask }
   }
   TRANSACTION 469
   {
     REQUEST { 0x01, 0xD5 }
     REPLY   { response_code, device_status, InnerLeakage_3_condensed_mask }
   }

/* Externe Leckage 471-474 */
   TRANSACTION 471
   {
     REQUEST { 0x01, 0xD7 }
     REPLY   { response_code, device_status, ExternalLeakage_1_condensed_mask }
   }
   TRANSACTION 472
   {
     REQUEST { 0x01, 0xD8 }
     REPLY   { response_code, device_status, ExternalLeakage_2_condensed_mask }
   }

   TRANSACTION 475 /* PST 475 */
   {
     REQUEST { 0x01, 0xDB }
     REPLY   { response_code, device_status, PST_1_condensed_mask }
   }


   TRANSACTION 502
   {
     REQUEST { 0x01, 0xF6 }
     REPLY   { response_code, device_status, automatical_test_status }
   }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  }
}



/* ------------------------------------------------------------------------ */
/* Command 150     Write Diagnose - Float Werte schreiben                   */
/* ------------------------------------------------------------------------ */
COMMAND write_diagnosis_floats
{
  NUMBER 150;
  OPERATION WRITE;

   TRANSACTION 1
   {
     REQUEST { 0, 1, start_value }
     REPLY   { response_code, device_status, start_value }
   }

  TRANSACTION 282
  {
    REQUEST { 0x01, 0x1A, kl_stepstart }
    REPLY   { response_code, device_status, kl_stepstart }
  }

  TRANSACTION 283
  {
    REQUEST { 0x01, 0x1B, kl_stepend }
    REPLY   { response_code, device_status, kl_stepend }
  }

   TRANSACTION 288
   {
     REQUEST { 1, 0x20, stepstart }
     REPLY   { response_code, device_status, stepstart }
   }

   TRANSACTION 289
   {
     REQUEST { 1, 0x21, stepend }
     REPLY   { response_code, device_status, stepend }
   }

/* Anfang PST */
   TRANSACTION 366
   {
     REQUEST { 1, 0x6E, pst_tolerance_band }
     REPLY   { response_code, device_status, pst_tolerance_band }
   }

   TRANSACTION 376
   {
     REQUEST { 1, 0x78, pst_step_tolerance_limit }
     REPLY   { response_code, device_status, pst_step_tolerance_limit }
   }

   TRANSACTION 1563
   {
     REQUEST { 6, 0x1B, pst_y_control_value }
     REPLY   { response_code, device_status, pst_y_control_value }
   }

   TRANSACTION 1564
   {
     REQUEST { 6, 0x1C, pst_x_control_value }
     REPLY   { response_code, device_status, pst_x_control_value }
   }
/* Ende PST */


  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 151     Read Diagnose - Float Werte lesen                        */
/* ------------------------------------------------------------------------ */
COMMAND read_diagnosis_floats
{
  NUMBER 151;
  OPERATION READ;

  TRANSACTION 1
  {
    REQUEST { 0, 0x01 }
    REPLY   { response_code, device_status, start_value }
  }

  TRANSACTION 7
  {
    REQUEST { 0, 0x07 }
    REPLY   { response_code, device_status, deviation_min }
  }

  TRANSACTION 8
  {
    REQUEST { 0, 0x08 }
    REPLY   { response_code, device_status, deviation_max }
  }

/* mit cmd 157 erledigt

  TRANSACTION 46
  {
    REQUEST { 0, 0x2E }
    REPLY   { response_code, device_status, average_value_stat_long_1 }
  }
  TRANSACTION 47
  {
    REQUEST { 0, 0x2F }
    REPLY   { response_code, device_status, average_value_stat_long_2 }
  }
  TRANSACTION 48
  {
    REQUEST { 0, 0x30 }
    REPLY   { response_code, device_status, average_value_stat_long_3 }
  }
  TRANSACTION 49
  {
    REQUEST { 0, 0x31 }
    REPLY   { response_code, device_status, average_value_stat_long_4 }
  }
  TRANSACTION 50
  {
    REQUEST { 0, 0x32 }
    REPLY   { response_code, device_status, average_value_stat_long_5 }
  }
  TRANSACTION 51
  {
    REQUEST { 0, 0x33 }
    REPLY   { response_code, device_status, average_value_stat_long_6 }
  }
  TRANSACTION 52
  {
    REQUEST { 0, 0x34 }
    REPLY   { response_code, device_status, average_value_stat_long_7 }
  }
  TRANSACTION 53
  {
    REQUEST { 0, 0x35 }
    REPLY   { response_code, device_status, average_value_stat_long_8 }
  }
  TRANSACTION 54
  {
    REQUEST { 0, 0x36 }
    REPLY   { response_code, device_status, average_value_stat_long_9 }
  }
  TRANSACTION 55
  {
    REQUEST { 0, 0x37 }
    REPLY   { response_code, device_status, average_value_stat_long_10 }
  }
  TRANSACTION 56
  {
    REQUEST { 0, 0x38 }
    REPLY   { response_code, device_status, average_value_stat_long_11 }
  }
  TRANSACTION 57
  {
    REQUEST { 0, 0x39 }
    REPLY   { response_code, device_status, average_value_stat_long_12 }
  }
  TRANSACTION 58
  {
    REQUEST { 0, 0x3A }
    REPLY   { response_code, device_status, average_value_stat_long_13 }
  }
  TRANSACTION 59
  {
    REQUEST { 0, 0x3B }
    REPLY   { response_code, device_status, average_value_stat_long_14 }
  }
  TRANSACTION 60
  {
    REQUEST { 0, 0x3C }
    REPLY   { response_code, device_status, average_value_stat_long_15 }
  }
  TRANSACTION 61
  {
    REQUEST { 0, 0x3D }
    REPLY   { response_code, device_status, average_value_stat_long_16 }
  }
  TRANSACTION 62
  {
    REQUEST { 0, 0x3E }
    REPLY   { response_code, device_status, average_value_stat_long_17 }
  }
  TRANSACTION 63
  {
    REQUEST { 0, 0x3F }
    REPLY   { response_code, device_status, average_value_stat_long_18 }
  }
  TRANSACTION 64
  {
    REQUEST { 0, 0x40 }
    REPLY   { response_code, device_status, average_value_stat_long_19 }
  }
  TRANSACTION 65
  {
    REQUEST { 0, 0x41 }
    REPLY   { response_code, device_status, average_value_stat_long_20 }
  }
  TRANSACTION 66
  {
    REQUEST { 0, 0x42 }
    REPLY   { response_code, device_status, average_value_stat_long_21 }
  }
  TRANSACTION 67
  {
    REQUEST { 0, 0x43 }
    REPLY   { response_code, device_status, average_value_stat_long_22 }
  }

  TRANSACTION 68
  {
    REQUEST { 0, 0x44 }
    REPLY   { response_code, device_status, average_value_stat_short_1 }
  }
  TRANSACTION 69
  {
    REQUEST { 0, 0x45 }
    REPLY   { response_code, device_status, average_value_stat_short_2 }
  }
  TRANSACTION 70
  {
    REQUEST { 0, 0x46 }
    REPLY   { response_code, device_status, average_value_stat_short_3 }
  }
  TRANSACTION 71
  {
    REQUEST { 0, 0x47 }
    REPLY   { response_code, device_status, average_value_stat_short_4 }
  }
  TRANSACTION 72
  {
    REQUEST { 0, 0x48 }
    REPLY   { response_code, device_status, average_value_stat_short_5 }
  }
  TRANSACTION 73
  {
    REQUEST { 0, 0x49 }
    REPLY   { response_code, device_status, average_value_stat_short_6 }
  }
  TRANSACTION 74
  {
    REQUEST { 0, 0x4A }
    REPLY   { response_code, device_status, average_value_stat_short_7 }
  }
  TRANSACTION 75
  {
    REQUEST { 0, 0x4B }
    REPLY   { response_code, device_status, average_value_stat_short_8 }
  }
  TRANSACTION 76
  {
    REQUEST { 0, 0x4C }
    REPLY   { response_code, device_status, average_value_stat_short_9 }
  }
  TRANSACTION 77
  {
    REQUEST { 0, 0x4D }
    REPLY   { response_code, device_status, average_value_stat_short_10 }
  }
  TRANSACTION 78
  {
    REQUEST { 0, 0x4E }
    REPLY   { response_code, device_status, average_value_stat_short_11 }
  }
  TRANSACTION 79
  {
    REQUEST { 0, 0x4F }
    REPLY   { response_code, device_status, average_value_stat_short_12 }
  }
  TRANSACTION 80
  {
    REQUEST { 0, 0x50 }
    REPLY   { response_code, device_status, average_value_stat_short_13 }
  }
  TRANSACTION 81
  {
    REQUEST { 0, 0x51 }
    REPLY   { response_code, device_status, average_value_stat_short_14 }
  }
  TRANSACTION 82
  {
    REQUEST { 0, 0x52 }
    REPLY   { response_code, device_status, average_value_stat_short_15 }
  }
  TRANSACTION 83
  {
    REQUEST { 0, 0x53 }
    REPLY   { response_code, device_status, average_value_stat_short_16 }
  }
  TRANSACTION 84
  {
    REQUEST { 0, 0x54 }
    REPLY   { response_code, device_status, average_value_stat_short_17 }
  }
  TRANSACTION 85
  {
    REQUEST { 0, 0x55 }
    REPLY   { response_code, device_status, average_value_stat_short_18 }
  }
  TRANSACTION 86
  {
    REQUEST { 0, 0x56 }
    REPLY   { response_code, device_status, average_value_stat_short_19 }
  }
  TRANSACTION 87
  {
    REQUEST { 0, 0x57 }
    REPLY   { response_code, device_status, average_value_stat_short_20 }
  }
  TRANSACTION 88
  {
    REQUEST { 0, 0x58 }
    REPLY   { response_code, device_status, average_value_stat_short_21 }
  }
  TRANSACTION 89
  {
    REQUEST { 0, 0x59 }
    REPLY   { response_code, device_status, average_value_stat_short_22 }
  }

  TRANSACTION 100
  {
    REQUEST { 0, 0x64 }
    REPLY   { response_code, device_status, average_value_long_1 }
  }

  TRANSACTION 101
  {
    REQUEST { 0, 0x65 }
    REPLY   { response_code, device_status, average_value_long_2 }
  }

  TRANSACTION 102
  {
    REQUEST { 0, 0x66 }
    REPLY   { response_code, device_status, average_value_long_3 }
  }

  TRANSACTION 103
  {
    REQUEST { 0, 0x67 }
    REPLY   { response_code, device_status, average_value_long_4 }
  }

  TRANSACTION 104
  {
    REQUEST { 0, 0x68 }
    REPLY   { response_code, device_status, average_value_long_5 }
  }

  TRANSACTION 105
  {
    REQUEST { 0, 0x69 }
    REPLY   { response_code, device_status, average_value_long_6 }
  }

  TRANSACTION 106
  {
    REQUEST { 0, 0x6A }
    REPLY   { response_code, device_status, average_value_long_7 }
  }

  TRANSACTION 107
  {
    REQUEST { 0, 0x6B }
    REPLY   { response_code, device_status, average_value_long_8 }
  }

  TRANSACTION 108
  {
    REQUEST { 0, 0x6C }
    REPLY   { response_code, device_status, average_value_long_9 }
  }

  TRANSACTION 109
  {
    REQUEST { 0, 0x6D }
    REPLY   { response_code, device_status, average_value_long_10 }
  }

  TRANSACTION 110
  {
    REQUEST { 0, 0x6E }
    REPLY   { response_code, device_status, average_value_long_11 }
  }

  TRANSACTION 111
  {
    REQUEST { 0, 0x6F }
    REPLY   { response_code, device_status, average_value_long_12 }
  }

  TRANSACTION 112
  {
    REQUEST { 0, 0x70 }
    REPLY   { response_code, device_status, average_value_long_13 }
  }

  TRANSACTION 113
  {
    REQUEST { 0, 0x71 }
    REPLY   { response_code, device_status, average_value_long_14 }
  }

  TRANSACTION 114
  {
    REQUEST { 0, 0x72 }
    REPLY   { response_code, device_status, average_value_long_15 }
  }

  TRANSACTION 115
  {
    REQUEST { 0, 0x73 }
    REPLY   { response_code, device_status, average_value_long_16 }
  }

  TRANSACTION 116
  {
    REQUEST { 0, 0x74 }
    REPLY   { response_code, device_status, average_value_long_17 }
  }

  TRANSACTION 117
  {
    REQUEST { 0, 0x75 }
    REPLY   { response_code, device_status, average_value_long_18 }
  }

  TRANSACTION 118
  {
    REQUEST { 0, 0x76 }
    REPLY   { response_code, device_status, average_value_long_19 }
  }
*/

  TRANSACTION 185
  {
    REQUEST { 0, 0xB9 }
    REPLY   { response_code, device_status, valve_pos_meas_point_1 }
  }
  TRANSACTION 186
  {
    REQUEST { 0, 0xBA }
    REPLY   { response_code, device_status, valve_pos_meas_point_2 }
  }
  TRANSACTION 187
  {
    REQUEST { 0, 0xBB }
    REPLY   { response_code, device_status, valve_pos_meas_point_3 }
  }
  TRANSACTION 188
  {
    REQUEST { 0, 0xBC }
    REPLY   { response_code, device_status, valve_pos_meas_point_4 }
  }
  TRANSACTION 189
  {
    REQUEST { 0, 0xBD }
    REPLY   { response_code, device_status, valve_pos_meas_point_5 }
  }
  TRANSACTION 190
  {
    REQUEST { 0, 0xBE }
    REPLY   { response_code, device_status, valve_pos_meas_point_6 }
  }
  TRANSACTION 191
  {
    REQUEST { 0, 0xBF }
    REPLY   { response_code, device_status, valve_pos_meas_point_7 }
  }
  TRANSACTION 192
  {
    REQUEST { 0, 0xC0 }
    REPLY   { response_code, device_status, valve_pos_meas_point_8 }
  }
  TRANSACTION 193
  {
    REQUEST { 0, 0xC1 }
    REPLY   { response_code, device_status, valve_pos_meas_point_9 }
  }
  TRANSACTION 194
  {
    REQUEST { 0, 0xC2 }
    REPLY   { response_code, device_status, valve_pos_meas_point_10 }
  }
  TRANSACTION 195
  {
    REQUEST { 0, 0xC3 }
    REPLY   { response_code, device_status, valve_pos_meas_point_11 }
  }
  TRANSACTION 196
  {
    REQUEST { 0, 0xC4 }
    REPLY   { response_code, device_status, valve_pos_meas_point_12 }
  }
  TRANSACTION 197
  {
    REQUEST { 0, 0xC5 }
    REPLY   { response_code, device_status, valve_pos_meas_point_13 }
  }
  TRANSACTION 198
  {
    REQUEST { 0, 0xC6 }
    REPLY   { response_code, device_status, valve_pos_meas_point_14 }
  }
  TRANSACTION 199
  {
    REQUEST { 0, 0xC7 }
    REPLY   { response_code, device_status, valve_pos_meas_point_15 }
  }
  TRANSACTION 200
  {
    REQUEST { 0, 0xC8 }
    REPLY   { response_code, device_status, valve_pos_meas_point_16 }
  }
  TRANSACTION 201
  {
    REQUEST { 0, 0xC9 }
    REPLY   { response_code, device_status, valve_pos_meas_point_17 }
  }
  TRANSACTION 202
  {
    REQUEST { 0, 0xCA }
    REPLY   { response_code, device_status, valve_pos_meas_point_18 }
  }
  TRANSACTION 203
  {
    REQUEST { 0, 0xCB }
    REPLY   { response_code, device_status, valve_pos_meas_point_19 }
  }
  TRANSACTION 204
  {
    REQUEST { 0, 0xCC }
    REPLY   { response_code, device_status, valve_pos_meas_point_20 }
  }
  TRANSACTION 205
  {
    REQUEST { 0, 0xCD }
    REPLY   { response_code, device_status, valve_pos_meas_point_21 }
  }
  TRANSACTION 206
  {
    REQUEST { 0, 0xCE }
    REPLY   { response_code, device_status, valve_pos_meas_point_22 }
  }
  TRANSACTION 207
  {
    REQUEST { 0, 0xCF }
    REPLY   { response_code, device_status, valve_pos_meas_point_23 }
  }
  TRANSACTION 208
  {
    REQUEST { 0, 0xD0 }
    REPLY   { response_code, device_status, valve_pos_meas_point_24 }
  }
  TRANSACTION 209
  {
    REQUEST { 0, 0xD1 }
    REPLY   { response_code, device_status, valve_pos_meas_point_25 }
  }
  TRANSACTION 210
  {
    REQUEST { 0, 0xD2 }
    REPLY   { response_code, device_status, valve_pos_meas_point_26 }
  }
  TRANSACTION 211
  {
    REQUEST { 0, 0xD3 }
    REPLY   { response_code, device_status, valve_pos_meas_point_27 }
  }
  TRANSACTION 212
  {
    REQUEST { 0, 0xD4 }
    REPLY   { response_code, device_status, valve_pos_meas_point_28 }
  }
  TRANSACTION 213
  {
    REQUEST { 0, 0xD5 }
    REPLY   { response_code, device_status, valve_pos_meas_point_29 }
  }
  TRANSACTION 214
  {
    REQUEST { 0, 0xD6 }
    REPLY   { response_code, device_status, valve_pos_meas_point_30 }
  }

  TRANSACTION 216
  {
    REQUEST { 0, 0xD8 }
    REPLY   { response_code, device_status, ref_value_valve_position }
  }

/* mit cmd 157 gemacht

  TRANSACTION 217
  {
    REQUEST { 0, 0xD9 }
    REPLY   { response_code, device_status, stat_ref_vs_0 }
  }

  TRANSACTION 218
  {
    REQUEST { 0, 0xDA }
    REPLY   { response_code, device_status, stat_ref_vs_1 }
  }

  TRANSACTION 219
  {
    REQUEST { 0, 0xDB }
    REPLY   { response_code, device_status, stat_ref_vs_2 }
  }

  TRANSACTION 220
  {
    REQUEST { 0, 0xDC }
    REPLY   { response_code, device_status, stat_ref_vs_3 }
  }

  TRANSACTION 221
  {
    REQUEST { 0, 0xDD }
    REPLY   { response_code, device_status, stat_ref_vs_4 }
  }

  TRANSACTION 222
  {
    REQUEST { 0, 0xDE }
    REPLY   { response_code, device_status, stat_ref_vs_5 }
  }

  TRANSACTION 223
  {
    REQUEST { 0, 0xDF }
    REPLY   { response_code, device_status, stat_ref_vs_6 }
  }

  TRANSACTION 224
  {
    REQUEST { 0, 0xE0 }
    REPLY   { response_code, device_status, stat_ref_vs_7 }
  }

  TRANSACTION 225
  {
    REQUEST { 0, 0xE1 }
    REPLY   { response_code, device_status, stat_ref_vs_8 }
  }

  TRANSACTION 226
  {
    REQUEST { 0, 0xE2 }
    REPLY   { response_code, device_status, stat_ref_vs_9 }
  }

  TRANSACTION 227
  {
    REQUEST { 0, 0xE3 }
    REPLY   { response_code, device_status, stat_ref_vs_10 }
  }

  TRANSACTION 228
  {
    REQUEST { 0, 0xE4 }
    REPLY   { response_code, device_status, stat_ref_vs_11 }
  }

  TRANSACTION 229
  {
    REQUEST { 0, 0xE5 }
    REPLY   { response_code, device_status, stat_ref_vs_12 }
  }

  TRANSACTION 230
  {
    REQUEST { 0, 0xE6 }
    REPLY   { response_code, device_status, stat_ref_vs_13 }
  }

  TRANSACTION 231
  {
    REQUEST { 0, 0xE7 }
    REPLY   { response_code, device_status, stat_ref_vs_14 }
  }

  TRANSACTION 232
  {
    REQUEST { 0, 0xE8 }
    REPLY   { response_code, device_status, stat_ref_vs_15 }
  }

  TRANSACTION 233
  {
    REQUEST { 0, 0xE9 }
    REPLY   { response_code, device_status, stat_ref_vs_16 }
  }

  TRANSACTION 234
  {
    REQUEST { 0, 0xEA }
    REPLY   { response_code, device_status, stat_ref_vs_17 }
  }

  TRANSACTION 235
  {
    REQUEST { 0, 0xEB }
    REPLY   { response_code, device_status, stat_ref_vs_18 }
  }

  TRANSACTION 236
  {
    REQUEST { 0, 0xEC }
    REPLY   { response_code, device_status, stat_ref_vs_19 }
  }

  TRANSACTION 237
  {
    REQUEST { 0, 0xED }
    REPLY   { response_code, device_status, stat_ref_vs_20 }
  }

  TRANSACTION 238
  {
    REQUEST { 0, 0xEE }
    REPLY   { response_code, device_status, stat_ref_vs_21 }
  }

  TRANSACTION 239
  {
    REQUEST { 0, 0xEF }
    REPLY   { response_code, device_status, stat_ref_vs_22 }
  }

  TRANSACTION 240
  {
    REQUEST { 0, 0xF0 }
    REPLY   { response_code, device_status, stat_ref_vs_23 }
  }

  TRANSACTION 241
  {
    REQUEST { 0, 0xF1 }
    REPLY   { response_code, device_status, stat_ref_vs_24 }
  }

  TRANSACTION 242
  {
    REQUEST { 0, 0xF2 }
    REPLY   { response_code, device_status, stat_again_vs_0 }
  }

  TRANSACTION 243
  {
    REQUEST { 0, 0xF3 }
    REPLY   { response_code, device_status, stat_again_vs_1 }
  }

  TRANSACTION 244
  {
    REQUEST { 0, 0xF4 }
    REPLY   { response_code, device_status, stat_again_vs_2 }
  }

  TRANSACTION 245
  {
    REQUEST { 0, 0xF5 }
    REPLY   { response_code, device_status, stat_again_vs_3 }
  }

  TRANSACTION 246
  {
    REQUEST { 0, 0xF6 }
    REPLY   { response_code, device_status, stat_again_vs_4 }
  }

  TRANSACTION 247
  {
    REQUEST { 0, 0xF7 }
    REPLY   { response_code, device_status, stat_again_vs_5 }
  }

  TRANSACTION 248
  {
    REQUEST { 0, 0xF8 }
    REPLY   { response_code, device_status, stat_again_vs_6 }
  }

  TRANSACTION 249
  {
    REQUEST { 0, 0xF9 }
    REPLY   { response_code, device_status, stat_again_vs_7 }
  }

  TRANSACTION 250
  {
    REQUEST { 0, 0xFA }
    REPLY   { response_code, device_status, stat_again_vs_8 }
  }

  TRANSACTION 251
  {
    REQUEST { 0, 0xFB }
    REPLY   { response_code, device_status, stat_again_vs_9 }
  }

  TRANSACTION 252
  {
    REQUEST { 0, 0xFC }
    REPLY   { response_code, device_status, stat_again_vs_10 }
  }

  TRANSACTION 253
  {
    REQUEST { 0, 0xFD }
    REPLY   { response_code, device_status, stat_again_vs_11 }
  }

  TRANSACTION 254
  {
    REQUEST { 0, 0xFE }
    REPLY   { response_code, device_status, stat_again_vs_12 }
  }

  TRANSACTION 255
  {
    REQUEST { 0, 0xFF }
    REPLY   { response_code, device_status, stat_again_vs_13 }
  }

  TRANSACTION 256
  {
    REQUEST { 0x01, 0x00 }
    REPLY   { response_code, device_status, stat_again_vs_14 }
  }

  TRANSACTION 257
  {
    REQUEST { 0x01, 0x01 }
    REPLY   { response_code, device_status, stat_again_vs_15 }
  }

  TRANSACTION 258
  {
    REQUEST { 0x01, 0x02 }
    REPLY   { response_code, device_status, stat_again_vs_16 }
  }

  TRANSACTION 259
  {
    REQUEST { 0x01, 0x03 }
    REPLY   { response_code, device_status, stat_again_vs_17 }
  }

  TRANSACTION 260
  {
    REQUEST { 0x01, 0x04 }
    REPLY   { response_code, device_status, stat_again_vs_18 }
  }

  TRANSACTION 261
  {
    REQUEST { 0x01, 0x05 }
    REPLY   { response_code, device_status, stat_again_vs_19 }
  }

  TRANSACTION 262
  {
    REQUEST { 0x01, 0x06 }
    REPLY   { response_code, device_status, stat_again_vs_20 }
  }

  TRANSACTION 263
  {
    REQUEST { 0x01, 0x07 }
    REPLY   { response_code, device_status, stat_again_vs_21 }
  }

  TRANSACTION 264
  {
    REQUEST { 0x01, 0x08 }
    REPLY   { response_code, device_status, stat_again_vs_22 }
  }

  TRANSACTION 265
  {
    REQUEST { 0x01, 0x09 }
    REPLY   { response_code, device_status, stat_again_vs_23 }
  }

  TRANSACTION 266
  {
    REQUEST { 0x01, 0x0A }
    REPLY   { response_code, device_status, stat_again_vs_24 }
  }
*/

  TRANSACTION 282
  {
    REQUEST { 0x01, 0x1A }
    REPLY   { response_code, device_status, kl_stepstart }
  }

  TRANSACTION 283
  {
    REQUEST { 0x01, 0x1B }
    REPLY   { response_code, device_status, kl_stepend }
  }

  TRANSACTION 284
  {
    REQUEST { 0x01, 0x1C }
    REPLY   { response_code, device_status, kl_step_height }
  }

  TRANSACTION 285
  {
    REQUEST { 0x01, 0x1D }
    REPLY   { response_code, device_status, kl_min_dead_band }
  }

  TRANSACTION 286
  {
    REQUEST { 0x01, 0x1E }
    REPLY   { response_code, device_status, kl_average_dead_band }
  }

  TRANSACTION 287
  {
    REQUEST { 0x01, 0x1F }
    REPLY   { response_code, device_status, kl_max_dead_band }
  }

  TRANSACTION 288
  {
    REQUEST { 0x01, 0x20 }
    REPLY   { response_code, device_status, stepstart }
  }

  TRANSACTION 289
  {
    REQUEST { 0x01, 0x21 }
    REPLY   { response_code, device_status, stepend }
  }

  TRANSACTION 290
  {
    REQUEST { 0x01, 0x22 }
    REPLY   { response_code, device_status, overshoot_rising }
  }

  TRANSACTION 296
  {
    REQUEST { 0x01, 0x28 }
    REPLY   { response_code, device_status, overshoot_falling }
  }

/* Anfang PST */
   TRANSACTION 366
   {
     REQUEST { 1, 0x6E }
     REPLY   { response_code, device_status, pst_tolerance_band }
   }
/* Ende PST */


  TRANSACTION 369
  {
    REQUEST { 0x01, 0x71 }
    REPLY   { response_code, device_status, max_temperature }
  }

  TRANSACTION 370
  {
    REQUEST { 0x01, 0x72 }
    REPLY   { response_code, device_status, min_temperature }
  }

/* Anfang PST */
   TRANSACTION 376
   {
     REQUEST { 1, 0x78 }
     REPLY   { response_code, device_status, pst_step_tolerance_limit }
   }
/* Ende PST */

  TRANSACTION 389
  {
    REQUEST { 0x01, 0x85 }
    REPLY   { response_code, device_status, current_temperature }
  }

/*
  TRANSACTION 400
  {
    REQUEST { 1,144 }
    REPLY   { response_code, device_status, sprung_e_0 }
  }
  TRANSACTION 401
  {
    REQUEST { 1,145 }
    REPLY   { response_code, device_status, sprung_e_1 }
  }
  TRANSACTION 402
  {
    REQUEST { 1,146 }
    REPLY   { response_code, device_status, sprung_e_2 }
  }
  TRANSACTION 403
  {
    REQUEST { 1,147 }
    REPLY   { response_code, device_status, sprung_e_3 }
  }
  TRANSACTION 404
  {
    REQUEST { 1,148 }
    REPLY   { response_code, device_status, sprung_e_4 }
  }
  TRANSACTION 405
  {
    REQUEST { 1,149 }
    REPLY   { response_code, device_status, sprung_e_5 }
  }
  TRANSACTION 406
  {
    REQUEST { 1,150 }
    REPLY   { response_code, device_status, sprung_e_6 }
  }
  TRANSACTION 407
  {
    REQUEST { 1,151 }
    REPLY   { response_code, device_status, sprung_e_7 }
  }
  TRANSACTION 408
  {
    REQUEST { 1,152 }
    REPLY   { response_code, device_status, sprung_e_8 }
  }
  TRANSACTION 409
  {
    REQUEST { 1,153 }
    REPLY   { response_code, device_status, sprung_e_9 }
  }
  TRANSACTION 410
  {
    REQUEST { 1,154 }
    REPLY   { response_code, device_status, sprung_e_10 }
  }
  TRANSACTION 411
  {
    REQUEST { 1,155 }
    REPLY   { response_code, device_status, sprung_e_11 }
  }
  TRANSACTION 412
  {
    REQUEST { 1,156 }
    REPLY   { response_code, device_status, sprung_e_12 }
  }
  TRANSACTION 413
  {
    REQUEST { 1,157 }
    REPLY   { response_code, device_status, sprung_e_13 }
  }
  TRANSACTION 414
  {
    REQUEST { 1,158 }
    REPLY   { response_code, device_status, sprung_e_14 }
  }
  TRANSACTION 415
  {
    REQUEST { 1,159 }
    REPLY   { response_code, device_status, sprung_e_15 }
  }
  TRANSACTION 416
  {
    REQUEST { 1,160 }
    REPLY   { response_code, device_status, sprung_e_16 }
  }
  TRANSACTION 417
  {
    REQUEST { 1,161 }
    REPLY   { response_code, device_status, sprung_e_17 }
  }
  TRANSACTION 418
  {
    REQUEST { 1,162 }
    REPLY   { response_code, device_status, sprung_e_18 }
  }
  TRANSACTION 419
  {
    REQUEST { 1,163 }
    REPLY   { response_code, device_status, sprung_e_19 }
  }
  TRANSACTION 420
  {
    REQUEST { 1,164 }
    REPLY   { response_code, device_status, sprung_e_20 }
  }
  TRANSACTION 421
  {
    REQUEST { 1,165 }
    REPLY   { response_code, device_status, sprung_e_21 }
  }
  TRANSACTION 422
  {
    REQUEST { 1,166 }
    REPLY   { response_code, device_status, sprung_e_22 }
  }
  TRANSACTION 423
  {
    REQUEST { 1,167 }
    REPLY   { response_code, device_status, sprung_e_23 }
  }
  TRANSACTION 424
  {
    REQUEST { 1,168 }
    REPLY   { response_code, device_status, sprung_e_24 }
  }
  TRANSACTION 425
  {
    REQUEST { 1,169 }
    REPLY   { response_code, device_status, sprung_e_25 }
  }
  TRANSACTION 426
  {
    REQUEST { 1,170 }
    REPLY   { response_code, device_status, sprung_e_26 }
  }
  TRANSACTION 427
  {
    REQUEST { 1,171 }
    REPLY   { response_code, device_status, sprung_e_27 }
  }
  TRANSACTION 428
  {
    REQUEST { 1,172 }
    REPLY   { response_code, device_status, sprung_e_28 }
  }
  TRANSACTION 429
  {
    REQUEST { 1,173 }
    REPLY   { response_code, device_status, sprung_e_29 }
  }
  TRANSACTION 430
  {
    REQUEST { 1,174 }
    REPLY   { response_code, device_status, sprung_e_30 }
  }
  TRANSACTION 431
  {
    REQUEST { 1,175 }
    REPLY   { response_code, device_status, sprung_e_31 }
  }
  TRANSACTION 432
  {
    REQUEST { 1,176 }
    REPLY   { response_code, device_status, sprung_e_32 }
  }
  TRANSACTION 433
  {
    REQUEST { 1,177 }
    REPLY   { response_code, device_status, sprung_e_33 }
  }
  TRANSACTION 434
  {
    REQUEST { 1,178 }
    REPLY   { response_code, device_status, sprung_e_34 }
  }
  TRANSACTION 435
  {
    REQUEST { 1,179 }
    REPLY   { response_code, device_status, sprung_e_35 }
  }
  TRANSACTION 436
  {
    REQUEST { 1,180 }
    REPLY   { response_code, device_status, sprung_e_36 }
  }
  TRANSACTION 437
  {
    REQUEST { 1,181 }
    REPLY   { response_code, device_status, sprung_e_37 }
  }
  TRANSACTION 438
  {
    REQUEST { 1,182 }
    REPLY   { response_code, device_status, sprung_e_38 }
  }
  TRANSACTION 439
  {
    REQUEST { 1,183 }
    REPLY   { response_code, device_status, sprung_e_39 }
  }
  TRANSACTION 440
  {
    REQUEST { 1,184 }
    REPLY   { response_code, device_status, sprung_e_40 }
  }
  TRANSACTION 441
  {
    REQUEST { 1,185 }
    REPLY   { response_code, device_status, sprung_e_41 }
  }
  TRANSACTION 442
  {
    REQUEST { 1,186 }
    REPLY   { response_code, device_status, sprung_e_42 }
  }
  TRANSACTION 443
  {
    REQUEST { 1,187 }
    REPLY   { response_code, device_status, sprung_e_43 }
  }
  TRANSACTION 444
  {
    REQUEST { 1,188 }
    REPLY   { response_code, device_status, sprung_e_44 }
  }
  TRANSACTION 445
  {
    REQUEST { 1,189 }
    REPLY   { response_code, device_status, sprung_e_45 }
  }
  TRANSACTION 446
  {
    REQUEST { 1,190 }
    REPLY   { response_code, device_status, sprung_e_46 }
  }
  TRANSACTION 447
  {
    REQUEST { 1,191 }
    REPLY   { response_code, device_status, sprung_e_47 }
  }
  TRANSACTION 448
  {
    REQUEST { 1,192 }
    REPLY   { response_code, device_status, sprung_e_48 }
  }
  TRANSACTION 449
  {
    REQUEST { 1,193 }
    REPLY   { response_code, device_status, sprung_e_49 }
  }
  TRANSACTION 450
  {
    REQUEST { 1,194 }
    REPLY   { response_code, device_status, sprung_e_50 }
  }
  TRANSACTION 451
  {
    REQUEST { 1,195 }
    REPLY   { response_code, device_status, sprung_e_51 }
  }
  TRANSACTION 452
  {
    REQUEST { 1,196 }
    REPLY   { response_code, device_status, sprung_e_52 }
  }
  TRANSACTION 453
  {
    REQUEST { 1,197 }
    REPLY   { response_code, device_status, sprung_e_53 }
  }
  TRANSACTION 454
  {
    REQUEST { 1,198 }
    REPLY   { response_code, device_status, sprung_e_54 }
  }
  TRANSACTION 455
  {
    REQUEST { 1,199 }
    REPLY   { response_code, device_status, sprung_e_55 }
  }
  TRANSACTION 456
  {
    REQUEST { 1,200 }
    REPLY   { response_code, device_status, sprung_e_56 }
  }
  TRANSACTION 457
  {
    REQUEST { 1,201 }
    REPLY   { response_code, device_status, sprung_e_57 }
  }
  TRANSACTION 458
  {
    REQUEST { 1,202 }
    REPLY   { response_code, device_status, sprung_e_58 }
  }
  TRANSACTION 459
  {
    REQUEST { 1,203 }
    REPLY   { response_code, device_status, sprung_e_59 }
  }
  TRANSACTION 460
  {
    REQUEST { 1,204 }
    REPLY   { response_code, device_status, sprung_e_60 }
  }
  TRANSACTION 461
  {
    REQUEST { 1,205 }
    REPLY   { response_code, device_status, sprung_e_61 }
  }
  TRANSACTION 462
  {
    REQUEST { 1,206 }
    REPLY   { response_code, device_status, sprung_e_62 }
  }
  TRANSACTION 463
  {
    REQUEST { 1,207 }
    REPLY   { response_code, device_status, sprung_e_63 }
  }
  TRANSACTION 464
  {
    REQUEST { 1,208 }
    REPLY   { response_code, device_status, sprung_e_64 }
  }
  TRANSACTION 465
  {
    REQUEST { 1,209 }
    REPLY   { response_code, device_status, sprung_e_65 }
  }
  TRANSACTION 466
  {
    REQUEST { 1,210 }
    REPLY   { response_code, device_status, sprung_e_66 }
  }
  TRANSACTION 467
  {
    REQUEST { 1,211 }
    REPLY   { response_code, device_status, sprung_e_67 }
  }
  TRANSACTION 468
  {
    REQUEST { 1,212 }
    REPLY   { response_code, device_status, sprung_e_68 }
  }
  TRANSACTION 469
  {
    REQUEST { 1,213 }
    REPLY   { response_code, device_status, sprung_e_69 }
  }
  TRANSACTION 470
  {
    REQUEST { 1,214 }
    REPLY   { response_code, device_status, sprung_e_70 }
  }
  TRANSACTION 471
  {
    REQUEST { 1,215 }
    REPLY   { response_code, device_status, sprung_e_71 }
  }
  TRANSACTION 472
  {
    REQUEST { 1,216 }
    REPLY   { response_code, device_status, sprung_e_72 }
  }
  TRANSACTION 473
  {
    REQUEST { 1,217 }
    REPLY   { response_code, device_status, sprung_e_73 }
  }
  TRANSACTION 474
  {
    REQUEST { 1,218 }
    REPLY   { response_code, device_status, sprung_e_74 }
  }
  TRANSACTION 475
  {
    REQUEST { 1,219 }
    REPLY   { response_code, device_status, sprung_e_75 }
  }
  TRANSACTION 476
  {
    REQUEST { 1,220 }
    REPLY   { response_code, device_status, sprung_e_76 }
  }
  TRANSACTION 477
  {
    REQUEST { 1,221 }
    REPLY   { response_code, device_status, sprung_e_77 }
  }
  TRANSACTION 478
  {
    REQUEST { 1,222 }
    REPLY   { response_code, device_status, sprung_e_78 }
  }
  TRANSACTION 479
  {
    REQUEST { 1,223 }
    REPLY   { response_code, device_status, sprung_e_79 }
  }
  TRANSACTION 480
  {
    REQUEST { 1,224 }
    REPLY   { response_code, device_status, sprung_e_80 }
  }
  TRANSACTION 481
  {
    REQUEST { 1,225 }
    REPLY   { response_code, device_status, sprung_e_81 }
  }
  TRANSACTION 482
  {
    REQUEST { 1,226 }
    REPLY   { response_code, device_status, sprung_e_82 }
  }
  TRANSACTION 483
  {
    REQUEST { 1,227 }
    REPLY   { response_code, device_status, sprung_e_83 }
  }
  TRANSACTION 484
  {
    REQUEST { 1,228 }
    REPLY   { response_code, device_status, sprung_e_84 }
  }
  TRANSACTION 485
  {
    REQUEST { 1,229 }
    REPLY   { response_code, device_status, sprung_e_85 }
  }
  TRANSACTION 486
  {
    REQUEST { 1,230 }
    REPLY   { response_code, device_status, sprung_e_86 }
  }
  TRANSACTION 487
  {
    REQUEST { 1,231 }
    REPLY   { response_code, device_status, sprung_e_87 }
  }
  TRANSACTION 488
  {
    REQUEST { 1,232 }
    REPLY   { response_code, device_status, sprung_e_88 }
  }
  TRANSACTION 489
  {
    REQUEST { 1,233 }
    REPLY   { response_code, device_status, sprung_e_89 }
  }
  TRANSACTION 490
  {
    REQUEST { 1,234 }
    REPLY   { response_code, device_status, sprung_e_90 }
  }
  TRANSACTION 491
  {
    REQUEST { 1,235 }
    REPLY   { response_code, device_status, sprung_e_91 }
  }
  TRANSACTION 492
  {
    REQUEST { 1,236 }
    REPLY   { response_code, device_status, sprung_e_92 }
  }
  TRANSACTION 493
  {
    REQUEST { 1,237 }
    REPLY   { response_code, device_status, sprung_e_93 }
  }
  TRANSACTION 494
  {
    REQUEST { 1,238 }
    REPLY   { response_code, device_status, sprung_e_94 }
  }
  TRANSACTION 495
  {
    REQUEST { 1,239 }
    REPLY   { response_code, device_status, sprung_e_95 }
  }
  TRANSACTION 496
  {
    REQUEST { 1,240 }
    REPLY   { response_code, device_status, sprung_e_96 }
  }
  TRANSACTION 497
  {
    REQUEST { 1,241 }
    REPLY   { response_code, device_status, sprung_e_97 }
  }
  TRANSACTION 498
  {
    REQUEST { 1,242 }
    REPLY   { response_code, device_status, sprung_e_98 }
  }
  TRANSACTION 499
  {
    REQUEST { 1,243 }
    REPLY   { response_code, device_status, sprung_e_99 }
  }
*/

  TRANSACTION 500
  {
    REQUEST { 1,244 }
    REPLY   { response_code, device_status, stat_kl_vs_0 }
  }
  TRANSACTION 501
  {
    REQUEST { 1,245 }
    REPLY   { response_code, device_status, stat_kl_vs_1 }
  }
  TRANSACTION 502
  {
    REQUEST { 1,246 }
    REPLY   { response_code, device_status, stat_kl_vs_2 }
  }
  TRANSACTION 503
  {
    REQUEST { 1,247 }
    REPLY   { response_code, device_status, stat_kl_vs_3 }
  }
  TRANSACTION 504
  {
    REQUEST { 1,248 }
    REPLY   { response_code, device_status, stat_kl_vs_4 }
  }
  TRANSACTION 505
  {
    REQUEST { 1,249 }
    REPLY   { response_code, device_status, stat_kl_vs_5 }
  }
  TRANSACTION 506
  {
    REQUEST { 1,250 }
    REPLY   { response_code, device_status, stat_kl_vs_6 }
  }
  TRANSACTION 507
  {
    REQUEST { 1,251 }
    REPLY   { response_code, device_status, stat_kl_vs_7 }
  }
  TRANSACTION 508
  {
    REQUEST { 1,252 }
    REPLY   { response_code, device_status, stat_kl_vs_8 }
  }
  TRANSACTION 509
  {
    REQUEST { 1,253 }
    REPLY   { response_code, device_status, stat_kl_vs_9 }
  }
  TRANSACTION 510
  {
    REQUEST { 1,254 }
    REPLY   { response_code, device_status, stat_kl_vs_10 }
  }
  TRANSACTION 511
  {
    REQUEST { 1,255 }
    REPLY   { response_code, device_status, stat_kl_vs_11 }
  }
  TRANSACTION 512
  {
    REQUEST { 2,0 }
    REPLY   { response_code, device_status, stat_kl_vs_12 }
  }
  TRANSACTION 513
  {
    REQUEST { 2,1 }
    REPLY   { response_code, device_status, stat_kl_vs_13 }
  }
  TRANSACTION 514
  {
    REQUEST { 2,2 }
    REPLY   { response_code, device_status, stat_kl_vs_14 }
  }
  TRANSACTION 515
  {
    REQUEST { 2,3 }
    REPLY   { response_code, device_status, stat_kl_vs_15 }
  }
  TRANSACTION 516
  {
    REQUEST { 2,4 }
    REPLY   { response_code, device_status, stat_kl_vs_16 }
  }
  TRANSACTION 517
  {
    REQUEST { 2,5 }
    REPLY   { response_code, device_status, stat_kl_vs_17 }
  }
  TRANSACTION 518
  {
    REQUEST { 2,6 }
    REPLY   { response_code, device_status, stat_kl_vs_18 }
  }
  TRANSACTION 519
  {
    REQUEST { 2,7 }
    REPLY   { response_code, device_status, stat_kl_vs_19 }
  }
  TRANSACTION 520
  {
    REQUEST { 2,8 }
    REPLY   { response_code, device_status, stat_kl_vs_20 }
  }
  TRANSACTION 521
  {
    REQUEST { 2,9 }
    REPLY   { response_code, device_status, stat_kl_vs_21 }
  }
  TRANSACTION 522
  {
    REQUEST { 2,10 }
    REPLY   { response_code, device_status, stat_kl_vs_22 }
  }
  TRANSACTION 523
  {
    REQUEST { 2,11 }
    REPLY   { response_code, device_status, stat_kl_vs_23 }
  }
  TRANSACTION 524
  {
    REQUEST { 2,12 }
    REPLY   { response_code, device_status, stat_kl_vs_24 }
  }
  TRANSACTION 525
  {
    REQUEST { 2,13 }
    REPLY   { response_code, device_status, stat_kl_vs_25 }
  }
  TRANSACTION 526
  {
    REQUEST { 2,14 }
    REPLY   { response_code, device_status, stat_kl_vs_26 }
  }
  TRANSACTION 527
  {
    REQUEST { 2,15 }
    REPLY   { response_code, device_status, stat_kl_vs_27 }
  }
  TRANSACTION 528
  {
    REQUEST { 2,16 }
    REPLY   { response_code, device_status, stat_kl_vs_28 }
  }
  TRANSACTION 529
  {
    REQUEST { 2,17 }
    REPLY   { response_code, device_status, stat_kl_vs_29 }
  }
  TRANSACTION 530
  {
    REQUEST { 2,18 }
    REPLY   { response_code, device_status, stat_kl_vs_30 }
  }
  TRANSACTION 531
  {
    REQUEST { 2,19 }
    REPLY   { response_code, device_status, stat_kl_vs_31 }
  }
  TRANSACTION 532
  {
    REQUEST { 2,20 }
    REPLY   { response_code, device_status, stat_kl_vs_32 }
  }
  TRANSACTION 533
  {
    REQUEST { 2,21 }
    REPLY   { response_code, device_status, stat_kl_vs_33 }
  }
  TRANSACTION 534
  {
    REQUEST { 2,22 }
    REPLY   { response_code, device_status, stat_kl_vs_34 }
  }
  TRANSACTION 535
  {
    REQUEST { 2,23 }
    REPLY   { response_code, device_status, stat_kl_vs_35 }
  }
  TRANSACTION 536
  {
    REQUEST { 2,24 }
    REPLY   { response_code, device_status, stat_kl_vs_36 }
  }
  TRANSACTION 537
  {
    REQUEST { 2,25 }
    REPLY   { response_code, device_status, stat_kl_vs_37 }
  }
  TRANSACTION 538
  {
    REQUEST { 2,26 }
    REPLY   { response_code, device_status, stat_kl_vs_38 }
  }
  TRANSACTION 539
  {
    REQUEST { 2,27 }
    REPLY   { response_code, device_status, stat_kl_vs_39 }
  }
  TRANSACTION 540
  {
    REQUEST { 2,28 }
    REPLY   { response_code, device_status, stat_kl_vs_40 }
  }
  TRANSACTION 541
  {
    REQUEST { 2,29 }
    REPLY   { response_code, device_status, stat_kl_vs_41 }
  }
  TRANSACTION 542
  {
    REQUEST { 2,30 }
    REPLY   { response_code, device_status, stat_kl_vs_42 }
  }
  TRANSACTION 543
  {
    REQUEST { 2,31 }
    REPLY   { response_code, device_status, stat_kl_vs_43 }
  }
  TRANSACTION 544
  {
    REQUEST { 2,32 }
    REPLY   { response_code, device_status, stat_kl_vs_44 }
  }
  TRANSACTION 545
  {
    REQUEST { 2,33 }
    REPLY   { response_code, device_status, stat_kl_vs_45 }
  }
  TRANSACTION 546
  {
    REQUEST { 2,34 }
    REPLY   { response_code, device_status, stat_kl_vs_46 }
  }
  TRANSACTION 547
  {
    REQUEST { 2,35 }
    REPLY   { response_code, device_status, stat_kl_vs_47 }
  }
  TRANSACTION 548
  {
    REQUEST { 2,36 }
    REPLY   { response_code, device_status, stat_kl_vs_48 }
  }
  TRANSACTION 549
  {
    REQUEST { 2,37 }
    REPLY   { response_code, device_status, stat_kl_vs_49 }
  }
  TRANSACTION 550
  {
    REQUEST { 2,38 }
    REPLY   { response_code, device_status, stat_kl_vs_50 }
  }
  TRANSACTION 551
  {
    REQUEST { 2,39 }
    REPLY   { response_code, device_status, stat_kl_vs_51 }
  }
  TRANSACTION 552
  {
    REQUEST { 2,40 }
    REPLY   { response_code, device_status, stat_kl_vs_52 }
  }
  TRANSACTION 553
  {
    REQUEST { 2,41 }
    REPLY   { response_code, device_status, stat_kl_vs_53 }
  }
  TRANSACTION 554
  {
    REQUEST { 2,42 }
    REPLY   { response_code, device_status, stat_kl_vs_54 }
  }
  TRANSACTION 555
  {
    REQUEST { 2,43 }
    REPLY   { response_code, device_status, stat_kl_vs_55 }
  }
  TRANSACTION 556
  {
    REQUEST { 2,44 }
    REPLY   { response_code, device_status, stat_kl_vs_56 }
  }
  TRANSACTION 557
  {
    REQUEST { 2,45 }
    REPLY   { response_code, device_status, stat_kl_vs_57 }
  }
  TRANSACTION 558
  {
    REQUEST { 2,46 }
    REPLY   { response_code, device_status, stat_kl_vs_58 }
  }
  TRANSACTION 559
  {
    REQUEST { 2,47 }
    REPLY   { response_code, device_status, stat_kl_vs_59 }
  }
  TRANSACTION 560
  {
    REQUEST { 2,48 }
    REPLY   { response_code, device_status, stat_kl_vs_60 }
  }
  TRANSACTION 561
  {
    REQUEST { 2,49 }
    REPLY   { response_code, device_status, stat_kl_vs_61 }
  }
  TRANSACTION 562
  {
    REQUEST { 2,50 }
    REPLY   { response_code, device_status, stat_kl_vs_62 }
  }
  TRANSACTION 563
  {
    REQUEST { 2,51 }
    REPLY   { response_code, device_status, stat_kl_vs_63 }
  }
  TRANSACTION 564
  {
    REQUEST { 2,52 }
    REPLY   { response_code, device_status, stat_kl_vs_64 }
  }
  TRANSACTION 565
  {
    REQUEST { 2,53 }
    REPLY   { response_code, device_status, stat_kl_vs_65 }
  }
  TRANSACTION 566
  {
    REQUEST { 2,54 }
    REPLY   { response_code, device_status, stat_kl_vs_66 }
  }
  TRANSACTION 567
  {
    REQUEST { 2,55 }
    REPLY   { response_code, device_status, stat_kl_vs_67 }
  }
  TRANSACTION 568
  {
    REQUEST { 2,56 }
    REPLY   { response_code, device_status, stat_kl_vs_68 }
  }
  TRANSACTION 569
  {
    REQUEST { 2,57 }
    REPLY   { response_code, device_status, stat_kl_vs_69 }
  }
  TRANSACTION 570
  {
    REQUEST { 2,58 }
    REPLY   { response_code, device_status, stat_kl_vs_70 }
  }
  TRANSACTION 571
  {
    REQUEST { 2,59 }
    REPLY   { response_code, device_status, stat_kl_vs_71 }
  }
  TRANSACTION 572
  {
    REQUEST { 2,60 }
    REPLY   { response_code, device_status, stat_kl_vs_72 }
  }
  TRANSACTION 573
  {
    REQUEST { 2,61 }
    REPLY   { response_code, device_status, stat_kl_vs_73 }
  }
  TRANSACTION 574
  {
    REQUEST { 2,62 }
    REPLY   { response_code, device_status, stat_kl_vs_74 }
  }
  TRANSACTION 575
  {
    REQUEST { 2,63 }
    REPLY   { response_code, device_status, stat_kl_vs_75 }
  }
  TRANSACTION 576
  {
    REQUEST { 2,64 }
    REPLY   { response_code, device_status, stat_kl_vs_76 }
  }
  TRANSACTION 577
  {
    REQUEST { 2,65 }
    REPLY   { response_code, device_status, stat_kl_vs_77 }
  }
  TRANSACTION 578
  {
    REQUEST { 2,66 }
    REPLY   { response_code, device_status, stat_kl_vs_78 }
  }
  TRANSACTION 579
  {
    REQUEST { 2,67 }
    REPLY   { response_code, device_status, stat_kl_vs_79 }
  }
  TRANSACTION 580
  {
    REQUEST { 2,68 }
    REPLY   { response_code, device_status, stat_kl_vs_80 }
  }
  TRANSACTION 581
  {
    REQUEST { 2,69 }
    REPLY   { response_code, device_status, stat_kl_vs_81 }
  }
  TRANSACTION 582
  {
    REQUEST { 2,70 }
    REPLY   { response_code, device_status, stat_kl_vs_82 }
  }
  TRANSACTION 583
  {
    REQUEST { 2,71 }
    REPLY   { response_code, device_status, stat_kl_vs_83 }
  }
  TRANSACTION 584
  {
    REQUEST { 2,72 }
    REPLY   { response_code, device_status, stat_kl_vs_84 }
  }
  TRANSACTION 585
  {
    REQUEST { 2,73 }
    REPLY   { response_code, device_status, stat_kl_vs_85 }
  }
  TRANSACTION 586
  {
    REQUEST { 2,74 }
    REPLY   { response_code, device_status, stat_kl_vs_86 }
  }
  TRANSACTION 587
  {
    REQUEST { 2,75 }
    REPLY   { response_code, device_status, stat_kl_vs_87 }
  }
  TRANSACTION 588
  {
    REQUEST { 2,76 }
    REPLY   { response_code, device_status, stat_kl_vs_88 }
  }
  TRANSACTION 589
  {
    REQUEST { 2,77 }
    REPLY   { response_code, device_status, stat_kl_vs_89 }
  }
  TRANSACTION 590
  {
    REQUEST { 2,78 }
    REPLY   { response_code, device_status, stat_kl_vs_90 }
  }
  TRANSACTION 591
  {
    REQUEST { 2,79 }
    REPLY   { response_code, device_status, stat_kl_vs_91 }
  }
  TRANSACTION 592
  {
    REQUEST { 2,80 }
    REPLY   { response_code, device_status, stat_kl_vs_92 }
  }
  TRANSACTION 593
  {
    REQUEST { 2,81 }
    REPLY   { response_code, device_status, stat_kl_vs_93 }
  }
  TRANSACTION 594
  {
    REQUEST { 2,82 }
    REPLY   { response_code, device_status, stat_kl_vs_94 }
  }
  TRANSACTION 595
  {
    REQUEST { 2,83 }
    REPLY   { response_code, device_status, stat_kl_vs_95 }
  }
  TRANSACTION 596
  {
    REQUEST { 2,84 }
    REPLY   { response_code, device_status, stat_kl_vs_96 }
  }
  TRANSACTION 597
  {
    REQUEST { 2,85 }
    REPLY   { response_code, device_status, stat_kl_vs_97 }
  }
  TRANSACTION 598
  {
    REQUEST { 2,86 }
    REPLY   { response_code, device_status, stat_kl_vs_98 }
  }
  TRANSACTION 599
  {
    REQUEST { 2,87 }
    REPLY   { response_code, device_status, stat_kl_vs_99 }
  }


  TRANSACTION 600
  {
    REQUEST { 2,88 }
    REPLY   { response_code, device_status, stat_kl_sw_0 }
  }
  TRANSACTION 601
  {
    REQUEST { 2,89 }
    REPLY   { response_code, device_status, stat_kl_sw_1 }
  }
  TRANSACTION 602
  {
    REQUEST { 2,90 }
    REPLY   { response_code, device_status, stat_kl_sw_2 }
  }
  TRANSACTION 603
  {
    REQUEST { 2,91 }
    REPLY   { response_code, device_status, stat_kl_sw_3 }
  }
  TRANSACTION 604
  {
    REQUEST { 2,92 }
    REPLY   { response_code, device_status, stat_kl_sw_4 }
  }
  TRANSACTION 605
  {
    REQUEST { 2,93 }
    REPLY   { response_code, device_status, stat_kl_sw_5 }
  }
  TRANSACTION 606
  {
    REQUEST { 2,94 }
    REPLY   { response_code, device_status, stat_kl_sw_6 }
  }
  TRANSACTION 607
  {
    REQUEST { 2,95 }
    REPLY   { response_code, device_status, stat_kl_sw_7 }
  }
  TRANSACTION 608
  {
    REQUEST { 2,96 }
    REPLY   { response_code, device_status, stat_kl_sw_8 }
  }
  TRANSACTION 609
  {
    REQUEST { 2,97 }
    REPLY   { response_code, device_status, stat_kl_sw_9 }
  }
  TRANSACTION 610
  {
    REQUEST { 2,98 }
    REPLY   { response_code, device_status, stat_kl_sw_10 }
  }
  TRANSACTION 611
  {
    REQUEST { 2,99 }
    REPLY   { response_code, device_status, stat_kl_sw_11 }
  }
  TRANSACTION 612
  {
    REQUEST { 2,100 }
    REPLY   { response_code, device_status, stat_kl_sw_12 }
  }
  TRANSACTION 613
  {
    REQUEST { 2,101 }
    REPLY   { response_code, device_status, stat_kl_sw_13 }
  }
  TRANSACTION 614
  {
    REQUEST { 2,102 }
    REPLY   { response_code, device_status, stat_kl_sw_14 }
  }
  TRANSACTION 615
  {
    REQUEST { 2,103 }
    REPLY   { response_code, device_status, stat_kl_sw_15 }
  }
  TRANSACTION 616
  {
    REQUEST { 2,104 }
    REPLY   { response_code, device_status, stat_kl_sw_16 }
  }
  TRANSACTION 617
  {
    REQUEST { 2,105 }
    REPLY   { response_code, device_status, stat_kl_sw_17 }
  }
  TRANSACTION 618
  {
    REQUEST { 2,106 }
    REPLY   { response_code, device_status, stat_kl_sw_18 }
  }
  TRANSACTION 619
  {
    REQUEST { 2,107 }
    REPLY   { response_code, device_status, stat_kl_sw_19 }
  }
  TRANSACTION 620
  {
    REQUEST { 2,108 }
    REPLY   { response_code, device_status, stat_kl_sw_20 }
  }
  TRANSACTION 621
  {
    REQUEST { 2,109 }
    REPLY   { response_code, device_status, stat_kl_sw_21 }
  }
  TRANSACTION 622
  {
    REQUEST { 2,110 }
    REPLY   { response_code, device_status, stat_kl_sw_22 }
  }
  TRANSACTION 623
  {
    REQUEST { 2,111 }
    REPLY   { response_code, device_status, stat_kl_sw_23 }
  }
  TRANSACTION 624
  {
    REQUEST { 2,112 }
    REPLY   { response_code, device_status, stat_kl_sw_24 }
  }
  TRANSACTION 625
  {
    REQUEST { 2,113 }
    REPLY   { response_code, device_status, stat_kl_sw_25 }
  }
  TRANSACTION 626
  {
    REQUEST { 2,114 }
    REPLY   { response_code, device_status, stat_kl_sw_26 }
  }
  TRANSACTION 627
  {
    REQUEST { 2,115 }
    REPLY   { response_code, device_status, stat_kl_sw_27 }
  }
  TRANSACTION 628
  {
    REQUEST { 2,116 }
    REPLY   { response_code, device_status, stat_kl_sw_28 }
  }
  TRANSACTION 629
  {
    REQUEST { 2,117 }
    REPLY   { response_code, device_status, stat_kl_sw_29 }
  }
  TRANSACTION 630
  {
    REQUEST { 2,118 }
    REPLY   { response_code, device_status, stat_kl_sw_30 }
  }
  TRANSACTION 631
  {
    REQUEST { 2,119 }
    REPLY   { response_code, device_status, stat_kl_sw_31 }
  }
  TRANSACTION 632
  {
    REQUEST { 2,120 }
    REPLY   { response_code, device_status, stat_kl_sw_32 }
  }
  TRANSACTION 633
  {
    REQUEST { 2,121 }
    REPLY   { response_code, device_status, stat_kl_sw_33 }
  }
  TRANSACTION 634
  {
    REQUEST { 2,122 }
    REPLY   { response_code, device_status, stat_kl_sw_34 }
  }
  TRANSACTION 635
  {
    REQUEST { 2,123 }
    REPLY   { response_code, device_status, stat_kl_sw_35 }
  }
  TRANSACTION 636
  {
    REQUEST { 2,124 }
    REPLY   { response_code, device_status, stat_kl_sw_36 }
  }
  TRANSACTION 637
  {
    REQUEST { 2,125 }
    REPLY   { response_code, device_status, stat_kl_sw_37 }
  }
  TRANSACTION 638
  {
    REQUEST { 2,126 }
    REPLY   { response_code, device_status, stat_kl_sw_38 }
  }
  TRANSACTION 639
  {
    REQUEST { 2,127 }
    REPLY   { response_code, device_status, stat_kl_sw_39 }
  }
  TRANSACTION 640
  {
    REQUEST { 2,128 }
    REPLY   { response_code, device_status, stat_kl_sw_40 }
  }
  TRANSACTION 641
  {
    REQUEST { 2,129 }
    REPLY   { response_code, device_status, stat_kl_sw_41 }
  }
  TRANSACTION 642
  {
    REQUEST { 2,130 }
    REPLY   { response_code, device_status, stat_kl_sw_42 }
  }
  TRANSACTION 643
  {
    REQUEST { 2,131 }
    REPLY   { response_code, device_status, stat_kl_sw_43 }
  }
  TRANSACTION 644
  {
    REQUEST { 2,132 }
    REPLY   { response_code, device_status, stat_kl_sw_44 }
  }
  TRANSACTION 645
  {
    REQUEST { 2,133 }
    REPLY   { response_code, device_status, stat_kl_sw_45 }
  }
  TRANSACTION 646
  {
    REQUEST { 2,134 }
    REPLY   { response_code, device_status, stat_kl_sw_46 }
  }
  TRANSACTION 647
  {
    REQUEST { 2,135 }
    REPLY   { response_code, device_status, stat_kl_sw_47 }
  }
  TRANSACTION 648
  {
    REQUEST { 2,136 }
    REPLY   { response_code, device_status, stat_kl_sw_48 }
  }
  TRANSACTION 649
  {
    REQUEST { 2,137 }
    REPLY   { response_code, device_status, stat_kl_sw_49 }
  }
  TRANSACTION 650
  {
    REQUEST { 2,138 }
    REPLY   { response_code, device_status, stat_kl_sw_50 }
  }
  TRANSACTION 651
  {
    REQUEST { 2,139 }
    REPLY   { response_code, device_status, stat_kl_sw_51 }
  }
  TRANSACTION 652
  {
    REQUEST { 2,140 }
    REPLY   { response_code, device_status, stat_kl_sw_52 }
  }
  TRANSACTION 653
  {
    REQUEST { 2,141 }
    REPLY   { response_code, device_status, stat_kl_sw_53 }
  }
  TRANSACTION 654
  {
    REQUEST { 2,142 }
    REPLY   { response_code, device_status, stat_kl_sw_54 }
  }
  TRANSACTION 655
  {
    REQUEST { 2,143 }
    REPLY   { response_code, device_status, stat_kl_sw_55 }
  }
  TRANSACTION 656
  {
    REQUEST { 2,144 }
    REPLY   { response_code, device_status, stat_kl_sw_56 }
  }
  TRANSACTION 657
  {
    REQUEST { 2,145 }
    REPLY   { response_code, device_status, stat_kl_sw_57 }
  }
  TRANSACTION 658
  {
    REQUEST { 2,146 }
    REPLY   { response_code, device_status, stat_kl_sw_58 }
  }
  TRANSACTION 659
  {
    REQUEST { 2,147 }
    REPLY   { response_code, device_status, stat_kl_sw_59 }
  }
  TRANSACTION 660
  {
    REQUEST { 2,148 }
    REPLY   { response_code, device_status, stat_kl_sw_60 }
  }
  TRANSACTION 661
  {
    REQUEST { 2,149 }
    REPLY   { response_code, device_status, stat_kl_sw_61 }
  }
  TRANSACTION 662
  {
    REQUEST { 2,150 }
    REPLY   { response_code, device_status, stat_kl_sw_62 }
  }
  TRANSACTION 663
  {
    REQUEST { 2,151 }
    REPLY   { response_code, device_status, stat_kl_sw_63 }
  }
  TRANSACTION 664
  {
    REQUEST { 2,152 }
    REPLY   { response_code, device_status, stat_kl_sw_64 }
  }
  TRANSACTION 665
  {
    REQUEST { 2,153 }
    REPLY   { response_code, device_status, stat_kl_sw_65 }
  }
  TRANSACTION 666
  {
    REQUEST { 2,154 }
    REPLY   { response_code, device_status, stat_kl_sw_66 }
  }
  TRANSACTION 667
  {
    REQUEST { 2,155 }
    REPLY   { response_code, device_status, stat_kl_sw_67 }
  }
  TRANSACTION 668
  {
    REQUEST { 2,156 }
    REPLY   { response_code, device_status, stat_kl_sw_68 }
  }
  TRANSACTION 669
  {
    REQUEST { 2,157 }
    REPLY   { response_code, device_status, stat_kl_sw_69 }
  }
  TRANSACTION 670
  {
    REQUEST { 2,158 }
    REPLY   { response_code, device_status, stat_kl_sw_70 }
  }
  TRANSACTION 671
  {
    REQUEST { 2,159 }
    REPLY   { response_code, device_status, stat_kl_sw_71 }
  }
  TRANSACTION 672
  {
    REQUEST { 2,160 }
    REPLY   { response_code, device_status, stat_kl_sw_72 }
  }
  TRANSACTION 673
  {
    REQUEST { 2,161 }
    REPLY   { response_code, device_status, stat_kl_sw_73 }
  }
  TRANSACTION 674
  {
    REQUEST { 2,162 }
    REPLY   { response_code, device_status, stat_kl_sw_74 }
  }
  TRANSACTION 675
  {
    REQUEST { 2,163 }
    REPLY   { response_code, device_status, stat_kl_sw_75 }
  }
  TRANSACTION 676
  {
    REQUEST { 2,164 }
    REPLY   { response_code, device_status, stat_kl_sw_76 }
  }
  TRANSACTION 677
  {
    REQUEST { 2,165 }
    REPLY   { response_code, device_status, stat_kl_sw_77 }
  }
  TRANSACTION 678
  {
    REQUEST { 2,166 }
    REPLY   { response_code, device_status, stat_kl_sw_78 }
  }
  TRANSACTION 679
  {
    REQUEST { 2,167 }
    REPLY   { response_code, device_status, stat_kl_sw_79 }
  }
  TRANSACTION 680
  {
    REQUEST { 2,168 }
    REPLY   { response_code, device_status, stat_kl_sw_80 }
  }
  TRANSACTION 681
  {
    REQUEST { 2,169 }
    REPLY   { response_code, device_status, stat_kl_sw_81 }
  }
  TRANSACTION 682
  {
    REQUEST { 2,170 }
    REPLY   { response_code, device_status, stat_kl_sw_82 }
  }
  TRANSACTION 683
  {
    REQUEST { 2,171 }
    REPLY   { response_code, device_status, stat_kl_sw_83 }
  }
  TRANSACTION 684
  {
    REQUEST { 2,172 }
    REPLY   { response_code, device_status, stat_kl_sw_84 }
  }
  TRANSACTION 685
  {
    REQUEST { 2,173 }
    REPLY   { response_code, device_status, stat_kl_sw_85 }
  }
  TRANSACTION 686
  {
    REQUEST { 2,174 }
    REPLY   { response_code, device_status, stat_kl_sw_86 }
  }
  TRANSACTION 687
  {
    REQUEST { 2,175 }
    REPLY   { response_code, device_status, stat_kl_sw_87 }
  }
  TRANSACTION 688
  {
    REQUEST { 2,176 }
    REPLY   { response_code, device_status, stat_kl_sw_88 }
  }
  TRANSACTION 689
  {
    REQUEST { 2,177 }
    REPLY   { response_code, device_status, stat_kl_sw_89 }
  }
  TRANSACTION 690
  {
    REQUEST { 2,178 }
    REPLY   { response_code, device_status, stat_kl_sw_90 }
  }
  TRANSACTION 691
  {
    REQUEST { 2,179 }
    REPLY   { response_code, device_status, stat_kl_sw_91 }
  }
  TRANSACTION 692
  {
    REQUEST { 2,180 }
    REPLY   { response_code, device_status, stat_kl_sw_92 }
  }
  TRANSACTION 693
  {
    REQUEST { 2,181 }
    REPLY   { response_code, device_status, stat_kl_sw_93 }
  }
  TRANSACTION 694
  {
    REQUEST { 2,182 }
    REPLY   { response_code, device_status, stat_kl_sw_94 }
  }
  TRANSACTION 695
  {
    REQUEST { 2,183 }
    REPLY   { response_code, device_status, stat_kl_sw_95 }
  }
  TRANSACTION 696
  {
    REQUEST { 2,184 }
    REPLY   { response_code, device_status, stat_kl_sw_96 }
  }
  TRANSACTION 697
  {
    REQUEST { 2,185 }
    REPLY   { response_code, device_status, stat_kl_sw_97 }
  }
  TRANSACTION 698
  {
    REQUEST { 2,186 }
    REPLY   { response_code, device_status, stat_kl_sw_98 }
  }
  TRANSACTION 699
  {
    REQUEST { 2,187 }
    REPLY   { response_code, device_status, stat_kl_sw_99 }
  }


  TRANSACTION 700
  {
    REQUEST { 2,188 }
    REPLY   { response_code, device_status, datalogger_sw_0 }
  }
  TRANSACTION 701
  {
    REQUEST { 2,189 }
    REPLY   { response_code, device_status, datalogger_sw_1 }
  }
  TRANSACTION 702
  {
    REQUEST { 2,190 }
    REPLY   { response_code, device_status, datalogger_sw_2 }
  }
  TRANSACTION 703
  {
    REQUEST { 2,191 }
    REPLY   { response_code, device_status, datalogger_sw_3 }
  }
  TRANSACTION 704
  {
    REQUEST { 2,192 }
    REPLY   { response_code, device_status, datalogger_sw_4 }
  }
  TRANSACTION 705
  {
    REQUEST { 2,193 }
    REPLY   { response_code, device_status, datalogger_sw_5 }
  }
  TRANSACTION 706
  {
    REQUEST { 2,194 }
    REPLY   { response_code, device_status, datalogger_sw_6 }
  }
  TRANSACTION 707
  {
    REQUEST { 2,195 }
    REPLY   { response_code, device_status, datalogger_sw_7 }
  }
  TRANSACTION 708
  {
    REQUEST { 2,196 }
    REPLY   { response_code, device_status, datalogger_sw_8 }
  }
  TRANSACTION 709
  {
    REQUEST { 2,197 }
    REPLY   { response_code, device_status, datalogger_sw_9 }
  }
  TRANSACTION 710
  {
    REQUEST { 2,198 }
    REPLY   { response_code, device_status, datalogger_sw_10 }
  }
  TRANSACTION 711
  {
    REQUEST { 2,199 }
    REPLY   { response_code, device_status, datalogger_sw_11 }
  }
  TRANSACTION 712
  {
    REQUEST { 2,200 }
    REPLY   { response_code, device_status, datalogger_sw_12 }
  }
  TRANSACTION 713
  {
    REQUEST { 2,201 }
    REPLY   { response_code, device_status, datalogger_sw_13 }
  }
  TRANSACTION 714
  {
    REQUEST { 2,202 }
    REPLY   { response_code, device_status, datalogger_sw_14 }
  }
  TRANSACTION 715
  {
    REQUEST { 2,203 }
    REPLY   { response_code, device_status, datalogger_sw_15 }
  }
  TRANSACTION 716
  {
    REQUEST { 2,204 }
    REPLY   { response_code, device_status, datalogger_sw_16 }
  }
  TRANSACTION 717
  {
    REQUEST { 2,205 }
    REPLY   { response_code, device_status, datalogger_sw_17 }
  }
  TRANSACTION 718
  {
    REQUEST { 2,206 }
    REPLY   { response_code, device_status, datalogger_sw_18 }
  }
  TRANSACTION 719
  {
    REQUEST { 2,207 }
    REPLY   { response_code, device_status, datalogger_sw_19 }
  }
  TRANSACTION 720
  {
    REQUEST { 2,208 }
    REPLY   { response_code, device_status, datalogger_sw_20 }
  }
  TRANSACTION 721
  {
    REQUEST { 2,209 }
    REPLY   { response_code, device_status, datalogger_sw_21 }
  }
  TRANSACTION 722
  {
    REQUEST { 2,210 }
    REPLY   { response_code, device_status, datalogger_sw_22 }
  }
  TRANSACTION 723
  {
    REQUEST { 2,211 }
    REPLY   { response_code, device_status, datalogger_sw_23 }
  }
  TRANSACTION 724
  {
    REQUEST { 2,212 }
    REPLY   { response_code, device_status, datalogger_sw_24 }
  }
  TRANSACTION 725
  {
    REQUEST { 2,213 }
    REPLY   { response_code, device_status, datalogger_sw_25 }
  }
  TRANSACTION 726
  {
    REQUEST { 2,214 }
    REPLY   { response_code, device_status, datalogger_sw_26 }
  }
  TRANSACTION 727
  {
    REQUEST { 2,215 }
    REPLY   { response_code, device_status, datalogger_sw_27 }
  }
  TRANSACTION 728
  {
    REQUEST { 2,216 }
    REPLY   { response_code, device_status, datalogger_sw_28 }
  }
  TRANSACTION 729
  {
    REQUEST { 2,217 }
    REPLY   { response_code, device_status, datalogger_sw_29 }
  }
  TRANSACTION 730
  {
    REQUEST { 2,218 }
    REPLY   { response_code, device_status, datalogger_sw_30 }
  }
  TRANSACTION 731
  {
    REQUEST { 2,219 }
    REPLY   { response_code, device_status, datalogger_sw_31 }
  }
  TRANSACTION 732
  {
    REQUEST { 2,220 }
    REPLY   { response_code, device_status, datalogger_sw_32 }
  }
  TRANSACTION 733
  {
    REQUEST { 2,221 }
    REPLY   { response_code, device_status, datalogger_sw_33 }
  }
  TRANSACTION 734
  {
    REQUEST { 2,222 }
    REPLY   { response_code, device_status, datalogger_sw_34 }
  }
  TRANSACTION 735
  {
    REQUEST { 2,223 }
    REPLY   { response_code, device_status, datalogger_sw_35 }
  }
  TRANSACTION 736
  {
    REQUEST { 2,224 }
    REPLY   { response_code, device_status, datalogger_sw_36 }
  }
  TRANSACTION 737
  {
    REQUEST { 2,225 }
    REPLY   { response_code, device_status, datalogger_sw_37 }
  }
  TRANSACTION 738
  {
    REQUEST { 2,226 }
    REPLY   { response_code, device_status, datalogger_sw_38 }
  }
  TRANSACTION 739
  {
    REQUEST { 2,227 }
    REPLY   { response_code, device_status, datalogger_sw_39 }
  }
  TRANSACTION 740
  {
    REQUEST { 2,228 }
    REPLY   { response_code, device_status, datalogger_sw_40 }
  }
  TRANSACTION 741
  {
    REQUEST { 2,229 }
    REPLY   { response_code, device_status, datalogger_sw_41 }
  }
  TRANSACTION 742
  {
    REQUEST { 2,230 }
    REPLY   { response_code, device_status, datalogger_sw_42 }
  }
  TRANSACTION 743
  {
    REQUEST { 2,231 }
    REPLY   { response_code, device_status, datalogger_sw_43 }
  }
  TRANSACTION 744
  {
    REQUEST { 2,232 }
    REPLY   { response_code, device_status, datalogger_sw_44 }
  }
  TRANSACTION 745
  {
    REQUEST { 2,233 }
    REPLY   { response_code, device_status, datalogger_sw_45 }
  }
  TRANSACTION 746
  {
    REQUEST { 2,234 }
    REPLY   { response_code, device_status, datalogger_sw_46 }
  }
  TRANSACTION 747
  {
    REQUEST { 2,235 }
    REPLY   { response_code, device_status, datalogger_sw_47 }
  }
  TRANSACTION 748
  {
    REQUEST { 2,236 }
    REPLY   { response_code, device_status, datalogger_sw_48 }
  }
  TRANSACTION 749
  {
    REQUEST { 2,237 }
    REPLY   { response_code, device_status, datalogger_sw_49 }
  }
  TRANSACTION 750
  {
    REQUEST { 2,238 }
    REPLY   { response_code, device_status, datalogger_sw_50 }
  }
  TRANSACTION 751
  {
    REQUEST { 2,239 }
    REPLY   { response_code, device_status, datalogger_sw_51 }
  }
  TRANSACTION 752
  {
    REQUEST { 2,240 }
    REPLY   { response_code, device_status, datalogger_sw_52 }
  }
  TRANSACTION 753
  {
    REQUEST { 2,241 }
    REPLY   { response_code, device_status, datalogger_sw_53 }
  }
  TRANSACTION 754
  {
    REQUEST { 2,242 }
    REPLY   { response_code, device_status, datalogger_sw_54 }
  }
  TRANSACTION 755
  {
    REQUEST { 2,243 }
    REPLY   { response_code, device_status, datalogger_sw_55 }
  }
  TRANSACTION 756
  {
    REQUEST { 2,244 }
    REPLY   { response_code, device_status, datalogger_sw_56 }
  }
  TRANSACTION 757
  {
    REQUEST { 2,245 }
    REPLY   { response_code, device_status, datalogger_sw_57 }
  }
  TRANSACTION 758
  {
    REQUEST { 2,246 }
    REPLY   { response_code, device_status, datalogger_sw_58 }
  }
  TRANSACTION 759
  {
    REQUEST { 2,247 }
    REPLY   { response_code, device_status, datalogger_sw_59 }
  }
  TRANSACTION 760
  {
    REQUEST { 2,248 }
    REPLY   { response_code, device_status, datalogger_sw_60 }
  }
  TRANSACTION 761
  {
    REQUEST { 2,249 }
    REPLY   { response_code, device_status, datalogger_sw_61 }
  }
  TRANSACTION 762
  {
    REQUEST { 2,250 }
    REPLY   { response_code, device_status, datalogger_sw_62 }
  }
  TRANSACTION 763
  {
    REQUEST { 2,251 }
    REPLY   { response_code, device_status, datalogger_sw_63 }
  }
  TRANSACTION 764
  {
    REQUEST { 2,252 }
    REPLY   { response_code, device_status, datalogger_sw_64 }
  }
  TRANSACTION 765
  {
    REQUEST { 2,253 }
    REPLY   { response_code, device_status, datalogger_sw_65 }
  }
  TRANSACTION 766
  {
    REQUEST { 2,254 }
    REPLY   { response_code, device_status, datalogger_sw_66 }
  }
  TRANSACTION 767
  {
    REQUEST { 2,255 }
    REPLY   { response_code, device_status, datalogger_sw_67 }
  }
  TRANSACTION 768
  {
    REQUEST { 3,0 }
    REPLY   { response_code, device_status, datalogger_sw_68 }
  }
  TRANSACTION 769
  {
    REQUEST { 3,1 }
    REPLY   { response_code, device_status, datalogger_sw_69 }
  }
  TRANSACTION 770
  {
    REQUEST { 3,2 }
    REPLY   { response_code, device_status, datalogger_sw_70 }
  }
  TRANSACTION 771
  {
    REQUEST { 3,3 }
    REPLY   { response_code, device_status, datalogger_sw_71 }
  }
  TRANSACTION 772
  {
    REQUEST { 3,4 }
    REPLY   { response_code, device_status, datalogger_sw_72 }
  }
  TRANSACTION 773
  {
    REQUEST { 3,5 }
    REPLY   { response_code, device_status, datalogger_sw_73 }
  }
  TRANSACTION 774
  {
    REQUEST { 3,6 }
    REPLY   { response_code, device_status, datalogger_sw_74 }
  }
  TRANSACTION 775
  {
    REQUEST { 3,7 }
    REPLY   { response_code, device_status, datalogger_sw_75 }
  }
  TRANSACTION 776
  {
    REQUEST { 3,8 }
    REPLY   { response_code, device_status, datalogger_sw_76 }
  }
  TRANSACTION 777
  {
    REQUEST { 3,9 }
    REPLY   { response_code, device_status, datalogger_sw_77 }
  }
  TRANSACTION 778
  {
    REQUEST { 3,10 }
    REPLY   { response_code, device_status, datalogger_sw_78 }
  }
  TRANSACTION 779
  {
    REQUEST { 3,11 }
    REPLY   { response_code, device_status, datalogger_sw_79 }
  }
  TRANSACTION 780
  {
    REQUEST { 3,12 }
    REPLY   { response_code, device_status, datalogger_sw_80 }
  }
  TRANSACTION 781
  {
    REQUEST { 3,13 }
    REPLY   { response_code, device_status, datalogger_sw_81 }
  }
  TRANSACTION 782
  {
    REQUEST { 3,14 }
    REPLY   { response_code, device_status, datalogger_sw_82 }
  }
  TRANSACTION 783
  {
    REQUEST { 3,15 }
    REPLY   { response_code, device_status, datalogger_sw_83 }
  }
  TRANSACTION 784
  {
    REQUEST { 3,16 }
    REPLY   { response_code, device_status, datalogger_sw_84 }
  }
  TRANSACTION 785
  {
    REQUEST { 3,17 }
    REPLY   { response_code, device_status, datalogger_sw_85 }
  }
  TRANSACTION 786
  {
    REQUEST { 3,18 }
    REPLY   { response_code, device_status, datalogger_sw_86 }
  }
  TRANSACTION 787
  {
    REQUEST { 3,19 }
    REPLY   { response_code, device_status, datalogger_sw_87 }
  }
  TRANSACTION 788
  {
    REQUEST { 3,20 }
    REPLY   { response_code, device_status, datalogger_sw_88 }
  }
  TRANSACTION 789
  {
    REQUEST { 3,21 }
    REPLY   { response_code, device_status, datalogger_sw_89 }
  }
  TRANSACTION 790
  {
    REQUEST { 3,22 }
    REPLY   { response_code, device_status, datalogger_sw_90 }
  }
  TRANSACTION 791
  {
    REQUEST { 3,23 }
    REPLY   { response_code, device_status, datalogger_sw_91 }
  }
  TRANSACTION 792
  {
    REQUEST { 3,24 }
    REPLY   { response_code, device_status, datalogger_sw_92 }
  }
  TRANSACTION 793
  {
    REQUEST { 3,25 }
    REPLY   { response_code, device_status, datalogger_sw_93 }
  }
  TRANSACTION 794
  {
    REQUEST { 3,26 }
    REPLY   { response_code, device_status, datalogger_sw_94 }
  }
  TRANSACTION 795
  {
    REQUEST { 3,27 }
    REPLY   { response_code, device_status, datalogger_sw_95 }
  }
  TRANSACTION 796
  {
    REQUEST { 3,28 }
    REPLY   { response_code, device_status, datalogger_sw_96 }
  }
  TRANSACTION 797
  {
    REQUEST { 3,29 }
    REPLY   { response_code, device_status, datalogger_sw_97 }
  }
  TRANSACTION 798
  {
    REQUEST { 3,30 }
    REPLY   { response_code, device_status, datalogger_sw_98 }
  }
  TRANSACTION 799
  {
    REQUEST { 3,31 }
    REPLY   { response_code, device_status, datalogger_sw_99 }
  }


  TRANSACTION 800
  {
    REQUEST { 3,32 }
    REPLY   { response_code, device_status, datalogger_e_0 }
  }
  TRANSACTION 801
  {
    REQUEST { 3,33 }
    REPLY   { response_code, device_status, datalogger_e_1 }
  }
  TRANSACTION 802
  {
    REQUEST { 3,34 }
    REPLY   { response_code, device_status, datalogger_e_2 }
  }
  TRANSACTION 803
  {
    REQUEST { 3,35 }
    REPLY   { response_code, device_status, datalogger_e_3 }
  }
  TRANSACTION 804
  {
    REQUEST { 3,36 }
    REPLY   { response_code, device_status, datalogger_e_4 }
  }
  TRANSACTION 805
  {
    REQUEST { 3,37 }
    REPLY   { response_code, device_status, datalogger_e_5 }
  }
  TRANSACTION 806
  {
    REQUEST { 3,38 }
    REPLY   { response_code, device_status, datalogger_e_6 }
  }
  TRANSACTION 807
  {
    REQUEST { 3,39 }
    REPLY   { response_code, device_status, datalogger_e_7 }
  }
  TRANSACTION 808
  {
    REQUEST { 3,40 }
    REPLY   { response_code, device_status, datalogger_e_8 }
  }
  TRANSACTION 809
  {
    REQUEST { 3,41 }
    REPLY   { response_code, device_status, datalogger_e_9 }
  }
  TRANSACTION 810
  {
    REQUEST { 3,42 }
    REPLY   { response_code, device_status, datalogger_e_10 }
  }
  TRANSACTION 811
  {
    REQUEST { 3,43 }
    REPLY   { response_code, device_status, datalogger_e_11 }
  }
  TRANSACTION 812
  {
    REQUEST { 3,44 }
    REPLY   { response_code, device_status, datalogger_e_12 }
  }
  TRANSACTION 813
  {
    REQUEST { 3,45 }
    REPLY   { response_code, device_status, datalogger_e_13 }
  }
  TRANSACTION 814
  {
    REQUEST { 3,46 }
    REPLY   { response_code, device_status, datalogger_e_14 }
  }
  TRANSACTION 815
  {
    REQUEST { 3,47 }
    REPLY   { response_code, device_status, datalogger_e_15 }
  }
  TRANSACTION 816
  {
    REQUEST { 3,48 }
    REPLY   { response_code, device_status, datalogger_e_16 }
  }
  TRANSACTION 817
  {
    REQUEST { 3,49 }
    REPLY   { response_code, device_status, datalogger_e_17 }
  }
  TRANSACTION 818
  {
    REQUEST { 3,50 }
    REPLY   { response_code, device_status, datalogger_e_18 }
  }
  TRANSACTION 819
  {
    REQUEST { 3,51 }
    REPLY   { response_code, device_status, datalogger_e_19 }
  }
  TRANSACTION 820
  {
    REQUEST { 3,52 }
    REPLY   { response_code, device_status, datalogger_e_20 }
  }
  TRANSACTION 821
  {
    REQUEST { 3,53 }
    REPLY   { response_code, device_status, datalogger_e_21 }
  }
  TRANSACTION 822
  {
    REQUEST { 3,54 }
    REPLY   { response_code, device_status, datalogger_e_22 }
  }
  TRANSACTION 823
  {
    REQUEST { 3,55 }
    REPLY   { response_code, device_status, datalogger_e_23 }
  }
  TRANSACTION 824
  {
    REQUEST { 3,56 }
    REPLY   { response_code, device_status, datalogger_e_24 }
  }
  TRANSACTION 825
  {
    REQUEST { 3,57 }
    REPLY   { response_code, device_status, datalogger_e_25 }
  }
  TRANSACTION 826
  {
    REQUEST { 3,58 }
    REPLY   { response_code, device_status, datalogger_e_26 }
  }
  TRANSACTION 827
  {
    REQUEST { 3,59 }
    REPLY   { response_code, device_status, datalogger_e_27 }
  }
  TRANSACTION 828
  {
    REQUEST { 3,60 }
    REPLY   { response_code, device_status, datalogger_e_28 }
  }
  TRANSACTION 829
  {
    REQUEST { 3,61 }
    REPLY   { response_code, device_status, datalogger_e_29 }
  }
  TRANSACTION 830
  {
    REQUEST { 3,62 }
    REPLY   { response_code, device_status, datalogger_e_30 }
  }
  TRANSACTION 831
  {
    REQUEST { 3,63 }
    REPLY   { response_code, device_status, datalogger_e_31 }
  }
  TRANSACTION 832
  {
    REQUEST { 3,64 }
    REPLY   { response_code, device_status, datalogger_e_32 }
  }
  TRANSACTION 833
  {
    REQUEST { 3,65 }
    REPLY   { response_code, device_status, datalogger_e_33 }
  }
  TRANSACTION 834
  {
    REQUEST { 3,66 }
    REPLY   { response_code, device_status, datalogger_e_34 }
  }
  TRANSACTION 835
  {
    REQUEST { 3,67 }
    REPLY   { response_code, device_status, datalogger_e_35 }
  }
  TRANSACTION 836
  {
    REQUEST { 3,68 }
    REPLY   { response_code, device_status, datalogger_e_36 }
  }
  TRANSACTION 837
  {
    REQUEST { 3,69 }
    REPLY   { response_code, device_status, datalogger_e_37 }
  }
  TRANSACTION 838
  {
    REQUEST { 3,70 }
    REPLY   { response_code, device_status, datalogger_e_38 }
  }
  TRANSACTION 839
  {
    REQUEST { 3,71 }
    REPLY   { response_code, device_status, datalogger_e_39 }
  }
  TRANSACTION 840
  {
    REQUEST { 3,72 }
    REPLY   { response_code, device_status, datalogger_e_40 }
  }
  TRANSACTION 841
  {
    REQUEST { 3,73 }
    REPLY   { response_code, device_status, datalogger_e_41 }
  }
  TRANSACTION 842
  {
    REQUEST { 3,74 }
    REPLY   { response_code, device_status, datalogger_e_42 }
  }
  TRANSACTION 843
  {
    REQUEST { 3,75 }
    REPLY   { response_code, device_status, datalogger_e_43 }
  }
  TRANSACTION 844
  {
    REQUEST { 3,76 }
    REPLY   { response_code, device_status, datalogger_e_44 }
  }
  TRANSACTION 845
  {
    REQUEST { 3,77 }
    REPLY   { response_code, device_status, datalogger_e_45 }
  }
  TRANSACTION 846
  {
    REQUEST { 3,78 }
    REPLY   { response_code, device_status, datalogger_e_46 }
  }
  TRANSACTION 847
  {
    REQUEST { 3,79 }
    REPLY   { response_code, device_status, datalogger_e_47 }
  }
  TRANSACTION 848
  {
    REQUEST { 3,80 }
    REPLY   { response_code, device_status, datalogger_e_48 }
  }
  TRANSACTION 849
  {
    REQUEST { 3,81 }
    REPLY   { response_code, device_status, datalogger_e_49 }
  }
  TRANSACTION 850
  {
    REQUEST { 3,82 }
    REPLY   { response_code, device_status, datalogger_e_50 }
  }
  TRANSACTION 851
  {
    REQUEST { 3,83 }
    REPLY   { response_code, device_status, datalogger_e_51 }
  }
  TRANSACTION 852
  {
    REQUEST { 3,84 }
    REPLY   { response_code, device_status, datalogger_e_52 }
  }
  TRANSACTION 853
  {
    REQUEST { 3,85 }
    REPLY   { response_code, device_status, datalogger_e_53 }
  }
  TRANSACTION 854
  {
    REQUEST { 3,86 }
    REPLY   { response_code, device_status, datalogger_e_54 }
  }
  TRANSACTION 855
  {
    REQUEST { 3,87 }
    REPLY   { response_code, device_status, datalogger_e_55 }
  }
  TRANSACTION 856
  {
    REQUEST { 3,88 }
    REPLY   { response_code, device_status, datalogger_e_56 }
  }
  TRANSACTION 857
  {
    REQUEST { 3,89 }
    REPLY   { response_code, device_status, datalogger_e_57 }
  }
  TRANSACTION 858
  {
    REQUEST { 3,90 }
    REPLY   { response_code, device_status, datalogger_e_58 }
  }
  TRANSACTION 859
  {
    REQUEST { 3,91 }
    REPLY   { response_code, device_status, datalogger_e_59 }
  }
  TRANSACTION 860
  {
    REQUEST { 3,92 }
    REPLY   { response_code, device_status, datalogger_e_60 }
  }
  TRANSACTION 861
  {
    REQUEST { 3,93 }
    REPLY   { response_code, device_status, datalogger_e_61 }
  }
  TRANSACTION 862
  {
    REQUEST { 3,94 }
    REPLY   { response_code, device_status, datalogger_e_62 }
  }
  TRANSACTION 863
  {
    REQUEST { 3,95 }
    REPLY   { response_code, device_status, datalogger_e_63 }
  }
  TRANSACTION 864
  {
    REQUEST { 3,96 }
    REPLY   { response_code, device_status, datalogger_e_64 }
  }
  TRANSACTION 865
  {
    REQUEST { 3,97 }
    REPLY   { response_code, device_status, datalogger_e_65 }
  }
  TRANSACTION 866
  {
    REQUEST { 3,98 }
    REPLY   { response_code, device_status, datalogger_e_66 }
  }
  TRANSACTION 867
  {
    REQUEST { 3,99 }
    REPLY   { response_code, device_status, datalogger_e_67 }
  }
  TRANSACTION 868
  {
    REQUEST { 3,100 }
    REPLY   { response_code, device_status, datalogger_e_68 }
  }
  TRANSACTION 869
  {
    REQUEST { 3,101 }
    REPLY   { response_code, device_status, datalogger_e_69 }
  }
  TRANSACTION 870
  {
    REQUEST { 3,102 }
    REPLY   { response_code, device_status, datalogger_e_70 }
  }
  TRANSACTION 871
  {
    REQUEST { 3,103 }
    REPLY   { response_code, device_status, datalogger_e_71 }
  }
  TRANSACTION 872
  {
    REQUEST { 3,104 }
    REPLY   { response_code, device_status, datalogger_e_72 }
  }
  TRANSACTION 873
  {
    REQUEST { 3,105 }
    REPLY   { response_code, device_status, datalogger_e_73 }
  }
  TRANSACTION 874
  {
    REQUEST { 3,106 }
    REPLY   { response_code, device_status, datalogger_e_74 }
  }
  TRANSACTION 875
  {
    REQUEST { 3,107 }
    REPLY   { response_code, device_status, datalogger_e_75 }
  }
  TRANSACTION 876
  {
    REQUEST { 3,108 }
    REPLY   { response_code, device_status, datalogger_e_76 }
  }
  TRANSACTION 877
  {
    REQUEST { 3,109 }
    REPLY   { response_code, device_status, datalogger_e_77 }
  }
  TRANSACTION 878
  {
    REQUEST { 3,110 }
    REPLY   { response_code, device_status, datalogger_e_78 }
  }
  TRANSACTION 879
  {
    REQUEST { 3,111 }
    REPLY   { response_code, device_status, datalogger_e_79 }
  }
  TRANSACTION 880
  {
    REQUEST { 3,112 }
    REPLY   { response_code, device_status, datalogger_e_80 }
  }
  TRANSACTION 881
  {
    REQUEST { 3,113 }
    REPLY   { response_code, device_status, datalogger_e_81 }
  }
  TRANSACTION 882
  {
    REQUEST { 3,114 }
    REPLY   { response_code, device_status, datalogger_e_82 }
  }
  TRANSACTION 883
  {
    REQUEST { 3,115 }
    REPLY   { response_code, device_status, datalogger_e_83 }
  }
  TRANSACTION 884
  {
    REQUEST { 3,116 }
    REPLY   { response_code, device_status, datalogger_e_84 }
  }
  TRANSACTION 885
  {
    REQUEST { 3,117 }
    REPLY   { response_code, device_status, datalogger_e_85 }
  }
  TRANSACTION 886
  {
    REQUEST { 3,118 }
    REPLY   { response_code, device_status, datalogger_e_86 }
  }
  TRANSACTION 887
  {
    REQUEST { 3,119 }
    REPLY   { response_code, device_status, datalogger_e_87 }
  }
  TRANSACTION 888
  {
    REQUEST { 3,120 }
    REPLY   { response_code, device_status, datalogger_e_88 }
  }
  TRANSACTION 889
  {
    REQUEST { 3,121 }
    REPLY   { response_code, device_status, datalogger_e_89 }
  }
  TRANSACTION 890
  {
    REQUEST { 3,122 }
    REPLY   { response_code, device_status, datalogger_e_90 }
  }
  TRANSACTION 891
  {
    REQUEST { 3,123 }
    REPLY   { response_code, device_status, datalogger_e_91 }
  }
  TRANSACTION 892
  {
    REQUEST { 3,124 }
    REPLY   { response_code, device_status, datalogger_e_92 }
  }
  TRANSACTION 893
  {
    REQUEST { 3,125 }
    REPLY   { response_code, device_status, datalogger_e_93 }
  }
  TRANSACTION 894
  {
    REQUEST { 3,126 }
    REPLY   { response_code, device_status, datalogger_e_94 }
  }
  TRANSACTION 895
  {
    REQUEST { 3,127 }
    REPLY   { response_code, device_status, datalogger_e_95 }
  }
  TRANSACTION 896
  {
    REQUEST { 3,128 }
    REPLY   { response_code, device_status, datalogger_e_96 }
  }
  TRANSACTION 897
  {
    REQUEST { 3,129 }
    REPLY   { response_code, device_status, datalogger_e_97 }
  }
  TRANSACTION 898
  {
    REQUEST { 3,130 }
    REPLY   { response_code, device_status, datalogger_e_98 }
  }
  TRANSACTION 899
  {
    REQUEST { 3,131 }
    REPLY   { response_code, device_status, datalogger_e_99 }
  }


  TRANSACTION 900
  {
    REQUEST { 3,132 }
    REPLY   { response_code, device_status, datalogger_vs_0 }
  }
  TRANSACTION 901
  {
    REQUEST { 3,133 }
    REPLY   { response_code, device_status, datalogger_vs_1 }
  }
  TRANSACTION 902
  {
    REQUEST { 3,134 }
    REPLY   { response_code, device_status, datalogger_vs_2 }
  }
  TRANSACTION 903
  {
    REQUEST { 3,135 }
    REPLY   { response_code, device_status, datalogger_vs_3 }
  }
  TRANSACTION 904
  {
    REQUEST { 3,136 }
    REPLY   { response_code, device_status, datalogger_vs_4 }
  }
  TRANSACTION 905
  {
    REQUEST { 3,137 }
    REPLY   { response_code, device_status, datalogger_vs_5 }
  }
  TRANSACTION 906
  {
    REQUEST { 3,138 }
    REPLY   { response_code, device_status, datalogger_vs_6 }
  }
  TRANSACTION 907
  {
    REQUEST { 3,139 }
    REPLY   { response_code, device_status, datalogger_vs_7 }
  }
  TRANSACTION 908
  {
    REQUEST { 3,140 }
    REPLY   { response_code, device_status, datalogger_vs_8 }
  }
  TRANSACTION 909
  {
    REQUEST { 3,141 }
    REPLY   { response_code, device_status, datalogger_vs_9 }
  }
  TRANSACTION 910
  {
    REQUEST { 3,142 }
    REPLY   { response_code, device_status, datalogger_vs_10 }
  }
  TRANSACTION 911
  {
    REQUEST { 3,143 }
    REPLY   { response_code, device_status, datalogger_vs_11 }
  }
  TRANSACTION 912
  {
    REQUEST { 3,144 }
    REPLY   { response_code, device_status, datalogger_vs_12 }
  }
  TRANSACTION 913
  {
    REQUEST { 3,145 }
    REPLY   { response_code, device_status, datalogger_vs_13 }
  }
  TRANSACTION 914
  {
    REQUEST { 3,146 }
    REPLY   { response_code, device_status, datalogger_vs_14 }
  }
  TRANSACTION 915
  {
    REQUEST { 3,147 }
    REPLY   { response_code, device_status, datalogger_vs_15 }
  }
  TRANSACTION 916
  {
    REQUEST { 3,148 }
    REPLY   { response_code, device_status, datalogger_vs_16 }
  }
  TRANSACTION 917
  {
    REQUEST { 3,149 }
    REPLY   { response_code, device_status, datalogger_vs_17 }
  }
  TRANSACTION 918
  {
    REQUEST { 3,150 }
    REPLY   { response_code, device_status, datalogger_vs_18 }
  }
  TRANSACTION 919
  {
    REQUEST { 3,151 }
    REPLY   { response_code, device_status, datalogger_vs_19 }
  }
  TRANSACTION 920
  {
    REQUEST { 3,152 }
    REPLY   { response_code, device_status, datalogger_vs_20 }
  }
  TRANSACTION 921
  {
    REQUEST { 3,153 }
    REPLY   { response_code, device_status, datalogger_vs_21 }
  }
  TRANSACTION 922
  {
    REQUEST { 3,154 }
    REPLY   { response_code, device_status, datalogger_vs_22 }
  }
  TRANSACTION 923
  {
    REQUEST { 3,155 }
    REPLY   { response_code, device_status, datalogger_vs_23 }
  }
  TRANSACTION 924
  {
    REQUEST { 3,156 }
    REPLY   { response_code, device_status, datalogger_vs_24 }
  }
  TRANSACTION 925
  {
    REQUEST { 3,157 }
    REPLY   { response_code, device_status, datalogger_vs_25 }
  }
  TRANSACTION 926
  {
    REQUEST { 3,158 }
    REPLY   { response_code, device_status, datalogger_vs_26 }
  }
  TRANSACTION 927
  {
    REQUEST { 3,159 }
    REPLY   { response_code, device_status, datalogger_vs_27 }
  }
  TRANSACTION 928
  {
    REQUEST { 3,160 }
    REPLY   { response_code, device_status, datalogger_vs_28 }
  }
  TRANSACTION 929
  {
    REQUEST { 3,161 }
    REPLY   { response_code, device_status, datalogger_vs_29 }
  }
  TRANSACTION 930
  {
    REQUEST { 3,162 }
    REPLY   { response_code, device_status, datalogger_vs_30 }
  }
  TRANSACTION 931
  {
    REQUEST { 3,163 }
    REPLY   { response_code, device_status, datalogger_vs_31 }
  }
  TRANSACTION 932
  {
    REQUEST { 3,164 }
    REPLY   { response_code, device_status, datalogger_vs_32 }
  }
  TRANSACTION 933
  {
    REQUEST { 3,165 }
    REPLY   { response_code, device_status, datalogger_vs_33 }
  }
  TRANSACTION 934
  {
    REQUEST { 3,166 }
    REPLY   { response_code, device_status, datalogger_vs_34 }
  }
  TRANSACTION 935
  {
    REQUEST { 3,167 }
    REPLY   { response_code, device_status, datalogger_vs_35 }
  }
  TRANSACTION 936
  {
    REQUEST { 3,168 }
    REPLY   { response_code, device_status, datalogger_vs_36 }
  }
  TRANSACTION 937
  {
    REQUEST { 3,169 }
    REPLY   { response_code, device_status, datalogger_vs_37 }
  }
  TRANSACTION 938
  {
    REQUEST { 3,170 }
    REPLY   { response_code, device_status, datalogger_vs_38 }
  }
  TRANSACTION 939
  {
    REQUEST { 3,171 }
    REPLY   { response_code, device_status, datalogger_vs_39 }
  }
  TRANSACTION 940
  {
    REQUEST { 3,172 }
    REPLY   { response_code, device_status, datalogger_vs_40 }
  }
  TRANSACTION 941
  {
    REQUEST { 3,173 }
    REPLY   { response_code, device_status, datalogger_vs_41 }
  }
  TRANSACTION 942
  {
    REQUEST { 3,174 }
    REPLY   { response_code, device_status, datalogger_vs_42 }
  }
  TRANSACTION 943
  {
    REQUEST { 3,175 }
    REPLY   { response_code, device_status, datalogger_vs_43 }
  }
  TRANSACTION 944
  {
    REQUEST { 3,176 }
    REPLY   { response_code, device_status, datalogger_vs_44 }
  }
  TRANSACTION 945
  {
    REQUEST { 3,177 }
    REPLY   { response_code, device_status, datalogger_vs_45 }
  }
  TRANSACTION 946
  {
    REQUEST { 3,178 }
    REPLY   { response_code, device_status, datalogger_vs_46 }
  }
  TRANSACTION 947
  {
    REQUEST { 3,179 }
    REPLY   { response_code, device_status, datalogger_vs_47 }
  }
  TRANSACTION 948
  {
    REQUEST { 3,180 }
    REPLY   { response_code, device_status, datalogger_vs_48 }
  }
  TRANSACTION 949
  {
    REQUEST { 3,181 }
    REPLY   { response_code, device_status, datalogger_vs_49 }
  }
  TRANSACTION 950
  {
    REQUEST { 3,182 }
    REPLY   { response_code, device_status, datalogger_vs_50 }
  }
  TRANSACTION 951
  {
    REQUEST { 3,183 }
    REPLY   { response_code, device_status, datalogger_vs_51 }
  }
  TRANSACTION 952
  {
    REQUEST { 3,184 }
    REPLY   { response_code, device_status, datalogger_vs_52 }
  }
  TRANSACTION 953
  {
    REQUEST { 3,185 }
    REPLY   { response_code, device_status, datalogger_vs_53 }
  }
  TRANSACTION 954
  {
    REQUEST { 3,186 }
    REPLY   { response_code, device_status, datalogger_vs_54 }
  }
  TRANSACTION 955
  {
    REQUEST { 3,187 }
    REPLY   { response_code, device_status, datalogger_vs_55 }
  }
  TRANSACTION 956
  {
    REQUEST { 3,188 }
    REPLY   { response_code, device_status, datalogger_vs_56 }
  }
  TRANSACTION 957
  {
    REQUEST { 3,189 }
    REPLY   { response_code, device_status, datalogger_vs_57 }
  }
  TRANSACTION 958
  {
    REQUEST { 3,190 }
    REPLY   { response_code, device_status, datalogger_vs_58 }
  }
  TRANSACTION 959
  {
    REQUEST { 3,191 }
    REPLY   { response_code, device_status, datalogger_vs_59 }
  }
  TRANSACTION 960
  {
    REQUEST { 3,192 }
    REPLY   { response_code, device_status, datalogger_vs_60 }
  }
  TRANSACTION 961
  {
    REQUEST { 3,193 }
    REPLY   { response_code, device_status, datalogger_vs_61 }
  }
  TRANSACTION 962
  {
    REQUEST { 3,194 }
    REPLY   { response_code, device_status, datalogger_vs_62 }
  }
  TRANSACTION 963
  {
    REQUEST { 3,195 }
    REPLY   { response_code, device_status, datalogger_vs_63 }
  }
  TRANSACTION 964
  {
    REQUEST { 3,196 }
    REPLY   { response_code, device_status, datalogger_vs_64 }
  }
  TRANSACTION 965
  {
    REQUEST { 3,197 }
    REPLY   { response_code, device_status, datalogger_vs_65 }
  }
  TRANSACTION 966
  {
    REQUEST { 3,198 }
    REPLY   { response_code, device_status, datalogger_vs_66 }
  }
  TRANSACTION 967
  {
    REQUEST { 3,199 }
    REPLY   { response_code, device_status, datalogger_vs_67 }
  }
  TRANSACTION 968
  {
    REQUEST { 3,200 }
    REPLY   { response_code, device_status, datalogger_vs_68 }
  }
  TRANSACTION 969
  {
    REQUEST { 3,201 }
    REPLY   { response_code, device_status, datalogger_vs_69 }
  }
  TRANSACTION 970
  {
    REQUEST { 3,202 }
    REPLY   { response_code, device_status, datalogger_vs_70 }
  }
  TRANSACTION 971
  {
    REQUEST { 3,203 }
    REPLY   { response_code, device_status, datalogger_vs_71 }
  }
  TRANSACTION 972
  {
    REQUEST { 3,204 }
    REPLY   { response_code, device_status, datalogger_vs_72 }
  }
  TRANSACTION 973
  {
    REQUEST { 3,205 }
    REPLY   { response_code, device_status, datalogger_vs_73 }
  }
  TRANSACTION 974
  {
    REQUEST { 3,206 }
    REPLY   { response_code, device_status, datalogger_vs_74 }
  }
  TRANSACTION 975
  {
    REQUEST { 3,207 }
    REPLY   { response_code, device_status, datalogger_vs_75 }
  }
  TRANSACTION 976
  {
    REQUEST { 3,208 }
    REPLY   { response_code, device_status, datalogger_vs_76 }
  }
  TRANSACTION 977
  {
    REQUEST { 3,209 }
    REPLY   { response_code, device_status, datalogger_vs_77 }
  }
  TRANSACTION 978
  {
    REQUEST { 3,210 }
    REPLY   { response_code, device_status, datalogger_vs_78 }
  }
  TRANSACTION 979
  {
    REQUEST { 3,211 }
    REPLY   { response_code, device_status, datalogger_vs_79 }
  }
  TRANSACTION 980
  {
    REQUEST { 3,212 }
    REPLY   { response_code, device_status, datalogger_vs_80 }
  }
  TRANSACTION 981
  {
    REQUEST { 3,213 }
    REPLY   { response_code, device_status, datalogger_vs_81 }
  }
  TRANSACTION 982
  {
    REQUEST { 3,214 }
    REPLY   { response_code, device_status, datalogger_vs_82 }
  }
  TRANSACTION 983
  {
    REQUEST { 3,215 }
    REPLY   { response_code, device_status, datalogger_vs_83 }
  }
  TRANSACTION 984
  {
    REQUEST { 3,216 }
    REPLY   { response_code, device_status, datalogger_vs_84 }
  }
  TRANSACTION 985
  {
    REQUEST { 3,217 }
    REPLY   { response_code, device_status, datalogger_vs_85 }
  }
  TRANSACTION 986
  {
    REQUEST { 3,218 }
    REPLY   { response_code, device_status, datalogger_vs_86 }
  }
  TRANSACTION 987
  {
    REQUEST { 3,219 }
    REPLY   { response_code, device_status, datalogger_vs_87 }
  }
  TRANSACTION 988
  {
    REQUEST { 3,220 }
    REPLY   { response_code, device_status, datalogger_vs_88 }
  }
  TRANSACTION 989
  {
    REQUEST { 3,221 }
    REPLY   { response_code, device_status, datalogger_vs_89 }
  }
  TRANSACTION 990
  {
    REQUEST { 3,222 }
    REPLY   { response_code, device_status, datalogger_vs_90 }
  }
  TRANSACTION 991
  {
    REQUEST { 3,223 }
    REPLY   { response_code, device_status, datalogger_vs_91 }
  }
  TRANSACTION 992
  {
    REQUEST { 3,224 }
    REPLY   { response_code, device_status, datalogger_vs_92 }
  }
  TRANSACTION 993
  {
    REQUEST { 3,225 }
    REPLY   { response_code, device_status, datalogger_vs_93 }
  }
  TRANSACTION 994
  {
    REQUEST { 3,226 }
    REPLY   { response_code, device_status, datalogger_vs_94 }
  }
  TRANSACTION 995
  {
    REQUEST { 3,227 }
    REPLY   { response_code, device_status, datalogger_vs_95 }
  }
  TRANSACTION 996
  {
    REQUEST { 3,228 }
    REPLY   { response_code, device_status, datalogger_vs_96 }
  }
  TRANSACTION 997
  {
    REQUEST { 3,229 }
    REPLY   { response_code, device_status, datalogger_vs_97 }
  }
  TRANSACTION 998
  {
    REQUEST { 3,230 }
    REPLY   { response_code, device_status, datalogger_vs_98 }
  }
  TRANSACTION 999
  {
    REQUEST { 3,231 }
    REPLY   { response_code, device_status, datalogger_vs_99 }
  }

/*
  TRANSACTION 1000
  {
    REQUEST { 3,232 }
    REPLY   { response_code, device_status, sprung_vs_0 }
  }
  TRANSACTION 1001
  {
    REQUEST { 3,233 }
    REPLY   { response_code, device_status, sprung_vs_1 }
  }
  TRANSACTION 1002
  {
    REQUEST { 3,234 }
    REPLY   { response_code, device_status, sprung_vs_2 }
  }
  TRANSACTION 1003
  {
    REQUEST { 3,235 }
    REPLY   { response_code, device_status, sprung_vs_3 }
  }
  TRANSACTION 1004
  {
    REQUEST { 3,236 }
    REPLY   { response_code, device_status, sprung_vs_4 }
  }
  TRANSACTION 1005
  {
    REQUEST { 3,237 }
    REPLY   { response_code, device_status, sprung_vs_5 }
  }
  TRANSACTION 1006
  {
    REQUEST { 3,238 }
    REPLY   { response_code, device_status, sprung_vs_6 }
  }
  TRANSACTION 1007
  {
    REQUEST { 3,239 }
    REPLY   { response_code, device_status, sprung_vs_7 }
  }
  TRANSACTION 1008
  {
    REQUEST { 3,240 }
    REPLY   { response_code, device_status, sprung_vs_8 }
  }
  TRANSACTION 1009
  {
    REQUEST { 3,241 }
    REPLY   { response_code, device_status, sprung_vs_9 }
  }
  TRANSACTION 1010
  {
    REQUEST { 3,242 }
    REPLY   { response_code, device_status, sprung_vs_10 }
  }
  TRANSACTION 1011
  {
    REQUEST { 3,243 }
    REPLY   { response_code, device_status, sprung_vs_11 }
  }
  TRANSACTION 1012
  {
    REQUEST { 3,244 }
    REPLY   { response_code, device_status, sprung_vs_12 }
  }
  TRANSACTION 1013
  {
    REQUEST { 3,245 }
    REPLY   { response_code, device_status, sprung_vs_13 }
  }
  TRANSACTION 1014
  {
    REQUEST { 3,246 }
    REPLY   { response_code, device_status, sprung_vs_14 }
  }
  TRANSACTION 1015
  {
    REQUEST { 3,247 }
    REPLY   { response_code, device_status, sprung_vs_15 }
  }
  TRANSACTION 1016
  {
    REQUEST { 3,248 }
    REPLY   { response_code, device_status, sprung_vs_16 }
  }
  TRANSACTION 1017
  {
    REQUEST { 3,249 }
    REPLY   { response_code, device_status, sprung_vs_17 }
  }
  TRANSACTION 1018
  {
    REQUEST { 3,250 }
    REPLY   { response_code, device_status, sprung_vs_18 }
  }
  TRANSACTION 1019
  {
    REQUEST { 3,251 }
    REPLY   { response_code, device_status, sprung_vs_19 }
  }
  TRANSACTION 1020
  {
    REQUEST { 3,252 }
    REPLY   { response_code, device_status, sprung_vs_20 }
  }
  TRANSACTION 1021
  {
    REQUEST { 3,253 }
    REPLY   { response_code, device_status, sprung_vs_21 }
  }
  TRANSACTION 1022
  {
    REQUEST { 3,254 }
    REPLY   { response_code, device_status, sprung_vs_22 }
  }
  TRANSACTION 1023
  {
    REQUEST { 3,255 }
    REPLY   { response_code, device_status, sprung_vs_23 }
  }
  TRANSACTION 1024
  {
    REQUEST { 4,0 }
    REPLY   { response_code, device_status, sprung_vs_24 }
  }
  TRANSACTION 1025
  {
    REQUEST { 4,1 }
    REPLY   { response_code, device_status, sprung_vs_25 }
  }
  TRANSACTION 1026
  {
    REQUEST { 4,2 }
    REPLY   { response_code, device_status, sprung_vs_26 }
  }
  TRANSACTION 1027
  {
    REQUEST { 4,3 }
    REPLY   { response_code, device_status, sprung_vs_27 }
  }
  TRANSACTION 1028
  {
    REQUEST { 4,4 }
    REPLY   { response_code, device_status, sprung_vs_28 }
  }
  TRANSACTION 1029
  {
    REQUEST { 4,5 }
    REPLY   { response_code, device_status, sprung_vs_29 }
  }
  TRANSACTION 1030
  {
    REQUEST { 4,6 }
    REPLY   { response_code, device_status, sprung_vs_30 }
  }
  TRANSACTION 1031
  {
    REQUEST { 4,7 }
    REPLY   { response_code, device_status, sprung_vs_31 }
  }
  TRANSACTION 1032
  {
    REQUEST { 4,8 }
    REPLY   { response_code, device_status, sprung_vs_32 }
  }
  TRANSACTION 1033
  {
    REQUEST { 4,9 }
    REPLY   { response_code, device_status, sprung_vs_33 }
  }
  TRANSACTION 1034
  {
    REQUEST { 4,10 }
    REPLY   { response_code, device_status, sprung_vs_34 }
  }
  TRANSACTION 1035
  {
    REQUEST { 4,11 }
    REPLY   { response_code, device_status, sprung_vs_35 }
  }
  TRANSACTION 1036
  {
    REQUEST { 4,12 }
    REPLY   { response_code, device_status, sprung_vs_36 }
  }
  TRANSACTION 1037
  {
    REQUEST { 4,13 }
    REPLY   { response_code, device_status, sprung_vs_37 }
  }
  TRANSACTION 1038
  {
    REQUEST { 4,14 }
    REPLY   { response_code, device_status, sprung_vs_38 }
  }
  TRANSACTION 1039
  {
    REQUEST { 4,15 }
    REPLY   { response_code, device_status, sprung_vs_39 }
  }
  TRANSACTION 1040
  {
    REQUEST { 4,16 }
    REPLY   { response_code, device_status, sprung_vs_40 }
  }
  TRANSACTION 1041
  {
    REQUEST { 4,17 }
    REPLY   { response_code, device_status, sprung_vs_41 }
  }
  TRANSACTION 1042
  {
    REQUEST { 4,18 }
    REPLY   { response_code, device_status, sprung_vs_42 }
  }
  TRANSACTION 1043
  {
    REQUEST { 4,19 }
    REPLY   { response_code, device_status, sprung_vs_43 }
  }
  TRANSACTION 1044
  {
    REQUEST { 4,20 }
    REPLY   { response_code, device_status, sprung_vs_44 }
  }
  TRANSACTION 1045
  {
    REQUEST { 4,21 }
    REPLY   { response_code, device_status, sprung_vs_45 }
  }
  TRANSACTION 1046
  {
    REQUEST { 4,22 }
    REPLY   { response_code, device_status, sprung_vs_46 }
  }
  TRANSACTION 1047
  {
    REQUEST { 4,23 }
    REPLY   { response_code, device_status, sprung_vs_47 }
  }
  TRANSACTION 1048
  {
    REQUEST { 4,24 }
    REPLY   { response_code, device_status, sprung_vs_48 }
  }
  TRANSACTION 1049
  {
    REQUEST { 4,25 }
    REPLY   { response_code, device_status, sprung_vs_49 }
  }
  TRANSACTION 1050
  {
    REQUEST { 4,26 }
    REPLY   { response_code, device_status, sprung_vs_50 }
  }
  TRANSACTION 1051
  {
    REQUEST { 4,27 }
    REPLY   { response_code, device_status, sprung_vs_51 }
  }
  TRANSACTION 1052
  {
    REQUEST { 4,28 }
    REPLY   { response_code, device_status, sprung_vs_52 }
  }
  TRANSACTION 1053
  {
    REQUEST { 4,29 }
    REPLY   { response_code, device_status, sprung_vs_53 }
  }
  TRANSACTION 1054
  {
    REQUEST { 4,30 }
    REPLY   { response_code, device_status, sprung_vs_54 }
  }
  TRANSACTION 1055
  {
    REQUEST { 4,31 }
    REPLY   { response_code, device_status, sprung_vs_55 }
  }
  TRANSACTION 1056
  {
    REQUEST { 4,32 }
    REPLY   { response_code, device_status, sprung_vs_56 }
  }
  TRANSACTION 1057
  {
    REQUEST { 4,33 }
    REPLY   { response_code, device_status, sprung_vs_57 }
  }
  TRANSACTION 1058
  {
    REQUEST { 4,34 }
    REPLY   { response_code, device_status, sprung_vs_58 }
  }
  TRANSACTION 1059
  {
    REQUEST { 4,35 }
    REPLY   { response_code, device_status, sprung_vs_59 }
  }
  TRANSACTION 1060
  {
    REQUEST { 4,36 }
    REPLY   { response_code, device_status, sprung_vs_60 }
  }
  TRANSACTION 1061
  {
    REQUEST { 4,37 }
    REPLY   { response_code, device_status, sprung_vs_61 }
  }
  TRANSACTION 1062
  {
    REQUEST { 4,38 }
    REPLY   { response_code, device_status, sprung_vs_62 }
  }
  TRANSACTION 1063
  {
    REQUEST { 4,39 }
    REPLY   { response_code, device_status, sprung_vs_63 }
  }
  TRANSACTION 1064
  {
    REQUEST { 4,40 }
    REPLY   { response_code, device_status, sprung_vs_64 }
  }
  TRANSACTION 1065
  {
    REQUEST { 4,41 }
    REPLY   { response_code, device_status, sprung_vs_65 }
  }
  TRANSACTION 1066
  {
    REQUEST { 4,42 }
    REPLY   { response_code, device_status, sprung_vs_66 }
  }
  TRANSACTION 1067
  {
    REQUEST { 4,43 }
    REPLY   { response_code, device_status, sprung_vs_67 }
  }
  TRANSACTION 1068
  {
    REQUEST { 4,44 }
    REPLY   { response_code, device_status, sprung_vs_68 }
  }
  TRANSACTION 1069
  {
    REQUEST { 4,45 }
    REPLY   { response_code, device_status, sprung_vs_69 }
  }
  TRANSACTION 1070
  {
    REQUEST { 4,46 }
    REPLY   { response_code, device_status, sprung_vs_70 }
  }
  TRANSACTION 1071
  {
    REQUEST { 4,47 }
    REPLY   { response_code, device_status, sprung_vs_71 }
  }
  TRANSACTION 1072
  {
    REQUEST { 4,48 }
    REPLY   { response_code, device_status, sprung_vs_72 }
  }
  TRANSACTION 1073
  {
    REQUEST { 4,49 }
    REPLY   { response_code, device_status, sprung_vs_73 }
  }
  TRANSACTION 1074
  {
    REQUEST { 4,50 }
    REPLY   { response_code, device_status, sprung_vs_74 }
  }
  TRANSACTION 1075
  {
    REQUEST { 4,51 }
    REPLY   { response_code, device_status, sprung_vs_75 }
  }
  TRANSACTION 1076
  {
    REQUEST { 4,52 }
    REPLY   { response_code, device_status, sprung_vs_76 }
  }
  TRANSACTION 1077
  {
    REQUEST { 4,53 }
    REPLY   { response_code, device_status, sprung_vs_77 }
  }
  TRANSACTION 1078
  {
    REQUEST { 4,54 }
    REPLY   { response_code, device_status, sprung_vs_78 }
  }
  TRANSACTION 1079
  {
    REQUEST { 4,55 }
    REPLY   { response_code, device_status, sprung_vs_79 }
  }
  TRANSACTION 1080
  {
    REQUEST { 4,56 }
    REPLY   { response_code, device_status, sprung_vs_80 }
  }
  TRANSACTION 1081
  {
    REQUEST { 4,57 }
    REPLY   { response_code, device_status, sprung_vs_81 }
  }
  TRANSACTION 1082
  {
    REQUEST { 4,58 }
    REPLY   { response_code, device_status, sprung_vs_82 }
  }
  TRANSACTION 1083
  {
    REQUEST { 4,59 }
    REPLY   { response_code, device_status, sprung_vs_83 }
  }
  TRANSACTION 1084
  {
    REQUEST { 4,60 }
    REPLY   { response_code, device_status, sprung_vs_84 }
  }
  TRANSACTION 1085
  {
    REQUEST { 4,61 }
    REPLY   { response_code, device_status, sprung_vs_85 }
  }
  TRANSACTION 1086
  {
    REQUEST { 4,62 }
    REPLY   { response_code, device_status, sprung_vs_86 }
  }
  TRANSACTION 1087
  {
    REQUEST { 4,63 }
    REPLY   { response_code, device_status, sprung_vs_87 }
  }
  TRANSACTION 1088
  {
    REQUEST { 4,64 }
    REPLY   { response_code, device_status, sprung_vs_88 }
  }
  TRANSACTION 1089
  {
    REQUEST { 4,65 }
    REPLY   { response_code, device_status, sprung_vs_89 }
  }
  TRANSACTION 1090
  {
    REQUEST { 4,66 }
    REPLY   { response_code, device_status, sprung_vs_90 }
  }
  TRANSACTION 1091
  {
    REQUEST { 4,67 }
    REPLY   { response_code, device_status, sprung_vs_91 }
  }
  TRANSACTION 1092
  {
    REQUEST { 4,68 }
    REPLY   { response_code, device_status, sprung_vs_92 }
  }
  TRANSACTION 1093
  {
    REQUEST { 4,69 }
    REPLY   { response_code, device_status, sprung_vs_93 }
  }
  TRANSACTION 1094
  {
    REQUEST { 4,70 }
    REPLY   { response_code, device_status, sprung_vs_94 }
  }
  TRANSACTION 1095
  {
    REQUEST { 4,71 }
    REPLY   { response_code, device_status, sprung_vs_95 }
  }
  TRANSACTION 1096
  {
    REQUEST { 4,72 }
    REPLY   { response_code, device_status, sprung_vs_96 }
  }
  TRANSACTION 1097
  {
    REQUEST { 4,73 }
    REPLY   { response_code, device_status, sprung_vs_97 }
  }
  TRANSACTION 1098
  {
    REQUEST { 4,74 }
    REPLY   { response_code, device_status, sprung_vs_98 }
  }
  TRANSACTION 1099
  {
    REQUEST { 4,75 }
    REPLY   { response_code, device_status, sprung_vs_99 }
  }
*/
/*
  TRANSACTION 1100
  {
    REQUEST { 4,76 }
    REPLY   { response_code, device_status, sprung_sw_0 }
  }
  TRANSACTION 1101
  {
    REQUEST { 4,77 }
    REPLY   { response_code, device_status, sprung_sw_1 }
  }
  TRANSACTION 1102
  {
    REQUEST { 4,78 }
    REPLY   { response_code, device_status, sprung_sw_2 }
  }
  TRANSACTION 1103
  {
    REQUEST { 4,79 }
    REPLY   { response_code, device_status, sprung_sw_3 }
  }
  TRANSACTION 1104
  {
    REQUEST { 4,80 }
    REPLY   { response_code, device_status, sprung_sw_4 }
  }
  TRANSACTION 1105
  {
    REQUEST { 4,81 }
    REPLY   { response_code, device_status, sprung_sw_5 }
  }
  TRANSACTION 1106
  {
    REQUEST { 4,82 }
    REPLY   { response_code, device_status, sprung_sw_6 }
  }
  TRANSACTION 1107
  {
    REQUEST { 4,83 }
    REPLY   { response_code, device_status, sprung_sw_7 }
  }
  TRANSACTION 1108
  {
    REQUEST { 4,84 }
    REPLY   { response_code, device_status, sprung_sw_8 }
  }
  TRANSACTION 1109
  {
    REQUEST { 4,85 }
    REPLY   { response_code, device_status, sprung_sw_9 }
  }
  TRANSACTION 1110
  {
    REQUEST { 4,86 }
    REPLY   { response_code, device_status, sprung_sw_10 }
  }
  TRANSACTION 1111
  {
    REQUEST { 4,87 }
    REPLY   { response_code, device_status, sprung_sw_11 }
  }
  TRANSACTION 1112
  {
    REQUEST { 4,88 }
    REPLY   { response_code, device_status, sprung_sw_12 }
  }
  TRANSACTION 1113
  {
    REQUEST { 4,89 }
    REPLY   { response_code, device_status, sprung_sw_13 }
  }
  TRANSACTION 1114
  {
    REQUEST { 4,90 }
    REPLY   { response_code, device_status, sprung_sw_14 }
  }
  TRANSACTION 1115
  {
    REQUEST { 4,91 }
    REPLY   { response_code, device_status, sprung_sw_15 }
  }
  TRANSACTION 1116
  {
    REQUEST { 4,91 }
    REPLY   { response_code, device_status, sprung_sw_16 }
  }
  TRANSACTION 1117
  {
    REQUEST { 4,93 }
    REPLY   { response_code, device_status, sprung_sw_17 }
  }
  TRANSACTION 1118
  {
    REQUEST { 4,94 }
    REPLY   { response_code, device_status, sprung_sw_18 }
  }
  TRANSACTION 1119
  {
    REQUEST { 4,95 }
    REPLY   { response_code, device_status, sprung_sw_19 }
  }
  TRANSACTION 1120
  {
    REQUEST { 4,96 }
    REPLY   { response_code, device_status, sprung_sw_20 }
  }
  TRANSACTION 1121
  {
    REQUEST { 4,97 }
    REPLY   { response_code, device_status, sprung_sw_21 }
  }
  TRANSACTION 1122
  {
    REQUEST { 4,98 }
    REPLY   { response_code, device_status, sprung_sw_22 }
  }
  TRANSACTION 1123
  {
    REQUEST { 4,99 }
    REPLY   { response_code, device_status, sprung_sw_23 }
  }
  TRANSACTION 1124
  {
    REQUEST { 4,100 }
    REPLY   { response_code, device_status, sprung_sw_24 }
  }
  TRANSACTION 1125
  {
    REQUEST { 4,101 }
    REPLY   { response_code, device_status, sprung_sw_25 }
  }
  TRANSACTION 1126
  {
    REQUEST { 4,102 }
    REPLY   { response_code, device_status, sprung_sw_26 }
  }
  TRANSACTION 1127
  {
    REQUEST { 4,103 }
    REPLY   { response_code, device_status, sprung_sw_27 }
  }
  TRANSACTION 1128
  {
    REQUEST { 4,104 }
    REPLY   { response_code, device_status, sprung_sw_28 }
  }
  TRANSACTION 1129
  {
    REQUEST { 4,105 }
    REPLY   { response_code, device_status, sprung_sw_29 }
  }
  TRANSACTION 1130
  {
    REQUEST { 4,106 }
    REPLY   { response_code, device_status, sprung_sw_30 }
  }
  TRANSACTION 1131
  {
    REQUEST { 4,107 }
    REPLY   { response_code, device_status, sprung_sw_31 }
  }
  TRANSACTION 1132
  {
    REQUEST { 4,108 }
    REPLY   { response_code, device_status, sprung_sw_32 }
  }
  TRANSACTION 1133
  {
    REQUEST { 4,109 }
    REPLY   { response_code, device_status, sprung_sw_33 }
  }
  TRANSACTION 1134
  {
    REQUEST { 4,110 }
    REPLY   { response_code, device_status, sprung_sw_34 }
  }
  TRANSACTION 1135
  {
    REQUEST { 4,111 }
    REPLY   { response_code, device_status, sprung_sw_35 }
  }
  TRANSACTION 1136
  {
    REQUEST { 4,112 }
    REPLY   { response_code, device_status, sprung_sw_36 }
  }
  TRANSACTION 1137
  {
    REQUEST { 4,113 }
    REPLY   { response_code, device_status, sprung_sw_37 }
  }
  TRANSACTION 1138
  {
    REQUEST { 4,114 }
    REPLY   { response_code, device_status, sprung_sw_38 }
  }
  TRANSACTION 1139
  {
    REQUEST { 4,115 }
    REPLY   { response_code, device_status, sprung_sw_39 }
  }
  TRANSACTION 1140
  {
    REQUEST { 4,116 }
    REPLY   { response_code, device_status, sprung_sw_40 }
  }
  TRANSACTION 1141
  {
    REQUEST { 4,117 }
    REPLY   { response_code, device_status, sprung_sw_41 }
  }
  TRANSACTION 1142
  {
    REQUEST { 4,118 }
    REPLY   { response_code, device_status, sprung_sw_42 }
  }
  TRANSACTION 1143
  {
    REQUEST { 4,119 }
    REPLY   { response_code, device_status, sprung_sw_43 }
  }
  TRANSACTION 1144
  {
    REQUEST { 4,120 }
    REPLY   { response_code, device_status, sprung_sw_44 }
  }
  TRANSACTION 1145
  {
    REQUEST { 4,121 }
    REPLY   { response_code, device_status, sprung_sw_45 }
  }
  TRANSACTION 1146
  {
    REQUEST { 4,122 }
    REPLY   { response_code, device_status, sprung_sw_46 }
  }
  TRANSACTION 1147
  {
    REQUEST { 4,123 }
    REPLY   { response_code, device_status, sprung_sw_47 }
  }
  TRANSACTION 1148
  {
    REQUEST { 4,124 }
    REPLY   { response_code, device_status, sprung_sw_48 }
  }
  TRANSACTION 1149
  {
    REQUEST { 4,125 }
    REPLY   { response_code, device_status, sprung_sw_49 }
  }
  TRANSACTION 1150
  {
    REQUEST { 4,126 }
    REPLY   { response_code, device_status, sprung_sw_50 }
  }
  TRANSACTION 1151
  {
    REQUEST { 4,127 }
    REPLY   { response_code, device_status, sprung_sw_51 }
  }
  TRANSACTION 1152
  {
    REQUEST { 4,128 }
    REPLY   { response_code, device_status, sprung_sw_52 }
  }
  TRANSACTION 1153
  {
    REQUEST { 4,129 }
    REPLY   { response_code, device_status, sprung_sw_53 }
  }
  TRANSACTION 1154
  {
    REQUEST { 4,130 }
    REPLY   { response_code, device_status, sprung_sw_54 }
  }
  TRANSACTION 1155
  {
    REQUEST { 4,131 }
    REPLY   { response_code, device_status, sprung_sw_55 }
  }
  TRANSACTION 1156
  {
    REQUEST { 4,132 }
    REPLY   { response_code, device_status, sprung_sw_56 }
  }
  TRANSACTION 1157
  {
    REQUEST { 4,133 }
    REPLY   { response_code, device_status, sprung_sw_57 }
  }
  TRANSACTION 1158
  {
    REQUEST { 4,134 }
    REPLY   { response_code, device_status, sprung_sw_58 }
  }
  TRANSACTION 1159
  {
    REQUEST { 4,135 }
    REPLY   { response_code, device_status, sprung_sw_59 }
  }
  TRANSACTION 1160
  {
    REQUEST { 4,136 }
    REPLY   { response_code, device_status, sprung_sw_60 }
  }
  TRANSACTION 1161
  {
    REQUEST { 4,137 }
    REPLY   { response_code, device_status, sprung_sw_61 }
  }
  TRANSACTION 1162
  {
    REQUEST { 4,138 }
    REPLY   { response_code, device_status, sprung_sw_62 }
  }
  TRANSACTION 1163
  {
    REQUEST { 4,139 }
    REPLY   { response_code, device_status, sprung_sw_63 }
  }
  TRANSACTION 1164
  {
    REQUEST { 4,140 }
    REPLY   { response_code, device_status, sprung_sw_64 }
  }
  TRANSACTION 1165
  {
    REQUEST { 4,141 }
    REPLY   { response_code, device_status, sprung_sw_65 }
  }
  TRANSACTION 1166
  {
    REQUEST { 4,142 }
    REPLY   { response_code, device_status, sprung_sw_66 }
  }
  TRANSACTION 1167
  {
    REQUEST { 4,143 }
    REPLY   { response_code, device_status, sprung_sw_67 }
  }
  TRANSACTION 1168
  {
    REQUEST { 4,144 }
    REPLY   { response_code, device_status, sprung_sw_68 }
  }
  TRANSACTION 1169
  {
    REQUEST { 4,145 }
    REPLY   { response_code, device_status, sprung_sw_69 }
  }
  TRANSACTION 1170
  {
    REQUEST { 4,146 }
    REPLY   { response_code, device_status, sprung_sw_70 }
  }
  TRANSACTION 1171
  {
    REQUEST { 4,147 }
    REPLY   { response_code, device_status, sprung_sw_71 }
  }
  TRANSACTION 1172
  {
    REQUEST { 4,148 }
    REPLY   { response_code, device_status, sprung_sw_72 }
  }
  TRANSACTION 1173
  {
    REQUEST { 4,149 }
    REPLY   { response_code, device_status, sprung_sw_73 }
  }
  TRANSACTION 1174
  {
    REQUEST { 4,150 }
    REPLY   { response_code, device_status, sprung_sw_74 }
  }
  TRANSACTION 1175
  {
    REQUEST { 4,151 }
    REPLY   { response_code, device_status, sprung_sw_75 }
  }
  TRANSACTION 1176
  {
    REQUEST { 4,152 }
    REPLY   { response_code, device_status, sprung_sw_76 }
  }
  TRANSACTION 1177
  {
    REQUEST { 4,153 }
    REPLY   { response_code, device_status, sprung_sw_77 }
  }
  TRANSACTION 1178
  {
    REQUEST { 4,154 }
    REPLY   { response_code, device_status, sprung_sw_78 }
  }
  TRANSACTION 1179
  {
    REQUEST { 4,155 }
    REPLY   { response_code, device_status, sprung_sw_79 }
  }
  TRANSACTION 1180
  {
    REQUEST { 4,156 }
    REPLY   { response_code, device_status, sprung_sw_80 }
  }
  TRANSACTION 1181
  {
    REQUEST { 4,157 }
    REPLY   { response_code, device_status, sprung_sw_81 }
  }
  TRANSACTION 1182
  {
    REQUEST { 4,158 }
    REPLY   { response_code, device_status, sprung_sw_82 }
  }
  TRANSACTION 1183
  {
    REQUEST { 4,159 }
    REPLY   { response_code, device_status, sprung_sw_83 }
  }
  TRANSACTION 1184
  {
    REQUEST { 4,160 }
    REPLY   { response_code, device_status, sprung_sw_84 }
  }
  TRANSACTION 1185
  {
    REQUEST { 4,161 }
    REPLY   { response_code, device_status, sprung_sw_85 }
  }
  TRANSACTION 1186
  {
    REQUEST { 4,162 }
    REPLY   { response_code, device_status, sprung_sw_86 }
  }
  TRANSACTION 1187
  {
    REQUEST { 4,163 }
    REPLY   { response_code, device_status, sprung_sw_87 }
  }
  TRANSACTION 1188
  {
    REQUEST { 4,164 }
    REPLY   { response_code, device_status, sprung_sw_88 }
  }
  TRANSACTION 1189
  {
    REQUEST { 4,165 }
    REPLY   { response_code, device_status, sprung_sw_89 }
  }
  TRANSACTION 1190
  {
    REQUEST { 4,166 }
    REPLY   { response_code, device_status, sprung_sw_90 }
  }
  TRANSACTION 1191
  {
    REQUEST { 4,167 }
    REPLY   { response_code, device_status, sprung_sw_91 }
  }
  TRANSACTION 1192
  {
    REQUEST { 4,168 }
    REPLY   { response_code, device_status, sprung_sw_92 }
  }
  TRANSACTION 1193
  {
    REQUEST { 4,169 }
    REPLY   { response_code, device_status, sprung_sw_93 }
  }
  TRANSACTION 1194
  {
    REQUEST { 4,170 }
    REPLY   { response_code, device_status, sprung_sw_94 }
  }
  TRANSACTION 1195
  {
    REQUEST { 4,171 }
    REPLY   { response_code, device_status, sprung_sw_95 }
  }
  TRANSACTION 1196
  {
    REQUEST { 4,172 }
    REPLY   { response_code, device_status, sprung_sw_96 }
  }
  TRANSACTION 1197
  {
    REQUEST { 4,173 }
    REPLY   { response_code, device_status, sprung_sw_97 }
  }
  TRANSACTION 1198
  {
    REQUEST { 4,174 }
    REPLY   { response_code, device_status, sprung_sw_98 }
  }
  TRANSACTION 1199
  {
    REQUEST { 4,175 }
    REPLY   { response_code, device_status, sprung_sw_99 }
  }
*/


/* Anfang PST */
   TRANSACTION 1542
   {
     REQUEST { 6, 0x06 }
     REPLY   { response_code, device_status, overshoot_rising_1 }
   }

   TRANSACTION 1543
   {
     REQUEST { 6, 0x07 }
     REPLY   { response_code, device_status, overshoot_falling_1 }
   }

   TRANSACTION 1548
   {
     REQUEST { 6, 0x0C }
     REPLY   { response_code, device_status, overshoot_rising_2 }
   }

   TRANSACTION 1549
   {
     REQUEST { 6, 0x0D }
     REPLY   { response_code, device_status, overshoot_falling_2 }
   }

   TRANSACTION 1563
   {
     REQUEST { 6, 0x1B }
     REPLY   { response_code, device_status, pst_y_control_value }
   }

   TRANSACTION 1564
   {
     REQUEST { 6, 0x1C }
     REPLY   { response_code, device_status, pst_x_control_value }
   }

   TRANSACTION 1566
   {
     REQUEST { 6, 0x1E }
     REPLY   { response_code, device_status, pst_min_value_y_control }
   }
/* Ende PST */


  RESPONSE_CODES
  {
    0, SUCCESS,             [no_command_specific_errors];
    3, DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	4, DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 160     Write Diagnose - unsigned Integer                        */
/* ------------------------------------------------------------------------ */
COMMAND write_diagnosis_uinteger
{
  NUMBER 160;
  OPERATION WRITE;

  TRANSACTION 187
  {
    REQUEST { 0, 0xBB, latency_after_step }
    REPLY   { response_code, device_status, latency_after_step }
  }

  TRANSACTION 188
  {
    REQUEST { 0, 0xBC, step_sample_rate }
    REPLY   { response_code, device_status, step_sample_rate }
  }

  TRANSACTION 196
  {
    REQUEST { 0, 0xC4, sample_rate_st_hist }
    REPLY   { response_code, device_status, sample_rate_st_hist }
  }

  TRANSACTION 198
  {
    REQUEST { 0, 0xC6, sample_rate_st_hist_e }
    REPLY   { response_code, device_status, sample_rate_st_hist_e }
  }

/* Anfang PST */
  TRANSACTION 191
  {
    REQUEST { 0, 0xBF, pst_max_test_duration }
    REPLY   { response_code, device_status, pst_max_test_duration }
  }

  TRANSACTION 193
  {
    REQUEST { 0, 0xC1, pst_ramp_time_rising }
    REPLY   { response_code, device_status, pst_ramp_time_rising }
  }

  TRANSACTION 194
  {
    REQUEST { 0, 0xC2, pst_ramp_time_falling }
    REPLY   { response_code, device_status, pst_ramp_time_falling }
  }

  TRANSACTION 245
  {
    REQUEST { 0, 0xF5, pst_settling_time_before_start }
    REPLY   { response_code, device_status, pst_settling_time_before_start }
  }
/* Ende PST */


  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
         7, MODE_ERROR,         [in_write_protect_mode];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 161     Read Diagnose - unsigned Integer                         */
/* ------------------------------------------------------------------------ */
COMMAND read_diagnosis_uinteger
{
  NUMBER 161;
  OPERATION READ;

/* mit cmd 157 erledigt

  TRANSACTION 0
  {
    REQUEST { 0x00, 0x00 }
    REPLY   { response_code, device_status, messages_1 }
  }

  TRANSACTION 1
  {
    REQUEST { 0x00, 0x01 }
    REPLY   { response_code, device_status, messages_2 }
  }

  TRANSACTION 2
  {
    REQUEST { 0x00, 0x02 }
    REPLY   { response_code, device_status, messages_3 }
  }

  TRANSACTION 3
  {
    REQUEST { 0x00, 0x03 }
    REPLY   { response_code, device_status, messages_4 }
  }

  TRANSACTION 4
  {
    REQUEST { 0x00, 0x04 }
    REPLY   { response_code, device_status, messages_5 }
  }

  TRANSACTION 5
  {
    REQUEST { 0x00, 0x05 }
    REPLY   { response_code, device_status, messages_6 }
  }

  TRANSACTION 6
  {
    REQUEST { 0x00, 0x06  }
    REPLY   { response_code, device_status, messages_7 }
  }

  TRANSACTION 7
  {
    REQUEST { 0x00, 0x07 }
    REPLY   { response_code, device_status, messages_8 }
  }

  TRANSACTION 8
  {
    REQUEST { 0x00, 0x08 }
    REPLY   { response_code, device_status, messages_9 }
  }

  TRANSACTION 9
  {
    REQUEST { 0x00, 0x09 }
    REPLY   { response_code, device_status, messages_10 }
  }

  TRANSACTION 10
  {
    REQUEST { 0x00, 0x0A }
    REPLY   { response_code, device_status, messages_11 }
  }

  TRANSACTION 11
  {
    REQUEST { 0x00, 0x0B }
    REPLY   { response_code, device_status, messages_12 }
  }

  TRANSACTION 12
  {
    REQUEST { 0x00, 0x0C }
    REPLY   { response_code, device_status, messages_13 }
  }

  TRANSACTION 13
  {
    REQUEST { 0x00, 0x0D }
    REPLY   { response_code, device_status, messages_14 }
  }

  TRANSACTION 14
  {
    REQUEST { 0x00, 0x0E }
    REPLY   { response_code, device_status, messages_15 }
  }

  TRANSACTION 15
  {
    REQUEST { 0x00, 0x0F }
    REPLY   { response_code, device_status, messages_16 }
  }

  TRANSACTION 16
  {
    REQUEST { 0x00, 0x10 }
    REPLY   { response_code, device_status, messages_17 }
  }

  TRANSACTION 17
  {
    REQUEST { 0x00, 0x11 }
    REPLY   { response_code, device_status, messages_18 }
  }

  TRANSACTION 18
  {
    REQUEST { 0x00, 0x12 }
    REPLY   { response_code, device_status, messages_19 }
  }

  TRANSACTION 19
  {
    REQUEST { 0x00, 0x13 }
    REPLY   { response_code, device_status, messages_20 }
  }

  TRANSACTION 20
  {
    REQUEST { 0x00, 0x14 }
    REPLY   { response_code, device_status, messages_21 }
  }

  TRANSACTION 21
  {
    REQUEST { 0x00, 0x15 }
    REPLY   { response_code, device_status, messages_22 }
  }

  TRANSACTION 22
  {
    REQUEST { 0x00, 0x16 }
    REPLY   { response_code, device_status, messages_23 }
  }

  TRANSACTION 23
  {
    REQUEST { 0x00, 0x17 }
    REPLY   { response_code, device_status, messages_24 }
  }

  TRANSACTION 24
  {
    REQUEST { 0x00, 0x18 }
    REPLY   { response_code, device_status, messages_25 }
  }

  TRANSACTION 25
  {
    REQUEST { 0x00, 0x19 }
    REPLY   { response_code, device_status, messages_26 }
  }

  TRANSACTION 26
  {
    REQUEST { 0x00, 0x1A }
    REPLY   { response_code, device_status, messages_27 }
  }

  TRANSACTION 27
  {
    REQUEST { 0x00, 0x1B }
    REPLY   { response_code, device_status, messages_28 }
  }

  TRANSACTION 28
  {
    REQUEST { 0x00, 0x1C }
    REPLY   { response_code, device_status, messages_29 }
  }

  TRANSACTION 29
  {
    REQUEST { 0x00, 0x1D }
    REPLY   { response_code, device_status, messages_30 }
  }
*/

  TRANSACTION 50
  {
    REQUEST { 0x00, 0x32 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_1 }
  }
  TRANSACTION 51
  {
    REQUEST { 0x00, 0x33 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_2 }
  }
  TRANSACTION 52
  {
    REQUEST { 0x00, 0x34 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_3 }
  }
  TRANSACTION 53
  {
    REQUEST { 0x00, 0x35 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_4 }
  }
  TRANSACTION 54
  {
    REQUEST { 0x00, 0x36 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_5 }
  }
  TRANSACTION 55
  {
    REQUEST { 0x00, 0x37 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_6 }
  }
  TRANSACTION 56
  {
    REQUEST { 0x00, 0x38 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_7 }
  }
  TRANSACTION 57
  {
    REQUEST { 0x00, 0x39 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_8 }
  }
  TRANSACTION 58
  {
    REQUEST { 0x00, 0x3A }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_9 }
  }
  TRANSACTION 59
  {
    REQUEST { 0x00, 0x3B }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_10 }
  }
  TRANSACTION 60
  {
    REQUEST { 0x00, 0x3C }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_11 }
  }
  TRANSACTION 61
  {
    REQUEST { 0x00, 0x3D }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_12 }
  }
  TRANSACTION 62
  {
    REQUEST { 0x00, 0x3E }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_13 }
  }
  TRANSACTION 63
  {
    REQUEST { 0x00, 0x3F }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_14 }
  }
  TRANSACTION 64
  {
    REQUEST { 0x00, 0x40 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_15 }
  }
  TRANSACTION 65
  {
    REQUEST { 0x00, 0x41 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_16 }
  }
  TRANSACTION 66
  {
    REQUEST { 0x00, 0x42 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_17 }
  }
  TRANSACTION 67
  {
    REQUEST { 0x00, 0x43 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_18 }
  }
  TRANSACTION 68
  {
    REQUEST { 0x00, 0x44 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_19 }
  }
  TRANSACTION 69
  {
    REQUEST { 0x00, 0x45 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_20 }
  }
  TRANSACTION 70
  {
    REQUEST { 0x00, 0x46 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_21 }
  }
  TRANSACTION 71
  {
    REQUEST { 0x00, 0x47 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_22 }
  }
  TRANSACTION 72
  {
    REQUEST { 0x00, 0x48 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_23 }
  }
  TRANSACTION 73
  {
    REQUEST { 0x00, 0x49 }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_24 }
  }
  TRANSACTION 74
  {
    REQUEST { 0x00, 0x4A }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_25 }
  }
  TRANSACTION 75
  {
    REQUEST { 0x00, 0x4B }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_26 }
  }
  TRANSACTION 76
  {
    REQUEST { 0x00, 0x4C }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_27 }
  }
  TRANSACTION 77
  {
    REQUEST { 0x00, 0x4D }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_28 }
  }
  TRANSACTION 78
  {
    REQUEST { 0x00, 0x4E }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_29 }
  }
  TRANSACTION 79
  {
    REQUEST { 0x00, 0x4F }
    REPLY   { response_code, device_status, lower_end_pos_drive_signal_30 }
  }


  TRANSACTION 111
  {
    REQUEST { 0x00, 0x6F }
    REPLY   { response_code, device_status, trend_travel_end_pos_drive_signal_ref }
  }

/* mit cmd 157 erledigt

  TRANSACTION 112
  {
    REQUEST { 0x00, 0x70 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_1 }
  }
  TRANSACTION 113
  {
    REQUEST { 0x00, 0x71 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_2 }
  }
  TRANSACTION 114
  {
    REQUEST { 0x00, 0x72 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_3 }
  }
  TRANSACTION 115
  {
    REQUEST { 0x00, 0x73 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_4 }
  }
  TRANSACTION 116
  {
    REQUEST { 0x00, 0x74 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_5 }
  }
  TRANSACTION 117
  {
    REQUEST { 0x00, 0x75 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_6 }
  }
  TRANSACTION 118
  {
    REQUEST { 0x00, 0x76 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_7 }
  }
  TRANSACTION 119
  {
    REQUEST { 0x00, 0x77 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_8 }
  }
  TRANSACTION 120
  {
    REQUEST { 0x00, 0x78 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_9 }
  }
  TRANSACTION 121
  {
    REQUEST { 0x00, 0x79 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_10 }
  }
  TRANSACTION 122
  {
    REQUEST { 0x00, 0x7A }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_11 }
  }
  TRANSACTION 123
  {
    REQUEST { 0x00, 0x7B }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_12 }
  }
  TRANSACTION 124
  {
    REQUEST { 0x00, 0x7C }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_13 }
  }
  TRANSACTION 125
  {
    REQUEST { 0x00, 0x7D }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_14 }
  }
  TRANSACTION 126
  {
    REQUEST { 0x00, 0x7E }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_15 }
  }
  TRANSACTION 127
  {
    REQUEST { 0x00, 0x7F }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_16 }
  }
  TRANSACTION 128
  {
    REQUEST { 0x00, 0x80 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_17 }
  }
  TRANSACTION 129
  {
    REQUEST { 0x00, 0x81 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_18 }
  }
  TRANSACTION 130
  {
    REQUEST { 0x00, 0x82 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_19 }
  }
  TRANSACTION 131
  {
    REQUEST { 0x00, 0x83 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_20 }
  }
  TRANSACTION 132
  {
    REQUEST { 0x00, 0x84 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_21 }
  }
  TRANSACTION 133
  {
    REQUEST { 0x00, 0x85 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_22 }
  }
  TRANSACTION 134
  {
    REQUEST { 0x00, 0x86 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_23 }
  }
  TRANSACTION 135
  {
    REQUEST { 0x00, 0x87 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_24 }
  }
  TRANSACTION 136
  {
    REQUEST { 0x00, 0x88 }
    REPLY   { response_code, device_status, hand_y_stat_referenzwerte_25 }
  }


  TRANSACTION 137
  {
    REQUEST { 0x00, 0x89 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_1 }
  }
  TRANSACTION 138
  {
    REQUEST { 0x00, 0x8A }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_2 }
  }
  TRANSACTION 139
  {
    REQUEST { 0x00, 0x8B }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_3 }
  }
  TRANSACTION 140
  {
    REQUEST { 0x00, 0x8C }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_4 }
  }
  TRANSACTION 141
  {
    REQUEST { 0x00, 0x8D }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_5 }
  }
  TRANSACTION 142
  {
    REQUEST { 0x00, 0x8E }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_6 }
  }
  TRANSACTION 143
  {
    REQUEST { 0x00, 0x8F }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_7 }
  }
  TRANSACTION 144
  {
    REQUEST { 0x00, 0x90 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_8 }
  }
  TRANSACTION 145
  {
    REQUEST { 0x00, 0x91 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_9 }
  }
  TRANSACTION 146
  {
    REQUEST { 0x00, 0x92 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_10 }
  }
  TRANSACTION 147
  {
    REQUEST { 0x00, 0x93 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_11 }
  }
  TRANSACTION 148
  {
    REQUEST { 0x00, 0x94 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_12 }
  }
  TRANSACTION 149
  {
    REQUEST { 0x00, 0x95 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_13 }
  }
  TRANSACTION 150
  {
    REQUEST { 0x00, 0x96 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_14 }
  }
  TRANSACTION 151
  {
    REQUEST { 0x00, 0x97 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_15 }
  }
  TRANSACTION 152
  {
    REQUEST { 0x00, 0x98 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_16 }
  }
  TRANSACTION 153
  {
    REQUEST { 0x00, 0x99 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_17 }
  }
  TRANSACTION 154
  {
    REQUEST { 0x00, 0x9A }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_18 }
  }
  TRANSACTION 155
  {
    REQUEST { 0x00, 0x9B }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_19 }
  }
  TRANSACTION 156
  {
    REQUEST { 0x00, 0x9C }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_20 }
  }
  TRANSACTION 157
  {
    REQUEST { 0x00, 0x9D }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_21 }
  }
  TRANSACTION 158
  {
    REQUEST { 0x00, 0x9E }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_22 }
  }
  TRANSACTION 159
  {
    REQUEST { 0x00, 0x9F }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_23 }
  }
  TRANSACTION 160
  {
    REQUEST { 0x00, 0xA0 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_24 }
  }
  TRANSACTION 161
  {
    REQUEST { 0x00, 0xA1 }
    REPLY   { response_code, device_status, hand_y_stat_wiederholungswerte_25 }
  }

  TRANSACTION 162
  {
    REQUEST { 0x00, 0xA2 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_1 }
  }
  TRANSACTION 163
  {
    REQUEST { 0x00, 0xA3 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_2 }
  }
  TRANSACTION 164
  {
    REQUEST { 0x00, 0xA4 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_3 }
  }
  TRANSACTION 165
  {
    REQUEST { 0x00, 0xA5 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_4 }
  }
  TRANSACTION 166
  {
    REQUEST { 0x00, 0xA6 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_5 }
  }
  TRANSACTION 167
  {
    REQUEST { 0x00, 0xA7 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_6 }
  }
  TRANSACTION 168
  {
    REQUEST { 0x00, 0xA8 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_7 }
  }
  TRANSACTION 169
  {
    REQUEST { 0x00, 0xA9 }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_8 }
  }
  TRANSACTION 170
  {
    REQUEST { 0x00, 0xAA }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_9 }
  }
  TRANSACTION 171
  {
    REQUEST { 0x00, 0xAB }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_10 }
  }
  TRANSACTION 172
  {
    REQUEST { 0x00, 0xAC }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_11 }
  }
  TRANSACTION 173
  {
    REQUEST { 0x00, 0xAD }
    REPLY   { response_code, device_status, hand_y_hys_referenzwerte_12 }
  }


  TRANSACTION 174
  {
    REQUEST { 0x00, 0xAE }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_1 }
  }
  TRANSACTION 175
  {
    REQUEST { 0x00, 0xAF }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_2 }
  }
  TRANSACTION 176
  {
    REQUEST { 0x00, 0xB0 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_3 }
  }
  TRANSACTION 177
  {
    REQUEST { 0x00, 0xB1 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_4 }
  }
  TRANSACTION 178
  {
    REQUEST { 0x00, 0xB2 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_5 }
  }
  TRANSACTION 179
  {
    REQUEST { 0x00, 0xB3 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_6 }
  }
  TRANSACTION 180
  {
    REQUEST { 0x00, 0xB4 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_7 }
  }
  TRANSACTION 181
  {
    REQUEST { 0x00, 0xB5 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_8 }
  }
  TRANSACTION 182
  {
    REQUEST { 0x00, 0xB6 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_9 }
  }
  TRANSACTION 183
  {
    REQUEST { 0x00, 0xB7 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_10 }
  }
  TRANSACTION 184
  {
    REQUEST { 0x00, 0xB8 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_11 }
  }
  TRANSACTION 185
  {
    REQUEST { 0x00, 0xB9 }
    REPLY   { response_code, device_status, hand_y_hys_wiederholungswerte_12 }
  }
*/

  TRANSACTION 187
  {
    REQUEST { 0x00, 0xBB }
    REPLY   { response_code, device_status, latency_after_step }
  }

  TRANSACTION 188
  {
    REQUEST { 0x00, 0xBC }
    REPLY   { response_code, device_status, step_sample_rate }
  }

  TRANSACTION 189
  {
    REQUEST { 0x00, 0xBD }
    REPLY   { response_code, device_status, duration_of_test }
  }


/* Anfang PST */
  TRANSACTION 191
  {
    REQUEST { 0x00, 0xBF }
    REPLY   { response_code, device_status, pst_max_test_duration }
  }

  TRANSACTION 193
  {
    REQUEST { 0x00, 0xC1 }
    REPLY   { response_code, device_status, pst_ramp_time_rising }
  }

  TRANSACTION 194
  {
    REQUEST { 0x00, 0xC2 }
    REPLY   { response_code, device_status, pst_ramp_time_falling }
  }

  TRANSACTION 216
  {
    REQUEST { 0x00, 0xD8 }
    REPLY   { response_code, device_status, pst_number_of_tests }
  }

  TRANSACTION 217
  {
    REQUEST { 0x00, 0xD9 }
    REPLY   { response_code, device_status, pst_test_status_0 }
  }

  TRANSACTION 218
  {
    REQUEST { 0x00, 0xDA }
    REPLY   { response_code, device_status, pst_test_status_1 }
  }

  TRANSACTION 219
  {
    REQUEST { 0x00, 0xDB }
    REPLY   { response_code, device_status, pst_test_status_2 }
  }

  TRANSACTION 245
  {
    REQUEST { 0x00, 0xF5 }
    REPLY   { response_code, device_status, pst_settling_time_before_start }
  }
/* Ende PST */


  TRANSACTION 196
  {
    REQUEST { 0, 0xC4 }
    REPLY   { response_code, device_status, sample_rate_st_hist }
  }

  TRANSACTION 198
  {
    REQUEST { 0, 0xC6 }
    REPLY   { response_code, device_status, sample_rate_st_hist_e }
  }

/*
  TRANSACTION 300
  {
    REQUEST { 1,44 }
    REPLY   { response_code, device_status, sprung_ss_0 }
  }
  TRANSACTION 301
  {
    REQUEST { 1,45 }
    REPLY   { response_code, device_status, sprung_ss_1 }
  }
  TRANSACTION 302
  {
    REQUEST { 1,46 }
    REPLY   { response_code, device_status, sprung_ss_2 }
  }
  TRANSACTION 303
  {
    REQUEST { 1,47 }
    REPLY   { response_code, device_status, sprung_ss_3 }
  }
  TRANSACTION 304
  {
    REQUEST { 1,48 }
    REPLY   { response_code, device_status, sprung_ss_4 }
  }
  TRANSACTION 305
  {
    REQUEST { 1,49 }
    REPLY   { response_code, device_status, sprung_ss_5 }
  }
  TRANSACTION 306
  {
    REQUEST { 1,50 }
    REPLY   { response_code, device_status, sprung_ss_6 }
  }
  TRANSACTION 307
  {
    REQUEST { 1,51 }
    REPLY   { response_code, device_status, sprung_ss_7 }
  }
  TRANSACTION 308
  {
    REQUEST { 1,52 }
    REPLY   { response_code, device_status, sprung_ss_8 }
  }
  TRANSACTION 309
  {
    REQUEST { 1,53 }
    REPLY   { response_code, device_status, sprung_ss_9 }
  }
  TRANSACTION 310
  {
    REQUEST { 1,54 }
    REPLY   { response_code, device_status, sprung_ss_10 }
  }
  TRANSACTION 311
  {
    REQUEST { 1,55 }
    REPLY   { response_code, device_status, sprung_ss_11 }
  }
  TRANSACTION 312
  {
    REQUEST { 1,56 }
    REPLY   { response_code, device_status, sprung_ss_12 }
  }
  TRANSACTION 313
  {
    REQUEST { 1,57 }
    REPLY   { response_code, device_status, sprung_ss_13 }
  }
  TRANSACTION 314
  {
    REQUEST { 1,58 }
    REPLY   { response_code, device_status, sprung_ss_14 }
  }
  TRANSACTION 315
  {
    REQUEST { 1,59 }
    REPLY   { response_code, device_status, sprung_ss_15 }
  }
  TRANSACTION 316
  {
    REQUEST { 1,60 }
    REPLY   { response_code, device_status, sprung_ss_16 }
  }
  TRANSACTION 317
  {
    REQUEST { 1,61 }
    REPLY   { response_code, device_status, sprung_ss_17 }
  }
  TRANSACTION 318
  {
    REQUEST { 1,62 }
    REPLY   { response_code, device_status, sprung_ss_18 }
  }
  TRANSACTION 319
  {
    REQUEST { 1,63 }
    REPLY   { response_code, device_status, sprung_ss_19 }
  }
  TRANSACTION 320
  {
    REQUEST { 1,64 }
    REPLY   { response_code, device_status, sprung_ss_20 }
  }
  TRANSACTION 321
  {
    REQUEST { 1,65 }
    REPLY   { response_code, device_status, sprung_ss_21 }
  }
  TRANSACTION 322
  {
    REQUEST { 1,66 }
    REPLY   { response_code, device_status, sprung_ss_22 }
  }
  TRANSACTION 323
  {
    REQUEST { 1,67 }
    REPLY   { response_code, device_status, sprung_ss_23 }
  }
  TRANSACTION 324
  {
    REQUEST { 1,68 }
    REPLY   { response_code, device_status, sprung_ss_24 }
  }
  TRANSACTION 325
  {
    REQUEST { 1,69 }
    REPLY   { response_code, device_status, sprung_ss_25 }
  }
  TRANSACTION 326
  {
    REQUEST { 1,70 }
    REPLY   { response_code, device_status, sprung_ss_26 }
  }
  TRANSACTION 327
  {
    REQUEST { 1,71 }
    REPLY   { response_code, device_status, sprung_ss_27 }
  }
  TRANSACTION 328
  {
    REQUEST { 1,72 }
    REPLY   { response_code, device_status, sprung_ss_28 }
  }
  TRANSACTION 329
  {
    REQUEST { 1,73 }
    REPLY   { response_code, device_status, sprung_ss_29 }
  }
  TRANSACTION 330
  {
    REQUEST { 1,74 }
    REPLY   { response_code, device_status, sprung_ss_30 }
  }
  TRANSACTION 331
  {
    REQUEST { 1,75 }
    REPLY   { response_code, device_status, sprung_ss_31 }
  }
  TRANSACTION 332
  {
    REQUEST { 1,76 }
    REPLY   { response_code, device_status, sprung_ss_32 }
  }
  TRANSACTION 333
  {
    REQUEST { 1,77 }
    REPLY   { response_code, device_status, sprung_ss_33 }
  }
  TRANSACTION 334
  {
    REQUEST { 1,78 }
    REPLY   { response_code, device_status, sprung_ss_34 }
  }
  TRANSACTION 335
  {
    REQUEST { 1,79 }
    REPLY   { response_code, device_status, sprung_ss_35 }
  }
  TRANSACTION 336
  {
    REQUEST { 1,80 }
    REPLY   { response_code, device_status, sprung_ss_36 }
  }
  TRANSACTION 337
  {
    REQUEST { 1,81 }
    REPLY   { response_code, device_status, sprung_ss_37 }
  }
  TRANSACTION 338
  {
    REQUEST { 1,82 }
    REPLY   { response_code, device_status, sprung_ss_38 }
  }
  TRANSACTION 339
  {
    REQUEST { 1,83 }
    REPLY   { response_code, device_status, sprung_ss_39 }
  }
  TRANSACTION 340
  {
    REQUEST { 1,84 }
    REPLY   { response_code, device_status, sprung_ss_40 }
  }
  TRANSACTION 341
  {
    REQUEST { 1,85 }
    REPLY   { response_code, device_status, sprung_ss_41 }
  }
  TRANSACTION 342
  {
    REQUEST { 1,86 }
    REPLY   { response_code, device_status, sprung_ss_42 }
  }
  TRANSACTION 343
  {
    REQUEST { 1,87 }
    REPLY   { response_code, device_status, sprung_ss_43 }
  }
  TRANSACTION 344
  {
    REQUEST { 1,88 }
    REPLY   { response_code, device_status, sprung_ss_44 }
  }
  TRANSACTION 345
  {
    REQUEST { 1,89 }
    REPLY   { response_code, device_status, sprung_ss_45 }
  }
  TRANSACTION 346
  {
    REQUEST { 1,90 }
    REPLY   { response_code, device_status, sprung_ss_46 }
  }
  TRANSACTION 347
  {
    REQUEST { 1,91 }
    REPLY   { response_code, device_status, sprung_ss_47 }
  }
  TRANSACTION 348
  {
    REQUEST { 1,92 }
    REPLY   { response_code, device_status, sprung_ss_48 }
  }
  TRANSACTION 349
  {
    REQUEST { 1,93 }
    REPLY   { response_code, device_status, sprung_ss_49 }
  }
  TRANSACTION 350
  {
    REQUEST { 1,94 }
    REPLY   { response_code, device_status, sprung_ss_50 }
  }
  TRANSACTION 351
  {
    REQUEST { 1,95 }
    REPLY   { response_code, device_status, sprung_ss_51 }
  }
  TRANSACTION 352
  {
    REQUEST { 1,96 }
    REPLY   { response_code, device_status, sprung_ss_52 }
  }
  TRANSACTION 353
  {
    REQUEST { 1,97 }
    REPLY   { response_code, device_status, sprung_ss_53 }
  }
  TRANSACTION 354
  {
    REQUEST { 1,98 }
    REPLY   { response_code, device_status, sprung_ss_54 }
  }
  TRANSACTION 355
  {
    REQUEST { 1,99 }
    REPLY   { response_code, device_status, sprung_ss_55 }
  }
  TRANSACTION 356
  {
    REQUEST { 1,100 }
    REPLY   { response_code, device_status, sprung_ss_56 }
  }
  TRANSACTION 357
  {
    REQUEST { 1,101 }
    REPLY   { response_code, device_status, sprung_ss_57 }
  }
  TRANSACTION 358
  {
    REQUEST { 1,102 }
    REPLY   { response_code, device_status, sprung_ss_58 }
  }
  TRANSACTION 359
  {
    REQUEST { 1,103 }
    REPLY   { response_code, device_status, sprung_ss_59 }
  }
  TRANSACTION 360
  {
    REQUEST { 1,104 }
    REPLY   { response_code, device_status, sprung_ss_60 }
  }
  TRANSACTION 361
  {
    REQUEST { 1,105 }
    REPLY   { response_code, device_status, sprung_ss_61 }
  }
  TRANSACTION 362
  {
    REQUEST { 1,106 }
    REPLY   { response_code, device_status, sprung_ss_62 }
  }
  TRANSACTION 363
  {
    REQUEST { 1,107 }
    REPLY   { response_code, device_status, sprung_ss_63 }
  }
  TRANSACTION 364
  {
    REQUEST { 1,108 }
    REPLY   { response_code, device_status, sprung_ss_64 }
  }
  TRANSACTION 365
  {
    REQUEST { 1,109 }
    REPLY   { response_code, device_status, sprung_ss_65 }
  }
  TRANSACTION 366
  {
    REQUEST { 1,110 }
    REPLY   { response_code, device_status, sprung_ss_66 }
  }
  TRANSACTION 367
  {
    REQUEST { 1,111 }
    REPLY   { response_code, device_status, sprung_ss_67 }
  }
  TRANSACTION 368
  {
    REQUEST { 1,112 }
    REPLY   { response_code, device_status, sprung_ss_68 }
  }
  TRANSACTION 369
  {
    REQUEST { 1,113 }
    REPLY   { response_code, device_status, sprung_ss_69 }
  }
  TRANSACTION 370
  {
    REQUEST { 1,114 }
    REPLY   { response_code, device_status, sprung_ss_70 }
  }
  TRANSACTION 371
  {
    REQUEST { 1,115 }
    REPLY   { response_code, device_status, sprung_ss_71 }
  }
  TRANSACTION 372
  {
    REQUEST { 1,116 }
    REPLY   { response_code, device_status, sprung_ss_72 }
  }
  TRANSACTION 373
  {
    REQUEST { 1,117 }
    REPLY   { response_code, device_status, sprung_ss_73 }
  }
  TRANSACTION 374
  {
    REQUEST { 1,118 }
    REPLY   { response_code, device_status, sprung_ss_74 }
  }
  TRANSACTION 375
  {
    REQUEST { 1,119 }
    REPLY   { response_code, device_status, sprung_ss_75 }
  }
  TRANSACTION 376
  {
    REQUEST { 1,120 }
    REPLY   { response_code, device_status, sprung_ss_76 }
  }
  TRANSACTION 377
  {
    REQUEST { 1,121 }
    REPLY   { response_code, device_status, sprung_ss_77 }
  }
  TRANSACTION 378
  {
    REQUEST { 1,122 }
    REPLY   { response_code, device_status, sprung_ss_78 }
  }
  TRANSACTION 379
  {
    REQUEST { 1,123 }
    REPLY   { response_code, device_status, sprung_ss_79 }
  }
  TRANSACTION 380
  {
    REQUEST { 1,124 }
    REPLY   { response_code, device_status, sprung_ss_80 }
  }
  TRANSACTION 381
  {
    REQUEST { 1,125 }
    REPLY   { response_code, device_status, sprung_ss_81 }
  }
  TRANSACTION 382
  {
    REQUEST { 1,126 }
    REPLY   { response_code, device_status, sprung_ss_82 }
  }
  TRANSACTION 383
  {
    REQUEST { 1,127 }
    REPLY   { response_code, device_status, sprung_ss_83 }
  }
  TRANSACTION 384
  {
    REQUEST { 1,128 }
    REPLY   { response_code, device_status, sprung_ss_84 }
  }
  TRANSACTION 385
  {
    REQUEST { 1,129 }
    REPLY   { response_code, device_status, sprung_ss_85 }
  }
  TRANSACTION 386
  {
    REQUEST { 1,130 }
    REPLY   { response_code, device_status, sprung_ss_86 }
  }
  TRANSACTION 387
  {
    REQUEST { 1,131 }
    REPLY   { response_code, device_status, sprung_ss_87 }
  }
  TRANSACTION 388
  {
    REQUEST { 1,132 }
    REPLY   { response_code, device_status, sprung_ss_88 }
  }
  TRANSACTION 389
  {
    REQUEST { 1,133 }
    REPLY   { response_code, device_status, sprung_ss_89 }
  }
  TRANSACTION 390
  {
    REQUEST { 1,134 }
    REPLY   { response_code, device_status, sprung_ss_90 }
  }
  TRANSACTION 391
  {
    REQUEST { 1,135 }
    REPLY   { response_code, device_status, sprung_ss_91 }
  }
  TRANSACTION 392
  {
    REQUEST { 1,136 }
    REPLY   { response_code, device_status, sprung_ss_92 }
  }
  TRANSACTION 393
  {
    REQUEST { 1,137 }
    REPLY   { response_code, device_status, sprung_ss_93 }
  }
  TRANSACTION 394
  {
    REQUEST { 1,138 }
    REPLY   { response_code, device_status, sprung_ss_94 }
  }
  TRANSACTION 395
  {
    REQUEST { 1,139 }
    REPLY   { response_code, device_status, sprung_ss_95 }
  }
  TRANSACTION 396
  {
    REQUEST { 1,140 }
    REPLY   { response_code, device_status, sprung_ss_96 }
  }
  TRANSACTION 397
  {
    REQUEST { 1,141 }
    REPLY   { response_code, device_status, sprung_ss_97 }
  }
  TRANSACTION 398
  {
    REQUEST { 1,142 }
    REPLY   { response_code, device_status, sprung_ss_98 }
  }
  TRANSACTION 399
  {
    REQUEST { 1,143 }
    REPLY   { response_code, device_status, sprung_ss_99 }
  }
*/

  TRANSACTION 400
  {
    REQUEST { 1,144 }
    REPLY   { response_code, device_status, datalogger_ss_0 }
  }
  TRANSACTION 401
  {
    REQUEST { 1,145 }
    REPLY   { response_code, device_status, datalogger_ss_1 }
  }
  TRANSACTION 402
  {
    REQUEST { 1,146 }
    REPLY   { response_code, device_status, datalogger_ss_2 }
  }
  TRANSACTION 403
  {
    REQUEST { 1,147 }
    REPLY   { response_code, device_status, datalogger_ss_3 }
  }
  TRANSACTION 404
  {
    REQUEST { 1,148 }
    REPLY   { response_code, device_status, datalogger_ss_4 }
  }
  TRANSACTION 405
  {
    REQUEST { 1,149 }
    REPLY   { response_code, device_status, datalogger_ss_5 }
  }
  TRANSACTION 406
  {
    REQUEST { 1,150 }
    REPLY   { response_code, device_status, datalogger_ss_6 }
  }
  TRANSACTION 407
  {
    REQUEST { 1,151 }
    REPLY   { response_code, device_status, datalogger_ss_7 }
  }
  TRANSACTION 408
  {
    REQUEST { 1,152 }
    REPLY   { response_code, device_status, datalogger_ss_8 }
  }
  TRANSACTION 409
  {
    REQUEST { 1,153 }
    REPLY   { response_code, device_status, datalogger_ss_9 }
  }
  TRANSACTION 410
  {
    REQUEST { 1,154 }
    REPLY   { response_code, device_status, datalogger_ss_10 }
  }
  TRANSACTION 411
  {
    REQUEST { 1,155 }
    REPLY   { response_code, device_status, datalogger_ss_11 }
  }
  TRANSACTION 412
  {
    REQUEST { 1,156 }
    REPLY   { response_code, device_status, datalogger_ss_12 }
  }
  TRANSACTION 413
  {
    REQUEST { 1,157 }
    REPLY   { response_code, device_status, datalogger_ss_13 }
  }
  TRANSACTION 414
  {
    REQUEST { 1,158 }
    REPLY   { response_code, device_status, datalogger_ss_14 }
  }
  TRANSACTION 415
  {
    REQUEST { 1,159 }
    REPLY   { response_code, device_status, datalogger_ss_15 }
  }
  TRANSACTION 416
  {
    REQUEST { 1,160 }
    REPLY   { response_code, device_status, datalogger_ss_16 }
  }
  TRANSACTION 417
  {
    REQUEST { 1,161 }
    REPLY   { response_code, device_status, datalogger_ss_17 }
  }
  TRANSACTION 418
  {
    REQUEST { 1,162 }
    REPLY   { response_code, device_status, datalogger_ss_18 }
  }
  TRANSACTION 419
  {
    REQUEST { 1,163 }
    REPLY   { response_code, device_status, datalogger_ss_19 }
  }
  TRANSACTION 420
  {
    REQUEST { 1,164 }
    REPLY   { response_code, device_status, datalogger_ss_20 }
  }
  TRANSACTION 421
  {
    REQUEST { 1,165 }
    REPLY   { response_code, device_status, datalogger_ss_21 }
  }
  TRANSACTION 422
  {
    REQUEST { 1,166 }
    REPLY   { response_code, device_status, datalogger_ss_22 }
  }
  TRANSACTION 423
  {
    REQUEST { 1,167 }
    REPLY   { response_code, device_status, datalogger_ss_23 }
  }
  TRANSACTION 424
  {
    REQUEST { 1,168 }
    REPLY   { response_code, device_status, datalogger_ss_24 }
  }
  TRANSACTION 425
  {
    REQUEST { 1,169 }
    REPLY   { response_code, device_status, datalogger_ss_25 }
  }
  TRANSACTION 426
  {
    REQUEST { 1,170 }
    REPLY   { response_code, device_status, datalogger_ss_26 }
  }
  TRANSACTION 427
  {
    REQUEST { 1,171 }
    REPLY   { response_code, device_status, datalogger_ss_27 }
  }
  TRANSACTION 428
  {
    REQUEST { 1,172 }
    REPLY   { response_code, device_status, datalogger_ss_28 }
  }
  TRANSACTION 429
  {
    REQUEST { 1,173 }
    REPLY   { response_code, device_status, datalogger_ss_29 }
  }
  TRANSACTION 430
  {
    REQUEST { 1,174 }
    REPLY   { response_code, device_status, datalogger_ss_30 }
  }
  TRANSACTION 431
  {
    REQUEST { 1,175 }
    REPLY   { response_code, device_status, datalogger_ss_31 }
  }
  TRANSACTION 432
  {
    REQUEST { 1,176 }
    REPLY   { response_code, device_status, datalogger_ss_32 }
  }
  TRANSACTION 433
  {
    REQUEST { 1,177 }
    REPLY   { response_code, device_status, datalogger_ss_33 }
  }
  TRANSACTION 434
  {
    REQUEST { 1,178 }
    REPLY   { response_code, device_status, datalogger_ss_34 }
  }
  TRANSACTION 435
  {
    REQUEST { 1,179 }
    REPLY   { response_code, device_status, datalogger_ss_35 }
  }
  TRANSACTION 436
  {
    REQUEST { 1,180 }
    REPLY   { response_code, device_status, datalogger_ss_36 }
  }
  TRANSACTION 437
  {
    REQUEST { 1,181 }
    REPLY   { response_code, device_status, datalogger_ss_37 }
  }
  TRANSACTION 438
  {
    REQUEST { 1,182 }
    REPLY   { response_code, device_status, datalogger_ss_38 }
  }
  TRANSACTION 439
  {
    REQUEST { 1,183 }
    REPLY   { response_code, device_status, datalogger_ss_39 }
  }
  TRANSACTION 440
  {
    REQUEST { 1,184 }
    REPLY   { response_code, device_status, datalogger_ss_40 }
  }
  TRANSACTION 441
  {
    REQUEST { 1,185 }
    REPLY   { response_code, device_status, datalogger_ss_41 }
  }
  TRANSACTION 442
  {
    REQUEST { 1,186 }
    REPLY   { response_code, device_status, datalogger_ss_42 }
  }
  TRANSACTION 443
  {
    REQUEST { 1,187 }
    REPLY   { response_code, device_status, datalogger_ss_43 }
  }
  TRANSACTION 444
  {
    REQUEST { 1,188 }
    REPLY   { response_code, device_status, datalogger_ss_44 }
  }
  TRANSACTION 445
  {
    REQUEST { 1,189 }
    REPLY   { response_code, device_status, datalogger_ss_45 }
  }
  TRANSACTION 446
  {
    REQUEST { 1,190 }
    REPLY   { response_code, device_status, datalogger_ss_46 }
  }
  TRANSACTION 447
  {
    REQUEST { 1,191 }
    REPLY   { response_code, device_status, datalogger_ss_47 }
  }
  TRANSACTION 448
  {
    REQUEST { 1,192 }
    REPLY   { response_code, device_status, datalogger_ss_48 }
  }
  TRANSACTION 449
  {
    REQUEST { 1,193 }
    REPLY   { response_code, device_status, datalogger_ss_49 }
  }
  TRANSACTION 450
  {
    REQUEST { 1,194 }
    REPLY   { response_code, device_status, datalogger_ss_50 }
  }
  TRANSACTION 451
  {
    REQUEST { 1,195 }
    REPLY   { response_code, device_status, datalogger_ss_51 }
  }
  TRANSACTION 452
  {
    REQUEST { 1,196 }
    REPLY   { response_code, device_status, datalogger_ss_52 }
  }
  TRANSACTION 453
  {
    REQUEST { 1,197 }
    REPLY   { response_code, device_status, datalogger_ss_53 }
  }
  TRANSACTION 454
  {
    REQUEST { 1,198 }
    REPLY   { response_code, device_status, datalogger_ss_54 }
  }
  TRANSACTION 455
  {
    REQUEST { 1,199 }
    REPLY   { response_code, device_status, datalogger_ss_55 }
  }
  TRANSACTION 456
  {
    REQUEST { 1,200 }
    REPLY   { response_code, device_status, datalogger_ss_56 }
  }
  TRANSACTION 457
  {
    REQUEST { 1,201 }
    REPLY   { response_code, device_status, datalogger_ss_57 }
  }
  TRANSACTION 458
  {
    REQUEST { 1,202 }
    REPLY   { response_code, device_status, datalogger_ss_58 }
  }
  TRANSACTION 459
  {
    REQUEST { 1,203 }
    REPLY   { response_code, device_status, datalogger_ss_59 }
  }
  TRANSACTION 460
  {
    REQUEST { 1,204 }
    REPLY   { response_code, device_status, datalogger_ss_60 }
  }
  TRANSACTION 461
  {
    REQUEST { 1,205 }
    REPLY   { response_code, device_status, datalogger_ss_61 }
  }
  TRANSACTION 462
  {
    REQUEST { 1,206 }
    REPLY   { response_code, device_status, datalogger_ss_62 }
  }
  TRANSACTION 463
  {
    REQUEST { 1,207 }
    REPLY   { response_code, device_status, datalogger_ss_63 }
  }
  TRANSACTION 464
  {
    REQUEST { 1,208 }
    REPLY   { response_code, device_status, datalogger_ss_64 }
  }
  TRANSACTION 465
  {
    REQUEST { 1,209 }
    REPLY   { response_code, device_status, datalogger_ss_65 }
  }
  TRANSACTION 466
  {
    REQUEST { 1,210 }
    REPLY   { response_code, device_status, datalogger_ss_66 }
  }
  TRANSACTION 467
  {
    REQUEST { 1,211 }
    REPLY   { response_code, device_status, datalogger_ss_67 }
  }
  TRANSACTION 468
  {
    REQUEST { 1,212 }
    REPLY   { response_code, device_status, datalogger_ss_68 }
  }
  TRANSACTION 469
  {
    REQUEST { 1,213 }
    REPLY   { response_code, device_status, datalogger_ss_69 }
  }
  TRANSACTION 470
  {
    REQUEST { 1,214 }
    REPLY   { response_code, device_status, datalogger_ss_70 }
  }
  TRANSACTION 471
  {
    REQUEST { 1,215 }
    REPLY   { response_code, device_status, datalogger_ss_71 }
  }
  TRANSACTION 472
  {
    REQUEST { 1,216 }
    REPLY   { response_code, device_status, datalogger_ss_72 }
  }
  TRANSACTION 473
  {
    REQUEST { 1,217 }
    REPLY   { response_code, device_status, datalogger_ss_73 }
  }
  TRANSACTION 474
  {
    REQUEST { 1,218 }
    REPLY   { response_code, device_status, datalogger_ss_74 }
  }
  TRANSACTION 475
  {
    REQUEST { 1,219 }
    REPLY   { response_code, device_status, datalogger_ss_75 }
  }
  TRANSACTION 476
  {
    REQUEST { 1,220 }
    REPLY   { response_code, device_status, datalogger_ss_76 }
  }
  TRANSACTION 477
  {
    REQUEST { 1,221 }
    REPLY   { response_code, device_status, datalogger_ss_77 }
  }
  TRANSACTION 478
  {
    REQUEST { 1,222 }
    REPLY   { response_code, device_status, datalogger_ss_78 }
  }
  TRANSACTION 479
  {
    REQUEST { 1,223 }
    REPLY   { response_code, device_status, datalogger_ss_79 }
  }
  TRANSACTION 480
  {
    REQUEST { 1,224 }
    REPLY   { response_code, device_status, datalogger_ss_80 }
  }
  TRANSACTION 481
  {
    REQUEST { 1,225 }
    REPLY   { response_code, device_status, datalogger_ss_81 }
  }
  TRANSACTION 482
  {
    REQUEST { 1,226 }
    REPLY   { response_code, device_status, datalogger_ss_82 }
  }
  TRANSACTION 483
  {
    REQUEST { 1,227 }
    REPLY   { response_code, device_status, datalogger_ss_83 }
  }
  TRANSACTION 484
  {
    REQUEST { 1,228 }
    REPLY   { response_code, device_status, datalogger_ss_84 }
  }
  TRANSACTION 485
  {
    REQUEST { 1,229 }
    REPLY   { response_code, device_status, datalogger_ss_85 }
  }
  TRANSACTION 486
  {
    REQUEST { 1,230 }
    REPLY   { response_code, device_status, datalogger_ss_86 }
  }
  TRANSACTION 487
  {
    REQUEST { 1,231 }
    REPLY   { response_code, device_status, datalogger_ss_87 }
  }
  TRANSACTION 488
  {
    REQUEST { 1,232 }
    REPLY   { response_code, device_status, datalogger_ss_88 }
  }
  TRANSACTION 489
  {
    REQUEST { 1,233 }
    REPLY   { response_code, device_status, datalogger_ss_89 }
  }
  TRANSACTION 490
  {
    REQUEST { 1,234 }
    REPLY   { response_code, device_status, datalogger_ss_90 }
  }
  TRANSACTION 491
  {
    REQUEST { 1,235 }
    REPLY   { response_code, device_status, datalogger_ss_91 }
  }
  TRANSACTION 492
  {
    REQUEST { 1,236 }
    REPLY   { response_code, device_status, datalogger_ss_92 }
  }
  TRANSACTION 493
  {
    REQUEST { 1,237 }
    REPLY   { response_code, device_status, datalogger_ss_93 }
  }
  TRANSACTION 494
  {
    REQUEST { 1,238 }
    REPLY   { response_code, device_status, datalogger_ss_94 }
  }
  TRANSACTION 495
  {
    REQUEST { 1,239 }
    REPLY   { response_code, device_status, datalogger_ss_95 }
  }
  TRANSACTION 496
  {
    REQUEST { 1,240 }
    REPLY   { response_code, device_status, datalogger_ss_96 }
  }
  TRANSACTION 497
  {
    REQUEST { 1,241 }
    REPLY   { response_code, device_status, datalogger_ss_97 }
  }
  TRANSACTION 498
  {
    REQUEST { 1,242 }
    REPLY   { response_code, device_status, datalogger_ss_98 }
  }
  TRANSACTION 499
  {
    REQUEST { 1,243 }
    REPLY   { response_code, device_status, datalogger_ss_99 }
  }


  RESPONSE_CODES
  {
    0, SUCCESS,             [no_command_specific_errors];
    3, DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	4, DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 180     Write Diagnose - unsigned Long                           */
/* ------------------------------------------------------------------------ */
COMMAND write_diagnosis_ulong
{
  NUMBER 180;
  OPERATION WRITE;

  TRANSACTION 477
  {
    REQUEST { 1, 0xDD, sample_rate }
    REPLY   { response_code, device_status, sample_rate }
  }

  TRANSACTION 478
  {
    REQUEST { 1, 0xDE, pretrigger_time }
    REPLY   { response_code, device_status, pretrigger_time }
  }

  TRANSACTION 480
  {
    REQUEST { 1, 0xE0, hys_stell_y }
    REPLY   { response_code, device_status, hys_stell_y }
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 3,	DATA_ENTRY_ERROR,	[passed_parameter_too_large];
		 4,	DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
         7, MODE_ERROR,         [in_write_protect_mode];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 181     Read Diagnose - unsigned Long                            */
/* ------------------------------------------------------------------------ */
COMMAND read_diagnosis_ulong
{
  NUMBER 181;
  OPERATION READ;

  TRANSACTION 0
  {
    REQUEST { 0, 0 }
    REPLY   { response_code, device_status, elapsed_hours_meter }
  }

  TRANSACTION 1
  {
    REQUEST { 0, 1 }
    REPLY   { response_code, device_status, device_in_closed_loop }
  }

  TRANSACTION 2
  {
    REQUEST { 0, 2 }
    REPLY   { response_code, device_status, device_switched_on_since_init }
  }

  TRANSACTION 3
  {
    REQUEST { 0, 3 }
    REPLY   { response_code, device_status, device_in_closed_loop_since_init }
  }

/* mit cmd 157 erledigt

  TRANSACTION 4
  {
    REQUEST { 0, 4 }
    REPLY   { response_code, device_status, elapsed_hours_meter_1 }
  }

  TRANSACTION 5
  {
    REQUEST { 0, 5 }
    REPLY   { response_code, device_status, elapsed_hours_meter_2 }
  }

  TRANSACTION 6
  {
    REQUEST { 0, 6 }
    REPLY   { response_code, device_status, elapsed_hours_meter_3 }
  }

  TRANSACTION 7
  {
    REQUEST { 0, 7 }
    REPLY   { response_code, device_status, elapsed_hours_meter_4 }
  }

  TRANSACTION 8
  {
    REQUEST { 0, 8 }
    REPLY   { response_code, device_status, elapsed_hours_meter_5 }
  }

  TRANSACTION 9
  {
    REQUEST { 0, 9 }
    REPLY   { response_code, device_status, elapsed_hours_meter_6 }
  }

  TRANSACTION 10
  {
    REQUEST { 0, 10 }
    REPLY   { response_code, device_status, elapsed_hours_meter_7 }
  }

  TRANSACTION 11
  {
    REQUEST { 0, 11 }
    REPLY   { response_code, device_status, elapsed_hours_meter_8 }
  }

  TRANSACTION 12
  {
    REQUEST { 0, 12 }
    REPLY   { response_code, device_status, elapsed_hours_meter_9 }
  }

  TRANSACTION 13
  {
    REQUEST { 0, 13 }
    REPLY   { response_code, device_status, elapsed_hours_meter_10 }
  }

  TRANSACTION 14
  {
    REQUEST { 0, 14 }
    REPLY   { response_code, device_status, elapsed_hours_meter_11 }
  }

  TRANSACTION 15
  {
    REQUEST { 0, 15 }
    REPLY   { response_code, device_status, elapsed_hours_meter_12 }
  }

  TRANSACTION 16
  {
    REQUEST { 0, 16 }
    REPLY   { response_code, device_status, elapsed_hours_meter_13 }
  }

  TRANSACTION 17
  {
    REQUEST { 0, 17 }
    REPLY   { response_code, device_status, elapsed_hours_meter_14 }
  }

  TRANSACTION 18
  {
    REQUEST { 0, 18 }
    REPLY   { response_code, device_status, elapsed_hours_meter_15 }
  }

  TRANSACTION 19
  {
    REQUEST { 0, 19 }
    REPLY   { response_code, device_status, elapsed_hours_meter_16 }
  }

  TRANSACTION 20
  {
    REQUEST { 0, 20 }
    REPLY   { response_code, device_status, elapsed_hours_meter_17 }
  }

  TRANSACTION 21
  {
    REQUEST { 0, 21 }
    REPLY   { response_code, device_status, elapsed_hours_meter_18 }
  }

  TRANSACTION 22
  {
    REQUEST { 0, 22 }
    REPLY   { response_code, device_status, elapsed_hours_meter_19 }
  }

  TRANSACTION 23
  {
    REQUEST { 0, 23 }
    REPLY   { response_code, device_status, elapsed_hours_meter_20 }
  }

  TRANSACTION 24
  {
    REQUEST { 0, 24 }
    REPLY   { response_code, device_status, elapsed_hours_meter_21 }
  }

  TRANSACTION 25
  {
    REQUEST { 0, 25 }
    REPLY   { response_code, device_status, elapsed_hours_meter_22 }
  }

  TRANSACTION 26
  {
    REQUEST { 0, 26 }
    REPLY   { response_code, device_status, elapsed_hours_meter_23 }
  }

  TRANSACTION 27
  {
    REQUEST { 0, 27 }
    REPLY   { response_code, device_status, elapsed_hours_meter_24 }
  }

  TRANSACTION 28
  {
    REQUEST { 0, 28 }
    REPLY   { response_code, device_status, elapsed_hours_meter_25 }
  }

  TRANSACTION 29
  {
    REQUEST { 0, 29 }
    REPLY   { response_code, device_status, elapsed_hours_meter_26 }
  }

  TRANSACTION 30
  {
    REQUEST { 0, 30 }
    REPLY   { response_code, device_status, elapsed_hours_meter_27 }
  }

  TRANSACTION 31
  {
    REQUEST { 0, 31 }
    REPLY   { response_code, device_status, elapsed_hours_meter_28 }
  }

  TRANSACTION 32
  {
    REQUEST { 0, 32 }
    REPLY   { response_code, device_status, elapsed_hours_meter_29 }
  }

  TRANSACTION 33
  {
    REQUEST { 0, 33  }
    REPLY   { response_code, device_status, elapsed_hours_meter_30 }
  }
*/

  TRANSACTION 34
  {
    REQUEST { 0, 34 }
    REPLY   { response_code, device_status, his_x_anzahl_messpunkte }
  }

  TRANSACTION 57
  {
    REQUEST { 0, 0x39 }
    REPLY   { response_code, device_status, gesamtanzahl }
  }

  TRANSACTION 70
  {
    REQUEST { 0, 0x46 }
    REPLY   { response_code, device_status, his_z_gesamtanzahl }
  }

  TRANSACTION 160
  {
    REQUEST { 0,160 }
    REPLY   { response_code, device_status, lower_end_position_bsz_1 }
  }
  TRANSACTION 161
  {
    REQUEST { 0,161 }
    REPLY   { response_code, device_status, lower_end_position_bsz_2 }
  }
  TRANSACTION 162
  {
    REQUEST { 0,162 }
    REPLY   { response_code, device_status, lower_end_position_bsz_3 }
  }
  TRANSACTION 163
  {
    REQUEST { 0,163 }
    REPLY   { response_code, device_status, lower_end_position_bsz_4 }
  }
  TRANSACTION 164
  {
    REQUEST { 0,164 }
    REPLY   { response_code, device_status, lower_end_position_bsz_5 }
  }
  TRANSACTION 165
  {
    REQUEST { 0,165 }
    REPLY   { response_code, device_status, lower_end_position_bsz_6 }
  }
  TRANSACTION 166
  {
    REQUEST { 0,166 }
    REPLY   { response_code, device_status, lower_end_position_bsz_7 }
  }
  TRANSACTION 167
  {
    REQUEST { 0,167 }
    REPLY   { response_code, device_status, lower_end_position_bsz_8 }
  }
  TRANSACTION 168
  {
    REQUEST { 0,168 }
    REPLY   { response_code, device_status, lower_end_position_bsz_9 }
  }
  TRANSACTION 169
  {
    REQUEST { 0,169 }
    REPLY   { response_code, device_status, lower_end_position_bsz_10 }
  }
  TRANSACTION 170
  {
    REQUEST { 0,170 }
    REPLY   { response_code, device_status, lower_end_position_bsz_11 }
  }
  TRANSACTION 171
  {
    REQUEST { 0,171 }
    REPLY   { response_code, device_status, lower_end_position_bsz_12 }
  }
  TRANSACTION 172
  {
    REQUEST { 0,172 }
    REPLY   { response_code, device_status, lower_end_position_bsz_13 }
  }
  TRANSACTION 173
  {
    REQUEST { 0,173 }
    REPLY   { response_code, device_status, lower_end_position_bsz_14 }
  }
  TRANSACTION 174
  {
    REQUEST { 0,174 }
    REPLY   { response_code, device_status, lower_end_position_bsz_15 }
  }
  TRANSACTION 175
  {
    REQUEST { 0,175 }
    REPLY   { response_code, device_status, lower_end_position_bsz_16 }
  }
  TRANSACTION 176
  {
    REQUEST { 0,176 }
    REPLY   { response_code, device_status, lower_end_position_bsz_17 }
  }
  TRANSACTION 177
  {
    REQUEST { 0,177 }
    REPLY   { response_code, device_status, lower_end_position_bsz_18 }
  }
  TRANSACTION 178
  {
    REQUEST { 0,178 }
    REPLY   { response_code, device_status, lower_end_position_bsz_19 }
  }
  TRANSACTION 179
  {
    REQUEST { 0,179 }
    REPLY   { response_code, device_status, lower_end_position_bsz_20 }
  }
  TRANSACTION 180
  {
    REQUEST { 0,180 }
    REPLY   { response_code, device_status, lower_end_position_bsz_21 }
  }
  TRANSACTION 181
  {
    REQUEST { 0,181 }
    REPLY   { response_code, device_status, lower_end_position_bsz_22 }
  }
  TRANSACTION 182
  {
    REQUEST { 0,182 }
    REPLY   { response_code, device_status, lower_end_position_bsz_23 }
  }
  TRANSACTION 183
  {
    REQUEST { 0,183 }
    REPLY   { response_code, device_status, lower_end_position_bsz_24 }
  }
  TRANSACTION 184
  {
    REQUEST { 0,184 }
    REPLY   { response_code, device_status, lower_end_position_bsz_25 }
  }
  TRANSACTION 185
  {
    REQUEST { 0,185 }
    REPLY   { response_code, device_status, lower_end_position_bsz_26 }
  }
  TRANSACTION 186
  {
    REQUEST { 0,186 }
    REPLY   { response_code, device_status, lower_end_position_bsz_27 }
  }
  TRANSACTION 187
  {
    REQUEST { 0,187 }
    REPLY   { response_code, device_status, lower_end_position_bsz_28 }
  }
  TRANSACTION 188
  {
    REQUEST { 0,188 }
    REPLY   { response_code, device_status, lower_end_position_bsz_29 }
  }
  TRANSACTION 189
  {
    REQUEST { 0,189 }
    REPLY   { response_code, device_status, lower_end_position_bsz_30 }
  }

  TRANSACTION 191
  {
    REQUEST { 0,191 }
    REPLY   { response_code, device_status, lower_end_position_ref_value_bsz }
  }

  TRANSACTION 192
  {
    REQUEST { 0,192 }
    REPLY   { response_code, device_status, his_t_zeit_max_temperatur }
  }

/* Anfang PST */
  TRANSACTION 197
  {
    REQUEST { 0,197 }
    REPLY   { response_code, device_status, pst_elapsed_hours_meter_0 }
  }
/* Anfang PST */


  TRANSACTION 200
  {
    REQUEST { 0,200 }
    REPLY   { response_code, device_status, datalogger_t_0 }
  }
  TRANSACTION 201
  {
    REQUEST { 0,201 }
    REPLY   { response_code, device_status, datalogger_t_1 }
  }
  TRANSACTION 202
  {
    REQUEST { 0,202 }
    REPLY   { response_code, device_status, datalogger_t_2 }
  }
  TRANSACTION 203
  {
    REQUEST { 0,203 }
    REPLY   { response_code, device_status, datalogger_t_3 }
  }
  TRANSACTION 204
  {
    REQUEST { 0,204 }
    REPLY   { response_code, device_status, datalogger_t_4 }
  }
  TRANSACTION 205
  {
    REQUEST { 0,205 }
    REPLY   { response_code, device_status, datalogger_t_5 }
  }
  TRANSACTION 206
  {
    REQUEST { 0,206 }
    REPLY   { response_code, device_status, datalogger_t_6 }
  }
  TRANSACTION 207
  {
    REQUEST { 0,207 }
    REPLY   { response_code, device_status, datalogger_t_7 }
  }
  TRANSACTION 208
  {
    REQUEST { 0,208 }
    REPLY   { response_code, device_status, datalogger_t_8 }
  }
  TRANSACTION 209
  {
    REQUEST { 0,209 }
    REPLY   { response_code, device_status, datalogger_t_9 }
  }
  TRANSACTION 210
  {
    REQUEST { 0,210 }
    REPLY   { response_code, device_status, datalogger_t_10 }
  }
  TRANSACTION 211
  {
    REQUEST { 0,211 }
    REPLY   { response_code, device_status, datalogger_t_11 }
  }
  TRANSACTION 212
  {
    REQUEST { 0,212 }
    REPLY   { response_code, device_status, datalogger_t_12 }
  }
  TRANSACTION 213
  {
    REQUEST { 0,213 }
    REPLY   { response_code, device_status, datalogger_t_13 }
  }
  TRANSACTION 214
  {
    REQUEST { 0,214 }
    REPLY   { response_code, device_status, datalogger_t_14 }
  }
  TRANSACTION 215
  {
    REQUEST { 0,215 }
    REPLY   { response_code, device_status, datalogger_t_15 }
  }
  TRANSACTION 216
  {
    REQUEST { 0,216 }
    REPLY   { response_code, device_status, datalogger_t_16 }
  }
  TRANSACTION 217
  {
    REQUEST { 0,217 }
    REPLY   { response_code, device_status, datalogger_t_17 }
  }
  TRANSACTION 218
  {
    REQUEST { 0,218 }
    REPLY   { response_code, device_status, datalogger_t_18 }
  }
  TRANSACTION 219
  {
    REQUEST { 0,219 }
    REPLY   { response_code, device_status, datalogger_t_19 }
  }
  TRANSACTION 220
  {
    REQUEST { 0,220 }
    REPLY   { response_code, device_status, datalogger_t_20 }
  }
  TRANSACTION 221
  {
    REQUEST { 0,221 }
    REPLY   { response_code, device_status, datalogger_t_21 }
  }
  TRANSACTION 222
  {
    REQUEST { 0,222 }
    REPLY   { response_code, device_status, datalogger_t_22 }
  }
  TRANSACTION 223
  {
    REQUEST { 0,223 }
    REPLY   { response_code, device_status, datalogger_t_23 }
  }
  TRANSACTION 224
  {
    REQUEST { 0,224 }
    REPLY   { response_code, device_status, datalogger_t_24 }
  }
  TRANSACTION 225
  {
    REQUEST { 0,225 }
    REPLY   { response_code, device_status, datalogger_t_25 }
  }
  TRANSACTION 226
  {
    REQUEST { 0,226 }
    REPLY   { response_code, device_status, datalogger_t_26 }
  }
  TRANSACTION 227
  {
    REQUEST { 0,227 }
    REPLY   { response_code, device_status, datalogger_t_27 }
  }
  TRANSACTION 228
  {
    REQUEST { 0,228 }
    REPLY   { response_code, device_status, datalogger_t_28 }
  }
  TRANSACTION 229
  {
    REQUEST { 0,229 }
    REPLY   { response_code, device_status, datalogger_t_29 }
  }
  TRANSACTION 230
  {
    REQUEST { 0,230 }
    REPLY   { response_code, device_status, datalogger_t_30 }
  }
  TRANSACTION 231
  {
    REQUEST { 0,231 }
    REPLY   { response_code, device_status, datalogger_t_31 }
  }
  TRANSACTION 232
  {
    REQUEST { 0,232 }
    REPLY   { response_code, device_status, datalogger_t_32 }
  }
  TRANSACTION 233
  {
    REQUEST { 0,233 }
    REPLY   { response_code, device_status, datalogger_t_33 }
  }
  TRANSACTION 234
  {
    REQUEST { 0,234 }
    REPLY   { response_code, device_status, datalogger_t_34 }
  }
  TRANSACTION 235
  {
    REQUEST { 0,235 }
    REPLY   { response_code, device_status, datalogger_t_35 }
  }
  TRANSACTION 236
  {
    REQUEST { 0,236 }
    REPLY   { response_code, device_status, datalogger_t_36 }
  }
  TRANSACTION 237
  {
    REQUEST { 0,237 }
    REPLY   { response_code, device_status, datalogger_t_37 }
  }
  TRANSACTION 238
  {
    REQUEST { 0,238 }
    REPLY   { response_code, device_status, datalogger_t_38 }
  }
  TRANSACTION 239
  {
    REQUEST { 0,239 }
    REPLY   { response_code, device_status, datalogger_t_39 }
  }
  TRANSACTION 240
  {
    REQUEST { 0,240 }
    REPLY   { response_code, device_status, datalogger_t_40 }
  }
  TRANSACTION 241
  {
    REQUEST { 0,241 }
    REPLY   { response_code, device_status, datalogger_t_41 }
  }
  TRANSACTION 242
  {
    REQUEST { 0,242 }
    REPLY   { response_code, device_status, datalogger_t_42 }
  }
  TRANSACTION 243
  {
    REQUEST { 0,243 }
    REPLY   { response_code, device_status, datalogger_t_43 }
  }
  TRANSACTION 244
  {
    REQUEST { 0,244 }
    REPLY   { response_code, device_status, datalogger_t_44 }
  }
  TRANSACTION 245
  {
    REQUEST { 0,245 }
    REPLY   { response_code, device_status, datalogger_t_45 }
  }
  TRANSACTION 246
  {
    REQUEST { 0,246 }
    REPLY   { response_code, device_status, datalogger_t_46 }
  }
  TRANSACTION 247
  {
    REQUEST { 0,247 }
    REPLY   { response_code, device_status, datalogger_t_47 }
  }
  TRANSACTION 248
  {
    REQUEST { 0,248 }
    REPLY   { response_code, device_status, datalogger_t_48 }
  }
  TRANSACTION 249
  {
    REQUEST { 0,249 }
    REPLY   { response_code, device_status, datalogger_t_49 }
  }
  TRANSACTION 250
  {
    REQUEST { 0,250 }
    REPLY   { response_code, device_status, datalogger_t_50 }
  }
  TRANSACTION 251
  {
    REQUEST { 0,251 }
    REPLY   { response_code, device_status, datalogger_t_51 }
  }
  TRANSACTION 252
  {
    REQUEST { 0,252 }
    REPLY   { response_code, device_status, datalogger_t_52 }
  }
  TRANSACTION 253
  {
    REQUEST { 0,253 }
    REPLY   { response_code, device_status, datalogger_t_53 }
  }
  TRANSACTION 254
  {
    REQUEST { 0,254 }
    REPLY   { response_code, device_status, datalogger_t_54 }
  }
  TRANSACTION 255
  {
    REQUEST { 0,255 }
    REPLY   { response_code, device_status, datalogger_t_55 }
  }
  TRANSACTION 256
  {
    REQUEST { 1,0 }
    REPLY   { response_code, device_status, datalogger_t_56 }
  }
  TRANSACTION 257
  {
    REQUEST { 1,1 }
    REPLY   { response_code, device_status, datalogger_t_57 }
  }
  TRANSACTION 258
  {
    REQUEST { 1,2 }
    REPLY   { response_code, device_status, datalogger_t_58 }
  }
  TRANSACTION 259
  {
    REQUEST { 1,3 }
    REPLY   { response_code, device_status, datalogger_t_59 }
  }
  TRANSACTION 260
  {
    REQUEST { 1,4 }
    REPLY   { response_code, device_status, datalogger_t_60 }
  }
  TRANSACTION 261
  {
    REQUEST { 1,5 }
    REPLY   { response_code, device_status, datalogger_t_61 }
  }
  TRANSACTION 262
  {
    REQUEST { 1,6 }
    REPLY   { response_code, device_status, datalogger_t_62 }
  }
  TRANSACTION 263
  {
    REQUEST { 1,7 }
    REPLY   { response_code, device_status, datalogger_t_63 }
  }
  TRANSACTION 264
  {
    REQUEST { 1,8 }
    REPLY   { response_code, device_status, datalogger_t_64 }
  }
  TRANSACTION 265
  {
    REQUEST { 1,9 }
    REPLY   { response_code, device_status, datalogger_t_65 }
  }
  TRANSACTION 266
  {
    REQUEST { 1,10 }
    REPLY   { response_code, device_status, datalogger_t_66 }
  }
  TRANSACTION 267
  {
    REQUEST { 1,11 }
    REPLY   { response_code, device_status, datalogger_t_67 }
  }
  TRANSACTION 268
  {
    REQUEST { 1,12 }
    REPLY   { response_code, device_status, datalogger_t_68 }
  }
  TRANSACTION 269
  {
    REQUEST { 1,13 }
    REPLY   { response_code, device_status, datalogger_t_69 }
  }
  TRANSACTION 270
  {
    REQUEST { 1,14 }
    REPLY   { response_code, device_status, datalogger_t_70 }
  }
  TRANSACTION 271
  {
    REQUEST { 1,15 }
    REPLY   { response_code, device_status, datalogger_t_71 }
  }
  TRANSACTION 272
  {
    REQUEST { 1,16 }
    REPLY   { response_code, device_status, datalogger_t_72 }
  }
  TRANSACTION 273
  {
    REQUEST { 1,17 }
    REPLY   { response_code, device_status, datalogger_t_73 }
  }
  TRANSACTION 274
  {
    REQUEST { 1,18 }
    REPLY   { response_code, device_status, datalogger_t_74 }
  }
  TRANSACTION 275
  {
    REQUEST { 1,19 }
    REPLY   { response_code, device_status, datalogger_t_75 }
  }
  TRANSACTION 276
  {
    REQUEST { 1,20 }
    REPLY   { response_code, device_status, datalogger_t_76 }
  }
  TRANSACTION 277
  {
    REQUEST { 1,21 }
    REPLY   { response_code, device_status, datalogger_t_77 }
  }
  TRANSACTION 278
  {
    REQUEST { 1,22 }
    REPLY   { response_code, device_status, datalogger_t_78 }
  }
  TRANSACTION 279
  {
    REQUEST { 1,23 }
    REPLY   { response_code, device_status, datalogger_t_79 }
  }
  TRANSACTION 280
  {
    REQUEST { 1,24 }
    REPLY   { response_code, device_status, datalogger_t_80 }
  }
  TRANSACTION 281
  {
    REQUEST { 1,25 }
    REPLY   { response_code, device_status, datalogger_t_81 }
  }
  TRANSACTION 282
  {
    REQUEST { 1,26 }
    REPLY   { response_code, device_status, datalogger_t_82 }
  }
  TRANSACTION 283
  {
    REQUEST { 1,27 }
    REPLY   { response_code, device_status, datalogger_t_83 }
  }
  TRANSACTION 284
  {
    REQUEST { 1,28 }
    REPLY   { response_code, device_status, datalogger_t_84 }
  }
  TRANSACTION 285
  {
    REQUEST { 1,29 }
    REPLY   { response_code, device_status, datalogger_t_85 }
  }
  TRANSACTION 286
  {
    REQUEST { 1,30 }
    REPLY   { response_code, device_status, datalogger_t_86 }
  }
  TRANSACTION 287
  {
    REQUEST { 1,31 }
    REPLY   { response_code, device_status, datalogger_t_87 }
  }
  TRANSACTION 288
  {
    REQUEST { 1,32 }
    REPLY   { response_code, device_status, datalogger_t_88 }
  }
  TRANSACTION 289
  {
    REQUEST { 1,33 }
    REPLY   { response_code, device_status, datalogger_t_89 }
  }
  TRANSACTION 290
  {
    REQUEST { 1,34 }
    REPLY   { response_code, device_status, datalogger_t_90 }
  }
  TRANSACTION 291
  {
    REQUEST { 1,35 }
    REPLY   { response_code, device_status, datalogger_t_91 }
  }
  TRANSACTION 292
  {
    REQUEST { 1,36 }
    REPLY   { response_code, device_status, datalogger_t_92 }
  }
  TRANSACTION 293
  {
    REQUEST { 1,37 }
    REPLY   { response_code, device_status, datalogger_t_93 }
  }
  TRANSACTION 294
  {
    REQUEST { 1,38 }
    REPLY   { response_code, device_status, datalogger_t_94 }
  }
  TRANSACTION 295
  {
    REQUEST { 1,39 }
    REPLY   { response_code, device_status, datalogger_t_95 }
  }
  TRANSACTION 296
  {
    REQUEST { 1,40 }
    REPLY   { response_code, device_status, datalogger_t_96 }
  }
  TRANSACTION 297
  {
    REQUEST { 1,41 }
    REPLY   { response_code, device_status, datalogger_t_97 }
  }
  TRANSACTION 298
  {
    REQUEST { 1,42 }
    REPLY   { response_code, device_status, datalogger_t_98 }
  }
  TRANSACTION 299
  {
    REQUEST { 1,43 }
    REPLY   { response_code, device_status, datalogger_t_99 }
  }


  TRANSACTION 300
  {
    REQUEST { 1,44 }
    REPLY   { response_code, device_status, sprung_t_0 }
  }
  TRANSACTION 301
  {
    REQUEST { 1,45 }
    REPLY   { response_code, device_status, sprung_t_1 }
  }
  TRANSACTION 302
  {
    REQUEST { 1,46 }
    REPLY   { response_code, device_status, sprung_t_2 }
  }
  TRANSACTION 303
  {
    REQUEST { 1,47 }
    REPLY   { response_code, device_status, sprung_t_3 }
  }
  TRANSACTION 304
  {
    REQUEST { 1,48 }
    REPLY   { response_code, device_status, sprung_t_4 }
  }
  TRANSACTION 305
  {
    REQUEST { 1,49 }
    REPLY   { response_code, device_status, sprung_t_5 }
  }
  TRANSACTION 306
  {
    REQUEST { 1,50 }
    REPLY   { response_code, device_status, sprung_t_6 }
  }
  TRANSACTION 307
  {
    REQUEST { 1,51 }
    REPLY   { response_code, device_status, sprung_t_7 }
  }
  TRANSACTION 308
  {
    REQUEST { 1,52 }
    REPLY   { response_code, device_status, sprung_t_8 }
  }
  TRANSACTION 309
  {
    REQUEST { 1,53 }
    REPLY   { response_code, device_status, sprung_t_9 }
  }
  TRANSACTION 310
  {
    REQUEST { 1,54 }
    REPLY   { response_code, device_status, sprung_t_10 }
  }
  TRANSACTION 311
  {
    REQUEST { 1,55 }
    REPLY   { response_code, device_status, sprung_t_11 }
  }
  TRANSACTION 312
  {
    REQUEST { 1,56 }
    REPLY   { response_code, device_status, sprung_t_12 }
  }
  TRANSACTION 313
  {
    REQUEST { 1,57 }
    REPLY   { response_code, device_status, sprung_t_13 }
  }
  TRANSACTION 314
  {
    REQUEST { 1,58 }
    REPLY   { response_code, device_status, sprung_t_14 }
  }
  TRANSACTION 315
  {
    REQUEST { 1,59 }
    REPLY   { response_code, device_status, sprung_t_15 }
  }
  TRANSACTION 316
  {
    REQUEST { 1,60 }
    REPLY   { response_code, device_status, sprung_t_16 }
  }
  TRANSACTION 317
  {
    REQUEST { 1,61 }
    REPLY   { response_code, device_status, sprung_t_17 }
  }
  TRANSACTION 318
  {
    REQUEST { 1,62 }
    REPLY   { response_code, device_status, sprung_t_18 }
  }
  TRANSACTION 319
  {
    REQUEST { 1,63 }
    REPLY   { response_code, device_status, sprung_t_19 }
  }
  TRANSACTION 320
  {
    REQUEST { 1,64 }
    REPLY   { response_code, device_status, sprung_t_20 }
  }
  TRANSACTION 321
  {
    REQUEST { 1,65 }
    REPLY   { response_code, device_status, sprung_t_21 }
  }
  TRANSACTION 322
  {
    REQUEST { 1,66 }
    REPLY   { response_code, device_status, sprung_t_22 }
  }
  TRANSACTION 323
  {
    REQUEST { 1,67 }
    REPLY   { response_code, device_status, sprung_t_23 }
  }
  TRANSACTION 324
  {
    REQUEST { 1,68 }
    REPLY   { response_code, device_status, sprung_t_24 }
  }
  TRANSACTION 325
  {
    REQUEST { 1,69 }
    REPLY   { response_code, device_status, sprung_t_25 }
  }
  TRANSACTION 326
  {
    REQUEST { 1,70 }
    REPLY   { response_code, device_status, sprung_t_26 }
  }
  TRANSACTION 327
  {
    REQUEST { 1,71 }
    REPLY   { response_code, device_status, sprung_t_27 }
  }
  TRANSACTION 328
  {
    REQUEST { 1,72 }
    REPLY   { response_code, device_status, sprung_t_28 }
  }
  TRANSACTION 329
  {
    REQUEST { 1,73 }
    REPLY   { response_code, device_status, sprung_t_29 }
  }
  TRANSACTION 330
  {
    REQUEST { 1,74 }
    REPLY   { response_code, device_status, sprung_t_30 }
  }
  TRANSACTION 331
  {
    REQUEST { 1,75 }
    REPLY   { response_code, device_status, sprung_t_31 }
  }
  TRANSACTION 332
  {
    REQUEST { 1,76 }
    REPLY   { response_code, device_status, sprung_t_32 }
  }
  TRANSACTION 333
  {
    REQUEST { 1,77 }
    REPLY   { response_code, device_status, sprung_t_33 }
  }
  TRANSACTION 334
  {
    REQUEST { 1,78 }
    REPLY   { response_code, device_status, sprung_t_34 }
  }
  TRANSACTION 335
  {
    REQUEST { 1,79 }
    REPLY   { response_code, device_status, sprung_t_35 }
  }
  TRANSACTION 336
  {
    REQUEST { 1,80 }
    REPLY   { response_code, device_status, sprung_t_36 }
  }
  TRANSACTION 337
  {
    REQUEST { 1,81 }
    REPLY   { response_code, device_status, sprung_t_37 }
  }
  TRANSACTION 338
  {
    REQUEST { 1,82 }
    REPLY   { response_code, device_status, sprung_t_38 }
  }
  TRANSACTION 339
  {
    REQUEST { 1,83 }
    REPLY   { response_code, device_status, sprung_t_39 }
  }
  TRANSACTION 340
  {
    REQUEST { 1,84 }
    REPLY   { response_code, device_status, sprung_t_40 }
  }
  TRANSACTION 341
  {
    REQUEST { 1,85 }
    REPLY   { response_code, device_status, sprung_t_41 }
  }
  TRANSACTION 342
  {
    REQUEST { 1,86 }
    REPLY   { response_code, device_status, sprung_t_42 }
  }
  TRANSACTION 343
  {
    REQUEST { 1,87 }
    REPLY   { response_code, device_status, sprung_t_43 }
  }
  TRANSACTION 344
  {
    REQUEST { 1,88 }
    REPLY   { response_code, device_status, sprung_t_44 }
  }
  TRANSACTION 345
  {
    REQUEST { 1,89 }
    REPLY   { response_code, device_status, sprung_t_45 }
  }
  TRANSACTION 346
  {
    REQUEST { 1,90 }
    REPLY   { response_code, device_status, sprung_t_46 }
  }
  TRANSACTION 347
  {
    REQUEST { 1,91 }
    REPLY   { response_code, device_status, sprung_t_47 }
  }
  TRANSACTION 348
  {
    REQUEST { 1,92 }
    REPLY   { response_code, device_status, sprung_t_48 }
  }
  TRANSACTION 349
  {
    REQUEST { 1,93 }
    REPLY   { response_code, device_status, sprung_t_49 }
  }
  TRANSACTION 350
  {
    REQUEST { 1,94 }
    REPLY   { response_code, device_status, sprung_t_50 }
  }
  TRANSACTION 351
  {
    REQUEST { 1,95 }
    REPLY   { response_code, device_status, sprung_t_51 }
  }
  TRANSACTION 352
  {
    REQUEST { 1,96 }
    REPLY   { response_code, device_status, sprung_t_52 }
  }
  TRANSACTION 353
  {
    REQUEST { 1,97 }
    REPLY   { response_code, device_status, sprung_t_53 }
  }
  TRANSACTION 354
  {
    REQUEST { 1,98 }
    REPLY   { response_code, device_status, sprung_t_54 }
  }
  TRANSACTION 355
  {
    REQUEST { 1,99 }
    REPLY   { response_code, device_status, sprung_t_55 }
  }
  TRANSACTION 356
  {
    REQUEST { 1,100 }
    REPLY   { response_code, device_status, sprung_t_56 }
  }
  TRANSACTION 357
  {
    REQUEST { 1,101 }
    REPLY   { response_code, device_status, sprung_t_57 }
  }
  TRANSACTION 358
  {
    REQUEST { 1,102 }
    REPLY   { response_code, device_status, sprung_t_58 }
  }
  TRANSACTION 359
  {
    REQUEST { 1,103 }
    REPLY   { response_code, device_status, sprung_t_59 }
  }
  TRANSACTION 360
  {
    REQUEST { 1,104 }
    REPLY   { response_code, device_status, sprung_t_60 }
  }
  TRANSACTION 361
  {
    REQUEST { 1,105 }
    REPLY   { response_code, device_status, sprung_t_61 }
  }
  TRANSACTION 362
  {
    REQUEST { 1,106 }
    REPLY   { response_code, device_status, sprung_t_62 }
  }
  TRANSACTION 363
  {
    REQUEST { 1,107 }
    REPLY   { response_code, device_status, sprung_t_63 }
  }
  TRANSACTION 364
  {
    REQUEST { 1,108 }
    REPLY   { response_code, device_status, sprung_t_64 }
  }
  TRANSACTION 365
  {
    REQUEST { 1,109 }
    REPLY   { response_code, device_status, sprung_t_65 }
  }
  TRANSACTION 366
  {
    REQUEST { 1,110 }
    REPLY   { response_code, device_status, sprung_t_66 }
  }
  TRANSACTION 367
  {
    REQUEST { 1,111 }
    REPLY   { response_code, device_status, sprung_t_67 }
  }
  TRANSACTION 368
  {
    REQUEST { 1,112 }
    REPLY   { response_code, device_status, sprung_t_68 }
  }
  TRANSACTION 369
  {
    REQUEST { 1,113 }
    REPLY   { response_code, device_status, sprung_t_69 }
  }
  TRANSACTION 370
  {
    REQUEST { 1,114 }
    REPLY   { response_code, device_status, sprung_t_70 }
  }
  TRANSACTION 371
  {
    REQUEST { 1,115 }
    REPLY   { response_code, device_status, sprung_t_71 }
  }
  TRANSACTION 372
  {
    REQUEST { 1,116 }
    REPLY   { response_code, device_status, sprung_t_72 }
  }
  TRANSACTION 373
  {
    REQUEST { 1,117 }
    REPLY   { response_code, device_status, sprung_t_73 }
  }
  TRANSACTION 374
  {
    REQUEST { 1,118 }
    REPLY   { response_code, device_status, sprung_t_74 }
  }
  TRANSACTION 375
  {
    REQUEST { 1,119 }
    REPLY   { response_code, device_status, sprung_t_75 }
  }
  TRANSACTION 376
  {
    REQUEST { 1,120 }
    REPLY   { response_code, device_status, sprung_t_76 }
  }
  TRANSACTION 377
  {
    REQUEST { 1,121 }
    REPLY   { response_code, device_status, sprung_t_77 }
  }
  TRANSACTION 378
  {
    REQUEST { 1,122 }
    REPLY   { response_code, device_status, sprung_t_78 }
  }
  TRANSACTION 379
  {
    REQUEST { 1,123 }
    REPLY   { response_code, device_status, sprung_t_79 }
  }
  TRANSACTION 380
  {
    REQUEST { 1,124 }
    REPLY   { response_code, device_status, sprung_t_80 }
  }
  TRANSACTION 381
  {
    REQUEST { 1,125 }
    REPLY   { response_code, device_status, sprung_t_81 }
  }
  TRANSACTION 382
  {
    REQUEST { 1,126 }
    REPLY   { response_code, device_status, sprung_t_82 }
  }
  TRANSACTION 383
  {
    REQUEST { 1,127 }
    REPLY   { response_code, device_status, sprung_t_83 }
  }
  TRANSACTION 384
  {
    REQUEST { 1,128 }
    REPLY   { response_code, device_status, sprung_t_84 }
  }
  TRANSACTION 385
  {
    REQUEST { 1,129 }
    REPLY   { response_code, device_status, sprung_t_85 }
  }
  TRANSACTION 386
  {
    REQUEST { 1,130 }
    REPLY   { response_code, device_status, sprung_t_86 }
  }
  TRANSACTION 387
  {
    REQUEST { 1,131 }
    REPLY   { response_code, device_status, sprung_t_87 }
  }
  TRANSACTION 388
  {
    REQUEST { 1,132 }
    REPLY   { response_code, device_status, sprung_t_88 }
  }
  TRANSACTION 389
  {
    REQUEST { 1,133 }
    REPLY   { response_code, device_status, sprung_t_89 }
  }
  TRANSACTION 390
  {
    REQUEST { 1,134 }
    REPLY   { response_code, device_status, sprung_t_90 }
  }
  TRANSACTION 391
  {
    REQUEST { 1,135 }
    REPLY   { response_code, device_status, sprung_t_91 }
  }
  TRANSACTION 392
  {
    REQUEST { 1,136 }
    REPLY   { response_code, device_status, sprung_t_92 }
  }
  TRANSACTION 393
  {
    REQUEST { 1,137 }
    REPLY   { response_code, device_status, sprung_t_93 }
  }
  TRANSACTION 394
  {
    REQUEST { 1,138 }
    REPLY   { response_code, device_status, sprung_t_94 }
  }
  TRANSACTION 395
  {
    REQUEST { 1,139 }
    REPLY   { response_code, device_status, sprung_t_95 }
  }
  TRANSACTION 396
  {
    REQUEST { 1,140 }
    REPLY   { response_code, device_status, sprung_t_96 }
  }
  TRANSACTION 397
  {
    REQUEST { 1,141 }
    REPLY   { response_code, device_status, sprung_t_97 }
  }
  TRANSACTION 398
  {
    REQUEST { 1,142 }
    REPLY   { response_code, device_status, sprung_t_98 }
  }
  TRANSACTION 399
  {
    REQUEST { 1,143 }
    REPLY   { response_code, device_status, sprung_t_99 }
  }


  TRANSACTION 462
  {
    REQUEST { 1, 0xCE }
    REPLY   { response_code, device_status, his_t_zeit_min_temperatur }
  }

  TRANSACTION 463
  {
    REQUEST { 1,0xCF }
    REPLY   { response_code, device_status, temp_period_time_low }
  }

  TRANSACTION 465
  {
    REQUEST { 1,0xD1 }
    REPLY   { response_code, device_status, temp_period_time_high }
  }

/* Anfang PST */
  TRANSACTION 466
  {
    REQUEST { 1,0xD2 }
    REPLY   { response_code, device_status, pst_elapsed_hours_meter_auto_test_time }
  }
/* Ende PST */

  TRANSACTION 467
  {
    REQUEST { 1,0xD3 }
    REPLY   { response_code, device_status, dead_time_rising }
  }

  TRANSACTION 468
  {
    REQUEST { 1,0xD4 }
    REPLY   { response_code, device_status, time_63_rising }
  }

  TRANSACTION 469
  {
    REQUEST { 1,0xD5 }
    REPLY   { response_code, device_status, time_98_rising }
  }

  TRANSACTION 470
  {
    REQUEST { 1,0xD6 }
    REPLY   { response_code, device_status, rise_time_rising_step }
  }

  TRANSACTION 471
  {
    REQUEST { 1,0xD7 }
    REPLY   { response_code, device_status, settling_time_rising_step }
  }

  TRANSACTION 472
  {
    REQUEST { 1,0xD8 }
    REPLY   { response_code, device_status, dead_time_falling }
  }

  TRANSACTION 473
  {
    REQUEST { 1,0xD9 }
    REPLY   { response_code, device_status, time_63_falling }
  }

  TRANSACTION 474
  {
    REQUEST { 1,0xDA }
    REPLY   { response_code, device_status, time_98_falling }
  }

  TRANSACTION 475
  {
    REQUEST { 1,0xDB }
    REPLY   { response_code, device_status, rise_time_falling_step }
  }

  TRANSACTION 476
  {
    REQUEST { 1,0xDC }
    REPLY   { response_code, device_status, settling_time_falling_step }
  }

  TRANSACTION 477
  {
    REQUEST { 1, 0xDD }
    REPLY   { response_code, device_status, sample_rate }
  }

  TRANSACTION 478
  {
    REQUEST { 1,0xDE }
    REPLY   { response_code, device_status, pretrigger_time }
  }

  TRANSACTION 479
  {
    REQUEST { 1,0xDF }
    REPLY   { response_code, device_status, max_pretrigger_time }
  }

  TRANSACTION 480
  {
    REQUEST { 1,0xE0 }
    REPLY   { response_code, device_status, hys_stell_y }
  }


/* Anfang PST */
  TRANSACTION 493
  {
    REQUEST { 1,0xED }
    REPLY   { response_code, device_status, pst_elapsed_hours_meter_1 }
  }

  TRANSACTION 494
  {
    REQUEST { 1,0xEE }
    REPLY   { response_code, device_status, dead_time_rising_1 }
  }

  TRANSACTION 495
  {
    REQUEST { 1,0xEF }
    REPLY   { response_code, device_status, time_63_rising_1 }
  }

  TRANSACTION 496
  {
    REQUEST { 1,0xF0 }
    REPLY   { response_code, device_status, time_98_rising_1 }
  }

  TRANSACTION 497
  {
    REQUEST { 1,0xF1 }
    REPLY   { response_code, device_status, rise_time_rising_step_1 }
  }

  TRANSACTION 498
  {
    REQUEST { 1,0xF2 }
    REPLY   { response_code, device_status, settling_time_rising_step_1 }
  }

  TRANSACTION 499
  {
    REQUEST { 1,0xF3 }
    REPLY   { response_code, device_status, dead_time_falling_1 }
  }

  TRANSACTION 500
  {
    REQUEST { 1,0xF4 }
    REPLY   { response_code, device_status, time_63_falling_1 }
  }

  TRANSACTION 501
  {
    REQUEST { 1,0xF5 }
    REPLY   { response_code, device_status, time_98_falling_1 }
  }

  TRANSACTION 502
  {
    REQUEST { 1,0xF6 }
    REPLY   { response_code, device_status, rise_time_falling_step_1 }
  }

  TRANSACTION 503
  {
    REQUEST { 1,0xF7 }
    REPLY   { response_code, device_status, settling_time_falling_step_1 }
  }

  TRANSACTION 504
  {
    REQUEST { 1,0xF8 }
    REPLY   { response_code, device_status, pst_elapsed_hours_meter_2 }
  }

  TRANSACTION 505
  {
    REQUEST { 1,0xF9 }
    REPLY   { response_code, device_status, dead_time_rising_2 }
  }

  TRANSACTION 506
  {
    REQUEST { 1,0xFA }
    REPLY   { response_code, device_status, time_63_rising_2 }
  }

  TRANSACTION 507
  {
    REQUEST { 1,0xFB }
    REPLY   { response_code, device_status, time_98_rising_2 }
  }

  TRANSACTION 508
  {
    REQUEST { 1,0xFC }
    REPLY   { response_code, device_status, rise_time_rising_step_2 }
  }

  TRANSACTION 509
  {
    REQUEST { 1,0xFD }
    REPLY   { response_code, device_status, settling_time_rising_step_2 }
  }

  TRANSACTION 510
  {
    REQUEST { 1,0xFE }
    REPLY   { response_code, device_status, dead_time_falling_2 }
  }

  TRANSACTION 511
  {
    REQUEST { 1,0xFF }
    REPLY   { response_code, device_status, time_63_falling_2 }
  }

  TRANSACTION 512
  {
    REQUEST { 2,0x00 }
    REPLY   { response_code, device_status, time_98_falling_2 }
  }

  TRANSACTION 513
  {
    REQUEST { 2,0x01 }
    REPLY   { response_code, device_status, rise_time_falling_step_2 }
  }

  TRANSACTION 514
  {
    REQUEST { 2,0x02 }
    REPLY   { response_code, device_status, settling_time_falling_step_2 }
  }

  TRANSACTION 557
  {
    REQUEST { 2,0x2D }
    REPLY   { response_code, device_status, pst_elapsed_hours_meter_next_PST_test }
  }
/* Ende PST */


  RESPONSE_CODES
  {
    0, SUCCESS,             [no_command_specific_errors];
    3, DATA_ENTRY_ERROR,	[passed_parameter_too_large];
	4, DATA_ENTRY_ERROR,	[passed_parameter_too_small];
  }
}



/* ------------------------------------------------------------------------ */
/* Command 255     PST Freigabecode schreiben                               */
/* ------------------------------------------------------------------------ */
COMMAND write_pst_enabling_code
{
  NUMBER 255;
  OPERATION WRITE;

  TRANSACTION
  {
    REQUEST { pst_enabling_code }
    REPLY   { response_code, device_status, pst_enabling_code }
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
         7, MODE_ERROR,         [in_write_protect_mode];
  }
}


/* ------------------------------------------------------------------------ */
/* Command 182     PST Ruecksetzen                                          */
/* ------------------------------------------------------------------------ */
COMMAND read_pst_reset
{
  NUMBER 182;
  OPERATION READ;

  TRANSACTION
  {
    REQUEST { }
    REPLY   { response_code, device_status, dummy_kmr }
  }

  RESPONSE_CODES
  {
		 0, SUCCESS,            [no_command_specific_errors];
		 2,	DATA_ENTRY_ERROR,	[invalid_selection];
		 5,	MISC_ERROR,		    [too_few_data_bytes_recieved];
         7, MODE_ERROR,         [in_write_protect_mode];
  }
}

/* nur fuer cmd 182 zu verwenden */
VARIABLE dummy_kmr
{
  LABEL "d_enum";
  TYPE ENUMERATED
  {
      { 0, " "}
  }
}


/* ----------- the end ---------------------------------------------------- */

