/*****************************************************************************
 *
 * $Workfile: methods.h $
 * $Revision: 1 $
 *     $Date: 11/02/02 4:51p $
 *   $Author: Wallyp $
 *
 *****************************************************************************
 * Copyright (c) 2002, HART Communication Foundation, All Rights Reserved
 *****************************************************************************
 *
 * Description: contains all the method built-in macros and definitions
 *
 *****************************************************************************
 *
 *   $History: methods.h $
 * 
 * *****************  Version 1  *****************
 * User: Wallyp       Date: 11/02/02   Time: 4:51p
 * Created in $/h6.std.dds
 * initial check into vss
 * 
 *****************************************************************************
 */


#ifndef BI_CODES_FILES
#define BI_CODES_FILES

#define BI_SUCCESS      0               /* task succeeded in intended task    */
#define BI_ERROR        -1              /* error occured in task              */
#define BI_ABORT        -2              /* user aborted task                  */
#define BI_NO_DEVICE    -3              /* no device found on comm request    */
#define BI_COMM_ERR     -4              /* communications error               */
#define BI_CONTINUE     -5              /* continue */
#define BI_RETRY        -6              /* retry */

#define N_BI_CODES      7

#define ALLBITS                 0xFF    /* sets all bits in the byte */

#define STATUS_SIZE             3       /* size of status array               */
#define STATUS_RESPONSE_CODE    0                                  
#define STATUS_COMM_STATUS      1
#define STATUS_DEVICE_STATUS    2

#define RESP_MASK_LEN           16      /* size of response code masks      */
#define DATA_MASK_LEN           25      /* size of data masks               */
#define MAX_XMTR_STATUS_LEN     DATA_MASK_LEN

#define RESPONSE_BUFFER_LENGTH  40      /* size of buffer string to place resp*/
#define BI_DISP_STR_LEN         126     /* size of # lines X # char/line in a response code display */

/*device status codes used in defaults*/
#define DEVICE_MALFUNCTION      0x80
#define CMD_NOT_IMPLIMENTED     0x40
#define ACCESS_RESTRICTED       0x10

/*
 * Send Command Error handling
 */

#define __IGNORE__  0
#define __ABORT__   1
#define __RETRY__   2

/*
 * 1) Display Message, Value, and Menu Builtins
 */
#define get_dev_var_value(a,b,c)    _get_dev_var_value((a),(b),METHODID(c))
#define GET_DEV_VAR_VALUE(a,b)      _get_dev_var_value((a),0,METHODID(b))
#define get_local_var_value(a,b,c)  _get_local_var_value((a),(b),LOCALVAR(c))
#define GET_LOCAL_VAR_VALUE(a,b)    _get_local_var_value((a),0,LOCALVAR(b))
#define display_comm_status(a)      _display_xmtr_status(METHODID(comm_status),a)
#define display_device_status(a)    _display_xmtr_status(METHODID(device_status),a)
#define display_xmtr_status(a,b)    _display_xmtr_status(METHODID(a),b)

/*
 * 2) Variable Access Builtins (Non-scaling)
 */
#define assign(a,b)                 _vassign(METHODID(a),METHODID(b))
#define vassign(a,b)                _vassign(METHODID(a),METHODID(b))

#define assign_double(a,b)          _dassign(METHODID(a),(b))
#define dassign(a,b)                _dassign(METHODID(a),(b))

#define assign_float(a,b)           _fassign(METHODID(a),(b))
#define fassign(a,b)                _fassign(METHODID(a),(b))

#define assign_int(a,b)             _iassign(METHODID(a),(b))
#define iassign(a,b)                _iassign(METHODID(a),(b))

#define assign_long(a,b)            _lassign(METHODID(a),(b))
#define lassign(a,b)                _lassign(METHODID(a),(b))

#define float_value(a)              _fvar_value(METHODID(a))
#define fvar_value(a)               _fvar_value(METHODID(a))

#define int_value(a)                _ivar_value(METHODID(a))
#define ivar_value(a)               _ivar_value(METHODID(a))

#define long_value(a)               _lvar_value(METHODID(a))
#define lvar_value(a)               _lvar_value(METHODID(a))

/*
 * 3) Communications Builtins
 */
#define get_status_code_string(a,b,c,d) _get_status_code_string(METHODID(a),(b),(c),(d))

/*
 * 4) Variable Table Value State Change Builtins
 *      Relevant to Method Termination
 */

/*
 * 5) Abort Methods Builtins
 */
#define add_abort_method(a)             _add_abort_method(METHODID(a))
#define remove_abort_method(a)          _remove_abort_method(METHODID(a))
#define remove_all_abort_methods()      remove_all_abort()

/*
 * 6) Name to ID Translation Builtins
 */
#define get_dictionary_string(a,b,c)    _get_dictionary_string(DICT_ID(a),(b),(c))
#define VARID(a)                        METHODID(a)
#define array_reference(a,b)            resolve_array_ref(METHODID(a),(b))
#define collection_reference(a,b)       resolve_record_ref(METHODID(a),(b))

/*
 * 7) Scaling Builtins
 */

/*
 * ABORT, IGNORE, RETRY Builtins
 */

#define ABORT_ON_COMM_ERROR()           _set_comm_status(0xFF,__ABORT__)
#define IGNORE_COMM_ERROR()             _set_comm_status(0xFF,__IGNORE__)
#define RETRY_ON_COMM_ERROR()           _set_comm_status(0xFF,__RETRY__)

#define ABORT_ON_ALL_COMM_STATUS()      _set_comm_status(0x7F,__ABORT__)
#define IGNORE_ALL_COMM_STATUS()        _set_comm_status(0x7F,__IGNORE__)
#define RETRY_ON_ALL_COMM_STATUS()      _set_comm_status(0x7F,__RETRY__)

#define ABORT_ON_COMM_STATUS(comm_stat) _set_comm_status((comm_stat),__ABORT__)
#define IGNORE_COMM_STATUS(comm_stat)   _set_comm_status((comm_stat),__IGNORE__)
#define RETRY_ON_COMM_STATUS(comm_stat) _set_comm_status((comm_stat),__RETRY__)


#define ABORT_ON_ALL_DEVICE_STATUS()    _set_device_status(0xFF,__ABORT__)
#define IGNORE_ALL_DEVICE_STATUS()      _set_device_status(0xFF,__IGNORE__)
#define RETRY_ON_ALL_DEVICE_STATUS()    _set_device_status(0xFF,__RETRY__)

#define ABORT_ON_DEVICE_STATUS(dev_st)  _set_device_status((dev_st),__ABORT__)
#define IGNORE_DEVICE_STATUS(dev_st)    _set_device_status((dev_st),__IGNORE__)
#define RETRY_ON_DEVICE_STATUS(dev_st)  _set_device_status((dev_st),__RETRY__)


#define ABORT_ON_ALL_RESPONSE_CODES()   _set_all_resp_code(__ABORT__)
#define IGNORE_ALL_RESPONSE_CODES()     _set_all_resp_code(__IGNORE__)
#define RETRY_ON_ALL_RESPONSE_CODES()   _set_all_resp_code(__RETRY__)

#define ABORT_ON_RESPONSE_CODE(rsp_cod) _set_resp_code((rsp_cod),__ABORT__)
#define IGNORE_RESPONSE_CODE(rsp_cod)   _set_resp_code((rsp_cod),__IGNORE__)
#define RETRY_ON_RESPONSE_CODE(rsp_cod) _set_resp_code((rsp_cod),__RETRY__)


#define ABORT_ON_NO_DEVICE()            _set_no_device(__ABORT__)
#define IGNORE_NO_DEVICE()              _set_no_device(__IGNORE__)
#define RETRY_ON_NO_DEVICE()            _set_no_device(__RETRY__)


/*
 *  XMTR - Abort, Ignore, Retry functions
 */


#define XMTR_ABORT_ON_COMM_ERROR()      _set_xmtr_comm_status(0xFF,__ABORT__)
#define XMTR_IGNORE_COMM_ERROR()        _set_xmtr_comm_status(0xFF,__IGNORE__)
#define XMTR_RETRY_ON_COMM_ERROR()      _set_xmtr_comm_status(0xFF,__RETRY__)

#define XMTR_ABORT_ON_ALL_COMM_STATUS() _set_xmtr_comm_status(0x7F,__ABORT__)
#define XMTR_IGNORE_ALL_COMM_STATUS()   _set_xmtr_comm_status(0x7F,__IGNORE__)
#define XMTR_RETRY_ON_ALL_COMM_STATUS() _set_xmtr_comm_status(0x7F,__RETRY__)

#define XMTR_ABORT_ON_COMM_STATUS(comm_st)  _set_xmtr_comm_status((comm_st),__ABORT__)
#define XMTR_IGNORE_COMM_STATUS(comm_st)    _set_xmtr_comm_status((comm_st),__IGNORE__)
#define XMTR_RETRY_ON_COMM_STATUS(comm_st)  _set_xmtr_comm_status((comm_st),__RETRY__)


#define XMTR_ABORT_ON_ALL_DEVICE_STATUS()   _set_xmtr_device_status(0xFF,__ABORT__)
#define XMTR_IGNORE_ALL_DEVICE_STATUS()     _set_xmtr_device_status(0xFF,__IGNORE__)
#define XMTR_RETRY_ON_ALL_DEVICE_STATUS()   _set_xmtr_device_status(0xFF,__RETRY__)

#define XMTR_ABORT_ON_DEVICE_STATUS(dev_st) _set_xmtr_device_status((dev_st),__ABORT__)
#define XMTR_IGNORE_DEVICE_STATUS(dev_st)   _set_xmtr_device_status((dev_st),__IGNORE__)
#define XMTR_RETRY_ON_DEVICE_STATUS(dev_st) _set_xmtr_device_status((dev_st),__RETRY__)


#define XMTR_ABORT_ON_ALL_RESPONSE_CODES()  _set_xmtr_all_resp_code(__ABORT__)
#define XMTR_IGNORE_ALL_RESPONSE_CODES()    _set_xmtr_all_resp_code(__IGNORE__)
#define XMTR_RETRY_ON_ALL_RESPONSE_CODES()  _set_xmtr_all_resp_code(__RETRY__)

#define XMTR_ABORT_ON_RESPONSE_CODE(rsp_cd) _set_xmtr_resp_code((rsp_cd),__ABORT__)
#define XMTR_IGNORE_RESPONSE_CODE(rsp_cd)   _set_xmtr_resp_code((rsp_cd),__IGNORE__)
#define XMTR_RETRY_ON_RESPONSE_CODE(rsp_cd) _set_xmtr_resp_code((rsp_cd),__RETRY__)


#define XMTR_ABORT_ON_NO_DEVICE()       _set_xmtr_no_device(__ABORT__)
#define XMTR_IGNORE_NO_DEVICE()         _set_xmtr_no_device(__IGNORE__)
#define XMTR_RETRY_ON_NO_DEVICE()       _set_xmtr_no_device(__RETRY__)


#define XMTR_ABORT_ON_ALL_DATA()        _set_xmtr_all_data(__ABORT__)
#define XMTR_IGNORE_ALL_DATA()          _set_xmtr_all_data(__IGNORE__)
#define XMTR_RETRY_ON_ALL_DATA()        _set_xmtr_all_data(__RETRY__)

#define XMTR_ABORT_ON_DATA(byte,bit)    _set_xmtr_data((byte),(bit),__ABORT__)
#define XMTR_IGNORE_DATA(byte,bit)      _set_xmtr_data((byte),(bit),__IGNORE__)
#define XMTR_RETRY_ON_DATA(byte,bit)    _set_xmtr_data((byte),(bit),__RETRY__)


/* ADDED BY KIM */
#define assign_var(a,b)                     _vassign(VARID(a),VARID(b))
#define NaN                                 NaN_value()

#endif
