/*--------------------------------------------------------------*/
/*  Copyright (C)   SAMSON AG (2006). All Rights Reserved       */
/*  Product:        SIEMENS SIMATIC PDM                         */
/*  Device:         SAMSON PROFIBUS Positioner 373X-4           */
/*  Communication:  PROFIBUS PA/DPV1 Profil 3.01                */
/*  Dictionary:     SIPADC01.dct                                */
/*  Description:    Device Description                          */
/*                                                              */
/*  $Revision:   1.3  $                                         */
/*  $Date:   01 Oct 1999 19:49:52  $                            */
/*--------------------------------------------------------------*/
/* Datum:     Autor:  Aenderungen:                              */
/* ------     ------  ------------                              */
/* 28.04.2005 Kmr/E82 Erste Version fuer 373X-4.                */
/*                    (Grundlage: 3785 Profil 3 DD)             */
/* 19.09.2006 Kmr/E82 Fertigstellung der DD;                    */
/*                    phys_device_man_id wird nur in PDM 5      */
/*                    angezeigt/eingelesen (sonst Fehler bei    */
/*                    Komplett-Einlesen)                        */
/* 08.08.2007 Kmr/E82 Schreibbarkeit von                        */
/*                    trans1_manufac_actuator_size abh. gemacht.*/
/* 10.09.2007 Kmr/E82 std_NodeAddress fuer Busadresse           */
/* 02.03.2009 Kmr/E82 OnlineWindow_ statt OnlineDialog_ ,       */
/*                    dadurch mehr nicht modale Fenster.        */
/*                                                              */
/*                                                              */
/*                                                              */
/*--------------------------------------------------------------*/
MANUFACTURER         66,   /* SAMSON */
DEVICE_TYPE           4,
DEVICE_REVISION       1,
DD_REVISION           1


/* --------------------------------------*/
// - mittels ADD_U8_1 kann die Ausfuehrzeit der Applikation bestimmt werden
//   Dies muss zuvor mit feature_select bit 2 freigeschaltet werden
/* --------------------------------------*/

#define CHECK_PROFILE_REV           0x300

/* Antworten von func1_target_mode */
#define BLOCK_MODE_RCAS             0x02
#define BLOCK_MODE_AUTO             0x08
#define BLOCK_MODE_MAN              0x10
#define BLOCK_MODE_LOCAL_OVERRIDE   0x20
#define BLOCK_MODE_OUT_OF_SERVICE   0x80

/* Herstellerspezifische Defines */
#define HUBANTRIEB       0
#define SCHWENKANTRIEB   1

#define INTEGRIERT       0
#define NAMUR            1

#define AUTO             0
#define HAND             1
#define SICHER           2

#define NICHT_VORHANDEN  0
#define VORHANDEN        1
#define INDUKTIV         1
#define SOFTWARE         2

/* Codes fuer trans1_self_calibration_cmd */
#define NO_TEST             0
#define NULLP_CAL           4
#define INIT                2
#define WEGINT_RESET        7
#define INIT_ERW           20
#define INIT_IMP           21
#define KALTSTART           1
#define ABBRUCH             3

#define NOT_IMPLEMENTED      0
#define IMPLEMENTED          1

/* Parameter Stiftposition */
#define PIN_POS_OFF          0
#define PIN_POS_17_MM        1
#define PIN_POS_25_MM        2
#define PIN_POS_35_MM        3
#define PIN_POS_50_MM        4
#define PIN_POS_70_MM        5
#define PIN_POS_100_MM       6
#define PIN_POS_200_MM       8
#define PIN_POS_90_GRAD      9

#define INIT_ART_MAX   0
#define INIT_ART_NOM   1
#define INIT_ART_MAN   2
#define INIT_ART_SUB   3
#define INIT_ART_ZERO_POINT 4

/* Parameter Bewegungsrichtung */
#define BEWEG_STEIGEND_STEIGEND     0
#define BEWEG_STEIGEND_FALLEND      1

#define DIAG_LEVEL_EXPERT            0
#define DIAG_LEVEL_EXPERT_PLUS       1
#define DIAG_LEVEL_EXPERT_PLUS_PLUS  2
#define DIAG_LEVEL_ESD               3


/********************************************************************************/
/* Define fr Test auf HW- oder SW-Schreibschutz in den Methoden                */
/*   In der Methode mssen die Variablen HWwrProt und SWwrProt definiert sein ! */
#define CHECK_WRITE_PROTECTION                                                         \
        ReadCommand (read_phys_write_locking);       /* SW-Schreibschutz auslesen */   \
        SWwrProt = ivar_value (phys_write_locking);                                    \
        ReadCommand (read_phys_hw_write_protection); /* HW-Schreibschutz auslesen */   \
        HWwrProt = ivar_value (phys_hw_write_protection);                              \
        if (HWwrProt == 1)       /* wenn HW-Schreibschutz aktiv */                     \
        {                                                                              \
            ACKNOWLEDGE("Device is write protected (hardware write protection)."       \
                        "|de|Gert ist schreibgeschtzt (Hardware-Schreibschutz).");   \
        }                                                                              \
        if (SWwrProt == 0)       /* wenn SW-Schreibschutz aktiv */                     \
        {                                                                              \
            ACKNOWLEDGE("Device is write protected (software write protection)."       \
                        "|de|Gert ist schreibgeschtzt (Software-Schreibschutz).");   \
        }                                                                              \
        if (HWwrProt == 1 || SWwrProt == 0) /* wenn HW- ODER SW-Schreibschutz aktiv */ \
        {                                                                              \
            process_abort(); /* Abbruch der Methode */                                 \
        }


/* ------------------------------------------------------------------------ */
/* nur sichtbar wenn Diagnose-Level EXPERT+ enthaelt */

/* Umschaltung zwischen EXPERT und EXPERT+ Parameter */
#define VALIDITY_ONLY_EXPERT_PLUS                               \
  VALIDITY                                                      \
    IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) || \
        ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) || \
        ( trans1_diag_level == DIAG_LEVEL_ESD              ))   \
    { TRUE; }                                                   \
    ELSE                                                        \
    { FALSE; }



/********************************************************************************/
/* Define fr Standardfunktionen am Beginn einer Methode */
#define FUNCTIONS_IGNORE_XXX          \
        IGNORE_ALL_COMM_STATUS();     \
        IGNORE_ALL_DEVICE_STATUS();   \
        IGNORE_ALL_RESPONSE_CODES();  \
        IGNORE_COMM_ERROR();

/********************************************************************************/
/* Define fr Statusmeldungen BAD, UNCERTAIN und GOOD nach Profil 3 */
#define STATUS_BAD_UNCERTAIN_GOOD                      \
/* bad */                                              \
        {   0,  [bad_0]         },                     \
        {   4,  [bad_4]         },                     \
        {   8,  [bad_8]         },                     \
        {   12, [bad_12]        },                     \
        {   16, [bad_16]        },                     \
        {   20, [bad_20]        },                     \
        {   24, [bad_24]        },                     \
        {   28, [bad_28]        },                     \
/* uncertain */                                        \
        {   64, [uncertain_64]  },                     \
        {   68, [uncertain_68]  },                     \
        {   72, [uncertain_72]  },                     \
        {   76, [uncertain_76]  },                     \
        {   80, [uncertain_80]  },                     \
        {   84, [uncertain_84]  },                     \
        {   88, [uncertain_88]  },                     \
        {   92, [uncertain_92]  },                     \
        {   96, "Uncertain, simulated value"           \
                "|de|Unsicher, Simulationswert"     }, \
        {  100, "Uncertain, sensor calibration"        \
                "|de|Unsicher, Sensor-Kalibrierung" }, \
/* good */                                             \
        {   128,[good_128]      },                     \
        {   132,[good_132]      },                     \
        {   136,[good_136]      },                     \
        {   140,[good_140]      },                     \
        {   144,[good_144]      },                     \
        {   148,[good_148]      },                     \
        {   152,[good_152]      },                     \
        {   160,[good_160]      },                     \
        {   164, "Good, maintenance required"          \
                 "|de|Gut, Wartungsbedarf" }           \

/********************************************************************************/
/* Define nur fr Statusmeldungen GOOD (CASCADE) nach Profil 3 */
/*  (zum Anhngen an STATUS_BAD_UNCERTAIN_GOOD)  */
#define STATUS_GOOD_CASCADE          \
                                     \
/* good (cascade) */                 \
        {   192,[good_192]      },   \
        {   196,[good_196]      },   \
        {   200,[good_200]      },   \
        {   204,[good_204]      },   \
        {   208,[good_208]      },   \
        {   212,[good_212]      },   \
        {   216,[good_216]      },   \
        {   220,[good_220]      },   \
        {   224,[good_224]      }

/********************************************************************************/
/* Define fr Statusmeldungen BAD, UNCERTAIN und GOOD nach Profil 3 */
/* (Nur fr maskierte Stati ! Wegen Limit-Bits um 2 Bits nach rechts verschoben) */
#define STATUS_BAD_UNCERTAIN_GOOD_MASK                  \
/* bad */                                               \
        {   0,  [bad_0]         },                      \
        {   1,  [bad_4]         },                      \
        {   2,  [bad_8]         },                      \
        {   3, [bad_12]         },                      \
        {   4, [bad_16]         },                      \
        {   5, [bad_20]         },                      \
        {   6, [bad_24]         },                      \
        {   7, [bad_28]         },                      \
/* Anpassung an Profile 3.01 - Anhaenge cond. Status */ \
/*#define BAD_PASSIVATED       0x23       */            \
/*#define BAD_MAINT_ALARM_MORE_DIAG  0x24 */            \
/*#define BAD_PR_NO_MAINT       0x2B    */              \
/*#define BAD_FUNCTION_CHECK_LO    0x3c */              \
        {   8, "Bad, passivated" "|de|Schlecht, Gert passiviert" },                                             \
        {   9, "Bad, maintenance alarm more diagnosis available" "|de|Schlecht, Ausfall - Diagnose verfgbar" }, \
        {  10, "Bad, prozess related no maintenance"  "|de|Schlecht, auerhalb der Spezifikation"           },   \
        {  15, "Bad, function check local override" "|de|Schlecht, Funktionskontrolle"  },                       \
                                                        \
/* uncertain */                                         \
        {   16, [uncertain_64]  },                      \
        {   17, [uncertain_68]  },                      \
        {   18, [uncertain_72]  },                      \
        {   19, [uncertain_76]  },                      \
        {   20, [uncertain_80]  },                      \
        {   21, [uncertain_84]  },                      \
        {   22, [uncertain_88]  },                      \
        {   23, [uncertain_92]  },                      \
        {   24, "Uncertain, simulated value"            \
                "|de|Unsicher, Simulationswert"     },  \
        {   25, "Uncertain, sensor calibration"         \
                "|de|Unsicher, Sensor-Kalibrierung" },  \
/* Anpassung an Profile 3.01 - Anhaenge cond. Status */ \
/*#define UNCERTAIN_MAINT_DEMANDED 		0x68 */         \
/*#define UNCERTAIN_SIMU_VAL_START		0x73 */         \
/*#define UNCERTAIN_SIMU_VAL_END	    0x74 */         \
/*#define UNCERTAIN_PR_NO_MAINT			0x78 */         \
        {  26, "Uncertain, maintenance demanded" "|de|Unsicher, Wartungsanforderung" },                    \
        {  28, "Uncertain, simulated value, start" "|de|Unsicher, simulierter Wert, Start" },              \
        {  29, "Uncertain, simulated value, end" "|de|Unsicher, simulierter Wert, Ende" },                 \
        {  30, "Uncertain, process related no maintenance" "|de|Unsicher, prozessbedingt keine Wartung" }, \
                                                        \
/* good */                                              \
        {   32, [good_128]      },                      \
        {   33, [good_132]      },                      \
        {   34, [good_136]      },                      \
        {   35, [good_140]      },                      \
        {   36, [good_144]      },                      \
        {   37, [good_148]      },                      \
        {   38, [good_152]      },                      \
        {   40, [good_160]      },                      \
        {   41, "Good, maintenance required" "|de|Gut, Wartungsbedarf" },       \
/*Anpassung an Profile 3.01 - Anhaenge cond. Status  */                         \
/* #define GOOD_MAINT_DEMANDED      0xA8 */                                     \
/* #define GOOD_FUNCTION_CHECK     0xBC  */                                     \
        {   42, "Good, maintenance demanded" "|de|Gut, Wartungsanforderung" },  \
        {   47, "Good, function check" "|de|Gut, Funktionskontrolle" }


/********************************************************************************/
/* Define nur fr Statusmeldungen GOOD (CASCADE) nach Profil 3 */
/*  (zum Anhngen an STATUS_BAD_UNCERTAIN_GOOD)  */
#define STATUS_GOOD_CASCADE_MASK    \
                                 ,  \
/* good (cascade) */                \
        {   48,[good_192]      },   \
        {   49,[good_196]      },   \
        {   50,[good_200]      },   \
        {   51,[good_204]      },   \
        {   52,[good_208]      },   \
        {   53,[good_212]      },   \
        {   54,[good_216]      },   \
        {   55,[good_220]      },   \
        {   56,[good_224]      }

/********************************************************************************/
/* Fr Status Quality / Limit Verarbeitung */
#define STATUS_LIMIT                                \
        { 0x00, [status_limit_OK]               },  \
        { 0x01, [status_limit_UNDERFLOW]        },  \
        { 0x02, [status_limit_OVERFLOW]         },  \
        { 0x03, [status_limit_VALUE_CONSTANT]   }

/********************************************************************************/
/* fr Methode methodOpenDeviceManual_3730: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3730     "e83844en.pdf"  \
                                    "|de|e83844de.pdf"

/* wenn verfuegbar:                 "|fr|e83844de.pdf"  \
                                    "|it|e83844de.pdf"  \
                                    "|es|e83844de.pdf"*/

/* fr Methode methodOpenDeviceManual_3731: EB im pdf-Format */
#define DEVICE_MANUAL_FILENAME_3731 "xxxxxen.pdf"       \
                                    "|de|xxxxxde.pdf"

/* fr Methode methodOpenValveDiagnostics: Ventildiagnose Doku im pdf-Format */
#define VALVE_DIAGNOSTICS_FILENAME "e83880en.pdf"       \
                               "|de|e83880de.pdf"

/********************************************************************************/



/********************************************************************************/

/********************************************************************************/
/* defines fr units                                                            */
/********************************************************************************/


#define UNIT_LIST                                       \
        { 1000, [unit_1000],    [unit_1000_help]    },  \
        { 1001, [unit_1001],    [unit_1001_help]    },  \
        { 1002, [unit_1002],    [unit_1002_help]    },  \
        { 1003, [unit_1003],    [unit_1003_help]    },  \
        { 1004, [unit_1004],    [unit_1004_help]    },  \
        { 1005, [unit_1005],    [unit_1005_help]    },  \
        { 1006, [unit_1006],    [unit_1006_help]    },  \
        { 1007, [unit_1007],    [unit_1007_help]    },  \
        { 1008, [unit_1008],    [unit_1008_help]    },  \
        { 1009, [unit_1009],    [unit_1009_help]    },  \
        { 1010, [unit_1010],    [unit_1010_help]    },  \
        { 1011, [unit_1011],    [unit_1011_help]    },  \
        { 1012, [unit_1012],    [unit_1012_help]    },  \
        { 1013, [unit_1013],    [unit_1013_help]    },  \
        { 1014, [unit_1014],    [unit_1014_help]    },  \
        { 1015, [unit_1015],    [unit_1015_help]    },  \
        { 1016, [unit_1016],    [unit_1016_help]    },  \
        { 1017, [unit_1017],    [unit_1017_help]    },  \
        { 1018, [unit_1018],    [unit_1018_help]    },  \
        { 1019, [unit_1019],    [unit_1019_help]    },  \
        { 1020, [unit_1020],    [unit_1020_help]    },  \
        { 1021, [unit_1021],    [unit_1021_help]    },  \
        { 1022, [unit_1022],    [unit_1022_help]    },  \
        { 1023, [unit_1023],    [unit_1023_help]    },  \
        { 1024, [unit_1024],    [unit_1024_help]    },  \
        { 1025, [unit_1025],    [unit_1025_help]    },  \
        { 1026, [unit_1026],    [unit_1026_help]    },  \
        { 1027, [unit_1027],    [unit_1027_help]    },  \
        { 1028, [unit_1028],    [unit_1028_help]    },  \
        { 1029, [unit_1029],    [unit_1029_help]    },  \
        { 1030, [unit_1030],    [unit_1030_help]    },  \
        { 1031, [unit_1031],    [unit_1031_help]    },  \
        { 1032, [unit_1032],    [unit_1032_help]    },  \
        { 1033, [unit_1033],    [unit_1033_help]    },  \
        { 1034, [unit_1034],    [unit_1034_help]    },  \
        { 1035, [unit_1035],    [unit_1035_help]    },  \
        { 1036, [unit_1036],    [unit_1036_help]    },  \
        { 1037, [unit_1037],    [unit_1037_help]    },  \
        { 1038, [unit_1038],    [unit_1038_help]    },  \
        { 1039, [unit_1039],    [unit_1039_help]    },  \
        { 1040, [unit_1040],    [unit_1040_help]    },  \
        { 1041, [unit_1041],    [unit_1041_help]    },  \
        { 1042, [unit_1042],    [unit_1042_help]    },  \
        { 1043, [unit_1043],    [unit_1043_help]    },  \
        { 1044, [unit_1044],    [unit_1044_help]    },  \
        { 1045, [unit_1045],    [unit_1045_help]    },  \
        { 1046, [unit_1046],    [unit_1046_help]    },  \
        { 1047, [unit_1047],    [unit_1047_help]    },  \
        { 1048, [unit_1048],    [unit_1048_help]    },  \
        { 1049, [unit_1049],    [unit_1049_help]    },  \
        { 1050, [unit_1050],    [unit_1050_help]    },  \
        { 1051, [unit_1051],    [unit_1051_help]    },  \
        { 1052, [unit_1052],    [unit_1052_help]    },  \
        { 1053, [unit_1053],    [unit_1053_help]    },  \
        { 1054, [unit_1054],    [unit_1054_help]    },  \
        { 1055, [unit_1055],    [unit_1055_help]    },  \
        { 1056, [unit_1056],    [unit_1056_help]    },  \
        { 1057, [unit_1057],    [unit_1057_help]    },  \
        { 1058, [unit_1058],    [unit_1058_help]    },  \
        { 1059, [unit_1059],    [unit_1059_help]    },  \
        { 1060, [unit_1060],    [unit_1060_help]    },  \
        { 1061, [unit_1061],    [unit_1061_help]    },  \
        { 1062, [unit_1062],    [unit_1062_help]    },  \
        { 1063, [unit_1063],    [unit_1063_help]    },  \
        { 1064, [unit_1064],    [unit_1064_help]    },  \
        { 1065, [unit_1065],    [unit_1065_help]    },  \
        { 1066, [unit_1066],    [unit_1066_help]    },  \
        { 1067, [unit_1067],    [unit_1067_help]    },  \
        { 1068, [unit_1068],    [unit_1068_help]    },  \
        { 1069, [unit_1069],    [unit_1069_help]    },  \
        { 1070, [unit_1070],    [unit_1070_help]    },  \
        { 1071, [unit_1071],    [unit_1071_help]    },  \
        { 1072, [unit_1072],    [unit_1072_help]    },  \
        { 1073, [unit_1073],    [unit_1073_help]    },  \
        { 1074, [unit_1074],    [unit_1074_help]    },  \
        { 1075, [unit_1075],    [unit_1075_help]    },  \
        { 1076, [unit_1076],    [unit_1076_help]    },  \
        { 1077, [unit_1077],    [unit_1077_help]    },  \
        { 1078, [unit_1078],    [unit_1078_help]    },  \
        { 1079, [unit_1079],    [unit_1079_help]    },  \
        { 1080, [unit_1080],    [unit_1080_help]    },  \
        { 1081, [unit_1081],    [unit_1081_help]    },  \
        { 1082, [unit_1082],    [unit_1082_help]    },  \
        { 1083, [unit_1083],    [unit_1083_help]    },  \
        { 1084, [unit_1084],    [unit_1084_help]    },  \
        { 1085, [unit_1085],    [unit_1085_help]    },  \
        { 1086, [unit_1086],    [unit_1086_help]    },  \
        { 1087, [unit_1087],    [unit_1087_help]    },  \
        { 1088, [unit_1088],    [unit_1088_help]    },  \
        { 1089, [unit_1089],    [unit_1089_help]    },  \
        { 1090, [unit_1090],    [unit_1090_help]    },  \
        { 1091, [unit_1091],    [unit_1091_help]    },  \
        { 1092, [unit_1092],    [unit_1092_help]    },  \
        { 1093, [unit_1093],    [unit_1093_help]    },  \
        { 1094, [unit_1094],    [unit_1094_help]    },  \
        { 1095, [unit_1095],    [unit_1095_help]    },  \
        { 1096, [unit_1096],    [unit_1096_help]    },  \
        { 1097, [unit_1097],    [unit_1097_help]    },  \
        { 1098, [unit_1098],    [unit_1098_help]    },  \
        { 1099, [unit_1099],    [unit_1099_help]    },  \
        { 1100, [unit_1100],    [unit_1100_help]    },  \
        { 1101, [unit_1101],    [unit_1101_help]    },  \
        { 1102, [unit_1102],    [unit_1102_help]    },  \
        { 1103, [unit_1103],    [unit_1103_help]    },  \
        { 1104, [unit_1104],    [unit_1104_help]    },  \
        { 1105, [unit_1105],    [unit_1105_help]    },  \
        { 1106, [unit_1106],    [unit_1106_help]    },  \
        { 1107, [unit_1107],    [unit_1107_help]    },  \
        { 1108, [unit_1108],    [unit_1108_help]    },  \
        { 1109, [unit_1109],    [unit_1109_help]    },  \
        { 1110, [unit_1110],    [unit_1110_help]    },  \
        { 1111, [unit_1111],    [unit_1111_help]    },  \
        { 1112, [unit_1112],    [unit_1112_help]    },  \
        { 1113, [unit_1113],    [unit_1113_help]    },  \
        { 1114, [unit_1114],    [unit_1114_help]    },  \
        { 1115, [unit_1115],    [unit_1115_help]    },  \
        { 1116, [unit_1116],    [unit_1116_help]    },  \
        { 1117, [unit_1117],    [unit_1117_help]    },  \
        { 1118, [unit_1118],    [unit_1118_help]    },  \
        { 1119, [unit_1119],    [unit_1119_help]    },  \
        { 1120, [unit_1120],    [unit_1120_help]    },  \
        { 1121, [unit_1121],    [unit_1121_help]    },  \
        { 1122, [unit_1122],    [unit_1122_help]    },  \
        { 1123, [unit_1123],    [unit_1123_help]    },  \
        { 1124, [unit_1124],    [unit_1124_help]    },  \
        { 1125, [unit_1125],    [unit_1125_help]    },  \
        { 1126, [unit_1126],    [unit_1126_help]    },  \
        { 1127, [unit_1127],    [unit_1127_help]    },  \
        { 1128, [unit_1128],    [unit_1128_help]    },  \
        { 1129, [unit_1129],    [unit_1129_help]    },  \
        { 1130, [unit_1130],    [unit_1130_help]    },  \
        { 1131, [unit_1131],    [unit_1131_help]    },  \
        { 1132, [unit_1132],    [unit_1132_help]    },  \
        { 1133, [unit_1133],    [unit_1133_help]    },  \
        { 1134, [unit_1134],    [unit_1134_help]    },  \
        { 1135, [unit_1135],    [unit_1135_help]    },  \
        { 1136, [unit_1136],    [unit_1136_help]    },  \
        { 1137, [unit_1137],    [unit_1137_help]    },  \
        { 1138, [unit_1138],    [unit_1138_help]    },  \
        { 1139, [unit_1139],    [unit_1139_help]    },  \
        { 1140, [unit_1140],    [unit_1140_help]    },  \
        { 1141, [unit_1141],    [unit_1141_help]    },  \
        { 1142, [unit_1142],    [unit_1142_help]    },  \
        { 1143, [unit_1143],    [unit_1143_help]    },  \
        { 1144, [unit_1144],    [unit_1144_help]    },  \
        { 1145, [unit_1145],    [unit_1145_help]    },  \
        { 1146, [unit_1146],    [unit_1146_help]    },  \
        { 1147, [unit_1147],    [unit_1147_help]    },  \
        { 1148, [unit_1148],    [unit_1148_help]    },  \
        { 1149, [unit_1149],    [unit_1149_help]    },  \
        { 1150, [unit_1150],    [unit_1150_help]    },  \
        { 1151, [unit_1151],    [unit_1151_help]    },  \
        { 1152, [unit_1152],    [unit_1152_help]    },  \
        { 1153, [unit_1153],    [unit_1153_help]    },  \
        { 1154, [unit_1154],    [unit_1154_help]    },  \
        { 1155, [unit_1155],    [unit_1155_help]    },  \
        { 1156, [unit_1156],    [unit_1156_help]    },  \
        { 1157, [unit_1157],    [unit_1157_help]    },  \
        { 1158, [unit_1158],    [unit_1158_help]    },  \
        { 1159, [unit_1159],    [unit_1159_help]    },  \
        { 1160, [unit_1160],    [unit_1160_help]    },  \
        { 1161, [unit_1161],    [unit_1161_help]    },  \
        { 1162, [unit_1162],    [unit_1162_help]    },  \
        { 1163, [unit_1163],    [unit_1163_help]    },  \
        { 1164, [unit_1164],    [unit_1164_help]    },  \
        { 1165, [unit_1165],    [unit_1165_help]    },  \
        { 1166, [unit_1166],    [unit_1166_help]    },  \
        { 1167, [unit_1167],    [unit_1167_help]    },  \
        { 1168, [unit_1168],    [unit_1168_help]    },  \
        { 1169, [unit_1169],    [unit_1169_help]    },  \
        { 1170, [unit_1170],    [unit_1170_help]    },  \
        { 1171, [unit_1171],    [unit_1171_help]    },  \
        { 1172, [unit_1172],    [unit_1172_help]    },  \
        { 1173, [unit_1173],    [unit_1173_help]    },  \
        { 1174, [unit_1174],    [unit_1174_help]    },  \
        { 1175, [unit_1175],    [unit_1175_help]    },  \
        { 1176, [unit_1176],    [unit_1176_help]    },  \
        { 1177, [unit_1177],    [unit_1177_help]    },  \
        { 1178, [unit_1178],    [unit_1178_help]    },  \
        { 1179, [unit_1179],    [unit_1179_help]    },  \
        { 1180, [unit_1180],    [unit_1180_help]    },  \
        { 1181, [unit_1181],    [unit_1181_help]    },  \
        { 1182, [unit_1182],    [unit_1182_help]    },  \
        { 1183, [unit_1183],    [unit_1183_help]    },  \
        { 1184, [unit_1184],    [unit_1184_help]    },  \
        { 1185, [unit_1185],    [unit_1185_help]    },  \
        { 1186, [unit_1186],    [unit_1186_help]    },  \
        { 1187, [unit_1187],    [unit_1187_help]    },  \
        { 1188, [unit_1188],    [unit_1188_help]    },  \
        { 1189, [unit_1189],    [unit_1189_help]    },  \
        { 1190, [unit_1190],    [unit_1190_help]    },  \
        { 1191, [unit_1191],    [unit_1191_help]    },  \
        { 1192, [unit_1192],    [unit_1192_help]    },  \
        { 1193, [unit_1193],    [unit_1193_help]    },  \
        { 1194, [unit_1194],    [unit_1194_help]    },  \
        { 1195, [unit_1195],    [unit_1195_help]    },  \
        { 1196, [unit_1196],    [unit_1196_help]    },  \
        { 1197, [unit_1197],    [unit_1197_help]    },  \
        { 1198, [unit_1198],    [unit_1198_help]    },  \
        { 1199, [unit_1199],    [unit_1199_help]    },  \
        { 1200, [unit_1200],    [unit_1200_help]    },  \
        { 1201, [unit_1201],    [unit_1201_help]    },  \
        { 1202, [unit_1202],    [unit_1202_help]    },  \
        { 1203, [unit_1203],    [unit_1203_help]    },  \
        { 1204, [unit_1204],    [unit_1204_help]    },  \
        { 1205, [unit_1205],    [unit_1205_help]    },  \
        { 1206, [unit_1206],    [unit_1206_help]    },  \
        { 1207, [unit_1207],    [unit_1207_help]    },  \
        { 1208, [unit_1208],    [unit_1208_help]    },  \
        { 1209, [unit_1209],    [unit_1209_help]    },  \
        { 1210, [unit_1210],    [unit_1210_help]    },  \
        { 1211, [unit_1211],    [unit_1211_help]    },  \
        { 1212, [unit_1212],    [unit_1212_help]    },  \
        { 1213, [unit_1213],    [unit_1213_help]    },  \
        { 1214, [unit_1214],    [unit_1214_help]    },  \
        { 1215, [unit_1215],    [unit_1215_help]    },  \
        { 1216, [unit_1216],    [unit_1216_help]    },  \
        { 1217, [unit_1217],    [unit_1217_help]    },  \
        { 1218, [unit_1218],    [unit_1218_help]    },  \
        { 1219, [unit_1219],    [unit_1219_help]    },  \
        { 1220, [unit_1220],    [unit_1220_help]    },  \
        { 1221, [unit_1221],    [unit_1221_help]    },  \
        { 1222, [unit_1222],    [unit_1222_help]    },  \
        { 1223, [unit_1223],    [unit_1223_help]    },  \
        { 1224, [unit_1224],    [unit_1224_help]    },  \
        { 1225, [unit_1225],    [unit_1225_help]    },  \
        { 1226, [unit_1226],    [unit_1226_help]    },  \
        { 1227, [unit_1227],    [unit_1227_help]    },  \
        { 1228, [unit_1228],    [unit_1228_help]    },  \
        { 1229, [unit_1229],    [unit_1229_help]    },  \
        { 1230, [unit_1230],    [unit_1230_help]    },  \
        { 1231, [unit_1231],    [unit_1231_help]    },  \
        { 1232, [unit_1232],    [unit_1232_help]    },  \
        { 1233, [unit_1233],    [unit_1233_help]    },  \
        { 1234, [unit_1234],    [unit_1234_help]    },  \
        { 1235, [unit_1235],    [unit_1235_help]    },  \
        { 1236, [unit_1236],    [unit_1236_help]    },  \
        { 1237, [unit_1237],    [unit_1237_help]    },  \
        { 1238, [unit_1238],    [unit_1238_help]    },  \
        { 1239, [unit_1239],    [unit_1239_help]    },  \
        { 1240, [unit_1240],    [unit_1240_help]    },  \
        { 1241, [unit_1241],    [unit_1241_help]    },  \
        { 1242, [unit_1242],    [unit_1242_help]    },  \
        { 1243, [unit_1243],    [unit_1243_help]    },  \
        { 1244, [unit_1244],    [unit_1244_help]    },  \
        { 1245, [unit_1245],    [unit_1245_help]    },  \
        { 1246, [unit_1246],    [unit_1246_help]    },  \
        { 1247, [unit_1247],    [unit_1247_help]    },  \
        { 1248, [unit_1248],    [unit_1248_help]    },  \
        { 1249, [unit_1249],    [unit_1249_help]    },  \
        { 1250, [unit_1250],    [unit_1250_help]    },  \
        { 1251, [unit_1251],    [unit_1251_help]    },  \
        { 1252, [unit_1252],    [unit_1252_help]    },  \
        { 1253, [unit_1253],    [unit_1253_help]    },  \
        { 1254, [unit_1254],    [unit_1254_help]    },  \
        { 1255, [unit_1255],    [unit_1255_help]    },  \
        { 1256, [unit_1256],    [unit_1256_help]    },  \
        { 1257, [unit_1257],    [unit_1257_help]    },  \
        { 1258, [unit_1258],    [unit_1258_help]    },  \
        { 1259, [unit_1259],    [unit_1259_help]    },  \
        { 1260, [unit_1260],    [unit_1260_help]    },  \
        { 1261, [unit_1261],    [unit_1261_help]    },  \
        { 1262, [unit_1262],    [unit_1262_help]    },  \
        { 1263, [unit_1263],    [unit_1263_help]    },  \
        { 1264, [unit_1264],    [unit_1264_help]    },  \
        { 1265, [unit_1265],    [unit_1265_help]    },  \
        { 1266, [unit_1266],    [unit_1266_help]    },  \
        { 1267, [unit_1267],    [unit_1267_help]    },  \
        { 1268, [unit_1268],    [unit_1268_help]    },  \
        { 1269, [unit_1269],    [unit_1269_help]    },  \
        { 1270, [unit_1270],    [unit_1270_help]    },  \
        { 1271, [unit_1271],    [unit_1271_help]    },  \
        { 1272, [unit_1272],    [unit_1272_help]    },  \
        { 1273, [unit_1273],    [unit_1273_help]    },  \
        { 1274, [unit_1274],    [unit_1274_help]    },  \
        { 1275, [unit_1275],    [unit_1275_help]    },  \
        { 1276, [unit_1276],    [unit_1276_help]    },  \
        { 1277, [unit_1277],    [unit_1277_help]    },  \
        { 1278, [unit_1278],    [unit_1278_help]    },  \
        { 1279, [unit_1279],    [unit_1279_help]    },  \
        { 1280, [unit_1280],    [unit_1280_help]    },  \
        { 1281, [unit_1281],    [unit_1281_help]    },  \
        { 1282, [unit_1282],    [unit_1282_help]    },  \
        { 1283, [unit_1283],    [unit_1283_help]    },  \
        { 1284, [unit_1284],    [unit_1284_help]    },  \
        { 1285, [unit_1285],    [unit_1285_help]    },  \
        { 1286, [unit_1286],    [unit_1286_help]    },  \
        { 1287, [unit_1287],    [unit_1287_help]    },  \
        { 1288, [unit_1288],    [unit_1288_help]    },  \
        { 1289, [unit_1289],    [unit_1289_help]    },  \
        { 1290, [unit_1290],    [unit_1290_help]    },  \
        { 1291, [unit_1291],    [unit_1291_help]    },  \
        { 1292, [unit_1292],    [unit_1292_help]    },  \
        { 1293, [unit_1293],    [unit_1293_help]    },  \
        { 1294, [unit_1294],    [unit_1294_help]    },  \
        { 1295, [unit_1295],    [unit_1295_help]    },  \
        { 1296, [unit_1296],    [unit_1296_help]    },  \
        { 1297, [unit_1297],    [unit_1297_help]    },  \
        { 1298, [unit_1298],    [unit_1298_help]    },  \
        { 1299, [unit_1299],    [unit_1299_help]    },  \
        { 1300, [unit_1300],    [unit_1300_help]    },  \
        { 1301, [unit_1301],    [unit_1301_help]    },  \
        { 1302, [unit_1302],    [unit_1302_help]    },  \
        { 1303, [unit_1303],    [unit_1303_help]    },  \
        { 1304, [unit_1304],    [unit_1304_help]    },  \
        { 1305, [unit_1305],    [unit_1305_help]    },  \
        { 1306, [unit_1306],    [unit_1306_help]    },  \
        { 1307, [unit_1307],    [unit_1307_help]    },  \
        { 1308, [unit_1308],    [unit_1308_help]    },  \
        { 1309, [unit_1309],    [unit_1309_help]    },  \
        { 1310, [unit_1310],    [unit_1310_help]    },  \
        { 1311, [unit_1311],    [unit_1311_help]    },  \
        { 1312, [unit_1312],    [unit_1312_help]    },  \
        { 1313, [unit_1313],    [unit_1313_help]    },  \
        { 1314, [unit_1314],    [unit_1314_help]    },  \
        { 1315, [unit_1315],    [unit_1315_help]    },  \
        { 1316, [unit_1316],    [unit_1316_help]    },  \
        { 1317, [unit_1317],    [unit_1317_help]    },  \
        { 1318, [unit_1318],    [unit_1318_help]    },  \
        { 1319, [unit_1319],    [unit_1319_help]    },  \
        { 1320, [unit_1320],    [unit_1320_help]    },  \
        { 1321, [unit_1321],    [unit_1321_help]    },  \
        { 1322, [unit_1322],    [unit_1322_help]    },  \
        { 1323, [unit_1323],    [unit_1323_help]    },  \
        { 1324, [unit_1324],    [unit_1324_help]    },  \
        { 1325, [unit_1325],    [unit_1325_help]    },  \
        { 1326, [unit_1326],    [unit_1326_help]    },  \
        { 1327, [unit_1327],    [unit_1327_help]    },  \
        { 1328, [unit_1328],    [unit_1328_help]    },  \
        { 1329, [unit_1329],    [unit_1329_help]    },  \
        { 1330, [unit_1330],    [unit_1330_help]    },  \
        { 1331, [unit_1331],    [unit_1331_help]    },  \
        { 1332, [unit_1332],    [unit_1332_help]    },  \
        { 1333, [unit_1333],    [unit_1333_help]    },  \
        { 1334, [unit_1334],    [unit_1334_help]    },  \
        { 1335, [unit_1335],    [unit_1335_help]    },  \
        { 1336, [unit_1336],    [unit_1336_help]    },  \
        { 1337, [unit_1337],    [unit_1337_help]    },  \
        { 1338, [unit_1338],    [unit_1338_help]    },  \
        { 1339, [unit_1339],    [unit_1339_help]    },  \
        { 1340, [unit_1340],    [unit_1340_help]    },  \
        { 1341, [unit_1341],    [unit_1341_help]    },  \
        { 1342, [unit_1342],    [unit_1342_help]    },  \
        { 1343, [unit_1343],    [unit_1343_help]    },  \
        { 1344, [unit_1344],    [unit_1344_help]    },  \
        { 1345, [unit_1345],    [unit_1345_help]    },  \
        { 1346, [unit_1346],    [unit_1346_help]    },  \
        { 1347, [unit_1347],    [unit_1347_help]    },  \
        { 1348, [unit_1348],    [unit_1348_help]    },  \
        { 1349, [unit_1349],    [unit_1349_help]    },  \
        { 1350, [unit_1350],    [unit_1350_help]    },  \
        { 1351, [unit_1351],    [unit_1351_help]    },  \
        { 1352, [unit_1352],    [unit_1352_help]    },  \
        { 1353, [unit_1353],    [unit_1353_help]    },  \
        { 1354, [unit_1354],    [unit_1354_help]    },  \
        { 1355, [unit_1355],    [unit_1355_help]    },  \
        { 1356, [unit_1356],    [unit_1356_help]    },  \
        { 1357, [unit_1357],    [unit_1357_help]    },  \
        { 1358, [unit_1358],    [unit_1358_help]    },  \
        { 1359, [unit_1359],    [unit_1359_help]    },  \
        { 1360, [unit_1360],    [unit_1360_help]    },  \
        { 1361, [unit_1361],    [unit_1361_help]    },  \
        { 1362, [unit_1362],    [unit_1362_help]    },  \
        { 1363, [unit_1363],    [unit_1363_help]    },  \
        { 1364, [unit_1364],    [unit_1364_help]    },  \
        { 1365, [unit_1365],    [unit_1365_help]    },  \
        { 1366, [unit_1366],    [unit_1366_help]    },  \
        { 1367, [unit_1367],    [unit_1367_help]    },  \
        { 1368, [unit_1368],    [unit_1368_help]    },  \
        { 1369, [unit_1369],    [unit_1369_help]    },  \
        { 1370, [unit_1370],    [unit_1370_help]    },  \
        { 1371, [unit_1371],    [unit_1371_help]    },  \
        { 1372, [unit_1372],    [unit_1372_help]    },  \
        { 1373, [unit_1373],    [unit_1373_help]    },  \
        { 1374, [unit_1374],    [unit_1374_help]    },  \
        { 1375, [unit_1375],    [unit_1375_help]    },  \
        { 1376, [unit_1376],    [unit_1376_help]    },  \
        { 1377, [unit_1377],    [unit_1377_help]    },  \
        { 1378, [unit_1378],    [unit_1378_help]    },  \
        { 1379, [unit_1379],    [unit_1379_help]    },  \
        { 1380, [unit_1380],    [unit_1380_help]    },  \
        { 1381, [unit_1381],    [unit_1381_help]    },  \
        { 1382, [unit_1382],    [unit_1382_help]    },  \
        { 1383, [unit_1383],    [unit_1383_help]    },  \
        { 1384, [unit_1384],    [unit_1384_help]    },  \
        { 1385, [unit_1385],    [unit_1385_help]    },  \
        { 1386, [unit_1386],    [unit_1386_help]    },  \
        { 1387, [unit_1387],    [unit_1387_help]    },  \
        { 1388, [unit_1388],    [unit_1388_help]    },  \
        { 1389, [unit_1389],    [unit_1389_help]    },  \
        { 1390, [unit_1390],    [unit_1390_help]    },  \
        { 1391, [unit_1391],    [unit_1391_help]    },  \
        { 1392, [unit_1392],    [unit_1392_help]    },  \
        { 1393, [unit_1393],    [unit_1393_help]    },  \
        { 1394, [unit_1394],    [unit_1394_help]    },  \
        { 1395, [unit_1395],    [unit_1395_help]    },  \
        { 1396, [unit_1396],    [unit_1396_help]    },  \
        { 1397, [unit_1397],    [unit_1397_help]    },  \
        { 1398, [unit_1398],    [unit_1398_help]    },  \
        { 1399, [unit_1399],    [unit_1399_help]    },  \
        { 1400, [unit_1400],    [unit_1400_help]    },  \
        { 1401, [unit_1401],    [unit_1401_help]    },  \
        { 1402, [unit_1402],    [unit_1402_help]    },  \
        { 1403, [unit_1403],    [unit_1403_help]    },  \
        { 1404, [unit_1404],    [unit_1404_help]    },  \
        { 1405, [unit_1405],    [unit_1405_help]    },  \
        { 1406, [unit_1406],    [unit_1406_help]    },  \
        { 1407, [unit_1407],    [unit_1407_help]    },  \
        { 1408, [unit_1408],    [unit_1408_help]    },  \
        { 1409, [unit_1409],    [unit_1409_help]    },  \
        { 1410, [unit_1410],    [unit_1410_help]    },  \
        { 1411, [unit_1411],    [unit_1411_help]    },  \
        { 1412, [unit_1412],    [unit_1412_help]    },  \
        { 1413, [unit_1413],    [unit_1413_help]    },  \
        { 1414, [unit_1414],    [unit_1414_help]    },  \
        { 1415, [unit_1415],    [unit_1415_help]    },  \
        { 1416, [unit_1416],    [unit_1416_help]    },  \
        { 1417, [unit_1417],    [unit_1417_help]    },  \
        { 1418, [unit_1418],    [unit_1418_help]    },  \
        { 1419, [unit_1419],    [unit_1419_help]    },  \
        { 1420, [unit_1420],    [unit_1420_help]    },  \
        { 1421, [unit_1421],    [unit_1421_help]    },  \
        { 1422, [unit_1422],    [unit_1422_help]    },  \
        { 1423, [unit_1423],    [unit_1423_help]    },  \
        { 1424, [unit_1424],    [unit_1424_help]    },  \
        { 1425, [unit_1425],    [unit_1425_help]    },  \
        { 1426, [unit_1426],    [unit_1426_help]    },  \
        { 1427, [unit_1427],    [unit_1427_help]    },  \
        { 1428, [unit_1428],    [unit_1428_help]    },  \
        { 1429, [unit_1429],    [unit_1429_help]    },  \
        { 1430, [unit_1430],    [unit_1430_help]    },  \
        { 1431, [unit_1431],    [unit_1431_help]    },  \
        { 1432, [unit_1432],    [unit_1432_help]    },  \
        { 1433, [unit_1433],    [unit_1433_help]    },  \
        { 1434, [unit_1434],    [unit_1434_help]    },  \
        { 1435, [unit_1435],    [unit_1435_help]    },  \
        { 1436, [unit_1436],    [unit_1436_help]    },  \
        { 1437, [unit_1437],    [unit_1437_help]    },  \
        { 1438, [unit_1438],    [unit_1438_help]    },  \
        { 1439, [unit_1439],    [unit_1439_help]    },  \
        { 1440, [unit_1440],    [unit_1440_help]    },  \
        { 1441, [unit_1441],    [unit_1441_help]    },  \
        { 1442, [unit_1442],    [unit_1442_help]    },  \
        { 1443, [unit_1443],    [unit_1443_help]    },  \
        { 1444, [unit_1444],    [unit_1444_help]    },  \
        { 1445, [unit_1445],    [unit_1445_help]    },  \
        { 1446, [unit_1446],    [unit_1446_help]    },  \
        { 1447, [unit_1447],    [unit_1447_help]    },  \
        { 1448, [unit_1448],    [unit_1448_help]    },  \
        { 1449, [unit_1449],    [unit_1449_help]    },  \
        { 1450, [unit_1450],    [unit_1450_help]    },  \
        { 1451, [unit_1451],    [unit_1451_help]    },  \
        { 1452, [unit_1452],    [unit_1452_help]    },  \
        { 1453, [unit_1453],    [unit_1453_help]    },  \
        { 1454, [unit_1454],    [unit_1454_help]    },  \
        { 1455, [unit_1455],    [unit_1455_help]    },  \
        { 1456, [unit_1456],    [unit_1456_help]    },  \
        { 1457, [unit_1457],    [unit_1457_help]    },  \
        { 1458, [unit_1458],    [unit_1458_help]    },  \
        { 1459, [unit_1459],    [unit_1459_help]    },  \
        { 1460, [unit_1460],    [unit_1460_help]    },  \
        { 1461, [unit_1461],    [unit_1461_help]    },  \
        { 1462, [unit_1462],    [unit_1462_help]    },  \
        { 1463, [unit_1463],    [unit_1463_help]    },  \
        { 1464, [unit_1464],    [unit_1464_help]    },  \
        { 1465, [unit_1465],    [unit_1465_help]    },  \
        { 1466, [unit_1466],    [unit_1466_help]    },  \
        { 1467, [unit_1467],    [unit_1467_help]    },  \
        { 1468, [unit_1468],    [unit_1468_help]    },  \
        { 1469, [unit_1469],    [unit_1469_help]    },  \
        { 1470, [unit_1470],    [unit_1470_help]    },  \
        { 1471, [unit_1471],    [unit_1471_help]    },  \
        { 1472, [unit_1472],    [unit_1472_help]    },  \
        { 1473, [unit_1473],    [unit_1473_help]    },  \
        { 1474, [unit_1474],    [unit_1474_help]    },  \
        { 1475, [unit_1475],    [unit_1475_help]    },  \
        { 1476, [unit_1476],    [unit_1476_help]    },  \
        { 1477, [unit_1477],    [unit_1477_help]    },  \
        { 1478, [unit_1478],    [unit_1478_help]    },  \
        { 1479, [unit_1479],    [unit_1479_help]    },  \
        { 1480, [unit_1480],    [unit_1480_help]    },  \
        { 1481, [unit_1481],    [unit_1481_help]    },  \
        { 1482, [unit_1482],    [unit_1482_help]    },  \
        { 1483, [unit_1483],    [unit_1483_help]    },  \
        { 1484, [unit_1484],    [unit_1484_help]    },  \
        { 1485, [unit_1485],    [unit_1485_help]    },  \
        { 1486, [unit_1486],    [unit_1486_help]    },  \
        { 1487, [unit_1487],    [unit_1487_help]    },  \
        { 1488, [unit_1488],    [unit_1488_help]    },  \
        { 1489, [unit_1489],    [unit_1489_help]    },  \
        { 1490, [unit_1490],    [unit_1490_help]    },  \
        { 1491, [unit_1491],    [unit_1491_help]    },  \
        { 1492, [unit_1492],    [unit_1492_help]    },  \
        { 1493, [unit_1493],    [unit_1493_help]    },  \
        { 1494, [unit_1494],    [unit_1494_help]    },  \
        { 1495, [unit_1495],    [unit_1495_help]    },  \
        { 1496, [unit_1496],    [unit_1496_help]    },  \
        { 1497, [unit_1497],    [unit_1497_help]    },  \
        { 1498, [unit_1498],    [unit_1498_help]    },  \
        { 1499, [unit_1499],    [unit_1499_help]    },  \
        { 1500, [unit_1500],    [unit_1500_help]    },  \
        { 1501, [unit_1501],    [unit_1501_help]    },  \
        { 1502, [unit_1502],    [unit_1502_help]    },  \
        { 1503, [unit_1503],    [unit_1503_help]    },  \
        { 1504, [unit_1504],    [unit_1504_help]    },  \
        { 1505, [unit_1505],    [unit_1505_help]    },  \
        { 1506, [unit_1506],    [unit_1506_help]    },  \
        { 1507, [unit_1507],    [unit_1507_help]    },  \
        { 1508, [unit_1508],    [unit_1508_help]    },  \
        { 1509, [unit_1509],    [unit_1509_help]    },  \
        { 1510, [unit_1510],    [unit_1510_help]    },  \
        { 1511, [unit_1511],    [unit_1511_help]    },  \
        { 1512, [unit_1512],    [unit_1512_help]    },  \
        { 1513, [unit_1513],    [unit_1513_help]    },  \
        { 1514, [unit_1514],    [unit_1514_help]    },  \
        { 1515, [unit_1515],    [unit_1515_help]    },  \
        { 1516, [unit_1516],    [unit_1516_help]    },  \
        { 1517, [unit_1517],    [unit_1517_help]    },  \
        { 1518, [unit_1518],    [unit_1518_help]    },  \
        { 1519, [unit_1519],    [unit_1519_help]    },  \
        { 1520, [unit_1520],    [unit_1520_help]    }   \



/********************************************************************************/
/* Includes                                                                     */
/********************************************************************************/

#include "PA_Detect.inc"
#include "Diagnosis.inc"


#include "SAPA_ACEP_373X_4_AO.ddl"
#include "SAPA_ACEP_373X_4_PB.ddl"
#include "SAPA_ACEP_373X_4_MENU.ddl"
#include "SAPA_ACEP_373X_4_DI1.ddl"
#include "SAPA_ACEP_373X_4_DI2.ddl"
#include "SAPA_ACEP_373X_4_DIAG.ddl"


VARIABLE    dummy_byte
{
    LABEL       "";
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}


/******************************************************************************/
/*    Physical Block                                                          */
/******************************************************************************/

/* Datei: SAHA_373X_4_PB.dll */

/******************************************************************************/
/*    AO Transducer Block: Actuator                                           */
/*    AO Function Block:			                                          */
/******************************************************************************/

/* Datei: SAHA_373X_4_AO.dll */



/******************************************************************************/
/*    Unit relations                                                          */
/******************************************************************************/
UNIT AO_PV_SCALE_UNIT
{
    func1_pv_unit:

    func1_pv_upper_range_value,
    func1_pv_lower_range_value,
    func1_readback_value,
    func1_rcas_in_value,
    func1_rcas_out_value,
    func1_fsafe_value,
    func1_simulate_value,
    func1_setpoint_value

}

UNIT AO_OUT_SCALE_UNIT
{
    func1_out_unit:

    trans1_feedback_value,
    func1_out_value,
    func1_out_upper_range_value,
    func1_out_lower_range_value,
    trans1_positioning_value
}

UNIT AO_FINAL_VALUE_RANGE_UNIT
{
   trans1_final_value_range_units:

   trans1_final_value_range_end,
   trans1_final_value_range_start,
   trans1_final_position_value__value,
   trans1_final_value__value
}


/******************************************************************************/
/*      Refresh relations                                                     */
/******************************************************************************/
/* nicht implementiert */

/******************************************************************************/
/* Methods                                                                    */
/******************************************************************************/

/* Defines fr Diagnosis und checkback: */
#define CB_FAIL_SAFE_1                0x00010000   /* Bit  0 0x010000    */
#define CB_REQ_LOC_OP_1               0x00020000   /* Bit  1 0x020000    */
#define CB_LOCAL_OP_1                 0x00040000   /* Bit  2 0x040000    */
#define CB_OVERRIDE_1                 0x00080000   /* Bit  3 0x080000    */
#define CB_TRAV_TIME_1                0x00800000   /* Bit  7 0x800000    */
#define CB_UPDATE_EVT_1               0x00000400   /* Bit 10 0x000400    */
#define CB_SIMULATE_1                 0x00000800   /* Bit 11 0x000800    */
#define CB_CONTR_ERR_1                0x00002000   /* Bit 13 0x002000    */
#define CB_CONTR_INACT_1              0x00004000   /* Bit 14 0x004000    */
#define CB_SELFTEST_1                 0x00008000   /* Bit 15 0x008000    */
#define CB_TOT_VALVE_TRAV_1           0x00000001   /* Bit 16 0x000001    */
#define CB_BINARY_INPUT_1             0x00000002   /* Bit 17 0x000002    */
#define CB_ZERO_PONIT_ERROR_1         0x00000080   /* Bit 23 0x000080    */

#define DIA_HW_ELECTR_1               0x01000000   /* Bit  0 0x00000001  */
#define DIA_HW_MECH_1                 0x02000000   /* Bit  1 0x00000002  */
#define DIA_MEM_CHKSUM_1              0x10000000   /* Bit  4 0x00000010  */
#define DIA_MEASUREMENT_1             0x20000000   /* Bit  5 0x00000020  */
#define DIA_NOT_INIT_1                0x40000000   /* Bit  6 0x00000040  */
#define DIA_INIT_ERR_1                0x80000000   /* Bit  7 0x00000080  */
#define DIA_ZERO_ERR_1                0x00010000   /* Bit  8 0x00000100  */
#define DIA_CONF_INVAL_1              0x00040000   /* Bit 10 0x00000400  */
#define DIA_WARMSTART_1               0x00080000   /* Bit 11 0x00000800  */
#define DIA_COLDSTART_1               0x00100000   /* Bit 12 0x00001000  */
#define DIA_MAINTENANCE_1             0x00200000   /* Bit 13 0x00002000  */
#define DIA_CHARACT_1                 0x00400000   /* Bit 14 0x00004000  */
#define DIA_IDENT_NUMBER_VIOLATION_1  0x00800000   /* Bit 15 0x00008000  */
#define DIA_MAINTENANCE_ALARM_1		  0x00000100   /* Bit xx 0x00010000  */
#define DIA_MAINTENANCE_DEMANDED_1	  0x00000200   /* Bit xx 0x00020000  */
#define DIA_FUNCTION_CHECK_1		  0x00000400   /* Bit xx 0x00040000  */
#define DIA_INV_PRO_COND_1			  0x00000800   /* Bit xx 0x00080000  */
#define EXTENSION_AVAILABLE_1         0x00000080   /* Bit xx 0x80000000  */




/* DIAGNOSIS_EXT  BYTE 1  */
#define DIA_EXT_DEVICE_NOT_INIT												0x01		/* Device not initialized */
#define DIA_EXT_SOL_VALVE_ACTIVE											0x02		/* Solenoid valve active  */
#define DIA_LIMIT_EXCEEDED														0x04		/* Total valve travel limit exceeded */
#define DIA_CONTROL_LOOP															0x08		/* Control loop */
#define DIA_ZERO_POINT_ERROR													0x10		/* Zero point error */
#define DIA_AUTOCORRECTION														0x20		/* Autocorrection */
#define DIA_FATAL_ERROR																0x40		/* Fatal error */
#define DIA_EXTENDEND_DIAG														0x80    /* Extenden diagnosis available */

/* DIAGNOSIS_EXT  BYTE 2  */
#define DIA_X_RANGE																		0x01		/* x > range */
#define DIA_DELTA_X_RANGE															0x02		/* Delta x < Bereich */
#define DIA_ATTACHMENT																0x04		/* Attachment */
#define DIA_INIT_TIME																	0x08		/* Initialization time exceeded */
#define DIA_INIT_MGV																	0x10		/* Initialization / solenoid valve */
#define DIA_TRAVEL_TIME_SHORT													0x20		/* Travel time too short */
#define DIA_PIN_POS																		0x40    /* Pin position */
#define DIA_TEST_RUNNING															0x80		/* Test or calibration running */

/* DIAGNOSIS_EXT  BYTE 3  */
#define DIA_X_SIGNAL																	0x01		/* x-signal*/
#define DIA_IP_CONVERTER															0x02		/* i/p-converter */
#define DIA_HW																				0x04		/* Hardware */
#define DIA_CONTR_PARA																0x08		/* Control parameter */
#define DIA_POTI_PARA																	0x10		/* Poti parameter */
#define DIA_ADJUST_PARA																0x20		/* Adjustment parameter */
#define DIA_INT_DEV_ERROR															0x40		/* Internal device error 1 */
#define DIA_GEN_PARA																	0x80		/* General parameter */

/* DIAGNOSIS_EXT  BYTE 4  */
#define DIA_NO_EMERENCY_MODE													0x01		/* No emergency mode */
#define DIA_PROGR_ERROR																0x02		/* Program load error */
#define DIA_OPT_PARA																	0x04		/* Options parameter */
#define DIA_INFO_PARA																	0x08		/* Info parameter */
#define DIA_DATA_MEM																	0x10		/* Data memory */
#define DIA_CONTR_CALC																0x20		/* Control calculation */
#define DIA_PA_PARA																		0x40		/* PA Parameter */
#define DIA_DIA_PARA																	0x80		/* DIAG Parameter */


/* DIAGNOSIS_EXT  BYTE 5  */
#define DIA_RESET_COMM_CONTR													0x01		/* Reset communication controller */
#define DIA_RESET_BUSANSCHALTUNG											0x02		/* Reset SPC4 */
#define DIA_BIN2_DEAKT																0x04		/* Bin Input 2 deactivated */
#define DIA_RESET_APPL_CONTR													0x08		/* Reset application controller */





/* DIAGNOSIS_EXT  BYTE 6  */
#define DIA_EXT_AIR_SUPP_PERH_MOD_TEST								0x01 		/* Air supply: Perhaps modified TEST 		*/
#define DIA_EXT_AIR_SUPP_PERH_NOT_ENOUGH_TEST					0x02		/* Air supply: Perhaps not enough TEST 	*/
#define DIA_EXT_AIR_SUPP_PERH_NOT_ENOUGH							0x04		/* Air supply: Perhaps not enough */
#define DIA_EXT_AIR_SUPP_WORK_FULL_CAP								0x08		/* Air supply: Working at full capacity */
#define DIA_EXT_AIR_SUPP_WORK_FULL_CAP_TEST						0x10		/* Air supply: Working at full capacity TEST*/
#define DIA_EXT_AIR_SUPP_PERH_MOD											0x20    /* Air supply: Perhaps modified */
#define DIA_EXT_PERH_SPR_STIFF_RED_TEST								0x40    /* Spring: Perhaps spring stiffness reduced TEST */
#define DIA_EXT_SPRING_PERH_BIAS_RED_TEST							0x80		/* Spring: Perhaps bias reduced TEST */


/* DIAG_EXT_1 BYTE 0 und 1*/

#define DIA_EXT_SPRING_PERH_BIAS_INC_TEST							0x0100 	/* Spring: Perhaps bias increased TEST */
#define DIA_EXT_SPRING_WORK_FULL_CAP									0x0200	/* Spring: Working at full capacity */
#define DIA_EXT_SPRING_WORK_FULL_CAP_TEST							0x0400  /* Spring: Working at full capacity TEST */
#define DIA_EXT_TREND_SHIFT_TO_CLOSE_POS							0x0800  /* Trend range: Shifting working range to closing position */
#define DIA_EXT_TREND_SHIFT_WORK_RANGE_OPEN_POS				0x1000  /* Trend range: Shifting working range to max. opening pos. */
#define DIA_EXT_FRICT_HIGHER_WHOLE_RANGE							0x2000	/* Friction: Much higher over whole range */
#define DIA_EXT_FRICT_LOWER_WHOLE_RANGE								0x4000	/* Friction: Much lower over whole range */
#define DIA_EXT_FRICT_HIGHER_SECT											0x8000	/* Friction: Much higher over section */
#define DIA_EXT_FRICT_MUCH_L_OVER_SECT								0x0001	/* Friction: Much lower over section" 					*/
#define DIA_EXT_FRICT_HUCH_H_WHOLE_RANGE_TEST					0x0002	/* Friction: Much higher over whole range TEST 	*/
#define DIA_EXT_FRICT_MUCH_L_WHOLE_RANGE_TEST					0x0004  /* Friction: Much lower over whole range TEST 	*/
#define DIA_EXT_FRICT_MUCH_H_OVER_SECT_TEST						0x0008  /* Friction: Much higher over section TEST 			*/
#define DIA_EXT_FRICT_MUCH_L_OVER_SECT_TEST						0x0010  /* Friction: Much lower over section TEST 			*/
#define DIA_EXT_LEACK_PNEU_PERH_EXIST_TEST						0x0020  /* Leakage Pneumatics: Perhaps existing TEST 		*/
#define DIA_EXT_LEACK_PNEU_PERH_EXIST									0x0040	/* Leakage Pneumatics: Perhaps existing */
#define DIA_EXT_LEACK_PNEU_PERH_TOO_LARGE_TEST				0x0080	/* Leakage Pneumatics: Perhaps too large TEST */

/* DIAG_EXT_1 BYTE 2 und 3*/

#define DIA_EXT_LEACK_SOON_EXP												0x0001  /* Ext. leakage perhaps soon expected */
#define DIA_EXT_LEACK_PERHAPS													0x0002	/* Ext. leakage perhaps existing 			*/
#define DIA_EXT_LEACKAGE															0x0004	/* Ext. leackage existing				 			*/
#define DIA_EXT_TREND_END_POS_MON_DOWN_AB_REF					0x0008	/* Trend end pos.: ZP-shift monotone down; aver. above ref. */
#define DIA_EXT_TREND_END_POS_MON_UP_AB_REF						0x0010  /* Trend end pos.: ZP-shift monotone up; aver. above ref. 	*/
#define DIA_EXT_TREND_END_POS_ALT											0x0020	/* Trend end pos.: ZP-shift alternate; aver. above ref. 		*/
#define DIA_EXT_TREND_END_POS_MON_DOWN_UNDER_REF			0x0040  /* Trend end pos.: ZP-shift monotone down; aver. under ref.	*/
#define DIA_EXT_TRAND_END_POS_MON_UP_UNDER_REF				0x0080  /* Trend end pos.: ZP-shift monotone up; aver. under ref. 	*/
#define DIA_EXT_LEACK_PNEU_PERH_TOO_LARGE							0x0100	/* Leakage Pneumatics: Perhaps too large */
#define DIA_EXT_LIMIT_RANGE_DOWN											0x0200	/* Limit range: Down */
#define DIA_EXT_LIMIT_RANGE_UP												0x0400	/* Limit range: UP */
#define DIA_EXT_LIMIT_RANGE_MOD_IMPOS									0x0800	/* Limit range: Modification impossible */
#define DIA_EXT_DYN_STRESS_FACT												0x1000 	/* Dynamic stress factor higher than 90% */
#define DIA_EXT_INNER_LEACK_PERH_LARGER								0x2000  /* Inner leakage: Perhaps larger than origin */
#define DIA_EXT_INNER_LEACK_LARGER_TEST								0x4000  /* Inner leakage: Perhaps larger than origin TEST */
#define DIA_EXT_INNER_LEACK_PERH_PRESENT							0x8000  /* Inner leakage: perhaps present */


/* DIAG_EXT_1 BYTE 4 und 5*/

#define DIA_EXT_TREND_END_POS_ALT_UNDER_REF						0x0100	/* Trend end pos.: ZP-alternate; aver. under ref. */
#define DIA_EXT_MECH_CONN_TRAVEL_TRANS_TEST						0x0200	/* Mech. conn. Pos./Valve: No opt. travel transm.TEST */
#define DIA_EXT_MECH_CONN_PERH_LOOSE									0x0400	/* Mech. conn. Pos./Valve: Perhaps loose */
#define DIA_EXT_MECH_CONN_PERH_LIMIT									0x0800	/* Mech. conn. Pos./Valve: Perhaps limit. range */
#define DIA_EXT_MECH_CONN_PERH_LOOSE_TEST							0x1000	/* Mech. conn. Pos./Valve: Perhaps loose TEST */
#define DIA_EXT_RANGE_MOST_CLOSE_POS									0x2000  /* Range: Mostly near closing pos. */
#define DIA_EXT_RANGE_MOST_NEAR_MAX_OPEN							0x4000  /* Range: Mostly near max. opening */
#define DIA_EXT_RANGE_MOST_CLOSE_POS									0x8000  /* Range: Mostly closing position */
#define DIA_EXT_RANGE_MOST_MAX_OPEN										0x0001  /* Range: Mostly max. opening */
#define DIA_EXT_TEMP_BELOW														0x0002  /* Temperature below -40C" "|de|Temperatur kleiner -40C */
#define DIA_EXT_TEMP_ABOVE														0x0004  /* Temperature above +80C" "|de|Temperatur grer +80C */
#define DIA_EXT_REF_TEST_ABORTED											0x0008	/* Reference test aborted */
#define DIA_EXT_ESD_MOVE_ACT_POSS											0x0010  /* ESD: Movement actuator poss. */
#define DIA_EXT_ESD_MOVE_ACT_IMPOSS										0x0020  /* ESD: Movement actuator imposs. */
#define DIA_EXT_ESD_ERROR_SOL_VALEVE									0x0040  /* ESD: Error solenoid valve */


/* Zum Lschen von bestimmten Diagnosezustnden: */
#define PDM_DIAG_MAINT_RECOMMENDED_INVERS  0xFFFB  /* Lsche MAINT_RECOMMENDED */
#define PDM_DIAG_GOOD_INVERS               0xFFF7  /* Lsche GOOD */


/* mgliche Stati (PDM_Diag_Status_Diagnosis):
PDM_DIAG_DEVICE_TYPE_MISMATCH
PDM_DIAG_MAINT_HIGH
PDM_DIAG_MAINT_MEDIUM
PDM_DIAG_MAINT_LOW
PDM_DIAG_MODE_TEST
PDM_DIAG_MODE_LOCAL_OVERRIDE
PDM_DIAG_MODE_SIMULATION
PDM_DIAG_MODE_OUT_OF_SERVICE
PDM_DIAG_CONFIG_ERROR
PDM_DIAG_CONFIG_WARNING
PDM_DIAG_CONFIG_CHANGED
PDM_DIAG_PROCESS_ALARM
PDM_DIAG_PROCESS_WARNING
PDM_DIAG_PROCESS_TOLERANCE
PDM_DIAG_GOOD
*/


/* fr PDM-LifeList / Diagnose */
METHOD  method_PDM_StandardDiagnosis
{
    LABEL "Diagnosis" "|049Diagnose";
    ACCESS      OFFLINE;
    CLASS       INPUT;
    DEFINITION
    {

        long i_phys_diagnosis;   				/* Diagnosis hat 4 Byte */
        long i_func1_check_back; 				/* Checkback hat 3 Byte */

        int diagnosis_ext_1_byte_0;     /* Diagnosis_Ext hat 6 Byte */
        int diagnosis_ext_1_byte_1;     /* Diagnosis_Ext hat 6 Byte */
        int diagnosis_ext_1_byte_2;     /* Diagnosis_Ext hat 6 Byte */
        int diagnosis_ext_1_byte_3;     /* Diagnosis_Ext hat 6 Byte */
        int diagnosis_ext_1_byte_4;     /* Diagnosis_Ext hat 6 Byte */
        int diagnosis_ext_1_byte_5;     /* Diagnosis_Ext hat 6 Byte */

        long diagnosis_ext_2_byte_01;		/* Diagnosis_Ext_2 hat 6 Byte */
        long diagnosis_ext_2_byte_23;		/* Diagnosis_Ext_2 hat 6 Byte */
        long diagnosis_ext_2_byte_45;		/* Diagnosis_Ext_2 hat 6 Byte */
        int  akt_BA; 										/* akt. Betriebsart AO Function Block*/
        int  akt_BA_AOTRD;  						/* akt. Betriebsart AO Transducer*/
				int  simulate_enable;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */

        ReadCommand (read_phys_diagnosis);   /* lese phys_diagnosis   (#13) */
        ReadCommand (read_func1_check_back); /* lese func1_check_back (#33) */
        i_phys_diagnosis   = lvar_value (phys_diagnosis);
        i_func1_check_back = lvar_value (func1_check_back);

        /* Vorbelegen: */
				PDM_Diag_Status_Diagnosis = 0;
				PDM_Diag_Rule_Message     = "";
				simulate_enable = 0;
				akt_BA_AOTRD = 0;


        /* bei Hand PDM_DIAG_SIMULATION setzen */
        ReadCommand (read_func1_mode);  /* lese akt. Betriebsart */
        akt_BA = ivar_value (func1_actual_mode);


				ReadCommand (read_func1_simulate);  /* lese simulate enable */
				simulate_enable = ivar_value (func1_simulate_enabled);


				ReadCommand (read_phys_diagnosis_ext_1); 			/* lese Diagnosis Ext 1 */
				diagnosis_ext_1_byte_0 = ivar_value (phys_diag_ext_1_0);	/* Byte 1 */


				ReadCommand (read_phys_diagnosis_ext_1); 			/* lese Diagnosis Ext 1 */
				diagnosis_ext_1_byte_1 = ivar_value (phys_diag_ext_1_1);	/* Byte 2 */


				ReadCommand (read_phys_diagnosis_ext_1); 			/* lese Diagnosis Ext 1 */
				diagnosis_ext_1_byte_2 = ivar_value (phys_diag_ext_1_2);	/* Byte 3 */


				ReadCommand (read_phys_diagnosis_ext_1); 			/* lese Diagnosis Ext 1 */
				diagnosis_ext_1_byte_3 = ivar_value (phys_diag_ext_1_3);	/* Byte 4 */

				ReadCommand (read_phys_diagnosis_ext_1); 			/* lese Diagnosis Ext 1 */
				diagnosis_ext_1_byte_4 = ivar_value (phys_diag_ext_1_4);	/* Byte 5 */


				ReadCommand (read_phys_diagnosis_ext_2); 			/* lese Diagnosis Ext 2 */
				diagnosis_ext_2_byte_01 = lvar_value (phys_diag_ext_2_0);	/* Byte 0 und 1 */

				ReadCommand (read_phys_diagnosis_ext_2); 			/* lese Diagnosis Ext 2 */
				diagnosis_ext_2_byte_23 = lvar_value (phys_diag_ext_2_1);	/* Byte 2 und 3 */


				ReadCommand (read_phys_diagnosis_ext_2); 			/* lese Diagnosis Ext 2 */
				diagnosis_ext_2_byte_45 = lvar_value (phys_diag_ext_2_2);	/* Byte 4 und 5 */

				ReadCommand (read_trans1_mode);  /* lese akt. Betriebsart AO Transducer*/
				akt_BA_AOTRD = ivar_value (trans1_actual_mode);


/* Symbol in Abhngigkeit der Diagnose Meldung setzen */
/* -------------------------------------------------- */


		if((i_phys_diagnosis & DIA_MAINTENANCE_ALARM_1) ||
		   (i_phys_diagnosis & DIA_HW_ELECTR_1) 		||
		   (i_phys_diagnosis & DIA_HW_MECH_1)   		  )
		{
		   /* BAD_MAINT_ALARM_MORE_DIAG - Ausfall */
		   /* BAD_DEVICE_FAILURE */
		   PDM_Diag_Status_Diagnosis = PDM_DIAG_MAINT_HIGH;
		}

		else if(i_phys_diagnosis & DIA_MAINTENANCE_DEMANDED_1)
		{
		   /* GOOD_MAINT_REQ  */
		   PDM_Diag_Status_Diagnosis = PDM_DIAG_MAINT_MEDIUM;
		}

		else if(i_phys_diagnosis & DIA_MAINTENANCE_1)
		{
		   /* GOOD_MAINT_DEMANDED */
		   /* UNCERTAIN_MAINT_DEMANDED */

		   PDM_Diag_Status_Diagnosis = PDM_DIAG_MAINT_LOW;
		}

		else if((akt_BA_AOTRD == BLOCK_MODE_LOCAL_OVERRIDE) || (akt_BA_AOTRD == BLOCK_MODE_MAN))
    	{
    	   PDM_Diag_Status_Diagnosis = PDM_DIAG_MODE_LOCAL_OVERRIDE;
           PDM_Diag_Rule_Message += "Manual mode active;"
                                    "|de|Betriebsart Hand aktiv;";
		}

		else if(simulate_enable == 1)
		{
		   PDM_Diag_Status_Diagnosis = PDM_DIAG_SIMULATION;
		}

		else
		{
		  PDM_Diag_Status_Diagnosis = PDM_DIAG_GOOD;
		}

/* ------------------------------------------------- */



/* ------------ Sammelstatus ausgeben -------------- */

		if( i_phys_diagnosis & DIA_MAINTENANCE_ALARM_1 )
		{
			PDM_Diag_Rule_Message     +=  "\r\n -----------------------------"  "|de| \r\n -----------------------------"+
																		"\r\n Maintenance alarm" 							"|de| \r\n Ausfall" +
																		"\r\n -----------------------------"  "|de| \r\n -----------------------------";
		}

		else if( i_phys_diagnosis & DIA_MAINTENANCE_DEMANDED_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n -----------------------------"  "|de| \r\n -----------------------------"+
																	 "\r\n Maintenance demanded" 				   "|de| \r\n Wartungsanforderung" +
																	 "\r\n -----------------------------"  "|de| \r\n -----------------------------";
		}

		else if(i_phys_diagnosis & DIA_MAINTENANCE_1)
		{
		  PDM_Diag_Rule_Message     += "\r\n -----------------------------"  "|de| \r\n -----------------------------" +
		  														 "\r\n Maintenance required"  				 "|de| \r\n Wartungsbedarf" +
		  														 "\r\n -----------------------------"  "|de| \r\n -----------------------------";
		}

		else if( i_phys_diagnosis & DIA_FUNCTION_CHECK_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n -----------------------------"  "|de| \r\n -----------------------------" +
																	 "\r\n Function check" 								 "|de| \r\n Funktionskontrolle" +
																	 "\r\n -----------------------------"  "|de| \r\n -----------------------------";
		}

		else if( i_phys_diagnosis & DIA_INV_PRO_COND_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n -----------------------------"  "|de| \r\n -----------------------------" +
																	 "\r\n Invalid process condition" 		 "|de| \r\n	Ungltiger Prozesszustand" +
																	 "\r\n -----------------------------"  "|de| \r\n -----------------------------";
		}

		else
		{
		  PDM_Diag_Rule_Message     += "\r\n -----------------------------"  "|de| \r\n -----------------------------" +
																	 "\r\n OK"												 		 "|de| \r\n	OK" +
																	 "\r\n -----------------------------"  "|de| \r\n -----------------------------";
		}



/* ------------------------------------------------- */


        /* wenn alles 0: */
		if( (i_phys_diagnosis == 0) && (i_func1_check_back == 0) )
		{
			PDM_Diag_Rule_Message     = [dia_OK];
		}

		if( i_func1_check_back & CB_FAIL_SAFE_1 )
		{
			PDM_Diag_Rule_Message += "\r\nDevice in fail-safe position;"
                                     "|de|\r\nGert in Sicherheitsstellung;";
		}
		if( i_func1_check_back & CB_OVERRIDE_1 )
		{
			PDM_Diag_Rule_Message     += "\r\nSolenoid valve inactive;"
                                        "|de|\r\nMagnetventil inaktiv;";
		}
		if( i_func1_check_back & CB_UPDATE_EVT_1 )
		{
			PDM_Diag_Rule_Message     += "\r\nStatic data changed changed;"
		                                 "|de|\r\nStatische Daten wurden gendert;";
		}
		if( i_func1_check_back & CB_CONTR_INACT_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_CONTR_INACT] + ";";
		}
		if( i_func1_check_back & CB_BINARY_INPUT_1 )
		{
			PDM_Diag_Rule_Message     += "\r\nBinary input active;"
                                        "|de|\r\nBinreingang aktiv;";
		}
		if( i_phys_diagnosis & DIA_WARMSTART_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" +  [dia_WARMSTART] + ";";
		}
		if( i_phys_diagnosis & DIA_COLDSTART_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" +  [dia_COLDSTART] + ";";
		}
        /************/
		if( i_phys_diagnosis & DIA_CONF_INVAL_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" +  [dia_CONF_INVAL] + ";";
		}
        /************/
		if( i_func1_check_back & CB_TOT_VALVE_TRAV_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" +  [cb_TOT_VALVE_TRAV] + ";";
		}
 		if( (i_func1_check_back & CB_TRAV_TIME_1) )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_TRAV_TIME] + ";";
		}
		if( i_func1_check_back & CB_REQ_LOC_OP_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_REQ_LOC_OP] + ";";
		}
		if( i_phys_diagnosis & DIA_CHARACT_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_CHARACT] + ";";
		}
        /************/
		if( i_phys_diagnosis & DIA_IDENT_NUMBER_VIOLATION_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_IDENT_VIOL] + ";";
		}

		if( i_phys_diagnosis & DIA_ZERO_ERR_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_ZERO_ERR] + ";";
		}
		if( i_phys_diagnosis & DIA_INIT_ERR_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_INIT_ERR] + ";";
		}
        /************/
		if( i_phys_diagnosis & DIA_HW_ELECTR_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_HW_ELECTR] + ";";
		}
		if( i_phys_diagnosis & DIA_HW_MECH_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_HW_MECH] + ";";
		}
		if( i_phys_diagnosis & DIA_MEM_CHKSUM_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_MEM_CHKSUM] + ";";
		}
		if( i_phys_diagnosis & DIA_MEASUREMENT_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_MEASUREMENT] + ";";
		}
		if( i_phys_diagnosis & DIA_NOT_INIT_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_NOT_INIT] + ";";
		}
		if( i_func1_check_back & CB_CONTR_ERR_1	)
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_CONTR_ERR] + ";";
		}
		if( i_func1_check_back & CB_ZERO_PONIT_ERROR_1 )
		{
			PDM_Diag_Rule_Message     += "\r\nZero point error;"
			                             "|de|\r\nNullpunktfehler;";
		}
        /************/
		if( i_func1_check_back & CB_SELFTEST_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_SELFTEST] + ";";
		}
		if( i_func1_check_back & CB_SIMULATE_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_SIMULATE] + ";";
		}
		if( i_func1_check_back & CB_LOCAL_OP_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [cb_LOCAL_OP] + ";";
		}



		if( i_phys_diagnosis & EXTENSION_AVAILABLE_1 )
		{
			PDM_Diag_Rule_Message     += "\r\n" + [dia_EXTENSION_AVAILABLE] + ";";
		}


		/* Expert + */
		/* -------- */

		/* TJ: Hilfetexte muessen noch ergaenzt werden */




    /* -------------------- diagnosis_ext byte 0 ------------------------- */

    if(diagnosis_ext_1_byte_0 & DIA_EXT_DEVICE_NOT_INIT)
    {
    	 PDM_Diag_Rule_Message  += "\r\nDevice not initialized;"  "|de|\r\nGert nicht initialisiert;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    if(diagnosis_ext_1_byte_0 & DIA_EXT_SOL_VALVE_ACTIVE)
    {
    	 PDM_Diag_Rule_Message  += "\r\nSolenoid valve active;"  "|de|\r\nMagnetventil aktiv;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_0 & DIA_LIMIT_EXCEEDED)
    {
    	 PDM_Diag_Rule_Message  += "\r\nTotal valve travel limit exceeded;"  "|de|\r\nWegintegral berschritten;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    if(diagnosis_ext_1_byte_0 & DIA_CONTROL_LOOP)
    {
    	 PDM_Diag_Rule_Message  += "\r\nControl loop;"  "|de|\r\nRegelkreis;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    if(diagnosis_ext_1_byte_0 & DIA_ZERO_POINT_ERROR)
    {
    	 PDM_Diag_Rule_Message  += "\r\nZero point;"  "|de|\r\nNullpunkt;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_0 & DIA_AUTOCORRECTION)
    {
    	 PDM_Diag_Rule_Message  += "\r\nAutocorrection;"  "|de|\r\nAutokorrektur;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    if(diagnosis_ext_1_byte_0 & DIA_FATAL_ERROR)
    {
    	 PDM_Diag_Rule_Message  += "\r\nFatal error;"  "|de|\r\nFataler Fehler;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    if(diagnosis_ext_1_byte_0 & DIA_EXTENDEND_DIAG)
    {
    	 PDM_Diag_Rule_Message  += "\r\nExtenden diagnosis;"  "|de|\r\nErweiterte Diagnose;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    /* -------------------- diagnosis_ext byte 1 ------------------------- */


    if(diagnosis_ext_1_byte_1 & DIA_X_RANGE)
    {
    	 PDM_Diag_Rule_Message  += "\r\nx > range;"  "|de|\r\nx > Bereich;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_DELTA_X_RANGE)
    {
    	 PDM_Diag_Rule_Message  += "\r\nDelta x < range;"  "|de|\r\nDelta x < Bereich;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_ATTACHMENT)
    {
    	 PDM_Diag_Rule_Message  += "\r\nAttachment;"  "|de|\r\nAnbau;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_INIT_TIME)
    {
    	 PDM_Diag_Rule_Message  += "\r\nInitialization time exceeded;"  "|de|\r\nInitialisierungszeit berschritten;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_INIT_MGV)
    {
    	 PDM_Diag_Rule_Message  += "\r\nInitialization / solenoid valve;"  "|de|\r\nInitialisierung / Magnetventil;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_TRAVEL_TIME_SHORT)
    {
    	 PDM_Diag_Rule_Message  += "\r\nTravel time too short;"  "|de|\r\nLaufzeit unterschritten;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_PIN_POS)
    {
    	 PDM_Diag_Rule_Message  += "\r\nPin position;"  "|de|\r\nStiftposition;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_TEST_RUNNING)
    {
    	 PDM_Diag_Rule_Message  += "\r\nTest or calibration running;"  "|de|\r\nTest oder Kalibrierung luft;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }



    /* -------------------- diagnosis_ext byte 2 ------------------------- */

    if(diagnosis_ext_1_byte_1 & DIA_X_SIGNAL)
    {
    	 PDM_Diag_Rule_Message  += "\r\nx-signal;"  "|de|\r\nx-Signal;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_IP_CONVERTER)
    {
    	 PDM_Diag_Rule_Message  += "\r\ni/p-converter;"  "|de|\r\ni/p Wandler;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_HW)
    {
    	 PDM_Diag_Rule_Message  += "\r\nHardware;"  "|de|\r\nHardware;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    /* -------------------- diagnosis_ext byte 3 ------------------------- */

    if(diagnosis_ext_1_byte_1 & DIA_CONTR_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nControl parameter;"  "|de|\r\nRegelparameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_POTI_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nPoti parameter;"  "|de|\r\nPotiparameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_ADJUST_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nAdjustment parameter;"  "|de|\r\nAbgleichparameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_INT_DEV_ERROR)
    {
    	 PDM_Diag_Rule_Message  += "\r\nInternal device error 1;"  "|de|\r\nInterner Gertefehler 1;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_GEN_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nGeneral parameter;"  "|de|\r\nAllgemeine Parameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    /* -------------------- diagnosis_ext byte 4 ------------------------- */

    if(diagnosis_ext_1_byte_1 & DIA_NO_EMERENCY_MODE)
    {
    	 PDM_Diag_Rule_Message  += "\r\nNo emergency mode;"  "|de|\r\nKeine Notlaufeigenschaft;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_PROGR_ERROR)
    {
    	 PDM_Diag_Rule_Message  += "\r\nProgram load error;"  "|de|\r\nProgrammladefehler;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_OPT_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nOptions parameter;"  "|de|\r\nOptionsparameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_INFO_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nInfo parameter;"  "|de|\r\nInfo-Parameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    if(diagnosis_ext_1_byte_1 & DIA_DATA_MEM)
    {
    	 PDM_Diag_Rule_Message  += "\r\nData memory;"  "|de|\r\nDatenspeicher;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_CONTR_CALC)
    {
    	 PDM_Diag_Rule_Message  += "\r\nControl calculation;"  "|de|\r\nBerechnung Regelung;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_PA_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nPA parameter;"  "|de|\r\nPA Parameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_DIA_PARA)
    {
    	 PDM_Diag_Rule_Message  += "\r\nDiagnosis parameter;"  "|de|\r\nDiagnoseparameter;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    /* -------------------- diagnosis_ext byte 5 ------------------------- */

    if(diagnosis_ext_1_byte_1 & DIA_RESET_COMM_CONTR)
    {
    	 PDM_Diag_Rule_Message  += "\r\nReset communication controller;"  "|de|\r\nReset Kommunikations-Controller;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_RESET_BUSANSCHALTUNG)
    {
    	 PDM_Diag_Rule_Message  += "\r\nReset communication interface;"  "|de|\r\nReset HW Busanschaltung;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_BIN2_DEAKT)
    {
    	 PDM_Diag_Rule_Message  += "\r\nBin Input 2 deactivated;"  "|de|\r\nBin Eingang 2 deaktiviert;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }

    if(diagnosis_ext_1_byte_1 & DIA_RESET_APPL_CONTR)
    {
    	 PDM_Diag_Rule_Message  += "\r\nReset application controller;"  "|de|\r\nReset Anwendungs-Controller;" +
		                             " -> Help ;" "|de| -> Hilfe ;";
    }


    /* -------------------- diagnosis_ext_2 byte 2 und 3 ---------------- */

    if( diagnosis_ext_2_byte_23 & DIA_EXT_LEACK_SOON_EXP)
		{
		  PDM_Diag_Rule_Message  += "\r\nExternal leakage perhaps soon existing;"  "|de|\r\nExterne Leckage eventuell bald vorhanden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}

    if( diagnosis_ext_2_byte_23 & DIA_EXT_LEACK_PERHAPS)
		{
		  PDM_Diag_Rule_Message  += "\r\nExternal leakage perhaps existing;"  "|de|\r\nExterne Leckage eventuell vorhanden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}

    if( diagnosis_ext_2_byte_23 & DIA_EXT_LEACKAGE)
		{

		  PDM_Diag_Rule_Message  += "\r\nExternal leakage "  "|de|\r\nExterne Leckage" +
		                            " -> Check packing" "|de| -> Stopfbuchse berprfen;";
		}

		if( diagnosis_ext_2_byte_23 & DIA_EXT_TREND_END_POS_MON_DOWN_AB_REF )
		{
		  PDM_Diag_Rule_Message  += "\r\nTrend end pos.: ZP-shift monotone down; aver. above ref.;"  "|de|\r\nNullpunkt verschiebt sich monoton nach unten Mittelwert oberhalb der Referenzgeraden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}

		if( diagnosis_ext_2_byte_23 & DIA_EXT_TREND_END_POS_MON_UP_AB_REF )
		{
		  PDM_Diag_Rule_Message  += "\r\nTrend end pos.: ZP-shift monotone up; aver. above ref.;"  "|de|\r\nNullpunkt verschiebt sich monoton nach oben Mittelwert oberhalb der Referenzgeraden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}

		if( diagnosis_ext_2_byte_23 & DIA_EXT_TREND_END_POS_ALT )
		{
		  PDM_Diag_Rule_Message  += "\r\nTrend end pos.: ZP-shift alternate; aver. above ref.;"  "|de|\r\nTrend Endlage: NP altern.; MW ob. Ref.-geraden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}

		if( diagnosis_ext_2_byte_23 & DIA_EXT_TREND_END_POS_MON_DOWN_UNDER_REF )
		{
		  PDM_Diag_Rule_Message  += "\r\nTrend end pos.: ZP-shift monotone down; aver. under ref.;"  "|de|\r\nTrend Endlage: NP-versch. monoton unten; MW unt. Ref.-geraden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}

		if( diagnosis_ext_2_byte_23 & DIA_EXT_TRAND_END_POS_MON_UP_UNDER_REF )
		{
		  PDM_Diag_Rule_Message  += "\r\nTrend end pos.: ZP-shift monotone up; aver. under ref.;"  "|de|\r\nTrend Endlage: NP-versch. monoton oben; MW unt. Ref.-geraden;" +
		                            "\r\nHelp ;" "|de|\r\nHilfe ;";
		}
		/* -------------------- diagnosis_ext_2 byte 4 und 5 ---------------- */




		/* ------------------------------------------------------------------ */


    /* wenn nirgens gesetzt worden ist: */
		if( PDM_Diag_Status_Diagnosis == 0 )
		{
			PDM_Diag_Rule_Message     = [dia_OK];
		}

  }
}
/*****************************************************************************/

/* fr Aufruf von Manual 3730-4: */
METHOD methodOpenDeviceManual_3730
{
    LABEL "SAMSON 3730-4 Mounting and operating instructions"
          "|049SAMSON 3730-4 Einbau- und Bedienungsanleitung";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3730);
	}
    HELP "Mounting and operating instructions of the positioner 3730-4."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3730-4.";
}
/*****************************************************************************/

/* fr Aufruf von Manual 3731-4: */
METHOD methodOpenDeviceManual_3731
{
    LABEL "SAMSON 3731-4 Mounting and operating instructions"
          "|049SAMSON 3731-4 Einbau- und Bedienungsanleitung";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(DEVICE_MANUAL_FILENAME_3731);
	}
    HELP "Mounting and operating instructions of the positioner 3731-4."
         "|de|Einbau- und Bedienungsanleitung des Stellungsreglers 3731-4.";
}

/*****************************************************************************/
/* fr Aufruf von Ventildiagnose EXPERT+: */
METHOD methodOpenValveDiagnostics
{
    LABEL "SAMSON EXPERT+ Valve Diagnostics" "|049SAMSON EXPERT+ Ventildiagnose";
	ACCESS OFFLINE;
	DEFINITION
	{
		ShellExecute(VALVE_DIAGNOSTICS_FILENAME);
	}
    HELP "EXPERT+ Valve Diagnostics of the positioner series 373X-4."
         "|de|EXPERT+ Ventildiagnose der Stellungsregler Serie 373X-4.";
}
/*****************************************************************************/


METHOD sie_set
{
    LABEL       [transfer];
    DEFINITION
    {
    }
    HELP        [transfer_help];
}

/*----------------------------------------------------------------------------*/
METHOD meld_init_art                      /* nderung der Initialisierungsart */
{
    LABEL "Message" "|de|Meldung";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ACKNOWLEDGE("A change of the initialization method will"
                    " take effect only after a new initialization !"
                    "|de|Eine nderung der Initialisierungsart wird erst"
                    " nach einer erneuten Initialisierung wirksam !");
    }
}
/*----------------------------------------------------------------------------*/
METHOD meld_wirksamkeit            /* nderung von phys_ident_number_selector */
{
    LABEL "Message" "|de|Meldung";
    DEFINITION
    {
        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ACKNOWLEDGE("A change of Selection Ident.-number will"
                    " take effect only after a device restart !"
                    "|de|Eine nderung der Auswahl Ident.-Nummer wird erst"
                    " nach einem Neustart des Gertes wirksam !");
    }
}
/*----------------------------------------------------------------------------*/
METHOD abort_initialization            /* Abbruch der Initialisierungssequenz */
{
    LABEL "Abort process in action"
          "|de|Laufende Aktion abbrechen";
    DEFINITION
    {
        int  HWwrProt;
        int  SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        iassign (trans1_self_calibration_cmd, ABBRUCH);   /* Abbruch starten     */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        iassign (trans1_self_calibration_cmd, 0);   /* zur Sicherheit auf neutral stellen */
        DELAY(5,"Action aborted"
                    "|de|Aktion wurde abgebrochen");
    }
    HELP "Aborts running calibration sequence."
         "|de|Abbruch der laufenden Kalibrierungssequenz.";
}
/*----------------------------------------------------------------------------*/
METHOD cal_zero_valve                                    /* Nullpunktabgleich */
{
    LABEL "Start zero adjustment"
          "|de|Nullpunktabgleich starten";
    DEFINITION
    {
        int  HWwrProt;
        int  SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Never start zero adjustment during a running process !\n"
                    "During zero adjustment the control valve departs from its current "
                    "position at full travel !\n\n"
                    "Status of zero adjustment: see parameter 'Status initialization'.\n\n"
                    "Start zero adjustment ?"
                    "|de|WARNUNG: Der Nullpunktabgleich darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Nullpunktabgleich fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status des Nullpunktabgleichs: siehe Parameter 'Status Initialisierung'.\n\n"
                    "Nullpunktabgleich starten ?");

        add_abort_method(abort_initialization);
        iassign (trans1_self_calibration_cmd, NULLP_CAL); /* Nullpunktabgleich starten */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        iassign (trans1_self_calibration_cmd, 0);   /* zur Sicherheit auf neutral stellen */
        DELAY(20,"Zero adjustment is running"
                "|de|Nullpunktabgleich luft");
    }
    HELP "Automatic zero point correction."
         "|de|Automatische Korrektur des Nullpunktes.";
}
/*----------------------------------------------------------------------------*/
/* Initialisierung (ohne erweiterte Initialisierung) ! */
METHOD init_valve
{
    LABEL "Start initialization"
          "|de|Initialisierung starten";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Never start initialization during a running process !\n"
                    "During initialization the control valve departs from its current"
                    "position at full travel !\n\n"
                    "Status of initialization: see parameter 'Status initialization'.\n\n"
                    "Start initialization ?"
                    "|de|WARNUNG: Die Initialisierung darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\n"
                    "Bei Initialisierung fhrt das Stellgert den gesamten Bereich durch !\n\n"
                    "Status der Initialisierung: siehe Parameter 'Status Initialisierung'.\n\n"
                    "Initialisierung starten ?");

        add_abort_method(abort_initialization);
        iassign (trans1_self_calibration_cmd, INIT);  /* Initialisierung starten */
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        iassign (trans1_self_calibration_cmd, 0);   /* zur Sicherheit auf neutral stellen */
        DELAY(10,"Initialization is running"
                "|de|Initialisierung luft");
    }
    HELP "Start the initialization sequence. "
         "Previously the parameter 'initialization mode' must have the required value."
         "|de|Start der Initialisierungssequenz. "
         "Der Parameter Initialisierungsart muss vorher auf die gewnschte "
         "Initialisierungssequenz eingestellt sein.";
}
/*----------------------------------------------------------------------------*/
METHOD warmstart                                                 /* Warmstart */
{
    LABEL "Warm start of the device"
          "|de|Auslsen eines Warmstarts";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Application data will be set to default values !\n"
                    "Never start warm start during a running process !\n"
                    "During warm start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Der Warmstart darf nicht whrend eines laufenden"
                    " Prozesses erfolgen !\nBei Warmstart fhrt das Stellgert den"
                    " gesamten Bereich durch !\nAusfhren ?");

        DELAY(2,"Warm start is starting"
                "|de|Warmstart wird gestartet");
        lassign(phys_factory_reset, 2506);       /* Warmstart auslsen  */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        lassign(phys_factory_reset, 0);          /* auf neutral stellen */
        DELAY(10,"Warm start is running"
                 "|de|Warmstart luft");
        ACKNOWLEDGE("Warm start was executed"
                    "|de|Warmstart wurde ausgefhrt");
    }
    HELP "Command to reset the device (warm start)."
         "|de|Auslsen eines Warmstarts.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_appl                                /* Kaltstart Applikation */
{
    LABEL "Start-up, function block and classification parameter"
          "|de|Inbetriebnahmeparameter, Funktionsblcke und Klassifizierung";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Application data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Applikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        DELAY(2,"Reset application is starting"
                "|de|Kaltstart Applikation wird gestartet");
        lassign (phys_factory_reset, 32769);     /* Kaltstart Applikation auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        lassign (phys_factory_reset, 0);         /* auf neutral stellen */
        DELAY(15,"Running" "|de|Luft");
        ACKNOWLEDGE("Reset application executed. New communication startup"
                    " necessary to get current device data."
                    "|de|Rcksetzen der Applikation durchgefhrt."
                    " Erneuter Verbindungsaufbau erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset start-up, function block and classification parameter."
         "|de|Rcksetzen Inbetriebnahmeparameter, Funktionsblcke und Klassifizierung.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_ident                      /* Kaltstart Gerteidentifikation */
{
    LABEL "Device identification"
          "|de|Gerteidentifikationsdaten";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Device identification data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Gerteidentifikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        DELAY(2,"Reset device identification is starting"
                "|de|Kaltstart Gerteidentifikation wird gestartet");
        lassign (phys_factory_reset, 32768);     /* Kaltstart Identifikation auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        lassign (phys_factory_reset, 0);         /* auf neutral stellen */
        DELAY(3,"Reset device identification is running"
                "|de|Kaltstart Gerteidentifikation luft");
        ACKNOWLEDGE("Reset device identification executed."
                    " New communication startup is necessary to get"
                    " current device data."
                    "|de|Rcksetzen der Gerteidentifikation durchgefhrt."
                    " Erneuter Verbindungsaufbau ist erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset device identification to default values."
         "|de|Rcksetzen der Gerteidentifikationsdaten auf Kaltstartwerte.";
}
/*----------------------------------------------------------------------------*/
METHOD coldstart_appl_ident         /* Kaltstart Applikation + Identifikation */
{
    LABEL "Start-up, device identification, function blocks and classification parameter"
          "|de|Inbetriebnahmeparameter, Gerteidentifikation, Funktionsblcke und Klassifizierung";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Device identification and application data will be set to default values !\n"
                    "Never start cold start during a running process !\n"
                    "During cold start the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Gerteidentifikationsdaten und Applikationsdaten werden zurckgesetzt !\n"
                    "Der Kaltstart darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Bei Kaltstart fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        DELAY(2,"Reset application and device identification is starting"
                "|de|Kaltstart Applikation und Gerteidentifikationsdaten wird gestartet");
        lassign (phys_factory_reset, 1);    /* Kaltstart Applikation+Ger.-ID auslsen */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        lassign (phys_factory_reset, 0);         /* auf neutral stellen */
        DELAY(15,"Running" "|de|Luft");
        ACKNOWLEDGE("Reset executed. New communication startup"
                    " necessary to get current device data."
                    "|de|Rcksetzen durchgefhrt."
                    " Erneuter Verbindungsaufbau erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset start-up, device identification, function blocks and classification parameter (Code 36)."
         "|de|Rcksetzen Inbetriebnahmeparameter, Gerteidentifikation, Funktionsblcke und Klassifizierung (Code 36).";
}
/*----------------------------------------------------------------------------*/
METHOD wegint_reset                                 /* Rcksetzen Wegintegral */
{
    LABEL "Reset total valve travel"
          "|de|Rcksetzen Wegintegral";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        iassign (trans1_self_calibration_cmd, WEGINT_RESET);
        WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        iassign (trans1_self_calibration_cmd, 0);   /* zur Sicherheit auf neutral stellen */
        DELAY(5,"Reset total valve travel in process"
                "|de|Wegintegral wird zurckgesetzt");
    }
    HELP "Reset total valve travel to 0."
         "|de|Rcksetzen des Wegintegrals auf 0.";
}
/*----------------------------------------------------------------------------*/
METHOD reset_busadr                              /* Rcksetzen der Busadresse */
{
    LABEL   "Reset bus address to 126"
            "|de|Rcksetzen der Busadresse auf 126";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: Bus address will be reset to factory value 126 !\n"
                    "Then communication is possible only with this bus address !\n"
                    "Execute ?"
                    "|de|WARNUNG: Die Busadresse wird auf den Auslieferwert 126 gestellt !\n"
                    "Verbindung kann dann nur noch mit dieser Busadresse aufgebaut werden !\n"
                    "Ausfhren ?");
        lassign (phys_factory_reset, 2712);      /* Reset Busadresse auslsen  */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        lassign (phys_factory_reset, 0);         /* auf neutral stellen */
        ACKNOWLEDGE("Bus address was reset"
                    "|de|Busadresse wurde zurckgesetzt");
    }
    HELP "Bus address in the device is set to factory value 126."
         "|de|Die Busadresse im Gert wird auf den Auslieferwert 126 zurckgesetzt.";
}
/*----------------------------------------------------------------------------*/
METHOD reset_code_36                             /* Reset, entspricht Code 36 */
{
    LABEL   "Start-up parameter"
            "|de|Inbetriebnahmeparameter";
    DEFINITION
    {
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* Prfung auf HW- und SW-Schreibschutz */
        ACKNOWLEDGE("WARNING: All device data will be set to default values !\n"
                    "Never start reset during a running process !\n"
                    "During reset the control valve departs from its current"
                    " position at full travel !\nExecute ?"
                    "|de|WARNUNG: Alle Gerteparameter werden zurckgesetzt !\n"
                    "Das Rcksetzen darf nicht whrend eines laufenden Prozesses erfolgen !\n"
                    "Beim Rcksetzen fhrt das Stellgert den gesamten Bereich durch !\n"
                    "Ausfhren ?");

        lassign (phys_factory_reset, 32770);     /* Reset (Code 36) auslsen  */
        WriteCommand (write_phys_factory_reset); /* ins Gert schreiben */
        lassign (phys_factory_reset, 0);         /* auf neutral stellen */
        ACKNOWLEDGE("Reset executed. New communication startup"
                    " necessary to get current device data."
                    "|de|Rcksetzen durchgefhrt."
                    " Erneuter Verbindungsaufbau erforderlich,"
                    " um Gertedaten zu aktualisieren.");
    }
    HELP "Reset start-up parameter to default values. Corresponds to Code 36"
         "|de|Rcksetzen der Inbetriebnahmeparameter auf Kaltstartwerte. ";
}


/* ------------------------------------------------------------------------ */
/* Ruecksetzen der Fehlerbits                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_fehler
{
    LABEL "Reset error" "|049Rcksetzen Fehler";

    DEFINITION
    {
        int   result;
        int   HWwrProt;
        int   SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        CHECK_WRITE_PROTECTION /* auf Schreibschutz testen */

        result = SELECT_FROM_LIST("Reset error:" "|049Rcksetzen Fehler:",
          "x > range;"             /* 0  Fehler 50   */
          "Delta x < range;"       /* 1  Fehler 51   */
          "Attachment;"            /* 2  Fehler 52   */
          "Init. time >;"          /* 3  Fehler 53   */
          "Init./sol. valve;"      /* 4  Fehler 54   */
          "Travel time <;"         /* 5  Fehler 55   */
          "Pin position;"          /* 6  Fehler 56   */
          "Zero point;"            /* 7  Fehler 58   */
          "Autocorrection;"        /* 8  Fehler 59   */
          "Hardware;"              /* 9  Fehler 65   */
          "Test calculation;"      /* 10 Fehler 67   */
          "Control parameter;"     /* 11 Fehler 68   */
          "Poti parameter;"        /* 12 Fehler 69   */
          "General parameter;"     /* 13 Fehler 71   */
          "Info parameter;"        /* 14 Fehler 75   */
          "Diagnosis parameter;"   /* 15 Fehler 80   */
          "Options parameter"      /* 16 Fehler 78   */

          "|049x > Bereich;"       /* 0  Fehler 50   */
          "Delta x < Bereich;"     /* 1  Fehler 51   */
          "Anbau;"                 /* 2  Fehler 52   */
          "Init.-zeit >;"          /* 3  Fehler 53   */
          "Init./Magnetventil;"    /* 4  Fehler 54   */
          "Laufzeit <;"            /* 5  Fehler 55   */
          "Stiftposition;"         /* 6  Fehler 56   */
          "Nullpunkt;"             /* 7  Fehler 58   */
          "Autokorrektur;"         /* 8  Fehler 59   */
          "Hardware;"              /* 9  Fehler 65   */
          "Kontrollrechnung;"      /* 10 Fehler 67   */
          "Regelparameter;"        /* 11 Fehler 68   */
          "Potiparameter;"         /* 12 Fehler 69   */
          "Allg. Parameter;"       /* 13 Fehler 71   */
          "Info Parameter;"        /* 14 Fehler 75   */
          "Diagnoseparameter;"     /* 15 Fehler 80   */
          "Optionsparameter"       /* 16 Fehler 78   */
          );

        /* ------------------------------------------------------------------------ */
        /* Parameter: Rcks. Fehlercodes  Doku-Nr.: 213-236,240,330  EB-Code: ab 50 */
        /* ------------------------------------------------------------------------ */
        ACKNOWLEDGE("Reset this error message ?"
                    "|049Diese Fehlermeldung zurcksetzen ?");
        if (result == 0)
        { /* Fehler 50  (X > Bereich-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 28);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 1)
        { /* Fehler 51  (dX > Bereich zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 29);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 2)
        { /* Fehler 52  (Anbau-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 30);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 3)
        { /* Fehler 53  (Init-Zeit > - Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 31);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 4)
        { /* Fehler 54  (Init-MGV-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 32);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 5)
        { /* Fehler 55  (Laufzeit < - Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 33);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 6)
        { /* Fehler 56  (Stiftposition-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 34);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 7)
        { /* Fehler 58  (Nullpunkt-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 24);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 8)
        { /* Fehler 59  (Autokorrektur-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 25);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 9)
        { /* Fehler 65  (Hardware-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 42);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 10)
        { /* Fehler 67  (Kontrollrechnung-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 53);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 11)
        { /* Fehler 68  (Regelparameter-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 43);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 12)
        { /* Fehler 69  (Poti-Parameter-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 44);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 13)
        { /* Fehler 71  (Allgemeine-Parameter-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 46);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 14)
        { /*  Fehler 75  (Info Parameter-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 51);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 15)
        { /*  Fehler 80  (Diagnoseparameter-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 55);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }
        if (result == 16)
        { /*  Fehler 78  (Optionsparameter-Fehler zuruecksetzen) */
          iassign (trans1_self_calibration_cmd, 50);
          WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
        }

        iassign (trans1_self_calibration_cmd, 0);   /* zur Sicherheit auf neutral stellen */
        DELAY(3,"resetting..." "|049wird zurckgesetzt...");
    }

    HELP "Resets different flags back to zero."
         "|049Setzt verschiedene Flags auf 0 zurck.";
}


/*----------------------------------------------------------------------------*/
METHOD check_write_protection_before_write        /* auf Schreibschutz prfen */
{
    LABEL "check_write_protection_before_write";
    DEFINITION
    {
        int  HWwrProt;
        int  SWwrProt;

        FUNCTIONS_IGNORE_XXX   /* Standardfunktionen */
        ReadCommand (read_phys_write_locking);       /* SW-Schreibschutz auslesen */
        SWwrProt = ivar_value (phys_write_locking);
        ReadCommand (read_phys_hw_write_protection); /* HW-Schreibschutz auslesen */
        HWwrProt = ivar_value (phys_hw_write_protection);
        if (HWwrProt == 1)       /* wenn HW-Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected (hardware write protection)."
                        "|de|Gert ist schreibgeschtzt (Hardware-Schreibschutz).");
        }
        if (SWwrProt == 0)       /* wenn SW-Schreibschutz aktiv */
        {
            ACKNOWLEDGE("Device is write protected (software write protection)."
                        "|de|Gert ist schreibgeschtzt (Software-Schreibschutz).");
        }
    }
}

/* ------------------------------------------------------------------------ */
/* Parameter: Geraet suchen                Doku-Nummer: 362   EB-Code: --   */
/* ------------------------------------------------------------------------ */
METHOD search_device
{
    LABEL "Search device" "|de|Gert suchen";

    DEFINITION
    {
      int  HWwrProt;
      int  SWwrProt;

       CHECK_WRITE_PROTECTION    /* auf Schreibschutz testen */

       iassign (trans1_self_calibration_cmd, 6);         /* starten     */
       WriteCommand (write_trans1_self_calibration_cmd); /* ins Gert schreiben */
    }

    HELP "Displays 'Here I am' at the connected device."
         "|de|Anzeige von 'Here I am' am angeschlossenem Gert.";
}



/* ------------------------------------------------------------------------ */
/* Starten und Abbrechen von Tests                                          */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */

#define ABORT_TEST_ACKNOWLEDGE                                \
       ACKNOWLEDGE("Terminate running test ?"                 \
                   "|de|Laufenden Test beenden ?");

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_data_logger
{
    LABEL "Start data logger" "|de|Start Datenlogger";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ACKNOWLEDGE("Execute test ?" "|de|Test ausfhren ?");
       iassign (trans1_enhanced_diag_cmd, 1);         /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Start the data logger. Can only be performed in the AUTOMATIC operating mode."
         "|de|Startet den Datenlogger. Ausfhrung nur in der Betriebsart AUTO mglich.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_data_logger
{
    LABEL "Stop data logger" "|de|Stopp Datenlogger";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 2);         /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the data logger."
         "|de|Beendet den Datenlogger.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_hys_online_test
{
    LABEL "Start test" "|de|Start Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       iassign (trans1_enhanced_diag_cmd, 3);         /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Activates the hysteresis online test."
         "|de|Aktiviert den Hysterese Online Test.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_hys_online_test
{
    LABEL "Terminate test" "|de|Test beenden";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 4);         /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Deactivates the hysteresis online test."
         "|de|Deaktiviert den Hysterese Online Test.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_step_response
{
    LABEL "Start step response" "|de|Start Sprungantwort";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ACKNOWLEDGE("Warning: During test start the control valve departs from its "
                   "current position at full travel. \nExecute test ?"
                   "|de|Warnung: Bei diesem Test kann das Stellventil den "
                   "gesamten Hubbereich durchfahren. \nTest ausfhren ?");
       iassign (trans1_enhanced_diag_cmd, 5);         /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(10,"Test is running"
                "|de|Testfunktion luft");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Starts the step response test (d4)."
         "|de|Starten der Sprungantwort (d4).";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_step_response
{
    LABEL "Stop step response" "|de|Stopp Sprungantwort";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 6);         /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the execution of the test."
         "|de|Beendet die Durchfhrung vom Test.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_all_tests_MAN
{
    LABEL "Start all tests" "|de|Alle Testlufe starten";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ACKNOWLEDGE("Warning: During test start the control valve departs from its "
                   "current position at full travel. \nExecute test ?"
                   "|de|Warnung: Bei diesem Test kann das Stellventil den "
                   "gesamten Hubbereich durchfahren. \nTest ausfhren ?");
       iassign (trans1_enhanced_diag_cmd, 7);         /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(10,"Tests are running"
                "|de|Testlufe gestartet");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "All tests will be carried out one after the other. "
         "The tests can only be conducted in the MANUAL operating mode."
         "|de|Alle Testlufe werden nacheinander durchgefhrt. "
         "Ausfhrung nur in der Betriebsart HAND mglich.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_all_tests_MAN
{
    LABEL "Stop all tests" "|de|Alle Testlufe beenden";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 8);         /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the execution of the tests."
         "|de|Beendet die Durchfhrung der Testlufe.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_drive_signal_diagram_steady
{
    LABEL "Start test" "|de|Start Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ACKNOWLEDGE("Warning: During test start the control valve departs from its "
                   "current position at full travel. \nExecute test ?"
                   "|de|Warnung: Bei diesem Test kann das Stellventil den "
                   "gesamten Hubbereich durchfahren. \nTest ausfhren ?");
       iassign (trans1_enhanced_diag_cmd, 9);         /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(10,"Test is running"
                "|de|Testfunktion luft");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Starts the execution of the test. "
         "The test can only be performed in the MANUAL operating mode."
         "|de|Startet die Durchfhrung vom Test. "
         "Ausfhrung nur in der Betriebsart HAND mglich.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_drive_signal_diagram_steady
{
    LABEL "Stop test" "|de|Stopp Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 10);        /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the execution of the test."
         "|de|Beendet die Durchfhrung vom Test.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_drive_signal_diagram_hys
{
    LABEL "Start test" "|de|Start Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ACKNOWLEDGE("Warning: During test start the control valve departs from its "
                   "current position at full travel. \nExecute test ?"
                   "|de|Warnung: Bei diesem Test kann das Stellventil den "
                   "gesamten Hubbereich durchfahren. \nTest ausfhren ?");
       iassign (trans1_enhanced_diag_cmd, 11);        /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(10,"Test is running"
                "|de|Testfunktion luft");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Starts the execution of the test. "
         "The test can only be performed in the MANUAL operating mode."
         "|de|Startet die Durchfhrung vom Test. "
         "Ausfhrung nur in der Betriebsart HAND mglich.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_drive_signal_diagram_hys
{
    LABEL "Stop test" "|de|Stopp Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 12);        /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the execution of the test."
         "|de|Beendet die Durchfhrung vom Test.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_static_char
{
    LABEL "Start test" "|de|Start Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ACKNOWLEDGE("Warning: During test start the control valve departs from its "
                   "current position at full travel. \nExecute test ?"
                   "|de|Warnung: Bei diesem Test kann das Stellventil den "
                   "gesamten Hubbereich durchfahren. \nTest ausfhren ?");
       iassign (trans1_enhanced_diag_cmd, 13);        /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(10,"Test is running"
                "|de|Testfunktion luft");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Starts the execution of the test. "
         "The test can only be performed in the MANUAL operating mode."
         "|de|Startet die Durchfhrung vom Test. "
         "Ausfhrung nur in der Betriebsart HAND mglich.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_static_char
{
    LABEL "Stop test" "|de|Stopp Testlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 14);        /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the execution of the test."
         "|de|Beendet die Durchfhrung vom Test.";
}

/* ------------------------------------------------------------------------ */
/* Starten von Test                                                         */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD start_reference_test
{
    LABEL "Start reference test" "|de|Start Referenzlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       iassign (trans1_enhanced_diag_cmd, 15);        /* starten */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(10,"Test functions d1 and d2 are running"
                "|de|Testfunktionen d1 und d2 werden ausgefhrt");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Starts both reference tests d1 and d2. "
         "The test can only be performed in the MANUAL operating mode."
         "|de|Startet die beiden Referenzlufe d1 und d2. "
         "Ausfhrung nur in der Betriebsart HAND mglich.";
}

/* ------------------------------------------------------------------------ */
/* Abbrechen von Test                                                       */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD abort_reference_test
{
    LABEL "Stop reference test" "|de|Stopp Referenzlauf";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       ABORT_TEST_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 16);        /* abbrechen */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       DELAY(5,"Stop reference test"
               "|de|Stopp Referenzlauf");
    }
    VALIDITY_ONLY_EXPERT_PLUS

    HELP "Terminates the execution of the test."
         "|de|Beendet die Durchfhrung vom Test.";
}



/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */

#define RESET_DATA_ACKNOWLEDGE                          \
       ACKNOWLEDGE("Reset these data ?"                 \
                   "|de|Diese Daten zurcksetzen ?");

#define RESET_DATA_ACKNOWLEDGE_READY                    \
       ACKNOWLEDGE("Data were reset."                   \
                   "|de|Daten wurden zurckgesetzt.");


/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_logger
{
    LABEL "Reset 'Logger'" "|de|Rcksetzen 'Protokollierung'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 17);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data in the logging buffer were deleted."
         "|de|Messwerte im Protokollierungspuffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_travel_hist_x_long
{
    LABEL "Reset 'Travel histogram x'"
          "|de|Rcksetzen 'Histogramm Ventilstellung x'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 21);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the long-term histogram were deleted."
         "|de|Messwerte im Langzeit-Histogramm werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_travel_hist_x_short
{
    LABEL "Reset 'Travel histogram x - short-term'"
          "|de|Rcksetzen 'Histogramm Ventilstellung x Kurzzeit'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 29);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the short-term histogram were deleted."
         "|de|Messwerte im Kurzzeit-Histogramm werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_setpoint_hist_e_long
{
    LABEL "Reset 'Setpoint deviation histogram e'"
          "|de|Rcksetzen 'Histogramm Regelabweichung e'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 23);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the long-term histogram were deleted."
         "|de|Messwerte im Langzeit-Histogramm werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_setpoint_hist_e_short
{
    LABEL "Reset 'Setpoint deviation histogram e - short-term'"
          "|de|Rcksetzen 'Histogramm Regelabweichung e Kurzzeit'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 30);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the short-term histogram were deleted."
         "|de|Messwerte im Kurzzeit-Histogramm werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_cycle_counter_hist_long
{
    LABEL "Reset 'Cycle counter histogram'"
          "|de|Rcksetzen 'Histogramm Zyklenzhler'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 22);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the long-term histogram were deleted."
         "|de|Messwerte im Langzeit-Histogramm werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_cycle_counter_hist_short
{
    LABEL "Reset 'Cycle counter histogram - short-term'"
          "|de|Rcksetzen 'Histogramm Zyklenzhler Kurzzeit'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 31);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the short-term histogram were deleted."
         "|de|Messwerte im Kurzzeit-Histogramm werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_drive_signal_dia_steady_long
{
    LABEL "Reset 'Drive signal diagram steady'"
          "|de|Rcksetzen 'Diagramm Stellsignal y - Stationr'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 24);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the ring buffer were deleted."
         "|de|Messwerte im Ringpuffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_drive_signal_dia_steady_short
{
    LABEL "Reset 'Drive signal diagram steady - short-term'"
          "|de|Rcksetzen 'Diagramm Stellsignal y - Stationr Kurzzeit'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 25);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the ring buffer were deleted."
         "|de|Messwerte im Ringpuffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_drive_signal_dia_hys_long
{
    LABEL "Reset 'Drive signal diagram hysteresis'"
          "|de|Rcksetzen 'Diagramm Stellsignal y - Hysterese'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 26);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the buffer were deleted."
         "|de|Messwerte im Puffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_drive_signal_dia_his_short
{
    LABEL "Reset 'Drive signal diagram hysteresis - short-term'"
          "|de|Rcksetzen 'Diagramm Stellsignal y - Hysterese Kurzzeit'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 32);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the buffer were deleted."
         "|de|Messwerte im Puffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_lower_end_pos
{
    LABEL "Reset 'Lower end position'"
          "|de|Rcksetzen 'Unterer Endlagentrend'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 27);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the lower end position of the buffer were deleted."
         "|de|Messwerte der unteren Endlage im Puffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_lower_end_pos_ref_values
{
    LABEL "Reset 'Lower end position - ref. values'"
          "|de|Rcksetzen 'Unterer Endlagentrend - Referenzwerte'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 28);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the lower end position of the buffer were deleted."
         "|de|Messwerte der unteren Endlage im Puffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_drive_signal_dia_steady_data
{
    LABEL "Reset 'Drive signal diagram steady measured data'"
          "|de|Rcksetzen 'Diagramm Stellsignal y - Stationr Messwerte'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 38);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the ring buffer were deleted."
         "|de|Messwerte im Ringpuffer werden gelscht.";
}

/* ------------------------------------------------------------------------ */
/* Reset EXPERT/EXPERT+ Daten                                               */
/* (trans1_enhanced_diag_cmd)                                               */
/* ------------------------------------------------------------------------ */
METHOD reset_diag_drive_signal_dia_hys_data
{
    LABEL "Reset 'Drive signal diagram hysteresis measured data'"
          "|de|Rcksetzen 'Diagramm Stellsignal y - Hysterese Messwerte'";
    DEFINITION
    {
       int  HWwrProt;
       int  SWwrProt;

       CHECK_WRITE_PROTECTION                         /* auf Schreibschutz testen */
       RESET_DATA_ACKNOWLEDGE
       iassign (trans1_enhanced_diag_cmd, 39);        /* reset */
       WriteCommand (write_trans1_enhanced_diag_cmd); /* ins Gert schreiben */
       iassign (trans1_enhanced_diag_cmd, 0);         /* auf neutral stellen */
       RESET_DATA_ACKNOWLEDGE_READY
    }
    HELP "Measured data of the ring buffer were deleted."
         "|de|Messwerte im Ringpuffer werden gelscht.";
}





/******************************************************************************/
/*      Communication Error Handling                                          */
/******************************************************************************/
VARIABLE CommError_0000_009F
{
    LABEL       [comm_err_dp_error_reserved];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_error_reserved_help];
}

VARIABLE CommError_00A0_00A0
{
    LABEL       [comm_err_dp_read_error];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_read_error_help];
}

VARIABLE CommError_00A1_00A1
{
    LABEL       [comm_err_dp_write_error];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_write_error_help];
}

VARIABLE CommError_00A2_00A2
{
    LABEL       [comm_err_dp_module_failure];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_module_failure_help];
}

VARIABLE CommError_00A3_00A7
{
    LABEL       [comm_err_dp_application_reserved];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_application_reserved_help];
}

VARIABLE CommError_00A8_00A8
{
    LABEL       [comm_err_dp_version_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_version_conflict_help];
}

VARIABLE CommError_00A9_00A9
{
    LABEL       [comm_err_dp_feature_not_supported];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_feature_not_supported_help];
}

VARIABLE CommError_00AA_00AF
{
    LABEL       [comm_err_dp_application_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_application_user_specific_help];
}

VARIABLE CommError_00B0_00B0
{
    LABEL       [comm_err_dp_invalid_index];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_index_help];
}

VARIABLE CommError_00B1_00B1
{
    LABEL       [comm_err_dp_write_length_error];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_write_length_error_help];
}

VARIABLE CommError_00B2_00B2
{
    LABEL       [comm_err_dp_invalid_slot];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_slot_help];
}

VARIABLE CommError_00B3_00B3
{
    LABEL       [comm_err_dp_type_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_type_conflict_help];
}

VARIABLE CommError_00B4_00B4
{
    LABEL       [comm_err_dp_invalid_area];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_area_help];
}

VARIABLE CommError_00B5_00B5
{
    LABEL       [comm_err_dp_state_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_state_conflict_help];
}

VARIABLE CommError_00B6_00B6
{
    LABEL       [comm_err_dp_access_denied];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_access_denied_help];
}

VARIABLE CommError_00B7_00B7
{
    LABEL       [comm_err_dp_invalid_range];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_range_help];
}

VARIABLE CommError_00B8_00B8
{
    LABEL       [comm_err_dp_invalid_parameter];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_parameter_help];
}

VARIABLE CommError_00B9_00B9
{
    LABEL       [comm_err_dp_invalid_type];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_invalid_type_help];
}

VARIABLE CommError_00BA_00BF
{
    LABEL       [comm_err_dp_access_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   0;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_access_user_specific_help];
}

VARIABLE CommError_00C0_00C0
{
    LABEL       [comm_err_dp_read_constrain_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_read_constrain_conflict_help];
}

VARIABLE CommError_00C1_00C1
{
    LABEL       [comm_err_dp_write_constrain_conflict];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_write_constrain_conflict_help];
}

VARIABLE CommError_00C2_00C2
{
    LABEL       [comm_err_dp_resource_busy];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_resource_busy_help];
}

VARIABLE CommError_00C3_00C3
{
    LABEL       [comm_err_dp_resource_unavailable];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_resource_unavailable_help];
}

VARIABLE CommError_00C4_00C7
{
    LABEL       [comm_err_dp_resource_reserved];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_resource_reserved_help];
}

VARIABLE CommError_00C8_00CF
{
    LABEL       [comm_err_dp_recource_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_recource_user_specific_help];
}

VARIABLE CommError_00D0_00FF
{
    LABEL       [comm_err_dp_user_specific];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [ignore]   },
        { 1, [check]    }
    }
    HELP        [comm_err_dp_user_specific_help];
}

VARIABLE CommError_ShowIgnoredErrors
{
    LABEL       [comm_show_ignored_errors];
    CLASS       LOCAL;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE   1;
        { 0, [comm_show_ignored_errors_NOT_SHOW]    },
        { 1, [comm_show_ignored_errors_SHOW]        }
    }
    HELP        [comm_show_ignored_errors_help];
}

VARIABLE CommError_Delay_Read
{
    LABEL       [comm_delay_read];
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE   0;
    }
    CONSTANT_UNIT   [msec];
    HELP        [comm_delay_read_help];
}

VARIABLE CommError_Delay_Write
{
    LABEL       [comm_delay_write];
    CLASS       LOCAL;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE   0;
    }
    CONSTANT_UNIT   [msec];
    HELP        [comm_delay_write_help];
}

MENU Menu_CommError
{
    LABEL   " ";
    ITEMS
    {
        CommError_0000_009F,            /* DP Error Reserved                            */
        CommError_00A0_00A0,            /* Application: DP Read Error                   */
        CommError_00A1_00A1,            /* Application: DP Write Error                  */
        CommError_00A2_00A2,            /* Application: DP Module Failure               */
        CommError_00A3_00A7,            /* Application: DP Application Reserved         */
        CommError_00A8_00A8,            /* Application: DP Version Conflict             */
        CommError_00A9_00A9,            /* Application: DP Feature Not Supported        */
        CommError_00AA_00AF,            /* Application: DP Application User Specific    */
        CommError_00B0_00B0,            /* Access:      DP Invalid Index                */
        CommError_00B1_00B1,            /* Access:      DP Write Length Error           */
        CommError_00B2_00B2,            /* Access:      DP Invalid Slot                 */
        CommError_00B3_00B3,            /* Access:      DP Type Conflict                */
        CommError_00B4_00B4,            /* Access:      DP Invalid Area                 */
        CommError_00B5_00B5,            /* Access:      DP State Conflict               */
        CommError_00B6_00B6,            /* Access:      DP Access Denied                */
        CommError_00B7_00B7,            /* Access:      DP Invalid Range                */
        CommError_00B8_00B8,            /* Access:      DP Invalid Parameter            */
        CommError_00B9_00B9,            /* Access:      DP Invalid Type                 */
        CommError_00BA_00BF,            /* Access:      DP Access User Specific         */
        CommError_00C0_00C0,            /* Resource:    DP Read Constrain Conflict      */
        CommError_00C1_00C1,            /* Resource:    DP Write Constrain Conflict     */
        CommError_00C2_00C2,            /* Resource:    DP Resource Busy                */
        CommError_00C3_00C3,            /* Resource:    DP Resource unavailable         */
        CommError_00C4_00C7,            /* Resource:    DP Resource Reserved            */
        CommError_00C8_00CF,            /* Resource:    DP Recource User Specific       */
        CommError_00D0_00FF             /* DP User Specific                             */
    }
}

MENU Menu_CommError_Delay
{
    LABEL   " ";
    ITEMS
    {
        CommError_Delay_Read,
        CommError_Delay_Write
    }
}


MENU OfflineDialog_CommErrorHandling
{
    LABEL   [menu_dialog_error_handling];
    ITEMS
    {
        Page_CommError_General  /*,
        Page_CommError_Application,
        Page_CommError_Access,
        Page_CommError_Resource,
        Page_CommError_Other    */
    }
}

MENU Page_CommError_General
{
    LABEL   [menu_dialog_general];
    ITEMS
    {
        CommError_Delay_Read,
        CommError_Delay_Write,
/*      CommError_ShowIgnoredErrors,    */
        CommError_DefaultHandling   /*,
        CommError_CheckAllErrors,
        CommError_IgnoreAllErrors   */
    }
}

MENU Page_CommError_Application
{
    LABEL   [menu_dialog_error_handling_application];
    ITEMS
    {
        CommError_00A0_00A0,    /* Application: DP Read Error                   */
        CommError_00A1_00A1,    /* Application: DP Write Error                  */
        CommError_00A2_00A2,    /* Application: DP Module Failure               */
        CommError_00A3_00A7,    /* Application: DP Application Reserved         */
        CommError_00A8_00A8,    /* Application: DP Version Conflict             */
        CommError_00A9_00A9,    /* Application: DP Feature Not Supported        */
        CommError_00AA_00AF     /* Application: DP Application User Specific    */
    }
}

MENU Page_CommError_Access
{
    LABEL   [menu_dialog_error_handling_access];
    ITEMS
    {
        CommError_00B0_00B0,    /* Access:      DP Invalid Index                */
        CommError_00B1_00B1,    /* Access:      DP Write Length Error           */
        CommError_00B2_00B2,    /* Access:      DP Invalid Slot                 */
        CommError_00B3_00B3,    /* Access:      DP Type Conflict                */
        CommError_00B4_00B4,    /* Access:      DP Invalid Area                 */
        CommError_00B5_00B5,    /* Access:      DP State Conflict               */
        CommError_00B6_00B6,    /* Access:      DP Access Denied                */
        CommError_00B7_00B7,    /* Access:      DP Invalid Range                */
        CommError_00B8_00B8,    /* Access:      DP Invalid Parameter            */
        CommError_00B9_00B9,    /* Access:      DP Invalid Type                 */
        CommError_00BA_00BF     /* Access:      DP Access User Specific         */
    }
}

MENU Page_CommError_Resource
{
    LABEL   [menu_dialog_error_handling_resource];
    ITEMS
    {
        CommError_00C0_00C0,    /* Resource:    DP Read Constrain Conflict      */
        CommError_00C1_00C1,    /* Resource:    DP Write Constrain Conflict     */
        CommError_00C2_00C2,    /* Resource:    DP Resource Busy                */
        CommError_00C3_00C3,    /* Resource:    DP Resource unavailable         */
        CommError_00C4_00C7,    /* Resource:    DP Resource Reserved            */
        CommError_00C8_00CF     /* Resource:    DP Recource User Specific       */
    }
}

MENU Page_CommError_Other
{
    LABEL   [menu_dialog_error_handling_other];
    ITEMS
    {
        CommError_0000_009F,
        CommError_00D0_00FF
    }
}

METHOD  CommError_IgnoreAllErrors
{
    LABEL       [comm_ignore_all_errors];
    DEFINITION
    {
        iassign(CommError_0000_009F, 0);    /* DP Error Reserved                            */
        iassign(CommError_00A0_00A0, 0);    /* Application: DP Read Error                   */
        iassign(CommError_00A1_00A1, 0);    /* Application: DP Write Error                  */
        iassign(CommError_00A2_00A2, 0);    /* Application: DP Module Failure               */
        iassign(CommError_00A3_00A7, 0);    /* Application: DP Application Reserved         */
        iassign(CommError_00A8_00A8, 0);    /* Application: DP Version Conflict             */
        iassign(CommError_00A9_00A9, 0);    /* Application: DP Feature Not Supported        */
        iassign(CommError_00AA_00AF, 0);    /* Application: DP Application User Specific    */
        iassign(CommError_00B0_00B0, 0);    /* Access:      DP Invalid Index                */
        iassign(CommError_00B1_00B1, 0);    /* Access:      DP Write Length Error           */
        iassign(CommError_00B2_00B2, 0);    /* Access:      DP Invalid Slot                 */
        iassign(CommError_00B3_00B3, 0);    /* Access:      DP Type Conflict                */
        iassign(CommError_00B4_00B4, 0);    /* Access:      DP Invalid Area                 */
        iassign(CommError_00B5_00B5, 0);    /* Access:      DP State Conflict               */
        iassign(CommError_00B6_00B6, 0);    /* Access:      DP Access Denied                */
        iassign(CommError_00B7_00B7, 0);    /* Access:      DP Invalid Range                */
        iassign(CommError_00B8_00B8, 0);    /* Access:      DP Invalid Parameter            */
        iassign(CommError_00B9_00B9, 0);    /* Access:      DP Invalid Type                 */
        iassign(CommError_00BA_00BF, 0);    /* Access:      DP Access User Specific         */
        iassign(CommError_00C0_00C0, 0);    /* Resource:    DP Read Constrain Conflict      */
        iassign(CommError_00C1_00C1, 0);    /* Resource:    DP Write Constrain Conflict     */
        iassign(CommError_00C2_00C2, 0);    /* Resource:    DP Resource Busy                */
        iassign(CommError_00C3_00C3, 0);    /* Resource:    DP Resource unavailable         */
        iassign(CommError_00C4_00C7, 0);    /* Resource:    DP Resource Reserved            */
        iassign(CommError_00C8_00CF, 0);    /* Resource:    DP Recource User Specific       */
        iassign(CommError_00D0_00FF, 0);    /* DP User Specific                             */
    }
    HELP        [comm_ignore_all_errors_help];
}

METHOD  CommError_CheckAllErrors
{
    LABEL       [comm_check_all_errors];
    DEFINITION
    {
        iassign(CommError_0000_009F, 1);    /* DP Error Reserved                            */
        iassign(CommError_00A0_00A0, 1);    /* Application: DP Read Error                   */
        iassign(CommError_00A1_00A1, 1);    /* Application: DP Write Error                  */
        iassign(CommError_00A2_00A2, 1);    /* Application: DP Module Failure               */
        iassign(CommError_00A3_00A7, 1);    /* Application: DP Application Reserved         */
        iassign(CommError_00A8_00A8, 1);    /* Application: DP Version Conflict             */
        iassign(CommError_00A9_00A9, 1);    /* Application: DP Feature Not Supported        */
        iassign(CommError_00AA_00AF, 1);    /* Application: DP Application User Specific    */
        iassign(CommError_00B0_00B0, 1);    /* Access:      DP Invalid Index                */
        iassign(CommError_00B1_00B1, 1);    /* Access:      DP Write Length Error           */
        iassign(CommError_00B2_00B2, 1);    /* Access:      DP Invalid Slot                 */
        iassign(CommError_00B3_00B3, 1);    /* Access:      DP Type Conflict                */
        iassign(CommError_00B4_00B4, 1);    /* Access:      DP Invalid Area                 */
        iassign(CommError_00B5_00B5, 1);    /* Access:      DP State Conflict               */
        iassign(CommError_00B6_00B6, 1);    /* Access:      DP Access Denied                */
        iassign(CommError_00B7_00B7, 1);    /* Access:      DP Invalid Range                */
        iassign(CommError_00B8_00B8, 1);    /* Access:      DP Invalid Parameter            */
        iassign(CommError_00B9_00B9, 1);    /* Access:      DP Invalid Type                 */
        iassign(CommError_00BA_00BF, 1);    /* Access:      DP Access User Specific         */
        iassign(CommError_00C0_00C0, 1);    /* Resource:    DP Read Constrain Conflict      */
        iassign(CommError_00C1_00C1, 1);    /* Resource:    DP Write Constrain Conflict     */
        iassign(CommError_00C2_00C2, 1);    /* Resource:    DP Resource Busy                */
        iassign(CommError_00C3_00C3, 1);    /* Resource:    DP Resource unavailable         */
        iassign(CommError_00C4_00C7, 1);    /* Resource:    DP Resource Reserved            */
        iassign(CommError_00C8_00CF, 1);    /* Resource:    DP Recource User Specific       */
        iassign(CommError_00D0_00FF, 1);    /* DP User Specific                             */
    }
    HELP        [comm_check_all_errors_help];
}

METHOD  CommError_DefaultHandling
{
    LABEL       [comm_default_handling];
    DEFINITION
    {
        lassign(CommError_Delay_Read,  0);  /* Delay after Read Command                     */
        lassign(CommError_Delay_Write, 0);  /* Delay after Write Command                    */
        iassign(CommError_0000_009F, 1);    /* DP Error Reserved                            */
        iassign(CommError_00A0_00A0, 1);    /* Application: DP Read Error                   */
        iassign(CommError_00A1_00A1, 1);    /* Application: DP Write Error                  */
        iassign(CommError_00A2_00A2, 1);    /* Application: DP Module Failure               */
        iassign(CommError_00A3_00A7, 1);    /* Application: DP Application Reserved         */
        iassign(CommError_00A8_00A8, 1);    /* Application: DP Version Conflict             */
        iassign(CommError_00A9_00A9, 1);    /* Application: DP Feature Not Supported        */
        iassign(CommError_00AA_00AF, 1);    /* Application: DP Application User Specific    */
        iassign(CommError_00B0_00B0, 0);    /* Access:      DP Invalid Index                */
        iassign(CommError_00B1_00B1, 1);    /* Access:      DP Write Length Error           */
        iassign(CommError_00B2_00B2, 0);    /* Access:      DP Invalid Slot                 */
        iassign(CommError_00B3_00B3, 1);    /* Access:      DP Type Conflict                */
        iassign(CommError_00B4_00B4, 1);    /* Access:      DP Invalid Area                 */
        iassign(CommError_00B5_00B5, 0);    /* Access:      DP State Conflict               */
        iassign(CommError_00B6_00B6, 0);    /* Access:      DP Access Denied                */
        iassign(CommError_00B7_00B7, 0);    /* Access:      DP Invalid Range                */
        iassign(CommError_00B8_00B8, 0);    /* Access:      DP Invalid Parameter            */
        iassign(CommError_00B9_00B9, 1);    /* Access:      DP Invalid Type                 */
        iassign(CommError_00BA_00BF, 0);    /* Access:      DP Access User Specific         */
        iassign(CommError_00C0_00C0, 1);    /* Resource:    DP Read Constrain Conflict      */
        iassign(CommError_00C1_00C1, 1);    /* Resource:    DP Write Constrain Conflict     */
        iassign(CommError_00C2_00C2, 1);    /* Resource:    DP Resource Busy                */
        iassign(CommError_00C3_00C3, 1);    /* Resource:    DP Resource unavailable         */
        iassign(CommError_00C4_00C7, 1);    /* Resource:    DP Resource Reserved            */
        iassign(CommError_00C8_00CF, 1);    /* Resource:    DP Recource User Specific       */
        iassign(CommError_00D0_00FF, 1);    /* DP User Specific                             */
    }
    HELP        [comm_default_handling_help];
}


/*******************************************************************************/
/*     Commands                                                                */
/*******************************************************************************/

/* ------------------------------------------------------------------------ */
/* Schreiben in ein EXPERT+ Geraet */
/* ------------------------------------------------------------------------ */
#define upload_EXPERT_PLUS                                               \
        func1_strategy,                                                  \
        trans1_strategy,                                                 \
        func1_alert_key,                                                 \
        trans1_alert_key,                                                \
        phys_strategy,                                                   \
        phys_ident_limit_switches,                                       \
        phys_tag_desc,                                                   \
        phys_write_locking,                                              \
        phys_descriptor,                                                 \
        phys_device_message,                                             \
        phys_device_instal_date,                                         \
        phys_local_operation_enable,                                     \
        phys_ident_number_selector,                                      \
        phys_cond_status_diag,                                           \
/*        phys_diag_event_switch__Diag_Status_Link_1_0_S,  */                \
/*        phys_diag_event_switch__Diag_Status_Link_1_0_D,  */                \
        phys_diag_event_switch__Diag_Status_Link_1_1_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_1_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_2_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_2_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_3_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_3_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_4_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_4_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_5_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_5_D,                  \
/*        phys_diag_event_switch__Diag_Status_Link_1_6_S, */                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_6_D, */                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_7_S, */                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_7_D, */                 \
        phys_diag_event_switch__Diag_Status_Link_1_8_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_8_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_9_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_9_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_10_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_10_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_11_S,                 \
        trans1_travel_limit_upper_value,                                 \
        phys_diag_event_switch__Diag_Status_Link_1_11_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_12_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_12_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_13_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_13_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_14_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_14_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_15_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_15_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_16_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_16_D,                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_17_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_17_D,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_18_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_18_D,    */             \
        phys_diag_event_switch__Diag_Status_Link_1_19_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_19_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_20_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_20_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_21_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_21_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_22_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_22_D,                 \
        trans1_total_valve_travel_limit,                                 \
        phys_diag_event_switch__Diag_Status_Link_1_23_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_23_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_24_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_24_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_25_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_25_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_26_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_26_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_27_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_27_D,                 \
        phys_diag_event_switch_2__Diag_Status_Link_2_16_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_16_D,               \
        trans1_X0,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_17_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_17_D,               \
        trans1_Y0,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_18_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_18_D,               \
        trans1_X1,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_19_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_19_D,               \
        trans1_Y1,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_20_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_20_D,               \
        trans1_X2,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_21_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_21_D,               \
        trans1_Y2,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_22_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_22_D,               \
        trans1_X3,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_23_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_23_D,               \
        trans1_Y3,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_24_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_24_D,               \
        trans1_X4,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_25_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_25_D,               \
        trans1_Y4,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_26_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_26_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_27_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_27_D,               \
        trans1_X5,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_28_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_28_D,               \
        trans1_final_value_range_start,                                  \
        phys_diag_event_switch_2__Diag_Status_Link_2_29_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_29_D,               \
        trans1_Y5,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_30_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_30_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_31_S,               \
        trans1_transm_pin_pos,                                           \
        phys_diag_event_switch_2__Diag_Status_Link_2_31_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_32_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_32_D,               \
        trans1_final_value_range_end,                                    \
        phys_diag_event_switch_2__Diag_Status_Link_2_33_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_33_D,               \
        trans1_X6,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_34_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_34_D,               \
        trans1_Y6,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_35_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_35_D,               \
        trans1_final_value_range_units,                                  \
        phys_diag_event_switch_2__Diag_Status_Link_2_36_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_36_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_37_S,               \
        trans1_actuator_man,                                             \
        trans1_additional_gear_id,                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_37_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_38_S,               \
        trans1_X7,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_38_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_39_S,               \
        trans1_travel_limit_lower_value,                                 \
        phys_diag_event_switch_2__Diag_Status_Link_2_39_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_41_S,               \
        trans1_Y7,                                                       \
        phys_diag_event_switch_2__Diag_Status_Link_2_41_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_42_S,               \
        trans1_X8,                                                       \
/*        phys_diag_event_switch__Diag_Status_Link_1_28_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_28_D,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_29_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_29_D,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_30_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_30_D,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_31_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_31_D,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_32_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_32_D,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_33_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_33_D,   */              \
        phys_diag_event_switch__Diag_Status_Link_1_34_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_34_D,                 \
        trans1_Y8,                                                       \
        phys_diag_event_switch__Diag_Status_Link_1_35_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_35_D,                 \
        trans1_X9,                                                       \
        phys_diag_event_switch__Diag_Status_Link_1_36_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_36_D,                 \
        trans1_Y9,                                                       \
        phys_diag_event_switch__Diag_Status_Link_1_37_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_37_D,                 \
        trans1_X10,                                                      \
        phys_diag_event_switch__Diag_Status_Link_1_38_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_38_D,                 \
        trans1_Y10,                                                      \
        phys_diag_event_switch__Diag_Status_Link_1_39_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_39_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_40_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_40_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_41_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_41_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_42_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_42_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_43_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_43_D,                 \
        trans1_delay_time,                                               \
        phys_diag_event_switch__Diag_Status_Link_1_44_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_44_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_45_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_45_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_46_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_46_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_47_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_47_D,                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_48_S, */                \
/*        phys_diag_event_switch__Diag_Status_Link_1_48_D, */                \
        phys_text_input_1,                                               \
        phys_text_input_2,                                               \
        phys_text_input_3,                                               \
        phys_text_input_4,                                               \
        phys_text_input_5,                                               \
        phys_reading_direction,                                          \
        phys_config_binary_input_2,                                      \
        phys_diag_event_switch_2__Diag_Status_Link_2_0_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_0_D,                \
        trans1_travel_lower_limit_on,                                    \
        phys_diag_event_switch_2__Diag_Status_Link_2_1_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_1_D,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_2_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_2_D,                \
        trans1_travel_upper_limit_on,                                    \
        trans3_sensor_id,                                                \
        phys_diag_event_switch_2__Diag_Status_Link_2_3_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_3_D,                \
        trans3_sensor_ser_num,                                           \
        phys_diag_event_switch_2__Diag_Status_Link_2_4_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_4_D,                \
        trans1_final_value_cutoff_lo_on,                                 \
        phys_diag_event_switch_2__Diag_Status_Link_2_5_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_5_D,                \
        trans1_additional_gear_man,                                      \
        phys_diag_event_switch_2__Diag_Status_Link_2_6_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_6_D,                \
        trans1_final_value_cutoff_hi_on,                                 \
        phys_diag_event_switch_2__Diag_Status_Link_2_7_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_7_D,                \
        trans1_additional_gear_ser_number,                               \
        phys_diag_event_switch_2__Diag_Status_Link_2_8_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_8_D,                \
        trans1_charact_type,                                             \
        phys_diag_event_switch_2__Diag_Status_Link_2_9_S,                \
        phys_diag_event_switch_2__Diag_Status_Link_2_9_D,                \
        trans1_supply_pressure,                                          \
        phys_diag_event_switch_2__Diag_Status_Link_2_10_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_10_D,               \
        trans1_actuator_version,                                         \
        phys_diag_event_switch_2__Diag_Status_Link_2_11_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_11_D,               \
        trans1_pressure_limit,                                           \
        phys_diag_event_switch_2__Diag_Status_Link_2_12_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_12_D,               \
        trans1_set_fail_safe_pos,                                        \
        phys_diag_event_switch_2__Diag_Status_Link_2_13_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_13_D,               \
        trans1_tolerance_band,                                           \
  /*      phys_diag_event_switch_2__Diag_Status_Link_2_14_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_14_D,    */           \
        phys_diag_event_switch_2__Diag_Status_Link_2_15_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_15_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_42_D,               \
        trans1_tag_desc,                                                 \
        trans1_device_calib_date,                                        \
        trans1_device_config_date,                                       \
        trans1_lin_type,                                                 \
        trans1_setp_cutoff_dec,                                          \
        trans1_setp_cutoff_inc,                                          \
        trans1_travel_rate_dec,                                          \
        trans1_travel_rate_inc,                                          \
        trans1_valve_maintenance_date,                                   \
        trans1_valve_type,                                               \
        trans1_rated_travel,                                             \
        trans1_valve_man,                                                \
        trans1_valve_serial_number,                                      \
        trans1_actuator_serial_number,                                   \
        trans1_additional_gear_install_date,                             \
        trans1_init_method,                                              \
        trans1_moving_direction,                                         \
        /* nur Schreiben wenn:                                           \
        /* wenn Regler NICHT initialisiert UND Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */  \
        IF ((trans1_device_init_state == 0) && (trans1_init_method == INIT_ART_SUB))                   \
        {                                                                \
          trans1_closing_direction, /* Abhaengigkeit */                  \
          trans1_blocking_position, /* Abhaengigkeit */                  \
        }                                                                \
        func1_tag_desc,                                                  \
        func1_batch_id,                                                  \
        func1_batch_unit,                                                \
        func1_batch_operation,                                           \
        func1_batch_phase,                                               \
        func1_pv_upper_range_value,                                      \
        func1_pv_lower_range_value,                                      \
        func1_pv_unit,                                                   \
        func1_in_channel,                                                \
        func1_out_channel,                                               \
        func1_fsafe_time,                                                \
        func1_fsafe_type,                                                \
        func1_fsafe_value,                                               \
        func1_increase_close,                                            \
        func1_simulate_status_quality,                                   \
        func1_simulate_status_limit,                                     \
        func1_out_upper_range_value,                                     \
        func1_out_lower_range_value,                                     \
        func1_out_unit,                                                  \
        trans2_tag_desc,                                                 \
        trans2_sensor_id,                                                \
        trans2_sensor_ser_num,                                           \
        trans2_sensor_man,                                               \
/*        func2_tag_desc,      */                                            \
        func2_DI_batch_id,                                               \
        trans1_X_HIS_ABTASTRATE,                                         \
        trans1_autostart_hyst,                                           \
        trans1_stat_kenn_start,                                          \
        func2_DI_batch_unit,                                             \
        func2_DI_batch_operation,                                        \
        func2_DI_fsafe_type,                                             \
        trans1_E_HIS_ABTASTRATE,                                         \
        func2_DI_fsafe_value,                                            \
        func2_DI_simulate_status_quality,                                \
        func2_DI_simulate_status_limit,                                  \
	    func2_DI_simulate_value,                                         \
        trans1_stat_kenn_ende,                                           \
	    func2_DI_simulation_enabled,                                     \
	    trans3_tag_desc,                                                 \
        trans3_sensor_man,                                               \
/*        func3_tag_desc,        */                                          \
        func3_DI_batch_operation,                                        \
        func3_DI_batch_phase,                                            \
	    func3_DI_simulate_value,                                         \
	    func3_DI_simulation_enabled,                                     \
	    phys_strategy,                                                   \
	    phys_alert_key,                                                  \
	    trans1_pressure_range_start,                                     \
	    func1_simulate_enabled,                                          \
        func1_simulate_value,                                            \
	    trans1_pressure_range_end,                                       \
	    trans1_actuator_size,                                            \
      IF (trans1_actuator_size == 65535)                               \
      {                                                                \
	      trans1_manufac_actuator_size,	                                 \
	    }                                                                \
	    trans1_attachment,                                               \
	    trans1_booster,                                                  \
        trans1_stuffing_box,                                             \
        trans1_sealing_edge,                                             \
        trans1_pressure_balancing,                                       \
        trans1_flow_characteristic,                                      \
        trans1_flow_direction,                                           \
        func3_DI_simulate_status_quality,                                \
    	func3_DI_simulate_status_limit,                                  \
        trans1_nom_diameter,                                             \
        trans1_nom_diameter_dn,                                          \
        trans1_kvs_unit,                                                 \
        trans1_kvs_value,                                                \
        func3_DI_batch_id,                                               \
        func3_DI_batch_unit,                                             \
        trans1_seat_diam_valve,                                          \
        trans2_strategy,                                                 \
        trans2_alert_key,                                                \
        func2_DI_tag_desc,                                               \
        func3_DI_alert_key,                                              \
        phys_feature_select,                                             \
        trans1_zero_point_limit,                                         \
        func1_check_back_opt,                                            \
        trans1_datalogger_select,                                        \
        trans1_datalogger_trigger_select,                                \
        trans1_datalogger_sample_rate,                                   \
        func2_DI_batch_phase,                                            \
        func2_DI_channel,                                                \
        func2_DI_invert,                                                 \
        trans1_datalogger_start_value,                                   \
        trans1_datalogger_logging_limit,                                 \
        trans1_datalogger_pretrigger_time,                               \
        trans3_strategy,                                                 \
        trans3_alert_key,                                                \
        func3_DI_tag_desc,                                               \
        func3_DI_strategy,                                               \
        trans1_stat_kenn_warte,                                          \
        trans1_stat_kenn_anzahl,                                         \
        trans1_Stepstart,                                                \
        trans1_Stepend,                                                  \
        func2_DI_strategy,                                               \
        func2_DI_alert_key,                                              \
        trans1_Step_Sample_Rate,                                         \
        func3_DI_channel,                                                \
        func3_DI_invert,                                                 \
        trans1_Latency_After_Step,                                       \
        func3_DI_fsafe_type,                                             \
        func3_DI_fsafe_value,                                            \
        trans1_Step_Selection




/* ------------------------------------------------------------------------ */
/* Schreiben in ein EXPERT Geraet */
/* ------------------------------------------------------------------------ */
#define upload_EXPERT                                                    \
        func1_strategy,                                                  \
        trans1_strategy,                                                 \
        func1_alert_key,                                                 \
        trans1_alert_key,                                                \
        phys_strategy,                                                   \
        phys_tag_desc,                                                   \
        phys_write_locking,                                              \
        phys_descriptor,                                                 \
        phys_device_message,                                             \
        phys_device_instal_date,                                         \
        phys_local_operation_enable,                                     \
        phys_ident_number_selector,                                      \
        phys_cond_status_diag,                                           \
/*        phys_diag_event_switch__Diag_Status_Link_1_0_S,    */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_0_D,    */              \
        phys_diag_event_switch__Diag_Status_Link_1_1_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_1_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_2_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_2_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_3_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_3_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_4_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_4_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_5_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_5_D,                  \
/*        phys_diag_event_switch__Diag_Status_Link_1_6_S,  */                \
/*        phys_diag_event_switch__Diag_Status_Link_1_6_D,  */                \
/*        phys_diag_event_switch__Diag_Status_Link_1_7_S,  */                \
/*        phys_diag_event_switch__Diag_Status_Link_1_7_D,  */                \
        phys_diag_event_switch__Diag_Status_Link_1_8_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_8_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_9_S,                  \
        phys_diag_event_switch__Diag_Status_Link_1_9_D,                  \
        phys_diag_event_switch__Diag_Status_Link_1_10_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_10_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_11_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_11_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_12_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_12_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_13_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_13_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_14_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_14_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_15_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_15_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_16_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_16_D,                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_17_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_17_D,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_18_S,   */              \
/*        phys_diag_event_switch__Diag_Status_Link_1_18_D,   */              \
        phys_diag_event_switch__Diag_Status_Link_1_19_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_19_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_20_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_20_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_21_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_21_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_22_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_22_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_23_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_23_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_24_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_24_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_25_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_25_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_26_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_26_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_27_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_27_D,                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_28_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_28_D,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_29_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_29_D,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_30_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_30_D,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_31_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_31_D,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_32_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_32_D,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_33_S,    */             \
/*        phys_diag_event_switch__Diag_Status_Link_1_33_D,    */             \
        phys_diag_event_switch__Diag_Status_Link_1_34_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_34_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_35_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_35_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_36_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_36_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_37_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_37_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_38_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_38_D,                 \
        trans1_transm_pin_pos,                                           \
        phys_diag_event_switch__Diag_Status_Link_1_39_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_39_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_45_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_45_D,                 \
        phys_diag_event_switch__Diag_Status_Link_1_46_S,                 \
        phys_diag_event_switch__Diag_Status_Link_1_46_D,                 \
/*        phys_diag_event_switch__Diag_Status_Link_1_48_S,      */           \
/*        phys_diag_event_switch__Diag_Status_Link_1_48_D,      */           \
        phys_ident_limit_switches,                                       \
        phys_text_input_4,                                               \
        phys_text_input_5,                                               \
        phys_reading_direction,                                          \
        phys_config_binary_input_2,                                      \
        phys_diag_event_switch_2__Diag_Status_Link_2_35_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_35_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_36_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_36_D,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_41_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_41_D,               \
        trans1_setp_cutoff_dec,                                          \
        trans1_total_valve_travel_limit,                                 \
        phys_diag_event_switch_2__Diag_Status_Link_2_42_S,               \
        phys_diag_event_switch_2__Diag_Status_Link_2_42_D,               \
        trans1_tag_desc,                                                 \
        trans1_device_calib_date,                                        \
        trans1_device_config_date,                                       \
        trans1_lin_type,                                                 \
        trans1_setp_cutoff_inc,                                          \
        trans1_travel_limit_lower_value,                                 \
        trans1_travel_limit_upper_value,                                 \
        trans1_travel_rate_dec,                                          \
        trans1_travel_rate_inc,                                          \
        trans1_valve_maintenance_date,                                   \
        trans1_valve_type,                                               \
        trans1_rated_travel,                                             \
        trans1_valve_man,                                                \
        trans1_valve_serial_number,                                      \
        trans1_actuator_serial_number,                                   \
        trans1_actuator_man,                                             \
        trans1_additional_gear_ser_number,                               \
        trans1_additional_gear_man,                                      \
        trans1_final_value_cutoff_lo_on,                                 \
        trans1_additional_gear_id,                                       \
        trans1_final_value_cutoff_hi_on,                                 \
        trans1_additional_gear_install_date,                             \
        trans1_init_method,                                              \
        trans1_moving_direction,                                         \
        /* nur Schreiben wenn:                                           \
        /* wenn Regler NICHT initialisiert UND Initialisierungsart = INIT_ART_SUB (Ersatzabgleich) */  \
        IF ((trans1_device_init_state == 0) && (trans1_init_method == INIT_ART_SUB))                   \
        {                                                                \
          trans1_closing_direction, /* Abhaengigkeit */                  \
          trans1_blocking_position, /* Abhaengigkeit */                  \
        }                                                                \
        phys_text_input_1,                                               \
        phys_text_input_2,                                               \
        phys_text_input_3,                                               \
        trans1_travel_lower_limit_on,                                    \
        trans1_travel_upper_limit_on,                                    \
        trans1_charact_type,                                             \
        trans1_supply_pressure,                                          \
        trans1_actuator_version,                                         \
        trans1_pressure_limit,                                           \
        trans1_set_fail_safe_pos,                                        \
        trans1_final_value_range_start,                                  \
        trans1_final_value_range_end,                                    \
        trans1_final_value_range_units,                                  \
        trans1_tolerance_band,                                           \
        trans1_delay_time,                                               \
        trans1_X0,                                                       \
        trans1_Y0,                                                       \
        trans1_X1,                                                       \
        trans1_Y1,                                                       \
        trans1_X2,                                                       \
        trans1_Y2,                                                       \
        trans1_X3,                                                       \
        trans1_Y3,                                                       \
        trans1_X4,                                                       \
        trans1_Y4,                                                       \
        trans1_X5,                                                       \
        trans1_Y5,                                                       \
        trans1_X6,                                                       \
        trans1_Y6,                                                       \
        trans1_X7,                                                       \
        trans1_Y7,                                                       \
        trans1_X8,                                                       \
        trans1_Y8,                                                       \
        trans1_X9,                                                       \
        trans1_Y9,                                                       \
        trans1_X10,                                                      \
        trans1_Y10,                                                      \
        func1_tag_desc,                                                  \
        func1_batch_id,                                                  \
        func1_batch_unit,                                                \
        func1_batch_operation,                                           \
        func1_batch_phase,                                               \
        func1_pv_upper_range_value,                                      \
        func1_pv_lower_range_value,                                      \
        func1_pv_unit,                                                   \
        func1_in_channel,                                                \
        func1_out_channel,                                               \
        func1_fsafe_time,                                                \
        func1_fsafe_type,                                                \
        func1_fsafe_value,                                               \
        func1_increase_close,                                            \
        func1_simulate_enabled,                                          \
        func1_simulate_value,                                            \
        func1_simulate_status_quality,                                   \
        func1_simulate_status_limit,                                     \
        func1_out_upper_range_value,                                     \
        func1_out_lower_range_value,                                     \
        func1_out_unit,                                                  \
        trans2_tag_desc,                                                 \
        trans2_sensor_id,                                                \
        trans2_sensor_ser_num,                                           \
        trans2_sensor_man,                                               \
/*        func2_tag_desc,    */                                              \
        func2_DI_batch_id,                                               \
        func2_DI_batch_unit,                                             \
        func2_DI_batch_operation,                                        \
        func2_DI_batch_phase,                                            \
        func2_DI_channel,                                                \
        func2_DI_invert,                                                 \
        func2_DI_fsafe_type,                                             \
        func2_DI_fsafe_value,                                            \
        func2_DI_simulate_status_quality,                                \
        func2_DI_simulate_status_limit,                                  \
	    func2_DI_simulate_value,                                         \
	    func2_DI_simulation_enabled,                                     \
	    trans3_tag_desc,                                                 \
        trans3_sensor_id,                                                \
        trans3_sensor_ser_num,                                           \
        trans3_sensor_man,                                               \
/*        func3_tag_desc,     */                                             \
        func3_DI_batch_id,                                               \
        func3_DI_batch_unit,                                             \
        func3_DI_batch_operation,                                        \
        func3_DI_batch_phase,                                            \
        func3_DI_channel,                                                \
        trans1_pressure_range_start,                                     \
        func3_DI_invert,                                                 \
        func3_DI_fsafe_type,                                             \
        func3_DI_fsafe_value,                                            \
        trans1_pressure_range_end,                                       \
        func3_DI_simulate_status_quality,                                \
	    func3_DI_simulate_status_limit,                                  \
	    func3_DI_simulate_value,                                         \
	    func3_DI_simulation_enabled,                                     \
	    phys_strategy,                                                   \
	    phys_alert_key,                                                  \
	    trans1_actuator_size,                                            \
      IF (trans1_actuator_size == 65535)                               \
      {                                                                \
	      trans1_manufac_actuator_size,	                                 \
	    }                                                                \
	    trans1_attachment,                                               \
	    trans1_booster,                                                  \
        trans1_stuffing_box,                                             \
        trans1_sealing_edge,                                             \
        trans1_pressure_balancing,                                       \
        trans1_flow_characteristic,                                      \
        trans1_flow_direction,                                           \
        trans1_nom_diameter,                                             \
        trans1_nom_diameter_dn,                                          \
        trans1_kvs_unit,                                                 \
        trans1_kvs_value,                                                \
        trans1_seat_diam_valve,                                          \
        trans2_strategy,                                                 \
        trans2_alert_key,                                                \
        func2_DI_tag_desc,                                               \
        func2_DI_strategy,                                               \
        func2_DI_alert_key,                                              \
        trans3_strategy,                                                 \
        trans3_alert_key,                                                \
        func3_DI_tag_desc,                                               \
        func3_DI_strategy,                                               \
        func3_DI_alert_key,                                              \
        phys_feature_select,                                             \
        trans1_zero_point_limit,                                         \
        func1_check_back_opt



MENU upload_variables /* Parameter die in das Geraet geschrieben werden */
{
    LABEL       [menu_load_to_device];
    ITEMS
    {

      /* Wenn EXPERT+ dann alle Parameter schreiben: */
      IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( trans1_diag_level == DIAG_LEVEL_ESD              ))
      {

        /* ------------------------------------------------------------------------ */
        /* Schreiben in ein EXPERT+ Geraet */
        /* ------------------------------------------------------------------------ */
        upload_EXPERT_PLUS

      }
      ELSE
      {

        /* ------------------------------------------------------------------------ */
        /* Schreiben in ein EXPERT Geraet */
        /* ------------------------------------------------------------------------ */
        upload_EXPERT

      }
    }
}




MENU download_variables         /* Parameter die aus dem Gert gelesen werden */
{
	LABEL		[menu_load_to_PC];
    ITEMS
    {

      /* Wenn EXPERT+ dann alle Parameter lesen: */
      IF (( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS      ) ||
          ( trans1_diag_level == DIAG_LEVEL_EXPERT_PLUS_PLUS ) ||
          ( trans1_diag_level == DIAG_LEVEL_ESD              ))
      {

        /* ------------------------------------------------------------------------ */
        /* Lesen aus einem EXPERT+ Geraet */
        /* ------------------------------------------------------------------------ */
        phys_condensed_state,
        phys_st_rev,
        func1_st_rev,
        trans1_st_rev,
        func1_strategy,
        trans1_strategy,
        func1_alert_key,
        trans1_alert_key,
        phys_strategy,
        phys_st_rev,
        phys_tag_desc,
        phys_software_rev,
        phys_hardware_rev,
#ifdef _V602_
        phys_device_man_id,
#endif
        phys_production_id,
        phys_feature_select,
        phys_strategy,
        phys_alert_key,
        phys_device_product_num,
        phys_device_id,
        phys_serial_num,
        phys_device_certification,
        phys_write_locking,
        phys_descriptor,
        phys_device_message,
        phys_device_instal_date,
        phys_local_operation_enable,
        phys_ident_number_selector,
        phys_hw_write_protection,
        phys_feature_supported,
        phys_feature_enabled,
        phys_cond_status_diag,
/*        phys_diag_event_switch__Diag_Status_Link_1_0_S,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_0_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_1_S,
        phys_diag_event_switch__Diag_Status_Link_1_1_D,
        phys_diag_event_switch__Diag_Status_Link_1_2_S,
        phys_diag_event_switch__Diag_Status_Link_1_2_D,
        phys_diag_event_switch__Diag_Status_Link_1_3_S,
        phys_diag_event_switch__Diag_Status_Link_1_3_D,
        phys_diag_event_switch__Diag_Status_Link_1_4_S,
        phys_diag_event_switch__Diag_Status_Link_1_4_D,
        phys_diag_event_switch__Diag_Status_Link_1_5_S,
        phys_diag_event_switch__Diag_Status_Link_1_5_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_6_S,
        phys_diag_event_switch__Diag_Status_Link_1_6_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_7_S,
        phys_diag_event_switch__Diag_Status_Link_1_7_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_8_S,
        phys_diag_event_switch__Diag_Status_Link_1_8_D,
        phys_diag_event_switch__Diag_Status_Link_1_9_S,
        phys_diag_event_switch__Diag_Status_Link_1_9_D,
        phys_diag_event_switch__Diag_Status_Link_1_10_S,
        phys_diag_event_switch__Diag_Status_Link_1_10_D,
        phys_diag_event_switch__Diag_Status_Link_1_11_S,
        phys_diag_event_switch__Diag_Status_Link_1_11_D,
        phys_diag_event_switch__Diag_Status_Link_1_12_S,
        phys_diag_event_switch__Diag_Status_Link_1_12_D,
        phys_diag_event_switch__Diag_Status_Link_1_13_S,
        phys_diag_event_switch__Diag_Status_Link_1_13_D,
        phys_diag_event_switch__Diag_Status_Link_1_14_S,
        phys_diag_event_switch__Diag_Status_Link_1_14_D,
        phys_diag_event_switch__Diag_Status_Link_1_15_S,
        phys_diag_event_switch__Diag_Status_Link_1_15_D,
        phys_diag_event_switch__Diag_Status_Link_1_16_S,
        phys_diag_event_switch__Diag_Status_Link_1_16_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_17_S,
        phys_diag_event_switch__Diag_Status_Link_1_17_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_18_S,
        phys_diag_event_switch__Diag_Status_Link_1_18_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_19_S,
        phys_diag_event_switch__Diag_Status_Link_1_19_D,
        phys_diag_event_switch__Diag_Status_Link_1_20_S,
        phys_diag_event_switch__Diag_Status_Link_1_20_D,
        phys_diag_event_switch__Diag_Status_Link_1_21_S,
        phys_diag_event_switch__Diag_Status_Link_1_21_D,
        phys_diag_event_switch__Diag_Status_Link_1_22_S,
        phys_diag_event_switch__Diag_Status_Link_1_22_D,
        phys_diag_event_switch__Diag_Status_Link_1_23_S,
        phys_diag_event_switch__Diag_Status_Link_1_23_D,
        phys_diag_event_switch__Diag_Status_Link_1_24_S,
        phys_diag_event_switch__Diag_Status_Link_1_24_D,
        phys_diag_event_switch__Diag_Status_Link_1_25_S,
        phys_diag_event_switch__Diag_Status_Link_1_25_D,
        phys_diag_event_switch__Diag_Status_Link_1_26_S,
        phys_diag_event_switch__Diag_Status_Link_1_26_D,
        phys_diag_event_switch__Diag_Status_Link_1_27_S,
        phys_diag_event_switch__Diag_Status_Link_1_27_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_28_S,
        phys_diag_event_switch__Diag_Status_Link_1_28_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_29_S,
        phys_diag_event_switch__Diag_Status_Link_1_29_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_30_S,
        phys_diag_event_switch__Diag_Status_Link_1_30_D,
        phys_diag_event_switch__Diag_Status_Link_1_31_S,
        phys_diag_event_switch__Diag_Status_Link_1_31_D,
        phys_diag_event_switch__Diag_Status_Link_1_32_S,
        phys_diag_event_switch__Diag_Status_Link_1_32_D,
        phys_diag_event_switch__Diag_Status_Link_1_33_S,
        phys_diag_event_switch__Diag_Status_Link_1_33_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_34_S,
        phys_diag_event_switch__Diag_Status_Link_1_34_D,
        phys_diag_event_switch__Diag_Status_Link_1_35_S,
        phys_diag_event_switch__Diag_Status_Link_1_35_D,
        phys_diag_event_switch__Diag_Status_Link_1_36_S,
        phys_diag_event_switch__Diag_Status_Link_1_36_D,
        phys_diag_event_switch__Diag_Status_Link_1_37_S,
        phys_diag_event_switch__Diag_Status_Link_1_37_D,
        phys_diag_event_switch__Diag_Status_Link_1_38_S,
        phys_diag_event_switch__Diag_Status_Link_1_38_D,
        phys_diag_event_switch__Diag_Status_Link_1_39_S,
        phys_diag_event_switch__Diag_Status_Link_1_39_D,
        phys_diag_event_switch__Diag_Status_Link_1_40_S,
        phys_diag_event_switch__Diag_Status_Link_1_40_D,
        phys_diag_event_switch__Diag_Status_Link_1_41_S,
        phys_diag_event_switch__Diag_Status_Link_1_41_D,
        phys_diag_event_switch__Diag_Status_Link_1_42_S,
        phys_diag_event_switch__Diag_Status_Link_1_42_D,
        phys_diag_event_switch__Diag_Status_Link_1_43_S,
        phys_diag_event_switch__Diag_Status_Link_1_43_D,
        phys_diag_event_switch__Diag_Status_Link_1_44_S,
        phys_diag_event_switch__Diag_Status_Link_1_44_D,
        phys_diag_event_switch__Diag_Status_Link_1_45_S,
        phys_diag_event_switch__Diag_Status_Link_1_45_D,
        phys_diag_event_switch__Diag_Status_Link_1_46_S,
        phys_diag_event_switch__Diag_Status_Link_1_46_D,
        phys_diag_event_switch__Diag_Status_Link_1_47_S,
        phys_diag_event_switch__Diag_Status_Link_1_47_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_48_S,
        phys_diag_event_switch__Diag_Status_Link_1_48_D,*/
        phys_ident_options,
        phys_ident_limit_switches,
        /* phys_device_product_num, */
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3,
        phys_text_input_4,
        phys_text_input_5,
        phys_reading_direction,
        phys_config_binary_input_2,
/*        phys_diagnosis_ext_2_01,
        phys_diagnosis_ext_2_23,
        phys_diagnosis_ext_2_45,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_0_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_0_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_1_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_1_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_2_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_2_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_3_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_3_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_4_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_4_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_5_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_5_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_6_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_6_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_7_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_7_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_8_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_8_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_9_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_9_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_10_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_10_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_11_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_11_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_12_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_12_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_13_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_13_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_14_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_14_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_15_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_15_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_16_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_16_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_17_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_17_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_18_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_18_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_19_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_19_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_20_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_20_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_21_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_21_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_22_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_22_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_23_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_23_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_24_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_24_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_25_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_25_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_26_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_26_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_27_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_27_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_28_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_28_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_29_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_29_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_30_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_30_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_31_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_31_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_32_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_32_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_33_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_33_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_34_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_34_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_35_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_35_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_36_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_36_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_37_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_37_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_38_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_38_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_39_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_39_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_41_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_41_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_D,
/*        phys_diagnosis_ext_1_raw_01,
        phys_diagnosis_ext_1_raw_23,
        phys_diagnosis_ext_1_raw_45,
        phys_diagnosis_ext_2_raw_01,
        phys_diagnosis_ext_2_raw_23,
        phys_diagnosis_ext_2_raw_45,*/
        phys_diagnosis_ext_1_raw_4,
        phys_ext_2_raw_enh_diag_1,
        phys_ext_2_raw_enh_diag_2,
        phys_ext_2_raw_enh_diag_3,
        phys_diag_ext_1_4,
        phys_diag_ext_2_0,
        phys_diag_ext_2_1,
        phys_diag_ext_2_2,
        phys_device_dp_status,
/*      phys_diag_ext_1_0,
        phys_diag_ext_1_1,
        phys_diag_ext_1_2,  */
        phys_diag_ext_1_3,
        phys_diag_operation,
        phys_diag_init_1,
        phys_diag_init_2,
        phys_diag_hw,
        phys_diag_data_1,
/*        phys_diag_data_2,*/
        phys_diagnosis_ext_1_raw_0,
        phys_diagnosis_ext_1_raw_1,
        phys_diagnosis_ext_1_raw_2,
        phys_diagnosis_ext_1_raw_3,
        trans1_tag_desc,
        trans1_act_stroke_time_dec,
        trans1_act_stroke_time_inc,
        trans1_device_calib_date,
        trans1_device_config_date,
        /* erst Stiftposition, dann Nennbereich einlesen */
        trans1_transm_pin_pos,
        trans1_lin_type,
        trans1_rated_travel,
        trans1_servo_gain_1,
        trans1_servo_rate_1,
        trans1_setp_cutoff_dec,
        trans1_total_valve_travel,
        trans1_setp_cutoff_inc,
        trans1_total_valve_travel_limit,
        trans1_travel_limit_lower_value,
        trans1_travel_limit_upper_value,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc,
        trans1_valve_maintenance_date,
        trans1_valve_man,
        trans1_actuator_man,
        trans1_valve_type,
        trans1_stuffing_box,
        trans1_sealing_edge,
        trans1_pressure_balancing,
        trans1_flow_characteristic,
        trans1_flow_direction,
        trans1_nom_diameter,
        trans1_nom_diameter_dn,
        trans1_kvs_unit,
        trans1_kvs_value,
        trans1_seat_diam_valve,
        trans1_actuator_type,
        trans1_actuator_action,
        trans1_valve_serial_number,
        trans1_actuator_serial_number,
        trans1_additional_gear_ser_number,
        trans1_additional_gear_man,
        trans1_additional_gear_id,
        trans1_additional_gear_install_date,
        trans1_init_method,
        trans1_sub_mode_init,
        trans1_device_init_state,
        trans1_moving_direction,
        trans1_closing_direction,
        trans1_blocking_position,
        trans1_travel_lower_limit_on,
        trans1_travel_upper_limit_on,
        trans1_final_value_cutoff_lo_on,
        trans1_final_value_cutoff_hi_on,
        trans1_transducer_state,
        trans1_charact_type,
        trans1_supply_pressure,
	    trans1_pressure_range_start,
	    trans1_pressure_range_end,
	    trans1_actuator_size,
	    trans1_manufac_actuator_size,
	    trans1_attachment,
	    trans1_booster,
        trans1_actuator_version,
/* in 1.43 nicht untersttzt        trans1_signal_pressure_action,*/
        trans1_pressure_limit,
        trans1_set_fail_safe_pos,
        trans1_final_value_range_start,
        trans1_final_value_range_end,
        trans1_final_value_range_units,
        trans1_tolerance_band,
        trans1_delay_time,
        trans1_status_solenoid_valve,
        trans1_final_position_value__value,
        trans1_final_position_value__quality,
        trans1_final_position_value__limit,
        trans1_diag_testinfo,
        trans1_autostart_hyst,
        trans1_stat_kenn_start,
        trans1_stat_kenn_ende,
        trans1_stat_kenn_warte,
        trans1_stat_kenn_anzahl,
        trans1_stat_kenn_sprunghoehe,
        trans1_stat_kenn_min_tot,
        trans1_stat_kenn_durch_tot,
        trans1_stat_kenn_max_tot,
        trans1_Stepstart,
		trans1_Stepend,
		trans1_Step_Sample_Rate,
		trans1_Latency_After_Step,
		trans1_Step_Selection,
       	trans1_Overshoot_Rising,
		trans1_Overshoot_Falling,
		trans1_Dead_Time_Rising,
		trans1_Dead_Time_Falling,
		trans1_Time_63_Rising,
		trans1_Time_63_Falling,
		trans1_Time_98_Rising,
		trans1_Time_98_Falling,
		trans1_Step_Progress,
		trans1_Rise_Time_Falling,
		trans1_Settling_Time_Falling,
		trans1_Rise_Time_Rising,
		trans1_Settling_Time_Rising,
		trans1_Duration_of_test,
        trans1_X0,
        trans1_Y0,
        trans1_X1,
        trans1_Y1,
        trans1_X2,
        trans1_Y2,
        trans1_X3,
        trans1_Y3,
        trans1_X4,
        trans1_Y4,
        trans1_X5,
        trans1_Y5,
        trans1_X6,
        trans1_Y6,
        trans1_X7,
        trans1_Y7,
        trans1_X8,
        trans1_Y8,
        trans1_X9,
        trans1_Y9,
        trans1_X10,
        trans1_Y10,

        /* Diagnosis */
        trans1_diag_level,
        trans1_datalogger_select,
	    trans1_datalogger_trigger_select,
	    trans1_datalogger_sample_rate,
	    trans1_datalogger_start_value,
	    trans1_datalogger_logging_limit,
	    trans1_datalogger_pretrigger_time,
	    trans1_datalogger_max_pretrig,
	    trans1_X_Interval_Value_0,
		trans1_X_Interval_Value_1,
		trans1_X_Interval_Value_2,
		trans1_X_Interval_Value_3,
		trans1_X_Interval_Value_4,
		trans1_X_Interval_Value_5,
		trans1_X_Interval_Value_6,
		trans1_X_Interval_Value_7,
		trans1_X_Interval_Value_8,
		trans1_X_Interval_Value_9,
		trans1_X_Interval_Value_10,
		trans1_X_Interval_Value_11,
		trans1_X_Interval_Value_12,
		trans1_X_Interval_Value_13,
		trans1_X_Interval_Value_14,
		trans1_X_Interval_Value_15,
		trans1_X_Interval_Value_16,
		trans1_X_Interval_Value_17,
		trans1_X_Interval_Value_18,
		trans1_X_Interval_Value_19,
		trans1_X_Interval_Value_20,
		trans1_X_Interval_Value_21,
		trans1_X_Average,
		trans1_Number_Mess_Points,
		trans1_E_Interval_Value_0,
        trans1_E_Interval_Value_1,
		trans1_E_Interval_Value_2,
		trans1_E_Interval_Value_3,
		trans1_E_Interval_Value_4,
		trans1_E_Interval_Value_5,
		trans1_E_Interval_Value_6,
		trans1_E_Interval_Value_7,
		trans1_E_Interval_Value_8,
		trans1_E_Interval_Value_9,
		trans1_E_Interval_Value_10,
		trans1_E_Interval_Value_11,
		trans1_E_Average,
		trans1_Total_Number_E,
        trans1_deviation_min,
		trans1_deviation_max,
		trans1_Z_Interval_Value_0,
        trans1_Z_Interval_Value_1,
		trans1_Z_Interval_Value_2,
		trans1_Z_Interval_Value_3,
		trans1_Z_Interval_Value_4,
		trans1_Z_Interval_Value_5,
		trans1_Z_Interval_Value_6,
		trans1_Z_Interval_Value_7,
		trans1_Z_Interval_Value_8,
		trans1_Z_Interval_Value_9,
		trans1_Z_Interval_Value_10,
		trans1_Z_Interval_Value_11,
		trans1_Z_Interval_Value_12,
		trans1_Z_Average,
		trans1_Total_Number_Z,
		trans1_Dynamic_Factor,
		trans1_Current_Temp,
		trans1_Max_Temp,
		trans1_Time_Max_Temp,
		trans1_Min_Temp,
		trans1_Time_Min_Temp,
		trans1_Period_Time_High,
		trans1_Period_Time_Low,
		trans1_Message_0,
		trans1_Elapsed_Hours_Meters_0,
		trans1_Message_1,
		trans1_Elapsed_Hours_Meters_1,
		trans1_Message_2,
		trans1_Elapsed_Hours_Meters_2,
		trans1_Message_3,
		trans1_Elapsed_Hours_Meters_3,
		trans1_Message_4,
		trans1_Elapsed_Hours_Meters_4,
		trans1_Message_5,
		trans1_Elapsed_Hours_Meters_5,
		trans1_Message_6,
		trans1_Elapsed_Hours_Meters_6,
		trans1_Message_7,
		trans1_Elapsed_Hours_Meters_7,
		trans1_Message_8,
		trans1_Elapsed_Hours_Meters_8,
		trans1_Message_9,
		trans1_Elapsed_Hours_Meters_9,
		trans1_Message_10,
		trans1_Elapsed_Hours_Meters_10,
		trans1_Message_11,
		trans1_Elapsed_Hours_Meters_11,
		trans1_Message_12,
		trans1_Elapsed_Hours_Meters_12,
		trans1_Message_13,
		trans1_Elapsed_Hours_Meters_13,
		trans1_Message_14,
		trans1_Elapsed_Hours_Meters_14,
		trans1_Message_15,
		trans1_Elapsed_Hours_Meters_15,
		trans1_Message_16,
		trans1_Elapsed_Hours_Meters_16,
		trans1_Message_17,
		trans1_Elapsed_Hours_Meters_17,
		trans1_Message_18,
		trans1_Elapsed_Hours_Meters_18,
		trans1_Message_19,
		trans1_Elapsed_Hours_Meters_19,
		trans1_Message_20,
		trans1_Elapsed_Hours_Meters_20,
		trans1_Message_21,
		trans1_Elapsed_Hours_Meters_21,
		trans1_Message_22,
		trans1_Elapsed_Hours_Meters_22,
		trans1_Message_23,
		trans1_Elapsed_Hours_Meters_23,
		trans1_Message_24,
		trans1_Elapsed_Hours_Meters_24,
		trans1_Message_25,
		trans1_Elapsed_Hours_Meters_25,
		trans1_Message_26,
		trans1_Elapsed_Hours_Meters_26,
		trans1_Message_27,
		trans1_Elapsed_Hours_Meters_27,
		trans1_Message_28,
		trans1_Elapsed_Hours_Meters_28,
		trans1_Message_29,
		trans1_Elapsed_Hours_Meters_29,
//		trans1_enhanced_diag_cmd,
		trans1_Elapsed_Hours_Meters,
 	    trans1_Device_In_Closed_Loop,
	    trans1_Power_On_Since_Init,
	    trans1_Device_In_Closed_Loop_Since_Last_Init,
	    trans1_no_of_zero_point_adj,
	    trans1_zero_point_limit,
	    trans1_counter_init_start,
        trans1_X_Interval_Value_0_KURZ,
		trans1_X_Interval_Value_1_KURZ,
		trans1_X_Interval_Value_2_KURZ,
		trans1_X_Interval_Value_3_KURZ,
		trans1_X_Interval_Value_4_KURZ,
		trans1_X_Interval_Value_5_KURZ,
		trans1_X_Interval_Value_6_KURZ,
		trans1_X_Interval_Value_7_KURZ,
		trans1_X_Interval_Value_8_KURZ,
		trans1_X_Interval_Value_9_KURZ,
		trans1_X_Interval_Value_10_KURZ,
		trans1_X_Interval_Value_11_KURZ,
		trans1_X_Interval_Value_12_KURZ,
		trans1_X_Interval_Value_13_KURZ,
		trans1_X_Interval_Value_14_KURZ,
		trans1_X_Interval_Value_15_KURZ,
		trans1_X_Interval_Value_16_KURZ,
		trans1_X_Interval_Value_17_KURZ,
		trans1_X_Interval_Value_18_KURZ,
		trans1_X_Interval_Value_19_KURZ,
		trans1_X_Interval_Value_20_KURZ,
		trans1_X_Interval_Value_21_KURZ,
		trans1_X_Average_KURZ,
		trans1_E_Interval_Value_0_KURZ,
        trans1_E_Interval_Value_1_KURZ,
		trans1_E_Interval_Value_2_KURZ,
		trans1_E_Interval_Value_3_KURZ,
		trans1_E_Interval_Value_4_KURZ,
		trans1_E_Interval_Value_5_KURZ,
		trans1_E_Interval_Value_6_KURZ,
		trans1_E_Interval_Value_7_KURZ,
		trans1_E_Interval_Value_8_KURZ,
		trans1_E_Interval_Value_9_KURZ,
		trans1_E_Interval_Value_10_KURZ,
		trans1_E_Interval_Value_11_KURZ,
		trans1_E_Average_KURZ,
		trans1_Z_Interval_Value_0_KURZ,
        trans1_Z_Interval_Value_1_KURZ,
		trans1_Z_Interval_Value_2_KURZ,
		trans1_Z_Interval_Value_3_KURZ,
		trans1_Z_Interval_Value_4_KURZ,
		trans1_Z_Interval_Value_5_KURZ,
		trans1_Z_Interval_Value_6_KURZ,
		trans1_Z_Interval_Value_7_KURZ,
		trans1_Z_Interval_Value_8_KURZ,
		trans1_Z_Interval_Value_9_KURZ,
		trans1_Z_Interval_Value_10_KURZ,
		trans1_Z_Interval_Value_11_KURZ,
		trans1_Z_Interval_Value_12_KURZ,
		trans1_Z_Average_KURZ,
		trans1_X_HIS_ABTASTRATE,
		trans1_E_HIS_ABTASTRATE,
  		trans1_stationaer_lang_Value_0,
        trans1_stationaer_lang_Value_1,
        trans1_stationaer_lang_Value_2,
        trans1_stationaer_lang_Value_3,
        trans1_stationaer_lang_Value_4,
        trans1_stationaer_lang_Value_5,
        trans1_stationaer_lang_Value_6,
        trans1_stationaer_lang_Value_7,
        trans1_stationaer_lang_Value_8,
        trans1_stationaer_lang_Value_9,
        trans1_stationaer_lang_Value_10,
        trans1_stationaer_lang_Value_11,
        trans1_stationaer_lang_Value_12,
        trans1_stationaer_lang_Value_13,
        trans1_stationaer_lang_Value_14,
        trans1_stationaer_lang_Value_15,
        trans1_stationaer_lang_Value_16,
        trans1_stationaer_lang_Value_17,
        trans1_stationaer_lang_Value_18,
        trans1_stationaer_lang_Value_19,
        trans1_stationaer_lang_Value_20,
        trans1_stationaer_lang_Value_21,
        trans1_stationaer_kurz_Value_0,
        trans1_stationaer_kurz_Value_1,
        trans1_stationaer_kurz_Value_2,
        trans1_stationaer_kurz_Value_3,
        trans1_stationaer_kurz_Value_4,
        trans1_stationaer_kurz_Value_5,
        trans1_stationaer_kurz_Value_6,
        trans1_stationaer_kurz_Value_7,
        trans1_stationaer_kurz_Value_8,
        trans1_stationaer_kurz_Value_9,
        trans1_stationaer_kurz_Value_10,
        trans1_stationaer_kurz_Value_11,
        trans1_stationaer_kurz_Value_12,
        trans1_stationaer_kurz_Value_13,
        trans1_stationaer_kurz_Value_14,
        trans1_stationaer_kurz_Value_15,
        trans1_stationaer_kurz_Value_16,
        trans1_stationaer_kurz_Value_17,
        trans1_stationaer_kurz_Value_18,
        trans1_stationaer_kurz_Value_19,
        trans1_stationaer_kurz_Value_20,
        trans1_stationaer_kurz_Value_21,
        trans1_stat_stellsignal_Value_0,
        trans1_stat_ventilstellung_Value_0,
        trans1_stat_stellsignal_Value_1,
        trans1_stat_ventilstellung_Value_1,
        trans1_stat_stellsignal_Value_2,
        trans1_stat_ventilstellung_Value_2,
        trans1_stat_stellsignal_Value_3,
        trans1_stat_ventilstellung_Value_3,
        trans1_stat_stellsignal_Value_4,
        trans1_stat_ventilstellung_Value_4,
        trans1_stat_stellsignal_Value_5,
        trans1_stat_ventilstellung_Value_5,
        trans1_stat_stellsignal_Value_6,
        trans1_stat_ventilstellung_Value_6,
        trans1_stat_stellsignal_Value_7,
        trans1_stat_ventilstellung_Value_7,
        trans1_stat_stellsignal_Value_8,
        trans1_stat_ventilstellung_Value_8,
        trans1_stat_stellsignal_Value_9,
        trans1_stat_ventilstellung_Value_9,
        trans1_hysterese_lang_Value_0,
        trans1_hysterese_lang_Value_1,
        trans1_hysterese_lang_Value_2,
        trans1_hysterese_lang_Value_3,
        trans1_hysterese_lang_Value_4,
        trans1_hysterese_lang_Value_5,
        trans1_hysterese_lang_Value_6,
        trans1_hysterese_lang_Value_7,
        trans1_hysterese_lang_Value_8,
        trans1_hysterese_lang_Value_9,
        trans1_hysterese_lang_Value_10,
        trans1_hysterese_lang_Value_11,
        trans1_hysterese_lang_Value_12,
        trans1_hysterese_lang_Value_13,
        trans1_hysterese_lang_Value_14,
        trans1_hysterese_lang_Value_15,
        trans1_hysterese_lang_Value_16,
        trans1_hysterese_lang_Value_17,
        trans1_hysterese_lang_Value_18,
        trans1_hys_stellsignal_Value_0,
        trans1_hys_ventilstellung_Value_0,
        trans1_hys_stellsignal_Value_1,
        trans1_hys_ventilstellung_Value_1,
        trans1_hys_stellsignal_Value_2,
        trans1_hys_ventilstellung_Value_2,
        trans1_hys_stellsignal_Value_3,
        trans1_hys_ventilstellung_Value_3,
        trans1_hys_stellsignal_Value_4,
        trans1_hys_ventilstellung_Value_4,
        trans1_hys_stellsignal_Value_5,
        trans1_hys_ventilstellung_Value_5,
        trans1_hys_stellsignal_Value_6,
        trans1_hys_ventilstellung_Value_6,
        trans1_hys_stellsignal_Value_7,
        trans1_hys_ventilstellung_Value_7,
        trans1_hys_stellsignal_Value_8,
        trans1_hys_ventilstellung_Value_8,
        trans1_hys_stellsignal_Value_9,
        trans1_hys_ventilstellung_Value_9,
        trans1_et_ventil_Value_0,
        trans1_et_ventil_Value_1,
        trans1_et_ventil_Value_2,
        trans1_et_ventil_Value_3,
        trans1_et_ventil_Value_4,
        trans1_et_ventil_Value_5,
        trans1_et_ventil_Value_6,
        trans1_et_ventil_Value_7,
        trans1_et_ventil_Value_8,
        trans1_et_ventil_Value_9,
        trans1_et_ventil_Value_10,
        trans1_et_ventil_Value_11,
        trans1_et_ventil_Value_12,
        trans1_et_ventil_Value_13,
        trans1_et_ventil_Value_14,
        trans1_et_ventil_Value_15,
        trans1_et_ventil_Value_16,
        trans1_et_ventil_Value_17,
        trans1_et_ventil_Value_18,
        trans1_et_ventil_Value_19,
        trans1_et_ventil_Value_20,
        trans1_et_ventil_Value_21,
        trans1_et_ventil_Value_22,
        trans1_et_ventil_Value_23,
        trans1_et_ventil_Value_24,
        trans1_et_ventil_Value_25,
        trans1_et_ventil_Value_26,
        trans1_et_ventil_Value_27,
        trans1_et_ventil_Value_28,
        trans1_et_ventil_Value_29,
        trans1_et_ventil_refwert,
        trans1_et_BSZ_Value_0,
        trans1_et_BSZ_Value_1,
        trans1_et_BSZ_Value_2,
        trans1_et_BSZ_Value_3,
        trans1_et_BSZ_Value_4,
        trans1_et_BSZ_Value_5,
        trans1_et_BSZ_Value_6,
        trans1_et_BSZ_Value_7,
        trans1_et_BSZ_Value_8,
        trans1_et_BSZ_Value_9,
        trans1_et_BSZ_Value_10,
        trans1_et_BSZ_Value_11,
        trans1_et_BSZ_Value_12,
        trans1_et_BSZ_Value_13,
        trans1_et_BSZ_Value_14,
        trans1_et_BSZ_Value_15,
        trans1_et_BSZ_Value_16,
        trans1_et_BSZ_Value_17,
        trans1_et_BSZ_Value_18,
        trans1_et_BSZ_Value_19,
        trans1_et_BSZ_Value_20,
        trans1_et_BSZ_Value_21,
        trans1_et_BSZ_Value_22,
        trans1_et_BSZ_Value_23,
        trans1_et_BSZ_Value_24,
        trans1_et_BSZ_Value_25,
        trans1_et_BSZ_Value_26,
        trans1_et_BSZ_Value_27,
        trans1_et_BSZ_Value_28,
        trans1_et_BSZ_Value_29,
        trans1_et_BSZ_refwert,
        trans1_et_endlage_Value_0,
        trans1_et_endlage_Value_1,
        trans1_et_endlage_Value_2,
        trans1_et_endlage_Value_3,
        trans1_et_endlage_Value_4,
        trans1_et_endlage_Value_5,
        trans1_et_endlage_Value_6,
        trans1_et_endlage_Value_7,
        trans1_et_endlage_Value_8,
        trans1_et_endlage_Value_9,
        trans1_et_endlage_Value_10,
        trans1_et_endlage_Value_11,
        trans1_et_endlage_Value_12,
        trans1_et_endlage_Value_13,
        trans1_et_endlage_Value_14,
        trans1_et_endlage_Value_15,
        trans1_et_endlage_Value_16,
        trans1_et_endlage_Value_17,
        trans1_et_endlage_Value_18,
        trans1_et_endlage_Value_19,
        trans1_et_endlage_Value_20,
        trans1_et_endlage_Value_21,
        trans1_et_endlage_Value_22,
        trans1_et_endlage_Value_23,
        trans1_et_endlage_Value_24,
        trans1_et_endlage_Value_25,
        trans1_et_endlage_Value_26,
        trans1_et_endlage_Value_27,
        trans1_et_endlage_Value_28,
        trans1_et_endlage_Value_29,
        trans1_et_endlage_refwert,
        trans1_stat_ref_vs_0,
        trans1_stat_ref_vs_1,
        trans1_stat_ref_vs_2,
        trans1_stat_ref_vs_3,
        trans1_stat_ref_vs_4,
        trans1_stat_ref_vs_5,
        trans1_stat_ref_vs_6,
        trans1_stat_ref_vs_7,
        trans1_stat_ref_vs_8,
        trans1_stat_ref_vs_9,
        trans1_stat_ref_vs_10,
        trans1_stat_ref_vs_11,
        trans1_stat_ref_vs_12,
        trans1_stat_ref_vs_13,
        trans1_stat_ref_vs_14,
        trans1_stat_ref_vs_15,
        trans1_stat_ref_vs_16,
        trans1_stat_ref_vs_17,
        trans1_stat_ref_vs_18,
        trans1_stat_ref_vs_19,
        trans1_stat_ref_vs_20,
        trans1_stat_ref_vs_21,
        trans1_stat_ref_vs_22,
        trans1_stat_ref_vs_23,
        trans1_stat_ref_vs_24,
        trans1_stat_again_vs_0,
        trans1_stat_again_vs_1,
        trans1_stat_again_vs_2,
        trans1_stat_again_vs_3,
        trans1_stat_again_vs_4,
        trans1_stat_again_vs_5,
        trans1_stat_again_vs_6,
        trans1_stat_again_vs_7,
        trans1_stat_again_vs_8,
        trans1_stat_again_vs_9,
        trans1_stat_again_vs_10,
        trans1_stat_again_vs_11,
        trans1_stat_again_vs_12,
        trans1_stat_again_vs_13,
        trans1_stat_again_vs_14,
        trans1_stat_again_vs_15,
        trans1_stat_again_vs_16,
        trans1_stat_again_vs_17,
        trans1_stat_again_vs_18,
        trans1_stat_again_vs_19,
        trans1_stat_again_vs_20,
        trans1_stat_again_vs_21,
        trans1_stat_again_vs_22,
        trans1_stat_again_vs_23,
        trans1_stat_again_vs_24,
        trans1_stat_ss_refzeit,
        trans1_stat_ss_testinfo,
        trans1_stat_ss_progress,
        trans1_stat_ref_ss_0,
        trans1_stat_again_ss_0,
        trans1_stat_ref_ss_1,
        trans1_stat_again_ss_1,
        trans1_stat_ref_ss_2,
        trans1_stat_again_ss_2,
        trans1_stat_ref_ss_3,
        trans1_stat_again_ss_3,
        trans1_stat_ref_ss_4,
        trans1_stat_again_ss_4,
        trans1_stat_ref_ss_5,
        trans1_stat_again_ss_5,
        trans1_stat_ref_ss_6,
        trans1_stat_again_ss_6,
        trans1_stat_ref_ss_7,
        trans1_stat_again_ss_7,
        trans1_stat_ref_ss_8,
        trans1_stat_again_ss_8,
        trans1_stat_ref_ss_9,
        trans1_stat_again_ss_9,
        trans1_stat_ref_ss_10,
        trans1_stat_again_ss_10,
        trans1_stat_ref_ss_11,
        trans1_stat_again_ss_11,
        trans1_stat_ref_ss_12,
        trans1_stat_again_ss_12,
        trans1_stat_ref_ss_13,
        trans1_stat_again_ss_13,
        trans1_stat_ref_ss_14,
        trans1_stat_again_ss_14,
        trans1_stat_ref_ss_15,
        trans1_stat_again_ss_15,
        trans1_stat_ref_ss_16,
        trans1_stat_again_ss_16,
        trans1_stat_ref_ss_17,
        trans1_stat_again_ss_17,
        trans1_stat_ref_ss_18,
        trans1_stat_again_ss_18,
        trans1_stat_ref_ss_19,
        trans1_stat_again_ss_19,
        trans1_stat_ref_ss_20,
        trans1_stat_again_ss_20,
        trans1_stat_ref_ss_21,
        trans1_stat_again_ss_21,
        trans1_stat_ref_ss_22,
        trans1_stat_again_ss_22,
        trans1_stat_ref_ss_23,
        trans1_stat_again_ss_23,
        trans1_stat_ref_ss_24,
        trans1_stat_again_ss_24,
        trans1_hys_ss_refzeit,
        trans1_hys_ss_testinfo,
        trans1_hys_ss_progress,
        trans1_hys_ref_vs_0,
        trans1_hys_ref_hys_0,
        trans1_hys_again_hys_0,
        trans1_hys_ref_vs_1,
        trans1_hys_ref_hys_1,
        trans1_hys_again_hys_1,
        trans1_hys_ref_vs_2,
        trans1_hys_ref_hys_2,
        trans1_hys_again_hys_2,
        trans1_hys_ref_vs_3,
        trans1_hys_ref_hys_3,
        trans1_hys_again_hys_3,
        trans1_hys_ref_vs_4,
        trans1_hys_ref_hys_4,
        trans1_hys_again_hys_4,
        trans1_hys_ref_vs_5,
        trans1_hys_ref_hys_5,
        trans1_hys_again_hys_5,
        trans1_hys_ref_vs_6,
        trans1_hys_ref_hys_6,
        trans1_hys_again_hys_6,
        trans1_hys_ref_vs_7,
        trans1_hys_ref_hys_7,
        trans1_hys_again_hys_7,
        trans1_hys_ref_vs_8,
        trans1_hys_ref_hys_8,
        trans1_hys_again_hys_8,
        trans1_hys_ref_vs_9,
        trans1_hys_ref_hys_9,
        trans1_hys_again_hys_9,
        trans1_hys_ref_vs_10,
        trans1_hys_ref_hys_10,
        trans1_hys_again_hys_10,
        trans1_hys_ref_vs_11,
        trans1_hys_ref_hys_11,
        trans1_hys_again_hys_11,

        func1_tag_desc,
        func1_batch_id,
        func1_batch_unit,
        func1_batch_operation,
        func1_batch_phase,
        func1_setpoint_value,
        func1_setpoint_status,
        func1_pv_upper_range_value,
        func1_pv_lower_range_value,
        func1_pv_unit,
        func1_in_channel,
        func1_out_channel,
        func1_fsafe_time,
        func1_fsafe_type,
        func1_fsafe_value,
        func1_increase_close,
        func1_out_upper_range_value,
        func1_out_lower_range_value,
        func1_out_unit,
        func1_simulate_enabled,
        func1_simulate_value,
        func1_simulate_status_quality,
        func1_simulate_status_limit,
        func1_check_back_opt,
        trans2_tag_desc,
        trans2_st_rev,
        trans2_strategy,
        trans2_alert_key,
        trans2_sensor_id,
        trans2_sensor_ser_num,
        trans2_sensor_man,
/*        func2_tag_desc,*/
        func2_DI_batch_id,
        func2_DI_batch_unit,
        func2_DI_batch_operation,
        func2_DI_batch_phase,
        func2_DI_channel,
        func2_DI_invert,
        func2_DI_fsafe_type,
        func2_DI_fsafe_value,
        func2_DI_simulate_status_quality,
		func2_DI_simulate_status_limit,
		func2_DI_simulate_value,
		func2_DI_simulation_enabled,
		func2_DI_tag_desc,
		func2_DI_st_rev,
		func2_DI_strategy,
		func2_DI_alert_key,
		trans3_tag_desc,
        trans3_sensor_id,
        trans3_sensor_ser_num,
        trans3_sensor_man,
        trans3_st_rev,
        trans3_strategy,
        trans3_alert_key,
/*        func3_tag_desc,*/
        func3_DI_batch_id,
        func3_DI_batch_unit,
        func3_DI_batch_operation,
        func3_DI_batch_phase,
        func3_DI_channel,
        func3_DI_invert,
        func3_DI_fsafe_type,
        func3_DI_fsafe_value,
        func3_DI_simulate_status_quality,
		func3_DI_simulate_status_limit,
		func3_DI_simulate_value,
	    func3_DI_simulation_enabled,
	    func3_DI_tag_desc,
	    func3_DI_st_rev,
	    func3_DI_strategy,
	    func3_DI_alert_key

      }
      ELSE
      {

        /* ------------------------------------------------------------------------ */
        /* Lesen aus einem EXPERT Geraet */
        /* ------------------------------------------------------------------------ */
        phys_condensed_state,
        phys_st_rev,
        func1_st_rev,
        trans1_st_rev,
        func1_strategy,
        trans1_strategy,
        func1_alert_key,
        trans1_alert_key,
        phys_strategy,
        trans1_diag_level,
        phys_st_rev,
        phys_tag_desc,
        phys_software_rev,
        phys_hardware_rev,
        phys_production_id,
        phys_feature_select,
        phys_strategy,
        phys_alert_key,
        phys_device_product_num,
#ifdef _V602_
        phys_device_man_id,
#endif
        phys_device_id,
        phys_serial_num,
        phys_device_certification,
        phys_write_locking,
        phys_descriptor,
        phys_device_message,
        phys_device_instal_date,
        phys_local_operation_enable,
        phys_ident_number_selector,
        phys_hw_write_protection,
   			phys_feature_supported,
        phys_feature_enabled,
        phys_cond_status_diag,
/*        phys_diag_event_switch__Diag_Status_Link_1_0_S,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_0_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_1_S,
        phys_diag_event_switch__Diag_Status_Link_1_1_D,
        phys_diag_event_switch__Diag_Status_Link_1_2_S,
        phys_diag_event_switch__Diag_Status_Link_1_2_D,
        phys_diag_event_switch__Diag_Status_Link_1_3_S,
        phys_diag_event_switch__Diag_Status_Link_1_3_D,
        phys_diag_event_switch__Diag_Status_Link_1_4_S,
        phys_diag_event_switch__Diag_Status_Link_1_4_D,
        phys_diag_event_switch__Diag_Status_Link_1_5_S,
        phys_diag_event_switch__Diag_Status_Link_1_5_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_6_S,
        phys_diag_event_switch__Diag_Status_Link_1_6_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_7_S,
        phys_diag_event_switch__Diag_Status_Link_1_7_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_8_S,
        phys_diag_event_switch__Diag_Status_Link_1_8_D,
        phys_diag_event_switch__Diag_Status_Link_1_9_S,
        phys_diag_event_switch__Diag_Status_Link_1_9_D,
        phys_diag_event_switch__Diag_Status_Link_1_10_S,
        phys_diag_event_switch__Diag_Status_Link_1_10_D,
        phys_diag_event_switch__Diag_Status_Link_1_11_S,
        phys_diag_event_switch__Diag_Status_Link_1_11_D,
        phys_diag_event_switch__Diag_Status_Link_1_12_S,
        phys_diag_event_switch__Diag_Status_Link_1_12_D,
        phys_diag_event_switch__Diag_Status_Link_1_13_S,
        phys_diag_event_switch__Diag_Status_Link_1_13_D,
        phys_diag_event_switch__Diag_Status_Link_1_14_S,
        phys_diag_event_switch__Diag_Status_Link_1_14_D,
        phys_diag_event_switch__Diag_Status_Link_1_15_S,
        phys_diag_event_switch__Diag_Status_Link_1_15_D,
        phys_diag_event_switch__Diag_Status_Link_1_16_S,
        phys_diag_event_switch__Diag_Status_Link_1_16_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_17_S,
        phys_diag_event_switch__Diag_Status_Link_1_17_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_18_S,
        phys_diag_event_switch__Diag_Status_Link_1_18_D,*/
        phys_diag_event_switch__Diag_Status_Link_1_19_S,
        phys_diag_event_switch__Diag_Status_Link_1_19_D,
        phys_diag_event_switch__Diag_Status_Link_1_20_S,
        phys_diag_event_switch__Diag_Status_Link_1_20_D,
        phys_diag_event_switch__Diag_Status_Link_1_21_S,
        phys_diag_event_switch__Diag_Status_Link_1_21_D,
        phys_diag_event_switch__Diag_Status_Link_1_22_S,
        phys_diag_event_switch__Diag_Status_Link_1_22_D,
        phys_diag_event_switch__Diag_Status_Link_1_23_S,
        phys_diag_event_switch__Diag_Status_Link_1_23_D,
        phys_diag_event_switch__Diag_Status_Link_1_24_S,
        phys_diag_event_switch__Diag_Status_Link_1_24_D,
        phys_diag_event_switch__Diag_Status_Link_1_25_S,
        phys_diag_event_switch__Diag_Status_Link_1_25_D,
        phys_diag_event_switch__Diag_Status_Link_1_26_S,
        phys_diag_event_switch__Diag_Status_Link_1_26_D,
        phys_diag_event_switch__Diag_Status_Link_1_27_S,
        phys_diag_event_switch__Diag_Status_Link_1_27_D,
/*        phys_diag_event_switch__Diag_Status_Link_1_28_S,
        phys_diag_event_switch__Diag_Status_Link_1_28_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_29_S,
        phys_diag_event_switch__Diag_Status_Link_1_29_D,*/
/*        phys_diag_event_switch__Diag_Status_Link_1_30_S,
        phys_diag_event_switch__Diag_Status_Link_1_30_D,
        phys_diag_event_switch__Diag_Status_Link_1_31_S,
        phys_diag_event_switch__Diag_Status_Link_1_31_D,
        phys_diag_event_switch__Diag_Status_Link_1_32_S,
        phys_diag_event_switch__Diag_Status_Link_1_32_D,
        phys_diag_event_switch__Diag_Status_Link_1_33_S,
        phys_diag_event_switch__Diag_Status_Link_1_33_D,
        phys_diag_event_switch__Diag_Status_Link_1_48_S,
        phys_diag_event_switch__Diag_Status_Link_1_48_D,*/
        phys_ident_options,
        phys_ident_limit_switches,
        /* phys_device_product_num, */
        phys_text_input_1,
        phys_text_input_2,
        phys_text_input_3,
        phys_text_input_4,
        phys_text_input_5,
        phys_reading_direction,
        phys_config_binary_input_2,
/*        phys_diagnosis_ext_2_01,
        phys_diagnosis_ext_2_23,
        phys_diagnosis_ext_2_45,*/
        phys_diag_event_switch_2__Diag_Status_Link_2_35_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_35_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_36_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_36_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_38_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_38_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_39_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_39_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_41_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_41_D,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_S,
        phys_diag_event_switch_2__Diag_Status_Link_2_42_D,
/*        phys_diagnosis_ext_1_raw_01,
        phys_diagnosis_ext_1_raw_23,
        phys_diagnosis_ext_1_raw_45,
        phys_diagnosis_ext_2_raw_01,
        phys_diagnosis_ext_2_raw_23,
        phys_diagnosis_ext_2_raw_45,*/
        phys_device_dp_status,
/*        phys_diag_ext_1_0,
        phys_diag_ext_1_1,
        phys_diag_ext_1_2, */
        phys_diag_ext_1_3,
        phys_diag_operation,
        phys_diag_init_1,
        phys_diag_init_2,
        phys_diag_hw,
        phys_diag_data_1,
/*        phys_diag_data_2,*/
        phys_diagnosis_ext_1_raw_0,
        phys_diagnosis_ext_1_raw_1,
        phys_diagnosis_ext_1_raw_2,
        phys_diagnosis_ext_1_raw_3,
        trans1_tag_desc,
        trans1_act_stroke_time_dec,
        trans1_act_stroke_time_inc,
        trans1_device_calib_date,
        trans1_device_config_date,
        /* erst Stiftposition, dann Nennbereich einlesen */
        trans1_transm_pin_pos,
        trans1_lin_type,
        trans1_rated_travel,
        trans1_servo_gain_1,
        trans1_servo_rate_1,
        trans1_setp_cutoff_dec,
        trans1_total_valve_travel,
        trans1_setp_cutoff_inc,
        trans1_total_valve_travel_limit,
        trans1_travel_limit_lower_value,
        trans1_travel_limit_upper_value,
        trans1_travel_rate_dec,
        trans1_travel_rate_inc,
        trans1_valve_maintenance_date,
        trans1_valve_man,
        trans1_actuator_man,
        trans1_valve_type,
        trans1_stuffing_box,
        trans1_sealing_edge,
        trans1_pressure_balancing,
        trans1_flow_characteristic,
        trans1_flow_direction,
        trans1_nom_diameter,
        trans1_nom_diameter_dn,
        trans1_kvs_unit,
        trans1_kvs_value,
        trans1_seat_diam_valve,
        trans1_actuator_type,
        trans1_actuator_action,
        trans1_valve_serial_number,
        trans1_actuator_serial_number,
        trans1_additional_gear_ser_number,
        trans1_additional_gear_man,
        trans1_additional_gear_id,
        trans1_additional_gear_install_date,
        trans1_init_method,
        trans1_sub_mode_init,
        trans1_device_init_state,
        trans1_moving_direction,
        trans1_closing_direction,
        trans1_blocking_position,
        trans1_travel_lower_limit_on,
        trans1_travel_upper_limit_on,
        trans1_final_value_cutoff_lo_on,
        trans1_final_value_cutoff_hi_on,
        trans1_transducer_state,
        trans1_charact_type,
        trans1_supply_pressure,
	    trans1_pressure_range_start,
	    trans1_pressure_range_end,
	    trans1_actuator_size,
	    trans1_manufac_actuator_size,
	    trans1_attachment,
	    trans1_booster,
        trans1_actuator_version,
/* in 1.43 nicht untersttzt        trans1_signal_pressure_action,*/
        trans1_pressure_limit,
        trans1_set_fail_safe_pos,
        trans1_final_value_range_start,
        trans1_final_value_range_end,
        trans1_final_value_range_units,
        trans1_tolerance_band,
        trans1_delay_time,
        trans1_status_solenoid_valve,
        trans1_final_position_value__value,
        trans1_final_position_value__quality,
        trans1_final_position_value__limit,
        trans1_diag_testinfo,
        trans1_X0,
        trans1_Y0,
        trans1_X1,
        trans1_Y1,
        trans1_X2,
        trans1_Y2,
        trans1_X3,
        trans1_Y3,
        trans1_X4,
        trans1_Y4,
        trans1_X5,
        trans1_Y5,
        trans1_X6,
        trans1_Y6,
        trans1_X7,
        trans1_Y7,
        trans1_X8,
        trans1_Y8,
        trans1_X9,
        trans1_Y9,
        trans1_X10,
        trans1_Y10,

        /* Diagnosis */
		trans1_Current_Temp,
		trans1_Max_Temp,
		trans1_Time_Max_Temp,
		trans1_Min_Temp,
		trans1_Time_Min_Temp,
		trans1_Period_Time_High,
		trans1_Period_Time_Low,
		trans1_Message_0,
		trans1_Elapsed_Hours_Meters_0,
		trans1_Message_1,
		trans1_Elapsed_Hours_Meters_1,
		trans1_Message_2,
		trans1_Elapsed_Hours_Meters_2,
		trans1_Message_3,
		trans1_Elapsed_Hours_Meters_3,
		trans1_Message_4,
		trans1_Elapsed_Hours_Meters_4,
		trans1_Message_5,
		trans1_Elapsed_Hours_Meters_5,
		trans1_Message_6,
		trans1_Elapsed_Hours_Meters_6,
		trans1_Message_7,
		trans1_Elapsed_Hours_Meters_7,
		trans1_Message_8,
		trans1_Elapsed_Hours_Meters_8,
		trans1_Message_9,
		trans1_Elapsed_Hours_Meters_9,
		trans1_Message_10,
		trans1_Elapsed_Hours_Meters_10,
		trans1_Message_11,
		trans1_Elapsed_Hours_Meters_11,
		trans1_Message_12,
		trans1_Elapsed_Hours_Meters_12,
		trans1_Message_13,
		trans1_Elapsed_Hours_Meters_13,
		trans1_Message_14,
		trans1_Elapsed_Hours_Meters_14,
		trans1_Message_15,
		trans1_Elapsed_Hours_Meters_15,
		trans1_Message_16,
		trans1_Elapsed_Hours_Meters_16,
		trans1_Message_17,
		trans1_Elapsed_Hours_Meters_17,
		trans1_Message_18,
		trans1_Elapsed_Hours_Meters_18,
		trans1_Message_19,
		trans1_Elapsed_Hours_Meters_19,
		trans1_Message_20,
		trans1_Elapsed_Hours_Meters_20,
		trans1_Message_21,
		trans1_Elapsed_Hours_Meters_21,
		trans1_Message_22,
		trans1_Elapsed_Hours_Meters_22,
		trans1_Message_23,
		trans1_Elapsed_Hours_Meters_23,
		trans1_Message_24,
		trans1_Elapsed_Hours_Meters_24,
		trans1_Message_25,
		trans1_Elapsed_Hours_Meters_25,
		trans1_Message_26,
		trans1_Elapsed_Hours_Meters_26,
		trans1_Message_27,
		trans1_Elapsed_Hours_Meters_27,
		trans1_Message_28,
		trans1_Elapsed_Hours_Meters_28,
		trans1_Message_29,
		trans1_Elapsed_Hours_Meters_29,
		trans1_Elapsed_Hours_Meters,
 	    trans1_Device_In_Closed_Loop,
	    trans1_Power_On_Since_Init,
	    trans1_Device_In_Closed_Loop_Since_Last_Init,
	    trans1_no_of_zero_point_adj,
	    trans1_zero_point_limit,
	    trans1_counter_init_start,

        func1_tag_desc,
        func1_batch_id,
        func1_batch_unit,
        func1_batch_operation,
        func1_batch_phase,
        func1_setpoint_value,
        func1_setpoint_status,
        func1_pv_upper_range_value,
        func1_pv_lower_range_value,
        func1_pv_unit,
        func1_in_channel,
        func1_out_channel,
        func1_fsafe_time,
        func1_fsafe_type,
        func1_fsafe_value,
        func1_increase_close,
        func1_out_upper_range_value,
        func1_out_lower_range_value,
        func1_out_unit,
        func1_simulate_enabled,
        func1_simulate_value,
        func1_simulate_status_quality,
        func1_simulate_status_limit,
        func1_check_back_opt,
        trans2_tag_desc,
        trans2_st_rev,
        trans2_strategy,
        trans2_alert_key,
        trans2_sensor_id,
        trans2_sensor_ser_num,
        trans2_sensor_man,
/*        func2_tag_desc,*/
        func2_DI_batch_id,
        func2_DI_batch_unit,
        func2_DI_batch_operation,
        func2_DI_batch_phase,
        func2_DI_channel,
        func2_DI_invert,
        func2_DI_fsafe_type,
        func2_DI_fsafe_value,
        func2_DI_simulate_status_quality,
		func2_DI_simulate_status_limit,
		func2_DI_simulate_value,
		func2_DI_simulation_enabled,
		func2_DI_tag_desc,
		func2_DI_st_rev,
		func2_DI_strategy,
		func2_DI_alert_key,
		trans3_tag_desc,
        trans3_sensor_id,
        trans3_sensor_ser_num,
        trans3_sensor_man,
        trans3_st_rev,
        trans3_strategy,
        trans3_alert_key,
/*        func3_tag_desc,*/
        func3_DI_batch_id,
        func3_DI_batch_unit,
        func3_DI_batch_operation,
        func3_DI_batch_phase,
        func3_DI_channel,
        func3_DI_invert,
        func3_DI_fsafe_type,
        func3_DI_fsafe_value,
        func3_DI_simulate_status_quality,
		func3_DI_simulate_status_limit,
		func3_DI_simulate_value,
	    func3_DI_simulation_enabled,
	    func3_DI_tag_desc,
	    func3_DI_st_rev,
	    func3_DI_strategy,
	    func3_DI_alert_key

	 }
   }
#ifdef _V602_
   PRE_READ_ACTIONS
   {
      read_diag_level;  /* erst Diagnoselevel auslesen, damit obige Abfrage geht */
   }
#endif
}

/* ------------------------------------------------------------------------ */
/* Diagnoselevel einlesen bevor komplettes Lesen aus dem Feldgeraet         */
/* ------------------------------------------------------------------------ */
METHOD read_diag_level
{
    LABEL "";
    DEFINITION
    {
		XMTR_IGNORE_ALL_COMM_STATUS();
		XMTR_IGNORE_ALL_DEVICE_STATUS();
		XMTR_IGNORE_ALL_RESPONSE_CODES();
		XMTR_IGNORE_COMM_ERROR();

		IGNORE_ALL_COMM_STATUS();
		IGNORE_ALL_DEVICE_STATUS();
		IGNORE_ALL_RESPONSE_CODES();
		IGNORE_COMM_ERROR();

        XMTR_RETRY_ON_NO_DEVICE();
        RETRY_ON_NO_DEVICE();

        ReadCommand (read_trans1_diag_level);    /* Diagnoselevel einlesen */
    }
}


/*-- ENDE der DD -------------------------------------------------------------*/

