/******************************************************************************/
/* Device Description for SAMSON Positioner TS 3793 HART capable              */
/******************************************************************************/
/* SAMSON AG - MESS- UND REGELTECHNIK                                         */
/* Weismüllerstraße 3 - 60314 Frankfurt am Main - Germany                     */
/* Phone: +49 69 4009-0 - Fax: +49 69 4009-1507                               */
/* E-mail: samson@samsongroup.com - Internet: www.samsongroup.com             */
/******************************************************************************/
/* Copyright (C): SAMSON AG (2019). All Rights Reserved                       */
/* Device:        SAMSON Positioner 3793 HART capable Dev Rev 2               */
/******************************************************************************/
/* Author: Thomas Krämer                                                      */
/* File:   SAHA_TS3793_r2d1.ddl                                               */
/******************************************************************************/
/* Date:      Author: Comments:                                               */
/* -----      ------- ---------                                               */
/* 08.10.2018 kmr/E36 EDD for Device Revision 2                               */
/*                                                                            */
/*                                                                            */
/******************************************************************************/

MANUFACTURER               66,   /* (66 = 42 hex) SAMSON AG, Frankfurt, Germany */
DEVICE_TYPE             17132,   /* Expanded device_type 0x42EC (0x42 = 66 + 0xEC = 236) Positioner TROVIS SAFE 3793 */
DEVICE_REVISION             2,   /* Device Revision 2 (FW 1.01.xx) */
DD_REVISION                 1    /* Device Description Revision 1 */

/* ------------------------------------------------------------------------ */
/* DD Versionsverwaltung:
   Hier die aktuelle DD Versionsnummer eintragen:
   Codierung:     [Dev Rev].[DD Rev].[fortlaufende Versionsnummer]          */
/* ------------------------------------------------------------------------ */
#define DD_REVISION_TEXT "|en|DD Revision: 2.1.001" "|de|DD Version: 2.1.001"
// #define DD_REVISION_TEXT "|en|DD Revision: 2.1.001-1 14.04.2020"
/* ------------------------------------------------------------------------ */

#include "macros.h"
#include "methods.h"

// PDM Diagnose:
#include "Diagnosis.inc"

/*****************************************
  Files to include:
*****************************************/
#include "42EC02_text_defines.dd"
#include "42EC02_defines.dd"
#include "42EC02_imports.dd"
#include "42EC02_dyn_var.dd"
#include "42EC02_methods.dd"

/* Parameter vom DD Generator: */
#include "42EC02_para_gen.dd"
/* Die DDGen Dateien mit den HART commands
   42EC02_cmd_read_gen.dd
   42EC02_cmd_write_gen.dd
   werden in 42EC02_hart_cmd.dd direkt in den commands includiert */

#include "42EC02_hart_cmd.dd"
#include "42EC02_graphs.dd"
#include "42EC02_pst.dd"
#include "42EC02_fst.dd"
#include "42EC02_valve_sig_graph.dd"
#include "42EC02_histogram.dd"
#include "42EC02_logger.dd"
#include "42EC02_fdi_online_menu.dd"
#include "42EC02_offline_menu.dd"

